/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.standard;

import com.alachisoft.ncache.serialization.core.io.ICompactSerializable;
import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.core.io.TypeSurrogateSelector;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheArgumentException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.DynamicSurrogateBuilder;
import com.alachisoft.ncache.serialization.standard.PackageResources;
import com.alachisoft.ncache.serialization.standard.io.TypeSurrogateSelectorImpl;
import com.alachisoft.ncache.serialization.standard.io.surrogates.EnumSerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.ExternalizableSerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.GenericArraySerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.InternalCompactSerializableSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.ThrowableSerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.VersionCompatibleInternalCompactSerializableSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.VersionCompatibleXExternalizableSerializationSurrogate;
import com.alachisoft.ncache.serialization.standard.io.surrogates.XExternalizableSerializationSurrogate;
import com.alachisoft.ncache.serialization.util.SerializationUtil;
import java.util.HashMap;
import java.util.Map;

public class FormatterServices {
    static HashMap _attributeOrder = new HashMap();
    private static FormatterServices msDefault;
    private TypeSurrogateSelector mSurrogateSelector;
    private String _cacheContext;

    public FormatterServices() {
        this.mSurrogateSelector = TypeSurrogateSelectorImpl.getDefault();
    }

    public FormatterServices(TypeSurrogateSelector selector) {
        if (selector == null) {
            throw new NullPointerException();
        }
        this.mSurrogateSelector = selector;
    }

    public static FormatterServices getDefault() {
        if (msDefault == null) {
            msDefault = new FormatterServices();
        }
        return msDefault;
    }

    public static HashMap getAttributeOrder() {
        return _attributeOrder;
    }

    public static void setAttributeOrder(HashMap attrib) {
        _attributeOrder = attrib;
    }

    public void SetCacheContext(String context) {
        this._cacheContext = context;
    }

    public TypeSurrogateSelector getSurrogateSelector() {
        return this.mSurrogateSelector;
    }

    public void setSurrogateSelector(TypeSurrogateSelector selector) {
        if (selector == null) {
            throw new NullPointerException();
        }
        this.mSurrogateSelector = selector;
    }

    public void registerKnownType(Class cls, short typeHandle, short subHandle, String cacheContext, boolean portable, HashMap nonCompactFieldsMap) throws NCacheArgumentException {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        if (this.mSurrogateSelector.getSurrogateForType(cls, true, cacheContext) != null) {
            throw new IllegalArgumentException(PackageResources.Surrogates_AlreadyRegistered);
        }
        SerializationSurrogate surrogate = null;
        try {
            surrogate = this.selectBestSurrogate(cls, portable, subHandle, nonCompactFieldsMap, false);
        }
        catch (Exception exception) {
            throw new NCacheArgumentException(exception.getMessage());
        }
        if (surrogate == null) {
            throw new IllegalArgumentException(PackageResources.Surrogates_NotFound);
        }
        this.mSurrogateSelector.register(surrogate, typeHandle, surrogate.getSubHandle(), cacheContext, portable);
    }

    public void register(Map type, HashMap attributeOrder, String cacheContext, HashMap portable) throws NCacheArgumentException {
        this._cacheContext = cacheContext;
        FormatterServices.setAttributeOrder(attributeOrder);
        for (Map.Entry pairs : type.entrySet()) {
            HashMap handleNonCompactFieldMap = (HashMap)pairs.getValue();
            Short typeHandle = (Short)handleNonCompactFieldMap.get("handle");
            HashMap nonCompactFieldsMap = (HashMap)handleNonCompactFieldMap.get("non-compact-fields");
            boolean isPortable = false;
            if (portable != null && portable.get(typeHandle) != null) {
                isPortable = (Boolean)portable.get(typeHandle);
            }
            short subHandle = 0;
            if (isPortable) {
                subHandle = SerializationUtil.GetSubTypeHandle(cacheContext, Short.toString(typeHandle), (Class)pairs.getKey());
            }
            this.registerKnownType((Class)pairs.getKey(), typeHandle, subHandle, cacheContext, isPortable, nonCompactFieldsMap);
        }
    }

    public void registerKnownType(Class cls) throws NCacheArgumentException {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        if (this.mSurrogateSelector.getSurrogateForType(cls, true, this._cacheContext) != null) {
            throw new IllegalArgumentException(PackageResources.Surrogates_AlreadyRegistered);
        }
        SerializationSurrogate surrogate = null;
        try {
            surrogate = this.selectBestSurrogate(cls, false, (short)0, null, false);
        }
        catch (Exception exception) {
            throw new NCacheArgumentException(exception.getMessage());
        }
        if (surrogate == null) {
            throw new IllegalArgumentException(PackageResources.Surrogates_NotFound);
        }
        this.mSurrogateSelector.register(surrogate);
    }

    public void registerKnownTypes(Class cls, short handle) throws NCacheArgumentException {
        this.registerKnownTypes(cls, handle, true);
    }

    public void registerNonVersionCompatibleCompactType(Class cls, short handle) throws NCacheArgumentException {
        this.registerKnownTypes(cls, handle, false);
    }

    private void registerKnownTypes(Class cls, short handle, boolean versionCompatible) throws NCacheArgumentException {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        if (this.mSurrogateSelector.getSurrogateForType(cls, true, this._cacheContext) != null) {
            SerializationSurrogate surrogate = this.mSurrogateSelector.getSurrogateForTypeHandle(handle, this._cacheContext);
            if (surrogate != null && surrogate.getRealClass().equals(cls)) {
                return;
            }
            throw new IllegalArgumentException(PackageResources.Surrogates_AlreadyRegistered);
        }
        SerializationSurrogate surrogate = null;
        try {
            surrogate = this.selectBestSurrogate(cls, false, (short)0, null, versionCompatible);
        }
        catch (Exception exception) {
            throw new NCacheArgumentException(exception.getMessage());
        }
        if (surrogate == null) {
            throw new IllegalArgumentException(PackageResources.Surrogates_NotFound);
        }
        this.mSurrogateSelector.register(surrogate, handle);
    }

    public void unregisterKnownType(Class cls, String cacheContext, boolean removeCache) {
        if (cls == null && !removeCache) {
            throw new NullPointerException("cls");
        }
        SerializationSurrogate surrogate = null;
        if (!removeCache) {
            surrogate = this.mSurrogateSelector.getSurrogateForType(cls, true, this._cacheContext);
        }
        this.mSurrogateSelector.unregister(surrogate, cacheContext, removeCache);
    }

    private SerializationSurrogate selectBestSurrogate(Class cls, boolean portable, short subHandle, HashMap nonCompactFieldsMap, boolean versionCompatible) throws Exception {
        SerializationSurrogate surrogate = null;
        surrogate = Throwable.class.isAssignableFrom(cls) ? new ThrowableSerializationSurrogate(cls) : (cls.isArray() ? new GenericArraySerializationSurrogate((Class<T[]>)cls) : (ICompactSerializable.class.isAssignableFrom(cls) ? (versionCompatible ? new VersionCompatibleXExternalizableSerializationSurrogate(cls) : new XExternalizableSerializationSurrogate(cls)) : (InternalCompactSerializable.class.isAssignableFrom(cls) ? (versionCompatible ? new VersionCompatibleInternalCompactSerializableSurrogate(cls) : new InternalCompactSerializableSurrogate(cls)) : (ICompactSerializable.class.isAssignableFrom(cls) ? new ExternalizableSerializationSurrogate(cls) : (Enum.class.isAssignableFrom(cls) ? new EnumSerializationSurrogate(cls) : DynamicSurrogateBuilder.createTypeSurrogate(this.mSurrogateSelector, cls, FormatterServices.getAttributeOrder(), this._cacheContext, portable, subHandle, nonCompactFieldsMap))))));
        return surrogate;
    }
}

