/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.core.io.surrogates;

import com.alachisoft.ncache.serialization.core.io.NCacheObjectOutput;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheIOException;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheInstantiationException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class SerializationSurrogateBase {
    private static Object[] mEmptyArgs = new Object[0];
    private short mTypeHandle;
    private short mSubTypeHandle = 0;
    private Class mActualType;
    private Constructor mConstructor;

    public SerializationSurrogateBase(Class type) {
        this.mActualType = type;
        try {
            this.mConstructor = type.getDeclaredConstructor(new Class[0]);
            this.mConstructor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Class getRealClass() {
        return this.mActualType;
    }

    public short getClassHandle() {
        return this.mTypeHandle;
    }

    public void setClassHandle(short value) {
        this.mTypeHandle = value;
    }

    public short getSubHandle() {
        return this.mSubTypeHandle;
    }

    public void setSubTypeHandle(short subHandle) {
        this.mSubTypeHandle = subHandle;
    }

    public boolean isVersionCompatible() {
        return false;
    }

    public Object createInstance() throws NCacheInstantiationException {
        try {
            if (this.mActualType.isInterface()) {
                return null;
            }
            if (this.mConstructor != null) {
                return this.mConstructor.newInstance(mEmptyArgs);
            }
            return this.newInstanceUsingEnclosingClasses(this.mActualType);
        }
        catch (Exception ex) {
            throw new NCacheInstantiationException(ex);
        }
    }

    private Object newInstanceUsingEnclosingClasses(Class type) throws NoSuchMethodException, IllegalAccessException, InstantiationException, IllegalArgumentException, InvocationTargetException, NCacheInstantiationException {
        try {
            if (type.getConstructor(new Class[0]) != null) {
                return type.newInstance();
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (type.getConstructor(type.getEnclosingClass()) != null) {
            return type.getConstructor(type.getEnclosingClass()).newInstance(this.newInstanceUsingEnclosingClasses(type.getEnclosingClass()));
        }
        throw new NCacheInstantiationException(type.getCanonicalName() + " and/or its enclosing classes do not have an empty constructor");
    }

    public void writeHandle(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            output.writeShort(this.mTypeHandle);
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }

    public void writeSubHandle(NCacheObjectOutput output, Object graph) throws NCacheIOException {
        try {
            output.writeShort(this.mSubTypeHandle);
        }
        catch (IOException ex) {
            throw new NCacheIOException(ex);
        }
    }
}

