/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.core.io;

import com.alachisoft.ncache.serialization.core.PackageResources;
import com.alachisoft.ncache.serialization.core.io.TypeSurrogateSelector;
import com.alachisoft.ncache.serialization.core.io.surrogates.BuiltinSerializationSurrogate;
import com.alachisoft.ncache.serialization.core.io.surrogates.NCacheArgumentException;
import com.alachisoft.ncache.serialization.core.io.surrogates.SerializationSurrogate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TypeSurrogateSelectorBase
implements TypeSurrogateSelector {
    protected SerializationSurrogate mNullSurrogate;
    protected SerializationSurrogate mDefaultSurrogate;
    protected SerializationSurrogate mDefaultArraySurrogate;
    protected Map<Class, SerializationSurrogate> mTypeSurrogateMap;
    protected Map<String, HashMap<Class, SerializationSurrogate>> mCacheContextTypeSurrogateMap;
    protected Map<String, HashMap<Short, Object>> mCacheContextHandleSurrogateMap;
    protected Map<Short, SerializationSurrogate> mHandleSurrogateMap;
    protected Short mNewTypeHandle;

    public TypeSurrogateSelectorBase() {
        this.construct(true);
    }

    public TypeSurrogateSelectorBase(boolean useBuiltinSurrogates) {
        this.construct(useBuiltinSurrogates);
    }

    private void construct(boolean useBuiltinSurrogates) {
        this.mTypeSurrogateMap = new HashMap<Class, SerializationSurrogate>();
        this.mHandleSurrogateMap = new HashMap<Short, SerializationSurrogate>();
        this.mCacheContextTypeSurrogateMap = new HashMap<String, HashMap<Class, SerializationSurrogate>>();
        this.mCacheContextHandleSurrogateMap = new HashMap<String, HashMap<Short, Object>>();
        this.mNewTypeHandle = -28672;
    }

    @Override
    public SerializationSurrogate getNullSurrogate() {
        return this.mNullSurrogate;
    }

    @Override
    public void setNullSurrogate(SerializationSurrogate value) {
        this.mNullSurrogate = value;
    }

    @Override
    public SerializationSurrogate getDefaultSurrogate() {
        return this.mDefaultSurrogate;
    }

    @Override
    public void setDefaultSurrogate(SerializationSurrogate value) {
        this.mDefaultSurrogate = value;
    }

    @Override
    public boolean isBuiltinSurrogate(SerializationSurrogate surrogate) {
        if (surrogate == null) {
            throw new IllegalArgumentException();
        }
        return BuiltinSerializationSurrogate.class.isAssignableFrom(surrogate.getClass());
    }

    @Override
    public SerializationSurrogate getSurrogateForObject(Object graph, String cacheContext) {
        if (graph == null) {
            return this.mNullSurrogate;
        }
        return this.getSurrogateForType(graph.getClass(), cacheContext.toLowerCase());
    }

    @Override
    public SerializationSurrogate getSurrogateForType(Class type, String cacheContext) {
        SerializationSurrogate surrogate = this.mTypeSurrogateMap.get(type);
        if (surrogate == null && cacheContext != null && this.mCacheContextTypeSurrogateMap.containsKey(cacheContext.toLowerCase())) {
            surrogate = this.mCacheContextTypeSurrogateMap.get(cacheContext.toLowerCase()).get(type);
        }
        if (surrogate == null && !type.isArray()) {
            surrogate = this.mDefaultSurrogate;
        } else if (surrogate == null && type.isArray()) {
            surrogate = this.mDefaultArraySurrogate;
        }
        return surrogate;
    }

    @Override
    public SerializationSurrogate getSurrogateForType(Class type, boolean strict, String cacheContext) {
        SerializationSurrogate surrogate = this.mTypeSurrogateMap.get(type);
        if (surrogate == null && cacheContext != null && this.mCacheContextTypeSurrogateMap.containsKey(cacheContext.toLowerCase())) {
            surrogate = this.mCacheContextTypeSurrogateMap.get(cacheContext.toLowerCase()).get(type);
        }
        if (!strict && surrogate == null && !type.isArray()) {
            surrogate = this.mDefaultSurrogate;
        } else if (!strict && surrogate == null && type.isArray()) {
            surrogate = this.mDefaultArraySurrogate;
        }
        return surrogate;
    }

    @Override
    public SerializationSurrogate getSurrogateForTypeHandle(short handle, String cacheContext) {
        SerializationSurrogate surrogate = this.mHandleSurrogateMap.get(handle);
        if (surrogate == null && cacheContext != null && this.mCacheContextTypeSurrogateMap.containsKey(cacheContext.toLowerCase())) {
            HashMap<Short, Object> userMap = this.mCacheContextHandleSurrogateMap.get(cacheContext.toLowerCase());
            if (userMap != null && userMap.containsKey(handle)) {
                if (userMap.get(handle) instanceof SerializationSurrogate) {
                    surrogate = (SerializationSurrogate)userMap.get(handle);
                } else {
                    return null;
                }
            }
            surrogate = (SerializationSurrogate)this.mCacheContextHandleSurrogateMap.get(cacheContext.toLowerCase()).get(handle);
        }
        if (surrogate == null) {
            surrogate = this.mDefaultSurrogate;
        }
        return surrogate;
    }

    @Override
    public SerializationSurrogate GetSurrogateForSubTypeHandle(short handle, short subHandle, String cacheContext) {
        SerializationSurrogate surrogate = null;
        HashMap<Short, Object> userTypeMap = this.mCacheContextHandleSurrogateMap.get(cacheContext.toLowerCase());
        if (userTypeMap != null && userTypeMap.containsKey(handle) && (surrogate = (SerializationSurrogate)((HashMap)userTypeMap.get(handle)).get(subHandle)) == null && ((HashMap)userTypeMap.get(handle)).size() > 0) {
            Iterator surr = ((HashMap)userTypeMap.get(handle)).entrySet().iterator();
            Map.Entry pair = surr.next();
            surrogate = (SerializationSurrogate)pair.getValue();
        }
        if (surrogate == null) {
            surrogate = this.mDefaultSurrogate;
        }
        return surrogate;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean register(SerializationSurrogate surrogate) throws NCacheArgumentException {
        if (surrogate == null) {
            throw new NCacheArgumentException();
        }
        while (true) {
            try {
                this.mNewTypeHandle = (short)(this.mNewTypeHandle + 1);
                return this.register(surrogate, this.mNewTypeHandle);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (NCacheArgumentException e) {
                throw e;
            }
            break;
        }
        catch (Exception e) {
            throw new NCacheArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(SerializationSurrogate surrogate, short typeHandle) throws NCacheArgumentException {
        if (!this.isBuiltinSurrogate(surrogate) && typeHandle < -28672) {
            throw new NCacheArgumentException(PackageResources.Surrogates_HandleOutOfRange);
        }
        Map<Class, SerializationSurrogate> map = this.mTypeSurrogateMap;
        synchronized (map) {
            if (this.mHandleSurrogateMap.containsKey(typeHandle)) {
                throw new IllegalArgumentException(PackageResources.Surrogates_AlreadyRegistered);
            }
            if (!this.mTypeSurrogateMap.containsKey(surrogate.getClassHandle())) {
                surrogate.setClassHandle(typeHandle);
                this.mTypeSurrogateMap.put(surrogate.getRealClass(), surrogate);
                this.mHandleSurrogateMap.put(surrogate.getClassHandle(), surrogate);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean register(SerializationSurrogate surrogate, short typeHandle, short subHandle, String cacheContext, boolean portable) throws NCacheArgumentException {
        if (!this.isBuiltinSurrogate(surrogate) && typeHandle < -28672) {
            throw new NCacheArgumentException(PackageResources.Surrogates_HandleOutOfRange);
        }
        if (this.mCacheContextTypeSurrogateMap.containsKey(cacheContext.toLowerCase())) {
            Map<String, HashMap<Class, SerializationSurrogate>> map = this.mCacheContextTypeSurrogateMap;
            synchronized (map) {
                if (this.mHandleSurrogateMap.containsKey(typeHandle) && this.mTypeSurrogateMap.containsKey(surrogate.getClassHandle())) {
                    throw new IllegalArgumentException(PackageResources.Surrogates_AlreadyRegistered);
                }
                if (portable) {
                    surrogate.setClassHandle(typeHandle);
                    if (!this.mCacheContextHandleSurrogateMap.get(cacheContext.toLowerCase()).containsKey(surrogate.getClassHandle())) {
                        this.mCacheContextTypeSurrogateMap.get(cacheContext.toLowerCase()).put(surrogate.getRealClass(), surrogate);
                        HashMap<Short, SerializationSurrogate> temp = new HashMap<Short, SerializationSurrogate>();
                        temp.put(surrogate.getSubHandle(), surrogate);
                        this.mCacheContextHandleSurrogateMap.get(cacheContext.toLowerCase()).put(surrogate.getClassHandle(), temp);
                        return true;
                    }
                    this.mCacheContextTypeSurrogateMap.get(cacheContext.toLowerCase()).put(surrogate.getRealClass(), surrogate);
                    HashMap typeMap = (HashMap)this.mCacheContextHandleSurrogateMap.get(cacheContext.toLowerCase()).get(surrogate.getClassHandle());
                    typeMap.put(surrogate.getSubHandle(), surrogate);
                } else if (!this.mCacheContextTypeSurrogateMap.get(cacheContext.toLowerCase()).containsKey(surrogate.getClassHandle())) {
                    surrogate.setClassHandle(typeHandle);
                    this.mCacheContextTypeSurrogateMap.get(cacheContext.toLowerCase()).put(surrogate.getRealClass(), surrogate);
                    this.mCacheContextHandleSurrogateMap.get(cacheContext.toLowerCase()).put(surrogate.getClassHandle(), surrogate);
                    return true;
                }
            }
        } else {
            surrogate.setClassHandle(typeHandle);
            if (portable) {
                HashMap<Class, SerializationSurrogate> temp1 = new HashMap<Class, SerializationSurrogate>();
                temp1.put(surrogate.getRealClass(), surrogate);
                HashMap temp2 = new HashMap();
                HashMap<Short, SerializationSurrogate> temp3 = new HashMap<Short, SerializationSurrogate>();
                temp3.put(surrogate.getSubHandle(), surrogate);
                temp2.put(surrogate.getClassHandle(), temp3);
                this.mCacheContextTypeSurrogateMap.put(cacheContext.toLowerCase(), temp1);
                this.mCacheContextHandleSurrogateMap.put(cacheContext.toLowerCase(), temp2);
            } else {
                HashMap<Class, SerializationSurrogate> temp1 = new HashMap<Class, SerializationSurrogate>();
                temp1.put(surrogate.getRealClass(), surrogate);
                HashMap<Short, SerializationSurrogate> temp2 = new HashMap<Short, SerializationSurrogate>();
                temp2.put(surrogate.getClassHandle(), surrogate);
                this.mCacheContextTypeSurrogateMap.put(cacheContext.toLowerCase(), temp1);
                this.mCacheContextHandleSurrogateMap.put(cacheContext.toLowerCase(), temp2);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(SerializationSurrogate surrogate, String cacheContext, boolean removeCache) {
        if (surrogate == null && !removeCache) {
            throw new IllegalArgumentException();
        }
        if (cacheContext == null && !removeCache) {
            Map<Class, SerializationSurrogate> map = this.mTypeSurrogateMap;
            synchronized (map) {
                this.mTypeSurrogateMap.remove(surrogate.getRealClass());
                this.mHandleSurrogateMap.remove(surrogate.getClassHandle());
            }
        } else if (removeCache) {
            this.mCacheContextTypeSurrogateMap.remove(cacheContext.toLowerCase());
            this.mCacheContextHandleSurrogateMap.remove(cacheContext.toLowerCase());
        } else {
            HashMap<Object, Object> temp1 = new HashMap();
            temp1 = this.mCacheContextTypeSurrogateMap.get(cacheContext.toLowerCase());
            temp1.remove(surrogate.getRealClass());
            HashMap<Object, Object> temp2 = new HashMap();
            temp2 = this.mCacheContextHandleSurrogateMap.get(cacheContext.toLowerCase());
            temp2.remove(surrogate.getClassHandle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<Class, SerializationSurrogate> map = this.mTypeSurrogateMap;
        synchronized (map) {
            this.mTypeSurrogateMap.clear();
            this.mHandleSurrogateMap.clear();
            this.mNewTypeHandle = -28672;
        }
    }
}

