/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.serialization.JSON;

import com.alachisoft.ncache.runtime.JSON.JsonArray;
import com.alachisoft.ncache.runtime.JSON.JsonObject;
import com.alachisoft.ncache.runtime.JSON.JsonValue;
import com.alachisoft.ncache.runtime.JSON.JsonValueBase;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.serialization.JSON.DataTypeNCacheMapper;
import com.alachisoft.ncache.serialization.JSON.DefaultNCacheMapper;
import com.alachisoft.ncache.serialization.JSON.PrimaryField;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class JsonBinaryFormatter {
    public static final Charset SERIALIZATION_CHARSET = StandardCharsets.UTF_8;
    private static DefaultNCacheMapper _defaultTypedMapper = new DefaultNCacheMapper(true);
    private static DefaultNCacheMapper _defaultNonTypedMapper = new DefaultNCacheMapper(false);
    private static DataTypeNCacheMapper _dataTypeMapper = new DataTypeNCacheMapper();

    public static byte[] toByteArray(Object serializableObject) throws OperationFailedException {
        return JsonBinaryFormatter.serializeObject(serializableObject).getBytes(SERIALIZATION_CHARSET);
    }

    public static String serializeObject(Object value) throws OperationFailedException {
        return JsonBinaryFormatter.serializeObject(value, false);
    }

    public static String serializeObject(Object value, boolean isCustomAtributeBaseSerialized) throws OperationFailedException {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        try {
            if (isCustomAtributeBaseSerialized && JsonBinaryFormatter.anyFieldHasAnnotation(value.getClass())) {
                return _dataTypeMapper.writeValueAsString(value);
            }
            if (JsonValueBase.class.isAssignableFrom(value.getClass())) {
                return ((JsonValueBase)value).toJson();
            }
            return _defaultTypedMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new OperationFailedException("Failed to deserialize data", (Throwable)e);
        }
    }

    public static <T> T fromByteBuffer(byte[] buffer, Class<?> cls) throws OperationFailedException {
        if (buffer == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: buffer");
        }
        String json = new String(buffer, SERIALIZATION_CHARSET);
        try {
            return JsonBinaryFormatter.deserializeObject(json, cls);
        }
        catch (JsonProcessingException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public static <T> T deserializeObject(String value, Class<?> cls) throws OperationFailedException, JsonProcessingException {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: value");
        }
        if (cls == null) {
            cls = Object.class;
        }
        try {
            if (JsonValueBase.class.isAssignableFrom(cls)) {
                JsonValueBase valuebase = JsonValueBase.parse((String)value);
                if (cls.isAssignableFrom(valuebase.getClass())) {
                    return (T)valuebase;
                }
                throw new ClassCastException(valuebase.getClass() + " cannot be cast to " + cls);
            }
            try {
                return (T)_defaultTypedMapper.readValue(value, cls);
            }
            catch (InvalidTypeIdException ex) {
                Object object = _defaultTypedMapper.readValue(value, Object.class);
                throw new ClassCastException("class " + object.getClass().getName() + " cannot be cast to " + cls);
            }
        }
        catch (JsonProcessingException jsonProcessingException) {
            return (T)_defaultNonTypedMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(value, cls);
        }
    }

    public static String decodeString(byte[] buffer) {
        return new String(buffer);
    }

    private static boolean anyFieldHasAnnotation(Class<?> c) {
        for (Field f : c.getFields()) {
            if (!f.isAnnotationPresent(PrimaryField.class)) continue;
            return true;
        }
        return false;
    }

    private static void addTypeToJson(JsonValueBase json) {
        if (json.getClass().isAssignableFrom(JsonObject.class)) {
            // empty if block
        }
        if (json.getClass().isAssignableFrom(JsonArray.class)) {
            // empty if block
        }
        if (json.getClass().isAssignableFrom(JsonValue.class)) {
            // empty if block
        }
    }
}

