/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Parser;

import Alachisoft.NCache.Parser.Action;
import Alachisoft.NCache.Parser.FAEdge;
import Alachisoft.NCache.Parser.FAState;
import Alachisoft.NCache.Parser.GrammarReader;
import Alachisoft.NCache.Parser.LRAction;
import Alachisoft.NCache.Parser.LRActionTable;
import Alachisoft.NCache.Parser.LookAheadReader;
import Alachisoft.NCache.Parser.ParseMessage;
import Alachisoft.NCache.Parser.ParseResult;
import Alachisoft.NCache.Parser.ParserException;
import Alachisoft.NCache.Parser.RecordId;
import Alachisoft.NCache.Parser.Reduction;
import Alachisoft.NCache.Parser.Rule;
import Alachisoft.NCache.Parser.Symbol;
import Alachisoft.NCache.Parser.SymbolType;
import Alachisoft.NCache.Parser.Token;
import Alachisoft.NCache.Parser.TokenStack;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.util.HashMap;

public class Parser {
    private HashMap m_parameters;
    private Symbol[] m_symbols;
    private String[] m_charsets;
    private Rule[] m_rules;
    private FAState[] m_DfaStates;
    private LRActionTable[] m_LalrTables;
    private boolean m_initialized;
    private boolean m_caseSensitive;
    private int m_startSymbol;
    private int m_initDfaState;
    private Symbol m_errorSymbol;
    private Symbol m_endSymbol;
    private LookAheadReader m_source;
    private int m_lineNumber;
    private boolean m_haveReduction;
    private boolean m_trimReductions;
    private int m_commentLevel;
    private int m_initLalrState;
    private int m_LalrState;
    private TokenStack m_inputTokens;
    private TokenStack m_outputTokens;
    private TokenStack m_tempStack;

    public Parser() {
    }

    public Parser(String p_filename) throws IOException {
        this.LoadGrammar(p_filename);
    }

    public Parser(FileInputStream stream) throws IOException {
        this.LoadGrammar(stream);
    }

    public final void LoadGrammar(String p_filename) throws IOException {
        this.m_parameters = new HashMap();
        this.m_inputTokens = new TokenStack();
        this.m_outputTokens = new TokenStack();
        this.m_tempStack = new TokenStack();
        this.m_initialized = false;
        this.m_trimReductions = false;
        this.LoadTables(new GrammarReader(p_filename));
    }

    public final void LoadGrammar(InputStream stream) throws IOException {
        this.m_parameters = new HashMap();
        this.m_inputTokens = new TokenStack();
        this.m_outputTokens = new TokenStack();
        this.m_tempStack = new TokenStack();
        this.m_initialized = false;
        this.m_trimReductions = false;
        this.LoadTables(new GrammarReader(stream));
    }

    public final boolean getTrimReductions() {
        return this.m_trimReductions;
    }

    public final void setTrimReductions(boolean value) {
        this.m_trimReductions = value;
    }

    public final Token getCurrentToken() {
        return this.m_inputTokens.PeekToken();
    }

    public final Reduction getCurrentReduction() {
        if (this.m_haveReduction) {
            Token token = this.m_tempStack.PeekToken();
            Object tempVar = token.getData();
            return (Reduction)(tempVar instanceof Reduction ? tempVar : null);
        }
        return null;
    }

    public final void setCurrentReduction(Reduction value) {
        if (this.m_haveReduction) {
            this.m_tempStack.PeekToken().setData(value);
        }
    }

    public final int getCurrentLineNumber() {
        return this.m_lineNumber;
    }

    public final void PushInputToken(Token p_token) {
        this.m_inputTokens.PushToken(p_token);
    }

    public final Token PopInputToken() {
        return this.m_inputTokens.PopToken();
    }

    public final TokenStack GetTokens() {
        return this.m_outputTokens;
    }

    public final String GetParameter(String p_name) {
        String result = (String)this.m_parameters.get(p_name);
        return result != null ? result : "";
    }

    public final void OpenFile(String p_filename) throws FileNotFoundException {
        this.Reset();
        this.m_source = new LookAheadReader(new BufferedReader(new FileReader(p_filename)));
        this.PrepareToParse();
    }

    public final void OpenStream(BufferedReader stream) {
        this.Reset();
        this.m_source = new LookAheadReader(stream);
        this.PrepareToParse();
    }

    public final void CloseFile() throws IOException {
        if (this.m_source != null) {
            this.m_source.Close();
        }
        this.m_source = null;
    }

    public final ParseMessage Parse() throws IOException {
        block16: while (true) {
            Token token;
            if (this.m_inputTokens.getCount() == 0) {
                token = this.RetrieveToken();
                if (token == null) {
                    throw new ParserException("RetrieveToken returned null");
                }
                if (token.getKind() == SymbolType.Whitespace) continue;
                this.m_inputTokens.PushToken(token);
                if (this.m_commentLevel != 0 || this.CommentToken(token)) continue;
                return ParseMessage.TokenRead;
            }
            if (this.m_commentLevel > 0) {
                token = this.m_inputTokens.PopToken();
                switch (token.getKind()) {
                    case CommentStart: {
                        ++this.m_commentLevel;
                        break;
                    }
                    case CommentEnd: {
                        --this.m_commentLevel;
                        break;
                    }
                    case End: {
                        return ParseMessage.CommentError;
                    }
                }
                continue;
            }
            token = this.m_inputTokens.PeekToken();
            switch (token.getKind()) {
                case CommentStart: {
                    this.m_inputTokens.PopToken();
                    ++this.m_commentLevel;
                    continue block16;
                }
                case CommentLine: {
                    this.m_inputTokens.PopToken();
                    this.DiscardLine();
                    continue block16;
                }
            }
            ParseResult result = this.ParseToken(token);
            switch (result) {
                case Accept: {
                    return ParseMessage.Accept;
                }
                case InternalError: {
                    return ParseMessage.InternalError;
                }
                case ReduceNormal: {
                    return ParseMessage.Reduction;
                }
                case Shift: {
                    this.m_inputTokens.PopToken();
                    break;
                }
                case SyntaxError: {
                    return ParseMessage.SyntaxError;
                }
            }
        }
    }

    private char FixCase(char p_char) {
        if (this.m_caseSensitive) {
            return p_char;
        }
        return Character.toLowerCase(p_char);
    }

    private String FixCase(String p_string) {
        if (this.m_caseSensitive) {
            return p_string;
        }
        return p_string.toLowerCase();
    }

    private void AddSymbol(Symbol p_symbol) {
        if (!this.m_initialized) {
            throw new ParserException("Table sizes not initialized");
        }
        int index = p_symbol.getTableIndex();
        this.m_symbols[index] = p_symbol;
    }

    private void AddCharset(int p_index, String p_charset) {
        if (!this.m_initialized) {
            throw new ParserException("Table sizes not initialized");
        }
        this.m_charsets[p_index] = this.FixCase(p_charset);
    }

    private void AddRule(Rule p_rule) {
        if (!this.m_initialized) {
            throw new ParserException("Table sizes not initialized");
        }
        int index = p_rule.getTableIndex();
        this.m_rules[index] = p_rule;
    }

    private void AddDfaState(int p_index, FAState p_fastate) {
        if (!this.m_initialized) {
            throw new ParserException("Table sizes not initialized");
        }
        this.m_DfaStates[p_index] = p_fastate;
    }

    private void AddLalrTable(int p_index, LRActionTable p_table) {
        if (!this.m_initialized) {
            throw new ParserException("Table counts not initialized");
        }
        this.m_LalrTables[p_index] = p_table;
    }

    private void LoadTables(GrammarReader reader) {
        block11: while (reader.MoveNext()) {
            byte id = (Byte)reader.RetrieveNext();
            switch (RecordId.forValue(id)) {
                case Parameters: {
                    this.m_parameters.put("Name", (String)reader.RetrieveNext());
                    this.m_parameters.put("Version", (String)reader.RetrieveNext());
                    this.m_parameters.put("Author", (String)reader.RetrieveNext());
                    this.m_parameters.put("About", (String)reader.RetrieveNext());
                    this.m_caseSensitive = (Boolean)reader.RetrieveNext();
                    this.m_startSymbol = ((Short)reader.RetrieveNext()).shortValue();
                    continue block11;
                }
                case TableCounts: {
                    this.m_symbols = new Symbol[((Short)reader.RetrieveNext()).shortValue()];
                    this.m_charsets = new String[((Short)reader.RetrieveNext()).shortValue()];
                    this.m_rules = new Rule[((Short)reader.RetrieveNext()).shortValue()];
                    this.m_DfaStates = new FAState[((Short)reader.RetrieveNext()).shortValue()];
                    this.m_LalrTables = new LRActionTable[((Short)reader.RetrieveNext()).shortValue()];
                    this.m_initialized = true;
                    continue block11;
                }
                case Initial: {
                    this.m_initDfaState = ((Short)reader.RetrieveNext()).shortValue();
                    this.m_initLalrState = ((Short)reader.RetrieveNext()).shortValue();
                    continue block11;
                }
                case Symbols: {
                    short index = (Short)reader.RetrieveNext();
                    String name = (String)reader.RetrieveNext();
                    SymbolType kind = SymbolType.forValue(((Short)reader.RetrieveNext()).shortValue());
                    Symbol symbol = new Symbol(index, name, kind);
                    this.AddSymbol(symbol);
                    continue block11;
                }
                case CharSets: {
                    short index = (Short)reader.RetrieveNext();
                    String charset = (String)reader.RetrieveNext();
                    this.AddCharset(index, charset);
                    continue block11;
                }
                case Rules: {
                    Object obj;
                    short index = (Short)reader.RetrieveNext();
                    Symbol head = this.m_symbols[(Short)reader.RetrieveNext()];
                    Rule rule = new Rule(index, head);
                    reader.RetrieveNext();
                    while ((obj = reader.RetrieveNext()) != null) {
                        rule.AddItem(this.m_symbols[(Short)obj]);
                    }
                    this.AddRule(rule);
                    continue block11;
                }
                case DFAStates: {
                    FAState fastate = new FAState();
                    short index = (Short)reader.RetrieveNext();
                    if (((Boolean)reader.RetrieveNext()).booleanValue()) {
                        fastate.setAcceptSymbol(((Short)reader.RetrieveNext()).shortValue());
                    } else {
                        reader.RetrieveNext();
                    }
                    reader.RetrieveNext();
                    while (!reader.RetrieveDone()) {
                        short ci = (Short)reader.RetrieveNext();
                        short ti = (Short)reader.RetrieveNext();
                        reader.RetrieveNext();
                        fastate.AddEdge(this.m_charsets[ci], ti);
                    }
                    this.AddDfaState(index, fastate);
                    continue block11;
                }
                case LRTables: {
                    LRActionTable table = new LRActionTable();
                    short index = (Short)reader.RetrieveNext();
                    reader.RetrieveNext();
                    while (!reader.RetrieveDone()) {
                        short sid = (Short)reader.RetrieveNext();
                        short action = (Short)reader.RetrieveNext();
                        short tid = (Short)reader.RetrieveNext();
                        reader.RetrieveNext();
                        table.AddItem(this.m_symbols[sid], Action.forValue(action), tid);
                    }
                    this.AddLalrTable(index, table);
                    continue block11;
                }
                case Comment: {
                    continue block11;
                }
            }
            throw new ParserException("Wrong id for record");
        }
    }

    private void Reset() {
        for (Symbol symbol : this.m_symbols) {
            if (symbol.getKind() == SymbolType.Error) {
                this.m_errorSymbol = symbol;
                continue;
            }
            if (symbol.getKind() != SymbolType.End) continue;
            this.m_endSymbol = symbol;
        }
        this.m_haveReduction = false;
        this.m_LalrState = this.m_initLalrState;
        this.m_lineNumber = 1;
        this.m_commentLevel = 0;
        this.m_inputTokens.Clear();
        this.m_outputTokens.Clear();
        this.m_tempStack.Clear();
    }

    private void PrepareToParse() {
        Token token = new Token();
        token.setState(this.m_initLalrState);
        token.SetParent(this.m_symbols[this.m_startSymbol]);
        this.m_tempStack.PushToken(token);
    }

    private void DiscardLine() throws IOException {
        this.m_source.DiscardLine();
        ++this.m_lineNumber;
    }

    private boolean CommentToken(Token p_token) {
        return p_token.getKind() == SymbolType.CommentLine || p_token.getKind() == SymbolType.CommentStart;
    }

    private ParseResult ParseToken(Token p_token) {
        ParseResult result = ParseResult.InternalError;
        LRActionTable table = this.m_LalrTables[this.m_LalrState];
        LRAction action = table.GetActionForSymbol(p_token.getTableIndex());
        if (action != null) {
            this.m_haveReduction = false;
            this.m_outputTokens.Clear();
            switch (action.getAction()) {
                case Accept: {
                    this.m_haveReduction = true;
                    result = ParseResult.Accept;
                    break;
                }
                case Shift: {
                    this.m_LalrState = action.getValue();
                    p_token.setState(this.m_LalrState);
                    this.m_tempStack.PushToken(p_token);
                    result = ParseResult.Shift;
                    break;
                }
                case Reduce: {
                    result = this.Reduce(this.m_rules[action.getValue()]);
                }
            }
        } else {
            this.m_outputTokens.Clear();
            for (Object aObj : table.getMembers()) {
                LRAction a = (LRAction)aObj;
                SymbolType kind = a.getSymbol().getKind();
                if (kind != SymbolType.Terminal && kind != SymbolType.End) continue;
                this.m_outputTokens.PushToken(new Token(a.getSymbol()));
            }
            result = ParseResult.SyntaxError;
        }
        return result;
    }

    private ParseResult Reduce(Rule p_rule) {
        ParseResult result;
        Token head;
        if (this.m_trimReductions && p_rule.getContainsOneNonTerminal()) {
            head = this.m_tempStack.PopToken();
            head.SetParent(p_rule.getRuleNonTerminal());
            result = ParseResult.ReduceEliminated;
        } else {
            Reduction reduction = new Reduction();
            reduction.setParentRule(p_rule);
            this.m_tempStack.PopTokensInto(reduction, p_rule.getSymbolCount());
            head = new Token();
            head.setData(reduction);
            head.SetParent(p_rule.getRuleNonTerminal());
            this.m_haveReduction = true;
            result = ParseResult.ReduceNormal;
        }
        int index = this.m_tempStack.PeekToken().getState();
        LRAction action = this.m_LalrTables[index].GetActionForSymbol(p_rule.getRuleNonTerminal().getTableIndex());
        if (action == null) {
            throw new ParserException("Action for LALR state is null");
        }
        this.m_LalrState = action.getValue();
        head.setState(this.m_LalrState);
        this.m_tempStack.PushToken(head);
        return result;
    }

    private Token RetrieveToken() throws IOException {
        Token result;
        int currentPos = 0;
        int lastAcceptState = -1;
        int lastAcceptPos = -1;
        FAState currentState = this.m_DfaStates[this.m_initDfaState];
        try {
            while (true) {
                int target = -1;
                char ch = this.FixCase(this.m_source.LookAhead(currentPos));
                for (Object edgeObj : currentState.getEdges()) {
                    FAEdge edge = (FAEdge)edgeObj;
                    String chars = edge.getCharacters();
                    if (chars.indexOf(ch) == -1) continue;
                    target = edge.getTargetIndex();
                    break;
                }
                if (target == -1) break;
                if (this.m_DfaStates[target].getAcceptSymbol() != -1) {
                    lastAcceptState = target;
                    lastAcceptPos = currentPos;
                }
                currentState = this.m_DfaStates[target];
                ++currentPos;
            }
            if (lastAcceptState == -1) {
                result = new Token(this.m_errorSymbol);
                result.setData(this.m_source.Read(1));
            } else {
                Symbol symbol = this.m_symbols[this.m_DfaStates[lastAcceptState].getAcceptSymbol()];
                result = new Token(symbol);
                result.setData(this.m_source.Read(lastAcceptPos + 1));
            }
        }
        catch (StreamCorruptedException e) {
            result = new Token(this.m_endSymbol);
            result.setData("");
        }
        this.UpdateLineNumber((String)result.getData());
        return result;
    }

    private void UpdateLineNumber(String p_string) {
        int index;
        int pos = 0;
        while ((index = p_string.indexOf(10, pos)) != -1) {
            pos = index + 1;
            ++this.m_lineNumber;
        }
    }
}

