/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamCorruptedException;

public class LookAheadReader {
    private static final int BUFSIZE = 256;
    private BufferedReader m_reader;
    private char[] m_buffer;
    private int m_curpos;
    private int m_buflen;

    public LookAheadReader(BufferedReader p_reader) {
        this.m_reader = p_reader;
        this.m_curpos = -1;
        this.m_buffer = new char[256];
    }

    private void FillBuffer(int p_length) throws IOException {
        int av = this.m_buflen - this.m_curpos;
        if (this.m_curpos == -1) {
            this.m_buflen = this.m_reader.read(this.m_buffer, 0, 256);
            this.m_curpos = 0;
        } else if (av < p_length) {
            if (this.m_buflen < 256) {
                throw new StreamCorruptedException();
            }
            System.arraycopy(this.m_buffer, this.m_curpos, this.m_buffer, 0, av);
            int read = this.m_reader.read(this.m_buffer, av, this.m_curpos);
            this.m_buflen = read + av;
            this.m_curpos = 0;
            this.m_reader.mark(this.m_buflen + 1);
            if (this.m_reader.read() == -1 && this.m_buflen == 256 && read == 0) {
                throw new StreamCorruptedException();
            }
            this.m_reader.reset();
        }
        if (this.m_buflen < 256) {
            this.m_buffer[this.m_buflen++] = 10;
        }
    }

    public final char LookAhead() throws IOException, StreamCorruptedException {
        this.FillBuffer(1);
        return this.m_buffer[this.m_curpos];
    }

    public final char LookAhead(int p_pos) throws IOException, StreamCorruptedException {
        this.FillBuffer(p_pos + 1);
        return this.m_buffer[this.m_curpos + p_pos];
    }

    public final char Read() throws IOException, StreamCorruptedException {
        this.FillBuffer(1);
        return this.m_buffer[this.m_curpos++];
    }

    public final String Read(int p_length) throws IOException, StreamCorruptedException {
        this.FillBuffer(p_length);
        String result = new String(this.m_buffer, this.m_curpos, p_length);
        this.m_curpos += p_length;
        return result;
    }

    public final void DiscardLine() throws IOException, StreamCorruptedException {
        while (this.LookAhead() != '\n') {
            ++this.m_curpos;
        }
    }

    public final void Close() throws IOException {
        this.m_reader.close();
    }
}

