/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class NCDateTime {
    private static int[] DaysToMonth365 = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static int[] DaysToMonth366 = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366};
    private static final long TicksPerMillisecond = 10000L;
    private static final long TicksPerSecond = 10000000L;
    private static final long TicksPerMinute = 600000000L;
    private static final long TicksPerHour = 36000000000L;
    private static final long TicksPerDay = 864000000000L;
    private static final int MillisPerSecond = 1000;
    private static final int MillisPerMinute = 60000;
    private static final int MillisPerHour = 3600000;
    private static final int MillisPerDay = 86400000;
    private static final int DaysPerYear = 365;
    private static final int DaysPer4Years = 1461;
    private static final int DaysPer100Years = 36524;
    private static final int DaysPer400Years = 146097;
    private static final int DaysTo1601 = 584388;
    private static final int DaysTo1899 = 693593;
    public static final int DaysTo1970 = 719162;
    private static final int DaysTo10000 = 3652059;
    public static final long MinTicks = 0L;
    public static final long MaxTicks = 3155378975999999999L;
    public static final Date MinValue = new Date(0L);
    public static final Date MaxValue = NCDateTime.getMaxValue();
    private static final long FlagsMask = 0xC000000L;
    private static final long MaxMillis = 315537897600000L;
    long dateData;
    int _year = -1;
    int _month = -1;
    int _day = -1;
    int _hours = -1;
    int _minutes = -1;
    int _seconds = -1;
    int _milliseconds = -1;

    public NCDateTime(int year, int month, int day, int hours, int minutes, int seconds, int milliseconds) throws IllegalArgumentException {
        if (milliseconds < 0 || milliseconds >= 1000) {
            throw new IllegalArgumentException("millisecond");
        }
        long num = this.DateToTicks(year, month, day) + this.TimeToTicks(hours, minutes, seconds);
        if ((num += (long)milliseconds * 10000L) < 0L || num > 3155378975999999999L) {
            throw new IllegalArgumentException("Arg_DateTimeRange");
        }
        this.dateData = num;
    }

    public NCDateTime(Date date) throws IllegalArgumentException {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(14, 0);
        c.setTime(date);
        if (c.get(14) < 0 || c.get(14) >= 1000) {
            throw new IllegalArgumentException("millisecond");
        }
        long num = this.DateToTicks(c.get(1), c.get(2) + 1, c.get(5)) + this.TimeToTicks(c.get(11), c.get(12), c.get(13));
        if ((num += (long)c.get(14) * 10000L) < 0L || num > 3155378975999999999L) {
            throw new IllegalArgumentException("Arg_DateTimeRange");
        }
        this.dateData = num;
    }

    public NCDateTime(long ticks) {
        this.dateData = ticks;
    }

    public void addTicks(long ticks) {
        this.dateData += ticks;
    }

    private static boolean IsLeapYear(int year) throws IllegalArgumentException {
        if (year < 1 || year > 9999) {
            throw new IllegalArgumentException("ArgumentOutOfRange_Year");
        }
        if (year % 4 != 0) {
            return false;
        }
        if (year % 100 == 0) {
            return year % 400 == 0;
        }
        return true;
    }

    public static Date getUTCNow() {
        try {
            NCDateTime ncd = new NCDateTime(Calendar.getInstance().getTime());
            return ncd.getLocalizedDate();
        }
        catch (IllegalArgumentException argumentException) {
            return null;
        }
    }

    public static Date getUTCDate(Date date) throws ParseException {
        long ticks = 0L;
        if (date.getTime() != 0L) {
            TimeZone utc = TimeZone.getTimeZone("UTC");
            Calendar cal = Calendar.getInstance(utc);
            cal.setTime(date);
            NCDateTime ncDate = new NCDateTime(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
            return ncDate.getDate();
        }
        return null;
    }

    private long DateToTicks(int year, int month, int day) throws IllegalArgumentException {
        if (year >= 1 && year <= 9999 && month >= 1 && month <= 12) {
            int[] numArray;
            int[] nArray = numArray = NCDateTime.IsLeapYear(year) ? DaysToMonth366 : DaysToMonth365;
            if (day >= 1 && day <= numArray[month] - numArray[month - 1]) {
                int num = year - 1;
                int num2 = num * 365 + num / 4 - num / 100 + num / 400 + numArray[month - 1] + day - 1;
                return (long)num2 * 864000000000L;
            }
        }
        throw new IllegalArgumentException("ArgumentOutOfRange_BadYearMonthDay");
    }

    private long TimeToTicks(int hour, int minute, int second) throws IllegalArgumentException {
        if (hour < 0 || hour >= 24 || minute < 0 || minute >= 60 || second < 0 || second >= 60) {
            throw new IllegalArgumentException("ArgumentOutOfRange_BadHourMinuteSecond");
        }
        long num = (long)hour * 3600L + (long)minute * 60L + (long)second;
        if (num > 922337203685L || num < -922337203685L) {
            throw new IllegalArgumentException("Overflow_TimeSpanTooLong");
        }
        return num * 10000000L;
    }

    public int getDay() {
        if (this._day == -1) {
            this._day = this.GetDatePart(3);
        }
        return this._day;
    }

    public int getHours() {
        if (this._hours == -1) {
            this._hours = (int)(this.getInternalTicks() / 36000000000L % 24L);
        }
        return this._hours;
    }

    public int getMilliseconds() {
        if (this._milliseconds == -1) {
            this._milliseconds = (int)(this.getInternalTicks() / 10000L % 1000L);
        }
        return this._milliseconds;
    }

    public int getMinutes() {
        if (this._minutes == -1) {
            this._minutes = (int)(this.getInternalTicks() / 600000000L % 60L);
        }
        return this._minutes;
    }

    public int getMonth() {
        if (this._month == -1) {
            this._month = this.GetDatePart(2);
        }
        return this._month;
    }

    public int getSeconds() {
        if (this._seconds == -1) {
            this._seconds = (int)(this.getInternalTicks() / 10000000L % 60L);
        }
        return this._seconds;
    }

    public int getYear() {
        if (this._year == -1) {
            this._year = this.GetDatePart(0);
        }
        return this._year;
    }

    public Date AddYears(int value) throws IllegalArgumentException {
        if (value < -10000 || value > 10000) {
            throw new IllegalArgumentException("years");
        }
        return this.AddMonths(value * 12);
    }

    public Date AddMonths(int months) throws IllegalArgumentException {
        if (months < -120000 || months > 120000) {
            throw new IllegalArgumentException("months");
        }
        int y = this.getYear();
        int m = this.getMonth();
        int d = this.getDay();
        int i = m - 1 + months;
        if (i >= 0) {
            m = i % 12 + 1;
            y += i / 12;
        } else {
            m = 12 + (i + 1) % 12;
            y += (i - 11) / 12;
        }
        if (y < 1 || y > 9999) {
            throw new IllegalArgumentException("months");
        }
        int days = NCDateTime.DaysInMonth(y, m);
        if (d > days) {
            d = days;
        }
        return new Date(this.DateToTicks(y, m, d) + this.getInternalTicks() % 864000000000L | this.getInternalKind());
    }

    public static int DaysInMonth(int year, int month) throws IllegalArgumentException {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("month");
        }
        int[] days = NCDateTime.IsLeapYear(year) ? DaysToMonth366 : DaysToMonth365;
        return days[month] - days[month - 1];
    }

    public long getTicks() {
        return this.getInternalTicks();
    }

    private long getInternalTicks() {
        return this.dateData & 0x3FFFFFFFFFFFFFFFL;
    }

    private long getInternalKind() {
        return this.dateData & 0xC000000L;
    }

    private int GetDatePart(int part) {
        int num5;
        int num6;
        int num3;
        int num4;
        int num2 = (int)(this.getInternalTicks() / 864000000000L);
        if ((num4 = (num2 -= (num3 = num2 / 146097) * 146097) / 36524) == 4) {
            num4 = 3;
        }
        num2 -= num4 * 36524;
        if ((num6 = (num2 -= (num5 = num2 / 1461) * 1461) / 365) == 4) {
            num6 = 3;
        }
        if (part == 0) {
            return num3 * 400 + num4 * 100 + num5 * 4 + num6 + 1;
        }
        num2 -= num6 * 365;
        if (part == 1) {
            return num2 + 1;
        }
        int[] numArray = num6 == 3 && (num5 != 24 || num4 == 3) ? DaysToMonth366 : DaysToMonth365;
        int index = num2 >> 6;
        while (num2 >= numArray[index]) {
            ++index;
        }
        if (part == 2) {
            return index;
        }
        return num2 - numArray[index - 1] + 1;
    }

    public Date getDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(14, 0);
        cal.set(this.getYear(), this.getMonth() - 1, this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds());
        cal.set(14, this.getMilliseconds());
        return cal.getTime();
    }

    public Date getLocalizedDate() {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar cal = Calendar.getInstance(utc);
        cal.clear();
        cal.set(14, 0);
        cal.set(this.getYear(), this.getMonth() - 1, this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds());
        cal.set(14, this.getMilliseconds());
        return cal.getTime();
    }

    public long getLocalizedTimeInTicks() {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        Calendar cal = Calendar.getInstance(utc);
        cal.clear();
        cal.set(14, 0);
        cal.set(this.getYear(), this.getMonth(), this.getDay(), this.getHours(), this.getMinutes(), this.getSeconds());
        cal.set(14, this.getMilliseconds());
        long tic = -1L;
        try {
            tic = new NCDateTime(cal.getTime()).getTicks();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return tic;
    }

    private static Date getMaxValue() {
        String maxValue = "30-Dec-9999 23:59:59 UTC";
        try {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            SimpleDateFormat date = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss z");
            cal.setTime(date.parse(maxValue));
            Date utcdate = cal.getTime();
            return utcdate;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("ArgumentOutOfRange_BadYearMonthDay");
        }
    }

    public static Date getDefaultDate() {
        return new NCDateTime(1, 1, 1, 0, 0, 0, 0).getDate();
    }

    public void addDays(double value) {
        this.add(value, 86400000);
    }

    private void add(double value, int scale) {
        long millis = (long)(value * (double)scale + (value >= 0.0 ? 0.5 : -0.5));
        if (millis <= -315537897600000L || millis >= 315537897600000L) {
            throw new IllegalArgumentException("valueArgumentOutOfRange_addValue");
        }
        this.addTicks(millis * 10000L);
    }
}

