/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.util;

import com.alachisoft.ncache.runtime.util.NCDateTime;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class HelperFxn {
    private static final long TICKS_AT_EPOCH = 621355968000000000L;
    private static final long TICKS_PER_MILLISECOND = 10000L;

    public static void copyTo(byte[] src, int srcStart, char[] dest, int destStart, int length) {
        int i = srcStart;
        for (int j = destStart; i < srcStart + length || j < destStart + length; ++i, ++j) {
            dest[i] = (char)src[j];
        }
    }

    public static void copyTo(char[] src, int srcStart, byte[] dest, int destStart, int length) {
        int i = srcStart;
        for (int j = destStart; i < srcStart + length || j < destStart + length; ++i, ++j) {
            dest[i] = (byte)src[j];
        }
    }

    public static void copyTo(byte[] src, int srcStart, byte[] dest, int destStart, int length) {
        int i = srcStart;
        for (int j = destStart; i < srcStart + length || j < destStart + length; ++i, ++j) {
            dest[i] = src[j];
        }
    }

    public static byte[] getUTF8Bytes(String data) throws UnsupportedEncodingException {
        return data.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] getUTF8Bytes(byte[] data) throws UnsupportedEncodingException {
        return String.valueOf(data).getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] getUTF8Bytes(int data) throws UnsupportedEncodingException {
        return String.valueOf(data).getBytes(StandardCharsets.UTF_8);
    }

    public static void BlockCopy(byte[] src, int srcOffset, byte[] dst, int dstOffset, int count) {
        for (int i = srcOffset; i < count; ++i) {
            dst[dstOffset + i] = src[i];
        }
    }

    public static long getTicks(Date date) {
        long ticks = 0L;
        if (date.getTime() != 0L) {
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            cal.setTime(date);
            try {
                NCDateTime ncDate = new NCDateTime(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
                ticks = ncDate.getTicks();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ticks;
    }

    public static long getUTCTicks(Date date) {
        long ticks = 0L;
        if (date.getTime() != 0L) {
            TimeZone utc = TimeZone.getTimeZone("UTC");
            Calendar cal = Calendar.getInstance(utc);
            cal.set(14, 0);
            cal.setTime(date);
            try {
                NCDateTime ncDate = new NCDateTime(cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14));
                ticks = ncDate.getTicks();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return ticks;
    }

    public static Date getDateFromTicks(long ticks) {
        return new NCDateTime(ticks).getDate();
    }

    public static Date getDateFromUTCTicks(long ticks) {
        return new NCDateTime(ticks).getLocalizedDate();
    }

    public static Date getCurrentTime() {
        return Calendar.getInstance().getTime();
    }

    public static byte[] writeShort(short value) {
        byte[] byteBuffer = new byte[]{(byte)value, (byte)(value >> 8)};
        return byteBuffer;
    }

    public static int toInt32(byte[] buffer, int offset, int size) {
        String s = new String(buffer, offset, size, StandardCharsets.UTF_8);
        return Integer.parseInt(s);
    }

    public static byte[] toBytes(int length) {
        return String.valueOf(length).getBytes(StandardCharsets.UTF_8);
    }
}

