/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.caching;

import com.alachisoft.ncache.runtime.caching.PayloadDeserializer;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.ConvertorBase64;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Date;
import java.util.UUID;

public class Message {
    private static final TimeSpan noExpiration = new TimeSpan(Long.MAX_VALUE);
    private TimeSpan expirationTime;
    private Object payload;
    private Object serializePayload;
    private String messageId;
    private PayloadDeserializer payloadDeserializer;
    private Date creationTime = new Date(0L);

    public Message(Object payload) {
        this(payload, null);
    }

    public Message(Object payload, TimeSpan timeSpan) {
        if (payload == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: payload");
        }
        this.creationTime = new Date();
        this.setExpirationTime(timeSpan);
        this.payload = payload;
        this.messageId = this.getGuidString();
    }

    public static TimeSpan getNoExpiration() {
        return noExpiration;
    }

    public final String getMessageId() {
        return this.messageId;
    }

    public final void setMessageId(String value) {
        this.messageId = value;
    }

    public final TimeSpan getExpirationTime() {
        return this.expirationTime;
    }

    public final void setExpirationTime(TimeSpan value) {
        this.expirationTime = value;
    }

    public final Object getPayload() {
        return this.payload;
    }

    public final void setSerializationDataInternal(PayloadDeserializer serializer, Object serializePayload) {
        this.payloadDeserializer = serializer;
        this.serializePayload = serializePayload;
    }

    public final <T> T getPayloadAsJson(Class<?> cls) throws OperationFailedException, JsonProcessingException {
        return this.payloadDeserializer.PayloadDeserializionJson(this.serializePayload, cls);
    }

    public final Date getCreationTime() {
        return this.creationTime;
    }

    public final void setCreationTime(Date value) {
        this.creationTime = value;
    }

    private String getGuidString() {
        String enc = ConvertorBase64.encodeBytes(UUID.randomUUID().toString().getBytes());
        enc = enc.replace("/", "_");
        enc = enc.replace("+", "-");
        return enc.substring(0, 22);
    }
}

