/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.caching;

import com.alachisoft.ncache.runtime.caching.ConnectivityStatus;
import java.net.InetAddress;

public class ClientInfo
implements Cloneable {
    private String appName;
    private String clientID;
    private InetAddress iPAddress;
    private String macAddress;
    private int cores;
    private String machineName;
    private int processID;
    private ConnectivityStatus status;
    private int clientVersion;

    public static ClientInfo tryParseLegacyClientID(String clientId) {
        String[] parameters = clientId.split("[:]", -1);
        if (parameters.length < 3) {
            return null;
        }
        ClientInfo info = new ClientInfo();
        info.setClientID(parameters[0]);
        info.setMachineName(parameters[1]);
        try {
            int processId = Integer.parseInt(parameters[2]);
            info.setProcessID(processId);
        }
        catch (NumberFormatException e) {
            return info;
        }
        return info;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String value) {
        this.appName = value;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String value) {
        this.clientID = value;
    }

    public InetAddress getIPAddress() {
        return this.iPAddress;
    }

    public void setIPAddress(InetAddress value) {
        this.iPAddress = value;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String value) {
        this.macAddress = value;
    }

    public int getCores() {
        return this.cores;
    }

    public void setCores(int value) {
        this.cores = value;
    }

    public int getProcessID() {
        return this.processID;
    }

    public void setProcessID(int value) {
        this.processID = value;
    }

    public String getMachineName() {
        return this.machineName;
    }

    public void setMachineName(String value) {
        this.machineName = value;
    }

    public ConnectivityStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConnectivityStatus value) {
        this.status = value;
    }

    public int getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(int value) {
        this.clientVersion = value;
    }

    public String toString() {
        return "Client ID: " + this.getClientID() + "\nApplication Name: " + this.getAppName() + "\nProcess ID: " + this.getProcessID() + "\nMachine Name: " + this.getMachineName() + "\nStatus: " + this.getStatus() + "\nAddress: " + this.getIPAddress() + "\nClient Version: " + this.getClientVersion();
    }

    public Object clone() {
        ClientInfo info = new ClientInfo();
        if (this.iPAddress != null) {
            info.setIPAddress(this.iPAddress);
        }
        info.setAppName(this.getAppName());
        info.setClientID(this.getClientID());
        info.setMachineName(this.getMachineName());
        info.setProcessID(this.getProcessID());
        info.setStatus(this.getStatus());
        info.setClientVersion(this.getClientVersion());
        return info;
    }
}

