/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.JSON;

import com.alachisoft.ncache.runtime.JSON.JsonArray;
import com.alachisoft.ncache.runtime.JSON.JsonDataType;
import com.alachisoft.ncache.runtime.JSON.JsonObject;
import com.alachisoft.ncache.runtime.JSON.JsonParser;
import com.alachisoft.ncache.runtime.JSON.JsonValue;
import com.alachisoft.ncache.runtime.errorhandling.ErrorMessages;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import tangible.RefObject;

public abstract class JsonValueBase
implements Serializable {
    private static JsonParser _jsonParser;
    private int _size;
    private int _inMemorySize;
    private JsonDataType _dataType;
    private Object _value;

    protected int getSize() {
        return this._size;
    }

    private void setSize(int value) {
        this._size = value;
    }

    protected int getInMemorySize() {
        return this._inMemorySize;
    }

    private void setInMemorySize(int value) {
        this._inMemorySize = value;
    }

    public JsonDataType getDataType() {
        return this._dataType;
    }

    private void setDataType(JsonDataType value) {
        this._dataType = value;
    }

    public Object getValue() {
        return this._value;
    }

    void setValue(Object value) {
        this._value = value;
    }

    protected JsonValueBase() {
        this(null, JsonDataType.Null);
    }

    protected JsonValueBase(Object value, JsonDataType dataType) {
        this.setValue(value);
        this.setDataType(dataType);
        int size = 0;
        int inMemorySize = 0;
        RefObject<Integer> tempRef_size = new RefObject<Integer>(size);
        RefObject<Integer> tempRef_inMemorySize = new RefObject<Integer>(inMemorySize);
        this.calculateSize(value, tempRef_size, tempRef_inMemorySize);
        size = (Integer)tempRef_size.argvalue;
        inMemorySize = (Integer)tempRef_inMemorySize.argvalue;
        this.setSize(size + 9);
        this.setInMemorySize(inMemorySize + 9 + 24);
    }

    private void calculateSize(Object value, RefObject<Integer> size, RefObject<Integer> inMemorySize) {
        size.argvalue = 0;
        inMemorySize.argvalue = 0;
        if (value == null) {
            return;
        }
        RefObject<Integer> refObject = inMemorySize;
        refObject.argvalue = (Integer)refObject.argvalue + 24;
        if (value.getClass().isPrimitive() || value.getClass() == Date.class) {
            int typeCodeSize = this.getTypeSize(value.getClass());
            RefObject<Integer> refObject2 = size;
            refObject2.argvalue = (Integer)refObject2.argvalue + typeCodeSize;
            refObject2 = inMemorySize;
            refObject2.argvalue = (Integer)refObject2.argvalue + typeCodeSize;
            return;
        }
        String possiblyString = (String)(value instanceof String ? value : null);
        if (possiblyString != null) {
            RefObject<Integer> refObject3 = size;
            refObject3.argvalue = (Integer)refObject3.argvalue + possiblyString.length() * 2;
            refObject3 = inMemorySize;
            refObject3.argvalue = (Integer)refObject3.argvalue + possiblyString.length() * 2;
            return;
        }
    }

    private int getTypeSize(Class<?> c) {
        if (c.isAssignableFrom(Boolean.TYPE) || c.isAssignableFrom(Byte.TYPE)) {
            return 1;
        }
        if (c.isAssignableFrom(Character.TYPE) || c.isAssignableFrom(Short.TYPE)) {
            return 2;
        }
        if (c.isAssignableFrom(Integer.TYPE) || c.isAssignableFrom(Float.TYPE)) {
            return 4;
        }
        if (c.isAssignableFrom(Long.TYPE) || c.isAssignableFrom(Double.TYPE) || c.isAssignableFrom(Date.class)) {
            return 8;
        }
        return 0;
    }

    public static JsonValueBase parse(String json) {
        if (json == null) {
            return null;
        }
        try {
            if (_jsonParser == null) {
                _jsonParser = new JsonParser();
            }
            _jsonParser.setJson(json);
            return _jsonParser.parse();
        }
        catch (OperationFailedException | IOException e) {
            throw new IllegalArgumentException("Invalid JSON string provided.", e);
        }
    }

    public static JsonValueBase parse(JsonObject jsonObject, String json) {
        if (json == null) {
            return null;
        }
        try {
            if (_jsonParser == null) {
                _jsonParser = new JsonParser(json);
            }
            _jsonParser.setJson(json);
            return _jsonParser.parse(jsonObject);
        }
        catch (OperationFailedException | IOException e) {
            throw new IllegalArgumentException("Invalid JSON string provided.", e);
        }
    }

    public static JsonValueBase parse(JsonArray jsonArray, String json) {
        if (json == null) {
            return null;
        }
        try {
            if (_jsonParser == null) {
                _jsonParser = new JsonParser(json);
            }
            _jsonParser.setJson(json);
            return _jsonParser.parse(jsonArray);
        }
        catch (OperationFailedException | IOException e) {
            throw new IllegalArgumentException("Invalid JSON string provided.", e);
        }
    }

    public static JsonValueBase parse(JsonValue jsonValue, String json) {
        if (json == null) {
            return null;
        }
        try {
            if (_jsonParser == null) {
                _jsonParser = new JsonParser(json);
            }
            _jsonParser.setJson(json);
            return _jsonParser.parse(jsonValue);
        }
        catch (OperationFailedException | IOException e) {
            throw new IllegalArgumentException("Invalid JSON string provided.", e);
        }
    }

    public String toJson() {
        return this.getValue() == null ? null : this.toString();
    }

    public void invalidateParentReference(Map<JsonValueBase, Byte> backRefs) throws OperationFailedException {
        if (backRefs == null) {
            backRefs = new HashMap<JsonValueBase, Byte>();
        }
        if (backRefs.containsKey(this)) {
            throw new OperationFailedException(22501, ErrorMessages.getErrorMessage(22501, new String[0]));
        }
        backRefs.put(this, (byte)0);
        switch (this.getDataType()) {
            case Object: {
                JsonObject jsonObject = (JsonObject)(this instanceof JsonObject ? this : null);
                if (jsonObject == null) {
                    return;
                }
                for (Map.Entry<String, JsonValueBase> attribute : jsonObject) {
                    attribute.getValue().invalidateParentReference(backRefs);
                }
                break;
            }
            case Array: {
                JsonArray jsonArray = (JsonArray)(this instanceof JsonArray ? this : null);
                if (jsonArray == null) {
                    return;
                }
                for (JsonValueBase item : jsonArray) {
                    item.invalidateParentReference(backRefs);
                }
                break;
            }
            default: {
                backRefs.remove(this);
            }
        }
    }
}

