/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime.JSON;

import java.math.BigDecimal;

public final class JsonUtil {
    public static <T> T getValueAs(Object value, Class<?> cls) {
        if (value == null || cls == null) {
            return (T)value;
        }
        if (cls.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        switch (cls.getName()) {
            case "java.lang.String": {
                return (T)value.toString();
            }
            case "java.math.BigDecimal": {
                return (T)new BigDecimal(value.toString());
            }
            case "java.lang.Double": {
                return (T)Double.valueOf(value.toString());
            }
            case "java.lang.Integer": {
                return (T)Integer.valueOf(value.toString());
            }
            case "java.lang.Long": {
                return (T)Double.valueOf(value.toString());
            }
            case "java.lang.Short": {
                return (T)Short.valueOf(value.toString());
            }
        }
        return (T)value;
    }
}

