/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.runtime;

public enum CacheItemPriority {
    Normal(0),
    Low(1),
    BelowNormal(2),
    AboveNormal(3),
    High(4),
    NotRemovable(5),
    Default(6);

    private final int value;

    private CacheItemPriority(int value) {
        this.value = value;
    }

    public static CacheItemPriority forValue(int value) {
        switch (value) {
            case 0: {
                return Normal;
            }
            case 1: {
                return Low;
            }
            case 2: {
                return BelowNormal;
            }
            case 3: {
                return AboveNormal;
            }
            case 4: {
                return High;
            }
            case 5: {
                return NotRemovable;
            }
            case 6: {
                return Default;
            }
        }
        return Default;
    }

    public int value() {
        return this.value;
    }

    public static CacheItemPriority getValueFromString(String value) {
        for (CacheItemPriority enumValue : CacheItemPriority.values()) {
            if (!enumValue.name().equalsIgnoreCase(value)) continue;
            return enumValue;
        }
        return Default;
    }
}

