"use strict";
var __esDecorate = (this && this.__esDecorate) || function (ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};
var __runInitializers = (this && this.__runInitializers) || function (thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessPoint = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const s3 = require("aws-cdk-lib/aws-s3");
const core = require("aws-cdk-lib/core");
const aws_s3objectlambda_1 = require("aws-cdk-lib/aws-s3objectlambda");
const metadata_resource_1 = require("aws-cdk-lib/core/lib/metadata-resource");
const prop_injectable_1 = require("aws-cdk-lib/core/lib/prop-injectable");
class AccessPointBase extends core.Resource {
    /** Implement the `IAccessPoint.domainName` field. */
    get domainName() {
        const urlSuffix = this.stack.urlSuffix;
        return `${this.accessPointName}-${this.env.account}.s3-object-lambda.${urlSuffix}`;
    }
    /** Implement the `IAccessPoint.regionalDomainName` field. */
    get regionalDomainName() {
        const urlSuffix = this.stack.urlSuffix;
        const region = this.env.region;
        return `${this.accessPointName}-${this.env.account}.s3-object-lambda.${region}.${urlSuffix}`;
    }
    /** Implement the `IAccessPoint.virtualHostedUrlForObject` method. */
    virtualHostedUrlForObject(key, options) {
        const domainName = options?.regional ?? true ? this.regionalDomainName : this.domainName;
        const prefix = `https://${domainName}`;
        if (!key) {
            return prefix;
        }
        if (key.startsWith('/')) {
            key = key.slice(1);
        }
        if (key.endsWith('/')) {
            key = key.slice(0, -1);
        }
        return `${prefix}/${key}`;
    }
}
/**
 * Checks the access point name against the rules in https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-access-points.html#access-points-names
 * @param name The name of the access point
 */
function validateAccessPointName(name) {
    if (name.length < 3 || name.length > 50) {
        throw new Error('Access point name must be between 3 and 50 characters long');
    }
    if (name.endsWith('-s3alias')) {
        throw new Error('Access point name cannot end with the suffix -s3alias');
    }
    if (name[0] === '-' || name[name.length - 1] === '-') {
        throw new Error('Access point name cannot begin or end with a dash');
    }
    if (!/^[0-9a-z](.(?![\.A-Z_]))+[0-9a-z]$/.test(name)) {
        throw new Error('Access point name must begin with a number or lowercase letter and not contain underscores, uppercase letters, or periods');
    }
}
/**
 * An S3 object lambda access point for intercepting and
 * transforming `GetObject` requests.
 */
let AccessPoint = (() => {
    let _classDecorators = [prop_injectable_1.propertyInjectable];
    let _classDescriptor;
    let _classExtraInitializers = [];
    let _classThis;
    let _classSuper = AccessPointBase;
    var AccessPoint = class extends _classSuper {
        static { _classThis = this; }
        static {
            const _metadata = typeof Symbol === "function" && Symbol.metadata ? Object.create(_classSuper[Symbol.metadata] ?? null) : void 0;
            __esDecorate(null, _classDescriptor = { value: _classThis }, _classDecorators, { kind: "class", name: _classThis.name, metadata: _metadata }, null, _classExtraInitializers);
            AccessPoint = _classThis = _classDescriptor.value;
            if (_metadata) Object.defineProperty(_classThis, Symbol.metadata, { enumerable: true, configurable: true, writable: true, value: _metadata });
        }
        static [JSII_RTTI_SYMBOL_1] = { fqn: "@aws-cdk/aws-s3objectlambda-alpha.AccessPoint", version: "2.224.0-alpha.0" };
        /** Uniquely identifies this class. */
        static PROPERTY_INJECTION_ID = '@aws-cdk.aws-s3objectlambda-alpha.AccessPoint';
        /**
         * Reference an existing AccessPoint defined outside of the CDK code.
         */
        static fromAccessPointAttributes(scope, id, attrs) {
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_s3objectlambda_alpha_AccessPointAttributes(attrs);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, this.fromAccessPointAttributes);
                }
                throw error;
            }
            const arn = core.Arn.split(attrs.accessPointArn, core.ArnFormat.SLASH_RESOURCE_NAME);
            if (!arn.resourceName) {
                throw new Error('Unable to parse access point name');
            }
            const name = arn.resourceName;
            class Import extends AccessPointBase {
                accessPointArn = attrs.accessPointArn;
                accessPointCreationDate = attrs.accessPointCreationDate;
                accessPointName = name;
            }
            return new Import(scope, id);
        }
        /**
         * The ARN of the access point.
         */
        accessPointName;
        /**
         * The ARN of the access point.
         * @attribute
         */
        accessPointArn;
        /**
         * The creation data of the access point.
         * @attribute
         */
        accessPointCreationDate;
        /**
         * The ARN of the S3 access point.
         */
        s3AccessPointArn;
        constructor(scope, id, props) {
            super(scope, id, {
                physicalName: props.accessPointName,
            });
            try {
                jsiiDeprecationWarnings._aws_cdk_aws_s3objectlambda_alpha_AccessPointProps(props);
            }
            catch (error) {
                if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                    Error.captureStackTrace(error, AccessPoint);
                }
                throw error;
            }
            // Enhanced CDK Analytics Telemetry
            (0, metadata_resource_1.addConstructMetadata)(this, props);
            if (props.accessPointName) {
                validateAccessPointName(props.accessPointName);
            }
            const supporting = new s3.CfnAccessPoint(this, 'SupportingAccessPoint', {
                bucket: props.bucket.bucketRef.bucketName,
            });
            const allowedFeatures = [];
            if (props.supportsGetObjectPartNumber) {
                allowedFeatures.push('GetObject-PartNumber');
            }
            if (props.supportsGetObjectRange) {
                allowedFeatures.push('GetObject-Range');
            }
            const accessPoint = new aws_s3objectlambda_1.CfnAccessPoint(this, id, {
                name: this.physicalName,
                objectLambdaConfiguration: {
                    allowedFeatures,
                    cloudWatchMetricsEnabled: props.cloudWatchMetricsEnabled,
                    supportingAccessPoint: supporting.attrArn,
                    transformationConfigurations: [
                        {
                            actions: ['GetObject'],
                            contentTransformation: {
                                AwsLambda: {
                                    FunctionArn: props.handler.functionArn,
                                    FunctionPayload: props.payload ? JSON.stringify(props.payload) : undefined,
                                },
                            },
                        },
                    ],
                },
            });
            this.s3AccessPointArn = supporting.attrArn;
            this.accessPointName = accessPoint.ref;
            this.accessPointArn = accessPoint.attrArn;
            this.accessPointCreationDate = accessPoint.attrCreationDate;
            props.handler.addToRolePolicy(new iam.PolicyStatement({
                actions: ['s3-object-lambda:WriteGetObjectResponse'],
                resources: ['*'],
            }));
        }
        static {
            __runInitializers(_classThis, _classExtraInitializers);
        }
    };
    return AccessPoint = _classThis;
})();
exports.AccessPoint = AccessPoint;
//# sourceMappingURL=data:application/json;base64,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