// Copyright (c) Mito
import React from 'react';
import { ActionEnum } from '../../types';
import Dropdown from '../elements/Dropdown';
import { makeToolbarDropdownItem } from './utils';
/**
 * Dropdown that displays the view options, which right now are just fullscreen
 * mode (but in the future might contain other options).
 */
const ToolbarViewDropdown = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(Dropdown, { display: props.uiState.currOpenToolbarDropdown === 'View', closeDropdown: () => props.setUIState((prevUIState) => {
                // Only close this dropdown if it's actually the one that is open, to avoid race conditions
                if (prevUIState.currOpenToolbarDropdown === 'View') {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenToolbarDropdown: undefined });
                }
                return prevUIState;
            }), width: 'medium' }, makeToolbarDropdownItem(props.actions[ActionEnum.Fullscreen]))));
};
export default ToolbarViewDropdown;
//# sourceMappingURL=ToolbarViewDropdown.js.map