import React, { useEffect, useState } from "react";
import { useInputValue } from "../../../hooks/useInputValue";
import { classNames } from "../../../utils/classNames";
import { checkProAccessCode } from "../../../utils/pro";
import Input from "../../elements/Input";
import TextButton from "../../elements/TextButton";
import Tooltip from "../../elements/Tooltip";
import PurpleCheckMark from "../../icons/PurpleCheckMark";
import Col from "../../spacing/Col";
import Row from "../../spacing/Row";
import Spacer from "../../spacing/Spacer";
import DefaultTaskpane from "../DefaultTaskpane/DefaultTaskpane";
import DefaultTaskpaneBody from "../DefaultTaskpane/DefaultTaskpaneBody";
import DefaultTaskpaneHeader from "../DefaultTaskpane/DefaultTaskpaneHeader";
const ProListElement = (props) => {
    return (React.createElement(Row, null,
        React.createElement(Col, { span: 2 },
            React.createElement(PurpleCheckMark, null)),
        React.createElement("p", { className: "text-body-1" }, props.text)));
};
/*
    This taskpane allows users to upgrade to pro, or tells them they
    are already upgraded (if they are).
*/
const UpgradeToProTaskpane = (props) => {
    const [isEnteringAccessCode, setIsEnteringAccessCode] = useState(false);
    const accessCodeInput = useInputValue('', 'mito-pro-access-code-ASKDJQWDKQWDLL');
    const [invalidAccessCode, setInvalidAccessCode] = useState(false);
    const isPro = props.userProfile.isPro;
    useEffect(() => {
        void props.mitoAPI.log('opened_upgrade_to_pro_taskpane');
    }, []);
    if (!isPro && !isEnteringAccessCode) {
        return (React.createElement(DefaultTaskpane, null,
            React.createElement(DefaultTaskpaneHeader, { header: "Upgrade to Mito Pro", setUIState: props.setUIState }),
            React.createElement(DefaultTaskpaneBody, null,
                React.createElement("p", { className: "text-body-1 mb-10px" },
                    React.createElement("a", { href: 'https://trymito.io/plans', target: '_blank', rel: "noreferrer" },
                        React.createElement("span", { className: 'text-body-1-link' }, "Mito Pro")),
                    " gives you extra features to super charge your analysis:"),
                React.createElement(ProListElement, { text: "Turn off all telemetry" }),
                React.createElement(ProListElement, { text: "Generated code optimization" }),
                React.createElement(ProListElement, { text: "Import from external drives" }),
                React.createElement(ProListElement, { text: "Style graphs" }),
                React.createElement(ProListElement, { text: "Export formatting" }),
                React.createElement(ProListElement, { text: "Priority support" }),
                React.createElement(ProListElement, { text: "All future pro functionality!" }),
                React.createElement("div", { className: "mt-25px" },
                    React.createElement(Row, { justify: "space-around" },
                        React.createElement("form", { className: 'element-width-block', action: "https://jl76z192i0.execute-api.us-east-1.amazonaws.com/Prod/create_checkout_session/", method: "POST", target: "_blank" },
                            React.createElement("button", { className: classNames('text-button', 'text-header-3', 'text-overflow-wrap', 'element-width-block', 'text-button-variant-dark'), type: "submit", onClick: () => {
                                    void props.mitoAPI.log('clicked_purchase_mito_pro');
                                    // A little hack to make sure the post is sent before we move to the next page
                                    setTimeout(() => setIsEnteringAccessCode(true), 100);
                                } }, "Purchase Mito Pro"))),
                    React.createElement(Row, { justify: "space-around", className: "mb-5px mt-5px" },
                        React.createElement("p", { className: "text-body-1" }, "Or")),
                    React.createElement(Row, { justify: "space-around" },
                        React.createElement(TextButton, { variant: 'dark', onClick: () => { setIsEnteringAccessCode(true); } }, "Enter Access Code"))))));
    }
    else if (!isPro && isEnteringAccessCode) {
        return (React.createElement(DefaultTaskpane, null,
            React.createElement(DefaultTaskpaneHeader, { header: "Enter Access Code", setUIState: props.setUIState }),
            React.createElement(DefaultTaskpaneBody, null,
                React.createElement(Row, { align: "center" },
                    React.createElement(Col, { span: 5 },
                        React.createElement("p", { className: "text-heading-2" }, "Access Code:")),
                    React.createElement(Col, { span: 2 },
                        React.createElement(Tooltip, { title: "Get an access code by purchasing a Pro license on the previous page." }))),
                React.createElement(Input, Object.assign({}, accessCodeInput)),
                invalidAccessCode &&
                    React.createElement("div", { className: "text-color-error" }, "Sorry, that access code is invalid. Purchase Mito Pro from the previous page and then enter the access code here."),
                React.createElement(Spacer, { px: 20 }),
                React.createElement(Row, { justify: "space-around" },
                    React.createElement(Col, null,
                        React.createElement(TextButton, { variant: 'light', onClick: () => { setIsEnteringAccessCode(false); } }, "Back")),
                    React.createElement(Col, null,
                        React.createElement(TextButton, { variant: 'dark', onClick: async () => {
                                if (!checkProAccessCode(accessCodeInput.value)) {
                                    setInvalidAccessCode(true);
                                    return;
                                }
                                setInvalidAccessCode(false);
                                await props.mitoAPI.log('signup_completed_pro', { 'location': 'upgrade_to_pro_taskpane' });
                                await props.mitoAPI.updateGoPro();
                                setIsEnteringAccessCode(false);
                            } }, "Submit Access Code"))))));
    }
    else {
        return (React.createElement(DefaultTaskpane, null,
            React.createElement(DefaultTaskpaneHeader, { header: "Welcome to Mito Pro!", setUIState: props.setUIState }),
            React.createElement(DefaultTaskpaneBody, null,
                React.createElement("p", { className: "text-heading-4 mb-10px" }, "You've successfully upgraded to Mito Pro. You can cancel any time by sending us an email."),
                React.createElement(ProListElement, { text: "All telemetry is off" }),
                React.createElement(ProListElement, { text: "Generated code is being optimized" }),
                React.createElement(ProListElement, { text: "Style graphs" }),
                React.createElement(ProListElement, { text: "Export formatting" }),
                React.createElement(ProListElement, { text: "Get priority support" }),
                React.createElement(ProListElement, { text: "All future pro functionality!" }))));
    }
};
export default UpgradeToProTaskpane;
//# sourceMappingURL=UpgradeToProTaskpane.js.map