// Copyright (c) Mito
import React from 'react';
import PivotTableValueAggregationCard from './PivotTableValueAggregationCard';
import PivotInvalidSelectedColumnsError from './PivotInvalidSelectedColumnsError';
import DropdownButton from '../../elements/DropdownButton';
import Row from '../../spacing/Row';
import Col from '../../spacing/Col';
import DropdownItem from '../../elements/DropdownItem';
import { getDisplayColumnHeader } from '../../../utils/columnHeaders';
/*
  A custom component used in the pivot table which lets the
  user select column headers to add to the row or column keys
*/
const PivotTableValueSelection = (props) => {
    return (React.createElement("div", null,
        React.createElement(Row, { justify: 'space-between', align: 'center' },
            React.createElement(Col, null,
                React.createElement("p", { className: 'text-header-3' }, "Values")),
            React.createElement(Col, null,
                React.createElement(DropdownButton, { text: '+ Add', width: 'small', searchable: true }, Object.entries(props.columnIDsMap).map(([columnID, columnHeader]) => {
                    return (React.createElement(DropdownItem, { key: columnID, title: getDisplayColumnHeader(columnHeader), onClick: () => {
                            props.addPivotValueAggregation(columnID);
                        } }));
                })))),
        React.createElement(PivotInvalidSelectedColumnsError, { columnIDsMap: props.columnIDsMap, pivotSection: 'values', selectedColumnIDs: props.pivotValuesColumnIDsArray.map(([columnID,]) => columnID), mitoAPI: props.mitoAPI }),
        props.pivotValuesColumnIDsArray.map(([columnID, aggregationType], valueIndex) => {
            var _a;
            const columnDtype = ((_a = props.sheetData) === null || _a === void 0 ? void 0 : _a.columnDtypeMap[columnID]) || '';
            return (React.createElement(PivotTableValueAggregationCard, { key: columnID + valueIndex + aggregationType, columnIDsMap: props.columnIDsMap, columnID: columnID, columnDtype: columnDtype, aggregationType: aggregationType, removePivotValueAggregation: () => {
                    props.removePivotValueAggregation(valueIndex);
                }, editPivotValueAggregation: (newAggregationType, newColumnID) => {
                    props.editPivotValueAggregation(valueIndex, newAggregationType, newColumnID);
                } }));
        })));
};
export default PivotTableValueSelection;
//# sourceMappingURL=PivotTableValueSelection.js.map