import React from "react";
import { getDisplayColumnHeader } from "../../../utils/columnHeaders";
import DropdownItem from "../../elements/DropdownItem";
import Select from "../../elements/Select";
import TextButton from "../../elements/TextButton";
import XIcon from "../../icons/XIcon";
import Col from "../../spacing/Col";
import Row from "../../spacing/Row";
import Spacer from "../../spacing/Spacer";
import { getFirstSuggestedMergeKeys } from "./mergeUtils";
const MergeKeysSelectionSection = (props) => {
    const sheetDataOne = props.sheetDataArray[props.params.sheet_index_one];
    const sheetDataTwo = props.sheetDataArray[props.params.sheet_index_two];
    const noPossibleMergeKeys = Object.keys((sheetDataOne === null || sheetDataOne === void 0 ? void 0 : sheetDataOne.columnDtypeMap) || {}).length === 0 || Object.keys((sheetDataTwo === null || sheetDataTwo === void 0 ? void 0 : sheetDataTwo.columnDtypeMap) || {}).length === 0;
    return (React.createElement("div", { className: "light-gray-container" },
        React.createElement(Row, { suppressTopBottomMargin: true },
            React.createElement(Col, null,
                React.createElement("p", { className: "text-header-3" }, "Match rows where:"))),
        props.params.merge_key_column_ids.map(([mergeKeyColumnIDOne, mergeKeyColumnIDTwo], index) => {
            return (React.createElement(Row, { key: index, justify: "space-between", align: "center" },
                React.createElement(Col, null,
                    React.createElement(Select, { value: mergeKeyColumnIDOne, onChange: (columnID) => {
                            props.setParams(prevParams => {
                                const newMergeKeys = [...prevParams.merge_key_column_ids];
                                newMergeKeys[index][0] = columnID;
                                return Object.assign(Object.assign({}, prevParams), { merge_key_column_ids: newMergeKeys });
                            });
                        }, width: 'medium', searchable: true }, Object.entries((sheetDataOne === null || sheetDataOne === void 0 ? void 0 : sheetDataOne.columnIDsMap) || {}).map(([columnID, columnHeader]) => {
                        return (React.createElement(DropdownItem, { key: columnID, id: columnID, title: getDisplayColumnHeader(columnHeader) }));
                    }))),
                React.createElement(Col, { className: "text-header-3" }, "="),
                React.createElement(Col, null,
                    React.createElement(Select, { value: mergeKeyColumnIDTwo, onChange: (columnID) => {
                            props.setParams(prevParams => {
                                const newMergeKeys = [...prevParams.merge_key_column_ids];
                                newMergeKeys[index][1] = columnID;
                                return Object.assign(Object.assign({}, prevParams), { merge_key_column_ids: newMergeKeys });
                            });
                        }, width: 'medium', searchable: true }, Object.entries((sheetDataTwo === null || sheetDataTwo === void 0 ? void 0 : sheetDataTwo.columnIDsMap) || {}).map(([columnID, columnHeader]) => {
                        return (React.createElement(DropdownItem, { key: columnID, id: columnID, title: getDisplayColumnHeader(columnHeader) }));
                    }))),
                React.createElement(Col, null,
                    React.createElement(XIcon, { onClick: () => {
                            props.setParams(prevParams => {
                                const newMergeKeys = [...prevParams.merge_key_column_ids];
                                newMergeKeys.splice(index, 1);
                                return Object.assign(Object.assign({}, prevParams), { merge_key_column_ids: newMergeKeys });
                            });
                        } }))));
        }),
        props.error !== undefined &&
            React.createElement("p", { className: 'text-color-error' }, props.error),
        React.createElement(Spacer, { px: 15 }),
        React.createElement(TextButton, { width: "medium", variant: "dark", onClick: () => {
                props.setParams(prevParams => {
                    const newMergeKeys = [...prevParams.merge_key_column_ids];
                    const newSuggestedMergeKeys = getFirstSuggestedMergeKeys(props.sheetDataArray, props.params.sheet_index_one, props.params.sheet_index_two, props.params.merge_key_column_ids);
                    if (newSuggestedMergeKeys) {
                        newMergeKeys.push(newSuggestedMergeKeys);
                    }
                    return Object.assign(Object.assign({}, prevParams), { merge_key_column_ids: newMergeKeys });
                });
            }, disabled: noPossibleMergeKeys, disabledTooltip: 'One of these dataframes has no columns, so no merge keys can be added.' }, "+ Add Merge Keys")));
};
export default MergeKeysSelectionSection;
//# sourceMappingURL=MergeKeysSelection.js.map