// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
import React from 'react';
import useSendEditOnClick from '../../../hooks/useSendEditOnClick';
import { StepType } from '../../../types';
import { getDisplayColumnHeader } from '../../../utils/columnHeaders';
import DataframeSelect from '../../elements/DataframeSelect';
import DropdownItem from '../../elements/DropdownItem';
import MultiToggleBox from '../../elements/MultiToggleBox';
import MultiToggleItem from '../../elements/MultiToggleItem';
import Select from '../../elements/Select';
import TextButton from '../../elements/TextButton';
import Col from '../../spacing/Col';
import Row from '../../spacing/Row';
import Spacer from '../../spacing/Spacer';
import DefaultEmptyTaskpane from '../DefaultTaskpane/DefaultEmptyTaskpane';
import DefaultTaskpane from '../DefaultTaskpane/DefaultTaskpane';
import DefaultTaskpaneBody from '../DefaultTaskpane/DefaultTaskpaneBody';
import DefaultTaskpaneHeader from '../DefaultTaskpane/DefaultTaskpaneHeader';
import { TaskpaneType } from '../taskpanes';
export const getDefaultParams = (selectedSheetIndex, sheetDataArray) => {
    var _a;
    if (sheetDataArray.length === 0) {
        return undefined;
    }
    return {
        sheet_index: selectedSheetIndex,
        column_ids: Object.keys((_a = sheetDataArray[selectedSheetIndex]) === null || _a === void 0 ? void 0 : _a.columnIDsMap),
        keep: 'first',
    };
};
/*
    A taskpane that allows a user to drop duplicates
    in a sheet
*/
const DropDuplicatesTaskpane = (props) => {
    var _a;
    const { params, setParams, loading, edit, editApplied, attemptedEditWithTheseParamsMultipleTimes, result } = useSendEditOnClick(() => getDefaultParams(props.selectedSheetIndex, props.sheetDataArray), StepType.DropDuplicates, props.mitoAPI, props.analysisData);
    if (props.sheetDataArray.length === 0 || params === undefined) {
        return React.createElement(DefaultEmptyTaskpane, { setUIState: props.setUIState });
    }
    /*
        If the sheetDataArray doesn't contain params.sheet_index,
        just close the taskpane to avoid a sheet crashing bug.
        
        TODO: We should handle this in useLiveUpdatingParams to so we can move
        closer to not having to write any custom code for this step.
    */
    if (props.sheetDataArray[params.sheet_index] === undefined) {
        props.setUIState((prevUIState) => {
            return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.NONE } });
        });
        // Return the defaut taskpane while the taskpane is closing
        return React.createElement(DefaultEmptyTaskpane, { setUIState: props.setUIState });
    }
    const columnIDsAndHeaders = ((_a = props.sheetDataArray[params.sheet_index]) === null || _a === void 0 ? void 0 : _a.data.map(c => [c.columnID, c.columnHeader])) || [];
    return (React.createElement(DefaultTaskpane, null,
        React.createElement(DefaultTaskpaneHeader, { header: 'Drop Duplicates', setUIState: props.setUIState }),
        React.createElement(DefaultTaskpaneBody, null,
            React.createElement(DataframeSelect, { title: 'Dataframe to drop duplicates within.', sheetDataArray: props.sheetDataArray, sheetIndex: params.sheet_index, onChange: (newSheetIndex) => {
                    setParams(dropDuplicateParams => {
                        return Object.assign(Object.assign({}, dropDuplicateParams), { sheet_index: newSheetIndex, column_ids: props.sheetDataArray[newSheetIndex].data.map(c => c.columnID) });
                    });
                    props.setUIState(prevUIState => {
                        return Object.assign(Object.assign({}, prevUIState), { selectedSheetIndex: newSheetIndex });
                    });
                } }),
            React.createElement(Row, { justify: 'space-between', align: 'center' },
                React.createElement(Col, null,
                    React.createElement("p", { className: 'text-header-3' }, "Duplicates to Keep")),
                React.createElement(Col, null,
                    React.createElement(Select, { width: 'medium', value: params.keep + '', onChange: (newKeep) => {
                            if (newKeep === 'false') {
                                newKeep = false;
                            }
                            setParams(dropDuplicateParams => {
                                return Object.assign(Object.assign({}, dropDuplicateParams), { keep: newKeep });
                            });
                        } },
                        React.createElement(DropdownItem, { title: 'first', subtext: 'Keep the first instance of the duplicated row.' }),
                        React.createElement(DropdownItem, { title: 'last', subtext: 'Keep the last instance of the duplicated row.' }),
                        React.createElement(DropdownItem, { id: 'false', title: 'none', subtext: 'Keep none of the duplicated rows.' })))),
            React.createElement("p", { className: 'text-header-3 mt-10px' }, "Columns to Deduplicate On"),
            React.createElement(MultiToggleBox, { searchable: true, toggleAllIndexes: (indexesToToggle, newToggle) => {
                    const columnIDsToToggle = indexesToToggle.map(index => columnIDsAndHeaders[index][0]);
                    setParams(oldDropDuplicateParams => {
                        const newSelectedColumnIDs = [...oldDropDuplicateParams.column_ids];
                        columnIDsToToggle.forEach(columnID => {
                            if (newToggle) {
                                if (!newSelectedColumnIDs.includes(columnID)) {
                                    newSelectedColumnIDs.push(columnID);
                                }
                            }
                            else {
                                if (newSelectedColumnIDs.includes(columnID)) {
                                    newSelectedColumnIDs.splice(newSelectedColumnIDs.indexOf(columnID), 1);
                                }
                            }
                        });
                        return Object.assign(Object.assign({}, oldDropDuplicateParams), { column_ids: newSelectedColumnIDs });
                    });
                }, height: 'large' }, columnIDsAndHeaders.map(([columnID, columnHeader], index) => {
                return (React.createElement(MultiToggleItem, { key: index, title: getDisplayColumnHeader(columnHeader), toggled: params.column_ids.includes(columnID), index: index, onToggle: () => {
                        setParams(oldDropDuplicateParams => {
                            const newSelectedColumnIDs = [...oldDropDuplicateParams.column_ids];
                            if (!newSelectedColumnIDs.includes(columnID)) {
                                newSelectedColumnIDs.push(columnID);
                            }
                            else {
                                newSelectedColumnIDs.splice(newSelectedColumnIDs.indexOf(columnID), 1);
                            }
                            return Object.assign(Object.assign({}, oldDropDuplicateParams), { column_ids: newSelectedColumnIDs });
                        });
                    } }));
            })),
            React.createElement(Spacer, { px: 25 }),
            React.createElement(TextButton, { variant: 'dark', width: 'block', onClick: () => edit(), disabled: false }, !loading
                ? `Drop duplicates in ${params.column_ids.length} columns`
                : 'Dropping duplicates...'),
            editApplied && !loading &&
                React.createElement(Row, { className: 'mt-5' },
                    React.createElement("p", { className: 'text-subtext-1' },
                        "Removed ",
                        React.createElement("span", { className: 'text-color-gray-important' }, !attemptedEditWithTheseParamsMultipleTimes ? (result === null || result === void 0 ? void 0 : result.num_rows_dropped) || 0 : 0),
                        " rows.")))));
};
export default DropDuplicatesTaskpane;
//# sourceMappingURL=DropDuplicates.js.map