import React from "react";
import DataframeSelect from "../../elements/DataframeSelect";
import Row from "../../spacing/Row";
const CSVDownloadConfigSection = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(DataframeSelect, { title: 'Dataframe to Export', sheetDataArray: props.sheetDataArray, sheetIndex: props.selectedSheetIndex, onChange: (newSheetIndex) => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { selectedSheetIndex: newSheetIndex, exportConfiguration: { exportType: 'csv' } });
                });
            } }),
        React.createElement(Row, { justify: 'space-around' },
            React.createElement("p", { className: 'ma-25px text-align-center' }, "CSV exports will not reflect any formatting changes made in Mito."))));
};
export default CSVDownloadConfigSection;
//# sourceMappingURL=CSVDownloadConfigSection.js.map