// Copyright (c) Saga Inc.
import React, { useEffect } from 'react';
import { isNumberDtype } from '../../utils/dtypes';
import Dropdown from '../elements/Dropdown';
import DropdownItem from '../elements/DropdownItem';
import DropdownSectionSeperator from '../elements/DropdownSectionSeperator';
import { ControlPanelTab } from '../taskpanes/ControlPanel/ControlPanelTaskpane';
import { TaskpaneType } from '../taskpanes/taskpanes';
import { getColumnIndexesInSelections } from './selectionUtils';
import { getCellDataFromCellIndexes } from './utils';
/*
    Displays a set of actions one can perform on a column header
*/
export default function ColumnHeaderDropdown(props) {
    // Log opening this dropdown
    useEffect(() => {
        if (props.display) {
            void props.mitoAPI.log('opened_column_header_dropdown');
        }
    }, [props.display]);
    // If the user interacts with the column header dropdown, we always default to 
    // selecting the first row for any action, like setting the column formula. 
    const rowIndex = 0;
    const columnIndex = Object.keys(props.sheetData.columnIDsMap).indexOf(props.columnID);
    return (React.createElement(Dropdown, { display: props.display, closeDropdown: () => props.setOpenColumnHeaderDropdown(false), width: 'medium' },
        React.createElement(DropdownItem, { title: 'Delete Column', onClick: () => {
                props.closeOpenEditingPopups();
                const columnIndexesSelected = getColumnIndexesInSelections(props.gridState.selections);
                const columnIDsToDelete = columnIndexesSelected.map(colIdx => { var _a, _b; return ((_b = (_a = props.sheetData) === null || _a === void 0 ? void 0 : _a.data[colIdx]) === null || _b === void 0 ? void 0 : _b.columnID) || ''; }).filter(columnID => columnID !== '');
                void props.mitoAPI.editDeleteColumn(props.sheetIndex, columnIDsToDelete);
            } }),
        React.createElement(DropdownItem, { title: 'Rename Column', onClick: () => {
                props.openColumnHeaderEditor();
            }, supressFocusSettingOnClose: true }),
        React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
        React.createElement(DropdownItem, { title: 'Filter', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.CONTROL_PANEL }, selectedColumnControlPanelTab: ControlPanelTab.FilterSort });
                });
            } }),
        React.createElement(DropdownItem, { title: 'Sort', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.CONTROL_PANEL }, selectedColumnControlPanelTab: ControlPanelTab.FilterSort });
                });
            } }),
        React.createElement(DropdownItem, { title: 'Change Dtype', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.CONTROL_PANEL }, selectedColumnControlPanelTab: ControlPanelTab.FilterSort });
                });
            } }),
        React.createElement(DropdownItem, { title: 'Fill NaN Values', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.FILL_NA, startingColumnIDs: [props.columnID] } });
                });
            } }),
        React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
        React.createElement(DropdownItem, { title: 'Format', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.CONTROL_PANEL }, selectedColumnControlPanelTab: ControlPanelTab.FilterSort });
                });
            }, disabled: !isNumberDtype(props.columnDtype), tooltip: !isNumberDtype(props.columnDtype) ? "Only number columns can be formatted currently" : undefined }),
        React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
        React.createElement(DropdownItem, { title: 'Set Column Formula', onClick: () => {
                const columnFormula = getCellDataFromCellIndexes(props.sheetData, rowIndex, columnIndex).columnFormula;
                props.setEditorState({
                    rowIndex: 0,
                    columnIndex: columnIndex,
                    formula: columnFormula !== undefined ? columnFormula : '',
                    // As in google sheets, if the starting formula is non empty, we default to the 
                    // arrow keys scrolling in the editor
                    arrowKeysScrollInFormula: columnFormula !== undefined && columnFormula.length > 0,
                    editorLocation: 'cell',
                    editingMode: 'set_column_formula'
                });
            }, supressFocusSettingOnClose: true }),
        React.createElement(DropdownItem, { title: 'Split Text to Columns ', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: { type: TaskpaneType.SPLIT_TEXT_TO_COLUMNS, startingColumnID: props.columnID } });
                });
            } }),
        React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
        React.createElement(DropdownItem, { title: 'View Unique Values', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: {
                            type: TaskpaneType.CONTROL_PANEL,
                        }, selectedColumnControlPanelTab: ControlPanelTab.UniqueValues });
                });
            } }),
        React.createElement(DropdownItem, { title: 'View Summary Stats', onClick: () => {
                props.setUIState(prevUIState => {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenTaskpane: {
                            type: TaskpaneType.CONTROL_PANEL,
                        }, selectedColumnControlPanelTab: ControlPanelTab.SummaryStats });
                });
            } })));
}
//# sourceMappingURL=ColumnHeaderDropdown.js.map