"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Import necessary packages
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
class SecureBucket extends constructs_1.Construct {
    // Optional allow pass of bucket props
    constructor(scope, id, props) {
        super(scope, id);
        // Overrule Bucket Props with secure defaults and make them mandatory
        let newProps = {
            ...props,
            // Force encryption to use a Custom Managed Key
            encryption: props && props.encryption && props.encryption != aws_s3_1.BucketEncryption.UNENCRYPTED
                ? props.encryption
                : aws_s3_1.BucketEncryption.KMS,
            // Create the Encryption Key, with Rotation enabled
            encryptionKey: new aws_kms_1.Key(this, `${id}-key`, { enableKeyRotation: true }),
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            versioned: true,
            enforceSSL: true,
            accessControl: aws_s3_1.BucketAccessControl.LOG_DELIVERY_WRITE,
            serverAccessLogsPrefix: 'access-logs',
        };
        // Create actual bucket
        this.bucket = new aws_s3_1.Bucket(this, `${id}-bucket`, newProps);
    }
}
exports.SecureBucket = SecureBucket;
_a = JSII_RTTI_SYMBOL_1;
SecureBucket[_a] = { fqn: "secure_bucket_construct.SecureBucket", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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