/*
 * Definitions for libfsext
 *
 * Copyright (C) 2010-2021, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFSEXT_DEFINITIONS_H )
#define _LIBFSEXT_DEFINITIONS_H

#include <libfsext/types.h>

#define LIBFSEXT_VERSION			20210721

/* The version string
 */
#define LIBFSEXT_VERSION_STRING			"20210721"

/* The file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBFSEXT_ACCESS_FLAGS
{
	LIBFSEXT_ACCESS_FLAG_READ		= 0x01,
/* Reserved: not supported yet */
	LIBFSEXT_ACCESS_FLAG_WRITE		= 0x02
};

/* The file access macros
 */
#define LIBFSEXT_OPEN_READ			( LIBFSEXT_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBFSEXT_OPEN_WRITE			( LIBFSEXT_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBFSEXT_OPEN_READ_WRITE		( LIBFSEXT_ACCESS_FLAG_READ | LIBFSEXT_ACCESS_FLAG_WRITE )

/* The path segment separator
 */
#define LIBFSEXT_SEPARATOR			'/'

/* The file types
 */
enum LIBFSEXT_FILE_TYPES
{
	LIBFSEXT_FILE_TYPE_FIFO			= 0x1000,
	LIBFSEXT_FILE_TYPE_CHARACTER_DEVICE	= 0x2000,
	LIBFSEXT_FILE_TYPE_DIRECTORY		= 0x4000,
	LIBFSEXT_FILE_TYPE_BLOCK_DEVICE		= 0x6000,
	LIBFSEXT_FILE_TYPE_REGULAR_FILE		= 0x8000,
	LIBFSEXT_FILE_TYPE_SYMBOLIC_LINK	= 0xa000,
	LIBFSEXT_FILE_TYPE_SOCKET		= 0xc000
};

/* The extent flag definitions
 */
enum LIBFSEXT_EXTENT_FLAGS
{
	/* The extent is sparse
	 */
	LIBFSEXT_EXTENT_FLAG_IS_SPARSE		= 0x00000001UL
};

#endif /* !defined( _LIBFSEXT_DEFINITIONS_H ) */

