# Pytrad: Causal Discovery for Python

Pytrad is an open-source causal discovery library for Python, which is a Python translation and extension of [Tetrad](https://github.com/cmu-phil/tetrad).

The package is on its very first version and we are actively developing it. Please, as a beta user, if you are willing, would you please kindly share any feedbacks (issues, suggestions, etc.) about it with us?

# Package Overview

Our Pytrad implements methods for causal discovery:

* Constrained-based causal discovery methods.
* Score-based causal discovery methods.
* Causal discovery methods based on constrained functional causal models.
* Hidden causal representation learning.
* Granger causality.
* Multiple utilities for building your own method, such as independence tests, score functions, graph operations, and evaluations.

# Install

Pytrad needs the following packages to be installed beforehand:

* python 3
* numpy
* networkx
* pandas
* scipy
* scikit-learn
* statsmodels
* pydot

(For visualization)

* matplotlib
* graphviz

To use Pytrad, we could install it using [pip](https://pypi.org/project/sqlparse/):

```
pip install pytrad
```

# Documentation

Please kindly refer to [Pytrad Doc](https://pytrad-docs.readthedocs.io/en/latest/) for detailed tutorials and usages.
