# Timecard

**Track time beautifully.**

Timecard allows you to track how much time you spend on tasks.
It offers a clean, responsive one-window interface that allows you to
quickly configure your time tracking, and then hides away in the system tray
until you need it again.

## Features

* Start and pause time tracking from application window or system tray.
* Stop timer and save to log with activity notes.
* View, sort, and edit time log entries.
* Customizable time log path.
* Hides to system tray.
* Quit protection helps prevent accidentally closing while tracking time.

## Installation

This can be installed a number of ways.

### PyPI

You can install directly via `pip` using the following command:

```bash
pip install Timecard-App
```

If you're installing outside of a virtual environment, use the following:

```bash
pip install --user Timecard-App
```

Then, you can start the program with just:

```bash
timecard-app
```

## Usage

Using Timecard is simple!

1. Press "Start" to start tracking time.
2. Press "Stop" and "Confirm Stop" to stop your running timer.
3. Enter activity notes for your session in "WHat are you doing?"
4. Press "Save" to save the time log entry.

If you close the window, Timecard will stay running in the system tray.
Click the system tray icon and press "Show/Hide Window" to restore the
window.

To quit, press the Quit button on the lower-right corner of the window,
and then press "Quit" at the prompt. If there is no time running or pending
save, you can also click "Quit" from the system tray icon menu.

## Future Features

* Pomodoro features.
* Alarms and reminders.

## History

Timecard 1.0 was the first application ever released by developer and author
Jason C. McDonald, built in Visual Basic .NET 2010, and released through
the then newly founded MousePaw Games.

This is a resurrection of that project. It offers the same core functionality
as the original, but in an improved interface. Unlike its predecessor,
Timecard 2.0 is portable and completely open source.

## Donate

Like what you see? Sponsor me on [GitHub](https://github.com/codemouse92/timecard) or [Buy Me A Coffee!](https://www.buymeacoffee.com/CodeMouse92).

## Contributing

Bug reports and pull requests are welcome via
[GitHub](https://github.com/codemouse92/timecard)!

## License

Timecard 2.0 is licensed under the BSD-3-Clause license (see `LICENSE`).
