"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestStack = exports.testFixtureCluster = exports.testFixtureNoVpc = exports.testFixture = void 0;
const ec2 = require("@aws-cdk/aws-ec2");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
function testFixture() {
    const { stack, app } = testFixtureNoVpc();
    const vpc = new ec2.Vpc(stack, 'VPC');
    return { stack, vpc, app };
}
exports.testFixture = testFixture;
function testFixtureNoVpc() {
    const app = new core_1.App();
    const stack = new core_1.Stack(app, 'Stack', { env: { region: 'us-east-1' } });
    return { stack, app };
}
exports.testFixtureNoVpc = testFixtureNoVpc;
function testFixtureCluster() {
    const { stack, app } = testFixtureNoVpc();
    const cluster = new lib_1.Cluster(stack, 'Cluster');
    return { stack, app, cluster };
}
exports.testFixtureCluster = testFixtureCluster;
// we must specify an explicit environment because we have an AMI map that is
// keyed from the target region.
const env = {
    region: process.env.CDK_INTEG_REGION || process.env.CDK_DEFAULT_REGION,
    account: process.env.CDK_INTEG_ACCOUNT || process.env.CDK_DEFAULT_ACCOUNT,
};
class TestStack extends core_1.Stack {
    constructor(scope, id) {
        super(scope, id, { env });
    }
}
exports.TestStack = TestStack;
//# sourceMappingURL=data:application/json;base64,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