# Generated by Django 3.2.7 on 2022-04-23 09:54

from django.db import migrations, models
import django.db.models.deletion
import django_sso.sso_gateway.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=128, verbose_name='Name')),
                ('base_url', models.URLField(verbose_name='Base url')),
                ('enabled', models.BooleanField(default=False, verbose_name='Enabled')),
                ('token', models.CharField(default=django_sso.sso_gateway.models.service_token_generator, max_length=128, unique=True, verbose_name='Token')),
            ],
            options={
                'verbose_name': 'Subordinated service',
                'verbose_name_plural': 'Subordinated services',
            },
        ),
        migrations.CreateModel(
            name='AuthenticationRequest',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('token', models.CharField(default=django_sso.sso_gateway.models.auth_token_generator, max_length=128, unique=True, verbose_name='Token')),
                ('user_identy', models.CharField(help_text='E-Mail, login, etc.', max_length=128, verbose_name='User identy')),
                ('next_url', models.CharField(help_text='To go after success auth', max_length=512, verbose_name='Next url')),
                ('authenticated', models.BooleanField(default=False, verbose_name='Request has been activated')),
                ('used', models.BooleanField(default=False, verbose_name='Are used in external sso_service')),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='sso_gateway.service', verbose_name='Service')),
            ],
            options={
                'verbose_name': 'Authentication request',
                'verbose_name_plural': 'Authentication requests',
            },
        ),
    ]
