# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AutoScalingGroupInstancesDistribution',
    'AutoScalingGroupLaunchTemplate',
    'AutoScalingGroupLaunchTemplateOverrides',
    'AutoScalingGroupLaunchTemplateSpecification',
    'AutoScalingGroupLifecycleHookSpecification',
    'AutoScalingGroupMetricsCollection',
    'AutoScalingGroupMixedInstancesPolicy',
    'AutoScalingGroupNotificationConfiguration',
    'AutoScalingGroupTagProperty',
    'LaunchConfigurationBlockDevice',
    'LaunchConfigurationBlockDeviceMapping',
    'LaunchConfigurationMetadataOptions',
    'ScalingPolicyCustomizedMetricSpecification',
    'ScalingPolicyMetricDimension',
    'ScalingPolicyPredefinedMetricSpecification',
    'ScalingPolicyPredictiveScalingConfiguration',
    'ScalingPolicyPredictiveScalingMetricSpecification',
    'ScalingPolicyPredictiveScalingPredefinedLoadMetric',
    'ScalingPolicyPredictiveScalingPredefinedMetricPair',
    'ScalingPolicyPredictiveScalingPredefinedScalingMetric',
    'ScalingPolicyStepAdjustment',
    'ScalingPolicyTargetTrackingConfiguration',
]

@pulumi.output_type
class AutoScalingGroupInstancesDistribution(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "onDemandAllocationStrategy":
            suggest = "on_demand_allocation_strategy"
        elif key == "onDemandBaseCapacity":
            suggest = "on_demand_base_capacity"
        elif key == "onDemandPercentageAboveBaseCapacity":
            suggest = "on_demand_percentage_above_base_capacity"
        elif key == "spotAllocationStrategy":
            suggest = "spot_allocation_strategy"
        elif key == "spotInstancePools":
            suggest = "spot_instance_pools"
        elif key == "spotMaxPrice":
            suggest = "spot_max_price"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupInstancesDistribution. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupInstancesDistribution.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupInstancesDistribution.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 on_demand_allocation_strategy: Optional[str] = None,
                 on_demand_base_capacity: Optional[int] = None,
                 on_demand_percentage_above_base_capacity: Optional[int] = None,
                 spot_allocation_strategy: Optional[str] = None,
                 spot_instance_pools: Optional[int] = None,
                 spot_max_price: Optional[str] = None):
        if on_demand_allocation_strategy is not None:
            pulumi.set(__self__, "on_demand_allocation_strategy", on_demand_allocation_strategy)
        if on_demand_base_capacity is not None:
            pulumi.set(__self__, "on_demand_base_capacity", on_demand_base_capacity)
        if on_demand_percentage_above_base_capacity is not None:
            pulumi.set(__self__, "on_demand_percentage_above_base_capacity", on_demand_percentage_above_base_capacity)
        if spot_allocation_strategy is not None:
            pulumi.set(__self__, "spot_allocation_strategy", spot_allocation_strategy)
        if spot_instance_pools is not None:
            pulumi.set(__self__, "spot_instance_pools", spot_instance_pools)
        if spot_max_price is not None:
            pulumi.set(__self__, "spot_max_price", spot_max_price)

    @property
    @pulumi.getter(name="onDemandAllocationStrategy")
    def on_demand_allocation_strategy(self) -> Optional[str]:
        return pulumi.get(self, "on_demand_allocation_strategy")

    @property
    @pulumi.getter(name="onDemandBaseCapacity")
    def on_demand_base_capacity(self) -> Optional[int]:
        return pulumi.get(self, "on_demand_base_capacity")

    @property
    @pulumi.getter(name="onDemandPercentageAboveBaseCapacity")
    def on_demand_percentage_above_base_capacity(self) -> Optional[int]:
        return pulumi.get(self, "on_demand_percentage_above_base_capacity")

    @property
    @pulumi.getter(name="spotAllocationStrategy")
    def spot_allocation_strategy(self) -> Optional[str]:
        return pulumi.get(self, "spot_allocation_strategy")

    @property
    @pulumi.getter(name="spotInstancePools")
    def spot_instance_pools(self) -> Optional[int]:
        return pulumi.get(self, "spot_instance_pools")

    @property
    @pulumi.getter(name="spotMaxPrice")
    def spot_max_price(self) -> Optional[str]:
        return pulumi.get(self, "spot_max_price")


@pulumi.output_type
class AutoScalingGroupLaunchTemplate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateSpecification":
            suggest = "launch_template_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupLaunchTemplate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupLaunchTemplate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupLaunchTemplate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template_specification: 'outputs.AutoScalingGroupLaunchTemplateSpecification',
                 overrides: Optional[Sequence['outputs.AutoScalingGroupLaunchTemplateOverrides']] = None):
        pulumi.set(__self__, "launch_template_specification", launch_template_specification)
        if overrides is not None:
            pulumi.set(__self__, "overrides", overrides)

    @property
    @pulumi.getter(name="launchTemplateSpecification")
    def launch_template_specification(self) -> 'outputs.AutoScalingGroupLaunchTemplateSpecification':
        return pulumi.get(self, "launch_template_specification")

    @property
    @pulumi.getter
    def overrides(self) -> Optional[Sequence['outputs.AutoScalingGroupLaunchTemplateOverrides']]:
        return pulumi.get(self, "overrides")


@pulumi.output_type
class AutoScalingGroupLaunchTemplateOverrides(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceType":
            suggest = "instance_type"
        elif key == "launchTemplateSpecification":
            suggest = "launch_template_specification"
        elif key == "weightedCapacity":
            suggest = "weighted_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupLaunchTemplateOverrides. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupLaunchTemplateOverrides.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupLaunchTemplateOverrides.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_type: Optional[str] = None,
                 launch_template_specification: Optional['outputs.AutoScalingGroupLaunchTemplateSpecification'] = None,
                 weighted_capacity: Optional[str] = None):
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if launch_template_specification is not None:
            pulumi.set(__self__, "launch_template_specification", launch_template_specification)
        if weighted_capacity is not None:
            pulumi.set(__self__, "weighted_capacity", weighted_capacity)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[str]:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="launchTemplateSpecification")
    def launch_template_specification(self) -> Optional['outputs.AutoScalingGroupLaunchTemplateSpecification']:
        return pulumi.get(self, "launch_template_specification")

    @property
    @pulumi.getter(name="weightedCapacity")
    def weighted_capacity(self) -> Optional[str]:
        return pulumi.get(self, "weighted_capacity")


@pulumi.output_type
class AutoScalingGroupLaunchTemplateSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplateId":
            suggest = "launch_template_id"
        elif key == "launchTemplateName":
            suggest = "launch_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupLaunchTemplateSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupLaunchTemplateSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupLaunchTemplateSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version: str,
                 launch_template_id: Optional[str] = None,
                 launch_template_name: Optional[str] = None):
        pulumi.set(__self__, "version", version)
        if launch_template_id is not None:
            pulumi.set(__self__, "launch_template_id", launch_template_id)
        if launch_template_name is not None:
            pulumi.set(__self__, "launch_template_name", launch_template_name)

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="launchTemplateId")
    def launch_template_id(self) -> Optional[str]:
        return pulumi.get(self, "launch_template_id")

    @property
    @pulumi.getter(name="launchTemplateName")
    def launch_template_name(self) -> Optional[str]:
        return pulumi.get(self, "launch_template_name")


@pulumi.output_type
class AutoScalingGroupLifecycleHookSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "lifecycleHookName":
            suggest = "lifecycle_hook_name"
        elif key == "lifecycleTransition":
            suggest = "lifecycle_transition"
        elif key == "defaultResult":
            suggest = "default_result"
        elif key == "heartbeatTimeout":
            suggest = "heartbeat_timeout"
        elif key == "notificationMetadata":
            suggest = "notification_metadata"
        elif key == "notificationTargetARN":
            suggest = "notification_target_arn"
        elif key == "roleARN":
            suggest = "role_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupLifecycleHookSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupLifecycleHookSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupLifecycleHookSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 lifecycle_hook_name: str,
                 lifecycle_transition: str,
                 default_result: Optional[str] = None,
                 heartbeat_timeout: Optional[int] = None,
                 notification_metadata: Optional[str] = None,
                 notification_target_arn: Optional[str] = None,
                 role_arn: Optional[str] = None):
        pulumi.set(__self__, "lifecycle_hook_name", lifecycle_hook_name)
        pulumi.set(__self__, "lifecycle_transition", lifecycle_transition)
        if default_result is not None:
            pulumi.set(__self__, "default_result", default_result)
        if heartbeat_timeout is not None:
            pulumi.set(__self__, "heartbeat_timeout", heartbeat_timeout)
        if notification_metadata is not None:
            pulumi.set(__self__, "notification_metadata", notification_metadata)
        if notification_target_arn is not None:
            pulumi.set(__self__, "notification_target_arn", notification_target_arn)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @property
    @pulumi.getter(name="lifecycleHookName")
    def lifecycle_hook_name(self) -> str:
        return pulumi.get(self, "lifecycle_hook_name")

    @property
    @pulumi.getter(name="lifecycleTransition")
    def lifecycle_transition(self) -> str:
        return pulumi.get(self, "lifecycle_transition")

    @property
    @pulumi.getter(name="defaultResult")
    def default_result(self) -> Optional[str]:
        return pulumi.get(self, "default_result")

    @property
    @pulumi.getter(name="heartbeatTimeout")
    def heartbeat_timeout(self) -> Optional[int]:
        return pulumi.get(self, "heartbeat_timeout")

    @property
    @pulumi.getter(name="notificationMetadata")
    def notification_metadata(self) -> Optional[str]:
        return pulumi.get(self, "notification_metadata")

    @property
    @pulumi.getter(name="notificationTargetARN")
    def notification_target_arn(self) -> Optional[str]:
        return pulumi.get(self, "notification_target_arn")

    @property
    @pulumi.getter(name="roleARN")
    def role_arn(self) -> Optional[str]:
        return pulumi.get(self, "role_arn")


@pulumi.output_type
class AutoScalingGroupMetricsCollection(dict):
    def __init__(__self__, *,
                 granularity: str,
                 metrics: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "granularity", granularity)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)

    @property
    @pulumi.getter
    def granularity(self) -> str:
        return pulumi.get(self, "granularity")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "metrics")


@pulumi.output_type
class AutoScalingGroupMixedInstancesPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launchTemplate":
            suggest = "launch_template"
        elif key == "instancesDistribution":
            suggest = "instances_distribution"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupMixedInstancesPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupMixedInstancesPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupMixedInstancesPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launch_template: 'outputs.AutoScalingGroupLaunchTemplate',
                 instances_distribution: Optional['outputs.AutoScalingGroupInstancesDistribution'] = None):
        pulumi.set(__self__, "launch_template", launch_template)
        if instances_distribution is not None:
            pulumi.set(__self__, "instances_distribution", instances_distribution)

    @property
    @pulumi.getter(name="launchTemplate")
    def launch_template(self) -> 'outputs.AutoScalingGroupLaunchTemplate':
        return pulumi.get(self, "launch_template")

    @property
    @pulumi.getter(name="instancesDistribution")
    def instances_distribution(self) -> Optional['outputs.AutoScalingGroupInstancesDistribution']:
        return pulumi.get(self, "instances_distribution")


@pulumi.output_type
class AutoScalingGroupNotificationConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "topicARN":
            suggest = "topic_arn"
        elif key == "notificationTypes":
            suggest = "notification_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupNotificationConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupNotificationConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupNotificationConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 topic_arn: str,
                 notification_types: Optional[Sequence[str]] = None):
        pulumi.set(__self__, "topic_arn", topic_arn)
        if notification_types is not None:
            pulumi.set(__self__, "notification_types", notification_types)

    @property
    @pulumi.getter(name="topicARN")
    def topic_arn(self) -> str:
        return pulumi.get(self, "topic_arn")

    @property
    @pulumi.getter(name="notificationTypes")
    def notification_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "notification_types")


@pulumi.output_type
class AutoScalingGroupTagProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "propagateAtLaunch":
            suggest = "propagate_at_launch"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoScalingGroupTagProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoScalingGroupTagProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoScalingGroupTagProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 propagate_at_launch: bool,
                 value: str):
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "propagate_at_launch", propagate_at_launch)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="propagateAtLaunch")
    def propagate_at_launch(self) -> bool:
        return pulumi.get(self, "propagate_at_launch")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class LaunchConfigurationBlockDevice(dict):
    """
    BlockDevice is a subproperty of BlockDeviceMapping that describes an Amazon EBS volume.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deleteOnTermination":
            suggest = "delete_on_termination"
        elif key == "snapshotId":
            suggest = "snapshot_id"
        elif key == "volumeSize":
            suggest = "volume_size"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchConfigurationBlockDevice. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchConfigurationBlockDevice.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchConfigurationBlockDevice.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete_on_termination: Optional[bool] = None,
                 encrypted: Optional[bool] = None,
                 iops: Optional[int] = None,
                 snapshot_id: Optional[str] = None,
                 throughput: Optional[int] = None,
                 volume_size: Optional[int] = None,
                 volume_type: Optional[str] = None):
        """
        BlockDevice is a subproperty of BlockDeviceMapping that describes an Amazon EBS volume.
        :param bool delete_on_termination: Indicates whether the volume is deleted on instance termination. 
        :param bool encrypted: Specifies whether the volume should be encrypted. 
        :param int iops: The number of input/output (I/O) operations per second (IOPS) to provision for the volume. 
        :param str snapshot_id: The snapshot ID of the volume to use.
        :param int throughput: The throughput (MiBps) to provision for a gp3 volume.
        :param int volume_size: The volume size, in GiBs.
        :param str volume_type: The volume type.
        """
        if delete_on_termination is not None:
            pulumi.set(__self__, "delete_on_termination", delete_on_termination)
        if encrypted is not None:
            pulumi.set(__self__, "encrypted", encrypted)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)
        if volume_size is not None:
            pulumi.set(__self__, "volume_size", volume_size)
        if volume_type is not None:
            pulumi.set(__self__, "volume_type", volume_type)

    @property
    @pulumi.getter(name="deleteOnTermination")
    def delete_on_termination(self) -> Optional[bool]:
        """
        Indicates whether the volume is deleted on instance termination. 
        """
        return pulumi.get(self, "delete_on_termination")

    @property
    @pulumi.getter
    def encrypted(self) -> Optional[bool]:
        """
        Specifies whether the volume should be encrypted. 
        """
        return pulumi.get(self, "encrypted")

    @property
    @pulumi.getter
    def iops(self) -> Optional[int]:
        """
        The number of input/output (I/O) operations per second (IOPS) to provision for the volume. 
        """
        return pulumi.get(self, "iops")

    @property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[str]:
        """
        The snapshot ID of the volume to use.
        """
        return pulumi.get(self, "snapshot_id")

    @property
    @pulumi.getter
    def throughput(self) -> Optional[int]:
        """
        The throughput (MiBps) to provision for a gp3 volume.
        """
        return pulumi.get(self, "throughput")

    @property
    @pulumi.getter(name="volumeSize")
    def volume_size(self) -> Optional[int]:
        """
        The volume size, in GiBs.
        """
        return pulumi.get(self, "volume_size")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> Optional[str]:
        """
        The volume type.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class LaunchConfigurationBlockDeviceMapping(dict):
    """
    BlockDeviceMapping is a property of AWS::AutoScaling::LaunchConfiguration that describes a block device mapping for an Auto Scaling group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceName":
            suggest = "device_name"
        elif key == "noDevice":
            suggest = "no_device"
        elif key == "virtualName":
            suggest = "virtual_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchConfigurationBlockDeviceMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchConfigurationBlockDeviceMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchConfigurationBlockDeviceMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_name: str,
                 ebs: Optional['outputs.LaunchConfigurationBlockDevice'] = None,
                 no_device: Optional[bool] = None,
                 virtual_name: Optional[str] = None):
        """
        BlockDeviceMapping is a property of AWS::AutoScaling::LaunchConfiguration that describes a block device mapping for an Auto Scaling group.
        :param str device_name: The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh). 
        :param 'LaunchConfigurationBlockDevice' ebs: Parameters used to automatically set up EBS volumes when an instance is launched.
        :param bool no_device: Setting this value to true suppresses the specified device included in the block device mapping of the AMI.
        :param str virtual_name: The name of the virtual device.
        """
        pulumi.set(__self__, "device_name", device_name)
        if ebs is not None:
            pulumi.set(__self__, "ebs", ebs)
        if no_device is not None:
            pulumi.set(__self__, "no_device", no_device)
        if virtual_name is not None:
            pulumi.set(__self__, "virtual_name", virtual_name)

    @property
    @pulumi.getter(name="deviceName")
    def device_name(self) -> str:
        """
        The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh). 
        """
        return pulumi.get(self, "device_name")

    @property
    @pulumi.getter
    def ebs(self) -> Optional['outputs.LaunchConfigurationBlockDevice']:
        """
        Parameters used to automatically set up EBS volumes when an instance is launched.
        """
        return pulumi.get(self, "ebs")

    @property
    @pulumi.getter(name="noDevice")
    def no_device(self) -> Optional[bool]:
        """
        Setting this value to true suppresses the specified device included in the block device mapping of the AMI.
        """
        return pulumi.get(self, "no_device")

    @property
    @pulumi.getter(name="virtualName")
    def virtual_name(self) -> Optional[str]:
        """
        The name of the virtual device.
        """
        return pulumi.get(self, "virtual_name")


@pulumi.output_type
class LaunchConfigurationMetadataOptions(dict):
    """
    MetadataOptions is a property of AWS::AutoScaling::LaunchConfiguration that describes metadata options for the instances.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpEndpoint":
            suggest = "http_endpoint"
        elif key == "httpPutResponseHopLimit":
            suggest = "http_put_response_hop_limit"
        elif key == "httpTokens":
            suggest = "http_tokens"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LaunchConfigurationMetadataOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LaunchConfigurationMetadataOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LaunchConfigurationMetadataOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_endpoint: Optional[str] = None,
                 http_put_response_hop_limit: Optional[int] = None,
                 http_tokens: Optional[str] = None):
        """
        MetadataOptions is a property of AWS::AutoScaling::LaunchConfiguration that describes metadata options for the instances.
        :param str http_endpoint: This parameter enables or disables the HTTP metadata endpoint on your instances.
        :param int http_put_response_hop_limit: The desired HTTP PUT response hop limit for instance metadata requests.
        :param str http_tokens: The state of token usage for your instance metadata requests.
        """
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if http_put_response_hop_limit is not None:
            pulumi.set(__self__, "http_put_response_hop_limit", http_put_response_hop_limit)
        if http_tokens is not None:
            pulumi.set(__self__, "http_tokens", http_tokens)

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[str]:
        """
        This parameter enables or disables the HTTP metadata endpoint on your instances.
        """
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpPutResponseHopLimit")
    def http_put_response_hop_limit(self) -> Optional[int]:
        """
        The desired HTTP PUT response hop limit for instance metadata requests.
        """
        return pulumi.get(self, "http_put_response_hop_limit")

    @property
    @pulumi.getter(name="httpTokens")
    def http_tokens(self) -> Optional[str]:
        """
        The state of token usage for your instance metadata requests.
        """
        return pulumi.get(self, "http_tokens")


@pulumi.output_type
class ScalingPolicyCustomizedMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricName":
            suggest = "metric_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyCustomizedMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyCustomizedMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyCustomizedMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_name: str,
                 namespace: str,
                 statistic: str,
                 dimensions: Optional[Sequence['outputs.ScalingPolicyMetricDimension']] = None,
                 unit: Optional[str] = None):
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "statistic", statistic)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> str:
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def statistic(self) -> str:
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.ScalingPolicyMetricDimension']]:
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        return pulumi.get(self, "unit")


@pulumi.output_type
class ScalingPolicyMetricDimension(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class ScalingPolicyPredefinedMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredefinedMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredefinedMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredefinedMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: Optional[str] = None):
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class ScalingPolicyPredictiveScalingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metricSpecifications":
            suggest = "metric_specifications"
        elif key == "maxCapacityBreachBehavior":
            suggest = "max_capacity_breach_behavior"
        elif key == "maxCapacityBuffer":
            suggest = "max_capacity_buffer"
        elif key == "schedulingBufferTime":
            suggest = "scheduling_buffer_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metric_specifications: Sequence['outputs.ScalingPolicyPredictiveScalingMetricSpecification'],
                 max_capacity_breach_behavior: Optional[str] = None,
                 max_capacity_buffer: Optional[int] = None,
                 mode: Optional[str] = None,
                 scheduling_buffer_time: Optional[int] = None):
        pulumi.set(__self__, "metric_specifications", metric_specifications)
        if max_capacity_breach_behavior is not None:
            pulumi.set(__self__, "max_capacity_breach_behavior", max_capacity_breach_behavior)
        if max_capacity_buffer is not None:
            pulumi.set(__self__, "max_capacity_buffer", max_capacity_buffer)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if scheduling_buffer_time is not None:
            pulumi.set(__self__, "scheduling_buffer_time", scheduling_buffer_time)

    @property
    @pulumi.getter(name="metricSpecifications")
    def metric_specifications(self) -> Sequence['outputs.ScalingPolicyPredictiveScalingMetricSpecification']:
        return pulumi.get(self, "metric_specifications")

    @property
    @pulumi.getter(name="maxCapacityBreachBehavior")
    def max_capacity_breach_behavior(self) -> Optional[str]:
        return pulumi.get(self, "max_capacity_breach_behavior")

    @property
    @pulumi.getter(name="maxCapacityBuffer")
    def max_capacity_buffer(self) -> Optional[int]:
        return pulumi.get(self, "max_capacity_buffer")

    @property
    @pulumi.getter
    def mode(self) -> Optional[str]:
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="schedulingBufferTime")
    def scheduling_buffer_time(self) -> Optional[int]:
        return pulumi.get(self, "scheduling_buffer_time")


@pulumi.output_type
class ScalingPolicyPredictiveScalingMetricSpecification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"
        elif key == "predefinedLoadMetricSpecification":
            suggest = "predefined_load_metric_specification"
        elif key == "predefinedMetricPairSpecification":
            suggest = "predefined_metric_pair_specification"
        elif key == "predefinedScalingMetricSpecification":
            suggest = "predefined_scaling_metric_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingMetricSpecification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingMetricSpecification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingMetricSpecification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: float,
                 predefined_load_metric_specification: Optional['outputs.ScalingPolicyPredictiveScalingPredefinedLoadMetric'] = None,
                 predefined_metric_pair_specification: Optional['outputs.ScalingPolicyPredictiveScalingPredefinedMetricPair'] = None,
                 predefined_scaling_metric_specification: Optional['outputs.ScalingPolicyPredictiveScalingPredefinedScalingMetric'] = None):
        pulumi.set(__self__, "target_value", target_value)
        if predefined_load_metric_specification is not None:
            pulumi.set(__self__, "predefined_load_metric_specification", predefined_load_metric_specification)
        if predefined_metric_pair_specification is not None:
            pulumi.set(__self__, "predefined_metric_pair_specification", predefined_metric_pair_specification)
        if predefined_scaling_metric_specification is not None:
            pulumi.set(__self__, "predefined_scaling_metric_specification", predefined_scaling_metric_specification)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        return pulumi.get(self, "target_value")

    @property
    @pulumi.getter(name="predefinedLoadMetricSpecification")
    def predefined_load_metric_specification(self) -> Optional['outputs.ScalingPolicyPredictiveScalingPredefinedLoadMetric']:
        return pulumi.get(self, "predefined_load_metric_specification")

    @property
    @pulumi.getter(name="predefinedMetricPairSpecification")
    def predefined_metric_pair_specification(self) -> Optional['outputs.ScalingPolicyPredictiveScalingPredefinedMetricPair']:
        return pulumi.get(self, "predefined_metric_pair_specification")

    @property
    @pulumi.getter(name="predefinedScalingMetricSpecification")
    def predefined_scaling_metric_specification(self) -> Optional['outputs.ScalingPolicyPredictiveScalingPredefinedScalingMetric']:
        return pulumi.get(self, "predefined_scaling_metric_specification")


@pulumi.output_type
class ScalingPolicyPredictiveScalingPredefinedLoadMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingPredefinedLoadMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingPredefinedLoadMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingPredefinedLoadMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: Optional[str] = None):
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class ScalingPolicyPredictiveScalingPredefinedMetricPair(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingPredefinedMetricPair. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingPredefinedMetricPair.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingPredefinedMetricPair.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: Optional[str] = None):
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class ScalingPolicyPredictiveScalingPredefinedScalingMetric(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predefinedMetricType":
            suggest = "predefined_metric_type"
        elif key == "resourceLabel":
            suggest = "resource_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyPredictiveScalingPredefinedScalingMetric. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyPredictiveScalingPredefinedScalingMetric.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyPredictiveScalingPredefinedScalingMetric.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predefined_metric_type: str,
                 resource_label: Optional[str] = None):
        pulumi.set(__self__, "predefined_metric_type", predefined_metric_type)
        if resource_label is not None:
            pulumi.set(__self__, "resource_label", resource_label)

    @property
    @pulumi.getter(name="predefinedMetricType")
    def predefined_metric_type(self) -> str:
        return pulumi.get(self, "predefined_metric_type")

    @property
    @pulumi.getter(name="resourceLabel")
    def resource_label(self) -> Optional[str]:
        return pulumi.get(self, "resource_label")


@pulumi.output_type
class ScalingPolicyStepAdjustment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scalingAdjustment":
            suggest = "scaling_adjustment"
        elif key == "metricIntervalLowerBound":
            suggest = "metric_interval_lower_bound"
        elif key == "metricIntervalUpperBound":
            suggest = "metric_interval_upper_bound"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyStepAdjustment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyStepAdjustment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyStepAdjustment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 scaling_adjustment: int,
                 metric_interval_lower_bound: Optional[float] = None,
                 metric_interval_upper_bound: Optional[float] = None):
        pulumi.set(__self__, "scaling_adjustment", scaling_adjustment)
        if metric_interval_lower_bound is not None:
            pulumi.set(__self__, "metric_interval_lower_bound", metric_interval_lower_bound)
        if metric_interval_upper_bound is not None:
            pulumi.set(__self__, "metric_interval_upper_bound", metric_interval_upper_bound)

    @property
    @pulumi.getter(name="scalingAdjustment")
    def scaling_adjustment(self) -> int:
        return pulumi.get(self, "scaling_adjustment")

    @property
    @pulumi.getter(name="metricIntervalLowerBound")
    def metric_interval_lower_bound(self) -> Optional[float]:
        return pulumi.get(self, "metric_interval_lower_bound")

    @property
    @pulumi.getter(name="metricIntervalUpperBound")
    def metric_interval_upper_bound(self) -> Optional[float]:
        return pulumi.get(self, "metric_interval_upper_bound")


@pulumi.output_type
class ScalingPolicyTargetTrackingConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetValue":
            suggest = "target_value"
        elif key == "customizedMetricSpecification":
            suggest = "customized_metric_specification"
        elif key == "disableScaleIn":
            suggest = "disable_scale_in"
        elif key == "predefinedMetricSpecification":
            suggest = "predefined_metric_specification"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScalingPolicyTargetTrackingConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScalingPolicyTargetTrackingConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScalingPolicyTargetTrackingConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_value: float,
                 customized_metric_specification: Optional['outputs.ScalingPolicyCustomizedMetricSpecification'] = None,
                 disable_scale_in: Optional[bool] = None,
                 predefined_metric_specification: Optional['outputs.ScalingPolicyPredefinedMetricSpecification'] = None):
        pulumi.set(__self__, "target_value", target_value)
        if customized_metric_specification is not None:
            pulumi.set(__self__, "customized_metric_specification", customized_metric_specification)
        if disable_scale_in is not None:
            pulumi.set(__self__, "disable_scale_in", disable_scale_in)
        if predefined_metric_specification is not None:
            pulumi.set(__self__, "predefined_metric_specification", predefined_metric_specification)

    @property
    @pulumi.getter(name="targetValue")
    def target_value(self) -> float:
        return pulumi.get(self, "target_value")

    @property
    @pulumi.getter(name="customizedMetricSpecification")
    def customized_metric_specification(self) -> Optional['outputs.ScalingPolicyCustomizedMetricSpecification']:
        return pulumi.get(self, "customized_metric_specification")

    @property
    @pulumi.getter(name="disableScaleIn")
    def disable_scale_in(self) -> Optional[bool]:
        return pulumi.get(self, "disable_scale_in")

    @property
    @pulumi.getter(name="predefinedMetricSpecification")
    def predefined_metric_specification(self) -> Optional['outputs.ScalingPolicyPredefinedMetricSpecification']:
        return pulumi.get(self, "predefined_metric_specification")


