import os

import matplotlib.animation as animation
import matplotlib.pyplot as plt
import numpy as np
from mpl_toolkits.mplot3d import Axes3D
from tqdm import tqdm


def plot_skeleton(skeleton_data_path: str, save_gif=False):
    """
    Example:
        from rofunc.xsens.visualize import plot_skeleton

        skeleton_data_path = './xsens_data/dough_01'  # dough_01 must be a folder with multiple .npy files about
                                                      the skeleton which can be generated by `get_skeleton`
        plot_skeleton(skeleton_data_path)
    """
    if not os.path.isdir(skeleton_data_path):
        raise Exception('The skeleton_data_path must be a folder with multiple .npy files about the skeleton. '
                        'Please use get_skeleton to generate the complete skeleton data.')

    print('{} animate start!'.format(skeleton_data_path.split('/')[-1]))
    labels = os.listdir(skeleton_data_path)
    data_dict = {}
    for label in labels:
        if label.split('.')[-1] == 'npy':
            exec('{} = np.load(os.path.join(skeleton_data_path, "{}"))'.format(label.split('.')[0], label))
            data_dict['{}'.format(label.split('.')[0])] = np.load(os.path.join(skeleton_data_path, "{}".format(label)))

    dim = len(data_dict['left_finger_LeftFirstPP'])

    fig = plt.figure()
    ax = Axes3D(fig)
    ax.set_xlim(-0.5, 1)  # 因为清空了画布，所以要重新设置坐标轴的范围
    ax.set_ylim(-0.5, 1)
    ax.set_zlim(-.5, 2)

    def update(index):
        ax.cla()  # 清空画布
        ax.set_xlim(-0.5, 1)  # 因为清空了画布，所以要重新设置坐标轴的范围
        ax.set_ylim(-0.5, 1)
        ax.set_zlim(-.5, 2)
        for label in labels:
            # exec('{} = np.load(os.path.join(skeleton_data_path, "{}"))'.format(label.split('.')[0], label))
            # exec('x, y, z =  {}[index, :3]'.format(label.split('.')[0]))
            if label.split('.')[-1] == 'npy':
                if 'finger' not in label:
                    x, y, z = data_dict['{}'.format(label.split('.')[0])][index, :3]
                    ax.scatter(x, y, z, c='r')

    ax.set_xlim(-0.5, 1)  # 因为清空了画布，所以要重新设置坐标轴的范围
    ax.set_ylim(-0.5, 1)
    ax.set_zlim(-.5, 2)
    ani = animation.FuncAnimation(fig, update, np.arange(0, dim, 10), interval=100, blit=False)
    if save_gif:
        ani.save(os.path.join(skeleton_data_path, '{}.gif'.format(skeleton_data_path.split('/')[-1])),
                 writer='pillow', fps=10)
        print('{} gif got!'.format(skeleton_data_path.split('/')[-1]))
    else:
        plt.show()


def plot_skeleton_batch(skeleton_dir):
    """
    Example:
        from rofunc.xsens.visualize import plot_skeleton_batch

        skeleton_dir = './xsens_data/'  # There must contain a folder with multiple .npy files about the skeleton which
                                          can be generated by `get_skeleton`
        plot_skeleton_batch(skeleton_dir)
    """
    skeletons = os.listdir(skeleton_dir)
    for skeleton in tqdm(skeletons):
        skeleton_path = os.path.join(skeleton_dir, skeleton)
        if os.path.isdir(skeleton_path):
            plot_skeleton(skeleton_path)
