"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.User = exports.UserProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ram_generated_1 = require("./ram.generated");
Object.defineProperty(exports, "UserProperty", { enumerable: true, get: function () { return ram_generated_1.RosUser; } });
/**
 * A ROS resource type:  `ALIYUN::RAM::User`
 */
class User extends ros.Resource {
    /**
     * Create a new `ALIYUN::RAM::User`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosUser = new ram_generated_1.RosUser(this, id, {
            userName: props.userName,
            policies: props.policies,
            email: props.email,
            groups: props.groups,
            comments: props.comments,
            displayName: props.displayName,
            loginProfile: props.loginProfile,
            mobilePhone: props.mobilePhone,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosUser;
        this.attrCreateDate = rosUser.attrCreateDate;
        this.attrLastLoginDate = rosUser.attrLastLoginDate;
        this.attrUserId = rosUser.attrUserId;
        this.attrUserName = rosUser.attrUserName;
    }
}
exports.User = User;
//# sourceMappingURL=data:application/json;base64,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