# Upload Files to GitHub

This is a Python package and command-line interface (CLI) tool for uploading files or directories to a GitHub repository. It uses the GitHub API to upload the files to a specified repository and branch.

## Installation

You can install this package using `pip`:

```
pip install upload-files-to-github
```

## Usage

### CLI

The CLI tool is called `upload_files_to_github.py` and can be used to upload one or multiple files/directories to a GitHub repository.

To upload a single file:

```
python upload_files_to_github.py --content "Hello World!" --path "example.txt" --repo "username/repo" --token "YOUR_GITHUB_TOKEN"
```

To upload multiple files or a directory:

```
python upload_files_to_github.py --files path/to/file1 path/to/directory --repo "username/repo" --token "YOUR_GITHUB_TOKEN"
```

### Package

You can also use this package in your Python code to upload files to a GitHub repository. Here's an example:

```python
from upload_files_to_github import upload_files_to_github

files = ["path/to/file1", "path/to/directory"]
repo = "username/repo"
token = "YOUR_GITHUB_TOKEN"
branch = "main"

upload_files_to_github(files, repo, token, branch)
```

## GitHub Token

To use this tool or package, you need a GitHub personal access token. You can [create a new token](https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/creating-a-personal-access-token) with the `repo` scope, which allows the tool to read and write to your repositories.

You can provide the token using the `--token` argument or by setting the `GITHUB_ACCESS_TOKEN` environment variable.