# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ultima_scraper',
 'ultima_scraper.datascraper',
 'ultima_scraper.metadata_manager',
 'ultima_scraper.modules']

package_data = \
{'': ['*'], 'ultima_scraper': ['docs/*', 'docs/assets/img/*']}

install_requires = \
['SQLAlchemy[asyncio]>=1.4.43,<2.0.0',
 'aiofiles>=22.1.0,<23.0.0',
 'aiohttp-socks>=0.7.1,<0.8.0',
 'aiohttp>=3.8.1,<4.0.0',
 'aiopath>=0.6.11,<0.7.0',
 'alembic>=1.7.5,<2.0.0',
 'beautifulsoup4>=4.10.0,<5.0.0',
 'dill>=0.3.6,<0.4.0',
 'mergedeep>=1.3.4,<2.0.0',
 'orjson>=3.6.5,<4.0.0',
 'python-dateutil>=2.8.2,<3.0.0',
 'python-socks[asyncio]>=2.0.1,<3.0.0',
 'requests>=2.26.0,<3.0.0',
 'rich>=12.4.4,<13.0.0',
 'selenium-wire==2.1.2',
 'selenium>=4.1.0,<5.0.0',
 'textual>=0.5.0,<0.6.0',
 'tqdm>=4.62.3,<5.0.0',
 'ultima-scraper-api>=0.0.1.3,<0.0.2.0',
 'ultima-scraper-renamer>=0.0.1,<0.0.2',
 'user-agent>=0.1.10,<0.2.0',
 'websockets>=10.4,<11.0',
 'win32-setctime>=1.0.4,<2.0.0']

extras_require = \
{'performance': ['lxml>=4.9.1,<5.0.0']}

setup_kwargs = {
    'name': 'ultima-scraper',
    'version': '7.6.2',
    'description': '',
    'long_description': '# OnlyFans DataScraper (Python 3.10.1+)\n[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/DIGITALCRIMINAL/OnlyFans.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/DIGITALCRIMINAL/OnlyFans/context:python)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Twitter](https://img.shields.io/twitter/url/https/twitter.com/0xHoarder.svg?style=social&label=Follow%200xhoarder)](https://twitter.com/0xHoarder)\n# ![app-token](ultima_scraper/docs/assets/img/64255399-96a86700-cf21-11e9-8c62-87a483f33701.png)\n# List of things I know that are broken:\n    UI (Progress Bars)\n# Mandatory Tutorial\n\nRead the [#FAQ](README.md#faq) at the bottom of this page before submitting a issue.\n\n## Running the app locally\nFrom the project folder open Windows Powershell/Terminal and run the commands below:\n\n### Installation commands:\n>### Poetry Installation Guide\n>`pip install poetry`\n>\n>`poetry install --no-dev`\n\nStart:\n\n>`poetry run python start_us.py`\n---\n\nOpen and edit:\n\n`.profiles/default/auth.json`\n\n[auth]\n\nYou have to fill in the following:\n\n- `{"cookie":"cookie_value"}`\n- `{"x_bc":"x-bc_value"}`\n- `{"user_agent":"user-agent_value"}`\n\nGo to www.onlyfans.com and login, open the network debugger, then check the image below on how to get said above auth values. Using Chrome for this process is recommended, as other browsers sometimes have issues producing values that will auth properly.\n\n![app-token](ultima_scraper/docs/assets/img/3.png)\n![app-token](ultima_scraper/docs/assets/img/4.png)\n\nYour auth config should look similar to this\n\n![app-token](ultima_scraper/docs/assets/img/5.png)\n\n<!-- If you want to auth via browser, add your email and password. -->\n\nIf you get auth attempt errors, only YOU can fix it unless you\'re willing to let me into your account so I can see if it\'s working or not.\n\nNote: If active is set to False, the script will ignore the profile.\n\n# USAGE\n\n`poetry run python start_us.py`\n\nEnter in inputs as prompted by console.\n\n# OPTIONAL\n\nOpen:\n\n`config.json` (Open with a texteditor)\n\n[settings]\n\n### profile_directories:\n\nWhere your account information is stored (auth.json).\n\n    Default = [".profiles"]\n\n    If you\'re going to fill, please remember to use forward ("/") slashes only.\n\n### download_directories:\n\nWhere downloaded content is stored.\n\n    Default = [".sites"]\n\n    If you\'re going to fill, please remember to use forward ("/") slashes only.\n\n    You can add multiple directories and the script will automatically rollover to the next directory if the current is full.\n\n### metadata_directories:\n\nWhere metadata content is stored.\n\n    Default = [".sites"]\n\n    If you\'re going to fill, please remember to use forward ("/") slashes only.\n\n    Automatic rollover not supported yet.\n\n### path_formatting:\n\nOverview for [file_directory_format](#file_directory_format), [filename_format](#filename_format) and [metadata_directory_format](#metadata_directory_format)\n\n    {site_name} = The site you\'re scraping.\n\n    {first_letter} = First letter of the model you\'re scraping.\n\n    {post_id} = The posts\' ID.\n\n    {media_id} = The media\'s ID.\n\n    {profile_username} = Your account\'s username.\n\n    {model_username} = The model\'s username.\n\n    {api_type} = Posts, Messages, etc.\n\n    {media_type} = Images, Videos, etc.\n\n    {filename} = The media\'s filename.\n\n    {value} = Value of the content. Paid or Free.\n\n    {text} = The media\'s text.\n\n    {date} = The post\'s creation date.\n\n    {ext} = The media\'s file extension.\n\n    Don\'t use the text variable. If you do, enjoy emojis in your filepaths and errors lmao.\n\n### file_directory_format:\n\nThis puts each media file into a folder.\n\nThe list below are unique identifiers that you must include.\n\nYou can choose one or more.\n\n    Default = "{site_name}/{model_username}/{api_type}/{value}/{media_type}"\n    Default Translated = "OnlyFans/belledelphine/Posts/Free/Images"\n\n    {model_username} = belledelphine\n\n### filename_format:\n\nUsage: Format for a filename\n\nThe list below are unique identifiers that you must include.\n\nYou must choose one or more.\n\n    Default = "{filename}.{ext}"\n    Default Translated = "5fb5a5e4b4ce6c47ce2b4_source.mp4"\n\n    {filename} = 5fb5a5e4b4ce6c47ce2b4_source\n    {media_id} = 133742069\n\n### metadata_directory_format:\n\nUsage: Filepath for metadata. It\'s tied with download_directories so ignore metadata_directories in the config.\n\nThe list below are unique identifiers that you must include.\n\nYou must choose one or more.\n\n    Default = "{site_name}/{model_username}/Metadata"\n    Default Translated = "OnlyFans/belledelphine/Metadata"\n\n    {model_username} = belledelphine\n\n### text_length:\n\nUsage: When you use {text} in filename_format, a limit of how many characters can be set by inputting a number.\n\n    Default = ""\n    Ideal = "50"\n    Max = "255"\n\n    The ideal is actually 0.\n\n### video_quality:\n\nUsage: Select the resolution of the video.\n\n    Default = "source"\n    720p = "720" | "720p"\n    240p = "240" | "240p"\n\n### auto_profile_choice:\nTypes: str|int\n\nUsage: You can automatically choose which profile you want to scrape.\n\n    Default = ""\n\n    If you\'ve got a profile folder named "user_one", set auto_profile_choice to "user_one" and it will choose it automatically.\n\n### auto_site_choice:\nTypes: list|str|bool\n\nUsage: You can automatically choose which site you want to scrape.\n\n    Default = ""\n\n    Inputs: onlyfans, fansly\n\n### auto_media_choice:\nTypes: list|str|bool\n\nUsage: You can automatically choose which media type you want to scrape.\n\n    Default = ""\n\n    Inputs: All, Images, Videos, etc\n\n    You can automatically choose which type of media you want to scrape.\n\n### auto_model_choice:\nTypes: list|str|bool\n\n    Default = false\n    Inputs: All, username, etc\n\n    If set to true, the script will scrape all the names.\n\n### auto_api_choice:\n\n    Default = true\n\n    If set to false, you\'ll be given the option to scrape individual apis.\n\n### jobs:\n    (Downloads)\n    "subscriptions" - This will scrape your standard content\n    "paid_content" - This will scrape paid content\n\n    If set to false, it won\'t do the job.\n\n### export_type:\n\n    Default = "json"\n\n    JSON = "json"\n\n    You can export an archive to different formats (not anymore lol).\n\n### overwrite_files:\n\n    Default = false\n\n    If set to true, any file with the same name will be redownloaded.\n\n### date_format:\n\n    Default = "%d-%m-%Y"\n\n    If you live in the USA and you want to use the incorrect format, use the following:\n\n    "%m-%d-%Y"\n\n### max_threads:\n\n    Default = -1\n\n    When number is set below 1, it will use all threads.\n    Set a number higher than 0 to limit threads.\n\n### min_drive_space:\n\n    Default = 0\n    Type: Float\n\n    Space is calculated in GBs.\n    0.5 is 500mb, 1 is 1gb,etc.\n    When a drive goes below minimum drive space, it will move onto the next drive or go into an infinite loop until drive is above the minimum space.\n\n### webhooks:\n\n    Default = []\n\n    Supported webhooks:\n    Discord\n\n    Data is sent whenever you\'ve completely downloaded a model.\n    You can also put in your own custom url and parse the data.\n    Need another webhook? Open an issue.\n\n### exit_on_completion:\n\n    Default = false\n\n    If set to true the scraper run once and exit upon completion, otherwise the scraper will give the option to run again. This is useful if the scraper is being executed by a cron job or another script.\n\n### infinite_loop:\n\n    Default = true\n\n    If set to false, the script will run once and ask you to input anything to continue.\n\n### loop_timeout:\n\n    Default = 0\n\n    When infinite_loop is set to true this will set the time in seconds to pause the loop in between runs.\n\n### boards:\n\n    Default = []\n    Example = ["s", "gif"]\n\n    Input boards names that you want to automatically scrape.\n\n### ignored_keywords:\n\n    Default = []\n    Example = ["ignore", "me"]\n\n    Any words you input, the script will ignore any content that contains these words.\n\n### ignore_type:\n\n    Default = ""\n    a = "paid"\n    b = "free"\n\n    This setting will not include any paid or free accounts in your subscription list.\n\n    Example: "ignore_type": "paid"\n\n    This choice will not include any accounts that you\'ve paid for.\n\n### export_metadata:\n\n    Default = true\n\n    Set to false if you don\'t want to save metadata.\n\n### blacklist_name:\n\n    Default = ""\n    Example = ["Blacklisted"]\n    Example = "Blacklisted,alsoforbidden"\n\n    This setting allows you to remove usernames when you choose the "scrap all" option by using lists or targetting specific usernames.\n\n    1. Go to https://onlyfans.com/my/lists and create a new list; you can name it whatever you want but I called mine "Blacklisted".\n    Add the list\'s name to the config.\n    Example: "blacklist_name": "Blacklisted"\n\n    2. Or simply put the username of the content creator in the list.\n\n# Other Tutorials:\n\n>## Running the app via docker\n>>Build and run the image, mounting the appropriate directories:\n>\n>>`docker build -t only-fans . && docker run -it --rm --name onlyfans -v ${PWD}/.settings:/usr/src/app/.settings -v ${PWD}/.profiles:/usr/src/app/.profiles -v ${PWD}/.sites:/usr/src/app/.sites only-fans`\n\n>## Running on Linux\n>>[Running in Linux](/ultima_scraper/docs/Linux.md)\n\n>### OnlyFans\n>>[X34\'s Collection of Scrapers](https://forum.sexy-egirls.com/threads/onlyfans-downloading-a-complete-guide-for-pc-and-mobile.70618/page-9)\n\n>### Fansly\n>>[X34\'s Tutorial](https://forum.sexy-egirls.com/threads/fansly-downloading-a-work-in-progress.132433/)\n\n# FAQ:\n\nBefore troubleshooting, make sure you\'re using Python 3.10.1 and the latest commit of the script.\n\n## Error: Access Denied / Auth Loop\n\n> Quadrupal check that the cookies and user agent are correct.\n> Remove 2FA.\n\n## I can\'t see ".settings" folder\'\n\n> Make sure you can see hidden files\n>\n> [Windows Tutorial](https://support.microsoft.com/en-gb/help/4028316/windows-view-hidden-files-and-folders-in-windows-10)\n>\n> [Mac Tutorial](https://setapp.com/how-to/show-hidden-files-on-mac)\n>\n> [Linux](https://www.google.com)\n\n## I\'m getting authed into the wrong account\n\n> Enjoy the free content. | This has been patched lol.\n\n## Do OnlyFans or OnlyFans models know I\'m using this script?\n\n> OnlyFans may know that you\'re using this script, but I try to keep it as anon as possible.\n\n> Generally, models will not know unless OnlyFans tells them but other than that there is identifiable information in the metadata folder which contains your IP address, so don\'t share it unless you\'re using a proxy/vpn or just don\'t care.\n\n## Do you collect session information?\n\n> No. The code is on Github which allows you to audit the codebase yourself. You can use wireshark or any other network analysis program to verify the outgoing connections are respective to the modules you chose.\n\n## Disclaimer (lmao):\n\n> OnlyFans is a registered trademark of Fenix International Limited.\n\n> The contributors of this script isn\'t in any way affiliated with, sponsored by, or endorsed by Fenix International Limited.\n\n> The contributors of this script are not responsible for the end users\' actions... lmao.\n',
    'author': 'DIGITALCRIMINALS',
    'author_email': '89371864+DIGITALCRIMINALS@users.noreply.github.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.10.1,<3.11.0',
}


setup(**setup_kwargs)
