# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetHostedZoneResult',
    'AwaitableGetHostedZoneResult',
    'get_hosted_zone',
    'get_hosted_zone_output',
]

@pulumi.output_type
class GetHostedZoneResult:
    def __init__(__self__, hosted_zone_config=None, hosted_zone_tags=None, id=None, name_servers=None, query_logging_config=None, v_pcs=None):
        if hosted_zone_config and not isinstance(hosted_zone_config, dict):
            raise TypeError("Expected argument 'hosted_zone_config' to be a dict")
        pulumi.set(__self__, "hosted_zone_config", hosted_zone_config)
        if hosted_zone_tags and not isinstance(hosted_zone_tags, list):
            raise TypeError("Expected argument 'hosted_zone_tags' to be a list")
        pulumi.set(__self__, "hosted_zone_tags", hosted_zone_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_servers and not isinstance(name_servers, list):
            raise TypeError("Expected argument 'name_servers' to be a list")
        pulumi.set(__self__, "name_servers", name_servers)
        if query_logging_config and not isinstance(query_logging_config, dict):
            raise TypeError("Expected argument 'query_logging_config' to be a dict")
        pulumi.set(__self__, "query_logging_config", query_logging_config)
        if v_pcs and not isinstance(v_pcs, list):
            raise TypeError("Expected argument 'v_pcs' to be a list")
        pulumi.set(__self__, "v_pcs", v_pcs)

    @property
    @pulumi.getter(name="hostedZoneConfig")
    def hosted_zone_config(self) -> Optional['outputs.HostedZoneConfig']:
        return pulumi.get(self, "hosted_zone_config")

    @property
    @pulumi.getter(name="hostedZoneTags")
    def hosted_zone_tags(self) -> Optional[Sequence['outputs.HostedZoneTag']]:
        """
        Adds, edits, or deletes tags for a health check or a hosted zone.

        For information about using tags for cost allocation, see Using Cost Allocation Tags in the AWS Billing and Cost Management User Guide.
        """
        return pulumi.get(self, "hosted_zone_tags")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "name_servers")

    @property
    @pulumi.getter(name="queryLoggingConfig")
    def query_logging_config(self) -> Optional['outputs.HostedZoneQueryLoggingConfig']:
        return pulumi.get(self, "query_logging_config")

    @property
    @pulumi.getter(name="vPCs")
    def v_pcs(self) -> Optional[Sequence['outputs.HostedZoneVPC']]:
        """
        A complex type that contains information about the VPCs that are associated with the specified hosted zone.
        """
        return pulumi.get(self, "v_pcs")


class AwaitableGetHostedZoneResult(GetHostedZoneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHostedZoneResult(
            hosted_zone_config=self.hosted_zone_config,
            hosted_zone_tags=self.hosted_zone_tags,
            id=self.id,
            name_servers=self.name_servers,
            query_logging_config=self.query_logging_config,
            v_pcs=self.v_pcs)


def get_hosted_zone(id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHostedZoneResult:
    """
    Resource schema for AWS::Route53::HostedZone.
    """
    __args__ = dict()
    __args__['id'] = id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('aws-native:route53:getHostedZone', __args__, opts=opts, typ=GetHostedZoneResult).value

    return AwaitableGetHostedZoneResult(
        hosted_zone_config=__ret__.hosted_zone_config,
        hosted_zone_tags=__ret__.hosted_zone_tags,
        id=__ret__.id,
        name_servers=__ret__.name_servers,
        query_logging_config=__ret__.query_logging_config,
        v_pcs=__ret__.v_pcs)


@_utilities.lift_output_func(get_hosted_zone)
def get_hosted_zone_output(id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHostedZoneResult]:
    """
    Resource schema for AWS::Route53::HostedZone.
    """
    ...
