# Reactionary

A tool for predicting MetaCyc reactions from (meta) genomes.

## Abstract

To better understand the functional (i.e. metabolic) characteristics
of microbiomes or single genomes, we need to annotate proteins in the
(meta)genomic data with information about what enzymatic activities
they exhibit. While there are tools available that perform metabolic
pathway prediction, they are currently predicated on the underlying
accuracy of the enzyme/reaction information found in the (meta)genome
annotation. HUMANN2 predicts MetaCyc reactions directly from reads in
a metagenomic context, but its algorithm has not been validated at the
reactome level and its reaction prediction accuracy is
unclear. Pathway Tools predicts MetaCyc reactions when constructing a
new (environmental) pathway/genome database, but it does so by
performing a second level of annotation by performing text analysis of
the primary sequence-based annotation tool. 

Reactionary is being developed to provide a validated MetaCyc reaction
prediction tool that works directly off of unannotated sequence data
for both genomic and metagenomic use cases. It currently has been
validated on the EcoCyc pathway/genome database, with a resulting
reaction prediction performance of an F1-score of 0.92. The tool is
currently being validated on a larger set of microbial genomes with
known high-quality reactome-level annotations with significant manual
review by biologists.


## Stanford Microbiome Bioinformatics Symposium 2019

Thanks for visiting my poster! You can get a copy of the PDF version
[here](https://www.overleaf.com/read/hxsyfmnqtzqf).



## Installation

### Installing with pip

...

And you'll need to fetch the Reactionary reference database as
follows:

`run-reactionary fetch-reference-db /home/username/data/`


### Installing with Docker

Assuming that you already have Docker installed, fetching the Docker
image is as simple as:

```
docker pull quay.io/taltman/reactionary:beta
```

You'll then use the Docker container to fetch the reference
database. First you will open up a shell to the container as follows:

```
sudo docker run -it --rm --network=host -v /home/username/data:/data quay.io/taltman/reactionary:beta bash 
```

And then execute the following from within the contailer shell:

```
run-reactionary fetch-reference-db /data/reactionary.db
```

Make a note of where you downloaded the reactionary reference
database, as it will be needed for calling `run-reactionary`.



## How to run Reactionary on an EggNOG-Mapper output annotation file

### Using Docker

Assuming that you have your PGDB files and EggNOG-Mapper annotation
file in a directory called `/home/username/data`, you can mount that
data directory within the Docker container and get a Bash shell as
follows:

```
sudo docker run -it --rm --network=host -v /home/username/data:/data quay.io/taltman/reactionary:beta bash 
```


From within the container shell, you can run `run-reactionary`. You
can test that `run-reactionary` is working correctly by displaying the
comprehensive command-line help information:

```
run-reactionary --help
```

The following example using Reactionary to predict reactions should work right out of the box:

```
run-reactionary reactionary/test/test.emapper.annotations 679895 /data/
```





# Reactionary Output

Reactionary generates a set of output files in the current directory (or the output directory specified  with the `--output_dir` option):

* `*annot.emapper.annotations.reactionary`
* `reactions.txt`
* `pathways.txt`
* `multi-reaction-proteins.txt`

These files are described in more detail in the following sections.

## `*annot.emapper.annotations.reactionary`

The input to Reactionary consists of a tab-delimited file generated by
the EggNOG-Mapper program [link here], with a name of the pattern
`*annot.emapper.annotations`. This file lists each protein, and it's
associated annotations from EggNOG-Mapper.  After predicting the
reactions present, Reactionary emits a file of the same format as the
input `*annot.emapper.annotations` file, except with an additional
column with a comma-delimited list of MetaCyc reaction
identifiers. This output file retains the same file name format as the
input file, except adds the `.reactionary` suffix at the end.


## `reactions.txt`

The `reactions.txt` file lists all of the reactions predicted by
Reactionary, with a list of all of the supporting information that
lead to that prediction.

For each reaction predicted, there is a line with the MetaCyc reaction
frame-ID in the first column. For each distinct protein that
contributed to the reaction's prediction, there is a subsequent line
below the reaction line that has an empty first column. Below is an
example with the file's header:

```
# Reaction frame ID
# 	Protein ID	NOG	Rank	Taxon ID
CARBOXYLATE-REDUCTASE-RXN
	G6157-MONOMER	3XNYV@561	genus	561
	G6155-MONOMER	3XMZP@561	genus	561
	G6156-MONOMER	3XP71@561	genus	561
```

The non-empty columns have the following semantics:

* "Protein ID": the protein identifier from the `*annot.emapper.annotations` file
* "NOG": the most specific EggNOG orthologous group identifier, and the associated NCBI Taxonomy DB identifier, separated by '@', used for predicting the reaction
* "Rank": the taxonomic rank used by Reactionary to find an associated reaction for the protein
* "Taxon ID": the NCBI Taxonomy DB identifier used by Reactionary to find an associated reaction for the protein


## `pathways.txt`

/This section describes features that are experimental, and have
not been rigorously validated./

The WarPath pathway predictor runs after Reactionary has predicted the
reactome for the input annotation. The predicted pathways are reported
in the `pathways.txt` file, along with data supporting it's prediction. Here is an example entry, along with the
file's header:

```
# Pathway Frame ID	Pathway Name	Enzyme-Info-Content-Norm	Taxonomic Domain(s)	Present Reaction(s)	Missing Reaction(s)	All Key Reactions Present?	Key Reactions	Key Non Reactions Satisfied?	Key Non Reactions
PWY-8121	2-deoxy-D-glucose 6-phosphate degradation	0.250	4751,2	3.1.3.68-RXN	RXN-18513,KDUD-RXN,RXN-18514	False		False	
```

The semantics of the columns are as follows:
* "Pathway Frame ID": the frame-ID of the MetaCyc pathway
* "Pathway Name": the common name of the pathway
* "Enzyme-Info-Content-Norm": a weighted fraction of the present reactions over all of the reactions of the pathway. See Dale et al.[link] for more detail.
* "Taxonomic Domain(s)": a comma-delimited list of NCBI Taxonomy DB identifiers of the taxa where this pathway is expected to be found, as curated in MetaCyc
* "Present Reaction(s)": a comma-delimited list of MetaCyc reaction frame IDs for the pathway which are present
* "Missing Reaction(s)": a comma-delimited list of MetaCyc reaction frame IDs for the pathway which are not present (i.e., "pathway holes")
* "All Key Reactions Present?": are all of the reactions curated as "key reactions" for this pathway in MetaCyc present?
* "Key Reactions": a comma-delimited list of MetaCyc reaction frame IDs for the key reactions of the pathway (if present)
* "All Key Non Reactions Satisfied?": is the logical expression of "key non reactions" for this pathway in MetaCyc true?
* "Key Non Reactions": a comma-delimited list of MetaCyc reaction frame IDs, beginning with a logical "AND" or "OR". If this logical expression evaluates to true, then the pathway is contra-indicated.


## `multi-reaction-proteins.txt`

/This file may not be generated if the input has no multi-reaction proteins that exceed the limit./

Many enzymes are associated with more than a single reaction, either
due to having multiple active sites, or due to a single active site
promiscuously binding to varying substrates. There are some enzymes
that are associated with a very large number of reactions (ten,
twenty, or even thirty). Reactionary will not include the
reactions of an enzyme if it is associated with more than a set number
of reactions (by default, ten), to help control for false
positives. This threshold can be changed using the `--max_reactions`
command-line argument. The protein annotations from EggNOG-Mapper that
have more than this set threshold of associated reactions are reported
in the `multi-reaction-proteins.txt` output file. An example entry
with the file header is shown below:

```
# Protein ID	NOG	Rank	Taxon ID	Reactions
EG11009-MONOMER	3XMC8@561	genus	561	TRANS-RXN0-592,TRANS-RXN-355,TRANS-RXN-377,TRANS-RXN-359,TRANS-RXN-354,TRANS-RXN-92,TRANS-RXN-378,TRANS-RXN-357,TRANS-RXN-365,TRANS-RXN-352,TRANS-RXN-363,TRANS-RXN-356,TRANS-RXN-360,TRANS-RXN-367,TRANS-RXN-364,TRANS-RXN-353
```

The column semantics are as follows:

* "Protein ID": the protein identifier from the EggNOG-Mapper input file
* "NOG": the most-specific EggNOG orthologous group used for predicting reactions
* "Rank": the rank used for predicting the reactions
* "Taxon ID": the NCBI Taxonomy taxon identifier used for predicting the reactions
* "Reactions": a comma-delimited list of MetaCyc reaction frame IDs

## Advanced Usage

### Supplementing the Reactionary reference database

At the heart of the Reactionary reference database, there is a table
that maps MetaCyc reaction frame IDs to EggNOG OG identifiers, of the
form `<OG_ID>@<NCBI_taxon_ID>`, e.g., '3XQB7@561'. The user can create
a tab-delimited text file of such mappings if they are not present in
the Reactionary reference database. Such file might look as follows:

```
2VP2Q@28216	1.2.1.2-RXN
1JRU6@119045	1.2.1.2-RXN
1JS03@119045	1.2.1.2-RXN
```

In the above example, the supplemental file provides three new
connections from the MetaCyc reaction `1.2.1.2-RXN` to EggNOG
entries.

If the file is called `new-refs.txt`, then it can be loaded into the
Reactionary database as follows:

`run-reactionary supplement-reference-db new-refs.txt ref-data/reactionary.db`

In the above example, the Reactionary reference database is located at
`ref-data/reactionary.db`. Once the data loading is complete, the
Reactionary reference database is ready to be used for annotating
EggNOG output files.

### How to evaluate the performance of Reactionary

## Bibliography

