lilypond_version = "2.19.84"

contexts = {
    "ChoirStaff": {
        "accepts": set(
            [
                "ChoirStaff",
                "ChordNames",
                "DrumStaff",
                "Dynamics",
                "FiguredBass",
                "GrandStaff",
                "Lyrics",
                "OneStaff",
                "PianoStaff",
                "RhythmicStaff",
                "Staff",
                "StaffGroup",
            ]
        ),
        "aliases": set([]),
        "consists": set(
            [
                "Instrument_name_engraver",
                "System_start_delimiter_engraver",
                "Vertical_align_engraver",
            ]
        ),
        "default_child": "Staff",
    },
    "ChordNames": {
        "accepts": set([]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Axis_group_engraver",
                "Chord_name_engraver",
                "Output_property_engraver",
                "Separating_line_group_engraver",
            ]
        ),
    },
    "CueVoice": {
        "accepts": set([]),
        "aliases": set(["Voice"]),
        "consists": set(
            [
                "Arpeggio_engraver",
                "Auto_beam_engraver",
                "Beam_engraver",
                "Bend_engraver",
                "Breathing_sign_engraver",
                "Chord_tremolo_engraver",
                "Cluster_spanner_engraver",
                "Dots_engraver",
                "Double_percent_repeat_engraver",
                "Dynamic_align_engraver",
                "Dynamic_engraver",
                "Fingering_engraver",
                "Font_size_engraver",
                "Forbid_line_break_engraver",
                "Glissando_engraver",
                "Grace_auto_beam_engraver",
                "Grace_beam_engraver",
                "Grace_engraver",
                "Grob_pq_engraver",
                "Instrument_switch_engraver",
                "Laissez_vibrer_engraver",
                "Ligature_bracket_engraver",
                "Multi_measure_rest_engraver",
                "New_fingering_engraver",
                "Note_head_line_engraver",
                "Note_heads_engraver",
                "Note_spacing_engraver",
                "Output_property_engraver",
                "Part_combine_engraver",
                "Percent_repeat_engraver",
                "Phrasing_slur_engraver",
                "Pitched_trill_engraver",
                "Repeat_tie_engraver",
                "Rest_engraver",
                "Rhythmic_column_engraver",
                "Script_column_engraver",
                "Script_engraver",
                "Slash_repeat_engraver",
                "Slur_engraver",
                "Spanner_break_forbid_engraver",
                "Stem_engraver",
                "Text_engraver",
                "Text_spanner_engraver",
                "Tie_engraver",
                "Trill_spanner_engraver",
                "Tuplet_engraver",
            ]
        ),
    },
    "Devnull": {
        "accepts": set([]),
        "aliases": set(["Staff", "Voice"]),
        "consists": set([]),
    },
    "DrumStaff": {
        "accepts": set(["CueVoice", "DrumVoice", "NullVoice"]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Axis_group_engraver",
                "Bar_engraver",
                "Clef_engraver",
                "Collision_engraver",
                "Cue_clef_engraver",
                "Dot_column_engraver",
                "Figured_bass_engraver",
                "Figured_bass_position_engraver",
                "Fingering_column_engraver",
                "Font_size_engraver",
                "Grob_pq_engraver",
                "Instrument_name_engraver",
                "Ledger_line_engraver",
                "Output_property_engraver",
                "Piano_pedal_align_engraver",
                "Pure_from_neighbor_engraver",
                "Rest_collision_engraver",
                "Script_row_engraver",
                "Separating_line_group_engraver",
                "Staff_collecting_engraver",
                "Staff_symbol_engraver",
                "Time_signature_engraver",
            ]
        ),
        "default_child": "DrumVoice",
    },
    "DrumVoice": {
        "accepts": set([]),
        "aliases": set(["Voice"]),
        "consists": set(
            [
                "Auto_beam_engraver",
                "Beam_engraver",
                "Bend_engraver",
                "Breathing_sign_engraver",
                "Chord_tremolo_engraver",
                "Dots_engraver",
                "Double_percent_repeat_engraver",
                "Drum_notes_engraver",
                "Dynamic_align_engraver",
                "Dynamic_engraver",
                "Font_size_engraver",
                "Forbid_line_break_engraver",
                "Grace_auto_beam_engraver",
                "Grace_beam_engraver",
                "Grace_engraver",
                "Grob_pq_engraver",
                "Grob_pq_engraver",
                "Instrument_switch_engraver",
                "Laissez_vibrer_engraver",
                "Multi_measure_rest_engraver",
                "Note_spacing_engraver",
                "Output_property_engraver",
                "Part_combine_engraver",
                "Percent_repeat_engraver",
                "Phrasing_slur_engraver",
                "Pitched_trill_engraver",
                "Repeat_tie_engraver",
                "Rest_engraver",
                "Rhythmic_column_engraver",
                "Script_column_engraver",
                "Script_engraver",
                "Slash_repeat_engraver",
                "Slur_engraver",
                "Spanner_break_forbid_engraver",
                "Stem_engraver",
                "Text_engraver",
                "Text_spanner_engraver",
                "Tie_engraver",
                "Trill_spanner_engraver",
                "Tuplet_engraver",
            ]
        ),
    },
    "Dynamics": {
        "accepts": set([]),
        "aliases": set(["Voice"]),
        "consists": set(
            [
                "Axis_group_engraver",
                "Bar_engraver",
                "Dynamic_align_engraver",
                "Dynamic_engraver",
                "Font_size_engraver",
                "Output_property_engraver",
                "Piano_pedal_engraver",
                "Script_engraver",
                "Text_engraver",
                "Text_spanner_engraver",
            ]
        ),
    },
    "FiguredBass": {
        "accepts": set([]),
        "aliases": set([]),
        "consists": set(
            [
                "Axis_group_engraver",
                "Figured_bass_engraver",
                "Separating_line_group_engraver",
            ]
        ),
    },
    "FretBoards": {
        "accepts": set([]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Axis_group_engraver",
                "Font_size_engraver",
                "Fretboard_engraver",
                "Instrument_name_engraver",
                "Output_property_engraver",
                "Separating_line_group_engraver",
            ]
        ),
    },
    "Global": {
        "accepts": set(["Score"]),
        "aliases": set([]),
        "consists": set([]),
        "default_child": "Score",
    },
    "GrandStaff": {
        "accepts": set(
            [
                "ChordNames",
                "DrumStaff",
                "Dynamics",
                "FiguredBass",
                "Lyrics",
                "RhythmicStaff",
                "Staff",
                "TabStaff",
            ]
        ),
        "aliases": set([]),
        "consists": set(
            [
                "Instrument_name_engraver",
                "Span_arpeggio_engraver",
                "Span_bar_engraver",
                "Span_bar_stub_engraver",
                "System_start_delimiter_engraver",
                "Vertical_align_engraver",
            ]
        ),
        "default_child": "Staff",
    },
    "GregorianTranscriptionStaff": {
        "accepts": set(["CueVoice", "GregorianTranscriptionVoice", "NullVoice"]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Accidental_engraver",
                "Axis_group_engraver",
                "Bar_engraver",
                "Clef_engraver",
                "Collision_engraver",
                "Cue_clef_engraver",
                "Dot_column_engraver",
                "Figured_bass_engraver",
                "Figured_bass_position_engraver",
                "Fingering_column_engraver",
                "Font_size_engraver",
                "Grob_pq_engraver",
                "Instrument_name_engraver",
                "Key_engraver",
                "Ledger_line_engraver",
                "Ottava_spanner_engraver",
                "Output_property_engraver",
                "Piano_pedal_align_engraver",
                "Piano_pedal_engraver",
                "Pure_from_neighbor_engraver",
                "Rest_collision_engraver",
                "Script_row_engraver",
                "Separating_line_group_engraver",
                "Staff_collecting_engraver",
                "Staff_symbol_engraver",
                "Time_signature_engraver",
            ]
        ),
        "default_child": "GregorianTranscriptionVoice",
    },
    "GregorianTranscriptionVoice": {
        "accepts": set([]),
        "aliases": set(["Voice"]),
        "consists": set(
            [
                "Arpeggio_engraver",
                "Auto_beam_engraver",
                "Beam_engraver",
                "Bend_engraver",
                "Breathing_sign_engraver",
                "Chord_tremolo_engraver",
                "Cluster_spanner_engraver",
                "Dots_engraver",
                "Double_percent_repeat_engraver",
                "Dynamic_align_engraver",
                "Dynamic_engraver",
                "Episema_engraver",
                "Fingering_engraver",
                "Font_size_engraver",
                "Forbid_line_break_engraver",
                "Glissando_engraver",
                "Grace_auto_beam_engraver",
                "Grace_beam_engraver",
                "Grace_engraver",
                "Grob_pq_engraver",
                "Instrument_switch_engraver",
                "Laissez_vibrer_engraver",
                "Ligature_bracket_engraver",
                "Multi_measure_rest_engraver",
                "New_fingering_engraver",
                "Note_head_line_engraver",
                "Note_heads_engraver",
                "Note_spacing_engraver",
                "Output_property_engraver",
                "Part_combine_engraver",
                "Percent_repeat_engraver",
                "Phrasing_slur_engraver",
                "Pitched_trill_engraver",
                "Repeat_tie_engraver",
                "Rest_engraver",
                "Rhythmic_column_engraver",
                "Script_column_engraver",
                "Script_engraver",
                "Slash_repeat_engraver",
                "Slur_engraver",
                "Spanner_break_forbid_engraver",
                "Stem_engraver",
                "Text_engraver",
                "Text_spanner_engraver",
                "Tie_engraver",
                "Trill_spanner_engraver",
                "Tuplet_engraver",
            ]
        ),
    },
    "KievanStaff": {
        "accepts": set(["CueVoice", "KievanVoice", "NullVoice"]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Accidental_engraver",
                "Axis_group_engraver",
                "Bar_engraver",
                "Clef_engraver",
                "Collision_engraver",
                "Cue_clef_engraver",
                "Dot_column_engraver",
                "Figured_bass_engraver",
                "Figured_bass_position_engraver",
                "Fingering_column_engraver",
                "Font_size_engraver",
                "Grob_pq_engraver",
                "Instrument_name_engraver",
                "Key_engraver",
                "Ledger_line_engraver",
                "Ottava_spanner_engraver",
                "Output_property_engraver",
                "Piano_pedal_align_engraver",
                "Piano_pedal_engraver",
                "Pure_from_neighbor_engraver",
                "Rest_collision_engraver",
                "Script_row_engraver",
                "Separating_line_group_engraver",
                "Staff_collecting_engraver",
                "Staff_symbol_engraver",
            ]
        ),
        "default_child": "KievanVoice",
    },
    "KievanVoice": {
        "accepts": set([]),
        "aliases": set(["Voice"]),
        "consists": set(
            [
                "Arpeggio_engraver",
                "Auto_beam_engraver",
                "Beam_engraver",
                "Bend_engraver",
                "Breathing_sign_engraver",
                "Chord_tremolo_engraver",
                "Cluster_spanner_engraver",
                "Dots_engraver",
                "Double_percent_repeat_engraver",
                "Dynamic_align_engraver",
                "Dynamic_engraver",
                "Fingering_engraver",
                "Font_size_engraver",
                "Forbid_line_break_engraver",
                "Glissando_engraver",
                "Grace_auto_beam_engraver",
                "Grace_beam_engraver",
                "Grace_engraver",
                "Grob_pq_engraver",
                "Instrument_switch_engraver",
                "Kievan_ligature_engraver",
                "Laissez_vibrer_engraver",
                "Multi_measure_rest_engraver",
                "New_fingering_engraver",
                "Note_head_line_engraver",
                "Note_heads_engraver",
                "Note_spacing_engraver",
                "Output_property_engraver",
                "Part_combine_engraver",
                "Percent_repeat_engraver",
                "Phrasing_slur_engraver",
                "Pitched_trill_engraver",
                "Repeat_tie_engraver",
                "Rest_engraver",
                "Rhythmic_column_engraver",
                "Script_column_engraver",
                "Script_engraver",
                "Slash_repeat_engraver",
                "Slur_engraver",
                "Spanner_break_forbid_engraver",
                "Stem_engraver",
                "Text_engraver",
                "Text_spanner_engraver",
                "Tie_engraver",
                "Trill_spanner_engraver",
                "Tuplet_engraver",
            ]
        ),
    },
    "Lyrics": {
        "accepts": set([]),
        "aliases": set([]),
        "consists": set(
            [
                "Axis_group_engraver",
                "Extender_engraver",
                "Font_size_engraver",
                "Hyphen_engraver",
                "Instrument_name_engraver",
                "Lyric_engraver",
                "Pure_from_neighbor_engraver",
                "Stanza_number_engraver",
            ]
        ),
    },
    "MensuralStaff": {
        "accepts": set(["CueVoice", "MensuralVoice", "NullVoice"]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Accidental_engraver",
                "Axis_group_engraver",
                "Bar_engraver",
                "Clef_engraver",
                "Collision_engraver",
                "Cue_clef_engraver",
                "Custos_engraver",
                "Dot_column_engraver",
                "Figured_bass_engraver",
                "Figured_bass_position_engraver",
                "Fingering_column_engraver",
                "Font_size_engraver",
                "Grob_pq_engraver",
                "Instrument_name_engraver",
                "Key_engraver",
                "Ledger_line_engraver",
                "Ottava_spanner_engraver",
                "Output_property_engraver",
                "Piano_pedal_align_engraver",
                "Piano_pedal_engraver",
                "Pure_from_neighbor_engraver",
                "Rest_collision_engraver",
                "Script_row_engraver",
                "Separating_line_group_engraver",
                "Staff_collecting_engraver",
                "Staff_symbol_engraver",
                "Time_signature_engraver",
            ]
        ),
        "default_child": "MensuralVoice",
    },
    "MensuralVoice": {
        "accepts": set([]),
        "aliases": set(["Voice"]),
        "consists": set(
            [
                "Arpeggio_engraver",
                "Auto_beam_engraver",
                "Beam_engraver",
                "Bend_engraver",
                "Breathing_sign_engraver",
                "Chord_tremolo_engraver",
                "Cluster_spanner_engraver",
                "Dots_engraver",
                "Double_percent_repeat_engraver",
                "Dynamic_align_engraver",
                "Dynamic_engraver",
                "Fingering_engraver",
                "Font_size_engraver",
                "Forbid_line_break_engraver",
                "Glissando_engraver",
                "Grace_auto_beam_engraver",
                "Grace_beam_engraver",
                "Grace_engraver",
                "Grob_pq_engraver",
                "Instrument_switch_engraver",
                "Laissez_vibrer_engraver",
                "Mensural_ligature_engraver",
                "Multi_measure_rest_engraver",
                "New_fingering_engraver",
                "Note_head_line_engraver",
                "Note_heads_engraver",
                "Note_spacing_engraver",
                "Output_property_engraver",
                "Part_combine_engraver",
                "Percent_repeat_engraver",
                "Phrasing_slur_engraver",
                "Pitched_trill_engraver",
                "Repeat_tie_engraver",
                "Rest_engraver",
                "Rhythmic_column_engraver",
                "Script_column_engraver",
                "Script_engraver",
                "Slash_repeat_engraver",
                "Spanner_break_forbid_engraver",
                "Stem_engraver",
                "Text_engraver",
                "Text_spanner_engraver",
                "Tie_engraver",
                "Trill_spanner_engraver",
                "Tuplet_engraver",
            ]
        ),
    },
    "NoteNames": {
        "accepts": set([]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Axis_group_engraver",
                "Note_name_engraver",
                "Separating_line_group_engraver",
                "Tie_engraver",
            ]
        ),
    },
    "NullVoice": {
        "accepts": set([]),
        "aliases": set(["Staff", "Voice"]),
        "consists": set(
            [
                "Beam_engraver",
                "Grob_pq_engraver",
                "Note_heads_engraver",
                "Pitch_squash_engraver",
                "Slur_engraver",
                "Tie_engraver",
            ]
        ),
    },
    "OneStaff": {
        "accepts": set(
            [
                "ChordNames",
                "DrumStaff",
                "Dynamics",
                "FiguredBass",
                "FretBoards",
                "GregorianTranscriptionStaff",
                "KievanStaff",
                "Lyrics",
                "MensuralStaff",
                "NoteNames",
                "PetrucciStaff",
                "RhythmicStaff",
                "Staff",
                "TabStaff",
                "VaticanaStaff",
            ]
        ),
        "aliases": set([]),
        "consists": set(["Axis_group_engraver"]),
        "default_child": "Staff",
    },
    "PetrucciStaff": {
        "accepts": set(["CueVoice", "NullVoice", "PetrucciVoice"]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Accidental_engraver",
                "Axis_group_engraver",
                "Bar_engraver",
                "Clef_engraver",
                "Collision_engraver",
                "Cue_clef_engraver",
                "Custos_engraver",
                "Dot_column_engraver",
                "Figured_bass_engraver",
                "Figured_bass_position_engraver",
                "Fingering_column_engraver",
                "Font_size_engraver",
                "Grob_pq_engraver",
                "Instrument_name_engraver",
                "Key_engraver",
                "Ledger_line_engraver",
                "Ottava_spanner_engraver",
                "Output_property_engraver",
                "Piano_pedal_align_engraver",
                "Piano_pedal_engraver",
                "Pure_from_neighbor_engraver",
                "Rest_collision_engraver",
                "Script_row_engraver",
                "Separating_line_group_engraver",
                "Staff_collecting_engraver",
                "Staff_symbol_engraver",
                "Time_signature_engraver",
            ]
        ),
        "default_child": "PetrucciVoice",
    },
    "PetrucciVoice": {
        "accepts": set([]),
        "aliases": set(["Voice"]),
        "consists": set(
            [
                "Arpeggio_engraver",
                "Auto_beam_engraver",
                "Beam_engraver",
                "Bend_engraver",
                "Breathing_sign_engraver",
                "Chord_tremolo_engraver",
                "Cluster_spanner_engraver",
                "Dots_engraver",
                "Double_percent_repeat_engraver",
                "Dynamic_align_engraver",
                "Dynamic_engraver",
                "Fingering_engraver",
                "Font_size_engraver",
                "Forbid_line_break_engraver",
                "Glissando_engraver",
                "Grace_auto_beam_engraver",
                "Grace_beam_engraver",
                "Grace_engraver",
                "Grob_pq_engraver",
                "Instrument_switch_engraver",
                "Laissez_vibrer_engraver",
                "Mensural_ligature_engraver",
                "Multi_measure_rest_engraver",
                "New_fingering_engraver",
                "Note_head_line_engraver",
                "Note_heads_engraver",
                "Note_spacing_engraver",
                "Output_property_engraver",
                "Part_combine_engraver",
                "Percent_repeat_engraver",
                "Phrasing_slur_engraver",
                "Pitched_trill_engraver",
                "Repeat_tie_engraver",
                "Rest_engraver",
                "Rhythmic_column_engraver",
                "Script_column_engraver",
                "Script_engraver",
                "Slash_repeat_engraver",
                "Slur_engraver",
                "Spanner_break_forbid_engraver",
                "Stem_engraver",
                "Text_engraver",
                "Text_spanner_engraver",
                "Tie_engraver",
                "Trill_spanner_engraver",
                "Tuplet_engraver",
            ]
        ),
    },
    "PianoStaff": {
        "accepts": set(
            [
                "ChordNames",
                "DrumStaff",
                "Dynamics",
                "FiguredBass",
                "Lyrics",
                "RhythmicStaff",
                "Staff",
                "TabStaff",
            ]
        ),
        "aliases": set(["GrandStaff"]),
        "consists": set(
            [
                "Instrument_name_engraver",
                "Keep_alive_together_engraver",
                "Span_arpeggio_engraver",
                "Span_bar_engraver",
                "Span_bar_stub_engraver",
                "System_start_delimiter_engraver",
                "Vertical_align_engraver",
                "Vertical_align_engraver",
            ]
        ),
        "default_child": "Staff",
    },
    "RhythmicStaff": {
        "accepts": set(["CueVoice", "NullVoice", "Voice"]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Axis_group_engraver",
                "Bar_engraver",
                "Dot_column_engraver",
                "Font_size_engraver",
                "Instrument_name_engraver",
                "Ledger_line_engraver",
                "Output_property_engraver",
                "Pitch_squash_engraver",
                "Separating_line_group_engraver",
                "Staff_symbol_engraver",
                "Time_signature_engraver",
            ]
        ),
        "default_child": "Voice",
    },
    "Score": {
        "accepts": set(
            [
                "ChoirStaff",
                "ChordNames",
                "Devnull",
                "DrumStaff",
                "Dynamics",
                "FiguredBass",
                "FretBoards",
                "GrandStaff",
                "GregorianTranscriptionStaff",
                "KievanStaff",
                "Lyrics",
                "MensuralStaff",
                "NoteNames",
                "OneStaff",
                "PetrucciStaff",
                "PianoStaff",
                "RhythmicStaff",
                "Staff",
                "StaffGroup",
                "TabStaff",
                "VaticanaStaff",
            ]
        ),
        "aliases": set(["Timing"]),
        "consists": set(
            [
                "Bar_number_engraver",
                "Beam_collision_engraver",
                "Break_align_engraver",
                "Concurrent_hairpin_engraver",
                "Default_bar_line_engraver",
                "Footnote_engraver",
                "Grace_spacing_engraver",
                "Mark_engraver",
                "Metronome_mark_engraver",
                "Output_property_engraver",
                "Paper_column_engraver",
                "Parenthesis_engraver",
                "Repeat_acknowledge_engraver",
                "Spacing_engraver",
                "Staff_collecting_engraver",
                "Stanza_number_align_engraver",
                "System_start_delimiter_engraver",
                "Timing_translator",
                "Tweak_engraver",
                "Vertical_align_engraver",
                "Volta_engraver",
            ]
        ),
        "default_child": "Staff",
    },
    "Staff": {
        "accepts": set(["CueVoice", "NullVoice", "Voice"]),
        "aliases": set([]),
        "consists": set(
            [
                "Accidental_engraver",
                "Axis_group_engraver",
                "Bar_engraver",
                "Clef_engraver",
                "Collision_engraver",
                "Cue_clef_engraver",
                "Dot_column_engraver",
                "Figured_bass_engraver",
                "Figured_bass_position_engraver",
                "Fingering_column_engraver",
                "Font_size_engraver",
                "Grob_pq_engraver",
                "Instrument_name_engraver",
                "Key_engraver",
                "Ledger_line_engraver",
                "Ottava_spanner_engraver",
                "Output_property_engraver",
                "Piano_pedal_align_engraver",
                "Piano_pedal_engraver",
                "Pure_from_neighbor_engraver",
                "Rest_collision_engraver",
                "Script_row_engraver",
                "Separating_line_group_engraver",
                "Staff_collecting_engraver",
                "Staff_symbol_engraver",
                "Time_signature_engraver",
            ]
        ),
        "default_child": "Voice",
    },
    "StaffGroup": {
        "accepts": set(
            [
                "ChoirStaff",
                "ChordNames",
                "DrumStaff",
                "FiguredBass",
                "FretBoards",
                "GrandStaff",
                "Lyrics",
                "OneStaff",
                "PianoStaff",
                "RhythmicStaff",
                "Staff",
                "StaffGroup",
                "TabStaff",
            ]
        ),
        "aliases": set([]),
        "consists": set(
            [
                "Instrument_name_engraver",
                "Output_property_engraver",
                "Span_arpeggio_engraver",
                "Span_bar_engraver",
                "Span_bar_stub_engraver",
                "System_start_delimiter_engraver",
                "Vertical_align_engraver",
            ]
        ),
        "default_child": "Staff",
    },
    "TabStaff": {
        "accepts": set(["CueVoice", "NullVoice", "TabVoice"]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Axis_group_engraver",
                "Bar_engraver",
                "Clef_engraver",
                "Collision_engraver",
                "Cue_clef_engraver",
                "Dot_column_engraver",
                "Figured_bass_engraver",
                "Figured_bass_position_engraver",
                "Fingering_column_engraver",
                "Font_size_engraver",
                "Grob_pq_engraver",
                "Instrument_name_engraver",
                "Ledger_line_engraver",
                "Output_property_engraver",
                "Piano_pedal_align_engraver",
                "Piano_pedal_engraver",
                "Pure_from_neighbor_engraver",
                "Rest_collision_engraver",
                "Script_row_engraver",
                "Separating_line_group_engraver",
                "Staff_collecting_engraver",
                "Staff_symbol_engraver",
                "Tab_staff_symbol_engraver",
                "Time_signature_engraver",
            ]
        ),
        "default_child": "TabVoice",
    },
    "TabVoice": {
        "accepts": set([]),
        "aliases": set(["Voice"]),
        "consists": set(
            [
                "Arpeggio_engraver",
                "Auto_beam_engraver",
                "Beam_engraver",
                "Bend_engraver",
                "Breathing_sign_engraver",
                "Chord_tremolo_engraver",
                "Cluster_spanner_engraver",
                "Dots_engraver",
                "Double_percent_repeat_engraver",
                "Dynamic_align_engraver",
                "Dynamic_engraver",
                "Font_size_engraver",
                "Forbid_line_break_engraver",
                "Glissando_engraver",
                "Grace_auto_beam_engraver",
                "Grace_beam_engraver",
                "Grace_engraver",
                "Grob_pq_engraver",
                "Instrument_switch_engraver",
                "Laissez_vibrer_engraver",
                "Ligature_bracket_engraver",
                "Multi_measure_rest_engraver",
                "Note_head_line_engraver",
                "Note_spacing_engraver",
                "Output_property_engraver",
                "Part_combine_engraver",
                "Percent_repeat_engraver",
                "Phrasing_slur_engraver",
                "Repeat_tie_engraver",
                "Rest_engraver",
                "Rhythmic_column_engraver",
                "Script_column_engraver",
                "Script_engraver",
                "Slash_repeat_engraver",
                "Slur_engraver",
                "Spanner_break_forbid_engraver",
                "Stem_engraver",
                "Tab_note_heads_engraver",
                "Tab_tie_follow_engraver",
                "Text_engraver",
                "Text_spanner_engraver",
                "Tie_engraver",
                "Trill_spanner_engraver",
                "Tuplet_engraver",
            ]
        ),
    },
    "VaticanaStaff": {
        "accepts": set(["CueVoice", "NullVoice", "VaticanaVoice"]),
        "aliases": set(["Staff"]),
        "consists": set(
            [
                "Accidental_engraver",
                "Axis_group_engraver",
                "Bar_engraver",
                "Clef_engraver",
                "Collision_engraver",
                "Cue_clef_engraver",
                "Custos_engraver",
                "Dot_column_engraver",
                "Figured_bass_engraver",
                "Figured_bass_position_engraver",
                "Fingering_column_engraver",
                "Font_size_engraver",
                "Grob_pq_engraver",
                "Instrument_name_engraver",
                "Key_engraver",
                "Ledger_line_engraver",
                "Ottava_spanner_engraver",
                "Output_property_engraver",
                "Piano_pedal_align_engraver",
                "Piano_pedal_engraver",
                "Pure_from_neighbor_engraver",
                "Rest_collision_engraver",
                "Script_row_engraver",
                "Separating_line_group_engraver",
                "Staff_collecting_engraver",
                "Staff_symbol_engraver",
            ]
        ),
        "default_child": "VaticanaVoice",
    },
    "VaticanaVoice": {
        "accepts": set([]),
        "aliases": set(["Voice"]),
        "consists": set(
            [
                "Arpeggio_engraver",
                "Auto_beam_engraver",
                "Beam_engraver",
                "Bend_engraver",
                "Breathing_sign_engraver",
                "Chord_tremolo_engraver",
                "Cluster_spanner_engraver",
                "Dots_engraver",
                "Double_percent_repeat_engraver",
                "Dynamic_align_engraver",
                "Dynamic_engraver",
                "Episema_engraver",
                "Fingering_engraver",
                "Font_size_engraver",
                "Forbid_line_break_engraver",
                "Glissando_engraver",
                "Grace_auto_beam_engraver",
                "Grace_beam_engraver",
                "Grace_engraver",
                "Grob_pq_engraver",
                "Instrument_switch_engraver",
                "Laissez_vibrer_engraver",
                "Multi_measure_rest_engraver",
                "New_fingering_engraver",
                "Note_head_line_engraver",
                "Note_heads_engraver",
                "Note_spacing_engraver",
                "Output_property_engraver",
                "Part_combine_engraver",
                "Percent_repeat_engraver",
                "Phrasing_slur_engraver",
                "Pitched_trill_engraver",
                "Repeat_tie_engraver",
                "Rest_engraver",
                "Rhythmic_column_engraver",
                "Script_column_engraver",
                "Script_engraver",
                "Slash_repeat_engraver",
                "Spanner_break_forbid_engraver",
                "Text_engraver",
                "Tie_engraver",
                "Trill_spanner_engraver",
                "Tuplet_engraver",
                "Vaticana_ligature_engraver",
            ]
        ),
    },
    "Voice": {
        "accepts": set([]),
        "aliases": set([]),
        "consists": set(
            [
                "Arpeggio_engraver",
                "Auto_beam_engraver",
                "Beam_engraver",
                "Bend_engraver",
                "Breathing_sign_engraver",
                "Chord_tremolo_engraver",
                "Cluster_spanner_engraver",
                "Dots_engraver",
                "Double_percent_repeat_engraver",
                "Dynamic_align_engraver",
                "Dynamic_engraver",
                "Fingering_engraver",
                "Font_size_engraver",
                "Forbid_line_break_engraver",
                "Glissando_engraver",
                "Grace_auto_beam_engraver",
                "Grace_beam_engraver",
                "Grace_engraver",
                "Grob_pq_engraver",
                "Instrument_switch_engraver",
                "Laissez_vibrer_engraver",
                "Ligature_bracket_engraver",
                "Multi_measure_rest_engraver",
                "New_fingering_engraver",
                "Note_head_line_engraver",
                "Note_heads_engraver",
                "Note_spacing_engraver",
                "Output_property_engraver",
                "Part_combine_engraver",
                "Percent_repeat_engraver",
                "Phrasing_slur_engraver",
                "Pitched_trill_engraver",
                "Repeat_tie_engraver",
                "Rest_engraver",
                "Rhythmic_column_engraver",
                "Script_column_engraver",
                "Script_engraver",
                "Slash_repeat_engraver",
                "Slur_engraver",
                "Spanner_break_forbid_engraver",
                "Stem_engraver",
                "Text_engraver",
                "Text_spanner_engraver",
                "Tie_engraver",
                "Trill_spanner_engraver",
                "Tuplet_engraver",
            ]
        ),
    },
}

lilypond_version = "2.19.84"

current_module = {
    "$current-book": "$current-book",
    "$current-bookpart": "$current-bookpart",
    "$defaultheader": "$defaultheader",
    "$defaultlayout": "$defaultlayout",
    "$defaultmidi": "$defaultmidi",
    "$defaultpaper": "$defaultpaper",
    "%module-public-interface": "%module-public-interface",
    "(": {
        "name": "SlurEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "slur-event",
        ),
    },
    ")": {
        "name": "SlurEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "slur-event",
        ),
    },
    "RemoveAllEmptyStaves": "RemoveAllEmptyStaves",
    "RemoveEmptyStaves": "RemoveEmptyStaves",
    "[": {
        "name": "BeamEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "beam-event",
            "span-event",
        ),
    },
    r"\!": {
        "name": "CrescendoEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "crescendo-event",
            "event",
        ),
    },
    r"\(": {
        "name": "PhrasingSlurEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "phrasing-slur-event",
        ),
    },
    r"\)": {
        "name": "PhrasingSlurEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "phrasing-slur-event",
        ),
    },
    r"\<": {
        "name": "CrescendoEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "crescendo-event",
            "event",
        ),
    },
    r"\=": {
        "signature": (
            "ly:event?",
            "key?",
            "ly:event?",
        ),
        "type": "ly:music-function?",
    },
    r"\>": {
        "name": "DecrescendoEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "decrescendo-event",
            "event",
        ),
    },
    r"\[": {
        "name": "LigatureEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "span-event",
            "ligature-event",
            "event",
        ),
    },
    "\\": {"name": "VoiceSeparator", "type": "ly:prob?", "types": ("separator",)},
    r"\]": {
        "name": "LigatureEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "span-event",
            "ligature-event",
            "event",
        ),
    },
    r"\~": {
        "name": "PesOrFlexaEvent",
        "type": "ly:prob?",
        "types": (
            "pes-or-flexa-event",
            "event",
        ),
    },
    "]": {
        "name": "BeamEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "beam-event",
            "span-event",
        ),
    },
    "absolute": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "absolute-volume-alist": "absolute-volume-alist",
    "accent": {
        "articulation-type": "accent",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "acciaccatura": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "accidental-styles": "accidental-styles",
    "accidentalStyle": {
        "signature": (
            "ly:music?",
            "symbol-list?",
        ),
        "type": "ly:music-function?",
    },
    "add-toc-item!": "add-toc-item!",
    "addChordShape": {
        "signature": (
            "void?",
            "symbol?",
            "pair?",
            "string-or-pair?",
        ),
        "type": "ly:music-function?",
    },
    "addInstrumentDefinition": {
        "signature": (
            "void?",
            "string?",
            "list?",
        ),
        "type": "ly:music-function?",
    },
    "addQuote": {
        "signature": (
            "void?",
            "string?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "aeolian": "aeolian",
    "afterGrace": {
        "signature": (
            "ly:music?",
            "optional?",
            "fraction?",
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "afterGraceFraction": "afterGraceFraction",
    "agostini-drums-style": "agostini-drums-style",
    "aikenHeads": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "aikenHeadsMinor": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "all-grob-descriptions": "all-grob-descriptions",
    "allowPageTurn": {"signature": ("ly:music?",), "type": "ly:music-function?"},
    "allowVoltaHook": {
        "signature": (
            "void?",
            "string?",
        ),
        "type": "ly:music-function?",
    },
    "alterBroken": {
        "signature": (
            "ly:music?",
            "key-list-or-symbol?",
            "list?",
            "key-list-or-music?",
        ),
        "type": "ly:music-function?",
    },
    "appendToTag": {
        "signature": (
            "ly:music?",
            "symbol?",
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "applyContext": {
        "signature": (
            "ly:music?",
            "procedure?",
        ),
        "type": "ly:music-function?",
    },
    "applyMusic": {
        "signature": (
            "ly:music?",
            "procedure?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "applyOutput": {
        "signature": (
            "ly:music?",
            "symbol-list-or-symbol?",
            "procedure?",
        ),
        "type": "ly:music-function?",
    },
    "appoggiatura": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "arabicStringNumbers": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "arpeggio": {
        "name": "ArpeggioEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "arpeggio-event",
            "event",
        ),
    },
    "arpeggioArrowDown": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "arpeggioArrowUp": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "arpeggioBracket": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "arpeggioNormal": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "arpeggioParenthesis": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "arpeggioParenthesisDashed": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "assertBeamQuant": {
        "signature": (
            "ly:music?",
            "pair?",
            "pair?",
        ),
        "type": "ly:music-function?",
    },
    "assertBeamSlope": {
        "signature": (
            "ly:music?",
            "procedure?",
        ),
        "type": "ly:music-function?",
    },
    "autoBeamOff": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "autoBeamOn": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "autoBreaksOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "autoBreaksOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "autoLineBreaksOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "autoLineBreaksOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "autoPageBreaksOff": {
        "context-type": "Score",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "autoPageBreaksOn": {
        "context-type": "Score",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "autochange": {
        "signature": (
            "ly:music?",
            "optional?",
            "ly:pitch?",
            "optional?",
            "ly:context-mod?",
            "optional?",
            "ly:context-mod?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "balloonGrobText": {
        "signature": (
            "ly:music?",
            "symbol?",
            "number-pair?",
            "cheap-markup?",
        ),
        "type": "ly:music-function?",
    },
    "balloonLengthOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "balloonLengthOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "balloonText": {
        "signature": (
            "ly:event?",
            "number-pair?",
            "cheap-markup?",
        ),
        "type": "ly:music-function?",
    },
    "banjo-c-tuning": "banjo-c-tuning",
    "banjo-modal-tuning": "banjo-modal-tuning",
    "banjo-open-d-tuning": "banjo-open-d-tuning",
    "banjo-open-dm-tuning": "banjo-open-dm-tuning",
    "banjo-open-g-tuning": "banjo-open-g-tuning",
    "bar": {
        "signature": (
            "ly:music?",
            "string?",
        ),
        "type": "ly:music-function?",
    },
    "barNumberCheck": {
        "signature": (
            "ly:music?",
            "integer?",
        ),
        "type": "ly:music-function?",
    },
    "baritone-ukulele-tuning": "baritone-ukulele-tuning",
    "bass-drop-d-tuning": "bass-drop-d-tuning",
    "bass-five-string-tuning": "bass-five-string-tuning",
    "bass-four-string-tuning": "bass-four-string-tuning",
    "bass-six-string-tuning": "bass-six-string-tuning",
    "bass-tuning": "bass-tuning",
    "bassFigureExtendersOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "bassFigureExtendersOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "bassFigureStaffAlignmentDown": {
        "context-type": "Staff",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "bassFigureStaffAlignmentNeutral": {
        "context-type": "Staff",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "bassFigureStaffAlignmentUp": {
        "context-type": "Staff",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "beamExceptions": {
        "signature": (
            "scheme?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "bendAfter": {
        "signature": (
            "ly:event?",
            "real?",
        ),
        "type": "ly:music-function?",
    },
    "bigger": 1,
    "blackTriangleMarkup": "blackTriangleMarkup",
    "bongos-style": "bongos-style",
    "book-bookpart-handler": "book-bookpart-handler",
    "book-music-handler": "book-music-handler",
    "book-score-handler": "book-score-handler",
    "book-text-handler": "book-text-handler",
    "bookOutputName": {
        "signature": (
            "void?",
            "string?",
        ),
        "type": "ly:music-function?",
    },
    "bookOutputSuffix": {
        "signature": (
            "void?",
            "string?",
        ),
        "type": "ly:music-function?",
    },
    "bookpart-music-handler": "bookpart-music-handler",
    "bookpart-score-handler": "bookpart-score-handler",
    "bookpart-text-handler": "bookpart-text-handler",
    "break": {
        "name": "LineBreakEvent",
        "type": "ly:prob?",
        "types": (
            "line-break-event",
            "break-event",
            "event",
        ),
    },
    "breakDynamicSpan": {
        "name": "BreakDynamicSpanEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "break-span-event",
            "break-dynamic-span-event",
            "event",
        ),
    },
    "breathe": {"signature": ("ly:music?",), "type": "ly:music-function?"},
    # "breve": LilyPondDuration(Duration(2, 1), None),
    "cadenzaOff": {
        "context-type": "Timing",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "cadenzaOn": {
        "context-type": "Timing",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "cello-tuning": "cello-tuning",
    "center": 0,
    "chord-shape": "chord-shape",
    "chord-shape-table": "chord-shape-table",
    "chordRepeats": {
        "signature": (
            "ly:music?",
            "optional?",
            "list?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "chordmodifiers": "chordmodifiers",
    "clef": {
        "signature": (
            "ly:music?",
            "string?",
        ),
        "type": "ly:music-function?",
    },
    "coda": {
        "articulation-type": "coda",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "compoundMeter": {
        "signature": (
            "ly:music?",
            "pair?",
        ),
        "type": "ly:music-function?",
    },
    "compressFullBarRests": {
        "context-type": "Score",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "compressMMRests": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "congas-style": "congas-style",
    "context-mod-music-handler": "context-mod-music-handler",
    "cr": {
        "name": "CrescendoEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "crescendo-event",
            "event",
        ),
    },
    "cresc": {
        "name": "CrescendoEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "crescendo-event",
            "event",
        ),
    },
    "crescHairpin": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "crescTextCresc": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "cross-style": "cross-style",
    "crossStaff": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "cueClef": {
        "signature": (
            "ly:music?",
            "string?",
        ),
        "type": "ly:music-function?",
    },
    "cueClefUnset": {"signature": ("ly:music?",), "type": "ly:music-function?"},
    "cueDuring": {
        "signature": (
            "ly:music?",
            "string?",
            "ly:dir?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "cueDuringWithClef": {
        "signature": (
            "ly:music?",
            "string?",
            "ly:dir?",
            "string?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "dashBang": {
        "articulation-type": "staccatissimo",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "dashDash": {
        "articulation-type": "tenuto",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "dashDot": {
        "articulation-type": "staccato",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "dashHat": {
        "articulation-type": "marcato",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "dashLarger": {
        "articulation-type": "accent",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "dashPlus": {
        "articulation-type": "stopped",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "dashUnderscore": {
        "articulation-type": "portato",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "deadNote": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "deadNotesOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "deadNotesOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "decr": {
        "name": "DecrescendoEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "decrescendo-event",
            "event",
        ),
    },
    "decresc": {
        "name": "DecrescendoEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "decrescendo-event",
            "event",
        ),
    },
    "default-fret-table": "default-fret-table",
    "default-language": None,
    "defaultNoteHeads": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "defaultStringTunings": "defaultStringTunings",
    "defaultTimeSignature": {
        "context-type": "Staff",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "defineBarLine": {
        "signature": (
            "void?",
            "string?",
            "list?",
        ),
        "type": "ly:music-function?",
    },
    "deprecatedcresc": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "deprecateddim": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "deprecatedendcresc": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "deprecatedenddim": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "dim": {
        "name": "DecrescendoEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "decrescendo-event",
            "event",
        ),
    },
    "dimHairpin": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "dimTextDecr": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "dimTextDecresc": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "dimTextDim": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "displayLilyMusic": {
        "signature": (
            "ly:music?",
            "optional?",
            "output-port?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "displayMusic": {
        "signature": (
            "ly:music?",
            "optional?",
            "output-port?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "displayScheme": {
        "signature": (
            "scheme?",
            "optional?",
            "output-port?",
            "scheme?",
        ),
        "type": "ly:music-function?",
    },
    "dorian": "dorian",
    "dotsDown": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "dotsNeutral": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "dotsUp": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "double-bass-tuning": "double-bass-tuning",
    "down": -1,
    "downbow": {
        "articulation-type": "downbow",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "downmordent": {
        "articulation-type": "downmordent",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "downprall": {
        "articulation-type": "downprall",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "drumPitchNames": "drumPitchNames",
    "drums-style": "drums-style",
    "dynamicDown": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "dynamicNeutral": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "dynamicUp": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "easyHeadsOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "easyHeadsOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "endSpanners": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "endcr": {
        "name": "CrescendoEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "crescendo-event",
            "event",
        ),
    },
    "endcresc": {
        "name": "CrescendoEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "crescendo-event",
            "event",
        ),
    },
    "enddecr": {
        "name": "DecrescendoEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "decrescendo-event",
            "event",
        ),
    },
    "enddecresc": {
        "name": "DecrescendoEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "decrescendo-event",
            "event",
        ),
    },
    "enddim": {
        "name": "DecrescendoEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "span-dynamic-event",
            "decrescendo-event",
            "event",
        ),
    },
    "episemFinis": {
        "name": "EpisemaEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "episema-event",
        ),
    },
    "episemInitium": {
        "name": "EpisemaEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "episema-event",
        ),
    },
    "espressivo": {
        "articulation-type": "espressivo",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "eventChords": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "expandFullBarRests": {
        "context-type": "Score",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "expect-error": "expect-error",
    "f": {
        "name": "AbsoluteDynamicEvent",
        "text": "f",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "featherDurations": {
        "signature": (
            "ly:music?",
            "ly:moment?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "fermata": {
        "articulation-type": "fermata",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "fermataMarkup": {
        "name": "MultiMeasureTextEvent",
        "text": ("#<procedure fermata-markup (layout props)>",),
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "multi-measure-text-event",
        ),
    },
    "ff": {
        "name": "AbsoluteDynamicEvent",
        "text": "ff",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "fff": {
        "name": "AbsoluteDynamicEvent",
        "text": "fff",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "ffff": {
        "name": "AbsoluteDynamicEvent",
        "text": "ffff",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "fffff": {
        "name": "AbsoluteDynamicEvent",
        "text": "fffff",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "finger": {
        "signature": (
            "ly:event?",
            "number-or-markup?",
        ),
        "type": "ly:music-function?",
    },
    "fixed": {
        "signature": (
            "ly:music?",
            "ly:pitch?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "flageolet": {
        "articulation-type": "flageolet",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "footnote": {
        "signature": (
            "ly:music?",
            "optional?",
            "cheap-markup?",
            "number-pair?",
            "cheap-markup?",
            "symbol-list-or-music?",
        ),
        "type": "ly:music-function?",
    },
    "four-string-banjo": "four-string-banjo",
    "fp": {
        "name": "AbsoluteDynamicEvent",
        "text": "fp",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "frenchChords": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "fullJazzExceptions": "fullJazzExceptions",
    "funkHeads": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "funkHeadsMinor": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "fz": {
        "name": "AbsoluteDynamicEvent",
        "text": "fz",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "germanChords": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "glissando": {
        "name": "GlissandoEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "glissando-event",
            "event",
        ),
    },
    "grace": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "grobdescriptions": {
        "signature": (
            "scheme?",
            "list?",
        ),
        "type": "ly:music-function?",
    },
    "guitar-asus4-tuning": "guitar-asus4-tuning",
    "guitar-dadgad-tuning": "guitar-dadgad-tuning",
    "guitar-drop-c-tuning": "guitar-drop-c-tuning",
    "guitar-drop-d-tuning": "guitar-drop-d-tuning",
    "guitar-lute-tuning": "guitar-lute-tuning",
    "guitar-open-d-tuning": "guitar-open-d-tuning",
    "guitar-open-g-tuning": "guitar-open-g-tuning",
    "guitar-seven-string-tuning": "guitar-seven-string-tuning",
    "guitar-tuning": "guitar-tuning",
    "halfopen": {
        "articulation-type": "halfopen",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "harmonic": {
        "name": "HarmonicEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "harmonic-event",
        ),
    },
    "harmonicByFret": {
        "signature": (
            "ly:music?",
            "number?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "harmonicByRatio": {
        "signature": (
            "ly:music?",
            "number?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "harmonicNote": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "harmonicsOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "harmonicsOn": {"signature": ("ly:music?",), "type": "ly:music-function?"},
    "hide": {
        "signature": (
            "ly:music?",
            "symbol-list-or-music?",
        ),
        "type": "ly:music-function?",
    },
    "hideNotes": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "hideSplitTiedTabNotes": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "hideStaffSwitch": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "huge": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "ignatzekExceptionMusic": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "ignatzekExceptions": "ignatzekExceptions",
    "improvisationOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "improvisationOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "inStaffSegno": {"signature": ("ly:music?",), "type": "ly:music-function?"},
    "incipit": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "inherit-acceptability": {
        "signature": (
            "void?",
            "symbol?",
            "symbol?",
        ),
        "type": "ly:music-function?",
    },
    "input-file-name": None,
    "instrument-definitions": "instrument-definitions",
    "instrument-equalizer-alist": "instrument-equalizer-alist",
    "instrumentSwitch": {
        "signature": (
            "ly:music?",
            "string?",
        ),
        "type": "ly:music-function?",
    },
    "inversion": {
        "signature": (
            "ly:music?",
            "ly:pitch?",
            "ly:pitch?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "ionian": "ionian",
    "italianChords": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "keepWithTag": {
        "signature": (
            "ly:music?",
            "symbol-list-or-symbol?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "key": {
        "signature": (
            "ly:music?",
            "optional?",
            "ly:pitch?",
            "optional?",
            "list?",
        ),
        "type": "ly:music-function?",
    },
    "kievanOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "kievanOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "killCues": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "label": {
        "signature": (
            "ly:music?",
            "symbol?",
        ),
        "type": "ly:music-function?",
    },
    "laissezVibrer": {
        "name": "LaissezVibrerEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "laissez-vibrer-event",
        ),
    },
    "language": {
        "signature": (
            "void?",
            "string?",
        ),
        "type": "ly:music-function?",
    },
    "language-pitch-names": "language-pitch-names",
    "languageRestore": {"signature": ("void?",), "type": "ly:music-function?"},
    "languageSaveAndChange": {
        "signature": (
            "void?",
            "string?",
        ),
        "type": "ly:music-function?",
    },
    "large": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "left": -1,
    "lheel": {
        "articulation-type": "lheel",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "lineprall": {
        "articulation-type": "lineprall",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "locrian": "locrian",
    # "longa": LilyPondDuration(Duration(4, 1), None),
    "longfermata": {
        "articulation-type": "longfermata",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "ltoe": {
        "articulation-type": "ltoe",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "lydian": "lydian",
    "magnifyMusic": {
        "signature": (
            "ly:music?",
            "positive?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "magnifyStaff": {
        "signature": (
            "ly:music?",
            "positive?",
        ),
        "type": "ly:music-function?",
    },
    "major": "major",
    "make-directed-part-combine-music": "make-directed-part-combine-music",
    "make-dynamic-script": "make-dynamic-script",
    "make-fretboard-table": "make-fretboard-table",
    "make-simple-dash-definition": "make-simple-dash-definition",
    "make-table-of-contents-markup-list": "make-table-of-contents-markup-list",
    "makeClusters": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "makeDefaultStringTuning": {
        "signature": (
            "void?",
            "symbol?",
            "list?",
        ),
        "type": "ly:music-function?",
    },
    "mandolin-tuning": "mandolin-tuning",
    "marcato": {
        "articulation-type": "marcato",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "mark": {
        "signature": (
            "ly:music?",
            "optional?",
            "number-or-markup?",
        ),
        "type": "ly:music-function?",
    },
    "markLengthOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "markLengthOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "markupMap": {
        "signature": (
            "ly:music?",
            "symbol-list-or-symbol?",
            "markup-function?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    # "maxima": LilyPondDuration(Duration(8, 1), None),
    "melisma": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "melismaEnd": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "mergeDifferentlyDottedOff": {
        "context-type": "Staff",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "mergeDifferentlyDottedOn": {
        "context-type": "Staff",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "mergeDifferentlyHeadedOff": {
        "context-type": "Staff",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "mergeDifferentlyHeadedOn": {
        "context-type": "Staff",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "mf": {
        "name": "AbsoluteDynamicEvent",
        "text": "mf",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "midiDrumPitches": "midiDrumPitches",
    "minor": "minor",
    "mixolydian": "mixolydian",
    "modalInversion": {
        "signature": (
            "ly:music?",
            "ly:pitch?",
            "ly:pitch?",
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "modalTranspose": {
        "signature": (
            "ly:music?",
            "ly:pitch?",
            "ly:pitch?",
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "mordent": {
        "articulation-type": "mordent",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "mp": {
        "name": "AbsoluteDynamicEvent",
        "text": "mp",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "musicMap": {
        "signature": (
            "ly:music?",
            "procedure?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "musicQuotes": "musicQuotes",
    "newSpacingSection": {
        "name": "EventChord",
        "type": "ly:prob?",
        "types": (
            "event-chord",
            "simultaneous-music",
        ),
    },
    "noBeam": {
        "name": "BeamForbidEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "beam-forbid-event",
        ),
    },
    "noBreak": {
        "name": "LineBreakEvent",
        "type": "ly:prob?",
        "types": (
            "line-break-event",
            "break-event",
            "event",
        ),
    },
    "noPageBreak": {"signature": ("ly:music?",), "type": "ly:music-function?"},
    "noPageTurn": {"signature": ("ly:music?",), "type": "ly:music-function?"},
    "normalsize": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "numericTimeSignature": {
        "context-type": "Staff",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "octaveCheck": {
        "signature": (
            "ly:music?",
            "ly:pitch?",
        ),
        "type": "ly:music-function?",
    },
    "offset": {
        "signature": (
            "ly:music?",
            "symbol-list-or-symbol?",
            "scheme?",
            "key-list-or-music?",
        ),
        "type": "ly:music-function?",
    },
    "omit": {
        "signature": (
            "ly:music?",
            "symbol-list-or-music?",
        ),
        "type": "ly:music-function?",
    },
    "once": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "oneVoice": {
        "context-type": "Voice",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "open": {
        "articulation-type": "open",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "ottava": {
        "signature": (
            "ly:music?",
            "integer?",
        ),
        "type": "ly:music-function?",
    },
    "output-def-music-handler": "output-def-music-handler",
    "output-empty-score-list": "output-empty-score-list",
    "output-suffix": "output-suffix",
    "overrideProperty": {
        "signature": (
            "ly:music?",
            "key-list?",
            "scheme?",
        ),
        "type": "ly:music-function?",
    },
    "overrideTimeSignatureSettings": {
        "signature": (
            "ly:music?",
            "fraction?",
            "fraction?",
            "list?",
            "list?",
        ),
        "type": "ly:music-function?",
    },
    "p": {
        "name": "AbsoluteDynamicEvent",
        "text": "p",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "pageBreak": {"signature": ("ly:music?",), "type": "ly:music-function?"},
    "pageTurn": {"signature": ("ly:music?",), "type": "ly:music-function?"},
    "palmMute": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "palmMuteOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "palmMuteOn": {"signature": ("ly:music?",), "type": "ly:music-function?"},
    "parallelMusic": {
        "signature": (
            "void?",
            "list?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "parenthesize": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "partCombineListener": "partCombineListener",
    "partcombine": {
        "signature": (
            "ly:music?",
            "optional?",
            "number-pair?",
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "partcombineApart": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "partcombineAutomatic": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "partcombineChords": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "partcombineDown": {
        "signature": (
            "ly:music?",
            "optional?",
            "number-pair?",
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "partcombineForce": {
        "signature": (
            "ly:music?",
            "optional?",
            "symbol?",
        ),
        "type": "ly:music-function?",
    },
    "partcombineSoloI": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "partcombineSoloII": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "partcombineUnisono": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "partcombineUp": {
        "signature": (
            "ly:music?",
            "optional?",
            "number-pair?",
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "partial": {
        "signature": (
            "ly:music?",
            "ly:duration?",
        ),
        "type": "ly:music-function?",
    },
    "partialJazzExceptions": "partialJazzExceptions",
    "partialJazzMusic": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "percussion-style": "percussion-style",
    "phrasingSlurDashPattern": {
        "signature": (
            "ly:music?",
            "number?",
            "number?",
        ),
        "type": "ly:music-function?",
    },
    "phrasingSlurDashed": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "phrasingSlurDotted": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "phrasingSlurDown": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "phrasingSlurHalfDashed": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "phrasingSlurHalfSolid": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "phrasingSlurNeutral": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "phrasingSlurSolid": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "phrasingSlurUp": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "phrygian": "phrygian",
    "pitchedTrill": {
        "signature": (
            "ly:music?",
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "pitchnames": "pitchnames",
    "pointAndClickOff": {"signature": ("void?",), "type": "ly:music-function?"},
    "pointAndClickOn": {"signature": ("void?",), "type": "ly:music-function?"},
    "pointAndClickTypes": {
        "signature": (
            "void?",
            "symbol-list-or-symbol?",
        ),
        "type": "ly:music-function?",
    },
    "portato": {
        "articulation-type": "portato",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "powerChordExceptions": "powerChordExceptions",
    "powerChordSymbol": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "powerChords": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "pp": {
        "name": "AbsoluteDynamicEvent",
        "text": "pp",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "ppp": {
        "name": "AbsoluteDynamicEvent",
        "text": "ppp",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "pppp": {
        "name": "AbsoluteDynamicEvent",
        "text": "pppp",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "ppppp": {
        "name": "AbsoluteDynamicEvent",
        "text": "ppppp",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "prall": {
        "articulation-type": "prall",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "pralldown": {
        "articulation-type": "pralldown",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "prallmordent": {
        "articulation-type": "prallmordent",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "prallprall": {
        "articulation-type": "prallprall",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "prallup": {
        "articulation-type": "prallup",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "predefinedFretboardsOff": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "predefinedFretboardsOn": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "previous-pitchnames": "previous-pitchnames",
    "propertyOverride": {
        "signature": (
            "ly:music?",
            "key-list?",
            "scheme?",
        ),
        "type": "ly:music-function?",
    },
    "propertyRevert": {
        "signature": (
            "ly:music?",
            "key-list?",
        ),
        "type": "ly:music-function?",
    },
    "propertySet": {
        "signature": (
            "ly:music?",
            "symbol-list-or-symbol?",
            "scheme?",
        ),
        "type": "ly:music-function?",
    },
    "propertyTweak": {
        "signature": (
            "ly:music?",
            "key-list-or-symbol?",
            "scheme?",
            "key-list-or-music?",
        ),
        "type": "ly:music-function?",
    },
    "propertyUnset": {
        "signature": (
            "ly:music?",
            "symbol-list-or-symbol?",
        ),
        "type": "ly:music-function?",
    },
    "pushToTag": {
        "signature": (
            "ly:music?",
            "symbol?",
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "quoteDuring": {
        "signature": (
            "ly:music?",
            "string?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "reduceChords": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "relative": {
        "signature": (
            "ly:music?",
            "optional?",
            "ly:pitch?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "removeWithTag": {
        "signature": (
            "ly:music?",
            "symbol-list-or-symbol?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "repeatTie": {
        "name": "RepeatTieEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "repeat-tie-event",
        ),
    },
    "resetRelativeOctave": {
        "signature": (
            "ly:music?",
            "ly:pitch?",
        ),
        "type": "ly:music-function?",
    },
    "retrograde": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "reverseturn": {
        "articulation-type": "reverseturn",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "revertTimeSignatureSettings": {
        "signature": (
            "ly:music?",
            "pair?",
        ),
        "type": "ly:music-function?",
    },
    "rfz": {
        "name": "AbsoluteDynamicEvent",
        "text": "rfz",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "rheel": {
        "articulation-type": "rheel",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "right": 1,
    "rightHandFinger": {
        "signature": (
            "ly:event?",
            "number-or-markup?",
        ),
        "type": "ly:music-function?",
    },
    "romanStringNumbers": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "rtoe": {
        "articulation-type": "rtoe",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "sacredHarpHeads": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "sacredHarpHeadsMinor": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "scaleDurations": {
        "signature": (
            "ly:music?",
            "fraction?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "segno": {
        "articulation-type": "segno",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "semiGermanChords": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "setDefaultDurationToQuarter": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "settingsFrom": {
        "signature": (
            "scheme?",
            "optional?",
            "symbol?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "sf": {
        "name": "AbsoluteDynamicEvent",
        "text": "sf",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "sff": {
        "name": "AbsoluteDynamicEvent",
        "text": "sff",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "sfp": {
        "name": "AbsoluteDynamicEvent",
        "text": "sfp",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "sfz": {
        "name": "AbsoluteDynamicEvent",
        "text": "sfz",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "shape": {
        "signature": (
            "ly:music?",
            "list?",
            "key-list-or-music?",
        ),
        "type": "ly:music-function?",
    },
    "shiftDurations": {
        "signature": (
            "ly:music?",
            "integer?",
            "integer?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "shiftOff": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "shiftOn": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "shiftOnn": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "shiftOnnn": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "shortfermata": {
        "articulation-type": "shortfermata",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "showSplitTiedTabNotes": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "showStaffSwitch": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "signumcongruentiae": {
        "articulation-type": "signumcongruentiae",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "single": {
        "signature": (
            "ly:music?",
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "skip": {
        "signature": (
            "ly:music?",
            "ly:duration?",
        ),
        "type": "ly:music-function?",
    },
    "slashedGrace": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "slurDashPattern": {
        "signature": (
            "ly:music?",
            "number?",
            "number?",
        ),
        "type": "ly:music-function?",
    },
    "slurDashed": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "slurDotted": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "slurDown": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "slurHalfDashed": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "slurHalfSolid": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "slurNeutral": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "slurSolid": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "slurUp": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "small": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "smaller": -1,
    "snappizzicato": {
        "articulation-type": "snappizzicato",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "sostenutoOff": {
        "name": "SostenutoEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "pedal-event",
            "sostenuto-event",
        ),
    },
    "sostenutoOn": {
        "name": "SostenutoEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "pedal-event",
            "sostenuto-event",
        ),
    },
    "southernHarmonyHeads": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "southernHarmonyHeadsMinor": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "sp": {
        "name": "AbsoluteDynamicEvent",
        "text": "sp",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "spacingTweaks": {
        "signature": (
            "ly:music?",
            "list?",
        ),
        "type": "ly:music-function?",
    },
    "spp": {
        "name": "AbsoluteDynamicEvent",
        "text": "spp",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "dynamic-event",
            "absolute-dynamic-event",
        ),
    },
    "staccatissimo": {
        "articulation-type": "staccatissimo",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "staccato": {
        "articulation-type": "staccato",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "start": -1,
    "startAcciaccaturaMusic": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "startAppoggiaturaMusic": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "startGraceMusic": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "startGraceSlur": {
        "name": "SlurEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "slur-event",
        ),
    },
    "startGroup": {
        "name": "NoteGroupingEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "note-grouping-event",
        ),
    },
    "startMeasureCount": {
        "name": "MeasureCounterEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "measure-counter-event",
            "span-event",
            "event",
        ),
    },
    "startSlashedGraceMusic": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "startStaff": {
        "name": "StaffSpanEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "event",
            "span-event",
            "staff-span-event",
        ),
    },
    "startTextSpan": {
        "name": "TextSpanEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "text-span-event",
        ),
    },
    "startTrillSpan": {
        "name": "TrillSpanEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "trill-span-event",
        ),
    },
    "stemDown": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "stemNeutral": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "stemUp": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "stop": 1,
    "stopAcciaccaturaMusic": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "stopAppoggiaturaMusic": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "stopGraceMusic": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "stopGraceSlur": {
        "name": "SlurEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "slur-event",
        ),
    },
    "stopGroup": {
        "name": "NoteGroupingEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "note-grouping-event",
        ),
    },
    "stopMeasureCount": {
        "name": "MeasureCounterEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "measure-counter-event",
            "span-event",
            "event",
        ),
    },
    "stopSlashedGraceMusic": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "stopStaff": {
        "name": "StaffSpanEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "event",
            "span-event",
            "staff-span-event",
        ),
    },
    "stopTextSpan": {
        "name": "TextSpanEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "text-span-event",
        ),
    },
    "stopTrillSpan": {
        "name": "TrillSpanEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "span-event",
            "event",
            "trill-span-event",
        ),
    },
    "stopped": {
        "articulation-type": "stopped",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "storePredefinedDiagram": {
        "signature": (
            "void?",
            "hash-table?",
            "ly:music?",
            "pair?",
            "string-or-pair?",
        ),
        "type": "ly:music-function?",
    },
    "stringTuning": {
        "signature": (
            "scheme?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "styledNoteHeads": {
        "signature": (
            "ly:music?",
            "symbol?",
            "symbol-list-or-symbol?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "sustainOff": {
        "name": "SustainEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "pedal-event",
            "sustain-event",
        ),
    },
    "sustainOn": {
        "name": "SustainEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "pedal-event",
            "sustain-event",
        ),
    },
    "tabChordRepeats": {
        "signature": (
            "ly:music?",
            "optional?",
            "list?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "tabChordRepetition": {"signature": ("void?",), "type": "ly:music-function?"},
    "tabFullNotation": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "table-of-contents-markup-list": "table-of-contents-markup-list",
    "tag": {
        "signature": (
            "ly:music?",
            "symbol-list-or-symbol?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "tagGroup": {
        "signature": (
            "void?",
            "symbol-list?",
        ),
        "type": "ly:music-function?",
    },
    "teeny": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "temporary": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "tenor-ukulele-tuning": "tenor-ukulele-tuning",
    "tenuto": {
        "articulation-type": "tenuto",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "textLengthOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "textLengthOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "textSpannerDown": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "textSpannerNeutral": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "textSpannerUp": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "thumb": {
        "name": "FingeringEvent",
        "text": (
            "#<procedure scale-markup (layout props factor-pair arg)>",
            "(1.78179743628068 . 1.78179743628068)",
            "(#<procedure musicglyph-markup (layout props glyph-name)> scripts.thumb)",
        ),
        "type": "ly:prob?",
        "types": (
            "post-event",
            "fingering-event",
            "event",
        ),
    },
    "tieDashPattern": {
        "signature": (
            "ly:music?",
            "number?",
            "number?",
        ),
        "type": "ly:music-function?",
    },
    "tieDashed": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "tieDotted": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "tieDown": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "tieHalfDashed": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "tieHalfSolid": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "tieNeutral": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "tieSolid": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "tieUp": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "timbales-style": "timbales-style",
    "time": {
        "signature": (
            "ly:music?",
            "optional?",
            "number-list?",
            "fraction?",
        ),
        "type": "ly:music-function?",
    },
    "times": {
        "signature": (
            "ly:music?",
            "fraction?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "tiny": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "toc-items": "toc-items",
    "tocItem": {
        "signature": (
            "ly:music?",
            "cheap-markup?",
        ),
        "type": "ly:music-function?",
    },
    "tocItemWithDotsMarkup": "tocItemWithDotsMarkup",
    "toplevel-book-handler": "toplevel-book-handler",
    "toplevel-bookpart-handler": "toplevel-bookpart-handler",
    "toplevel-bookparts": "toplevel-bookparts",
    "toplevel-music-functions": "toplevel-music-functions",
    "toplevel-music-handler": "toplevel-music-handler",
    "toplevel-score-handler": "toplevel-score-handler",
    "toplevel-scores": "toplevel-scores",
    "toplevel-text-handler": "toplevel-text-handler",
    "transpose": {
        "signature": (
            "ly:music?",
            "ly:pitch?",
            "ly:pitch?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "transposedCueDuring": {
        "signature": (
            "ly:music?",
            "string?",
            "ly:dir?",
            "ly:pitch?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "transposition": {
        "signature": (
            "ly:music?",
            "ly:pitch?",
        ),
        "type": "ly:music-function?",
    },
    "treCorde": {
        "name": "UnaCordaEvent",
        "span-direction": 1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "pedal-event",
            "una-corda-event",
        ),
    },
    "trill": {
        "articulation-type": "trill",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "tuplet": {
        "signature": (
            "ly:music?",
            "fraction?",
            "optional?",
            "ly:duration?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "tupletDown": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "tupletNeutral": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "tupletSpan": {
        "signature": (
            "ly:music?",
            "optional?",
            "ly:duration?",
        ),
        "type": "ly:music-function?",
    },
    "tupletUp": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "turn": {
        "articulation-type": "turn",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "tweak": {
        "signature": (
            "ly:music?",
            "key-list-or-symbol?",
            "scheme?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "ukulele-d-tuning": "ukulele-d-tuning",
    "ukulele-tuning": "ukulele-tuning",
    "unHideNotes": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "unaCorda": {
        "name": "UnaCordaEvent",
        "span-direction": -1,
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "pedal-event",
            "una-corda-event",
        ),
    },
    "undo": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "unfoldRepeats": {
        "signature": (
            "ly:music?",
            "optional?",
            "symbol-list-or-symbol?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "up": 1,
    "upbow": {
        "articulation-type": "upbow",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "upmordent": {
        "articulation-type": "upmordent",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "upprall": {
        "articulation-type": "upprall",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "varcoda": {
        "articulation-type": "varcoda",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "version-seen": "version-seen",
    "verylongfermata": {
        "articulation-type": "verylongfermata",
        "name": "ArticulationEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "event",
            "articulation-event",
            "script-event",
        ),
    },
    "viola-tuning": "viola-tuning",
    "violin-tuning": "violin-tuning",
    "voiceFour": {
        "context-type": "Voice",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "voiceFourStyle": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "voiceNeutralStyle": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "voiceOne": {
        "context-type": "Voice",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "voiceOneStyle": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "voiceThree": {
        "context-type": "Voice",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "voiceThreeStyle": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "voiceTwo": {
        "context-type": "Voice",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "voiceTwoStyle": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "voices": {
        "signature": (
            "ly:music?",
            "key-list?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "void": {
        "signature": (
            "void?",
            "scheme?",
        ),
        "type": "ly:music-function?",
    },
    "walkerHeads": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "walkerHeadsMinor": {
        "context-type": "Bottom",
        "name": "ContextSpeccedMusic",
        "type": "ly:prob?",
        "types": (
            "context-specification",
            "music-wrapper-music",
        ),
    },
    "whiteTriangleMarkup": "whiteTriangleMarkup",
    "withMusicProperty": {
        "signature": (
            "ly:music?",
            "symbol?",
            "scheme?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "xNote": {
        "signature": (
            "ly:music?",
            "ly:music?",
        ),
        "type": "ly:music-function?",
    },
    "xNotesOff": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "xNotesOn": {
        "name": "SequentialMusic",
        "type": "ly:prob?",
        "types": ("sequential-music",),
    },
    "|": {"name": "BarCheck", "type": "ly:prob?", "types": ("bar-check",)},
    "~": {
        "name": "TieEvent",
        "type": "ly:prob?",
        "types": (
            "post-event",
            "tie-event",
            "event",
        ),
    },
}

lilypond_version = "2.19.84"

engravers = {
    "Accidental_engraver": {
        "grobs_created": set(
            [
                "Accidental",
                "AccidentalCautionary",
                "AccidentalPlacement",
                "AccidentalSuggestion",
            ]
        ),
        "properties_read": set(
            [
                "accidentalGrouping",
                "autoAccidentals",
                "autoCautionaries",
                "extraNatural",
                "harmonicAccidentals",
                "internalBarNumber",
                "keyAlterations",
                "localAlterations",
            ]
        ),
        "properties_written": set(["localAlterations"]),
    },
    "Ambitus_engraver": {
        "grobs_created": set(
            [
                "AccidentalPlacement",
                "Ambitus",
                "AmbitusAccidental",
                "AmbitusLine",
                "AmbitusNoteHead",
            ]
        ),
        "properties_read": set(
            ["keyAlterations", "middleCClefPosition", "middleCOffset"]
        ),
        "properties_written": set([]),
    },
    "Arpeggio_engraver": {
        "grobs_created": set(["Arpeggio"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Auto_beam_engraver": {
        "grobs_created": set(["Beam"]),
        "properties_read": set(
            [
                "autoBeaming",
                "baseMoment",
                "beamExceptions",
                "beamHalfMeasure",
                "beatStructure",
                "subdivideBeams",
            ]
        ),
        "properties_written": set([]),
    },
    "Axis_group_engraver": {
        "grobs_created": set(["VerticalAxisGroup"]),
        "properties_read": set(
            ["currentCommandColumn", "hasAxisGroup", "keepAliveInterfaces"]
        ),
        "properties_written": set(["hasAxisGroup"]),
    },
    "Balloon_engraver": {
        "grobs_created": set(["BalloonTextItem"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Bar_engraver": {
        "grobs_created": set(["BarLine"]),
        "properties_read": set(["whichBar"]),
        "properties_written": set(["forbidBreak"]),
    },
    "Bar_number_engraver": {
        "grobs_created": set(["BarNumber"]),
        "properties_read": set(
            [
                "alternativeNumberingStyle",
                "barNumberFormatter",
                "barNumberVisibility",
                "currentBarNumber",
                "stavesFound",
                "whichBar",
            ]
        ),
        "properties_written": set(["currentBarNumber"]),
    },
    "Beam_collision_engraver": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Beam_engraver": {
        "grobs_created": set(["Beam"]),
        "properties_read": set(
            ["baseMoment", "beamMelismaBusy", "beatStructure", "subdivideBeams"]
        ),
        "properties_written": set(["forbidBreak"]),
    },
    "Beam_performer": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Bend_engraver": {
        "grobs_created": set(["BendAfter"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Break_align_engraver": {
        "grobs_created": set(["BreakAlignGroup", "BreakAlignment", "LeftEdge"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Breathing_sign_engraver": {
        "grobs_created": set(["BreathingSign"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Chord_name_engraver": {
        "grobs_created": set(["ChordName"]),
        "properties_read": set(
            [
                "chordChanges",
                "chordNameExceptions",
                "chordNameExceptions",
                "chordNameFunction",
                "chordNoteNamer",
                "chordRootNamer",
                "lastChord",
                "majorSevenSymbol",
                "noChordSymbol",
            ]
        ),
        "properties_written": set(["lastChord"]),
    },
    "Chord_tremolo_engraver": {
        "grobs_created": set(["Beam"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Clef_engraver": {
        "grobs_created": set(["Clef", "ClefModifier"]),
        "properties_read": set(
            [
                "clefGlyph",
                "clefPosition",
                "clefTransposition",
                "clefTranspositionStyle",
                "explicitClefVisibility",
                "forceClef",
            ]
        ),
        "properties_written": set([]),
    },
    "Cluster_spanner_engraver": {
        "grobs_created": set(["ClusterSpanner", "ClusterSpannerBeacon"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Collision_engraver": {
        "grobs_created": set(["NoteCollision"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Completion_heads_engraver": {
        "grobs_created": set(["NoteHead", "Tie", "TieColumn"]),
        "properties_read": set(
            [
                "completionFactor",
                "completionUnit",
                "measureLength",
                "measurePosition",
                "middleCPosition",
                "timing",
            ]
        ),
        "properties_written": set(["completionBusy"]),
    },
    "Completion_rest_engraver": {
        "grobs_created": set(["Rest"]),
        "properties_read": set(
            [
                "completionFactor",
                "completionUnit",
                "measureLength",
                "measurePosition",
                "middleCPosition",
            ]
        ),
        "properties_written": set(["restCompletionBusy"]),
    },
    "Concurrent_hairpin_engraver": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Control_track_performer": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Cue_clef_engraver": {
        "grobs_created": set(["ClefModifier", "CueClef", "CueEndClef"]),
        "properties_read": set(
            [
                "clefTransposition",
                "cueClefGlyph",
                "cueClefPosition",
                "cueClefTransposition",
                "cueClefTranspositionStyle",
                "explicitCueClefVisibility",
                "middleCCuePosition",
            ]
        ),
        "properties_written": set([]),
    },
    "Custos_engraver": {
        "grobs_created": set(["Custos"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Default_bar_line_engraver": {
        "grobs_created": set([]),
        "properties_read": set(
            [
                "automaticBars",
                "barAlways",
                "defaultBarType",
                "measureLength",
                "measurePosition",
                "timing",
                "whichBar",
            ]
        ),
        "properties_written": set([]),
    },
    "Dot_column_engraver": {
        "grobs_created": set(["DotColumn"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Dots_engraver": {
        "grobs_created": set(["Dots"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Double_percent_repeat_engraver": {
        "grobs_created": set(["DoublePercentRepeat", "DoublePercentRepeatCounter"]),
        "properties_read": set(
            ["countPercentRepeats", "measureLength", "repeatCountVisibility"]
        ),
        "properties_written": set(["forbidBreak"]),
    },
    "Drum_note_performer": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Drum_notes_engraver": {
        "grobs_created": set(["NoteHead", "Script"]),
        "properties_read": set(["drumStyleTable"]),
        "properties_written": set([]),
    },
    "Dynamic_align_engraver": {
        "grobs_created": set(["DynamicLineSpanner"]),
        "properties_read": set(["currentMusicalColumn"]),
        "properties_written": set([]),
    },
    "Dynamic_engraver": {
        "grobs_created": set(["DynamicText", "DynamicTextSpanner", "Hairpin"]),
        "properties_read": set(
            [
                "crescendoSpanner",
                "crescendoText",
                "currentMusicalColumn",
                "decrescendoSpanner",
                "decrescendoText",
            ]
        ),
        "properties_written": set([]),
    },
    "Dynamic_performer": {
        "grobs_created": set([]),
        "properties_read": set(
            [
                "dynamicAbsoluteVolumeFunction",
                "instrumentEqualizer",
                "midiInstrument",
                "midiMaximumVolume",
                "midiMinimumVolume",
            ]
        ),
        "properties_written": set([]),
    },
    "Episema_engraver": {
        "grobs_created": set(["Episema"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Extender_engraver": {
        "grobs_created": set(["LyricExtender"]),
        "properties_read": set(["extendersOverRests"]),
        "properties_written": set([]),
    },
    "Figured_bass_engraver": {
        "grobs_created": set(
            [
                "BassFigure",
                "BassFigureAlignment",
                "BassFigureBracket",
                "BassFigureContinuation",
                "BassFigureLine",
            ]
        ),
        "properties_read": set(
            [
                "figuredBassAlterationDirection",
                "figuredBassCenterContinuations",
                "figuredBassFormatter",
                "ignoreFiguredBassRest",
                "implicitBassFigures",
                "useBassFigureExtenders",
            ]
        ),
        "properties_written": set([]),
    },
    "Figured_bass_position_engraver": {
        "grobs_created": set(["BassFigureAlignmentPositioning"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Fingering_column_engraver": {
        "grobs_created": set(["FingeringColumn"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Fingering_engraver": {
        "grobs_created": set(["Fingering"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Font_size_engraver": {
        "grobs_created": set([]),
        "properties_read": set(["fontSize"]),
        "properties_written": set([]),
    },
    "Footnote_engraver": {
        "grobs_created": set(["FootnoteItem", "FootnoteSpanner"]),
        "properties_read": set(["currentMusicalColumn"]),
        "properties_written": set([]),
    },
    "Forbid_line_break_engraver": {
        "grobs_created": set([]),
        "properties_read": set(["busyGrobs"]),
        "properties_written": set(["forbidBreak"]),
    },
    "Fretboard_engraver": {
        "grobs_created": set(["FretBoard"]),
        "properties_read": set(
            [
                "chordChanges",
                "defaultStrings",
                "highStringOne",
                "maximumFretStretch",
                "minimumFret",
                "noteToFretFunction",
                "predefinedDiagramTable",
                "stringTunings",
                "tablatureFormat",
            ]
        ),
        "properties_written": set([]),
    },
    "Glissando_engraver": {
        "grobs_created": set(["Glissando"]),
        "properties_read": set(["glissandoMap"]),
        "properties_written": set([]),
    },
    "Grace_auto_beam_engraver": {
        "grobs_created": set(["Beam"]),
        "properties_read": set(["autoBeaming"]),
        "properties_written": set([]),
    },
    "Grace_beam_engraver": {
        "grobs_created": set(["Beam"]),
        "properties_read": set(
            ["baseMoment", "beamMelismaBusy", "beatStructure", "subdivideBeams"]
        ),
        "properties_written": set([]),
    },
    "Grace_engraver": {
        "grobs_created": set([]),
        "properties_read": set(["graceSettings"]),
        "properties_written": set([]),
    },
    "Grace_spacing_engraver": {
        "grobs_created": set(["GraceSpacing"]),
        "properties_read": set(["currentMusicalColumn"]),
        "properties_written": set([]),
    },
    "Grid_line_span_engraver": {
        "grobs_created": set(["GridLine"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Grid_point_engraver": {
        "grobs_created": set(["GridPoint"]),
        "properties_read": set(["gridInterval"]),
        "properties_written": set([]),
    },
    "Grob_pq_engraver": {
        "grobs_created": set([]),
        "properties_read": set(["busyGrobs"]),
        "properties_written": set(["busyGrobs"]),
    },
    "Horizontal_bracket_engraver": {
        "grobs_created": set(["HorizontalBracket", "HorizontalBracketText"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Hyphen_engraver": {
        "grobs_created": set(["LyricHyphen", "LyricSpace"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Instrument_name_engraver": {
        "grobs_created": set(["InstrumentName"]),
        "properties_read": set(
            [
                "currentCommandColumn",
                "instrumentName",
                "shortInstrumentName",
                "shortVocalName",
                "vocalName",
            ]
        ),
        "properties_written": set([]),
    },
    "Instrument_switch_engraver": {
        "grobs_created": set(["InstrumentSwitch"]),
        "properties_read": set(["instrumentCueName"]),
        "properties_written": set([]),
    },
    "Keep_alive_together_engraver": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Key_engraver": {
        "grobs_created": set(["KeyCancellation", "KeySignature"]),
        "properties_read": set(
            [
                "createKeyOnClefChange",
                "explicitKeySignatureVisibility",
                "extraNatural",
                "keyAlterationOrder",
                "keyAlterations",
                "lastKeyAlterations",
                "middleCClefPosition",
                "printKeyCancellation",
            ]
        ),
        "properties_written": set(["keyAlterations", "lastKeyAlterations", "tonic"]),
    },
    "Key_performer": {
        "grobs_created": set([]),
        "properties_read": set(["instrumentTransposition"]),
        "properties_written": set([]),
    },
    "Kievan_ligature_engraver": {
        "grobs_created": set(["KievanLigature"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Laissez_vibrer_engraver": {
        "grobs_created": set(["LaissezVibrerTie", "LaissezVibrerTieColumn"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Ledger_line_engraver": {
        "grobs_created": set(["LedgerLineSpanner"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Ligature_bracket_engraver": {
        "grobs_created": set(["LigatureBracket"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Lyric_engraver": {
        "grobs_created": set(["LyricText"]),
        "properties_read": set(
            ["ignoreMelismata", "lyricMelismaAlignment", "searchForVoice"]
        ),
        "properties_written": set([]),
    },
    "Lyric_performer": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Mark_engraver": {
        "grobs_created": set(["RehearsalMark"]),
        "properties_read": set(["markFormatter", "rehearsalMark", "stavesFound"]),
        "properties_written": set([]),
    },
    "Measure_counter_engraver": {
        "grobs_created": set(["MeasureCounter"]),
        "properties_read": set(
            ["currentBarNumber", "currentCommandColumn", "measurePosition"]
        ),
        "properties_written": set([]),
    },
    "Measure_grouping_engraver": {
        "grobs_created": set(["MeasureGrouping"]),
        "properties_read": set(
            ["baseMoment", "beatStructure", "currentMusicalColumn", "measurePosition"]
        ),
        "properties_written": set([]),
    },
    "Melody_engraver": {
        "grobs_created": set(["MelodyItem"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Mensural_ligature_engraver": {
        "grobs_created": set(["MensuralLigature"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Merge_rests_engraver": {
        "grobs_created": set([]),
        "properties_read": set(["suspendRestMerging"]),
        "properties_written": set([]),
    },
    "Metronome_mark_engraver": {
        "grobs_created": set(["MetronomeMark"]),
        "properties_read": set(
            [
                "currentCommandColumn",
                "currentMusicalColumn",
                "metronomeMarkFormatter",
                "stavesFound",
                "tempoHideNote",
            ]
        ),
        "properties_written": set([]),
    },
    "Midi_control_change_performer": {
        "grobs_created": set([]),
        "properties_read": set(
            [
                "midiBalance",
                "midiChorusLevel",
                "midiExpression",
                "midiPanPosition",
                "midiReverbLevel",
            ]
        ),
        "properties_written": set([]),
    },
    "Multi_measure_rest_engraver": {
        "grobs_created": set(
            ["MultiMeasureRest", "MultiMeasureRestNumber", "MultiMeasureRestText"]
        ),
        "properties_read": set(
            [
                "currentCommandColumn",
                "internalBarNumber",
                "measurePosition",
                "restNumberThreshold",
                "whichBar",
            ]
        ),
        "properties_written": set([]),
    },
    "New_fingering_engraver": {
        "grobs_created": set(["Fingering", "Script", "StringNumber", "StrokeFinger"]),
        "properties_read": set(
            [
                "fingeringOrientations",
                "harmonicDots",
                "stringNumberOrientations",
                "strokeFingerOrientations",
            ]
        ),
        "properties_written": set([]),
    },
    "Note_head_line_engraver": {
        "grobs_created": set(["VoiceFollower"]),
        "properties_read": set(["followVoice"]),
        "properties_written": set([]),
    },
    "Note_heads_engraver": {
        "grobs_created": set(["NoteHead"]),
        "properties_read": set(["middleCPosition", "staffLineLayoutFunction"]),
        "properties_written": set([]),
    },
    "Note_name_engraver": {
        "grobs_created": set(["NoteName"]),
        "properties_read": set(["printOctaveNames"]),
        "properties_written": set([]),
    },
    "Note_performer": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Note_spacing_engraver": {
        "grobs_created": set(["NoteSpacing"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Ottava_spanner_engraver": {
        "grobs_created": set(["OttavaBracket"]),
        "properties_read": set(["currentMusicalColumn", "middleCOffset", "ottavation"]),
        "properties_written": set([]),
    },
    "Output_property_engraver": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Page_turn_engraver": {
        "grobs_created": set([]),
        "properties_read": set(
            ["minimumPageTurnLength", "minimumRepeatLengthForPageTurn"]
        ),
        "properties_written": set([]),
    },
    "Paper_column_engraver": {
        "grobs_created": set(["NonMusicalPaperColumn", "PaperColumn"]),
        "properties_read": set(["forbidBreak"]),
        "properties_written": set(
            ["currentCommandColumn", "currentMusicalColumn", "forbidBreak"]
        ),
    },
    "Parenthesis_engraver": {
        "grobs_created": set(["ParenthesesItem"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Part_combine_engraver": {
        "grobs_created": set(["CombineTextScript"]),
        "properties_read": set(
            [
                "aDueText",
                "partCombineTextsOnNote",
                "printPartCombineTexts",
                "soloIIText",
                "soloText",
            ]
        ),
        "properties_written": set([]),
    },
    "Percent_repeat_engraver": {
        "grobs_created": set(["PercentRepeat", "PercentRepeatCounter"]),
        "properties_read": set(
            ["countPercentRepeats", "currentCommandColumn", "repeatCountVisibility"]
        ),
        "properties_written": set([]),
    },
    "Phrasing_slur_engraver": {
        "grobs_created": set(["PhrasingSlur"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Piano_pedal_align_engraver": {
        "grobs_created": set(
            [
                "SostenutoPedalLineSpanner",
                "SustainPedalLineSpanner",
                "UnaCordaPedalLineSpanner",
            ]
        ),
        "properties_read": set(["currentCommandColumn"]),
        "properties_written": set([]),
    },
    "Piano_pedal_engraver": {
        "grobs_created": set(
            ["PianoPedalBracket", "SostenutoPedal", "SustainPedal", "UnaCordaPedal"]
        ),
        "properties_read": set(
            [
                "currentCommandColumn",
                "pedalSostenutoStrings",
                "pedalSostenutoStyle",
                "pedalSustainStrings",
                "pedalSustainStyle",
                "pedalUnaCordaStrings",
                "pedalUnaCordaStyle",
            ]
        ),
        "properties_written": set([]),
    },
    "Piano_pedal_performer": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Pitch_squash_engraver": {
        "grobs_created": set([]),
        "properties_read": set(["squashedPosition"]),
        "properties_written": set([]),
    },
    "Pitched_trill_engraver": {
        "grobs_created": set(
            ["TrillPitchAccidental", "TrillPitchGroup", "TrillPitchHead"]
        ),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Pure_from_neighbor_engraver": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Repeat_acknowledge_engraver": {
        "grobs_created": set([]),
        "properties_read": set(
            [
                "doubleRepeatSegnoType",
                "doubleRepeatType",
                "endRepeatSegnoType",
                "endRepeatType",
                "repeatCommands",
                "segnoType",
                "startRepeatSegnoType",
                "startRepeatType",
                "whichBar",
            ]
        ),
        "properties_written": set([]),
    },
    "Repeat_tie_engraver": {
        "grobs_created": set(["RepeatTie", "RepeatTieColumn"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Rest_collision_engraver": {
        "grobs_created": set(["RestCollision"]),
        "properties_read": set(["busyGrobs"]),
        "properties_written": set([]),
    },
    "Rest_engraver": {
        "grobs_created": set(["Rest"]),
        "properties_read": set(["middleCPosition"]),
        "properties_written": set([]),
    },
    "Rhythmic_column_engraver": {
        "grobs_created": set(["NoteColumn"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Script_column_engraver": {
        "grobs_created": set(["ScriptColumn"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Script_engraver": {
        "grobs_created": set(["Script"]),
        "properties_read": set(["scriptDefinitions"]),
        "properties_written": set([]),
    },
    "Script_row_engraver": {
        "grobs_created": set(["ScriptRow"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Separating_line_group_engraver": {
        "grobs_created": set(["StaffSpacing"]),
        "properties_read": set(["createSpacing"]),
        "properties_written": set(["hasStaffSpacing"]),
    },
    "Slash_repeat_engraver": {
        "grobs_created": set(["DoubleRepeatSlash", "RepeatSlash"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Slur_engraver": {
        "grobs_created": set(["Slur"]),
        "properties_read": set(["doubleSlurs", "slurMelismaBusy"]),
        "properties_written": set([]),
    },
    "Slur_performer": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Spacing_engraver": {
        "grobs_created": set(["SpacingSpanner"]),
        "properties_read": set(
            [
                "currentCommandColumn",
                "currentMusicalColumn",
                "proportionalNotationDuration",
            ]
        ),
        "properties_written": set([]),
    },
    "Span_arpeggio_engraver": {
        "grobs_created": set(["Arpeggio"]),
        "properties_read": set(["connectArpeggios"]),
        "properties_written": set([]),
    },
    "Span_bar_engraver": {
        "grobs_created": set(["SpanBar"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Span_bar_stub_engraver": {
        "grobs_created": set(["SpanBarStub"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Span_stem_engraver": {
        "grobs_created": set(["Stem"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Spanner_break_forbid_engraver": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Staff_collecting_engraver": {
        "grobs_created": set([]),
        "properties_read": set(["stavesFound"]),
        "properties_written": set(["stavesFound"]),
    },
    "Staff_performer": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Staff_symbol_engraver": {
        "grobs_created": set(["StaffSymbol"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Stanza_number_align_engraver": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Stanza_number_engraver": {
        "grobs_created": set(["StanzaNumber"]),
        "properties_read": set(["stanza"]),
        "properties_written": set([]),
    },
    "Stem_engraver": {
        "grobs_created": set(["Flag", "Stem", "StemStub", "StemTremolo"]),
        "properties_read": set(["stemLeftBeamCount", "stemRightBeamCount", "whichBar"]),
        "properties_written": set([]),
    },
    "System_start_delimiter_engraver": {
        "grobs_created": set(
            [
                "SystemStartBar",
                "SystemStartBrace",
                "SystemStartBracket",
                "SystemStartSquare",
            ]
        ),
        "properties_read": set(
            [
                "currentCommandColumn",
                "systemStartDelimiter",
                "systemStartDelimiterHierarchy",
            ]
        ),
        "properties_written": set([]),
    },
    "Tab_note_heads_engraver": {
        "grobs_created": set(["TabNoteHead"]),
        "properties_read": set(
            [
                "defaultStrings",
                "fretLabels",
                "highStringOne",
                "maximumFretStretch",
                "middleCPosition",
                "minimumFret",
                "noteToFretFunction",
                "stringOneTopmost",
                "stringTunings",
                "tabStaffLineLayoutFunction",
                "tablatureFormat",
            ]
        ),
        "properties_written": set([]),
    },
    "Tab_staff_symbol_engraver": {
        "grobs_created": set(["StaffSymbol"]),
        "properties_read": set(["stringTunings"]),
        "properties_written": set([]),
    },
    "Tab_tie_follow_engraver": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Tempo_performer": {
        "grobs_created": set([]),
        "properties_read": set(["tempoWholesPerMinute"]),
        "properties_written": set([]),
    },
    "Text_engraver": {
        "grobs_created": set(["TextScript"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Text_spanner_engraver": {
        "grobs_created": set(["TextSpanner"]),
        "properties_read": set(["currentMusicalColumn"]),
        "properties_written": set([]),
    },
    "Tie_engraver": {
        "grobs_created": set(["Tie", "TieColumn"]),
        "properties_read": set(["skipTypesetting", "tieWaitForNote"]),
        "properties_written": set(["tieMelismaBusy"]),
    },
    "Tie_performer": {
        "grobs_created": set([]),
        "properties_read": set(["tieWaitForNote"]),
        "properties_written": set(["tieMelismaBusy"]),
    },
    "Time_signature_engraver": {
        "grobs_created": set(["TimeSignature"]),
        "properties_read": set(
            ["initialTimeSignatureVisibility", "partialBusy", "timeSignatureFraction"]
        ),
        "properties_written": set([]),
    },
    "Time_signature_performer": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Timing_translator": {
        "grobs_created": set([]),
        "properties_read": set(
            [
                "baseMoment",
                "currentBarNumber",
                "internalBarNumber",
                "measureLength",
                "measurePosition",
                "timeSignatureFraction",
            ]
        ),
        "properties_written": set(
            [
                "baseMoment",
                "currentBarNumber",
                "internalBarNumber",
                "measureLength",
                "measurePosition",
                "timeSignatureFraction",
            ]
        ),
    },
    "Trill_spanner_engraver": {
        "grobs_created": set(["TrillSpanner"]),
        "properties_read": set(["currentCommandColumn", "currentMusicalColumn"]),
        "properties_written": set([]),
    },
    "Tuplet_engraver": {
        "grobs_created": set(["TupletBracket", "TupletNumber"]),
        "properties_read": set(["tupletFullLength", "tupletFullLengthNote"]),
        "properties_written": set([]),
    },
    "Tweak_engraver": {
        "grobs_created": set([]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Vaticana_ligature_engraver": {
        "grobs_created": set(["DotColumn", "VaticanaLigature"]),
        "properties_read": set([]),
        "properties_written": set([]),
    },
    "Vertical_align_engraver": {
        "grobs_created": set(["Vertical"]),
        "properties_read": set(
            ["alignAboveContext", "alignBelowContext", "hasAxisGroup"]
        ),
        "properties_written": set([]),
    },
    "Volta_engraver": {
        "grobs_created": set(["VoltaBracket", "VoltaBracketSpanner"]),
        "properties_read": set(
            ["repeatCommands", "stavesFound", "voltaSpannerDuration"]
        ),
        "properties_written": set([]),
    },
}

lilypond_version = "2.19.84"

grob_interfaces = {
    "Accidental": [
        "accidental-interface",
        "font-interface",
        "grob-interface",
        "inline-accidental-interface",
        "item-interface",
    ],
    "AccidentalCautionary": [
        "accidental-interface",
        "font-interface",
        "grob-interface",
        "inline-accidental-interface",
        "item-interface",
    ],
    "AccidentalPlacement": [
        "accidental-placement-interface",
        "grob-interface",
        "item-interface",
    ],
    "AccidentalSuggestion": [
        "accidental-interface",
        "accidental-suggestion-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "script-interface",
        "self-alignment-interface",
        "side-position-interface",
    ],
    "Ambitus": [
        "ambitus-interface",
        "axis-group-interface",
        "break-aligned-interface",
        "grob-interface",
        "item-interface",
    ],
    "AmbitusAccidental": [
        "accidental-interface",
        "break-aligned-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "side-position-interface",
    ],
    "AmbitusLine": [
        "ambitus-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
    ],
    "AmbitusNoteHead": [
        "ambitus-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "ledgered-interface",
        "note-head-interface",
        "rhythmic-head-interface",
        "staff-symbol-referencer-interface",
    ],
    "Arpeggio": [
        "arpeggio-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "side-position-interface",
        "staff-symbol-referencer-interface",
    ],
    "BalloonTextItem": [
        "balloon-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "text-interface",
    ],
    "BarLine": [
        "bar-line-interface",
        "break-aligned-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "pure-from-neighbor-interface",
    ],
    "BarNumber": [
        "break-alignable-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "text-interface",
    ],
    "BassFigure": [
        "bass-figure-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "rhythmic-grob-interface",
        "text-interface",
    ],
    "BassFigureAlignment": [
        "align-interface",
        "axis-group-interface",
        "bass-figure-alignment-interface",
        "grob-interface",
        "spanner-interface",
    ],
    "BassFigureAlignmentPositioning": [
        "axis-group-interface",
        "grob-interface",
        "outside-staff-interface",
        "side-position-interface",
        "spanner-interface",
    ],
    "BassFigureBracket": [
        "enclosing-bracket-interface",
        "grob-interface",
        "item-interface",
    ],
    "BassFigureContinuation": [
        "figured-bass-continuation-interface",
        "grob-interface",
        "spanner-interface",
    ],
    "BassFigureLine": [
        "axis-group-interface",
        "grob-interface",
        "outside-staff-axis-group-interface",
        "spanner-interface",
    ],
    "Beam": [
        "beam-interface",
        "font-interface",
        "grob-interface",
        "spanner-interface",
        "staff-symbol-referencer-interface",
        "unbreakable-spanner-interface",
    ],
    "BendAfter": ["bend-after-interface", "grob-interface", "spanner-interface"],
    "BreakAlignGroup": [
        "axis-group-interface",
        "break-aligned-interface",
        "grob-interface",
        "item-interface",
    ],
    "BreakAlignment": [
        "axis-group-interface",
        "break-alignment-interface",
        "grob-interface",
        "item-interface",
    ],
    "BreathingSign": [
        "break-aligned-interface",
        "breathing-sign-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "text-interface",
    ],
    "ChordName": [
        "chord-name-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "rhythmic-grob-interface",
        "text-interface",
    ],
    "Clef": [
        "break-aligned-interface",
        "clef-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "pure-from-neighbor-interface",
        "staff-symbol-referencer-interface",
    ],
    "ClefModifier": [
        "clef-modifier-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "text-interface",
    ],
    "ClusterSpanner": ["cluster-interface", "grob-interface", "spanner-interface"],
    "ClusterSpannerBeacon": [
        "cluster-beacon-interface",
        "grob-interface",
        "item-interface",
        "rhythmic-grob-interface",
    ],
    "CombineTextScript": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "text-interface",
        "text-script-interface",
    ],
    "CueClef": [
        "break-aligned-interface",
        "clef-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "pure-from-neighbor-interface",
        "staff-symbol-referencer-interface",
    ],
    "CueEndClef": [
        "break-aligned-interface",
        "clef-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "pure-from-neighbor-interface",
        "staff-symbol-referencer-interface",
    ],
    "Custos": [
        "break-aligned-interface",
        "custos-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "staff-symbol-referencer-interface",
    ],
    "DotColumn": [
        "axis-group-interface",
        "dot-column-interface",
        "grob-interface",
        "item-interface",
    ],
    "Dots": [
        "dots-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "staff-symbol-referencer-interface",
    ],
    "DoublePercentRepeat": [
        "break-aligned-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "percent-repeat-interface",
        "percent-repeat-item-interface",
    ],
    "DoublePercentRepeatCounter": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "percent-repeat-interface",
        "percent-repeat-item-interface",
        "self-alignment-interface",
        "side-position-interface",
        "text-interface",
    ],
    "DoubleRepeatSlash": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "percent-repeat-interface",
        "percent-repeat-item-interface",
        "rhythmic-grob-interface",
    ],
    "DynamicLineSpanner": [
        "axis-group-interface",
        "dynamic-interface",
        "dynamic-line-spanner-interface",
        "grob-interface",
        "outside-staff-interface",
        "side-position-interface",
        "spanner-interface",
    ],
    "DynamicText": [
        "dynamic-interface",
        "dynamic-text-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "script-interface",
        "self-alignment-interface",
        "text-interface",
    ],
    "DynamicTextSpanner": [
        "dynamic-interface",
        "dynamic-text-spanner-interface",
        "font-interface",
        "grob-interface",
        "line-interface",
        "line-spanner-interface",
        "spanner-interface",
        "text-interface",
    ],
    "Episema": [
        "episema-interface",
        "font-interface",
        "grob-interface",
        "line-interface",
        "line-spanner-interface",
        "side-position-interface",
        "spanner-interface",
    ],
    "Fingering": [
        "finger-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "text-interface",
        "text-script-interface",
    ],
    "FingeringColumn": [
        "fingering-column-interface",
        "grob-interface",
        "item-interface",
    ],
    "Flag": ["flag-interface", "font-interface", "grob-interface", "item-interface"],
    "FootnoteItem": [
        "balloon-interface",
        "font-interface",
        "footnote-interface",
        "grob-interface",
        "item-interface",
        "text-interface",
    ],
    "FootnoteSpanner": [
        "balloon-interface",
        "font-interface",
        "footnote-interface",
        "footnote-spanner-interface",
        "grob-interface",
        "spanner-interface",
        "text-interface",
    ],
    "FretBoard": [
        "chord-name-interface",
        "font-interface",
        "fret-diagram-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "rhythmic-grob-interface",
    ],
    "Glissando": [
        "glissando-interface",
        "grob-interface",
        "line-interface",
        "line-spanner-interface",
        "spanner-interface",
        "unbreakable-spanner-interface",
    ],
    "GraceSpacing": [
        "grace-spacing-interface",
        "grob-interface",
        "spacing-options-interface",
        "spanner-interface",
    ],
    "GridLine": [
        "grid-line-interface",
        "grob-interface",
        "item-interface",
        "self-alignment-interface",
    ],
    "GridPoint": ["grid-point-interface", "grob-interface", "item-interface"],
    "Hairpin": [
        "dynamic-interface",
        "grob-interface",
        "hairpin-interface",
        "line-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "spanner-interface",
    ],
    "HorizontalBracket": [
        "grob-interface",
        "horizontal-bracket-interface",
        "line-interface",
        "outside-staff-interface",
        "side-position-interface",
        "spanner-interface",
    ],
    "HorizontalBracketText": [
        "font-interface",
        "grob-interface",
        "horizontal-bracket-text-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "spanner-interface",
        "text-interface",
    ],
    "InstrumentName": [
        "font-interface",
        "grob-interface",
        "self-alignment-interface",
        "side-position-interface",
        "spanner-interface",
        "system-start-text-interface",
        "text-interface",
    ],
    "InstrumentSwitch": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "text-interface",
    ],
    "KeyCancellation": [
        "break-aligned-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "key-cancellation-interface",
        "key-signature-interface",
        "pure-from-neighbor-interface",
        "staff-symbol-referencer-interface",
    ],
    "KeySignature": [
        "break-aligned-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "key-signature-interface",
        "pure-from-neighbor-interface",
        "staff-symbol-referencer-interface",
    ],
    "KievanLigature": [
        "font-interface",
        "grob-interface",
        "kievan-ligature-interface",
        "spanner-interface",
    ],
    "LaissezVibrerTie": ["grob-interface", "item-interface", "semi-tie-interface"],
    "LaissezVibrerTieColumn": [
        "grob-interface",
        "item-interface",
        "semi-tie-column-interface",
    ],
    "LedgerLineSpanner": [
        "grob-interface",
        "ledger-line-spanner-interface",
        "spanner-interface",
    ],
    "LeftEdge": ["break-aligned-interface", "grob-interface", "item-interface"],
    "LigatureBracket": [
        "grob-interface",
        "line-interface",
        "spanner-interface",
        "tuplet-bracket-interface",
    ],
    "LyricExtender": [
        "grob-interface",
        "lyric-extender-interface",
        "lyric-interface",
        "spanner-interface",
    ],
    "LyricHyphen": [
        "font-interface",
        "grob-interface",
        "lyric-hyphen-interface",
        "lyric-interface",
        "spanner-interface",
    ],
    "LyricSpace": ["grob-interface", "lyric-hyphen-interface", "spanner-interface"],
    "LyricText": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "lyric-syllable-interface",
        "rhythmic-grob-interface",
        "self-alignment-interface",
        "text-interface",
    ],
    "MeasureCounter": [
        "font-interface",
        "grob-interface",
        "measure-counter-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "spanner-interface",
        "text-interface",
    ],
    "MeasureGrouping": [
        "grob-interface",
        "measure-grouping-interface",
        "outside-staff-interface",
        "side-position-interface",
        "spanner-interface",
    ],
    "MelodyItem": ["grob-interface", "item-interface", "melody-spanner-interface"],
    "MensuralLigature": [
        "font-interface",
        "grob-interface",
        "mensural-ligature-interface",
        "spanner-interface",
    ],
    "MetronomeMark": [
        "break-alignable-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "metronome-mark-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "text-interface",
    ],
    "MultiMeasureRest": [
        "font-interface",
        "grob-interface",
        "multi-measure-interface",
        "multi-measure-rest-interface",
        "outside-staff-interface",
        "rest-interface",
        "spanner-interface",
        "staff-symbol-referencer-interface",
    ],
    "MultiMeasureRestNumber": [
        "font-interface",
        "grob-interface",
        "multi-measure-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "spanner-interface",
        "text-interface",
    ],
    "MultiMeasureRestText": [
        "font-interface",
        "grob-interface",
        "multi-measure-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "spanner-interface",
        "text-interface",
    ],
    "NonMusicalPaperColumn": [
        "axis-group-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "paper-column-interface",
        "separation-item-interface",
        "spaceable-grob-interface",
    ],
    "NoteCollision": [
        "axis-group-interface",
        "grob-interface",
        "item-interface",
        "note-collision-interface",
    ],
    "NoteColumn": [
        "axis-group-interface",
        "grob-interface",
        "item-interface",
        "note-column-interface",
        "separation-item-interface",
    ],
    "NoteHead": [
        "font-interface",
        "gregorian-ligature-interface",
        "grob-interface",
        "item-interface",
        "ledgered-interface",
        "ligature-head-interface",
        "mensural-ligature-interface",
        "note-head-interface",
        "rhythmic-grob-interface",
        "rhythmic-head-interface",
        "staff-symbol-referencer-interface",
        "vaticana-ligature-interface",
    ],
    "NoteName": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "note-name-interface",
        "text-interface",
    ],
    "NoteSpacing": [
        "grob-interface",
        "item-interface",
        "note-spacing-interface",
        "spacing-interface",
    ],
    "OttavaBracket": [
        "font-interface",
        "grob-interface",
        "horizontal-bracket-interface",
        "line-interface",
        "ottava-bracket-interface",
        "outside-staff-interface",
        "side-position-interface",
        "spanner-interface",
        "text-interface",
    ],
    "PaperColumn": [
        "axis-group-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "paper-column-interface",
        "separation-item-interface",
        "spaceable-grob-interface",
    ],
    "ParenthesesItem": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "parentheses-interface",
    ],
    "PercentRepeat": [
        "font-interface",
        "grob-interface",
        "multi-measure-rest-interface",
        "percent-repeat-interface",
        "spanner-interface",
    ],
    "PercentRepeatCounter": [
        "font-interface",
        "grob-interface",
        "outside-staff-interface",
        "percent-repeat-interface",
        "self-alignment-interface",
        "side-position-interface",
        "spanner-interface",
        "text-interface",
    ],
    "PhrasingSlur": [
        "grob-interface",
        "outside-staff-interface",
        "slur-interface",
        "spanner-interface",
    ],
    "PianoPedalBracket": [
        "grob-interface",
        "line-interface",
        "piano-pedal-bracket-interface",
        "piano-pedal-interface",
        "spanner-interface",
    ],
    "RehearsalMark": [
        "break-alignable-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "mark-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "text-interface",
    ],
    "RepeatSlash": [
        "grob-interface",
        "item-interface",
        "percent-repeat-interface",
        "percent-repeat-item-interface",
        "rhythmic-grob-interface",
    ],
    "RepeatTie": ["grob-interface", "item-interface", "semi-tie-interface"],
    "RepeatTieColumn": [
        "grob-interface",
        "item-interface",
        "semi-tie-column-interface",
    ],
    "Rest": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "rest-interface",
        "rhythmic-grob-interface",
        "rhythmic-head-interface",
        "staff-symbol-referencer-interface",
    ],
    "RestCollision": ["grob-interface", "item-interface", "rest-collision-interface"],
    "Script": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "script-interface",
        "self-alignment-interface",
        "side-position-interface",
    ],
    "ScriptColumn": ["grob-interface", "item-interface", "script-column-interface"],
    "ScriptRow": ["grob-interface", "item-interface", "script-column-interface"],
    "Slur": [
        "grob-interface",
        "outside-staff-interface",
        "slur-interface",
        "spanner-interface",
    ],
    "SostenutoPedal": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "piano-pedal-script-interface",
        "self-alignment-interface",
        "text-interface",
    ],
    "SostenutoPedalLineSpanner": [
        "axis-group-interface",
        "grob-interface",
        "outside-staff-interface",
        "piano-pedal-interface",
        "side-position-interface",
        "spanner-interface",
    ],
    "SpacingSpanner": [
        "grob-interface",
        "spacing-options-interface",
        "spacing-spanner-interface",
        "spanner-interface",
    ],
    "SpanBar": [
        "bar-line-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "span-bar-interface",
    ],
    "SpanBarStub": [
        "grob-interface",
        "item-interface",
        "pure-from-neighbor-interface",
    ],
    "StaffGrouper": ["grob-interface", "spanner-interface", "staff-grouper-interface"],
    "StaffSpacing": [
        "grob-interface",
        "item-interface",
        "spacing-interface",
        "staff-spacing-interface",
    ],
    "StaffSymbol": ["grob-interface", "spanner-interface", "staff-symbol-interface"],
    "StanzaNumber": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "side-position-interface",
        "stanza-number-interface",
        "text-interface",
    ],
    "Stem": ["grob-interface", "item-interface", "stem-interface"],
    "StemStub": ["grob-interface", "item-interface"],
    "StemTremolo": [
        "grob-interface",
        "item-interface",
        "self-alignment-interface",
        "stem-tremolo-interface",
    ],
    "StringNumber": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "number-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "string-number-interface",
        "text-interface",
        "text-script-interface",
    ],
    "StrokeFinger": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "stroke-finger-interface",
        "text-interface",
        "text-script-interface",
    ],
    "SustainPedal": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "piano-pedal-interface",
        "piano-pedal-script-interface",
        "self-alignment-interface",
        "text-interface",
    ],
    "SustainPedalLineSpanner": [
        "axis-group-interface",
        "grob-interface",
        "outside-staff-interface",
        "piano-pedal-interface",
        "side-position-interface",
        "spanner-interface",
    ],
    "System": [
        "axis-group-interface",
        "grob-interface",
        "outside-staff-axis-group-interface",
        "spanner-interface",
        "system-interface",
    ],
    "SystemStartBar": [
        "grob-interface",
        "side-position-interface",
        "spanner-interface",
        "system-start-delimiter-interface",
    ],
    "SystemStartBrace": [
        "font-interface",
        "grob-interface",
        "side-position-interface",
        "spanner-interface",
        "system-start-delimiter-interface",
    ],
    "SystemStartBracket": [
        "font-interface",
        "grob-interface",
        "side-position-interface",
        "spanner-interface",
        "system-start-delimiter-interface",
    ],
    "SystemStartSquare": [
        "font-interface",
        "grob-interface",
        "side-position-interface",
        "spanner-interface",
        "system-start-delimiter-interface",
    ],
    "TabNoteHead": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "note-head-interface",
        "rhythmic-grob-interface",
        "rhythmic-head-interface",
        "staff-symbol-referencer-interface",
        "tab-note-head-interface",
        "text-interface",
    ],
    "TextScript": [
        "font-interface",
        "grob-interface",
        "instrument-specific-markup-interface",
        "item-interface",
        "outside-staff-interface",
        "self-alignment-interface",
        "side-position-interface",
        "text-interface",
        "text-script-interface",
    ],
    "TextSpanner": [
        "font-interface",
        "grob-interface",
        "line-interface",
        "line-spanner-interface",
        "outside-staff-interface",
        "side-position-interface",
        "spanner-interface",
    ],
    "Tie": ["grob-interface", "spanner-interface", "tie-interface"],
    "TieColumn": ["grob-interface", "spanner-interface", "tie-column-interface"],
    "TimeSignature": [
        "break-aligned-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "pure-from-neighbor-interface",
        "time-signature-interface",
    ],
    "TrillPitchAccidental": [
        "accidental-interface",
        "font-interface",
        "grob-interface",
        "inline-accidental-interface",
        "item-interface",
        "side-position-interface",
        "trill-pitch-accidental-interface",
    ],
    "TrillPitchGroup": [
        "axis-group-interface",
        "font-interface",
        "grob-interface",
        "item-interface",
        "note-head-interface",
        "parentheses-interface",
        "side-position-interface",
    ],
    "TrillPitchHead": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "ledgered-interface",
        "pitched-trill-interface",
        "rhythmic-head-interface",
        "staff-symbol-referencer-interface",
    ],
    "TrillSpanner": [
        "font-interface",
        "grob-interface",
        "line-interface",
        "line-spanner-interface",
        "outside-staff-interface",
        "side-position-interface",
        "spanner-interface",
        "trill-spanner-interface",
    ],
    "TupletBracket": [
        "grob-interface",
        "line-interface",
        "outside-staff-interface",
        "spanner-interface",
        "tuplet-bracket-interface",
    ],
    "TupletNumber": [
        "font-interface",
        "grob-interface",
        "outside-staff-interface",
        "spanner-interface",
        "text-interface",
        "tuplet-number-interface",
    ],
    "UnaCordaPedal": [
        "font-interface",
        "grob-interface",
        "item-interface",
        "piano-pedal-script-interface",
        "self-alignment-interface",
        "text-interface",
    ],
    "UnaCordaPedalLineSpanner": [
        "axis-group-interface",
        "grob-interface",
        "outside-staff-interface",
        "piano-pedal-interface",
        "side-position-interface",
        "spanner-interface",
    ],
    "VaticanaLigature": [
        "font-interface",
        "grob-interface",
        "spanner-interface",
        "vaticana-ligature-interface",
    ],
    "Vertical": [
        "align-interface",
        "axis-group-interface",
        "grob-interface",
        "spanner-interface",
    ],
    "VerticalAxisGroup": [
        "axis-group-interface",
        "grob-interface",
        "hara-kiri-group-spanner-interface",
        "outside-staff-axis-group-interface",
        "spanner-interface",
    ],
    "VoiceFollower": [
        "grob-interface",
        "line-interface",
        "line-spanner-interface",
        "spanner-interface",
    ],
    "VoltaBracket": [
        "font-interface",
        "grob-interface",
        "horizontal-bracket-interface",
        "line-interface",
        "side-position-interface",
        "spanner-interface",
        "text-interface",
        "volta-bracket-interface",
        "volta-interface",
    ],
    "VoltaBracketSpanner": [
        "axis-group-interface",
        "grob-interface",
        "outside-staff-interface",
        "side-position-interface",
        "spanner-interface",
        "volta-interface",
    ],
}

lilypond_version = "2.19.84"

interface_properties = {
    "accidental-interface": [
        "alteration",
        "avoid-slur",
        "glyph-name",
        "glyph-name-alist",
        "hide-tied-accidental-after-break",
        "parenthesized",
        "restore-first",
    ],
    "accidental-placement-interface": [
        "direction",
        "padding",
        "positioning-done",
        "right-padding",
        "script-priority",
    ],
    "accidental-suggestion-interface": [],
    "align-interface": [
        "align-dir",
        "axes",
        "padding",
        "positioning-done",
        "stacking-dir",
    ],
    "ambitus-interface": ["gap", "length-fraction", "maximum-gap", "thickness"],
    "arpeggio-interface": [
        "arpeggio-direction",
        "dash-definition",
        "positions",
        "protrusion",
        "script-priority",
    ],
    "axis-group-interface": [
        "axes",
        "default-staff-staff-spacing",
        "no-alignment",
        "nonstaff-nonstaff-spacing",
        "nonstaff-relatedstaff-spacing",
        "nonstaff-unrelatedstaff-spacing",
        "staff-affinity",
        "staff-staff-spacing",
    ],
    "balloon-interface": ["annotation-balloon", "annotation-line", "padding", "text"],
    "bar-line-interface": [
        "allow-span-bar",
        "bar-extent",
        "gap",
        "glyph",
        "glyph-name",
        "hair-thickness",
        "kern",
        "rounded",
        "segno-kern",
        "thick-thickness",
    ],
    "bass-figure-alignment-interface": [],
    "bass-figure-interface": ["implicit"],
    "beam-interface": [
        "X-positions",
        "annotation",
        "auto-knee-gap",
        "beam-thickness",
        "beamed-stem-shorten",
        "beaming",
        "break-overshoot",
        "clip-edges",
        "collision-interfaces",
        "collision-voice-only",
        "concaveness",
        "damping",
        "details",
        "direction",
        "gap",
        "gap-count",
        "grow-direction",
        "inspect-quants",
        "knee",
        "length-fraction",
        "neutral-direction",
        "positions",
        "skip-quanting",
    ],
    "bend-after-interface": ["thickness"],
    "break-alignable-interface": ["break-align-symbols", "non-break-align-symbols"],
    "break-aligned-interface": [
        "break-align-anchor",
        "break-align-anchor-alignment",
        "break-align-symbol",
        "space-alist",
    ],
    "break-alignment-interface": ["break-align-orders", "positioning-done"],
    "breathing-sign-interface": ["direction"],
    "chord-name-interface": [],
    "clef-interface": ["full-size-change", "glyph", "glyph-name", "non-default"],
    "clef-modifier-interface": ["clef-alignments"],
    "cluster-beacon-interface": ["positions"],
    "cluster-interface": ["padding", "style"],
    "custos-interface": ["neutral-direction", "neutral-position", "style"],
    "dot-column-interface": ["chord-dots-limit", "direction", "positioning-done"],
    "dots-interface": ["direction", "dot-count", "style"],
    "dynamic-interface": [],
    "dynamic-line-spanner-interface": ["avoid-slur"],
    "dynamic-text-interface": ["right-padding"],
    "dynamic-text-spanner-interface": ["text"],
    "enclosing-bracket-interface": [
        "bracket-flare",
        "edge-height",
        "padding",
        "shorten-pair",
        "thickness",
    ],
    "episema-interface": [],
    "figured-bass-continuation-interface": ["padding", "thickness"],
    "finger-interface": [],
    "fingering-column-interface": ["padding", "positioning-done", "snap-radius"],
    "flag-interface": ["glyph-name", "stroke-style", "style"],
    "font-interface": [
        "font-encoding",
        "font-family",
        "font-features",
        "font-name",
        "font-series",
        "font-shape",
        "font-size",
    ],
    "footnote-interface": ["automatically-numbered", "footnote", "footnote-text"],
    "footnote-spanner-interface": ["footnote-text"],
    "fret-diagram-interface": [
        "align-dir",
        "dot-placement-list",
        "fret-diagram-details",
        "size",
        "thickness",
    ],
    "glissando-interface": [],
    "grace-spacing-interface": ["common-shortest-duration"],
    "gregorian-ligature-interface": [],
    "grid-line-interface": ["thickness"],
    "grid-point-interface": [],
    "grob-interface": [
        "X-extent",
        "X-offset",
        "Y-extent",
        "Y-offset",
        "after-line-breaking",
        "avoid-slur",
        "before-line-breaking",
        "color",
        "cross-staff",
        "extra-offset",
        "footnote-music",
        "forced-spacing",
        "horizontal-skylines",
        "id",
        "layer",
        "minimum-X-extent",
        "minimum-Y-extent",
        "output-attributes",
        "parenthesis-friends",
        "rotation",
        "skyline-horizontal-padding",
        "springs-and-rods",
        "stencil",
        "transparent",
        "vertical-skylines",
        "whiteout",
        "whiteout-style",
    ],
    "hairpin-interface": [
        "bound-padding",
        "broken-bound-padding",
        "circled-tip",
        "grow-direction",
        "height",
        "shorten-pair",
    ],
    "hara-kiri-group-spanner-interface": [
        "remove-empty",
        "remove-first",
        "remove-layer",
    ],
    "horizontal-bracket-interface": [
        "bracket-flare",
        "connect-to-neighbor",
        "edge-height",
        "shorten-pair",
    ],
    "horizontal-bracket-text-interface": [],
    "inline-accidental-interface": [],
    "instrument-specific-markup-interface": [
        "fret-diagram-details",
        "graphical",
        "harp-pedal-details",
        "size",
        "thickness",
    ],
    "item-interface": [
        "break-visibility",
        "extra-spacing-height",
        "extra-spacing-width",
        "non-musical",
    ],
    "key-cancellation-interface": [],
    "key-signature-interface": [
        "alteration-alist",
        "flat-positions",
        "glyph-name-alist",
        "non-default",
        "padding",
        "padding-pairs",
        "sharp-positions",
    ],
    "kievan-ligature-interface": ["padding"],
    "ledger-line-spanner-interface": [
        "gap",
        "length-fraction",
        "minimum-length-fraction",
    ],
    "ledgered-interface": ["no-ledgers"],
    "ligature-bracket-interface": ["height", "thickness", "width"],
    "ligature-head-interface": [],
    "ligature-interface": [],
    "line-interface": [
        "arrow-length",
        "arrow-width",
        "dash-fraction",
        "dash-period",
        "style",
        "thickness",
        "zigzag-length",
        "zigzag-width",
    ],
    "line-spanner-interface": [
        "bound-details",
        "extra-dy",
        "gap",
        "left-bound-info",
        "right-bound-info",
        "simple-Y",
        "thickness",
        "to-barline",
    ],
    "lyric-extender-interface": ["left-padding", "next", "right-padding", "thickness"],
    "lyric-hyphen-interface": [
        "dash-period",
        "height",
        "length",
        "minimum-distance",
        "minimum-length",
        "padding",
        "thickness",
    ],
    "lyric-interface": [],
    "lyric-syllable-interface": [],
    "mark-interface": [],
    "measure-counter-interface": ["count-from", "spacing-pair"],
    "measure-grouping-interface": ["height", "style", "thickness"],
    "melody-spanner-interface": ["neutral-direction"],
    "mensural-ligature-interface": ["thickness"],
    "metronome-mark-interface": [],
    "multi-measure-interface": ["bound-padding"],
    "multi-measure-rest-interface": [
        "bound-padding",
        "expand-limit",
        "hair-thickness",
        "max-symbol-separation",
        "measure-count",
        "minimum-length",
        "round-up-exceptions",
        "round-up-to-longer-rest",
        "spacing-pair",
        "thick-thickness",
        "usable-duration-logs",
    ],
    "note-collision-interface": [
        "merge-differently-dotted",
        "merge-differently-headed",
        "note-collision-threshold",
        "positioning-done",
        "prefer-dotted-right",
    ],
    "note-column-interface": [
        "force-hshift",
        "glissando-skip",
        "horizontal-shift",
        "ignore-collision",
    ],
    "note-head-interface": [
        "duration-log",
        "glyph-name",
        "ignore-ambitus",
        "ledger-positions",
        "note-names",
        "stem-attachment",
        "style",
    ],
    "note-name-interface": [],
    "note-spacing-interface": [
        "knee-spacing-correction",
        "same-direction-correction",
        "space-to-barline",
        "stem-spacing-correction",
    ],
    "number-interface": ["number-type"],
    "only-prebreak-interface": [],
    "ottava-bracket-interface": [
        "bracket-flare",
        "edge-height",
        "minimum-length",
        "shorten-pair",
    ],
    "outside-staff-axis-group-interface": ["outside-staff-placement-directive"],
    "outside-staff-interface": [
        "outside-staff-horizontal-padding",
        "outside-staff-padding",
        "outside-staff-priority",
    ],
    "paper-column-interface": [
        "between-cols",
        "full-measure-extra-space",
        "labels",
        "line-break-penalty",
        "line-break-permission",
        "line-break-system-details",
        "page-break-penalty",
        "page-break-permission",
        "page-turn-penalty",
        "page-turn-permission",
        "rhythmic-location",
        "shortest-playing-duration",
        "shortest-starter-duration",
        "used",
        "when",
    ],
    "parentheses-interface": ["padding", "stencils"],
    "percent-repeat-interface": [
        "dot-negative-kern",
        "slash-negative-kern",
        "slope",
        "thickness",
    ],
    "percent-repeat-item-interface": [
        "dot-negative-kern",
        "slash-negative-kern",
        "slope",
        "thickness",
    ],
    "piano-pedal-bracket-interface": [
        "bound-padding",
        "bracket-flare",
        "edge-height",
        "shorten-pair",
    ],
    "piano-pedal-interface": [],
    "piano-pedal-script-interface": [],
    "pitched-trill-interface": [],
    "pure-from-neighbor-interface": [],
    "rest-collision-interface": ["minimum-distance", "positioning-done"],
    "rest-interface": ["direction", "minimum-distance", "style", "voiced-position"],
    "rhythmic-grob-interface": [],
    "rhythmic-head-interface": ["duration-log", "glissando-skip"],
    "script-column-interface": [],
    "script-interface": [
        "avoid-slur",
        "positioning-done",
        "script-priority",
        "side-relative-direction",
        "slur-padding",
        "toward-stem-shift",
        "toward-stem-shift-in-column",
    ],
    "self-alignment-interface": [
        "X-align-on-main-noteheads",
        "parent-alignment-X",
        "parent-alignment-Y",
        "self-alignment-X",
        "self-alignment-Y",
    ],
    "semi-tie-column-interface": [
        "head-direction",
        "positioning-done",
        "tie-configuration",
    ],
    "semi-tie-interface": [
        "control-points",
        "details",
        "direction",
        "head-direction",
        "line-thickness",
        "thickness",
    ],
    "separation-item-interface": [
        "X-extent",
        "horizontal-skylines",
        "padding",
        "skyline-vertical-padding",
    ],
    "side-position-interface": [
        "add-stem-support",
        "direction",
        "horizon-padding",
        "minimum-space",
        "padding",
        "side-axis",
        "slur-padding",
        "staff-padding",
        "use-skylines",
    ],
    "slur-interface": [
        "annotation",
        "avoid-slur",
        "control-points",
        "dash-definition",
        "details",
        "direction",
        "eccentricity",
        "height-limit",
        "inspect-index",
        "inspect-quants",
        "line-thickness",
        "positions",
        "ratio",
        "thickness",
    ],
    "spaceable-grob-interface": [
        "allow-loose-spacing",
        "keep-inside-line",
        "measure-length",
    ],
    "spacing-interface": [],
    "spacing-options-interface": ["shortest-duration-space", "spacing-increment"],
    "spacing-spanner-interface": [
        "average-spacing-wishes",
        "base-shortest-duration",
        "common-shortest-duration",
        "packed-spacing",
        "shortest-duration-space",
        "spacing-increment",
        "strict-grace-spacing",
        "strict-note-spacing",
        "uniform-stretching",
    ],
    "span-bar-interface": ["glyph-name"],
    "spanner-interface": [
        "minimum-length",
        "minimum-length-after-break",
        "normalized-endpoints",
        "spanner-id",
        "to-barline",
    ],
    "staff-grouper-interface": ["staff-staff-spacing", "staffgroup-staff-spacing"],
    "staff-spacing-interface": ["stem-spacing-correction"],
    "staff-symbol-interface": [
        "break-align-symbols",
        "ledger-extra",
        "ledger-line-thickness",
        "ledger-positions",
        "ledger-positions-function",
        "line-count",
        "line-positions",
        "staff-space",
        "thickness",
        "width",
    ],
    "staff-symbol-referencer-interface": ["staff-position"],
    "stanza-number-interface": [],
    "stem-interface": [
        "avoid-note-head",
        "beaming",
        "beamlet-default-length",
        "beamlet-max-length-proportion",
        "default-direction",
        "details",
        "direction",
        "double-stem-separation",
        "duration-log",
        "french-beaming",
        "length",
        "length-fraction",
        "max-beam-connect",
        "neutral-direction",
        "no-stem-extend",
        "note-collision-threshold",
        "positioning-done",
        "stem-begin-position",
        "stemlet-length",
        "thickness",
    ],
    "stem-tremolo-interface": [
        "beam-thickness",
        "beam-width",
        "direction",
        "flag-count",
        "length-fraction",
        "shape",
        "slope",
    ],
    "string-number-interface": [],
    "stroke-finger-interface": ["digit-names"],
    "system-interface": ["labels"],
    "system-start-delimiter-interface": ["collapse-height", "style", "thickness"],
    "system-start-text-interface": [
        "long-text",
        "self-alignment-X",
        "self-alignment-Y",
        "text",
    ],
    "tab-note-head-interface": ["details"],
    "text-interface": [
        "baseline-skip",
        "flag-style",
        "replacement-alist",
        "text",
        "text-direction",
        "word-space",
    ],
    "text-script-interface": ["avoid-slur", "script-priority"],
    "tie-column-interface": ["positioning-done", "tie-configuration"],
    "tie-interface": [
        "annotation",
        "avoid-slur",
        "control-points",
        "dash-definition",
        "details",
        "direction",
        "head-direction",
        "line-thickness",
        "neutral-direction",
        "staff-position",
        "thickness",
    ],
    "time-signature-interface": ["fraction", "style"],
    "trill-pitch-accidental-interface": [],
    "trill-spanner-interface": [],
    "tuplet-bracket-interface": [
        "X-positions",
        "avoid-scripts",
        "bracket-flare",
        "bracket-visibility",
        "break-overshoot",
        "connect-to-neighbor",
        "direction",
        "edge-height",
        "edge-text",
        "full-length-padding",
        "full-length-to-extent",
        "gap",
        "padding",
        "positions",
        "shorten-pair",
        "staff-padding",
        "thickness",
    ],
    "tuplet-number-interface": ["avoid-slur", "direction", "knee-to-beam"],
    "unbreakable-spanner-interface": ["breakable"],
    "vaticana-ligature-interface": ["glyph-name", "thickness"],
    "volta-bracket-interface": ["height", "shorten-pair", "thickness"],
    "volta-interface": [],
}

lilypond_version = "2.19.84"

language_pitch_names = {
    "nederlands": {
        "ceses": "cff",
        "ceseh": "ctqf",
        "ces": "cf",
        "ceh": "cqf",
        "c": "c",
        "cih": "cqs",
        "cis": "cs",
        "cisih": "ctqs",
        "cisis": "css",
        "deses": "dff",
        "deseh": "dtqf",
        "des": "df",
        "deh": "dqf",
        "d": "d",
        "dih": "dqs",
        "dis": "ds",
        "disih": "dtqs",
        "disis": "dss",
        "eeses": "eff",
        "eses": "eff",
        "eeseh": "etqf",
        "ees": "ef",
        "es": "ef",
        "eeh": "eqf",
        "e": "e",
        "eih": "eqs",
        "eis": "es",
        "eisih": "etqs",
        "eisis": "ess",
        "feses": "fff",
        "feseh": "ftqf",
        "fes": "ff",
        "feh": "fqf",
        "f": "f",
        "fih": "fqs",
        "fis": "fs",
        "fisih": "ftqs",
        "fisis": "fss",
        "geses": "gff",
        "geseh": "gtqf",
        "ges": "gf",
        "geh": "gqf",
        "g": "g",
        "gih": "gqs",
        "gis": "gs",
        "gisih": "gtqs",
        "gisis": "gss",
        "aeses": "aff",
        "ases": "aff",
        "aeseh": "atqf",
        "aes": "af",
        "as": "af",
        "aeh": "aqf",
        "a": "a",
        "aih": "aqs",
        "ais": "as",
        "aisih": "atqs",
        "aisis": "ass",
        "beses": "bff",
        "beseh": "btqf",
        "bes": "bf",
        "beh": "bqf",
        "b": "b",
        "bih": "bqs",
        "bis": "bs",
        "bisih": "btqs",
        "bisis": "bss",
    },
    "catalan": {
        "dobb": "cff",
        "dob": "cf",
        "do": "c",
        "dod": "cs",
        "dodd": "css",
        "rebb": "dff",
        "reb": "df",
        "re": "d",
        "red": "ds",
        "redd": "dss",
        "mibb": "eff",
        "mib": "ef",
        "mi": "e",
        "mid": "es",
        "midd": "ess",
        "fabb": "fff",
        "fab": "ff",
        "fa": "f",
        "fad": "fs",
        "fadd": "fss",
        "solbb": "gff",
        "solb": "gf",
        "sol": "g",
        "sold": "gs",
        "soldd": "gss",
        "labb": "aff",
        "lab": "af",
        "la": "a",
        "lad": "as",
        "ladd": "ass",
        "sibb": "bff",
        "sib": "bf",
        "si": "b",
        "sid": "bs",
        "sidd": "bss",
        "dos": "cs",
        "doss": "css",
        "res": "ds",
        "ress": "dss",
        "mis": "es",
        "miss": "ess",
        "fas": "fs",
        "fass": "fss",
        "sols": "gs",
        "solss": "gss",
        "las": "as",
        "lass": "ass",
        "sis": "bs",
        "siss": "bss",
    },
    "deutsch": {
        "ceses": "cff",
        "ceseh": "ctqf",
        "ces": "cf",
        "ceh": "cqf",
        "c": "c",
        "cih": "cqs",
        "cis": "cs",
        "cisih": "ctqs",
        "cisis": "css",
        "deses": "dff",
        "deseh": "dtqf",
        "des": "df",
        "deh": "dqf",
        "d": "d",
        "dih": "dqs",
        "dis": "ds",
        "disih": "dtqs",
        "disis": "dss",
        "eses": "eff",
        "eseh": "etqf",
        "es": "ef",
        "eeh": "eqf",
        "eh": "eqf",
        "e": "e",
        "eih": "eqs",
        "eis": "es",
        "eisih": "etqs",
        "eisis": "ess",
        "feses": "fff",
        "feseh": "ftqf",
        "fes": "ff",
        "feh": "fqf",
        "f": "f",
        "fih": "fqs",
        "fis": "fs",
        "fisih": "ftqs",
        "fisis": "fss",
        "geses": "gff",
        "geseh": "gtqf",
        "ges": "gf",
        "geh": "gqf",
        "g": "g",
        "gih": "gqs",
        "gis": "gs",
        "gisih": "gtqs",
        "gisis": "gss",
        "asas": "aff",
        "ases": "aff",
        "asah": "atqf",
        "aseh": "atqf",
        "as": "af",
        "aeh": "aqf",
        "ah": "aqf",
        "a": "a",
        "aih": "aqs",
        "ais": "as",
        "aisih": "atqs",
        "aisis": "ass",
        "heses": "bff",
        "heseh": "btqf",
        "b": "bf",
        "beh": "bqf",
        "h": "b",
        "hih": "bqs",
        "his": "bs",
        "hisih": "btqs",
        "hisis": "bss",
    },
    "english": {
        "cff": "cff",
        "ctqf": "ctqf",
        "cf": "cf",
        "cqf": "cqf",
        "c": "c",
        "cqs": "cqs",
        "cs": "cs",
        "ctqs": "ctqs",
        "css": "css",
        "cx": "css",
        "dff": "dff",
        "dtqf": "dtqf",
        "df": "df",
        "dqf": "dqf",
        "d": "d",
        "dqs": "dqs",
        "ds": "ds",
        "dtqs": "dtqs",
        "dss": "dss",
        "dx": "dss",
        "eff": "eff",
        "etqf": "etqf",
        "ef": "ef",
        "eqf": "eqf",
        "e": "e",
        "eqs": "eqs",
        "es": "es",
        "etqs": "etqs",
        "ess": "ess",
        "ex": "ess",
        "fff": "fff",
        "ftqf": "ftqf",
        "ff": "ff",
        "fqf": "fqf",
        "f": "f",
        "fqs": "fqs",
        "fs": "fs",
        "ftqs": "ftqs",
        "fss": "fss",
        "fx": "fss",
        "gff": "gff",
        "gtqf": "gtqf",
        "gf": "gf",
        "gqf": "gqf",
        "g": "g",
        "gqs": "gqs",
        "gs": "gs",
        "gtqs": "gtqs",
        "gss": "gss",
        "gx": "gss",
        "aff": "aff",
        "atqf": "atqf",
        "af": "af",
        "aqf": "aqf",
        "a": "a",
        "aqs": "aqs",
        "as": "as",
        "atqs": "atqs",
        "ass": "ass",
        "ax": "ass",
        "bff": "bff",
        "btqf": "btqf",
        "bf": "bf",
        "bqf": "bqf",
        "b": "b",
        "bqs": "bqs",
        "bs": "bs",
        "btqs": "btqs",
        "bss": "bss",
        "bx": "bss",
        "c-flatflat": "cff",
        "c-flat": "cf",
        "c-natural": "c",
        "c-sharp": "cs",
        "c-sharpsharp": "css",
        "d-flatflat": "dff",
        "d-flat": "df",
        "d-natural": "d",
        "d-sharp": "ds",
        "d-sharpsharp": "dss",
        "e-flatflat": "eff",
        "e-flat": "ef",
        "e-natural": "e",
        "e-sharp": "es",
        "e-sharpsharp": "ess",
        "f-flatflat": "fff",
        "f-flat": "ff",
        "f-natural": "f",
        "f-sharp": "fs",
        "f-sharpsharp": "fss",
        "g-flatflat": "gff",
        "g-flat": "gf",
        "g-natural": "g",
        "g-sharp": "gs",
        "g-sharpsharp": "gss",
        "a-flatflat": "aff",
        "a-flat": "af",
        "a-natural": "a",
        "a-sharp": "as",
        "a-sharpsharp": "ass",
        "b-flatflat": "bff",
        "b-flat": "bf",
        "b-natural": "b",
        "b-sharp": "bs",
        "b-sharpsharp": "bss",
    },
    "espanol": {
        "dobb": "cff",
        "dotcb": "ctqf",
        "dob": "cf",
        "docb": "cqf",
        "do": "c",
        "docs": "cqs",
        "dos": "cs",
        "dotcs": "ctqs",
        "doss": "css",
        "dox": "css",
        "rebb": "dff",
        "retcb": "dtqf",
        "reb": "df",
        "recb": "dqf",
        "re": "d",
        "recs": "dqs",
        "res": "ds",
        "retcs": "dtqs",
        "ress": "dss",
        "rex": "dss",
        "mibb": "eff",
        "mitcb": "etqf",
        "mib": "ef",
        "micb": "eqf",
        "mi": "e",
        "mics": "eqs",
        "mis": "es",
        "mitcs": "etqs",
        "miss": "ess",
        "mix": "ess",
        "fabb": "fff",
        "fatcb": "ftqf",
        "fab": "ff",
        "facb": "fqf",
        "fa": "f",
        "facs": "fqs",
        "fas": "fs",
        "fatcs": "ftqs",
        "fass": "fss",
        "fax": "fss",
        "solbb": "gff",
        "soltcb": "gtqf",
        "solb": "gf",
        "solcb": "gqf",
        "sol": "g",
        "solcs": "gqs",
        "sols": "gs",
        "soltcs": "gtqs",
        "solss": "gss",
        "solx": "gss",
        "labb": "aff",
        "latcb": "atqf",
        "lab": "af",
        "lacb": "aqf",
        "la": "a",
        "lacs": "aqs",
        "las": "as",
        "latcs": "atqs",
        "lass": "ass",
        "lax": "ass",
        "sibb": "bff",
        "sitcb": "btqf",
        "sib": "bf",
        "sicb": "bqf",
        "si": "b",
        "sics": "bqs",
        "sis": "bs",
        "sitcs": "btqs",
        "siss": "bss",
        "six": "bss",
    },
    "français": {
        "dobb": "cff",
        "dobsb": "ctqf",
        "dob": "cf",
        "dosb": "cqf",
        "do": "c",
        "dosd": "cqs",
        "dod": "cs",
        "dodsd": "ctqs",
        "dodd": "css",
        "dox": "css",
        "rébb": "dff",
        "rébsb": "dtqf",
        "réb": "df",
        "résb": "dqf",
        "ré": "d",
        "résd": "dqs",
        "réd": "ds",
        "rédsd": "dtqs",
        "rédd": "dss",
        "réx": "dss",
        "rebb": "dff",
        "rebsb": "dtqf",
        "reb": "df",
        "resb": "dqf",
        "re": "d",
        "resd": "dqs",
        "red": "ds",
        "redsd": "dtqs",
        "redd": "dss",
        "rex": "dss",
        "mibb": "eff",
        "mibsb": "etqf",
        "mib": "ef",
        "misb": "eqf",
        "mi": "e",
        "misd": "eqs",
        "mid": "es",
        "midsd": "etqs",
        "midd": "ess",
        "mix": "ess",
        "fabb": "fff",
        "fabsb": "ftqf",
        "fab": "ff",
        "fasb": "fqf",
        "fa": "f",
        "fasd": "fqs",
        "fad": "fs",
        "fadsd": "ftqs",
        "fadd": "fss",
        "fax": "fss",
        "solbb": "gff",
        "solbsb": "gtqf",
        "solb": "gf",
        "solsb": "gqf",
        "sol": "g",
        "solsd": "gqs",
        "sold": "gs",
        "soldsd": "gtqs",
        "soldd": "gss",
        "solx": "gss",
        "labb": "aff",
        "labsb": "atqf",
        "lab": "af",
        "lasb": "aqf",
        "la": "a",
        "lasd": "aqs",
        "lad": "as",
        "ladsd": "atqs",
        "ladd": "ass",
        "lax": "ass",
        "sibb": "bff",
        "sibsb": "btqf",
        "sib": "bf",
        "sisb": "bqf",
        "si": "b",
        "sisd": "bqs",
        "sid": "bs",
        "sidsd": "btqs",
        "sidd": "bss",
        "six": "bss",
    },
    "italiano": {
        "dobb": "cff",
        "dobsb": "ctqf",
        "dob": "cf",
        "dosb": "cqf",
        "do": "c",
        "dosd": "cqs",
        "dod": "cs",
        "dodsd": "ctqs",
        "dodd": "css",
        "rebb": "dff",
        "rebsb": "dtqf",
        "reb": "df",
        "resb": "dqf",
        "re": "d",
        "resd": "dqs",
        "red": "ds",
        "redsd": "dtqs",
        "redd": "dss",
        "mibb": "eff",
        "mibsb": "etqf",
        "mib": "ef",
        "misb": "eqf",
        "mi": "e",
        "misd": "eqs",
        "mid": "es",
        "midsd": "etqs",
        "midd": "ess",
        "fabb": "fff",
        "fabsb": "ftqf",
        "fab": "ff",
        "fasb": "fqf",
        "fa": "f",
        "fasd": "fqs",
        "fad": "fs",
        "fadsd": "ftqs",
        "fadd": "fss",
        "solbb": "gff",
        "solbsb": "gtqf",
        "solb": "gf",
        "solsb": "gqf",
        "sol": "g",
        "solsd": "gqs",
        "sold": "gs",
        "soldsd": "gtqs",
        "soldd": "gss",
        "labb": "aff",
        "labsb": "atqf",
        "lab": "af",
        "lasb": "aqf",
        "la": "a",
        "lasd": "aqs",
        "lad": "as",
        "ladsd": "atqs",
        "ladd": "ass",
        "sibb": "bff",
        "sibsb": "btqf",
        "sib": "bf",
        "sisb": "bqf",
        "si": "b",
        "sisd": "bqs",
        "sid": "bs",
        "sidsd": "btqs",
        "sidd": "bss",
    },
    "norsk": {
        "ceses": "cff",
        "cessess": "cff",
        "ces": "cf",
        "cess": "cf",
        "c": "c",
        "cis": "cs",
        "ciss": "cs",
        "cisis": "css",
        "cississ": "css",
        "deses": "dff",
        "dessess": "dff",
        "des": "df",
        "dess": "df",
        "d": "d",
        "dis": "ds",
        "diss": "ds",
        "disis": "dss",
        "dississ": "dss",
        "eeses": "eff",
        "eessess": "eff",
        "eses": "eff",
        "essess": "eff",
        "ees": "ef",
        "eess": "ef",
        "es": "ef",
        "ess": "ef",
        "e": "e",
        "eis": "es",
        "eiss": "es",
        "eisis": "ess",
        "eississ": "ess",
        "feses": "fff",
        "fessess": "fff",
        "fes": "ff",
        "fess": "ff",
        "f": "f",
        "fis": "fs",
        "fiss": "fs",
        "fisis": "fss",
        "fississ": "fss",
        "geses": "gff",
        "gessess": "gff",
        "ges": "gf",
        "gess": "gf",
        "g": "g",
        "g": "g",
        "gis": "gs",
        "giss": "gs",
        "gisis": "gss",
        "gississ": "gss",
        "aeses": "aff",
        "aessess": "aff",
        "ases": "aff",
        "assess": "aff",
        "aes": "af",
        "aess": "af",
        "as": "af",
        "ass": "af",
        "a": "a",
        "ais": "as",
        "aiss": "as",
        "aisis": "ass",
        "aississ": "ass",
        "bes": "bff",
        "bess": "bff",
        "b": "bf",
        "b": "bf",
        "h": "b",
        "his": "bs",
        "hiss": "bs",
        "hisis": "bss",
        "hississ": "bss",
    },
    "portugues": {
        "dobb": "cff",
        "dobtqt": "ctqf",
        "dob": "cf",
        "dobqt": "cqf",
        "do": "c",
        "dosqt": "cqs",
        "dos": "cs",
        "dostqt": "ctqs",
        "doss": "css",
        "rebb": "dff",
        "rebtqt": "dtqf",
        "reb": "df",
        "rebqt": "dqf",
        "re": "d",
        "resqt": "dqs",
        "res": "ds",
        "restqt": "dtqs",
        "ress": "dss",
        "mibb": "eff",
        "mibtqt": "etqf",
        "mib": "ef",
        "mibqt": "eqf",
        "mi": "e",
        "misqt": "eqs",
        "mis": "es",
        "mistqt": "etqs",
        "miss": "ess",
        "fabb": "fff",
        "fabtqt": "ftqf",
        "fab": "ff",
        "fabqt": "fqf",
        "fa": "f",
        "fasqt": "fqs",
        "fas": "fs",
        "fastqt": "ftqs",
        "fass": "fss",
        "solbb": "gff",
        "solbtqt": "gtqf",
        "solb": "gf",
        "solbqt": "gqf",
        "sol": "g",
        "solsqt": "gqs",
        "sols": "gs",
        "solstqt": "gtqs",
        "solss": "gss",
        "labb": "aff",
        "labtqt": "atqf",
        "lab": "af",
        "labqt": "aqf",
        "la": "a",
        "lasqt": "aqs",
        "las": "as",
        "lastqt": "atqs",
        "lass": "ass",
        "sibb": "bff",
        "sibtqt": "btqf",
        "sib": "bf",
        "sibqt": "bqf",
        "si": "b",
        "sisqt": "bqs",
        "sis": "bs",
        "sistqt": "btqs",
        "siss": "bss",
    },
    "suomi": {
        "ceses": "cff",
        "ces": "cf",
        "c": "c",
        "cis": "cs",
        "cisis": "css",
        "deses": "dff",
        "des": "df",
        "d": "d",
        "dis": "ds",
        "disis": "dss",
        "eses": "eff",
        "es": "ef",
        "e": "e",
        "eis": "es",
        "eisis": "ess",
        "feses": "fff",
        "fes": "ff",
        "f": "f",
        "fis": "fs",
        "fisis": "fss",
        "geses": "gff",
        "ges": "gf",
        "g": "g",
        "gis": "gs",
        "gisis": "gss",
        "asas": "aff",
        "ases": "aff",
        "as": "af",
        "a": "a",
        "ais": "as",
        "aisis": "ass",
        "bb": "bff",
        "bes": "bff",
        "heses": "bff",
        "b": "bf",
        "h": "b",
        "his": "bs",
        "hisis": "bss",
    },
    "svenska": {
        "cessess": "cff",
        "cess": "cf",
        "c": "c",
        "ciss": "cs",
        "cississ": "css",
        "dessess": "dff",
        "dess": "df",
        "d": "d",
        "diss": "ds",
        "dississ": "dss",
        "essess": "eff",
        "ess": "ef",
        "e": "e",
        "eiss": "es",
        "eississ": "ess",
        "fessess": "fff",
        "fess": "ff",
        "f": "f",
        "fiss": "fs",
        "fississ": "fss",
        "gessess": "gff",
        "gess": "gf",
        "g": "g",
        "giss": "gs",
        "gississ": "gss",
        "assess": "aff",
        "ass": "af",
        "a": "a",
        "aiss": "as",
        "aississ": "ass",
        "hessess": "bff",
        "b": "bf",
        "h": "b",
        "hiss": "bs",
        "hississ": "bss",
    },
    "vlaams": {
        "dobb": "cff",
        "dob": "cf",
        "do": "c",
        "dok": "cs",
        "dokk": "css",
        "rebb": "dff",
        "reb": "df",
        "re": "d",
        "rek": "ds",
        "rekk": "dss",
        "mibb": "eff",
        "mib": "ef",
        "mi": "e",
        "mik": "es",
        "mikk": "ess",
        "fabb": "fff",
        "fab": "ff",
        "fa": "f",
        "fak": "fs",
        "fakk": "fss",
        "solbb": "gff",
        "solb": "gf",
        "sol": "g",
        "solk": "gs",
        "solkk": "gss",
        "labb": "aff",
        "lab": "af",
        "la": "a",
        "lak": "as",
        "lakk": "ass",
        "sibb": "bff",
        "sib": "bf",
        "si": "b",
        "sik": "bs",
        "sikk": "bss",
    },
    "español": {
        "dobb": "cff",
        "dotcb": "ctqf",
        "dob": "cf",
        "docb": "cqf",
        "do": "c",
        "docs": "cqs",
        "dos": "cs",
        "dotcs": "ctqs",
        "doss": "css",
        "dox": "css",
        "rebb": "dff",
        "retcb": "dtqf",
        "reb": "df",
        "recb": "dqf",
        "re": "d",
        "recs": "dqs",
        "res": "ds",
        "retcs": "dtqs",
        "ress": "dss",
        "rex": "dss",
        "mibb": "eff",
        "mitcb": "etqf",
        "mib": "ef",
        "micb": "eqf",
        "mi": "e",
        "mics": "eqs",
        "mis": "es",
        "mitcs": "etqs",
        "miss": "ess",
        "mix": "ess",
        "fabb": "fff",
        "fatcb": "ftqf",
        "fab": "ff",
        "facb": "fqf",
        "fa": "f",
        "facs": "fqs",
        "fas": "fs",
        "fatcs": "ftqs",
        "fass": "fss",
        "fax": "fss",
        "solbb": "gff",
        "soltcb": "gtqf",
        "solb": "gf",
        "solcb": "gqf",
        "sol": "g",
        "solcs": "gqs",
        "sols": "gs",
        "soltcs": "gtqs",
        "solss": "gss",
        "solx": "gss",
        "labb": "aff",
        "latcb": "atqf",
        "lab": "af",
        "lacb": "aqf",
        "la": "a",
        "lacs": "aqs",
        "las": "as",
        "latcs": "atqs",
        "lass": "ass",
        "lax": "ass",
        "sibb": "bff",
        "sitcb": "btqf",
        "sib": "bf",
        "sicb": "bqf",
        "si": "b",
        "sics": "bqs",
        "sis": "bs",
        "sitcs": "btqs",
        "siss": "bss",
        "six": "bss",
    },
}

lilypond_version = "2.19.24"

markup_functions = {
    "abs-fontsize": ("number?", "cheap-markup?"),
    "arrow-head": ("integer?", "ly:dir?", "boolean?"),
    "auto-footnote": ("cheap-markup?", "cheap-markup?"),
    "backslashed-digit": ("integer?",),
    "beam": ("number?", "number?", "number?"),
    "bold": ("cheap-markup?",),
    "box": ("cheap-markup?",),
    "bracket": ("cheap-markup?",),
    "caps": ("cheap-markup?",),
    "center-align": ("cheap-markup?",),
    "center-column": ("markup-list?",),
    "char": ("integer?",),
    "circle": ("cheap-markup?",),
    "column": ("markup-list?",),
    "combine": ("cheap-markup?", "cheap-markup?"),
    "compound-meter": ("number-or-pair?",),
    "concat": ("markup-list?",),
    "customTabClef": ("integer?", "number?"),
    "dir-column": ("markup-list?",),
    "doubleflat": (),
    "doublesharp": (),
    "draw-circle": ("number?", "number?", "boolean?"),
    "draw-dashed-line": ("number-pair?",),
    "draw-dotted-line": ("number-pair?",),
    "draw-hline": (),
    "draw-line": ("number-pair?",),
    "dynamic": ("cheap-markup?",),
    "ellipse": ("cheap-markup?",),
    "epsfile": ("number?", "number?", "string?"),
    "eyeglasses": (),
    "fermata": (),
    "fill-line": ("markup-list?",),
    "fill-with-pattern": (
        "number?",
        "ly:dir?",
        "cheap-markup?",
        "cheap-markup?",
        "cheap-markup?",
    ),
    "filled-box": ("number-pair?", "number-pair?", "number?"),
    "finger": ("cheap-markup?",),
    "first-visible": ("markup-list?",),
    "flat": (),
    "fontCaps": ("cheap-markup?",),
    "fontsize": ("number?", "cheap-markup?"),
    "footnote": ("cheap-markup?", "cheap-markup?"),
    "fraction": ("cheap-markup?", "cheap-markup?"),
    "fret-diagram": ("string?",),
    "fret-diagram-terse": ("string?",),
    "fret-diagram-verbose": ("pair?",),
    "fromproperty": ("symbol?",),
    "general-align": ("integer?", "number?", "cheap-markup?"),
    "halign": ("number?", "cheap-markup?"),
    "harp-pedal": ("string?",),
    "hbracket": ("cheap-markup?",),
    "hcenter-in": ("number?", "cheap-markup?"),
    "hspace": ("number?",),
    "huge": ("cheap-markup?",),
    "italic": ("cheap-markup?",),
    "justify-field": ("symbol?",),
    "justify-line": ("markup-list?",),
    "justify": ("markup-list?",),
    "justify-string": ("string?",),
    "large": ("cheap-markup?",),
    "larger": ("cheap-markup?",),
    "left-align": ("cheap-markup?",),
    "left-brace": ("number?",),
    "left-column": ("markup-list?",),
    "line": ("markup-list?",),
    "lookup": ("string?",),
    "lower": ("number?", "cheap-markup?"),
    "magnify": ("number?", "cheap-markup?"),
    "markalphabet": ("integer?",),
    "markletter": ("integer?",),
    "medium": ("cheap-markup?",),
    "musicglyph": ("string?",),
    "natural": (),
    "normal-size-sub": ("cheap-markup?",),
    "normal-size-super": ("cheap-markup?",),
    "normal-text": ("cheap-markup?",),
    "normalsize": ("cheap-markup?",),
    "note-by-number": ("number?", "number?", "number?"),
    "note": ("string?", "number?"),
    "null": (),
    "number": ("cheap-markup?",),
    "on-the-fly": ("procedure?", "cheap-markup?"),
    "oval": ("cheap-markup?",),
    "override": ("pair?", "cheap-markup?"),
    "pad-around": ("number?", "cheap-markup?"),
    "pad": ("number?", "cheap-markup?"),
    "pad-to-box": ("number-pair?", "number-pair?", "cheap-markup?"),
    "pad-x": ("number?", "cheap-markup?"),
    "page-link": ("number?", "cheap-markup?"),
    "page-ref": ("symbol?", "cheap-markup?", "cheap-markup?"),
    "parenthesize": ("cheap-markup?",),
    "path": ("number?", "list?"),
    "pattern": ("integer?", "integer?", "number?", "cheap-markup?"),
    "postscript": ("string?",),
    "property-recursive": ("symbol?",),
    "put-adjacent": ("integer?", "ly:dir?", "cheap-markup?", "cheap-markup?"),
    "raise": ("number?", "cheap-markup?"),
    "replace": ("list?", "cheap-markup?"),
    "rest-by-number": ("number?", "number?"),
    "rest": ("string?",),
    "right-align": ("cheap-markup?",),
    "right-brace": ("number?",),
    "right-column": ("markup-list?",),
    "roman": ("cheap-markup?",),
    "rotate": ("number?", "cheap-markup?"),
    "rounded-box": ("cheap-markup?",),
    "sans": ("cheap-markup?",),
    "scale": ("number-pair?", "cheap-markup?"),
    "score": ("ly:score?",),
    "semiflat": (),
    "semisharp": (),
    "sesquiflat": (),
    "sesquisharp": (),
    "sharp": (),
    "simple": ("string?",),
    "slashed-digit": ("integer?",),
    "small": ("cheap-markup?",),
    "smallCaps": ("cheap-markup?",),
    "smaller": ("cheap-markup?",),
    "stencil": ("ly:stencil?",),
    "strut": (),
    "sub": ("cheap-markup?",),
    "super": ("cheap-markup?",),
    "teeny": ("cheap-markup?",),
    "text": ("cheap-markup?",),
    "tied-lyric": ("string?",),
    "tiny": ("cheap-markup?",),
    "translate": ("number-pair?", "cheap-markup?"),
    "translate-scaled": ("number-pair?", "cheap-markup?"),
    "transparent": ("cheap-markup?",),
    "triangle": ("boolean?",),
    "typewriter": ("cheap-markup?",),
    "underline": ("cheap-markup?",),
    "upright": ("cheap-markup?",),
    "vcenter": ("cheap-markup?",),
    "verbatim-file": ("string?",),
    "vspace": ("number?",),
    "whiteout-box": ("cheap-markup?",),
    "whiteout": ("cheap-markup?",),
    "with-color": ("color?", "cheap-markup?"),
    "with-dimensions": ("number-pair?", "number-pair?", "cheap-markup?"),
    "with-link": ("symbol?", "cheap-markup?"),
    "with-url": ("string?", "cheap-markup?"),
    "woodwind-diagram": ("symbol?", "list?"),
    "wordwrap-field": ("symbol?",),
    "wordwrap": ("markup-list?",),
    "wordwrap-string": ("string?",),
}

markup_list_functions = {
    "column-lines": ("markup-list?",),
    "justified-lines": ("markup-list?",),
    "map-markup-commands": ("procedure?", "markup-list?"),
    "override-lines": ("pair?", "markup-list?"),
    "score-lines": ("ly:score?",),
    "table-of-contents": (),
    "wordwrap-internal": ("boolean?", "markup-list?"),
    "wordwrap-lines": ("markup-list?",),
    "wordwrap-string-internal": ("boolean?", "string?"),
}

lilypond_version = "2.19.84"

music_glyphs = set(
    [
        "accidentals.doublesharp",
        "accidentals.flat",
        "accidentals.flat.arrowboth",
        "accidentals.flat.arrowdown",
        "accidentals.flat.arrowup",
        "accidentals.flat.slash",
        "accidentals.flat.slashslash",
        "accidentals.flatflat",
        "accidentals.flatflat.slash",
        "accidentals.hufnagelM1",
        "accidentals.kievan1",
        "accidentals.kievanM1",
        "accidentals.leftparen",
        "accidentals.medicaeaM1",
        "accidentals.mensural1",
        "accidentals.mensuralM1",
        "accidentals.mirroredflat",
        "accidentals.mirroredflat.backslash",
        "accidentals.mirroredflat.flat",
        "accidentals.natural",
        "accidentals.natural.arrowboth",
        "accidentals.natural.arrowdown",
        "accidentals.natural.arrowup",
        "accidentals.rightparen",
        "accidentals.sharp",
        "accidentals.sharp.arrowboth",
        "accidentals.sharp.arrowdown",
        "accidentals.sharp.arrowup",
        "accidentals.sharp.slashslash.stem",
        "accidentals.sharp.slashslash.stemstemstem",
        "accidentals.sharp.slashslashslash.stem",
        "accidentals.sharp.slashslashslash.stemstem",
        "accidentals.vaticana0",
        "accidentals.vaticanaM1",
        "accordion.bayanbass",
        "accordion.discant",
        "accordion.dot",
        "accordion.freebass",
        "accordion.oldEE",
        "accordion.pull",
        "accordion.push",
        "accordion.stdbass",
        "arrowheads.close.01",
        "arrowheads.close.0M1",
        "arrowheads.close.11",
        "arrowheads.close.1M1",
        "arrowheads.open.01",
        "arrowheads.open.0M1",
        "arrowheads.open.11",
        "arrowheads.open.1M1",
        "brackettips.down",
        "brackettips.up",
        "clefs.C",
        "clefs.C_change",
        "clefs.F",
        "clefs.F_change",
        "clefs.G",
        "clefs.GG",
        "clefs.GG_change",
        "clefs.G_change",
        "clefs.blackmensural.c",
        "clefs.blackmensural.c_change",
        "clefs.hufnagel.do",
        "clefs.hufnagel.do.fa",
        "clefs.hufnagel.do.fa_change",
        "clefs.hufnagel.do_change",
        "clefs.hufnagel.fa",
        "clefs.hufnagel.fa_change",
        "clefs.kievan.do",
        "clefs.kievan.do_change",
        "clefs.medicaea.do",
        "clefs.medicaea.do_change",
        "clefs.medicaea.fa",
        "clefs.medicaea.fa_change",
        "clefs.mensural.c",
        "clefs.mensural.c_change",
        "clefs.mensural.f",
        "clefs.mensural.f_change",
        "clefs.mensural.g",
        "clefs.mensural.g_change",
        "clefs.neomensural.c",
        "clefs.neomensural.c_change",
        "clefs.percussion",
        "clefs.percussion_change",
        "clefs.petrucci.c1",
        "clefs.petrucci.c1_change",
        "clefs.petrucci.c2",
        "clefs.petrucci.c2_change",
        "clefs.petrucci.c3",
        "clefs.petrucci.c3_change",
        "clefs.petrucci.c4",
        "clefs.petrucci.c4_change",
        "clefs.petrucci.c5",
        "clefs.petrucci.c5_change",
        "clefs.petrucci.f",
        "clefs.petrucci.f_change",
        "clefs.petrucci.g",
        "clefs.petrucci.g_change",
        "clefs.tab",
        "clefs.tab_change",
        "clefs.tenorG",
        "clefs.tenorG_change",
        "clefs.varC",
        "clefs.varC_change",
        "clefs.varpercussion",
        "clefs.varpercussion_change",
        "clefs.vaticana.do",
        "clefs.vaticana.do_change",
        "clefs.vaticana.fa",
        "clefs.vaticana.fa_change",
        "comma",
        "custodes.hufnagel.d0",
        "custodes.hufnagel.d1",
        "custodes.hufnagel.d2",
        "custodes.hufnagel.u0",
        "custodes.hufnagel.u1",
        "custodes.hufnagel.u2",
        "custodes.medicaea.d0",
        "custodes.medicaea.d1",
        "custodes.medicaea.d2",
        "custodes.medicaea.u0",
        "custodes.medicaea.u1",
        "custodes.medicaea.u2",
        "custodes.mensural.d0",
        "custodes.mensural.d1",
        "custodes.mensural.d2",
        "custodes.mensural.u0",
        "custodes.mensural.u1",
        "custodes.mensural.u2",
        "custodes.vaticana.d0",
        "custodes.vaticana.d1",
        "custodes.vaticana.d2",
        "custodes.vaticana.u0",
        "custodes.vaticana.u1",
        "custodes.vaticana.u2",
        "dots.dot",
        "dots.dotkievan",
        "dots.dotvaticana",
        "eight",
        "f",
        "five",
        "flags.d3",
        "flags.d4",
        "flags.d5",
        "flags.d6",
        "flags.d7",
        "flags.dgrace",
        "flags.mensurald03",
        "flags.mensurald04",
        "flags.mensurald05",
        "flags.mensurald06",
        "flags.mensurald13",
        "flags.mensurald14",
        "flags.mensurald15",
        "flags.mensurald16",
        "flags.mensurald23",
        "flags.mensurald24",
        "flags.mensurald25",
        "flags.mensurald26",
        "flags.mensuralu03",
        "flags.mensuralu04",
        "flags.mensuralu05",
        "flags.mensuralu06",
        "flags.mensuralu13",
        "flags.mensuralu14",
        "flags.mensuralu15",
        "flags.mensuralu16",
        "flags.mensuralu23",
        "flags.mensuralu24",
        "flags.mensuralu25",
        "flags.mensuralu26",
        "flags.u3",
        "flags.u4",
        "flags.u5",
        "flags.u6",
        "flags.u7",
        "flags.ugrace",
        "four",
        "hyphen",
        "m",
        "nine",
        "noteheads.d0doFunk",
        "noteheads.d0fa",
        "noteheads.d0faFunk",
        "noteheads.d0faThin",
        "noteheads.d0miFunk",
        "noteheads.d0reFunk",
        "noteheads.d0tiFunk",
        "noteheads.d1do",
        "noteheads.d1doFunk",
        "noteheads.d1doThin",
        "noteheads.d1doWalker",
        "noteheads.d1fa",
        "noteheads.d1faFunk",
        "noteheads.d1faThin",
        "noteheads.d1faWalker",
        "noteheads.d1miFunk",
        "noteheads.d1re",
        "noteheads.d1reFunk",
        "noteheads.d1reThin",
        "noteheads.d1reWalker",
        "noteheads.d1ti",
        "noteheads.d1tiFunk",
        "noteheads.d1tiThin",
        "noteheads.d1tiWalker",
        "noteheads.d1triangle",
        "noteheads.d2do",
        "noteheads.d2doFunk",
        "noteheads.d2doThin",
        "noteheads.d2doWalker",
        "noteheads.d2fa",
        "noteheads.d2faFunk",
        "noteheads.d2faThin",
        "noteheads.d2faWalker",
        "noteheads.d2kievan",
        "noteheads.d2re",
        "noteheads.d2reFunk",
        "noteheads.d2reThin",
        "noteheads.d2reWalker",
        "noteheads.d2ti",
        "noteheads.d2tiFunk",
        "noteheads.d2tiThin",
        "noteheads.d2tiWalker",
        "noteheads.d2triangle",
        "noteheads.d3kievan",
        "noteheads.dM2",
        "noteheads.dM2blackmensural",
        "noteheads.dM2mensural",
        "noteheads.dM2neomensural",
        "noteheads.dM2semimensural",
        "noteheads.dM3blackmensural",
        "noteheads.dM3mensural",
        "noteheads.dM3neomensural",
        "noteheads.dM3semimensural",
        "noteheads.drM2mensural",
        "noteheads.drM2neomensural",
        "noteheads.drM2semimensural",
        "noteheads.drM3mensural",
        "noteheads.drM3neomensural",
        "noteheads.drM3semimensural",
        "noteheads.s0",
        "noteheads.s0blackmensural",
        "noteheads.s0blackpetrucci",
        "noteheads.s0cross",
        "noteheads.s0diamond",
        "noteheads.s0do",
        "noteheads.s0doThin",
        "noteheads.s0doWalker",
        "noteheads.s0faWalker",
        "noteheads.s0harmonic",
        "noteheads.s0kievan",
        "noteheads.s0la",
        "noteheads.s0laFunk",
        "noteheads.s0laThin",
        "noteheads.s0laWalker",
        "noteheads.s0mensural",
        "noteheads.s0mi",
        "noteheads.s0miMirror",
        "noteheads.s0miThin",
        "noteheads.s0miWalker",
        "noteheads.s0neomensural",
        "noteheads.s0petrucci",
        "noteheads.s0re",
        "noteheads.s0reThin",
        "noteheads.s0reWalker",
        "noteheads.s0slash",
        "noteheads.s0sol",
        "noteheads.s0solFunk",
        "noteheads.s0ti",
        "noteheads.s0tiThin",
        "noteheads.s0tiWalker",
        "noteheads.s0triangle",
        "noteheads.s1",
        "noteheads.s1blackpetrucci",
        "noteheads.s1cross",
        "noteheads.s1diamond",
        "noteheads.s1kievan",
        "noteheads.s1la",
        "noteheads.s1laFunk",
        "noteheads.s1laThin",
        "noteheads.s1laWalker",
        "noteheads.s1mensural",
        "noteheads.s1mi",
        "noteheads.s1miMirror",
        "noteheads.s1miThin",
        "noteheads.s1miWalker",
        "noteheads.s1neomensural",
        "noteheads.s1petrucci",
        "noteheads.s1slash",
        "noteheads.s1sol",
        "noteheads.s1solFunk",
        "noteheads.s2",
        "noteheads.s2blackpetrucci",
        "noteheads.s2cross",
        "noteheads.s2diamond",
        "noteheads.s2harmonic",
        "noteheads.s2la",
        "noteheads.s2laFunk",
        "noteheads.s2laThin",
        "noteheads.s2laWalker",
        "noteheads.s2mensural",
        "noteheads.s2mi",
        "noteheads.s2miFunk",
        "noteheads.s2miMirror",
        "noteheads.s2miThin",
        "noteheads.s2miWalker",
        "noteheads.s2neomensural",
        "noteheads.s2petrucci",
        "noteheads.s2slash",
        "noteheads.s2sol",
        "noteheads.s2solFunk",
        "noteheads.s2xcircle",
        "noteheads.sM1",
        "noteheads.sM1blackmensural",
        "noteheads.sM1double",
        "noteheads.sM1kievan",
        "noteheads.sM1mensural",
        "noteheads.sM1neomensural",
        "noteheads.sM1semimensural",
        "noteheads.sM2blackligmensural",
        "noteheads.sM2kievan",
        "noteheads.sM2ligmensural",
        "noteheads.sM2semiligmensural",
        "noteheads.sM3blackligmensural",
        "noteheads.sM3ligmensural",
        "noteheads.sM3semiligmensural",
        "noteheads.shufnagel.lpes",
        "noteheads.shufnagel.punctum",
        "noteheads.shufnagel.virga",
        "noteheads.smedicaea.inclinatum",
        "noteheads.smedicaea.punctum",
        "noteheads.smedicaea.rvirga",
        "noteheads.smedicaea.virga",
        "noteheads.sr1kievan",
        "noteheads.srM1mensural",
        "noteheads.srM1neomensural",
        "noteheads.srM1semimensural",
        "noteheads.srM2ligmensural",
        "noteheads.srM2semiligmensural",
        "noteheads.srM3ligmensural",
        "noteheads.srM3semiligmensural",
        "noteheads.ssolesmes.auct.asc",
        "noteheads.ssolesmes.auct.desc",
        "noteheads.ssolesmes.incl.auctum",
        "noteheads.ssolesmes.incl.parvum",
        "noteheads.ssolesmes.oriscus",
        "noteheads.ssolesmes.stropha",
        "noteheads.ssolesmes.stropha.aucta",
        "noteheads.svaticana.cephalicus",
        "noteheads.svaticana.epiphonus",
        "noteheads.svaticana.inclinatum",
        "noteheads.svaticana.inner.cephalicus",
        "noteheads.svaticana.linea.punctum",
        "noteheads.svaticana.linea.punctum.cavum",
        "noteheads.svaticana.lpes",
        "noteheads.svaticana.plica",
        "noteheads.svaticana.punctum",
        "noteheads.svaticana.punctum.cavum",
        "noteheads.svaticana.quilisma",
        "noteheads.svaticana.reverse.plica",
        "noteheads.svaticana.reverse.vplica",
        "noteheads.svaticana.upes",
        "noteheads.svaticana.vepiphonus",
        "noteheads.svaticana.vlpes",
        "noteheads.svaticana.vplica",
        "noteheads.svaticana.vupes",
        "noteheads.u0doFunk",
        "noteheads.u0fa",
        "noteheads.u0faFunk",
        "noteheads.u0faThin",
        "noteheads.u0miFunk",
        "noteheads.u0reFunk",
        "noteheads.u0tiFunk",
        "noteheads.u1do",
        "noteheads.u1doFunk",
        "noteheads.u1doThin",
        "noteheads.u1doWalker",
        "noteheads.u1fa",
        "noteheads.u1faFunk",
        "noteheads.u1faThin",
        "noteheads.u1faWalker",
        "noteheads.u1miFunk",
        "noteheads.u1re",
        "noteheads.u1reFunk",
        "noteheads.u1reThin",
        "noteheads.u1reWalker",
        "noteheads.u1ti",
        "noteheads.u1tiFunk",
        "noteheads.u1tiThin",
        "noteheads.u1tiWalker",
        "noteheads.u1triangle",
        "noteheads.u2do",
        "noteheads.u2doFunk",
        "noteheads.u2doThin",
        "noteheads.u2doWalker",
        "noteheads.u2fa",
        "noteheads.u2faFunk",
        "noteheads.u2faThin",
        "noteheads.u2faWalker",
        "noteheads.u2kievan",
        "noteheads.u2re",
        "noteheads.u2reFunk",
        "noteheads.u2reThin",
        "noteheads.u2reWalker",
        "noteheads.u2ti",
        "noteheads.u2tiFunk",
        "noteheads.u2tiThin",
        "noteheads.u2tiWalker",
        "noteheads.u2triangle",
        "noteheads.u3kievan",
        "noteheads.uM2",
        "noteheads.uM2blackmensural",
        "noteheads.uM2mensural",
        "noteheads.uM2neomensural",
        "noteheads.uM2semimensural",
        "noteheads.uM3blackmensural",
        "noteheads.uM3mensural",
        "noteheads.uM3neomensural",
        "noteheads.uM3semimensural",
        "noteheads.urM2mensural",
        "noteheads.urM2neomensural",
        "noteheads.urM2semimensural",
        "noteheads.urM3mensural",
        "noteheads.urM3neomensural",
        "noteheads.urM3semimensural",
        "one",
        "p",
        "pedal.*",
        "pedal..",
        "pedal.M",
        "pedal.P",
        "pedal.Ped",
        "pedal.d",
        "pedal.e",
        "period",
        "plus",
        "r",
        "rests.0",
        "rests.0mensural",
        "rests.0neomensural",
        "rests.0o",
        "rests.1",
        "rests.1mensural",
        "rests.1neomensural",
        "rests.1o",
        "rests.2",
        "rests.2classical",
        "rests.2mensural",
        "rests.2neomensural",
        "rests.2z",
        "rests.3",
        "rests.3mensural",
        "rests.3neomensural",
        "rests.4",
        "rests.4mensural",
        "rests.4neomensural",
        "rests.5",
        "rests.6",
        "rests.7",
        "rests.M1",
        "rests.M1mensural",
        "rests.M1neomensural",
        "rests.M1o",
        "rests.M2",
        "rests.M2mensural",
        "rests.M2neomensural",
        "rests.M3",
        "rests.M3mensural",
        "rests.M3neomensural",
        "s",
        "scripts.arpeggio",
        "scripts.arpeggio.arrow.1",
        "scripts.arpeggio.arrow.M1",
        "scripts.augmentum",
        "scripts.barline.kievan",
        "scripts.caesura.curved",
        "scripts.caesura.straight",
        "scripts.circulus",
        "scripts.coda",
        "scripts.daccentus",
        "scripts.dfermata",
        "scripts.dlongfermata",
        "scripts.dmarcato",
        "scripts.downbow",
        "scripts.downmordent",
        "scripts.downprall",
        "scripts.dpedalheel",
        "scripts.dpedaltoe",
        "scripts.dportato",
        "scripts.dsemicirculus",
        "scripts.dshortfermata",
        "scripts.dsignumcongruentiae",
        "scripts.dstaccatissimo",
        "scripts.dverylongfermata",
        "scripts.espr",
        "scripts.flageolet",
        "scripts.halfopen",
        "scripts.halfopenvertical",
        "scripts.ictus",
        "scripts.lcomma",
        "scripts.lineprall",
        "scripts.lvarcomma",
        "scripts.mordent",
        "scripts.open",
        "scripts.prall",
        "scripts.pralldown",
        "scripts.prallmordent",
        "scripts.prallprall",
        "scripts.prallup",
        "scripts.rcomma",
        "scripts.reverseturn",
        "scripts.rvarcomma",
        "scripts.segno",
        "scripts.sforzato",
        "scripts.snappizzicato",
        "scripts.staccato",
        "scripts.stopped",
        "scripts.tenuto",
        "scripts.thumb",
        "scripts.tickmark",
        "scripts.trilelement",
        "scripts.trill",
        "scripts.trill_element",
        "scripts.turn",
        "scripts.uaccentus",
        "scripts.ufermata",
        "scripts.ulongfermata",
        "scripts.umarcato",
        "scripts.upbow",
        "scripts.upedalheel",
        "scripts.upedaltoe",
        "scripts.upmordent",
        "scripts.uportato",
        "scripts.upprall",
        "scripts.usemicirculus",
        "scripts.ushortfermata",
        "scripts.usignumcongruentiae",
        "scripts.ustaccatissimo",
        "scripts.uverylongfermata",
        "scripts.varcoda",
        "scripts.varsegno",
        "seven",
        "six",
        "space",
        "three",
        "ties.lyric.default",
        "ties.lyric.short",
        "timesig.C22",
        "timesig.C44",
        "timesig.mensural22",
        "timesig.mensural24",
        "timesig.mensural32",
        "timesig.mensural34",
        "timesig.mensural44",
        "timesig.mensural48",
        "timesig.mensural64",
        "timesig.mensural68",
        "timesig.mensural68alt",
        "timesig.mensural94",
        "timesig.mensural98",
        "timesig.neomensural22",
        "timesig.neomensural24",
        "timesig.neomensural32",
        "timesig.neomensural34",
        "timesig.neomensural44",
        "timesig.neomensural48",
        "timesig.neomensural64",
        "timesig.neomensural68",
        "timesig.neomensural68alt",
        "timesig.neomensural94",
        "timesig.neomensural98",
        "two",
        "z",
        "zero",
    ]
)
