# AUTOGENERATED! DO NOT EDIT! File to edit: metrics.ipynb (unless otherwise specified).

__all__ = ['PCK', 'fraction_of_gt_corrs_consisent_with_F']

# Cell
import numpy as np

def PCK(pts: np.array, gt_pts: np.array, ths = np.arange(20)):
    '''Function to calculate  Probability of Correct Keypoint (PCK) given the error threshold'''
    assert pts.shape[0] == gt_pts.shape[0]
    assert pts.shape[1] == 2
    diff  = np.linalg.norm(pts - gt_pts, ord=2, axis=1)
    out = []
    for th in ths:
        correct = diff <= th
        out.append(correct.astype(np.float32).mean())
    return np.array(out)

# Cell
import kornia.geometry as KG
import torch
def fraction_of_gt_corrs_consisent_with_F(Fm: np.array, gt_corrs: np.array, ths=np.arange(20)):
    assert Fm.shape == (3, 3)
    assert gt_corrs.shape[1] == 4
    pts_torch = torch.from_numpy(gt_corrs)[None]
    F_torch = torch.from_numpy(Fm)[None]
    errors = KG.symmetrical_epipolar_distance(pts_torch[:,:,:2],
                                              pts_torch[:,:,2:],
                                              F_torch, squared=False).detach().cpu().numpy().reshape(-1, 1)
    out = []
    for th in ths:
        correct = errors <= th
        out.append(correct.astype(np.float32).mean())
    return out