# AUTOGENERATED! DO NOT EDIT! File to edit: evaluation.ipynb (unless otherwise specified).

__all__ = ['evaluate_Fs']

# Cell
import numpy as np
from .dataset import *
from .metrics import *

def evaluate_Fs(Fs = [], subset = 'test'):
    dset = WxBSDataset('.WxBS', subset=subset, download=True)
    ths = np.arange(20)
    gt_corrs = []
    names = []
    for data_dict in dset:
        corrs = data_dict['pts']
        pairname = data_dict['name']
        names.append(pairname)
        gt_corrs.append(corrs)
    assert len(Fs) == len(gt_corrs)
    per_pair_results = {}
    all_res = []
    for (F, pts, pairname) in zip(Fs, gt_corrs, names):
        res = fraction_of_gt_corrs_consisent_with_F(F, pts, ths)
        per_pair_results[pairname] = res
        all_res.append(res)
    per_pair_results['average'] = np.stack(all_res, axis=1).mean(axis=1)
    return per_pair_results, ths