# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict


class AddCustomLineRequestIpSegment(TeaModel):
    def __init__(
        self,
        end_ip: str = None,
        start_ip: str = None,
    ):
        # The end IP address of the CIDR block.
        self.end_ip = end_ip
        # The start IP address of the CIDR block.
        self.start_ip = start_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ip is not None:
            result['EndIp'] = self.end_ip
        if self.start_ip is not None:
            result['StartIp'] = self.start_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndIp') is not None:
            self.end_ip = m.get('EndIp')
        if m.get('StartIp') is not None:
            self.start_ip = m.get('StartIp')
        return self


class AddCustomLineRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        ip_segment: List[AddCustomLineRequestIpSegment] = None,
        lang: str = None,
        line_name: str = None,
    ):
        # The domain name for which you configure the custom line.
        self.domain_name = domain_name
        self.ip_segment = ip_segment
        # The language type.
        self.lang = lang
        # The name of the custom line.
        self.line_name = line_name

    def validate(self):
        if self.ip_segment:
            for k in self.ip_segment:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        result['IpSegment'] = []
        if self.ip_segment is not None:
            for k in self.ip_segment:
                result['IpSegment'].append(k.to_map() if k else None)
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.line_name is not None:
            result['LineName'] = self.line_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        self.ip_segment = []
        if m.get('IpSegment') is not None:
            for k in m.get('IpSegment'):
                temp_model = AddCustomLineRequestIpSegment()
                self.ip_segment.append(temp_model.from_map(k))
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        return self


class AddCustomLineResponseBody(TeaModel):
    def __init__(
        self,
        line_code: str = None,
        line_id: int = None,
        request_id: str = None,
    ):
        # The code of the custom line.
        self.line_code = line_code
        # The unique ID of the custom line.
        self.line_id = line_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_id is not None:
            result['LineId'] = self.line_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineId') is not None:
            self.line_id = m.get('LineId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCustomLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCustomLineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCustomLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDnsCacheDomainRequestSourceDnsServer(TeaModel):
    def __init__(
        self,
        host: str = None,
        port: str = None,
    ):
        self.host = host
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class AddDnsCacheDomainRequest(TeaModel):
    def __init__(
        self,
        cache_ttl_max: int = None,
        cache_ttl_min: int = None,
        domain_name: str = None,
        instance_id: str = None,
        lang: str = None,
        remark: str = None,
        source_dns_server: List[AddDnsCacheDomainRequestSourceDnsServer] = None,
        source_edns: str = None,
        source_protocol: str = None,
    ):
        self.cache_ttl_max = cache_ttl_max
        self.cache_ttl_min = cache_ttl_min
        self.domain_name = domain_name
        self.instance_id = instance_id
        self.lang = lang
        self.remark = remark
        self.source_dns_server = source_dns_server
        self.source_edns = source_edns
        self.source_protocol = source_protocol

    def validate(self):
        if self.source_dns_server:
            for k in self.source_dns_server:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cache_ttl_max is not None:
            result['CacheTtlMax'] = self.cache_ttl_max
        if self.cache_ttl_min is not None:
            result['CacheTtlMin'] = self.cache_ttl_min
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.remark is not None:
            result['Remark'] = self.remark
        result['SourceDnsServer'] = []
        if self.source_dns_server is not None:
            for k in self.source_dns_server:
                result['SourceDnsServer'].append(k.to_map() if k else None)
        if self.source_edns is not None:
            result['SourceEdns'] = self.source_edns
        if self.source_protocol is not None:
            result['SourceProtocol'] = self.source_protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CacheTtlMax') is not None:
            self.cache_ttl_max = m.get('CacheTtlMax')
        if m.get('CacheTtlMin') is not None:
            self.cache_ttl_min = m.get('CacheTtlMin')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        self.source_dns_server = []
        if m.get('SourceDnsServer') is not None:
            for k in m.get('SourceDnsServer'):
                temp_model = AddDnsCacheDomainRequestSourceDnsServer()
                self.source_dns_server.append(temp_model.from_map(k))
        if m.get('SourceEdns') is not None:
            self.source_edns = m.get('SourceEdns')
        if m.get('SourceProtocol') is not None:
            self.source_protocol = m.get('SourceProtocol')
        return self


class AddDnsCacheDomainResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDnsCacheDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDnsCacheDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDnsCacheDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDnsGtmAccessStrategyRequestDefaultAddrPool(TeaModel):
    def __init__(
        self,
        id: str = None,
        lba_weight: int = None,
    ):
        # The ID of the address pool in the primary address pool group.
        self.id = id
        # The weight of the address pool in the primary address pool group.
        self.lba_weight = lba_weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.lba_weight is not None:
            result['LbaWeight'] = self.lba_weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LbaWeight') is not None:
            self.lba_weight = m.get('LbaWeight')
        return self


class AddDnsGtmAccessStrategyRequestFailoverAddrPool(TeaModel):
    def __init__(
        self,
        id: str = None,
        lba_weight: int = None,
    ):
        # The ID of the address pool in the secondary address pool group.
        self.id = id
        # The weight of the address pool in the secondary address pool group.
        self.lba_weight = lba_weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.lba_weight is not None:
            result['LbaWeight'] = self.lba_weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LbaWeight') is not None:
            self.lba_weight = m.get('LbaWeight')
        return self


class AddDnsGtmAccessStrategyRequest(TeaModel):
    def __init__(
        self,
        default_addr_pool: List[AddDnsGtmAccessStrategyRequestDefaultAddrPool] = None,
        default_addr_pool_type: str = None,
        default_latency_optimization: str = None,
        default_lba_strategy: str = None,
        default_max_return_addr_num: int = None,
        default_min_available_addr_num: int = None,
        failover_addr_pool: List[AddDnsGtmAccessStrategyRequestFailoverAddrPool] = None,
        failover_addr_pool_type: str = None,
        failover_latency_optimization: str = None,
        failover_lba_strategy: str = None,
        failover_max_return_addr_num: int = None,
        failover_min_available_addr_num: int = None,
        instance_id: str = None,
        lang: str = None,
        lines: str = None,
        strategy_mode: str = None,
        strategy_name: str = None,
    ):
        self.default_addr_pool = default_addr_pool
        # The type of the primary address pool. Valid values:
        # 
        # *   IPV4
        # *   IPV6
        # *   DOMAIN
        self.default_addr_pool_type = default_addr_pool_type
        # Specifies whether to enable scheduling optimization for latency resolution for the primary address pool group. Valid values:
        # 
        # *   OPEN: enable
        # *   CLOSE: disable
        self.default_latency_optimization = default_latency_optimization
        # The load balancing policy of the primary address pool group. Valid values:
        # 
        # *   ALL_RR: returns all addresses.
        # *   RATIO: returns addresses by weight.
        self.default_lba_strategy = default_lba_strategy
        # The maximum number of addresses returned from the primary address pool group.
        self.default_max_return_addr_num = default_max_return_addr_num
        # The minimum number of available addresses in the primary address pool group.
        self.default_min_available_addr_num = default_min_available_addr_num
        self.failover_addr_pool = failover_addr_pool
        # The type of the secondary address pool. Valid values:
        # 
        # *   IPV4
        # *   IPV6
        # *   DOMAIN
        self.failover_addr_pool_type = failover_addr_pool_type
        # Specifies whether to enable scheduling optimization for latency resolution for the secondary address pool group. Valid values:
        # 
        # *   OPEN: enable
        # *   CLOSE: disable
        self.failover_latency_optimization = failover_latency_optimization
        # The load balancing policy of the secondary address pool group. Valid values:
        # 
        # *   ALL_RR: returns all addresses.
        # *   RATIO: returns addresses by weight.
        self.failover_lba_strategy = failover_lba_strategy
        # The maximum number of addresses returned from the secondary address pool group.
        self.failover_max_return_addr_num = failover_max_return_addr_num
        # The minimum number of available addresses in the secondary address pool group.
        self.failover_min_available_addr_num = failover_min_available_addr_num
        # The ID of the instance.
        self.instance_id = instance_id
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The line codes of source regions. For example: `["default", "drpeng"]` indicates Global and Dr. Peng Telecom & Media Group.
        self.lines = lines
        # The type of the access policy. Valid values:
        # 
        # *   GEO: geographical location-based
        # *   LATENCY: latency-based
        self.strategy_mode = strategy_mode
        # The name of the access policy.
        self.strategy_name = strategy_name

    def validate(self):
        if self.default_addr_pool:
            for k in self.default_addr_pool:
                if k:
                    k.validate()
        if self.failover_addr_pool:
            for k in self.failover_addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DefaultAddrPool'] = []
        if self.default_addr_pool is not None:
            for k in self.default_addr_pool:
                result['DefaultAddrPool'].append(k.to_map() if k else None)
        if self.default_addr_pool_type is not None:
            result['DefaultAddrPoolType'] = self.default_addr_pool_type
        if self.default_latency_optimization is not None:
            result['DefaultLatencyOptimization'] = self.default_latency_optimization
        if self.default_lba_strategy is not None:
            result['DefaultLbaStrategy'] = self.default_lba_strategy
        if self.default_max_return_addr_num is not None:
            result['DefaultMaxReturnAddrNum'] = self.default_max_return_addr_num
        if self.default_min_available_addr_num is not None:
            result['DefaultMinAvailableAddrNum'] = self.default_min_available_addr_num
        result['FailoverAddrPool'] = []
        if self.failover_addr_pool is not None:
            for k in self.failover_addr_pool:
                result['FailoverAddrPool'].append(k.to_map() if k else None)
        if self.failover_addr_pool_type is not None:
            result['FailoverAddrPoolType'] = self.failover_addr_pool_type
        if self.failover_latency_optimization is not None:
            result['FailoverLatencyOptimization'] = self.failover_latency_optimization
        if self.failover_lba_strategy is not None:
            result['FailoverLbaStrategy'] = self.failover_lba_strategy
        if self.failover_max_return_addr_num is not None:
            result['FailoverMaxReturnAddrNum'] = self.failover_max_return_addr_num
        if self.failover_min_available_addr_num is not None:
            result['FailoverMinAvailableAddrNum'] = self.failover_min_available_addr_num
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.lines is not None:
            result['Lines'] = self.lines
        if self.strategy_mode is not None:
            result['StrategyMode'] = self.strategy_mode
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.default_addr_pool = []
        if m.get('DefaultAddrPool') is not None:
            for k in m.get('DefaultAddrPool'):
                temp_model = AddDnsGtmAccessStrategyRequestDefaultAddrPool()
                self.default_addr_pool.append(temp_model.from_map(k))
        if m.get('DefaultAddrPoolType') is not None:
            self.default_addr_pool_type = m.get('DefaultAddrPoolType')
        if m.get('DefaultLatencyOptimization') is not None:
            self.default_latency_optimization = m.get('DefaultLatencyOptimization')
        if m.get('DefaultLbaStrategy') is not None:
            self.default_lba_strategy = m.get('DefaultLbaStrategy')
        if m.get('DefaultMaxReturnAddrNum') is not None:
            self.default_max_return_addr_num = m.get('DefaultMaxReturnAddrNum')
        if m.get('DefaultMinAvailableAddrNum') is not None:
            self.default_min_available_addr_num = m.get('DefaultMinAvailableAddrNum')
        self.failover_addr_pool = []
        if m.get('FailoverAddrPool') is not None:
            for k in m.get('FailoverAddrPool'):
                temp_model = AddDnsGtmAccessStrategyRequestFailoverAddrPool()
                self.failover_addr_pool.append(temp_model.from_map(k))
        if m.get('FailoverAddrPoolType') is not None:
            self.failover_addr_pool_type = m.get('FailoverAddrPoolType')
        if m.get('FailoverLatencyOptimization') is not None:
            self.failover_latency_optimization = m.get('FailoverLatencyOptimization')
        if m.get('FailoverLbaStrategy') is not None:
            self.failover_lba_strategy = m.get('FailoverLbaStrategy')
        if m.get('FailoverMaxReturnAddrNum') is not None:
            self.failover_max_return_addr_num = m.get('FailoverMaxReturnAddrNum')
        if m.get('FailoverMinAvailableAddrNum') is not None:
            self.failover_min_available_addr_num = m.get('FailoverMinAvailableAddrNum')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Lines') is not None:
            self.lines = m.get('Lines')
        if m.get('StrategyMode') is not None:
            self.strategy_mode = m.get('StrategyMode')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        return self


class AddDnsGtmAccessStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        strategy_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the access policy.
        self.strategy_id = strategy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        return self


class AddDnsGtmAccessStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDnsGtmAccessStrategyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDnsGtmAccessStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDnsGtmAddressPoolRequestAddr(TeaModel):
    def __init__(
        self,
        addr: str = None,
        attribute_info: str = None,
        lba_weight: int = None,
        mode: str = None,
        remark: str = None,
    ):
        # The address.
        self.addr = addr
        # The source region of the address. The value is a JSON string.
        # 
        # *   lineCode: the line code of the source region of the address.
        # 
        # *   lineCodeRectifyType: the rectification type of the line code. Default value: AUTO. Valid values:
        # 
        #     *   NO_NEED: no need for rectification
        #     *   RECTIFIED: rectified
        #     *   AUTO: automatic rectification
        self.attribute_info = attribute_info
        # The weight of the address.
        self.lba_weight = lba_weight
        # The mode of the address. Valid values:
        # 
        # *   SMART: smart return
        # *   ONLINE: always online
        # *   OFFLINE: always offline
        self.mode = mode
        # The description of the address.
        self.remark = remark

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr is not None:
            result['Addr'] = self.addr
        if self.attribute_info is not None:
            result['AttributeInfo'] = self.attribute_info
        if self.lba_weight is not None:
            result['LbaWeight'] = self.lba_weight
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.remark is not None:
            result['Remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addr') is not None:
            self.addr = m.get('Addr')
        if m.get('AttributeInfo') is not None:
            self.attribute_info = m.get('AttributeInfo')
        if m.get('LbaWeight') is not None:
            self.lba_weight = m.get('LbaWeight')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        return self


class AddDnsGtmAddressPoolRequestIspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        isp_code: str = None,
    ):
        # The code of the city where the monitored node is deployed.
        self.city_code = city_code
        # The code of the Internet service provider (ISP) to which the monitored node belongs.
        self.isp_code = isp_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        return self


class AddDnsGtmAddressPoolRequest(TeaModel):
    def __init__(
        self,
        addr: List[AddDnsGtmAddressPoolRequestAddr] = None,
        evaluation_count: int = None,
        instance_id: str = None,
        interval: int = None,
        isp_city_node: List[AddDnsGtmAddressPoolRequestIspCityNode] = None,
        lang: str = None,
        lba_strategy: str = None,
        monitor_extend_info: str = None,
        monitor_status: str = None,
        name: str = None,
        protocol_type: str = None,
        timeout: int = None,
        type: str = None,
    ):
        # The addresses in the address pool.
        self.addr = addr
        # The maximum number of consecutive exceptions detected. If the number of consecutive exceptions detected reaches the maximum number, the application service is deemed abnormal.
        self.evaluation_count = evaluation_count
        # The ID of the GTM instance for which you want to create an address pool.
        self.instance_id = instance_id
        # The health check interval. Unit: seconds.
        self.interval = interval
        # The monitored nodes.
        self.isp_city_node = isp_city_node
        # The language of the values of specific response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The load balancing policy for the address pool. Valid values:
        # 
        # *   ALL_RR: returns all addresses.
        # *   RATIO: returns addresses by weight.
        self.lba_strategy = lba_strategy
        # The extended information, that is, the parameters required for the protocol. Different protocols require different parameters:
        # 
        # *   HTTP or HTTPS:
        # 
        #     *   port: the port to check.
        # 
        #     *   host: the host configuration.
        # 
        #     *   path: the health check URL.
        # 
        #     *   code: the status code threshold. If the returned status code is greater than the specified threshold, the application service is deemed abnormal.
        # 
        #     *   failureRate: the failure rate.
        # 
        #     *   sni: specifies whether to enable Server Name Indication (SNI). This parameter is only required for the HTTPS protocol. Valid values:
        # 
        #         *   true: enables SNI.
        #         *   Other value: disables SNI.
        # 
        #     *   nodeType: the type of the monitored node when the address pool type is DOMAIN. Valid values:
        # 
        #         *   IPV4
        #         *   IPV6
        # 
        # *   PING:
        # 
        #     *   failureRate: the failure rate.
        # 
        #     *   packetNum: the number of ping packets.
        # 
        #     *   packetLossRate: the loss rate of ping packets.
        # 
        #     *   nodeType: the type of the monitored node when the address pool type is DOMAIN. Valid values:
        # 
        #         *   IPV4
        #         *   IPV6
        # 
        # *   TCP:
        # 
        #     *   port: the port to check.
        # 
        #     *   failureRate: the failure rate.
        # 
        #     *   nodeType: the type of the monitored node when the address pool type is DOMAIN. Valid values:
        # 
        #         *   IPV4
        #         *   IPV6
        self.monitor_extend_info = monitor_extend_info
        # Specifies whether to enable the health check. If this parameter is set to OPEN, the system validates the health check configuration. If this parameter is set to CLOSE, the health check configuration is discarded. Default value: CLOSE. Valid values:
        # 
        # *   OPEN: enables the health check.
        # *   CLOSE: disables the health check.
        self.monitor_status = monitor_status
        # The name of the address pool that you want to create.
        self.name = name
        # The protocol used for the health check. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        # *   PING
        # *   TCP
        self.protocol_type = protocol_type
        # The health check timeout period. Unit: milliseconds.
        self.timeout = timeout
        # The type of the address pool. Valid values:
        # 
        # *   IPV4: IPv4 address
        # *   IPV6: IPv6 address
        # *   DOMAIN: domain name
        self.type = type

    def validate(self):
        if self.addr:
            for k in self.addr:
                if k:
                    k.validate()
        if self.isp_city_node:
            for k in self.isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Addr'] = []
        if self.addr is not None:
            for k in self.addr:
                result['Addr'].append(k.to_map() if k else None)
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interval is not None:
            result['Interval'] = self.interval
        result['IspCityNode'] = []
        if self.isp_city_node is not None:
            for k in self.isp_city_node:
                result['IspCityNode'].append(k.to_map() if k else None)
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.lba_strategy is not None:
            result['LbaStrategy'] = self.lba_strategy
        if self.monitor_extend_info is not None:
            result['MonitorExtendInfo'] = self.monitor_extend_info
        if self.monitor_status is not None:
            result['MonitorStatus'] = self.monitor_status
        if self.name is not None:
            result['Name'] = self.name
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.addr = []
        if m.get('Addr') is not None:
            for k in m.get('Addr'):
                temp_model = AddDnsGtmAddressPoolRequestAddr()
                self.addr.append(temp_model.from_map(k))
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        self.isp_city_node = []
        if m.get('IspCityNode') is not None:
            for k in m.get('IspCityNode'):
                temp_model = AddDnsGtmAddressPoolRequestIspCityNode()
                self.isp_city_node.append(temp_model.from_map(k))
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('LbaStrategy') is not None:
            self.lba_strategy = m.get('LbaStrategy')
        if m.get('MonitorExtendInfo') is not None:
            self.monitor_extend_info = m.get('MonitorExtendInfo')
        if m.get('MonitorStatus') is not None:
            self.monitor_status = m.get('MonitorStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddDnsGtmAddressPoolResponseBody(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        monitor_config_id: str = None,
        request_id: str = None,
    ):
        # The ID of the address pool created.
        self.addr_pool_id = addr_pool_id
        # The ID of the health check configuration.
        self.monitor_config_id = monitor_config_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDnsGtmAddressPoolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDnsGtmAddressPoolResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDnsGtmAddressPoolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDnsGtmMonitorRequestIspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        isp_code: str = None,
    ):
        # The code of the city where the monitored node is deployed.
        self.city_code = city_code
        # The code of the Internet service provider (ISP) to which the monitored node belongs.
        self.isp_code = isp_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        return self


class AddDnsGtmMonitorRequest(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        evaluation_count: int = None,
        interval: int = None,
        isp_city_node: List[AddDnsGtmMonitorRequestIspCityNode] = None,
        lang: str = None,
        monitor_extend_info: str = None,
        protocol_type: str = None,
        timeout: int = None,
    ):
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The maximum number of consecutive exceptions detected. If the number of consecutive exceptions detected reaches the maximum number, the application service is deemed abnormal.
        self.evaluation_count = evaluation_count
        # The health check interval. Unit: seconds.
        self.interval = interval
        # The monitored nodes.
        self.isp_city_node = isp_city_node
        # The language of the values of specific response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The extended information, that is, the parameters required for the protocol. Different protocols require different parameters:
        # 
        # *   HTTP or HTTPS:
        # 
        #     *   port: the port to check.
        # 
        #     *   host: the host configuration.
        # 
        #     *   path: the health check URL.
        # 
        #     *   code: the status code threshold. If the returned status code is greater than the specified threshold, the application service is deemed abnormal.
        # 
        #     *   failureRate: the failure rate.
        # 
        #     *   sni: specifies whether to enable Server Name Indication (SNI). This parameter is only required for the HTTPS protocol. Valid values:
        # 
        #         *   true: enables SNI.
        #         *   false: disables SNI.
        # 
        #     *   nodeType: the type of the monitored node when the address pool type is DOMAIN. Valid values:
        # 
        #         *   IPV4
        #         *   IPV6
        # 
        # *   PING:
        # 
        #     *   failureRate: the failure rate.
        # 
        #     *   packetNum: the number of ping packets.
        # 
        #     *   packetLossRate: the loss rate of ping packets.
        # 
        #     *   nodeType: the type of the monitored node when the address pool type is DOMAIN. Valid values:
        # 
        #         *   IPV4
        #         *   IPV6
        # 
        # *   TCP:
        # 
        #     *   port: the port to check.
        # 
        #     *   failureRate: the failure rate.
        # 
        #     *   nodeType: the type of the monitored node when the address pool type is DOMAIN. Valid values:
        # 
        #         *   IPV4
        #         *   IPV6
        self.monitor_extend_info = monitor_extend_info
        # The protocol used for the health check. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        # *   PING
        # *   TCP
        self.protocol_type = protocol_type
        # The health check timeout period. Unit: milliseconds.
        self.timeout = timeout

    def validate(self):
        if self.isp_city_node:
            for k in self.isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.interval is not None:
            result['Interval'] = self.interval
        result['IspCityNode'] = []
        if self.isp_city_node is not None:
            for k in self.isp_city_node:
                result['IspCityNode'].append(k.to_map() if k else None)
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.monitor_extend_info is not None:
            result['MonitorExtendInfo'] = self.monitor_extend_info
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        self.isp_city_node = []
        if m.get('IspCityNode') is not None:
            for k in m.get('IspCityNode'):
                temp_model = AddDnsGtmMonitorRequestIspCityNode()
                self.isp_city_node.append(temp_model.from_map(k))
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MonitorExtendInfo') is not None:
            self.monitor_extend_info = m.get('MonitorExtendInfo')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        return self


class AddDnsGtmMonitorResponseBody(TeaModel):
    def __init__(
        self,
        monitor_config_id: str = None,
        request_id: str = None,
    ):
        # The ID of the health check configuration.
        self.monitor_config_id = monitor_config_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDnsGtmMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDnsGtmMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDnsGtmMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDomainRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        group_id: str = None,
        lang: str = None,
        resource_group_id: str = None,
    ):
        # The domain name to be added.
        self.domain_name = domain_name
        # The ID of the domain name group. The default value is the ID of the default domain name group.
        self.group_id = group_id
        # The language of the domain name.
        self.lang = lang
        # The ID of the resource group.
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class AddDomainResponseBodyDnsServers(TeaModel):
    def __init__(
        self,
        dns_server: List[str] = None,
    ):
        self.dns_server = dns_server

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_server is not None:
            result['DnsServer'] = self.dns_server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsServer') is not None:
            self.dns_server = m.get('DnsServer')
        return self


class AddDomainResponseBody(TeaModel):
    def __init__(
        self,
        dns_servers: AddDomainResponseBodyDnsServers = None,
        domain_id: str = None,
        domain_name: str = None,
        group_id: str = None,
        group_name: str = None,
        puny_code: str = None,
        request_id: str = None,
    ):
        # The Domain Name System (DNS) servers that resolve the domain name.
        self.dns_servers = dns_servers
        # The ID of the domain name.
        self.domain_id = domain_id
        # The domain name.
        self.domain_name = domain_name
        # The ID of the domain name group.
        self.group_id = group_id
        # The name of the domain name group.
        self.group_name = group_name
        # The Punycode for the domain name. This parameter is returned only for Chinese domain names.
        self.puny_code = puny_code
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.dns_servers:
            self.dns_servers.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_servers is not None:
            result['DnsServers'] = self.dns_servers.to_map()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.puny_code is not None:
            result['PunyCode'] = self.puny_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsServers') is not None:
            temp_model = AddDomainResponseBodyDnsServers()
            self.dns_servers = temp_model.from_map(m['DnsServers'])
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('PunyCode') is not None:
            self.puny_code = m.get('PunyCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDomainBackupRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        period_type: str = None,
    ):
        # The domain name for which you want to create a backup task.
        self.domain_name = domain_name
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
        self.lang = lang
        # The backup cycle. Valid values:
        # 
        # *   **DAY**: Backs up data once every day.
        # *   **HOUR**: Backs up data once every hour.
        self.period_type = period_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.period_type is not None:
            result['PeriodType'] = self.period_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PeriodType') is not None:
            self.period_type = m.get('PeriodType')
        return self


class AddDomainBackupResponseBody(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        period_type: str = None,
        request_id: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The backup cycle.
        self.period_type = period_type
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.period_type is not None:
            result['PeriodType'] = self.period_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('PeriodType') is not None:
            self.period_type = m.get('PeriodType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDomainBackupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDomainBackupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDomainBackupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDomainGroupRequest(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        lang: str = None,
    ):
        # The name of the domain name group.
        self.group_name = group_name
        # The language type.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class AddDomainGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        request_id: str = None,
    ):
        # The ID of the domain name group.
        self.group_id = group_id
        # The name of the domain name group.
        self.group_name = group_name
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDomainGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDomainGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDomainGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddDomainRecordRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        line: str = None,
        priority: int = None,
        rr: str = None,
        ttl: int = None,
        type: str = None,
        user_client_ip: str = None,
        value: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language type.
        self.lang = lang
        # The resolution line. Default value: **default**.
        self.line = line
        # The priority of an MX-type DNS record. Valid values: `[1,50]`.
        # 
        # This parameter must be specified if the type of the DNS record is MX. A smaller value indicates a higher priority.
        self.priority = priority
        # The host record.
        # 
        # For example, to resolve @.example.com, you must set RR to an at sign (@) instead of leaving it blank.
        self.rr = rr
        # The TTL of the resolution. Default value: 600. Unit: seconds.
        self.ttl = ttl
        # The type of the DNS record. DNS record types
        # 
        # [dns records types](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/dns-record-types)
        self.type = type
        # The IP address of the client.
        self.user_client_ip = user_client_ip
        # The value of the DNS record.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.line is not None:
            result['Line'] = self.line
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.rr is not None:
            result['RR'] = self.rr
        if self.ttl is not None:
            result['TTL'] = self.ttl
        if self.type is not None:
            result['Type'] = self.type
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RR') is not None:
            self.rr = m.get('RR')
        if m.get('TTL') is not None:
            self.ttl = m.get('TTL')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddDomainRecordResponseBody(TeaModel):
    def __init__(
        self,
        record_id: str = None,
        request_id: str = None,
    ):
        # The ID of the DNS record.
        self.record_id = record_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddDomainRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddDomainRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddDomainRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGtmAccessStrategyRequest(TeaModel):
    def __init__(
        self,
        access_lines: str = None,
        default_addr_pool_id: str = None,
        failover_addr_pool_id: str = None,
        instance_id: str = None,
        lang: str = None,
        strategy_name: str = None,
    ):
        # The line codes of access regions.
        self.access_lines = access_lines
        # The ID of the default address pool.
        self.default_addr_pool_id = default_addr_pool_id
        # The ID of the failover address pool.
        # 
        # If the failover address pool is not set, pass the **Empty** value.
        self.failover_addr_pool_id = failover_addr_pool_id
        # The ID of the GTM instance for which you want to create an access policy.
        self.instance_id = instance_id
        # The language used by the user.
        self.lang = lang
        # The name of the access policy.
        self.strategy_name = strategy_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_lines is not None:
            result['AccessLines'] = self.access_lines
        if self.default_addr_pool_id is not None:
            result['DefaultAddrPoolId'] = self.default_addr_pool_id
        if self.failover_addr_pool_id is not None:
            result['FailoverAddrPoolId'] = self.failover_addr_pool_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessLines') is not None:
            self.access_lines = m.get('AccessLines')
        if m.get('DefaultAddrPoolId') is not None:
            self.default_addr_pool_id = m.get('DefaultAddrPoolId')
        if m.get('FailoverAddrPoolId') is not None:
            self.failover_addr_pool_id = m.get('FailoverAddrPoolId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        return self


class AddGtmAccessStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        strategy_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the access policy created.
        self.strategy_id = strategy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        return self


class AddGtmAccessStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddGtmAccessStrategyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGtmAccessStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGtmAddressPoolRequestAddr(TeaModel):
    def __init__(
        self,
        lba_weight: int = None,
        mode: str = None,
        value: str = None,
    ):
        # The weight of the address.
        self.lba_weight = lba_weight
        # The mode of the address. Valid values:
        # 
        # *   **SMART**: smart return
        # *   **ONLINE**: always online
        # *   **OFFLINE**: always offline
        self.mode = mode
        # The address.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lba_weight is not None:
            result['LbaWeight'] = self.lba_weight
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LbaWeight') is not None:
            self.lba_weight = m.get('LbaWeight')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AddGtmAddressPoolRequestIspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        isp_code: str = None,
    ):
        # The code of the city where the monitored node is deployed. For more information about specific values, see the response parameters of DescribeGtmMonitorAvailableConfig.
        self.city_code = city_code
        # *   The code of the Internet service provider (ISP) to which the monitored node belongs. For more information about specific values, see the response parameters of DescribeGtmMonitorAvailableConfig.
        # *   If the value of the GroupType parameter is BGP or OVERSEAS, IspCode is optional. The default value is 465.
        # *   If the value of the GroupType parameter is not BGP or OVERSEAS, IspCode is required and is used together with CityCode.
        self.isp_code = isp_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        return self


class AddGtmAddressPoolRequest(TeaModel):
    def __init__(
        self,
        addr: List[AddGtmAddressPoolRequestAddr] = None,
        evaluation_count: int = None,
        instance_id: str = None,
        interval: int = None,
        isp_city_node: List[AddGtmAddressPoolRequestIspCityNode] = None,
        lang: str = None,
        min_available_addr_num: int = None,
        monitor_extend_info: str = None,
        monitor_status: str = None,
        name: str = None,
        protocol_type: str = None,
        timeout: int = None,
        type: str = None,
    ):
        # The addresses in the address pool.
        self.addr = addr
        # The maximum number of consecutive exceptions detected. If the number of consecutive exceptions detected reaches the maximum number, the application service is deemed abnormal.
        self.evaluation_count = evaluation_count
        # The ID of the GTM instance for which you want to create an address pool.
        self.instance_id = instance_id
        # The health check interval. Unit: seconds. Set the value to 60.
        self.interval = interval
        # The monitored nodes.
        self.isp_city_node = isp_city_node
        # The language of the values of specific response parameters.
        self.lang = lang
        # The minimum number of available addresses in the address pool.
        self.min_available_addr_num = min_available_addr_num
        # The extended information, that is, the parameters required for the protocol. Different protocols require different parameters:
        # 
        # HTTP or HTTPS:
        # 
        # *   port: the port to check.
        # *   failureRate: the failure rate.
        # *   code: the status code threshold. If the returned status code is greater than the specified threshold, the application service is deemed abnormal. Valid values: 400 and 500.
        # *   host: the host configuration.
        # *   path: the health check URL.
        # 
        # PING:
        # 
        # *   packetNum: the number of ping packets.
        # *   packetLossRate: the loss rate of ping packets.
        # *   failureRate: the failure rate.
        # 
        # TCP:
        # 
        # *   port: the port to check.
        # *   failureRate: the failure rate.
        self.monitor_extend_info = monitor_extend_info
        # Specifies whether to enable the health check. Valid values:
        # 
        # *   **OPEN**: enables the health check.
        # *   **CLOSE**: disables the health check. This is the default value.
        self.monitor_status = monitor_status
        # The name of the address pool that you want to create.
        self.name = name
        # The protocol used for the health check. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        # *   PING
        # *   TCP
        self.protocol_type = protocol_type
        # The health check timeout period. Unit: milliseconds. Valid values: 2000, 3000, 5000, and 10000.
        self.timeout = timeout
        # The type of the address pool. Valid values:
        # 
        # *   **IP**: IPv4 address
        # *   **DOMAIN**: domain name
        self.type = type

    def validate(self):
        if self.addr:
            for k in self.addr:
                if k:
                    k.validate()
        if self.isp_city_node:
            for k in self.isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Addr'] = []
        if self.addr is not None:
            for k in self.addr:
                result['Addr'].append(k.to_map() if k else None)
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.interval is not None:
            result['Interval'] = self.interval
        result['IspCityNode'] = []
        if self.isp_city_node is not None:
            for k in self.isp_city_node:
                result['IspCityNode'].append(k.to_map() if k else None)
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.min_available_addr_num is not None:
            result['MinAvailableAddrNum'] = self.min_available_addr_num
        if self.monitor_extend_info is not None:
            result['MonitorExtendInfo'] = self.monitor_extend_info
        if self.monitor_status is not None:
            result['MonitorStatus'] = self.monitor_status
        if self.name is not None:
            result['Name'] = self.name
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.addr = []
        if m.get('Addr') is not None:
            for k in m.get('Addr'):
                temp_model = AddGtmAddressPoolRequestAddr()
                self.addr.append(temp_model.from_map(k))
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        self.isp_city_node = []
        if m.get('IspCityNode') is not None:
            for k in m.get('IspCityNode'):
                temp_model = AddGtmAddressPoolRequestIspCityNode()
                self.isp_city_node.append(temp_model.from_map(k))
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MinAvailableAddrNum') is not None:
            self.min_available_addr_num = m.get('MinAvailableAddrNum')
        if m.get('MonitorExtendInfo') is not None:
            self.monitor_extend_info = m.get('MonitorExtendInfo')
        if m.get('MonitorStatus') is not None:
            self.monitor_status = m.get('MonitorStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddGtmAddressPoolResponseBody(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        monitor_config_id: str = None,
        request_id: str = None,
    ):
        # The ID of the address pool created.
        self.addr_pool_id = addr_pool_id
        # The ID of the health check configuration.
        self.monitor_config_id = monitor_config_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddGtmAddressPoolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddGtmAddressPoolResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGtmAddressPoolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGtmMonitorRequestIspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        isp_code: str = None,
    ):
        # The code of the city where the monitored node is deployed.
        # 
        # For more information about specific values, see the response parameters of DescribeGtmMonitorAvailableConfig.
        self.city_code = city_code
        # The code of the Internet service provider (ISP) to which the monitored node belongs. For more information about specific values, see the response parameters of DescribeGtmMonitorAvailableConfig.
        # 
        # *   If the value of the GroupType parameter is BGP or OVERSEAS, IspCode is optional. The default value is 465.
        # *   If the value of the GroupType parameter is not BGP or OVERSEAS, IspCode is required and is used together with CityCode.
        self.isp_code = isp_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        return self


class AddGtmMonitorRequest(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        evaluation_count: int = None,
        interval: int = None,
        isp_city_node: List[AddGtmMonitorRequestIspCityNode] = None,
        lang: str = None,
        monitor_extend_info: str = None,
        protocol_type: str = None,
        timeout: int = None,
    ):
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The maximum number of consecutive exceptions detected. If the number of consecutive exceptions detected reaches the maximum number, the application service is deemed abnormal.
        self.evaluation_count = evaluation_count
        # The health check interval. Unit: seconds. Set the value to 60.
        self.interval = interval
        # The monitored nodes.
        self.isp_city_node = isp_city_node
        # The language of the values of specific response parameters.
        self.lang = lang
        # The extended information, that is, the parameters required for the protocol. Different protocols require different parameters:
        # 
        # HTTP or HTTPS:
        # 
        # *   port: the port to check.
        # *   failureRate: the failure rate.
        # *   code: the status code threshold. If the returned status code is greater than the specified threshold, the application service is deemed abnormal. Valid values: 400 and 500.
        # *   host: the host configuration.
        # *   path: the health check URL.
        # 
        # PING:
        # 
        # *   packetNum: the number of ping packets.
        # *   packetLossRate: the loss rate of ping packets.
        # *   failureRate: the failure rate.
        # 
        # TCP:
        # 
        # *   port: the port to check.
        # *   failureRate: the failure rate.
        self.monitor_extend_info = monitor_extend_info
        # The protocol used for the health check. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        # *   PING
        # *   TCP
        self.protocol_type = protocol_type
        # The health check timeout period. Unit: milliseconds. Valid values: 2000, 3000, 5000, and 10000.
        self.timeout = timeout

    def validate(self):
        if self.isp_city_node:
            for k in self.isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.interval is not None:
            result['Interval'] = self.interval
        result['IspCityNode'] = []
        if self.isp_city_node is not None:
            for k in self.isp_city_node:
                result['IspCityNode'].append(k.to_map() if k else None)
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.monitor_extend_info is not None:
            result['MonitorExtendInfo'] = self.monitor_extend_info
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        self.isp_city_node = []
        if m.get('IspCityNode') is not None:
            for k in m.get('IspCityNode'):
                temp_model = AddGtmMonitorRequestIspCityNode()
                self.isp_city_node.append(temp_model.from_map(k))
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MonitorExtendInfo') is not None:
            self.monitor_extend_info = m.get('MonitorExtendInfo')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        return self


class AddGtmMonitorResponseBody(TeaModel):
    def __init__(
        self,
        monitor_config_id: str = None,
        request_id: str = None,
    ):
        # The ID of the health check configuration.
        self.monitor_config_id = monitor_config_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddGtmMonitorResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddGtmMonitorResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGtmMonitorResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddGtmRecoveryPlanRequest(TeaModel):
    def __init__(
        self,
        fault_addr_pool: str = None,
        lang: str = None,
        name: str = None,
        remark: str = None,
    ):
        # The list of IDs of faulty address pools.
        self.fault_addr_pool = fault_addr_pool
        # The language used by the user.
        self.lang = lang
        # The name of the disaster recovery plan that you want to create.
        self.name = name
        # The remarks on the disaster recovery plan.
        self.remark = remark

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.fault_addr_pool is not None:
            result['FaultAddrPool'] = self.fault_addr_pool
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        if self.remark is not None:
            result['Remark'] = self.remark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FaultAddrPool') is not None:
            self.fault_addr_pool = m.get('FaultAddrPool')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        return self


class AddGtmRecoveryPlanResponseBody(TeaModel):
    def __init__(
        self,
        recovery_plan_id: str = None,
        request_id: str = None,
    ):
        # The ID of the disaster recovery plan created.
        self.recovery_plan_id = recovery_plan_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.recovery_plan_id is not None:
            result['RecoveryPlanId'] = self.recovery_plan_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecoveryPlanId') is not None:
            self.recovery_plan_id = m.get('RecoveryPlanId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddGtmRecoveryPlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddGtmRecoveryPlanResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddGtmRecoveryPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindInstanceDomainsRequest(TeaModel):
    def __init__(
        self,
        domain_names: str = None,
        instance_id: str = None,
        lang: str = None,
    ):
        # The list of domain names.
        # 
        # >  Separate multiple domain names with commas (,). A maximum of 100 domain names can be entered.
        self.domain_names = domain_names
        # The ID of the instance.
        self.instance_id = instance_id
        # The language type.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_names is not None:
            result['DomainNames'] = self.domain_names
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainNames') is not None:
            self.domain_names = m.get('DomainNames')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class BindInstanceDomainsResponseBody(TeaModel):
    def __init__(
        self,
        failed_count: int = None,
        request_id: str = None,
        success_count: int = None,
    ):
        # The number of domain names that failed to be bound.
        self.failed_count = failed_count
        # The ID of the request.
        self.request_id = request_id
        # The number of domain names that have been bound.
        self.success_count = success_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failed_count is not None:
            result['FailedCount'] = self.failed_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailedCount') is not None:
            self.failed_count = m.get('FailedCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class BindInstanceDomainsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BindInstanceDomainsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindInstanceDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeDomainGroupRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        group_id: str = None,
        lang: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The ID of the target domain name group.
        self.group_id = group_id
        # The language type.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class ChangeDomainGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        group_name: str = None,
        request_id: str = None,
    ):
        # The ID of the target domain name group.
        self.group_id = group_id
        # The name of the target domain name group.
        self.group_name = group_name
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeDomainGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeDomainGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeDomainGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeDomainOfDnsProductRequest(TeaModel):
    def __init__(
        self,
        force: bool = None,
        instance_id: str = None,
        lang: str = None,
        new_domain: str = None,
        user_client_ip: str = None,
    ):
        # Specifies whether to force bind a domain name to the instance.
        self.force = force
        # The ID of the Alibaba Cloud DNS instance.
        self.instance_id = instance_id
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
        self.lang = lang
        # The domain name that you want to bind to the instance. If you do not specify this parameter, this operation unbinds the original domain name from the instance.
        self.new_domain = new_domain
        # The IP address of the client.
        self.user_client_ip = user_client_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.force is not None:
            result['Force'] = self.force
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.new_domain is not None:
            result['NewDomain'] = self.new_domain
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NewDomain') is not None:
            self.new_domain = m.get('NewDomain')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        return self


class ChangeDomainOfDnsProductResponseBody(TeaModel):
    def __init__(
        self,
        original_domain: str = None,
        request_id: str = None,
    ):
        # The original domain name that was bound to the instance. If the value of this parameter is empty, the instance is bound with a domain name for the first time.
        self.original_domain = original_domain
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.original_domain is not None:
            result['OriginalDomain'] = self.original_domain
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OriginalDomain') is not None:
            self.original_domain = m.get('OriginalDomain')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeDomainOfDnsProductResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeDomainOfDnsProductResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeDomainOfDnsProductResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CopyGtmConfigRequest(TeaModel):
    def __init__(
        self,
        copy_type: str = None,
        lang: str = None,
        source_id: str = None,
        target_id: str = None,
    ):
        # The type of the object that you want to copy. Only the INSTANCE type is supported.
        self.copy_type = copy_type
        # The language that specific response parameters will use.
        self.lang = lang
        # The ID of the source object. Only instance IDs are supported.
        self.source_id = source_id
        # The ID of the target object. Only instance IDs are supported.
        self.target_id = target_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.copy_type is not None:
            result['CopyType'] = self.copy_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_id is not None:
            result['SourceId'] = self.source_id
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CopyType') is not None:
            self.copy_type = m.get('CopyType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceId') is not None:
            self.source_id = m.get('SourceId')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        return self


class CopyGtmConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CopyGtmConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CopyGtmConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CopyGtmConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePdnsAppKeyRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class CreatePdnsAppKeyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreatePdnsAppKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePdnsAppKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePdnsAppKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreatePdnsUdpIpSegmentRequest(TeaModel):
    def __init__(
        self,
        ip: str = None,
        lang: str = None,
        name: str = None,
    ):
        self.ip = ip
        self.lang = lang
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreatePdnsUdpIpSegmentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        valid_message: str = None,
    ):
        self.request_id = request_id
        self.valid_message = valid_message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.valid_message is not None:
            result['ValidMessage'] = self.valid_message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ValidMessage') is not None:
            self.valid_message = m.get('ValidMessage')
        return self


class CreatePdnsUdpIpSegmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreatePdnsUdpIpSegmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreatePdnsUdpIpSegmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomLinesRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        line_ids: str = None,
    ):
        # The language type.
        self.lang = lang
        # The unique IDs of the custom lines that you want to delete. Separate the unique IDs with commas (,).
        self.line_ids = line_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.line_ids is not None:
            result['LineIds'] = self.line_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('LineIds') is not None:
            self.line_ids = m.get('LineIds')
        return self


class DeleteCustomLinesResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomLinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomLinesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomLinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDnsCacheDomainRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
    ):
        self.domain_name = domain_name
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteDnsCacheDomainResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDnsCacheDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDnsCacheDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDnsCacheDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDnsGtmAccessStrategyRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        strategy_id: str = None,
    ):
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The ID of the access policy.
        self.strategy_id = strategy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        return self


class DeleteDnsGtmAccessStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDnsGtmAccessStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDnsGtmAccessStrategyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDnsGtmAccessStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDnsGtmAddressPoolRequest(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        lang: str = None,
    ):
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteDnsGtmAddressPoolResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDnsGtmAddressPoolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDnsGtmAddressPoolResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDnsGtmAddressPoolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDomainRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language type.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteDomainResponseBody(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        request_id: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDomainGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        lang: str = None,
    ):
        # The ID of the domain name group.
        self.group_id = group_id
        # The language type.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteDomainGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_name: str = None,
        request_id: str = None,
    ):
        # The name of the domain name group.
        self.group_name = group_name
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDomainGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDomainGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDomainGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDomainRecordRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        record_id: str = None,
        user_client_ip: str = None,
    ):
        # The language type.
        self.lang = lang
        # The ID of the DNS record.
        # 
        # This parameter is returned when you add a DNS record or when you query the list of DNS records.
        self.record_id = record_id
        # The IP address of the client.
        self.user_client_ip = user_client_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        return self


class DeleteDomainRecordResponseBody(TeaModel):
    def __init__(
        self,
        record_id: str = None,
        request_id: str = None,
    ):
        # The ID of the DNS record.
        self.record_id = record_id
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteDomainRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteDomainRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDomainRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGtmAccessStrategyRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        strategy_id: str = None,
    ):
        # The language used by the user.
        self.lang = lang
        # The ID of the access policy that you want to delete.
        self.strategy_id = strategy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        return self


class DeleteGtmAccessStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGtmAccessStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGtmAccessStrategyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGtmAccessStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGtmAddressPoolRequest(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        lang: str = None,
    ):
        # The ID of the address pool that you want to delete.
        self.addr_pool_id = addr_pool_id
        # The language used by the user.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DeleteGtmAddressPoolResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGtmAddressPoolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGtmAddressPoolResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGtmAddressPoolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGtmRecoveryPlanRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        recovery_plan_id: int = None,
    ):
        # The language used by the user.
        self.lang = lang
        # The ID of the disaster recovery plan that you want to delete.
        self.recovery_plan_id = recovery_plan_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.recovery_plan_id is not None:
            result['RecoveryPlanId'] = self.recovery_plan_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RecoveryPlanId') is not None:
            self.recovery_plan_id = m.get('RecoveryPlanId')
        return self


class DeleteGtmRecoveryPlanResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGtmRecoveryPlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGtmRecoveryPlanResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGtmRecoveryPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSubDomainRecordsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        rr: str = None,
        type: str = None,
        user_client_ip: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language type.
        self.lang = lang
        # The host record.
        # 
        # For example, to resolve @.example.com, you must set RR to an at sign (@) instead of leaving it blank.
        self.rr = rr
        # The type of the DNS record. If you do not specify this parameter, all DNS record types corresponding to the subdomain name are returned.
        # 
        # DNS record types include **A, MX, CNAME, TXT, REDIRECT_URL, FORWORD_URL, NS, AAAA, and SRV**. The value is not case-sensitive.
        self.type = type
        # The IP address of the client.
        self.user_client_ip = user_client_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.rr is not None:
            result['RR'] = self.rr
        if self.type is not None:
            result['Type'] = self.type
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RR') is not None:
            self.rr = m.get('RR')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        return self


class DeleteSubDomainRecordsResponseBody(TeaModel):
    def __init__(
        self,
        rr: str = None,
        request_id: str = None,
        total_count: str = None,
    ):
        # The host record.
        self.rr = rr
        # The ID of the request.
        self.request_id = request_id
        # The total number of deleted DNS records.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rr is not None:
            result['RR'] = self.rr
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RR') is not None:
            self.rr = m.get('RR')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DeleteSubDomainRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSubDomainRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSubDomainRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBatchResultCountRequest(TeaModel):
    def __init__(
        self,
        batch_type: str = None,
        lang: str = None,
        task_id: int = None,
    ):
        # The type of the batch operation. Valid values:
        # 
        # *   **DOMAIN_ADD**: adds domain names in batches.
        # *   **DOMAIN_DEL**: deletes domain names in batches.
        # *   **RR_ADD**: adds DNS records in batches.
        # *   **RR_DEL**: deletes DNS records in batches.
        self.batch_type = batch_type
        # The language type.
        self.lang = lang
        # The ID of the task.
        # 
        # If you specify TaskId, the execution result of the specified task is returned. If you do not specify TaskId, the execution result of the last task is returned.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_type is not None:
            result['BatchType'] = self.batch_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchType') is not None:
            self.batch_type = m.get('BatchType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeBatchResultCountResponseBody(TeaModel):
    def __init__(
        self,
        batch_type: str = None,
        failed_count: int = None,
        reason: str = None,
        request_id: str = None,
        status: int = None,
        success_count: int = None,
        task_id: int = None,
        total_count: int = None,
    ):
        # The type of the batch operation.
        self.batch_type = batch_type
        # The total number of domain names or DNS records that failed to be processed.
        self.failed_count = failed_count
        # The cause of the execution failure.
        self.reason = reason
        # The ID of the request.
        self.request_id = request_id
        # The status of the task. Valid values:
        # 
        # *   **-1**: No task for importing domain names or DNS records is submitted.
        # *   **0**: The task is being processed.
        # *   **1**: The task is completed.
        # *   **2**: The task failed.
        self.status = status
        # The total number of successfully processed domain names or DNS records.
        self.success_count = success_count
        # The ID of the last task.
        self.task_id = task_id
        # The total number of DNS records that were processed in batches.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_type is not None:
            result['BatchType'] = self.batch_type
        if self.failed_count is not None:
            result['FailedCount'] = self.failed_count
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchType') is not None:
            self.batch_type = m.get('BatchType')
        if m.get('FailedCount') is not None:
            self.failed_count = m.get('FailedCount')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBatchResultCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBatchResultCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBatchResultCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBatchResultDetailRequest(TeaModel):
    def __init__(
        self,
        batch_type: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        status: str = None,
        task_id: int = None,
    ):
        # The type of the batch operation. Valid values:
        # 
        # *   **DOMAIN_ADD**: adds domain names in batches.
        # *   **DOMAIN_DEL**: deletes domain names in batches.
        # *   **RR_ADD**: adds DNS records in batches.
        # *   **RR_DEL**: deletes DNS records in batches.
        self.batch_type = batch_type
        # The language type.
        self.lang = lang
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        self.status = status
        # The ID of the task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_type is not None:
            result['BatchType'] = self.batch_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchType') is not None:
            self.batch_type = m.get('BatchType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail(TeaModel):
    def __init__(
        self,
        batch_type: str = None,
        domain: str = None,
        line: str = None,
        new_rr: str = None,
        new_value: str = None,
        operate_date_str: str = None,
        priority: str = None,
        reason: str = None,
        record_id: str = None,
        remark: str = None,
        rr: str = None,
        rr_status: str = None,
        status: bool = None,
        ttl: str = None,
        type: str = None,
        value: str = None,
    ):
        # The type of the batch operation.
        self.batch_type = batch_type
        # The domain name.
        self.domain = domain
        # The line code.
        self.line = line
        # The new host record.
        self.new_rr = new_rr
        # The new record value.
        self.new_value = new_value
        # The time when the operation was performed.
        self.operate_date_str = operate_date_str
        # The priority of an MX-type DNS record.
        self.priority = priority
        # The cause of the execution failure.
        self.reason = reason
        # The ID of the DNS record.
        self.record_id = record_id
        # The description of the DNS record.
        self.remark = remark
        # The host record.
        self.rr = rr
        # The status of the DNS record.
        self.rr_status = rr_status
        # The execution result. Valid values:**true**: The execution succeeded.**false**: The execution failed.
        self.status = status
        # The TTL of the DNS record.
        self.ttl = ttl
        # The type of the DNS record.
        self.type = type
        # The value of the DNS record.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_type is not None:
            result['BatchType'] = self.batch_type
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.line is not None:
            result['Line'] = self.line
        if self.new_rr is not None:
            result['NewRr'] = self.new_rr
        if self.new_value is not None:
            result['NewValue'] = self.new_value
        if self.operate_date_str is not None:
            result['OperateDateStr'] = self.operate_date_str
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.rr is not None:
            result['Rr'] = self.rr
        if self.rr_status is not None:
            result['RrStatus'] = self.rr_status
        if self.status is not None:
            result['Status'] = self.status
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchType') is not None:
            self.batch_type = m.get('BatchType')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('NewRr') is not None:
            self.new_rr = m.get('NewRr')
        if m.get('NewValue') is not None:
            self.new_value = m.get('NewValue')
        if m.get('OperateDateStr') is not None:
            self.operate_date_str = m.get('OperateDateStr')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Rr') is not None:
            self.rr = m.get('Rr')
        if m.get('RrStatus') is not None:
            self.rr_status = m.get('RrStatus')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeBatchResultDetailResponseBodyBatchResultDetails(TeaModel):
    def __init__(
        self,
        batch_result_detail: List[DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail] = None,
    ):
        self.batch_result_detail = batch_result_detail

    def validate(self):
        if self.batch_result_detail:
            for k in self.batch_result_detail:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BatchResultDetail'] = []
        if self.batch_result_detail is not None:
            for k in self.batch_result_detail:
                result['BatchResultDetail'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.batch_result_detail = []
        if m.get('BatchResultDetail') is not None:
            for k in m.get('BatchResultDetail'):
                temp_model = DescribeBatchResultDetailResponseBodyBatchResultDetailsBatchResultDetail()
                self.batch_result_detail.append(temp_model.from_map(k))
        return self


class DescribeBatchResultDetailResponseBody(TeaModel):
    def __init__(
        self,
        batch_result_details: DescribeBatchResultDetailResponseBodyBatchResultDetails = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # Detailed information about the batch operation result.
        self.batch_result_details = batch_result_details
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.batch_result_details:
            self.batch_result_details.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_result_details is not None:
            result['BatchResultDetails'] = self.batch_result_details.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchResultDetails') is not None:
            temp_model = DescribeBatchResultDetailResponseBodyBatchResultDetails()
            self.batch_result_details = temp_model.from_map(m['BatchResultDetails'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBatchResultDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBatchResultDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBatchResultDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomLineRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        line_id: int = None,
    ):
        # The language type.
        self.lang = lang
        # The unique ID of the custom line.
        self.line_id = line_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.line_id is not None:
            result['LineId'] = self.line_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('LineId') is not None:
            self.line_id = m.get('LineId')
        return self


class DescribeCustomLineResponseBodyIpSegmentList(TeaModel):
    def __init__(
        self,
        end_ip: str = None,
        start_ip: str = None,
    ):
        # The end IP address.
        self.end_ip = end_ip
        # The start IP address.
        self.start_ip = start_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_ip is not None:
            result['EndIp'] = self.end_ip
        if self.start_ip is not None:
            result['StartIp'] = self.start_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndIp') is not None:
            self.end_ip = m.get('EndIp')
        if m.get('StartIp') is not None:
            self.start_ip = m.get('StartIp')
        return self


class DescribeCustomLineResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        domain_name: str = None,
        id: int = None,
        ip_segment_list: List[DescribeCustomLineResponseBodyIpSegmentList] = None,
        name: str = None,
        request_id: str = None,
    ):
        # The code of the custom line. The code is used when you configure a resolution record.
        self.code = code
        # The domain name for which the custom line is configured.
        self.domain_name = domain_name
        # The unique ID of the custom line.
        self.id = id
        # The list of CIDR blocks.
        self.ip_segment_list = ip_segment_list
        # The name of the custom line.
        self.name = name
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.ip_segment_list:
            for k in self.ip_segment_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.id is not None:
            result['Id'] = self.id
        result['IpSegmentList'] = []
        if self.ip_segment_list is not None:
            for k in self.ip_segment_list:
                result['IpSegmentList'].append(k.to_map() if k else None)
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.ip_segment_list = []
        if m.get('IpSegmentList') is not None:
            for k in m.get('IpSegmentList'):
                temp_model = DescribeCustomLineResponseBodyIpSegmentList()
                self.ip_segment_list.append(temp_model.from_map(k))
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCustomLineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomLineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomLineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomLinesRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The domain name for which the custom lines to be queried are configured.
        self.domain_name = domain_name
        # The language type.
        self.lang = lang
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeCustomLinesResponseBodyCustomLines(TeaModel):
    def __init__(
        self,
        code: str = None,
        id: int = None,
        name: str = None,
    ):
        # The code of the custom line.
        self.code = code
        # The unique ID of the custom line.
        self.id = id
        # The name of the custom line.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeCustomLinesResponseBody(TeaModel):
    def __init__(
        self,
        custom_lines: List[DescribeCustomLinesResponseBodyCustomLines] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The list of custom lines.
        self.custom_lines = custom_lines
        # The number of the returned page.
        self.page_number = page_number
        # The number of entries that were returned on each page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of custom lines.
        self.total_items = total_items
        # The number of pages that were returned.
        self.total_pages = total_pages

    def validate(self):
        if self.custom_lines:
            for k in self.custom_lines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CustomLines'] = []
        if self.custom_lines is not None:
            for k in self.custom_lines:
                result['CustomLines'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.custom_lines = []
        if m.get('CustomLines') is not None:
            for k in m.get('CustomLines'):
                temp_model = DescribeCustomLinesResponseBodyCustomLines()
                self.custom_lines.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeCustomLinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomLinesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomLinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDNSSLBSubDomainsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        rr: str = None,
        user_client_ip: str = None,
    ):
        # The domain name whose subdomains you want to query.
        self.domain_name = domain_name
        # The language of the domain name.
        self.lang = lang
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **100**. Default value: **20**.
        self.page_size = page_size
        self.rr = rr
        # The IP address of the client that you use to query subdomains.
        self.user_client_ip = user_client_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rr is not None:
            result['Rr'] = self.rr
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rr') is not None:
            self.rr = m.get('Rr')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        return self


class DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm(TeaModel):
    def __init__(
        self,
        line: str = None,
        open: bool = None,
    ):
        self.line = line
        self.open = open

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.line is not None:
            result['Line'] = self.line
        if self.open is not None:
            result['Open'] = self.open
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('Open') is not None:
            self.open = m.get('Open')
        return self


class DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithms(TeaModel):
    def __init__(
        self,
        line_algorithm: List[DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm] = None,
    ):
        self.line_algorithm = line_algorithm

    def validate(self):
        if self.line_algorithm:
            for k in self.line_algorithm:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['LineAlgorithm'] = []
        if self.line_algorithm is not None:
            for k in self.line_algorithm:
                result['LineAlgorithm'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.line_algorithm = []
        if m.get('LineAlgorithm') is not None:
            for k in m.get('LineAlgorithm'):
                temp_model = DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithmsLineAlgorithm()
                self.line_algorithm.append(temp_model.from_map(k))
        return self


class DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain(TeaModel):
    def __init__(
        self,
        line_algorithms: DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithms = None,
        open: bool = None,
        record_count: int = None,
        sub_domain: str = None,
        type: str = None,
    ):
        self.line_algorithms = line_algorithms
        # Indicates whether weighted round-robin is enabled for the subdomain.
        self.open = open
        # The number of DNS records added for the subdomain.
        self.record_count = record_count
        # The subdomain.
        self.sub_domain = sub_domain
        # The type of the DNS record that supports weighted round-robin. Valid values: A, AAAA, and CNAME.
        self.type = type

    def validate(self):
        if self.line_algorithms:
            self.line_algorithms.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.line_algorithms is not None:
            result['LineAlgorithms'] = self.line_algorithms.to_map()
        if self.open is not None:
            result['Open'] = self.open
        if self.record_count is not None:
            result['RecordCount'] = self.record_count
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LineAlgorithms') is not None:
            temp_model = DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomainLineAlgorithms()
            self.line_algorithms = temp_model.from_map(m['LineAlgorithms'])
        if m.get('Open') is not None:
            self.open = m.get('Open')
        if m.get('RecordCount') is not None:
            self.record_count = m.get('RecordCount')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDNSSLBSubDomainsResponseBodySlbSubDomains(TeaModel):
    def __init__(
        self,
        slb_sub_domain: List[DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain] = None,
    ):
        self.slb_sub_domain = slb_sub_domain

    def validate(self):
        if self.slb_sub_domain:
            for k in self.slb_sub_domain:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SlbSubDomain'] = []
        if self.slb_sub_domain is not None:
            for k in self.slb_sub_domain:
                result['SlbSubDomain'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.slb_sub_domain = []
        if m.get('SlbSubDomain') is not None:
            for k in m.get('SlbSubDomain'):
                temp_model = DescribeDNSSLBSubDomainsResponseBodySlbSubDomainsSlbSubDomain()
                self.slb_sub_domain.append(temp_model.from_map(k))
        return self


class DescribeDNSSLBSubDomainsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        slb_sub_domains: DescribeDNSSLBSubDomainsResponseBodySlbSubDomains = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The total number of subdomains returned.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The details of the subdomains.
        self.slb_sub_domains = slb_sub_domains
        # The number of domain name groups.
        self.total_count = total_count

    def validate(self):
        if self.slb_sub_domains:
            self.slb_sub_domains.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.slb_sub_domains is not None:
            result['SlbSubDomains'] = self.slb_sub_domains.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SlbSubDomains') is not None:
            temp_model = DescribeDNSSLBSubDomainsResponseBodySlbSubDomains()
            self.slb_sub_domains = temp_model.from_map(m['SlbSubDomains'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDNSSLBSubDomainsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDNSSLBSubDomainsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDNSSLBSubDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsCacheDomainsRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.keyword = keyword
        self.lang = lang
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers(TeaModel):
    def __init__(
        self,
        host: str = None,
        port: str = None,
    ):
        self.host = host
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class DescribeDnsCacheDomainsResponseBodyDomains(TeaModel):
    def __init__(
        self,
        cache_ttl_max: int = None,
        cache_ttl_min: int = None,
        create_time: str = None,
        create_timestamp: int = None,
        domain_id: str = None,
        domain_name: str = None,
        expire_time: str = None,
        expire_timestamp: int = None,
        instance_id: str = None,
        remark: str = None,
        source_dns_servers: List[DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers] = None,
        source_edns: str = None,
        source_protocol: str = None,
        update_time: str = None,
        update_timestamp: int = None,
        version_code: str = None,
    ):
        self.cache_ttl_max = cache_ttl_max
        self.cache_ttl_min = cache_ttl_min
        self.create_time = create_time
        self.create_timestamp = create_timestamp
        self.domain_id = domain_id
        self.domain_name = domain_name
        self.expire_time = expire_time
        self.expire_timestamp = expire_timestamp
        self.instance_id = instance_id
        self.remark = remark
        self.source_dns_servers = source_dns_servers
        self.source_edns = source_edns
        self.source_protocol = source_protocol
        self.update_time = update_time
        self.update_timestamp = update_timestamp
        self.version_code = version_code

    def validate(self):
        if self.source_dns_servers:
            for k in self.source_dns_servers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cache_ttl_max is not None:
            result['CacheTtlMax'] = self.cache_ttl_max
        if self.cache_ttl_min is not None:
            result['CacheTtlMin'] = self.cache_ttl_min
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.expire_timestamp is not None:
            result['ExpireTimestamp'] = self.expire_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.remark is not None:
            result['Remark'] = self.remark
        result['SourceDnsServers'] = []
        if self.source_dns_servers is not None:
            for k in self.source_dns_servers:
                result['SourceDnsServers'].append(k.to_map() if k else None)
        if self.source_edns is not None:
            result['SourceEdns'] = self.source_edns
        if self.source_protocol is not None:
            result['SourceProtocol'] = self.source_protocol
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CacheTtlMax') is not None:
            self.cache_ttl_max = m.get('CacheTtlMax')
        if m.get('CacheTtlMin') is not None:
            self.cache_ttl_min = m.get('CacheTtlMin')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('ExpireTimestamp') is not None:
            self.expire_timestamp = m.get('ExpireTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        self.source_dns_servers = []
        if m.get('SourceDnsServers') is not None:
            for k in m.get('SourceDnsServers'):
                temp_model = DescribeDnsCacheDomainsResponseBodyDomainsSourceDnsServers()
                self.source_dns_servers.append(temp_model.from_map(k))
        if m.get('SourceEdns') is not None:
            self.source_edns = m.get('SourceEdns')
        if m.get('SourceProtocol') is not None:
            self.source_protocol = m.get('SourceProtocol')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        return self


class DescribeDnsCacheDomainsResponseBody(TeaModel):
    def __init__(
        self,
        domains: List[DescribeDnsCacheDomainsResponseBodyDomains] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.domains = domains
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.domains:
            for k in self.domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Domains'] = []
        if self.domains is not None:
            for k in self.domains:
                result['Domains'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domains = []
        if m.get('Domains') is not None:
            for k in m.get('Domains'):
                temp_model = DescribeDnsCacheDomainsResponseBodyDomains()
                self.domains.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDnsCacheDomainsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsCacheDomainsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsCacheDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmAccessStrategiesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        strategy_mode: str = None,
    ):
        # The ID of the instance.
        self.instance_id = instance_id
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The type of the access policy. Valid values:
        # 
        # *   GEO: geographical location-based
        # *   LATENCY: latency-based
        self.strategy_mode = strategy_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.strategy_mode is not None:
            result['StrategyMode'] = self.strategy_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StrategyMode') is not None:
            self.strategy_mode = m.get('StrategyMode')
        return self


class DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool(TeaModel):
    def __init__(
        self,
        addr_count: int = None,
        id: str = None,
        lba_weight: int = None,
        name: str = None,
    ):
        # The number of addresses in the address pool.
        self.addr_count = addr_count
        # The ID of the address pool.
        self.id = id
        # The weight of the address pool.
        self.lba_weight = lba_weight
        # The name of the address pool.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_count is not None:
            result['AddrCount'] = self.addr_count
        if self.id is not None:
            result['Id'] = self.id
        if self.lba_weight is not None:
            result['LbaWeight'] = self.lba_weight
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrCount') is not None:
            self.addr_count = m.get('AddrCount')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LbaWeight') is not None:
            self.lba_weight = m.get('LbaWeight')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPools(TeaModel):
    def __init__(
        self,
        effective_addr_pool: List[DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool] = None,
    ):
        self.effective_addr_pool = effective_addr_pool

    def validate(self):
        if self.effective_addr_pool:
            for k in self.effective_addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EffectiveAddrPool'] = []
        if self.effective_addr_pool is not None:
            for k in self.effective_addr_pool:
                result['EffectiveAddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.effective_addr_pool = []
        if m.get('EffectiveAddrPool') is not None:
            for k in m.get('EffectiveAddrPool'):
                temp_model = DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPoolsEffectiveAddrPool()
                self.effective_addr_pool.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine(TeaModel):
    def __init__(
        self,
        group_code: str = None,
        group_name: str = None,
        line_code: str = None,
        line_name: str = None,
    ):
        # The code of the source region group.
        self.group_code = group_code
        # The name of the source region group.
        self.group_name = group_name
        # The line code of the source region.
        self.line_code = line_code
        # The line name of the source region.
        self.line_name = line_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_code is not None:
            result['GroupCode'] = self.group_code
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_name is not None:
            result['LineName'] = self.line_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupCode') is not None:
            self.group_code = m.get('GroupCode')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        return self


class DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLines(TeaModel):
    def __init__(
        self,
        line: List[DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine] = None,
    ):
        self.line = line

    def validate(self):
        if self.line:
            for k in self.line:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Line'] = []
        if self.line is not None:
            for k in self.line:
                result['Line'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.line = []
        if m.get('Line') is not None:
            for k in m.get('Line'):
                temp_model = DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine()
                self.line.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_timestamp: int = None,
        effective_addr_pool_group_type: str = None,
        effective_addr_pool_type: str = None,
        effective_addr_pools: DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPools = None,
        effective_lba_strategy: str = None,
        lines: DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLines = None,
        strategy_id: str = None,
        strategy_name: str = None,
    ):
        # The time when the access policy was created.
        self.create_time = create_time
        # The timestamp that indicates when the access policy was created.
        self.create_timestamp = create_timestamp
        # The type of the active address pool group. Valid values:
        # 
        # *   DEFAULT: the primary address pool group
        # *   FAILOVER: the secondary address pool group
        self.effective_addr_pool_group_type = effective_addr_pool_group_type
        # The type of the active address pools. Valid values:
        # 
        # *   IPV4
        # *   IPV6
        # *   DOMAIN
        self.effective_addr_pool_type = effective_addr_pool_type
        # The active address pool groups.
        self.effective_addr_pools = effective_addr_pools
        # The load balancing policy of the active address pool group. Data is returned when StrategyMode is set to GEO. Valid values: 
        # 
        # - ALL_RR: returns all addresses.
        # - RATIO: returns addresses by weight.
        self.effective_lba_strategy = effective_lba_strategy
        # The source regions. Data is returned when StrategyMode is set to GEO. Valid values:
        self.lines = lines
        # The ID of the access policy.
        self.strategy_id = strategy_id
        # The name of the access policy.
        self.strategy_name = strategy_name

    def validate(self):
        if self.effective_addr_pools:
            self.effective_addr_pools.validate()
        if self.lines:
            self.lines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.effective_addr_pool_group_type is not None:
            result['EffectiveAddrPoolGroupType'] = self.effective_addr_pool_group_type
        if self.effective_addr_pool_type is not None:
            result['EffectiveAddrPoolType'] = self.effective_addr_pool_type
        if self.effective_addr_pools is not None:
            result['EffectiveAddrPools'] = self.effective_addr_pools.to_map()
        if self.effective_lba_strategy is not None:
            result['EffectiveLbaStrategy'] = self.effective_lba_strategy
        if self.lines is not None:
            result['Lines'] = self.lines.to_map()
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('EffectiveAddrPoolGroupType') is not None:
            self.effective_addr_pool_group_type = m.get('EffectiveAddrPoolGroupType')
        if m.get('EffectiveAddrPoolType') is not None:
            self.effective_addr_pool_type = m.get('EffectiveAddrPoolType')
        if m.get('EffectiveAddrPools') is not None:
            temp_model = DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyEffectiveAddrPools()
            self.effective_addr_pools = temp_model.from_map(m['EffectiveAddrPools'])
        if m.get('EffectiveLbaStrategy') is not None:
            self.effective_lba_strategy = m.get('EffectiveLbaStrategy')
        if m.get('Lines') is not None:
            temp_model = DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategyLines()
            self.lines = temp_model.from_map(m['Lines'])
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        return self


class DescribeDnsGtmAccessStrategiesResponseBodyStrategies(TeaModel):
    def __init__(
        self,
        strategy: List[DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy] = None,
    ):
        self.strategy = strategy

    def validate(self):
        if self.strategy:
            for k in self.strategy:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Strategy'] = []
        if self.strategy is not None:
            for k in self.strategy:
                result['Strategy'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.strategy = []
        if m.get('Strategy') is not None:
            for k in m.get('Strategy'):
                temp_model = DescribeDnsGtmAccessStrategiesResponseBodyStrategiesStrategy()
                self.strategy.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAccessStrategiesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        strategies: DescribeDnsGtmAccessStrategiesResponseBodyStrategies = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The access policies.
        self.strategies = strategies
        # The total number of entries returned on all pages.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.strategies:
            self.strategies.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategies is not None:
            result['Strategies'] = self.strategies.to_map()
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Strategies') is not None:
            temp_model = DescribeDnsGtmAccessStrategiesResponseBodyStrategies()
            self.strategies = temp_model.from_map(m['Strategies'])
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeDnsGtmAccessStrategiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmAccessStrategiesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmAccessStrategiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmAccessStrategyRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        strategy_id: str = None,
    ):
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The ID of the access policy.
        self.strategy_id = strategy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        return self


class DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool(TeaModel):
    def __init__(
        self,
        addr_count: int = None,
        id: str = None,
        lba_weight: int = None,
        name: str = None,
    ):
        # The number of addresses in the address pool.
        self.addr_count = addr_count
        # The ID of the address pool.
        self.id = id
        # The weight of the address pool.
        self.lba_weight = lba_weight
        # The name of the address pool.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_count is not None:
            result['AddrCount'] = self.addr_count
        if self.id is not None:
            result['Id'] = self.id
        if self.lba_weight is not None:
            result['LbaWeight'] = self.lba_weight
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrCount') is not None:
            self.addr_count = m.get('AddrCount')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LbaWeight') is not None:
            self.lba_weight = m.get('LbaWeight')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPools(TeaModel):
    def __init__(
        self,
        default_addr_pool: List[DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool] = None,
    ):
        self.default_addr_pool = default_addr_pool

    def validate(self):
        if self.default_addr_pool:
            for k in self.default_addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DefaultAddrPool'] = []
        if self.default_addr_pool is not None:
            for k in self.default_addr_pool:
                result['DefaultAddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.default_addr_pool = []
        if m.get('DefaultAddrPool') is not None:
            for k in m.get('DefaultAddrPool'):
                temp_model = DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPoolsDefaultAddrPool()
                self.default_addr_pool.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool(TeaModel):
    def __init__(
        self,
        addr_count: int = None,
        id: str = None,
        lba_weight: int = None,
        name: str = None,
    ):
        # The number of addresses in the address pool.
        self.addr_count = addr_count
        # The ID of the address pool.
        self.id = id
        # The weight of the address pool.
        self.lba_weight = lba_weight
        # The name of the address pool.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_count is not None:
            result['AddrCount'] = self.addr_count
        if self.id is not None:
            result['Id'] = self.id
        if self.lba_weight is not None:
            result['LbaWeight'] = self.lba_weight
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrCount') is not None:
            self.addr_count = m.get('AddrCount')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('LbaWeight') is not None:
            self.lba_weight = m.get('LbaWeight')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPools(TeaModel):
    def __init__(
        self,
        failover_addr_pool: List[DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool] = None,
    ):
        self.failover_addr_pool = failover_addr_pool

    def validate(self):
        if self.failover_addr_pool:
            for k in self.failover_addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailoverAddrPool'] = []
        if self.failover_addr_pool is not None:
            for k in self.failover_addr_pool:
                result['FailoverAddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.failover_addr_pool = []
        if m.get('FailoverAddrPool') is not None:
            for k in m.get('FailoverAddrPool'):
                temp_model = DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPoolsFailoverAddrPool()
                self.failover_addr_pool.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAccessStrategyResponseBodyLinesLine(TeaModel):
    def __init__(
        self,
        group_code: str = None,
        group_name: str = None,
        line_code: str = None,
        line_name: str = None,
    ):
        # The code of the source region group.
        self.group_code = group_code
        # The name of the source region group.
        self.group_name = group_name
        # The line code of the source region.
        self.line_code = line_code
        # The line name of the source region.
        self.line_name = line_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_code is not None:
            result['GroupCode'] = self.group_code
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_name is not None:
            result['LineName'] = self.line_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupCode') is not None:
            self.group_code = m.get('GroupCode')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        return self


class DescribeDnsGtmAccessStrategyResponseBodyLines(TeaModel):
    def __init__(
        self,
        line: List[DescribeDnsGtmAccessStrategyResponseBodyLinesLine] = None,
    ):
        self.line = line

    def validate(self):
        if self.line:
            for k in self.line:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Line'] = []
        if self.line is not None:
            for k in self.line:
                result['Line'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.line = []
        if m.get('Line') is not None:
            for k in m.get('Line'):
                temp_model = DescribeDnsGtmAccessStrategyResponseBodyLinesLine()
                self.line.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAccessStrategyResponseBody(TeaModel):
    def __init__(
        self,
        access_mode: str = None,
        create_time: str = None,
        create_timestamp: int = None,
        default_addr_pool_group_status: str = None,
        default_addr_pool_type: str = None,
        default_addr_pools: DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPools = None,
        default_available_addr_num: int = None,
        default_latency_optimization: str = None,
        default_lba_strategy: str = None,
        default_max_return_addr_num: int = None,
        default_min_available_addr_num: int = None,
        effective_addr_pool_group_type: str = None,
        failover_addr_pool_group_status: str = None,
        failover_addr_pool_type: str = None,
        failover_addr_pools: DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPools = None,
        failover_available_addr_num: int = None,
        failover_latency_optimization: str = None,
        failover_lba_strategy: str = None,
        failover_max_return_addr_num: int = None,
        failover_min_available_addr_num: int = None,
        instance_id: str = None,
        lines: DescribeDnsGtmAccessStrategyResponseBodyLines = None,
        request_id: str = None,
        strategy_id: str = None,
        strategy_mode: str = None,
        strategy_name: str = None,
    ):
        # The primary/secondary switchover policy for address pool groups. Valid values:
        # 
        # *   AUTO: performs automatic switchover between the primary and secondary address pool groups upon failures.
        # *   DEFAULT: uses the primary address pool group.
        # *   FAILOVER: uses the secondary address pool group.
        self.access_mode = access_mode
        # The time when the access policy was created.
        self.create_time = create_time
        # The timestamp that indicates when the access policy was created.
        self.create_timestamp = create_timestamp
        # The status of the primary address pool group. Valid values:
        # 
        # *   AVAILABLE: available
        # *   NOT_AVAILABLE: unavailable
        self.default_addr_pool_group_status = default_addr_pool_group_status
        # The type of the primary address pool. Valid values:
        # 
        # *   IPV4
        # *   IPV6
        # *   DOMAIN
        self.default_addr_pool_type = default_addr_pool_type
        # The address pools in the primary address pool group.
        self.default_addr_pools = default_addr_pools
        # The number of available addresses in the primary address pool.
        self.default_available_addr_num = default_available_addr_num
        # Indicates whether scheduling optimization for latency resolution was enabled for the primary address pool group. Valid values:
        # 
        # *   OPEN: enabled
        # *   CLOSE: disabled
        self.default_latency_optimization = default_latency_optimization
        # The load balancing policy of the primary address pool group. Valid values:
        # 
        # *   ALL_RR: returns all addresses.
        # *   RATIO: returns addresses by weight.
        self.default_lba_strategy = default_lba_strategy
        # The maximum number of addresses returned from the primary address pool group.
        self.default_max_return_addr_num = default_max_return_addr_num
        # The minimum number of available addresses in the primary address pool group.
        self.default_min_available_addr_num = default_min_available_addr_num
        # The type of the active address pool group. Valid values:
        # 
        # *   DEFAULT: the primary address pool group
        # *   FAILOVER: the secondary address pool group
        self.effective_addr_pool_group_type = effective_addr_pool_group_type
        # The status of the secondary address pool group. Valid values:
        # 
        # *   AVAILABLE: available
        # *   NOT_AVAILABLE: unavailable
        self.failover_addr_pool_group_status = failover_addr_pool_group_status
        # The type of the secondary address pool. Valid values:
        # 
        # *   IPV4
        # *   IPV6
        # *   DOMAIN
        self.failover_addr_pool_type = failover_addr_pool_type
        # The address pools in the secondary address pool group.
        self.failover_addr_pools = failover_addr_pools
        # The number of available addresses in the secondary address pool.
        self.failover_available_addr_num = failover_available_addr_num
        # Indicates whether scheduling optimization for latency resolution was enabled for the secondary address pool group. Valid values:
        # 
        # *   OPEN: enabled
        # *   CLOSE: disabled
        self.failover_latency_optimization = failover_latency_optimization
        # The load balancing policy of the secondary address pool group. Valid values:
        # 
        # *   ALL_RR: returns all addresses.
        # *   RATIO: returns addresses by weight.
        self.failover_lba_strategy = failover_lba_strategy
        # The maximum number of addresses returned from the secondary address pool group.
        self.failover_max_return_addr_num = failover_max_return_addr_num
        # The minimum number of available addresses in the secondary address pool group.
        self.failover_min_available_addr_num = failover_min_available_addr_num
        # The ID of the associated instance.
        self.instance_id = instance_id
        # The source regions.
        self.lines = lines
        # The ID of the request.
        self.request_id = request_id
        # The ID of the access policy.
        self.strategy_id = strategy_id
        # The type of the access policy. Valid values:
        # 
        # *   GEO: geographical location-based
        # *   LATENCY: latency-based
        self.strategy_mode = strategy_mode
        # The name of the access policy.
        self.strategy_name = strategy_name

    def validate(self):
        if self.default_addr_pools:
            self.default_addr_pools.validate()
        if self.failover_addr_pools:
            self.failover_addr_pools.validate()
        if self.lines:
            self.lines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_mode is not None:
            result['AccessMode'] = self.access_mode
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.default_addr_pool_group_status is not None:
            result['DefaultAddrPoolGroupStatus'] = self.default_addr_pool_group_status
        if self.default_addr_pool_type is not None:
            result['DefaultAddrPoolType'] = self.default_addr_pool_type
        if self.default_addr_pools is not None:
            result['DefaultAddrPools'] = self.default_addr_pools.to_map()
        if self.default_available_addr_num is not None:
            result['DefaultAvailableAddrNum'] = self.default_available_addr_num
        if self.default_latency_optimization is not None:
            result['DefaultLatencyOptimization'] = self.default_latency_optimization
        if self.default_lba_strategy is not None:
            result['DefaultLbaStrategy'] = self.default_lba_strategy
        if self.default_max_return_addr_num is not None:
            result['DefaultMaxReturnAddrNum'] = self.default_max_return_addr_num
        if self.default_min_available_addr_num is not None:
            result['DefaultMinAvailableAddrNum'] = self.default_min_available_addr_num
        if self.effective_addr_pool_group_type is not None:
            result['EffectiveAddrPoolGroupType'] = self.effective_addr_pool_group_type
        if self.failover_addr_pool_group_status is not None:
            result['FailoverAddrPoolGroupStatus'] = self.failover_addr_pool_group_status
        if self.failover_addr_pool_type is not None:
            result['FailoverAddrPoolType'] = self.failover_addr_pool_type
        if self.failover_addr_pools is not None:
            result['FailoverAddrPools'] = self.failover_addr_pools.to_map()
        if self.failover_available_addr_num is not None:
            result['FailoverAvailableAddrNum'] = self.failover_available_addr_num
        if self.failover_latency_optimization is not None:
            result['FailoverLatencyOptimization'] = self.failover_latency_optimization
        if self.failover_lba_strategy is not None:
            result['FailoverLbaStrategy'] = self.failover_lba_strategy
        if self.failover_max_return_addr_num is not None:
            result['FailoverMaxReturnAddrNum'] = self.failover_max_return_addr_num
        if self.failover_min_available_addr_num is not None:
            result['FailoverMinAvailableAddrNum'] = self.failover_min_available_addr_num
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lines is not None:
            result['Lines'] = self.lines.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.strategy_mode is not None:
            result['StrategyMode'] = self.strategy_mode
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessMode') is not None:
            self.access_mode = m.get('AccessMode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('DefaultAddrPoolGroupStatus') is not None:
            self.default_addr_pool_group_status = m.get('DefaultAddrPoolGroupStatus')
        if m.get('DefaultAddrPoolType') is not None:
            self.default_addr_pool_type = m.get('DefaultAddrPoolType')
        if m.get('DefaultAddrPools') is not None:
            temp_model = DescribeDnsGtmAccessStrategyResponseBodyDefaultAddrPools()
            self.default_addr_pools = temp_model.from_map(m['DefaultAddrPools'])
        if m.get('DefaultAvailableAddrNum') is not None:
            self.default_available_addr_num = m.get('DefaultAvailableAddrNum')
        if m.get('DefaultLatencyOptimization') is not None:
            self.default_latency_optimization = m.get('DefaultLatencyOptimization')
        if m.get('DefaultLbaStrategy') is not None:
            self.default_lba_strategy = m.get('DefaultLbaStrategy')
        if m.get('DefaultMaxReturnAddrNum') is not None:
            self.default_max_return_addr_num = m.get('DefaultMaxReturnAddrNum')
        if m.get('DefaultMinAvailableAddrNum') is not None:
            self.default_min_available_addr_num = m.get('DefaultMinAvailableAddrNum')
        if m.get('EffectiveAddrPoolGroupType') is not None:
            self.effective_addr_pool_group_type = m.get('EffectiveAddrPoolGroupType')
        if m.get('FailoverAddrPoolGroupStatus') is not None:
            self.failover_addr_pool_group_status = m.get('FailoverAddrPoolGroupStatus')
        if m.get('FailoverAddrPoolType') is not None:
            self.failover_addr_pool_type = m.get('FailoverAddrPoolType')
        if m.get('FailoverAddrPools') is not None:
            temp_model = DescribeDnsGtmAccessStrategyResponseBodyFailoverAddrPools()
            self.failover_addr_pools = temp_model.from_map(m['FailoverAddrPools'])
        if m.get('FailoverAvailableAddrNum') is not None:
            self.failover_available_addr_num = m.get('FailoverAvailableAddrNum')
        if m.get('FailoverLatencyOptimization') is not None:
            self.failover_latency_optimization = m.get('FailoverLatencyOptimization')
        if m.get('FailoverLbaStrategy') is not None:
            self.failover_lba_strategy = m.get('FailoverLbaStrategy')
        if m.get('FailoverMaxReturnAddrNum') is not None:
            self.failover_max_return_addr_num = m.get('FailoverMaxReturnAddrNum')
        if m.get('FailoverMinAvailableAddrNum') is not None:
            self.failover_min_available_addr_num = m.get('FailoverMinAvailableAddrNum')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lines') is not None:
            temp_model = DescribeDnsGtmAccessStrategyResponseBodyLines()
            self.lines = temp_model.from_map(m['Lines'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('StrategyMode') is not None:
            self.strategy_mode = m.get('StrategyMode')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        return self


class DescribeDnsGtmAccessStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmAccessStrategyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmAccessStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
        strategy_mode: str = None,
    ):
        # The ID of the instance.
        self.instance_id = instance_id
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The type of the access policy. Valid values:
        # 
        # *   GEO: geographical location-based
        # *   LATENCY: latency-based
        self.strategy_mode = strategy_mode

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.strategy_mode is not None:
            result['StrategyMode'] = self.strategy_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StrategyMode') is not None:
            self.strategy_mode = m.get('StrategyMode')
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool(TeaModel):
    def __init__(
        self,
        addr_count: int = None,
        id: str = None,
        name: str = None,
    ):
        # The number of addresses in the address pool.
        self.addr_count = addr_count
        # The ID of the address pool.
        self.id = id
        # The name of the address pool.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_count is not None:
            result['AddrCount'] = self.addr_count
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrCount') is not None:
            self.addr_count = m.get('AddrCount')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPools(TeaModel):
    def __init__(
        self,
        domain_addr_pool: List[DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool] = None,
    ):
        self.domain_addr_pool = domain_addr_pool

    def validate(self):
        if self.domain_addr_pool:
            for k in self.domain_addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainAddrPool'] = []
        if self.domain_addr_pool is not None:
            for k in self.domain_addr_pool:
                result['DomainAddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_addr_pool = []
        if m.get('DomainAddrPool') is not None:
            for k in m.get('DomainAddrPool'):
                temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPoolsDomainAddrPool()
                self.domain_addr_pool.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool(TeaModel):
    def __init__(
        self,
        addr_count: int = None,
        id: str = None,
        name: str = None,
    ):
        # The number of addresses in the address pool.
        self.addr_count = addr_count
        # The ID of the address pool.
        self.id = id
        # The name of the address pool.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_count is not None:
            result['AddrCount'] = self.addr_count
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrCount') is not None:
            self.addr_count = m.get('AddrCount')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPools(TeaModel):
    def __init__(
        self,
        ipv_4addr_pool: List[DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool] = None,
    ):
        self.ipv_4addr_pool = ipv_4addr_pool

    def validate(self):
        if self.ipv_4addr_pool:
            for k in self.ipv_4addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ipv4AddrPool'] = []
        if self.ipv_4addr_pool is not None:
            for k in self.ipv_4addr_pool:
                result['Ipv4AddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_4addr_pool = []
        if m.get('Ipv4AddrPool') is not None:
            for k in m.get('Ipv4AddrPool'):
                temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPoolsIpv4AddrPool()
                self.ipv_4addr_pool.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool(TeaModel):
    def __init__(
        self,
        addr_count: int = None,
        id: str = None,
        name: str = None,
    ):
        # The number of addresses in the address pool.
        self.addr_count = addr_count
        # The ID of the address pool.
        self.id = id
        # The name of the address pool.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_count is not None:
            result['AddrCount'] = self.addr_count
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrCount') is not None:
            self.addr_count = m.get('AddrCount')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPools(TeaModel):
    def __init__(
        self,
        ipv_6addr_pool: List[DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool] = None,
    ):
        self.ipv_6addr_pool = ipv_6addr_pool

    def validate(self):
        if self.ipv_6addr_pool:
            for k in self.ipv_6addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ipv6AddrPool'] = []
        if self.ipv_6addr_pool is not None:
            for k in self.ipv_6addr_pool:
                result['Ipv6AddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_6addr_pool = []
        if m.get('Ipv6AddrPool') is not None:
            for k in m.get('Ipv6AddrPool'):
                temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPoolsIpv6AddrPool()
                self.ipv_6addr_pool.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine(TeaModel):
    def __init__(
        self,
        father_code: str = None,
        group_code: str = None,
        group_name: str = None,
        line_code: str = None,
        line_name: str = None,
    ):
        # The parent line code of the source region. Leave it blank if no parent line exists.
        self.father_code = father_code
        # The line name of the source region.
        self.group_code = group_code
        # The name of the source region group.
        self.group_name = group_name
        # The line code of the source region.
        self.line_code = line_code
        # The code of the source region group.
        self.line_name = line_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.father_code is not None:
            result['FatherCode'] = self.father_code
        if self.group_code is not None:
            result['GroupCode'] = self.group_code
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_name is not None:
            result['LineName'] = self.line_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FatherCode') is not None:
            self.father_code = m.get('FatherCode')
        if m.get('GroupCode') is not None:
            self.group_code = m.get('GroupCode')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLines(TeaModel):
    def __init__(
        self,
        line: List[DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine] = None,
    ):
        self.line = line

    def validate(self):
        if self.line:
            for k in self.line:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Line'] = []
        if self.line is not None:
            for k in self.line:
                result['Line'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.line = []
        if m.get('Line') is not None:
            for k in m.get('Line'):
                temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLinesLine()
                self.line.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedDomainLines(TeaModel):
    def __init__(
        self,
        selected_domain_line: List[str] = None,
    ):
        self.selected_domain_line = selected_domain_line

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.selected_domain_line is not None:
            result['SelectedDomainLine'] = self.selected_domain_line
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SelectedDomainLine') is not None:
            self.selected_domain_line = m.get('SelectedDomainLine')
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv4Lines(TeaModel):
    def __init__(
        self,
        selected_ipv_4line: List[str] = None,
    ):
        self.selected_ipv_4line = selected_ipv_4line

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.selected_ipv_4line is not None:
            result['SelectedIpv4Line'] = self.selected_ipv_4line
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SelectedIpv4Line') is not None:
            self.selected_ipv_4line = m.get('SelectedIpv4Line')
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv6Lines(TeaModel):
    def __init__(
        self,
        selected_ipv_6line: List[str] = None,
    ):
        self.selected_ipv_6line = selected_ipv_6line

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.selected_ipv_6line is not None:
            result['SelectedIpv6Line'] = self.selected_ipv_6line
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SelectedIpv6Line') is not None:
            self.selected_ipv_6line = m.get('SelectedIpv6Line')
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponseBody(TeaModel):
    def __init__(
        self,
        domain_addr_pools: DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPools = None,
        ipv_4addr_pools: DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPools = None,
        ipv_6addr_pools: DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPools = None,
        lines: DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLines = None,
        request_id: str = None,
        selected_domain_lines: DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedDomainLines = None,
        selected_ipv_4lines: DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv4Lines = None,
        selected_ipv_6lines: DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv6Lines = None,
        suggest_set_default_line: bool = None,
    ):
        # The available address pools of the domain name type.
        self.domain_addr_pools = domain_addr_pools
        # The available address pools of the IPv4 type.
        self.ipv_4addr_pools = ipv_4addr_pools
        # The available address pools of the IPv6 type.
        self.ipv_6addr_pools = ipv_6addr_pools
        # The source regions.
        self.lines = lines
        # The ID of the request.
        self.request_id = request_id
        self.selected_domain_lines = selected_domain_lines
        self.selected_ipv_4lines = selected_ipv_4lines
        self.selected_ipv_6lines = selected_ipv_6lines
        # Indicates whether we recommend that you set the source region to global.
        self.suggest_set_default_line = suggest_set_default_line

    def validate(self):
        if self.domain_addr_pools:
            self.domain_addr_pools.validate()
        if self.ipv_4addr_pools:
            self.ipv_4addr_pools.validate()
        if self.ipv_6addr_pools:
            self.ipv_6addr_pools.validate()
        if self.lines:
            self.lines.validate()
        if self.selected_domain_lines:
            self.selected_domain_lines.validate()
        if self.selected_ipv_4lines:
            self.selected_ipv_4lines.validate()
        if self.selected_ipv_6lines:
            self.selected_ipv_6lines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_addr_pools is not None:
            result['DomainAddrPools'] = self.domain_addr_pools.to_map()
        if self.ipv_4addr_pools is not None:
            result['Ipv4AddrPools'] = self.ipv_4addr_pools.to_map()
        if self.ipv_6addr_pools is not None:
            result['Ipv6AddrPools'] = self.ipv_6addr_pools.to_map()
        if self.lines is not None:
            result['Lines'] = self.lines.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.selected_domain_lines is not None:
            result['SelectedDomainLines'] = self.selected_domain_lines.to_map()
        if self.selected_ipv_4lines is not None:
            result['SelectedIpv4Lines'] = self.selected_ipv_4lines.to_map()
        if self.selected_ipv_6lines is not None:
            result['SelectedIpv6Lines'] = self.selected_ipv_6lines.to_map()
        if self.suggest_set_default_line is not None:
            result['SuggestSetDefaultLine'] = self.suggest_set_default_line
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainAddrPools') is not None:
            temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyDomainAddrPools()
            self.domain_addr_pools = temp_model.from_map(m['DomainAddrPools'])
        if m.get('Ipv4AddrPools') is not None:
            temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv4AddrPools()
            self.ipv_4addr_pools = temp_model.from_map(m['Ipv4AddrPools'])
        if m.get('Ipv6AddrPools') is not None:
            temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyIpv6AddrPools()
            self.ipv_6addr_pools = temp_model.from_map(m['Ipv6AddrPools'])
        if m.get('Lines') is not None:
            temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodyLines()
            self.lines = temp_model.from_map(m['Lines'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SelectedDomainLines') is not None:
            temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedDomainLines()
            self.selected_domain_lines = temp_model.from_map(m['SelectedDomainLines'])
        if m.get('SelectedIpv4Lines') is not None:
            temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv4Lines()
            self.selected_ipv_4lines = temp_model.from_map(m['SelectedIpv4Lines'])
        if m.get('SelectedIpv6Lines') is not None:
            temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBodySelectedIpv6Lines()
            self.selected_ipv_6lines = temp_model.from_map(m['SelectedIpv6Lines'])
        if m.get('SuggestSetDefaultLine') is not None:
            self.suggest_set_default_line = m.get('SuggestSetDefaultLine')
        return self


class DescribeDnsGtmAccessStrategyAvailableConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmAccessStrategyAvailableConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmAccessStrategyAvailableConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmAddrAttributeInfoRequest(TeaModel):
    def __init__(
        self,
        addrs: str = None,
        lang: str = None,
        type: str = None,
    ):
        # The addresses whose source regions you want to query.
        self.addrs = addrs
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The type of the addresses. Valid values:
        # 
        # *   IPV4: IPv4 address
        # *   IPV6: IPv6 address
        # *   DOMAIN: domain name
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addrs is not None:
            result['Addrs'] = self.addrs
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addrs') is not None:
            self.addrs = m.get('Addrs')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo(TeaModel):
    def __init__(
        self,
        father_code: str = None,
        group_code: str = None,
        group_name: str = None,
        line_code: str = None,
        line_name: str = None,
    ):
        # The parent line code of the source region.
        self.father_code = father_code
        # The code of the source region group.
        self.group_code = group_code
        # The name of the source region group.
        self.group_name = group_name
        # The line code of the source region.
        self.line_code = line_code
        # The line name of the source region.
        self.line_name = line_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.father_code is not None:
            result['FatherCode'] = self.father_code
        if self.group_code is not None:
            result['GroupCode'] = self.group_code
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_name is not None:
            result['LineName'] = self.line_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FatherCode') is not None:
            self.father_code = m.get('FatherCode')
        if m.get('GroupCode') is not None:
            self.group_code = m.get('GroupCode')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        return self


class DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr(TeaModel):
    def __init__(
        self,
        addr: str = None,
        attribute_info: DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo = None,
    ):
        # The address that was queried.
        self.addr = addr
        # The source region of the address.
        self.attribute_info = attribute_info

    def validate(self):
        if self.attribute_info:
            self.attribute_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr is not None:
            result['Addr'] = self.addr
        if self.attribute_info is not None:
            result['AttributeInfo'] = self.attribute_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addr') is not None:
            self.addr = m.get('Addr')
        if m.get('AttributeInfo') is not None:
            temp_model = DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddrAttributeInfo()
            self.attribute_info = temp_model.from_map(m['AttributeInfo'])
        return self


class DescribeDnsGtmAddrAttributeInfoResponseBodyAddr(TeaModel):
    def __init__(
        self,
        addr: List[DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr] = None,
    ):
        self.addr = addr

    def validate(self):
        if self.addr:
            for k in self.addr:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Addr'] = []
        if self.addr is not None:
            for k in self.addr:
                result['Addr'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.addr = []
        if m.get('Addr') is not None:
            for k in m.get('Addr'):
                temp_model = DescribeDnsGtmAddrAttributeInfoResponseBodyAddrAddr()
                self.addr.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAddrAttributeInfoResponseBody(TeaModel):
    def __init__(
        self,
        addr: DescribeDnsGtmAddrAttributeInfoResponseBodyAddr = None,
        request_id: str = None,
    ):
        # The addresses that were queried.
        self.addr = addr
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.addr:
            self.addr.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr is not None:
            result['Addr'] = self.addr.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addr') is not None:
            temp_model = DescribeDnsGtmAddrAttributeInfoResponseBodyAddr()
            self.addr = temp_model.from_map(m['Addr'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDnsGtmAddrAttributeInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmAddrAttributeInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmAddrAttributeInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmAddressPoolAvailableConfigRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
    ):
        # The ID of the instance.
        self.instance_id = instance_id
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo(TeaModel):
    def __init__(
        self,
        father_code: str = None,
        group_code: str = None,
        group_name: str = None,
        line_code: str = None,
        line_name: str = None,
    ):
        # The parent line code of the source region.
        self.father_code = father_code
        # The code of the source region group.
        self.group_code = group_code
        # The name of the request source group.
        self.group_name = group_name
        # The line code of the source region.
        self.line_code = line_code
        # The line name of the source region.
        self.line_name = line_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.father_code is not None:
            result['FatherCode'] = self.father_code
        if self.group_code is not None:
            result['GroupCode'] = self.group_code
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_name is not None:
            result['LineName'] = self.line_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FatherCode') is not None:
            self.father_code = m.get('FatherCode')
        if m.get('GroupCode') is not None:
            self.group_code = m.get('GroupCode')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        return self


class DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfos(TeaModel):
    def __init__(
        self,
        attribute_info: List[DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo] = None,
    ):
        self.attribute_info = attribute_info

    def validate(self):
        if self.attribute_info:
            for k in self.attribute_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AttributeInfo'] = []
        if self.attribute_info is not None:
            for k in self.attribute_info:
                result['AttributeInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.attribute_info = []
        if m.get('AttributeInfo') is not None:
            for k in m.get('AttributeInfo'):
                temp_model = DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfosAttributeInfo()
                self.attribute_info.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmAddressPoolAvailableConfigResponseBody(TeaModel):
    def __init__(
        self,
        attribute_infos: DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfos = None,
        request_id: str = None,
    ):
        # The supported source regions.
        self.attribute_infos = attribute_infos
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.attribute_infos:
            self.attribute_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attribute_infos is not None:
            result['AttributeInfos'] = self.attribute_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AttributeInfos') is not None:
            temp_model = DescribeDnsGtmAddressPoolAvailableConfigResponseBodyAttributeInfos()
            self.attribute_infos = temp_model.from_map(m['AttributeInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDnsGtmAddressPoolAvailableConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmAddressPoolAvailableConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmAddressPoolAvailableConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmAvailableAlertGroupRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDnsGtmAvailableAlertGroupResponseBody(TeaModel):
    def __init__(
        self,
        available_alert_group: str = None,
        request_id: str = None,
    ):
        # The returned available alert groups.
        self.available_alert_group = available_alert_group
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_alert_group is not None:
            result['AvailableAlertGroup'] = self.available_alert_group
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableAlertGroup') is not None:
            self.available_alert_group = m.get('AvailableAlertGroup')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDnsGtmAvailableAlertGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmAvailableAlertGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmAvailableAlertGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
    ):
        # The ID of the instance about which you want to query the information.
        self.instance_id = instance_id
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig(TeaModel):
    def __init__(
        self,
        dingtalk_notice: bool = None,
        email_notice: bool = None,
        notice_type: str = None,
        sms_notice: bool = None,
    ):
        self.dingtalk_notice = dingtalk_notice
        # Indicates whether email notification is configured. Valid values:
        # 
        # *   true: Email notification is configured.
        # *   false: Email notification is not configured. null: Email notification is not configured.
        self.email_notice = email_notice
        # The type of the alert event. Valid values:
        # 
        # *   ADDR_ALERT: The address is unavailable.
        # *   ADDR_RESUME: The address is restored and becomes available.
        # *   ADDR_POOL_GROUP_UNAVAILABLE: The address pool group is unavailable.
        # *   ADDR_POOL_GROUP_AVAILABLE: The address pool group is restored and becomes available.
        # *   ACCESS_STRATEGY_POOL_GROUP_SWITCH: Switchover is triggered between the primary and secondary address pools.
        # *   MONITOR_NODE_IP_CHANGE: The IP address of the monitoring node has changed.
        self.notice_type = notice_type
        # Indicates whether SMS notification is configured. Valid values:
        # 
        # *   true: SMS notification is configured.
        # *   false: SMS notification is not configured. null: SMS notification is not configured.
        self.sms_notice = sms_notice

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dingtalk_notice is not None:
            result['DingtalkNotice'] = self.dingtalk_notice
        if self.email_notice is not None:
            result['EmailNotice'] = self.email_notice
        if self.notice_type is not None:
            result['NoticeType'] = self.notice_type
        if self.sms_notice is not None:
            result['SmsNotice'] = self.sms_notice
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DingtalkNotice') is not None:
            self.dingtalk_notice = m.get('DingtalkNotice')
        if m.get('EmailNotice') is not None:
            self.email_notice = m.get('EmailNotice')
        if m.get('NoticeType') is not None:
            self.notice_type = m.get('NoticeType')
        if m.get('SmsNotice') is not None:
            self.sms_notice = m.get('SmsNotice')
        return self


class DescribeDnsGtmInstanceResponseBodyConfigAlertConfig(TeaModel):
    def __init__(
        self,
        alert_config: List[DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig] = None,
    ):
        self.alert_config = alert_config

    def validate(self):
        if self.alert_config:
            for k in self.alert_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertConfig'] = []
        if self.alert_config is not None:
            for k in self.alert_config:
                result['AlertConfig'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_config = []
        if m.get('AlertConfig') is not None:
            for k in m.get('AlertConfig'):
                temp_model = DescribeDnsGtmInstanceResponseBodyConfigAlertConfigAlertConfig()
                self.alert_config.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmInstanceResponseBodyConfig(TeaModel):
    def __init__(
        self,
        alert_config: DescribeDnsGtmInstanceResponseBodyConfigAlertConfig = None,
        alert_group: str = None,
        cname_type: str = None,
        instance_name: str = None,
        pubic_zone_name: str = None,
        public_cname_mode: str = None,
        public_rr: str = None,
        public_user_domain_name: str = None,
        strategy_mode: str = None,
        ttl: int = None,
    ):
        # The alert notification method.
        self.alert_config = alert_config
        # The name of the alert group.
        self.alert_group = alert_group
        # The type of the CNAME domain name that is used to access the instance. Valid value:
        # 
        # *   PUBLIC: The CNAME domain name is used to access the instance over the Internet.
        self.cname_type = cname_type
        # The name of the instance.
        self.instance_name = instance_name
        # The domain name that is used to access the instance over the Internet.
        self.pubic_zone_name = pubic_zone_name
        # Indicates whether a custom CNAME domain name or a CNAME domain name assigned by the system is used to access the instance over the Internet. Valid values:
        # 
        # *   CUSTOM: A custom CNAME domain name is used.
        # *   SYSTEM_ASSIGN: A CNAME domain name assigned by the system is used.
        self.public_cname_mode = public_cname_mode
        # The hostname corresponding to the CNAME domain name that is used to access the instance over the Internet.
        self.public_rr = public_rr
        # The service domain name that is used over the Internet.
        self.public_user_domain_name = public_user_domain_name
        # The type of the access policy. Valid values:
        # 
        # *   LATENCY: Latency-based
        # *   GEO: Geographical location-based
        self.strategy_mode = strategy_mode
        # The global time to live (TTL).
        self.ttl = ttl

    def validate(self):
        if self.alert_config:
            self.alert_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alert_config is not None:
            result['AlertConfig'] = self.alert_config.to_map()
        if self.alert_group is not None:
            result['AlertGroup'] = self.alert_group
        if self.cname_type is not None:
            result['CnameType'] = self.cname_type
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.pubic_zone_name is not None:
            result['PubicZoneName'] = self.pubic_zone_name
        if self.public_cname_mode is not None:
            result['PublicCnameMode'] = self.public_cname_mode
        if self.public_rr is not None:
            result['PublicRr'] = self.public_rr
        if self.public_user_domain_name is not None:
            result['PublicUserDomainName'] = self.public_user_domain_name
        if self.strategy_mode is not None:
            result['StrategyMode'] = self.strategy_mode
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlertConfig') is not None:
            temp_model = DescribeDnsGtmInstanceResponseBodyConfigAlertConfig()
            self.alert_config = temp_model.from_map(m['AlertConfig'])
        if m.get('AlertGroup') is not None:
            self.alert_group = m.get('AlertGroup')
        if m.get('CnameType') is not None:
            self.cname_type = m.get('CnameType')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('PubicZoneName') is not None:
            self.pubic_zone_name = m.get('PubicZoneName')
        if m.get('PublicCnameMode') is not None:
            self.public_cname_mode = m.get('PublicCnameMode')
        if m.get('PublicRr') is not None:
            self.public_rr = m.get('PublicRr')
        if m.get('PublicUserDomainName') is not None:
            self.public_user_domain_name = m.get('PublicUserDomainName')
        if m.get('StrategyMode') is not None:
            self.strategy_mode = m.get('StrategyMode')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        return self


class DescribeDnsGtmInstanceResponseBodyUsedQuota(TeaModel):
    def __init__(
        self,
        dingtalk_used_count: int = None,
        email_used_count: int = None,
        sms_used_count: int = None,
        task_used_count: int = None,
    ):
        self.dingtalk_used_count = dingtalk_used_count
        # The total number of emails that were sent.
        self.email_used_count = email_used_count
        # The total number of short messages that were sent.
        self.sms_used_count = sms_used_count
        # The number of detection tasks that were created.
        self.task_used_count = task_used_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dingtalk_used_count is not None:
            result['DingtalkUsedCount'] = self.dingtalk_used_count
        if self.email_used_count is not None:
            result['EmailUsedCount'] = self.email_used_count
        if self.sms_used_count is not None:
            result['SmsUsedCount'] = self.sms_used_count
        if self.task_used_count is not None:
            result['TaskUsedCount'] = self.task_used_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DingtalkUsedCount') is not None:
            self.dingtalk_used_count = m.get('DingtalkUsedCount')
        if m.get('EmailUsedCount') is not None:
            self.email_used_count = m.get('EmailUsedCount')
        if m.get('SmsUsedCount') is not None:
            self.sms_used_count = m.get('SmsUsedCount')
        if m.get('TaskUsedCount') is not None:
            self.task_used_count = m.get('TaskUsedCount')
        return self


class DescribeDnsGtmInstanceResponseBody(TeaModel):
    def __init__(
        self,
        config: DescribeDnsGtmInstanceResponseBodyConfig = None,
        create_time: str = None,
        create_timestamp: int = None,
        expire_time: str = None,
        expire_timestamp: int = None,
        instance_id: str = None,
        payment_type: str = None,
        request_id: str = None,
        resource_group_id: str = None,
        sms_quota: int = None,
        task_quota: int = None,
        used_quota: DescribeDnsGtmInstanceResponseBodyUsedQuota = None,
        version_code: str = None,
    ):
        # The configurations of the instance.
        self.config = config
        # The time when the instance was created.
        self.create_time = create_time
        # The UNIX timestamp that indicates when the instance was created.
        self.create_timestamp = create_timestamp
        # The time when the instance expires.
        self.expire_time = expire_time
        # The UNIX timestamp that indicates when the instance expires.
        self.expire_timestamp = expire_timestamp
        # The ID of the instance.
        self.instance_id = instance_id
        # The billing method. Valid value:
        # 
        # *   Subscription: You can pay in advance for the use of resources.
        self.payment_type = payment_type
        # The ID of the request.
        self.request_id = request_id
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id
        # The total number of SMS notifications.
        self.sms_quota = sms_quota
        # The total number of detection tasks.
        self.task_quota = task_quota
        # The used quota.
        self.used_quota = used_quota
        # The version of the instance.
        self.version_code = version_code

    def validate(self):
        if self.config:
            self.config.validate()
        if self.used_quota:
            self.used_quota.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.expire_timestamp is not None:
            result['ExpireTimestamp'] = self.expire_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.payment_type is not None:
            result['PaymentType'] = self.payment_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sms_quota is not None:
            result['SmsQuota'] = self.sms_quota
        if self.task_quota is not None:
            result['TaskQuota'] = self.task_quota
        if self.used_quota is not None:
            result['UsedQuota'] = self.used_quota.to_map()
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            temp_model = DescribeDnsGtmInstanceResponseBodyConfig()
            self.config = temp_model.from_map(m['Config'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('ExpireTimestamp') is not None:
            self.expire_timestamp = m.get('ExpireTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PaymentType') is not None:
            self.payment_type = m.get('PaymentType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SmsQuota') is not None:
            self.sms_quota = m.get('SmsQuota')
        if m.get('TaskQuota') is not None:
            self.task_quota = m.get('TaskQuota')
        if m.get('UsedQuota') is not None:
            temp_model = DescribeDnsGtmInstanceResponseBodyUsedQuota()
            self.used_quota = temp_model.from_map(m['UsedQuota'])
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        return self


class DescribeDnsGtmInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmInstanceAddressPoolRequest(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        lang: str = None,
    ):
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The language of the values of specific response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr(TeaModel):
    def __init__(
        self,
        addr: str = None,
        alert_status: str = None,
        attribute_info: str = None,
        create_time: str = None,
        create_timestamp: int = None,
        lba_weight: int = None,
        mode: str = None,
        remark: str = None,
        update_time: str = None,
        update_timestamp: int = None,
    ):
        # The address.
        self.addr = addr
        # The status of the last health check on the address. Valid values:
        # 
        # *   OK: No active alerts are triggered.
        # *   ALERT: Alerts are triggered based on the alert rules.
        self.alert_status = alert_status
        # The source region of the address.
        # 
        # *   lineCode: the line code of the source region of the address. This parameter is deprecated, and lineCodes prevails.
        # *   lineName: the line name of the source region of the address. This parameter is deprecated.
        # *   lineCodes: the line codes of the source regions of the address.
        self.attribute_info = attribute_info
        # The time when the address was added into the address pool.
        self.create_time = create_time
        # The timestamp that indicates the time when the address was added into the address pool.
        self.create_timestamp = create_timestamp
        # The weight of the address.
        self.lba_weight = lba_weight
        # The mode of the address. Valid values:
        # 
        # *   SMART: smart return
        # *   ONLINE: always online
        # *   OFFLINE: always offline
        self.mode = mode
        # The description of the address.
        self.remark = remark
        # The time when the address was last updated.
        self.update_time = update_time
        # The timestamp that indicates the time when the address was last updated.
        self.update_timestamp = update_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr is not None:
            result['Addr'] = self.addr
        if self.alert_status is not None:
            result['AlertStatus'] = self.alert_status
        if self.attribute_info is not None:
            result['AttributeInfo'] = self.attribute_info
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.lba_weight is not None:
            result['LbaWeight'] = self.lba_weight
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Addr') is not None:
            self.addr = m.get('Addr')
        if m.get('AlertStatus') is not None:
            self.alert_status = m.get('AlertStatus')
        if m.get('AttributeInfo') is not None:
            self.attribute_info = m.get('AttributeInfo')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('LbaWeight') is not None:
            self.lba_weight = m.get('LbaWeight')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        return self


class DescribeDnsGtmInstanceAddressPoolResponseBodyAddrs(TeaModel):
    def __init__(
        self,
        addr: List[DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr] = None,
    ):
        self.addr = addr

    def validate(self):
        if self.addr:
            for k in self.addr:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Addr'] = []
        if self.addr is not None:
            for k in self.addr:
                result['Addr'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.addr = []
        if m.get('Addr') is not None:
            for k in m.get('Addr'):
                temp_model = DescribeDnsGtmInstanceAddressPoolResponseBodyAddrsAddr()
                self.addr.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmInstanceAddressPoolResponseBody(TeaModel):
    def __init__(
        self,
        addr_count: int = None,
        addr_pool_id: str = None,
        addrs: DescribeDnsGtmInstanceAddressPoolResponseBodyAddrs = None,
        create_time: str = None,
        create_timestamp: int = None,
        lba_strategy: str = None,
        monitor_config_id: str = None,
        monitor_status: str = None,
        name: str = None,
        request_id: str = None,
        type: str = None,
        update_time: str = None,
        update_timestamp: int = None,
    ):
        # The number of addresses in the address pool.
        self.addr_count = addr_count
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The addresses in the address pool.
        self.addrs = addrs
        # The time when the address pool was created.
        self.create_time = create_time
        # The timestamp that indicates the time when the address pool was created.
        self.create_timestamp = create_timestamp
        # The load balancing policy for the address pool. Valid values:
        # 
        # *   ALL_RR: returns all addresses.
        # *   RATIO: returns addresses by weight.
        self.lba_strategy = lba_strategy
        # The ID of the health check configuration.
        self.monitor_config_id = monitor_config_id
        # Indicates the status of the health check. Valid values:
        # 
        # *   OPEN: The health check is enabled.
        # *   CLOSE: The health check is disabled.
        # *   UNCONFIGURED: The health check is not configured.
        self.monitor_status = monitor_status
        # The name of the address pool.
        self.name = name
        # The ID of the request.
        self.request_id = request_id
        # The type of the address pool. Valid values:
        # 
        # *   IPV4: IPv4 address
        # *   IPV6: IPv6 address
        # *   DOMAIN: domain name
        self.type = type
        # The time when the address pool was last updated.
        self.update_time = update_time
        # The timestamp that indicates the time when the address pool was last updated.
        self.update_timestamp = update_timestamp

    def validate(self):
        if self.addrs:
            self.addrs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_count is not None:
            result['AddrCount'] = self.addr_count
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.addrs is not None:
            result['Addrs'] = self.addrs.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.lba_strategy is not None:
            result['LbaStrategy'] = self.lba_strategy
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        if self.monitor_status is not None:
            result['MonitorStatus'] = self.monitor_status
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrCount') is not None:
            self.addr_count = m.get('AddrCount')
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('Addrs') is not None:
            temp_model = DescribeDnsGtmInstanceAddressPoolResponseBodyAddrs()
            self.addrs = temp_model.from_map(m['Addrs'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('LbaStrategy') is not None:
            self.lba_strategy = m.get('LbaStrategy')
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        if m.get('MonitorStatus') is not None:
            self.monitor_status = m.get('MonitorStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        return self


class DescribeDnsGtmInstanceAddressPoolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmInstanceAddressPoolResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmInstanceAddressPoolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmInstanceAddressPoolsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the instance.
        self.instance_id = instance_id
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The number of the page to return. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: 100. Default value: 20.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool(TeaModel):
    def __init__(
        self,
        addr_count: int = None,
        addr_pool_id: str = None,
        create_time: str = None,
        create_timestamp: int = None,
        lba_strategy: str = None,
        monitor_config_id: str = None,
        monitor_status: str = None,
        name: str = None,
        type: str = None,
        update_time: str = None,
        update_timestamp: int = None,
    ):
        # The number of addresses in the address pool.
        self.addr_count = addr_count
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The time when the address pool was created.
        self.create_time = create_time
        # The timestamp that indicates when the address pool was created.
        self.create_timestamp = create_timestamp
        # The load balancing policy of the address pool. Valid values:
        # 
        # *   ALL_RR: returns all addresses.
        # *   RATIO: returns addresses by weight.
        self.lba_strategy = lba_strategy
        # The ID of the health check task.
        self.monitor_config_id = monitor_config_id
        # Indicates whether health checks are configured. Valid values:
        # 
        # *   OPEN: enabled
        # *   CLOSE: disabled
        # *   UNCONFIGURED: not configured
        self.monitor_status = monitor_status
        # The name of the address pool.
        self.name = name
        # The type of the address pool. Valid values:
        # 
        # *   IPV4: IPv4 address
        # *   IPV6: IPv6 address
        # *   DOMAIN: domain name
        self.type = type
        # The time when the address pool was updated.
        self.update_time = update_time
        # The timestamp that indicates when the address pool was updated.
        self.update_timestamp = update_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_count is not None:
            result['AddrCount'] = self.addr_count
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.lba_strategy is not None:
            result['LbaStrategy'] = self.lba_strategy
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        if self.monitor_status is not None:
            result['MonitorStatus'] = self.monitor_status
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrCount') is not None:
            self.addr_count = m.get('AddrCount')
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('LbaStrategy') is not None:
            self.lba_strategy = m.get('LbaStrategy')
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        if m.get('MonitorStatus') is not None:
            self.monitor_status = m.get('MonitorStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        return self


class DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPools(TeaModel):
    def __init__(
        self,
        addr_pool: List[DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool] = None,
    ):
        self.addr_pool = addr_pool

    def validate(self):
        if self.addr_pool:
            for k in self.addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AddrPool'] = []
        if self.addr_pool is not None:
            for k in self.addr_pool:
                result['AddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.addr_pool = []
        if m.get('AddrPool') is not None:
            for k in m.get('AddrPool'):
                temp_model = DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool()
                self.addr_pool.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmInstanceAddressPoolsResponseBody(TeaModel):
    def __init__(
        self,
        addr_pools: DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPools = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The returned address pools.
        self.addr_pools = addr_pools
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned on all pages.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.addr_pools:
            self.addr_pools.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pools is not None:
            result['AddrPools'] = self.addr_pools.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPools') is not None:
            temp_model = DescribeDnsGtmInstanceAddressPoolsResponseBodyAddrPools()
            self.addr_pools = temp_model.from_map(m['AddrPools'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeDnsGtmInstanceAddressPoolsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmInstanceAddressPoolsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmInstanceAddressPoolsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmInstanceStatusRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
    ):
        # The ID of the instance.
        self.instance_id = instance_id
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDnsGtmInstanceStatusResponseBody(TeaModel):
    def __init__(
        self,
        addr_available_num: int = None,
        addr_not_available_num: int = None,
        addr_pool_group_not_available_num: int = None,
        request_id: str = None,
        strategy_not_available_num: int = None,
        switch_to_failover_strategy_num: int = None,
    ):
        # The number of available addresses.
        self.addr_available_num = addr_available_num
        # The number of unavailable addresses.
        self.addr_not_available_num = addr_not_available_num
        # The number of unavailable address pool groups.
        self.addr_pool_group_not_available_num = addr_pool_group_not_available_num
        # The ID of the request.
        self.request_id = request_id
        # The number of access policies that are unavailable in the current active address pool group.
        self.strategy_not_available_num = strategy_not_available_num
        # The number of access policies switched to the secondary address pool group.
        self.switch_to_failover_strategy_num = switch_to_failover_strategy_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_available_num is not None:
            result['AddrAvailableNum'] = self.addr_available_num
        if self.addr_not_available_num is not None:
            result['AddrNotAvailableNum'] = self.addr_not_available_num
        if self.addr_pool_group_not_available_num is not None:
            result['AddrPoolGroupNotAvailableNum'] = self.addr_pool_group_not_available_num
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategy_not_available_num is not None:
            result['StrategyNotAvailableNum'] = self.strategy_not_available_num
        if self.switch_to_failover_strategy_num is not None:
            result['SwitchToFailoverStrategyNum'] = self.switch_to_failover_strategy_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrAvailableNum') is not None:
            self.addr_available_num = m.get('AddrAvailableNum')
        if m.get('AddrNotAvailableNum') is not None:
            self.addr_not_available_num = m.get('AddrNotAvailableNum')
        if m.get('AddrPoolGroupNotAvailableNum') is not None:
            self.addr_pool_group_not_available_num = m.get('AddrPoolGroupNotAvailableNum')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StrategyNotAvailableNum') is not None:
            self.strategy_not_available_num = m.get('StrategyNotAvailableNum')
        if m.get('SwitchToFailoverStrategyNum') is not None:
            self.switch_to_failover_strategy_num = m.get('SwitchToFailoverStrategyNum')
        return self


class DescribeDnsGtmInstanceStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmInstanceStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmInstanceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmInstanceSystemCnameRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
    ):
        # The ID of the instance.
        self.instance_id = instance_id
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDnsGtmInstanceSystemCnameResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        system_cname: str = None,
    ):
        self.request_id = request_id
        # The CNAME domain name assigned by the system.
        self.system_cname = system_cname

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.system_cname is not None:
            result['SystemCname'] = self.system_cname
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SystemCname') is not None:
            self.system_cname = m.get('SystemCname')
        return self


class DescribeDnsGtmInstanceSystemCnameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmInstanceSystemCnameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmInstanceSystemCnameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmInstancesRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_group_id: str = None,
    ):
        # The keyword that you use for query. Fuzzy search by instance ID or instance name is supported.
        self.keyword = keyword
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return on each page.
        self.page_size = page_size
        # The ID of the resource group where you want to query instances.
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig(TeaModel):
    def __init__(
        self,
        dingtalk_notice: str = None,
        email_notice: str = None,
        notice_type: str = None,
        sms_notice: str = None,
    ):
        self.dingtalk_notice = dingtalk_notice
        # Indicates whether email notifications were configured. Valid values:
        # 
        # *   true: configured
        # *   false | null: not configured
        self.email_notice = email_notice
        # The type of the alert event. Valid values:
        # 
        # *   ADDR_ALERT: The address is unavailable.
        # *   ADDR_RESUME: The address is restored and becomes available.
        # *   ADDR_POOL_GROUP_UNAVAILABLE: The address pool group is unavailable.
        # *   ADDR_POOL_GROUP_AVAILABLE: The address pool group is restored and becomes available.
        # *   ACCESS_STRATEGY_POOL_GROUP_SWITCH: Switchover is triggered between the primary and secondary address pools.
        self.notice_type = notice_type
        # Indicates whether SMS notifications were configured. Valid values:
        # 
        # *   true: configured
        # *   false | null: not configured
        self.sms_notice = sms_notice

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dingtalk_notice is not None:
            result['DingtalkNotice'] = self.dingtalk_notice
        if self.email_notice is not None:
            result['EmailNotice'] = self.email_notice
        if self.notice_type is not None:
            result['NoticeType'] = self.notice_type
        if self.sms_notice is not None:
            result['SmsNotice'] = self.sms_notice
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DingtalkNotice') is not None:
            self.dingtalk_notice = m.get('DingtalkNotice')
        if m.get('EmailNotice') is not None:
            self.email_notice = m.get('EmailNotice')
        if m.get('NoticeType') is not None:
            self.notice_type = m.get('NoticeType')
        if m.get('SmsNotice') is not None:
            self.sms_notice = m.get('SmsNotice')
        return self


class DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig(TeaModel):
    def __init__(
        self,
        alert_config: List[DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig] = None,
        alert_group: str = None,
        cname_type: str = None,
        instance_name: str = None,
        public_cname_mode: str = None,
        public_rr: str = None,
        public_user_domain_name: str = None,
        public_zone_name: str = None,
        strategy_mode: str = None,
        ttl: int = None,
    ):
        # The alert notification methods.
        self.alert_config = alert_config
        # The alert group.
        self.alert_group = alert_group
        # The access type of the CNAME domain name.
        # 
        # *   The value was set to PUBLIC, which indicates Internet access.
        self.cname_type = cname_type
        # The name of the instance.
        self.instance_name = instance_name
        # Indicates whether a custom CNAME domain name or a CNAME domain name assigned by the system is used to access GTM over the Internet. Valid values:
        # 
        # *   CUSTOM: a custom CNAME domain name
        # *   SYSTEM_ASSIGN: a CNAME domain name assigned by the system
        self.public_cname_mode = public_cname_mode
        self.public_rr = public_rr
        # The website domain name that the user uses on the Internet.
        self.public_user_domain_name = public_user_domain_name
        # The domain name that is used to access GTM over the Internet.
        self.public_zone_name = public_zone_name
        # The type of the access policy. Valid values:
        # 
        # *   LATENCY: latency-based
        # *   GEO: geographical location-based
        self.strategy_mode = strategy_mode
        # The global time to live (TTL).
        self.ttl = ttl

    def validate(self):
        if self.alert_config:
            for k in self.alert_config:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlertConfig'] = []
        if self.alert_config is not None:
            for k in self.alert_config:
                result['AlertConfig'].append(k.to_map() if k else None)
        if self.alert_group is not None:
            result['AlertGroup'] = self.alert_group
        if self.cname_type is not None:
            result['CnameType'] = self.cname_type
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.public_cname_mode is not None:
            result['PublicCnameMode'] = self.public_cname_mode
        if self.public_rr is not None:
            result['PublicRr'] = self.public_rr
        if self.public_user_domain_name is not None:
            result['PublicUserDomainName'] = self.public_user_domain_name
        if self.public_zone_name is not None:
            result['PublicZoneName'] = self.public_zone_name
        if self.strategy_mode is not None:
            result['StrategyMode'] = self.strategy_mode
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alert_config = []
        if m.get('AlertConfig') is not None:
            for k in m.get('AlertConfig'):
                temp_model = DescribeDnsGtmInstancesResponseBodyGtmInstancesConfigAlertConfig()
                self.alert_config.append(temp_model.from_map(k))
        if m.get('AlertGroup') is not None:
            self.alert_group = m.get('AlertGroup')
        if m.get('CnameType') is not None:
            self.cname_type = m.get('CnameType')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('PublicCnameMode') is not None:
            self.public_cname_mode = m.get('PublicCnameMode')
        if m.get('PublicRr') is not None:
            self.public_rr = m.get('PublicRr')
        if m.get('PublicUserDomainName') is not None:
            self.public_user_domain_name = m.get('PublicUserDomainName')
        if m.get('PublicZoneName') is not None:
            self.public_zone_name = m.get('PublicZoneName')
        if m.get('StrategyMode') is not None:
            self.strategy_mode = m.get('StrategyMode')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        return self


class DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota(TeaModel):
    def __init__(
        self,
        dingtalk_used_count: int = None,
        email_used_count: int = None,
        sms_used_count: int = None,
        task_used_count: int = None,
    ):
        self.dingtalk_used_count = dingtalk_used_count
        # The total number of email notifications that were sent.
        self.email_used_count = email_used_count
        # The total number of SMS notifications that were sent.
        self.sms_used_count = sms_used_count
        # The number of detection tasks that were created.
        self.task_used_count = task_used_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dingtalk_used_count is not None:
            result['DingtalkUsedCount'] = self.dingtalk_used_count
        if self.email_used_count is not None:
            result['EmailUsedCount'] = self.email_used_count
        if self.sms_used_count is not None:
            result['SmsUsedCount'] = self.sms_used_count
        if self.task_used_count is not None:
            result['TaskUsedCount'] = self.task_used_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DingtalkUsedCount') is not None:
            self.dingtalk_used_count = m.get('DingtalkUsedCount')
        if m.get('EmailUsedCount') is not None:
            self.email_used_count = m.get('EmailUsedCount')
        if m.get('SmsUsedCount') is not None:
            self.sms_used_count = m.get('SmsUsedCount')
        if m.get('TaskUsedCount') is not None:
            self.task_used_count = m.get('TaskUsedCount')
        return self


class DescribeDnsGtmInstancesResponseBodyGtmInstances(TeaModel):
    def __init__(
        self,
        config: DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig = None,
        create_time: str = None,
        create_timestamp: int = None,
        expire_time: str = None,
        expire_timestamp: int = None,
        instance_id: str = None,
        payment_type: str = None,
        resource_group_id: str = None,
        sms_quota: int = None,
        task_quota: int = None,
        used_quota: DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota = None,
        version_code: str = None,
    ):
        # The configurations of the instance.
        self.config = config
        # The time when the instance was created.
        self.create_time = create_time
        # The timestamp that indicates when the instance was created.
        self.create_timestamp = create_timestamp
        # The time when the instance expires.
        self.expire_time = expire_time
        # The timestamp that indicates when the instance expires.
        self.expire_timestamp = expire_timestamp
        # The ID of the instance.
        self.instance_id = instance_id
        # The billing method of the instance.
        # 
        # *   The value is set to Subscription.
        self.payment_type = payment_type
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id
        # The total number of SMS notifications.
        self.sms_quota = sms_quota
        # The total number of detection tasks.
        self.task_quota = task_quota
        # The used quota.
        self.used_quota = used_quota
        # The version of the instance.
        self.version_code = version_code

    def validate(self):
        if self.config:
            self.config.validate()
        if self.used_quota:
            self.used_quota.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.expire_timestamp is not None:
            result['ExpireTimestamp'] = self.expire_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.payment_type is not None:
            result['PaymentType'] = self.payment_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.sms_quota is not None:
            result['SmsQuota'] = self.sms_quota
        if self.task_quota is not None:
            result['TaskQuota'] = self.task_quota
        if self.used_quota is not None:
            result['UsedQuota'] = self.used_quota.to_map()
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            temp_model = DescribeDnsGtmInstancesResponseBodyGtmInstancesConfig()
            self.config = temp_model.from_map(m['Config'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('ExpireTimestamp') is not None:
            self.expire_timestamp = m.get('ExpireTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PaymentType') is not None:
            self.payment_type = m.get('PaymentType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SmsQuota') is not None:
            self.sms_quota = m.get('SmsQuota')
        if m.get('TaskQuota') is not None:
            self.task_quota = m.get('TaskQuota')
        if m.get('UsedQuota') is not None:
            temp_model = DescribeDnsGtmInstancesResponseBodyGtmInstancesUsedQuota()
            self.used_quota = temp_model.from_map(m['UsedQuota'])
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        return self


class DescribeDnsGtmInstancesResponseBody(TeaModel):
    def __init__(
        self,
        gtm_instances: List[DescribeDnsGtmInstancesResponseBodyGtmInstances] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The returned instances.
        self.gtm_instances = gtm_instances
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned on all pages.
        self.total_items = total_items
        # The total number of returned pages.
        self.total_pages = total_pages

    def validate(self):
        if self.gtm_instances:
            for k in self.gtm_instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GtmInstances'] = []
        if self.gtm_instances is not None:
            for k in self.gtm_instances:
                result['GtmInstances'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.gtm_instances = []
        if m.get('GtmInstances') is not None:
            for k in m.get('GtmInstances'):
                temp_model = DescribeDnsGtmInstancesResponseBodyGtmInstances()
                self.gtm_instances.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeDnsGtmInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmLogsRequest(TeaModel):
    def __init__(
        self,
        end_timestamp: int = None,
        instance_id: str = None,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        start_timestamp: int = None,
    ):
        # The timestamp that specifies the end of the time range to query.
        self.end_timestamp = end_timestamp
        # The ID of the instance.
        self.instance_id = instance_id
        # The keyword for searches in "%KeyWord%" mode. The value is not case-sensitive.
        self.keyword = keyword
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The number of the page to return. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: 100. Default value: 20.
        self.page_size = page_size
        # The timestamp that specifies the beginning of the time range to query.
        self.start_timestamp = start_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_timestamp is not None:
            result['EndTimestamp'] = self.end_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_timestamp is not None:
            result['StartTimestamp'] = self.start_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTimestamp') is not None:
            self.end_timestamp = m.get('EndTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTimestamp') is not None:
            self.start_timestamp = m.get('StartTimestamp')
        return self


class DescribeDnsGtmLogsResponseBodyLogsLog(TeaModel):
    def __init__(
        self,
        content: str = None,
        entity_id: str = None,
        entity_name: str = None,
        entity_type: str = None,
        id: int = None,
        oper_action: str = None,
        oper_time: str = None,
        oper_timestamp: int = None,
    ):
        # The formatted message content.
        self.content = content
        # The ID of the object on which the operation was performed.
        self.entity_id = entity_id
        # The name of the object on which the operation was performed.
        self.entity_name = entity_name
        # The type of the object on which the operation was performed.
        self.entity_type = entity_type
        # The ID of the record.
        self.id = id
        # The operation performed.
        self.oper_action = oper_action
        # The time when the operation was performed.
        self.oper_time = oper_time
        # The timestamp of the operation.
        self.oper_timestamp = oper_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.entity_name is not None:
            result['EntityName'] = self.entity_name
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.id is not None:
            result['Id'] = self.id
        if self.oper_action is not None:
            result['OperAction'] = self.oper_action
        if self.oper_time is not None:
            result['OperTime'] = self.oper_time
        if self.oper_timestamp is not None:
            result['OperTimestamp'] = self.oper_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('EntityName') is not None:
            self.entity_name = m.get('EntityName')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('OperAction') is not None:
            self.oper_action = m.get('OperAction')
        if m.get('OperTime') is not None:
            self.oper_time = m.get('OperTime')
        if m.get('OperTimestamp') is not None:
            self.oper_timestamp = m.get('OperTimestamp')
        return self


class DescribeDnsGtmLogsResponseBodyLogs(TeaModel):
    def __init__(
        self,
        log: List[DescribeDnsGtmLogsResponseBodyLogsLog] = None,
    ):
        self.log = log

    def validate(self):
        if self.log:
            for k in self.log:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Log'] = []
        if self.log is not None:
            for k in self.log:
                result['Log'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.log = []
        if m.get('Log') is not None:
            for k in m.get('Log'):
                temp_model = DescribeDnsGtmLogsResponseBodyLogsLog()
                self.log.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmLogsResponseBody(TeaModel):
    def __init__(
        self,
        logs: DescribeDnsGtmLogsResponseBodyLogs = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The returned logs.
        self.logs = logs
        # The number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned on all pages.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.logs:
            self.logs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logs is not None:
            result['Logs'] = self.logs.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Logs') is not None:
            temp_model = DescribeDnsGtmLogsResponseBodyLogs()
            self.logs = temp_model.from_map(m['Logs'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeDnsGtmLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmLogsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmMonitorAvailableConfigRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language of the values of specific response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNodeIps(TeaModel):
    def __init__(
        self,
        ip: List[str] = None,
    ):
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        default_selected: bool = None,
        group_name: str = None,
        group_type: str = None,
        ips: DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNodeIps = None,
        isp_code: str = None,
        isp_name: str = None,
    ):
        # The code of the city where the monitored node is deployed.
        self.city_code = city_code
        # The display name of the city where the monitored node is deployed.
        self.city_name = city_name
        # Indicates whether the monitored node is selected for the health check by default.
        self.default_selected = default_selected
        # The name of the group to which the monitored node belongs.
        self.group_name = group_name
        # The type of the group to which the monitored node belongs. Valid values:
        # 
        # *   BGP: BGP nodes
        # *   OVERSEAS: nodes outside the Chinese mainland
        # *   ISP: ISP nodes
        self.group_type = group_type
        self.ips = ips
        # The code of the ISP to which the monitored node belongs.
        self.isp_code = isp_code
        # The display name of the ISP to which the monitored node belongs.
        self.isp_name = isp_name

    def validate(self):
        if self.ips:
            self.ips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.default_selected is not None:
            result['DefaultSelected'] = self.default_selected
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.ips is not None:
            result['Ips'] = self.ips.to_map()
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('DefaultSelected') is not None:
            self.default_selected = m.get('DefaultSelected')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('Ips') is not None:
            temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNodeIps()
            self.ips = temp_model.from_map(m['Ips'])
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodes(TeaModel):
    def __init__(
        self,
        domain_ipv_4isp_city_node: List[DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode] = None,
    ):
        self.domain_ipv_4isp_city_node = domain_ipv_4isp_city_node

    def validate(self):
        if self.domain_ipv_4isp_city_node:
            for k in self.domain_ipv_4isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainIpv4IspCityNode'] = []
        if self.domain_ipv_4isp_city_node is not None:
            for k in self.domain_ipv_4isp_city_node:
                result['DomainIpv4IspCityNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_ipv_4isp_city_node = []
        if m.get('DomainIpv4IspCityNode') is not None:
            for k in m.get('DomainIpv4IspCityNode'):
                temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodesDomainIpv4IspCityNode()
                self.domain_ipv_4isp_city_node.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNodeIps(TeaModel):
    def __init__(
        self,
        ip: List[str] = None,
    ):
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        default_selected: bool = None,
        group_name: str = None,
        group_type: str = None,
        ips: DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNodeIps = None,
        isp_code: str = None,
        isp_name: str = None,
    ):
        # The code of the city where the monitored node is deployed.
        self.city_code = city_code
        # The display name of the city where the monitored node is deployed.
        self.city_name = city_name
        # Indicates whether the monitored node is selected for the health check by default.
        self.default_selected = default_selected
        # The name of the group to which the monitored node belongs.
        self.group_name = group_name
        # The type of the group to which the monitored node belongs. Valid values:
        # 
        # *   BGP: BGP nodes
        # *   OVERSEAS: nodes outside the Chinese mainland
        # *   ISP: ISP nodes
        self.group_type = group_type
        self.ips = ips
        # The code of the ISP to which the monitored node belongs.
        self.isp_code = isp_code
        # The display name of the ISP to which the monitored node belongs.
        self.isp_name = isp_name

    def validate(self):
        if self.ips:
            self.ips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.default_selected is not None:
            result['DefaultSelected'] = self.default_selected
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.ips is not None:
            result['Ips'] = self.ips.to_map()
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('DefaultSelected') is not None:
            self.default_selected = m.get('DefaultSelected')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('Ips') is not None:
            temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNodeIps()
            self.ips = temp_model.from_map(m['Ips'])
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodes(TeaModel):
    def __init__(
        self,
        domain_ipv_6isp_city_node: List[DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode] = None,
    ):
        self.domain_ipv_6isp_city_node = domain_ipv_6isp_city_node

    def validate(self):
        if self.domain_ipv_6isp_city_node:
            for k in self.domain_ipv_6isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainIpv6IspCityNode'] = []
        if self.domain_ipv_6isp_city_node is not None:
            for k in self.domain_ipv_6isp_city_node:
                result['DomainIpv6IspCityNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_ipv_6isp_city_node = []
        if m.get('DomainIpv6IspCityNode') is not None:
            for k in m.get('DomainIpv6IspCityNode'):
                temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodesDomainIpv6IspCityNode()
                self.domain_ipv_6isp_city_node.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNodeIps(TeaModel):
    def __init__(
        self,
        ip: List[str] = None,
    ):
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        default_selected: bool = None,
        group_name: str = None,
        group_type: str = None,
        ips: DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNodeIps = None,
        isp_code: str = None,
        isp_name: str = None,
    ):
        # The code of the city where the monitored node is deployed.
        self.city_code = city_code
        # The display name of the city where the monitored node is deployed.
        self.city_name = city_name
        # Indicates whether the monitored node is selected for the health check by default.
        self.default_selected = default_selected
        # The name of the group to which the monitored node belongs.
        self.group_name = group_name
        # The type of the group to which the monitored node belongs. Valid values:
        # 
        # *   BGP: Border Gateway Protocol (BGP) nodes
        # *   OVERSEAS: nodes outside the Chinese mainland
        # *   ISP: ISP nodes
        self.group_type = group_type
        self.ips = ips
        # The code of the Internet service provider (ISP) to which the monitored node belongs.
        self.isp_code = isp_code
        # The display name of the ISP to which the monitored node belongs.
        self.isp_name = isp_name

    def validate(self):
        if self.ips:
            self.ips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.default_selected is not None:
            result['DefaultSelected'] = self.default_selected
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.ips is not None:
            result['Ips'] = self.ips.to_map()
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('DefaultSelected') is not None:
            self.default_selected = m.get('DefaultSelected')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('Ips') is not None:
            temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNodeIps()
            self.ips = temp_model.from_map(m['Ips'])
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodes(TeaModel):
    def __init__(
        self,
        ipv_4isp_city_node: List[DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode] = None,
    ):
        self.ipv_4isp_city_node = ipv_4isp_city_node

    def validate(self):
        if self.ipv_4isp_city_node:
            for k in self.ipv_4isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ipv4IspCityNode'] = []
        if self.ipv_4isp_city_node is not None:
            for k in self.ipv_4isp_city_node:
                result['Ipv4IspCityNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_4isp_city_node = []
        if m.get('Ipv4IspCityNode') is not None:
            for k in m.get('Ipv4IspCityNode'):
                temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodesIpv4IspCityNode()
                self.ipv_4isp_city_node.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNodeIps(TeaModel):
    def __init__(
        self,
        ip: List[str] = None,
    ):
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        default_selected: bool = None,
        group_name: str = None,
        group_type: str = None,
        ips: DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNodeIps = None,
        isp_code: str = None,
        isp_name: str = None,
    ):
        # The code of the city where the monitored node is deployed.
        self.city_code = city_code
        # The display name of the city where the monitored node is deployed.
        self.city_name = city_name
        # Indicates whether the monitored node is selected for the health check by default.
        self.default_selected = default_selected
        # The name of the group to which the monitored node belongs.
        self.group_name = group_name
        # The type of the group to which the monitored node belongs. Valid values:
        # 
        # *   BGP: BGP nodes
        # *   OVERSEAS: nodes outside the Chinese mainland
        # *   ISP: ISP nodes
        self.group_type = group_type
        self.ips = ips
        # The code of the ISP to which the monitored node belongs.
        self.isp_code = isp_code
        # The display name of the ISP to which the monitored node belongs.
        self.isp_name = isp_name

    def validate(self):
        if self.ips:
            self.ips.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.default_selected is not None:
            result['DefaultSelected'] = self.default_selected
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.ips is not None:
            result['Ips'] = self.ips.to_map()
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('DefaultSelected') is not None:
            self.default_selected = m.get('DefaultSelected')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('Ips') is not None:
            temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNodeIps()
            self.ips = temp_model.from_map(m['Ips'])
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodes(TeaModel):
    def __init__(
        self,
        ipv_6isp_city_node: List[DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode] = None,
    ):
        self.ipv_6isp_city_node = ipv_6isp_city_node

    def validate(self):
        if self.ipv_6isp_city_node:
            for k in self.ipv_6isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Ipv6IspCityNode'] = []
        if self.ipv_6isp_city_node is not None:
            for k in self.ipv_6isp_city_node:
                result['Ipv6IspCityNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ipv_6isp_city_node = []
        if m.get('Ipv6IspCityNode') is not None:
            for k in m.get('Ipv6IspCityNode'):
                temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodesIpv6IspCityNode()
                self.ipv_6isp_city_node.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmMonitorAvailableConfigResponseBody(TeaModel):
    def __init__(
        self,
        domain_ipv_4isp_city_nodes: DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodes = None,
        domain_ipv_6isp_city_nodes: DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodes = None,
        ipv_4isp_city_nodes: DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodes = None,
        ipv_6isp_city_nodes: DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodes = None,
        request_id: str = None,
    ):
        # The monitored nodes that can be used to perform health checks on address pools that contain public domain names that are resolved to IPv4 addresses.
        self.domain_ipv_4isp_city_nodes = domain_ipv_4isp_city_nodes
        # The monitored nodes that can be used to perform health checks on address pools that contain public domain names that are resolved to IPv6 addresses.
        self.domain_ipv_6isp_city_nodes = domain_ipv_6isp_city_nodes
        # The monitored nodes that can be used to perform health checks on address pools that contain public IPv4 addresses.
        self.ipv_4isp_city_nodes = ipv_4isp_city_nodes
        # The monitored nodes that can be used to perform health checks on address pools that contain public IPv6 addresses.
        self.ipv_6isp_city_nodes = ipv_6isp_city_nodes
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.domain_ipv_4isp_city_nodes:
            self.domain_ipv_4isp_city_nodes.validate()
        if self.domain_ipv_6isp_city_nodes:
            self.domain_ipv_6isp_city_nodes.validate()
        if self.ipv_4isp_city_nodes:
            self.ipv_4isp_city_nodes.validate()
        if self.ipv_6isp_city_nodes:
            self.ipv_6isp_city_nodes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_ipv_4isp_city_nodes is not None:
            result['DomainIpv4IspCityNodes'] = self.domain_ipv_4isp_city_nodes.to_map()
        if self.domain_ipv_6isp_city_nodes is not None:
            result['DomainIpv6IspCityNodes'] = self.domain_ipv_6isp_city_nodes.to_map()
        if self.ipv_4isp_city_nodes is not None:
            result['Ipv4IspCityNodes'] = self.ipv_4isp_city_nodes.to_map()
        if self.ipv_6isp_city_nodes is not None:
            result['Ipv6IspCityNodes'] = self.ipv_6isp_city_nodes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainIpv4IspCityNodes') is not None:
            temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv4IspCityNodes()
            self.domain_ipv_4isp_city_nodes = temp_model.from_map(m['DomainIpv4IspCityNodes'])
        if m.get('DomainIpv6IspCityNodes') is not None:
            temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyDomainIpv6IspCityNodes()
            self.domain_ipv_6isp_city_nodes = temp_model.from_map(m['DomainIpv6IspCityNodes'])
        if m.get('Ipv4IspCityNodes') is not None:
            temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv4IspCityNodes()
            self.ipv_4isp_city_nodes = temp_model.from_map(m['Ipv4IspCityNodes'])
        if m.get('Ipv6IspCityNodes') is not None:
            temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBodyIpv6IspCityNodes()
            self.ipv_6isp_city_nodes = temp_model.from_map(m['Ipv6IspCityNodes'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDnsGtmMonitorAvailableConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmMonitorAvailableConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmMonitorAvailableConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsGtmMonitorConfigRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        monitor_config_id: str = None,
    ):
        # The language of the values of specific response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The ID of the health check task.
        self.monitor_config_id = monitor_config_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        return self


class DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        country_code: str = None,
        country_name: str = None,
        isp_code: str = None,
        isp_name: str = None,
    ):
        # The code of the monitored city node.
        self.city_code = city_code
        # The display name of the monitored city node.
        self.city_name = city_name
        # The code of the country or region.
        self.country_code = country_code
        # The display name of the country or region.
        self.country_name = country_name
        # The code of the monitored Internet service provider (ISP) node.
        self.isp_code = isp_code
        # The name of the ISP.
        self.isp_name = isp_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.country_code is not None:
            result['CountryCode'] = self.country_code
        if self.country_name is not None:
            result['CountryName'] = self.country_name
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('CountryCode') is not None:
            self.country_code = m.get('CountryCode')
        if m.get('CountryName') is not None:
            self.country_name = m.get('CountryName')
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        return self


class DescribeDnsGtmMonitorConfigResponseBodyIspCityNodes(TeaModel):
    def __init__(
        self,
        isp_city_node: List[DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode] = None,
    ):
        self.isp_city_node = isp_city_node

    def validate(self):
        if self.isp_city_node:
            for k in self.isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IspCityNode'] = []
        if self.isp_city_node is not None:
            for k in self.isp_city_node:
                result['IspCityNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.isp_city_node = []
        if m.get('IspCityNode') is not None:
            for k in m.get('IspCityNode'):
                temp_model = DescribeDnsGtmMonitorConfigResponseBodyIspCityNodesIspCityNode()
                self.isp_city_node.append(temp_model.from_map(k))
        return self


class DescribeDnsGtmMonitorConfigResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_timestamp: int = None,
        evaluation_count: int = None,
        interval: int = None,
        isp_city_nodes: DescribeDnsGtmMonitorConfigResponseBodyIspCityNodes = None,
        monitor_config_id: str = None,
        monitor_extend_info: str = None,
        protocol_type: str = None,
        request_id: str = None,
        timeout: int = None,
        update_time: str = None,
        update_timestamp: int = None,
    ):
        # The time when the health check task was created.
        self.create_time = create_time
        # The timestamp that indicates when the health check task was created.
        self.create_timestamp = create_timestamp
        # The number of consecutive times of failed health check attempts.
        self.evaluation_count = evaluation_count
        # The interval at which the health check task is executed. Unit: seconds.
        self.interval = interval
        # The monitored node.
        self.isp_city_nodes = isp_city_nodes
        # The ID of the health check task.
        self.monitor_config_id = monitor_config_id
        # The extended information. The following parameters are required for different health check protocols:
        # 
        # *   HTTP or HTTPS:
        # 
        #     *   port: the check port.
        # 
        #     *   host: the host settings.
        # 
        #     *   path: the URL path.
        # 
        #     *   code: the return code greater than the specified value.
        # 
        #     *   failureRate: the failure rate.
        # 
        #     *   sni: specifies whether to enable server name indication (SNI). This parameter is used only for the HTTPS protocol. Valid values:
        # 
        #         *   true: enable SNI.
        #         *   false: disable SNI.
        # 
        #     *   nodeType: the type of the node to monitor when the address pool type is DOMAIN. Valid values:
        # 
        #         *   IPV4
        #         *   IPV6
        # 
        # *   PING:
        # 
        #     *   failureRate: the failure rate.
        # 
        #     *   packetNum: the number of ping packets.
        # 
        #     *   packetLossRate: the loss rate of ping packets.
        # 
        #     *   nodeType: the type of the node to monitor when the address pool type is DOMAIN. Valid values:
        # 
        #         *   IPV4
        #         *   IPV6
        # 
        # *   TCP:
        # 
        #     *   port: the check port.
        # 
        #     *   failureRate: the failure rate.
        # 
        #     *   nodeType: the type of the node to monitor when the address pool type is DOMAIN. Valid values:
        # 
        #         *   IPV4
        #         *   IPV6
        self.monitor_extend_info = monitor_extend_info
        # The health check protocol. Valid values:
        # 
        # *   HTTP
        # *   HTTPS
        # *   PING
        # *   TCP
        self.protocol_type = protocol_type
        # The ID of the request.
        self.request_id = request_id
        # The timeout period. Unit: milliseconds.
        self.timeout = timeout
        # The time when the information about the health check task was updated.
        self.update_time = update_time
        # The timestamp that indicates when the information about the health check task was updated.
        self.update_timestamp = update_timestamp

    def validate(self):
        if self.isp_city_nodes:
            self.isp_city_nodes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_city_nodes is not None:
            result['IspCityNodes'] = self.isp_city_nodes.to_map()
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        if self.monitor_extend_info is not None:
            result['MonitorExtendInfo'] = self.monitor_extend_info
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspCityNodes') is not None:
            temp_model = DescribeDnsGtmMonitorConfigResponseBodyIspCityNodes()
            self.isp_city_nodes = temp_model.from_map(m['IspCityNodes'])
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        if m.get('MonitorExtendInfo') is not None:
            self.monitor_extend_info = m.get('MonitorExtendInfo')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        return self


class DescribeDnsGtmMonitorConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsGtmMonitorConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsGtmMonitorConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsProductInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
        user_client_ip: str = None,
    ):
        # The ID of the instance. You can call the **DescribeDomainInfo** operation to obtain the instance ID.
        self.instance_id = instance_id
        # The language type.
        self.lang = lang
        # The IP address of the client.
        self.user_client_ip = user_client_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        return self


class DescribeDnsProductInstanceResponseBodyDnsServers(TeaModel):
    def __init__(
        self,
        dns_server: List[str] = None,
    ):
        self.dns_server = dns_server

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_server is not None:
            result['DnsServer'] = self.dns_server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsServer') is not None:
            self.dns_server = m.get('DnsServer')
        return self


class DescribeDnsProductInstanceResponseBody(TeaModel):
    def __init__(
        self,
        bind_count: int = None,
        bind_domain_count: int = None,
        bind_domain_used_count: int = None,
        bind_used_count: int = None,
        ddos_defend_flow: int = None,
        ddos_defend_query: int = None,
        dns_slbcount: int = None,
        dns_security: str = None,
        dns_servers: DescribeDnsProductInstanceResponseBodyDnsServers = None,
        domain: str = None,
        domain_type: str = None,
        end_time: str = None,
        end_timestamp: int = None,
        gslb: bool = None,
        isplines: str = None,
        ispregion_lines: str = None,
        in_black_hole: bool = None,
        in_clean: bool = None,
        instance_id: str = None,
        monitor_frequency: int = None,
        monitor_node_count: int = None,
        monitor_task_count: int = None,
        oversea_ddos_defend_flow: int = None,
        oversea_line: str = None,
        payment_type: str = None,
        region_lines: bool = None,
        request_id: str = None,
        search_engine_lines: str = None,
        start_time: str = None,
        start_timestamp: int = None,
        sub_domain_level: int = None,
        ttlmin_value: int = None,
        urlforward_count: int = None,
        version_code: str = None,
        version_name: str = None,
    ):
        # The number of times you can change domain names that are bound to the DNS instance. It can be specified by the user who uses Alibaba Cloud DNS of the custom version.
        self.bind_count = bind_count
        # The number of domain names that you can bind to the DNS instance.
        self.bind_domain_count = bind_domain_count
        # The number of domain names that have been bound to the DNS instance.
        self.bind_domain_used_count = bind_domain_used_count
        # The number of times you have changed domain names that are bound to the DNS instance. It can be specified by the user who uses Alibaba Cloud DNS of the custom version.
        self.bind_used_count = bind_used_count
        # The DDoS protection traffic. Unit: GB.
        self.ddos_defend_flow = ddos_defend_flow
        # The DDoS protection frequency. Unit: 10,000 QPS.
        self.ddos_defend_query = ddos_defend_query
        # The number of IP addresses supported by a domain name or line.
        self.dns_slbcount = dns_slbcount
        # The DNS security policy. Valid values:
        # 
        # *   **no**: not required.
        # *   **basic**: anti-DDoS basic.
        # *   **advanced**: anti-DDoS advanced.
        self.dns_security = dns_security
        # The list of DNS servers.
        self.dns_servers = dns_servers
        # The bound domain name.
        # 
        # If this parameter is not specified, no domain name is bound.
        self.domain = domain
        self.domain_type = domain_type
        # The time at which the instance expired.
        self.end_time = end_time
        # The UNIX timestamp representing the expiration time of the instance.
        self.end_timestamp = end_timestamp
        # Indicates whether GSLB was allowed.
        self.gslb = gslb
        # The list of ISP lines.
        self.isplines = isplines
        # The list of ISP line subdivisions.
        self.ispregion_lines = ispregion_lines
        # Indicates whether the request for domain name resolution was in the black hole.
        self.in_black_hole = in_black_hole
        # Indicates whether the request for domain name resolution was being cleared.
        self.in_clean = in_clean
        # The ID of the Alibaba Cloud DNS instance.
        self.instance_id = instance_id
        # The monitoring frequency. Unit: minutes.
        self.monitor_frequency = monitor_frequency
        # The number of monitored nodes.
        self.monitor_node_count = monitor_node_count
        # The number of monitoring tasks.
        self.monitor_task_count = monitor_task_count
        # DDoS protection traffic outside China. Unit: GB.
        self.oversea_ddos_defend_flow = oversea_ddos_defend_flow
        # The type of the overseas line.
        self.oversea_line = oversea_line
        self.payment_type = payment_type
        # Indicates whether regional lines were allowed.
        self.region_lines = region_lines
        # The ID of the request.
        self.request_id = request_id
        # The list of search engine lines.
        self.search_engine_lines = search_engine_lines
        # The time when the DNS instance was purchased.
        self.start_time = start_time
        # The UNIX timestamp representing when the DNS instance was purchased.
        self.start_timestamp = start_timestamp
        # The number of subdomain name levels.
        self.sub_domain_level = sub_domain_level
        # The minimum TTL. Unit: seconds.
        self.ttlmin_value = ttlmin_value
        # The URL forwarding quantity.
        self.urlforward_count = urlforward_count
        # The version code of the Alibaba Cloud DNS instance.
        self.version_code = version_code
        # The version name of the Alibaba Cloud DNS instance.
        self.version_name = version_name

    def validate(self):
        if self.dns_servers:
            self.dns_servers.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_count is not None:
            result['BindCount'] = self.bind_count
        if self.bind_domain_count is not None:
            result['BindDomainCount'] = self.bind_domain_count
        if self.bind_domain_used_count is not None:
            result['BindDomainUsedCount'] = self.bind_domain_used_count
        if self.bind_used_count is not None:
            result['BindUsedCount'] = self.bind_used_count
        if self.ddos_defend_flow is not None:
            result['DDosDefendFlow'] = self.ddos_defend_flow
        if self.ddos_defend_query is not None:
            result['DDosDefendQuery'] = self.ddos_defend_query
        if self.dns_slbcount is not None:
            result['DnsSLBCount'] = self.dns_slbcount
        if self.dns_security is not None:
            result['DnsSecurity'] = self.dns_security
        if self.dns_servers is not None:
            result['DnsServers'] = self.dns_servers.to_map()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_timestamp is not None:
            result['EndTimestamp'] = self.end_timestamp
        if self.gslb is not None:
            result['Gslb'] = self.gslb
        if self.isplines is not None:
            result['ISPLines'] = self.isplines
        if self.ispregion_lines is not None:
            result['ISPRegionLines'] = self.ispregion_lines
        if self.in_black_hole is not None:
            result['InBlackHole'] = self.in_black_hole
        if self.in_clean is not None:
            result['InClean'] = self.in_clean
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.monitor_frequency is not None:
            result['MonitorFrequency'] = self.monitor_frequency
        if self.monitor_node_count is not None:
            result['MonitorNodeCount'] = self.monitor_node_count
        if self.monitor_task_count is not None:
            result['MonitorTaskCount'] = self.monitor_task_count
        if self.oversea_ddos_defend_flow is not None:
            result['OverseaDDosDefendFlow'] = self.oversea_ddos_defend_flow
        if self.oversea_line is not None:
            result['OverseaLine'] = self.oversea_line
        if self.payment_type is not None:
            result['PaymentType'] = self.payment_type
        if self.region_lines is not None:
            result['RegionLines'] = self.region_lines
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.search_engine_lines is not None:
            result['SearchEngineLines'] = self.search_engine_lines
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.start_timestamp is not None:
            result['StartTimestamp'] = self.start_timestamp
        if self.sub_domain_level is not None:
            result['SubDomainLevel'] = self.sub_domain_level
        if self.ttlmin_value is not None:
            result['TTLMinValue'] = self.ttlmin_value
        if self.urlforward_count is not None:
            result['URLForwardCount'] = self.urlforward_count
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        if self.version_name is not None:
            result['VersionName'] = self.version_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindCount') is not None:
            self.bind_count = m.get('BindCount')
        if m.get('BindDomainCount') is not None:
            self.bind_domain_count = m.get('BindDomainCount')
        if m.get('BindDomainUsedCount') is not None:
            self.bind_domain_used_count = m.get('BindDomainUsedCount')
        if m.get('BindUsedCount') is not None:
            self.bind_used_count = m.get('BindUsedCount')
        if m.get('DDosDefendFlow') is not None:
            self.ddos_defend_flow = m.get('DDosDefendFlow')
        if m.get('DDosDefendQuery') is not None:
            self.ddos_defend_query = m.get('DDosDefendQuery')
        if m.get('DnsSLBCount') is not None:
            self.dns_slbcount = m.get('DnsSLBCount')
        if m.get('DnsSecurity') is not None:
            self.dns_security = m.get('DnsSecurity')
        if m.get('DnsServers') is not None:
            temp_model = DescribeDnsProductInstanceResponseBodyDnsServers()
            self.dns_servers = temp_model.from_map(m['DnsServers'])
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndTimestamp') is not None:
            self.end_timestamp = m.get('EndTimestamp')
        if m.get('Gslb') is not None:
            self.gslb = m.get('Gslb')
        if m.get('ISPLines') is not None:
            self.isplines = m.get('ISPLines')
        if m.get('ISPRegionLines') is not None:
            self.ispregion_lines = m.get('ISPRegionLines')
        if m.get('InBlackHole') is not None:
            self.in_black_hole = m.get('InBlackHole')
        if m.get('InClean') is not None:
            self.in_clean = m.get('InClean')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MonitorFrequency') is not None:
            self.monitor_frequency = m.get('MonitorFrequency')
        if m.get('MonitorNodeCount') is not None:
            self.monitor_node_count = m.get('MonitorNodeCount')
        if m.get('MonitorTaskCount') is not None:
            self.monitor_task_count = m.get('MonitorTaskCount')
        if m.get('OverseaDDosDefendFlow') is not None:
            self.oversea_ddos_defend_flow = m.get('OverseaDDosDefendFlow')
        if m.get('OverseaLine') is not None:
            self.oversea_line = m.get('OverseaLine')
        if m.get('PaymentType') is not None:
            self.payment_type = m.get('PaymentType')
        if m.get('RegionLines') is not None:
            self.region_lines = m.get('RegionLines')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SearchEngineLines') is not None:
            self.search_engine_lines = m.get('SearchEngineLines')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StartTimestamp') is not None:
            self.start_timestamp = m.get('StartTimestamp')
        if m.get('SubDomainLevel') is not None:
            self.sub_domain_level = m.get('SubDomainLevel')
        if m.get('TTLMinValue') is not None:
            self.ttlmin_value = m.get('TTLMinValue')
        if m.get('URLForwardCount') is not None:
            self.urlforward_count = m.get('URLForwardCount')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        if m.get('VersionName') is not None:
            self.version_name = m.get('VersionName')
        return self


class DescribeDnsProductInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsProductInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsProductInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDnsProductInstancesRequest(TeaModel):
    def __init__(
        self,
        domain_type: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        user_client_ip: str = None,
        version_code: str = None,
    ):
        self.domain_type = domain_type
        # The language type.
        self.lang = lang
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **100**. Default value: **20**.
        self.page_size = page_size
        # The IP address of the client.
        self.user_client_ip = user_client_ip
        # The version code of the Alibaba Cloud DNS instance.
        self.version_code = version_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        return self


class DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct(TeaModel):
    def __init__(
        self,
        bind_count: int = None,
        bind_domain_count: int = None,
        bind_domain_used_count: int = None,
        bind_used_count: int = None,
        ddos_defend_flow: int = None,
        ddos_defend_query: int = None,
        dns_slbcount: int = None,
        dns_security: str = None,
        domain: str = None,
        end_time: str = None,
        end_timestamp: int = None,
        gslb: bool = None,
        isplines: str = None,
        ispregion_lines: str = None,
        in_black_hole: bool = None,
        in_clean: bool = None,
        instance_id: str = None,
        monitor_frequency: int = None,
        monitor_node_count: int = None,
        monitor_task_count: int = None,
        oversea_ddos_defend_flow: int = None,
        oversea_line: str = None,
        payment_type: str = None,
        region_lines: bool = None,
        search_engine_lines: str = None,
        start_time: str = None,
        start_timestamp: int = None,
        sub_domain_level: int = None,
        ttlmin_value: int = None,
        urlforward_count: int = None,
        version_code: str = None,
        version_name: str = None,
    ):
        # The number of times you can change domain names that are bound to the DNS instance. It can be specified by the user who uses Alibaba Cloud DNS of the custom version.
        self.bind_count = bind_count
        # The number of domain names that can be bound to the DNS instance.
        self.bind_domain_count = bind_domain_count
        # The number of domain names that have been bound to the DNS instance.
        self.bind_domain_used_count = bind_domain_used_count
        # The number of times you have changed domain names that are bound to the DNS instance. It can be specified by the user who uses Alibaba Cloud DNS of the custom version.
        self.bind_used_count = bind_used_count
        # The DDoS protection traffic. Unit: GB.
        self.ddos_defend_flow = ddos_defend_flow
        # The DDoS protection frequency. Unit: 10,000 QPS.
        self.ddos_defend_query = ddos_defend_query
        # The number of IP addresses supported by a domain name or line.
        self.dns_slbcount = dns_slbcount
        # The DNS security policy. Valid values:
        # 
        # *   **no**: not required.
        # *   **basic**: anti-DDoS basic.
        # *   **advanced**: anti-DDoS advanced.
        self.dns_security = dns_security
        # The bound domain name.
        self.domain = domain
        # The time at which the instance expired.
        self.end_time = end_time
        # The UNIX timestamp representing the expiration time of the instance.
        self.end_timestamp = end_timestamp
        # Indicates whether global server load balancing (GSLB) was allowed.
        self.gslb = gslb
        # The list of ISP lines.
        self.isplines = isplines
        # The list of ISP line subdivisions.
        self.ispregion_lines = ispregion_lines
        # Indicates whether the request for domain name resolution was in the black hole.
        self.in_black_hole = in_black_hole
        # Indicates whether the request for domain name resolution was being cleared.
        self.in_clean = in_clean
        # The ID of the Alibaba Cloud DNS instance.
        self.instance_id = instance_id
        # The monitoring frequency. Unit: minutes.
        self.monitor_frequency = monitor_frequency
        # The number of monitored nodes.
        self.monitor_node_count = monitor_node_count
        # The number of monitoring tasks.
        self.monitor_task_count = monitor_task_count
        # DDoS protection traffic outside China. Unit: GB.
        self.oversea_ddos_defend_flow = oversea_ddos_defend_flow
        # The type of the overseas line.
        self.oversea_line = oversea_line
        self.payment_type = payment_type
        # Indicates whether regional lines were allowed.
        self.region_lines = region_lines
        # The list of search engine lines.
        self.search_engine_lines = search_engine_lines
        # The time when the DNS instance was purchased.
        self.start_time = start_time
        # The UNIX timestamp representing when the DNS instance was purchased.
        self.start_timestamp = start_timestamp
        # The number of subdomain name levels.
        self.sub_domain_level = sub_domain_level
        # The minimum TTL. Unit: seconds.
        self.ttlmin_value = ttlmin_value
        # The URL forwarding quantity.
        self.urlforward_count = urlforward_count
        # The version code of the Alibaba Cloud DNS instance.
        self.version_code = version_code
        # The version name of the Alibaba Cloud DNS instance.
        self.version_name = version_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_count is not None:
            result['BindCount'] = self.bind_count
        if self.bind_domain_count is not None:
            result['BindDomainCount'] = self.bind_domain_count
        if self.bind_domain_used_count is not None:
            result['BindDomainUsedCount'] = self.bind_domain_used_count
        if self.bind_used_count is not None:
            result['BindUsedCount'] = self.bind_used_count
        if self.ddos_defend_flow is not None:
            result['DDosDefendFlow'] = self.ddos_defend_flow
        if self.ddos_defend_query is not None:
            result['DDosDefendQuery'] = self.ddos_defend_query
        if self.dns_slbcount is not None:
            result['DnsSLBCount'] = self.dns_slbcount
        if self.dns_security is not None:
            result['DnsSecurity'] = self.dns_security
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.end_timestamp is not None:
            result['EndTimestamp'] = self.end_timestamp
        if self.gslb is not None:
            result['Gslb'] = self.gslb
        if self.isplines is not None:
            result['ISPLines'] = self.isplines
        if self.ispregion_lines is not None:
            result['ISPRegionLines'] = self.ispregion_lines
        if self.in_black_hole is not None:
            result['InBlackHole'] = self.in_black_hole
        if self.in_clean is not None:
            result['InClean'] = self.in_clean
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.monitor_frequency is not None:
            result['MonitorFrequency'] = self.monitor_frequency
        if self.monitor_node_count is not None:
            result['MonitorNodeCount'] = self.monitor_node_count
        if self.monitor_task_count is not None:
            result['MonitorTaskCount'] = self.monitor_task_count
        if self.oversea_ddos_defend_flow is not None:
            result['OverseaDDosDefendFlow'] = self.oversea_ddos_defend_flow
        if self.oversea_line is not None:
            result['OverseaLine'] = self.oversea_line
        if self.payment_type is not None:
            result['PaymentType'] = self.payment_type
        if self.region_lines is not None:
            result['RegionLines'] = self.region_lines
        if self.search_engine_lines is not None:
            result['SearchEngineLines'] = self.search_engine_lines
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.start_timestamp is not None:
            result['StartTimestamp'] = self.start_timestamp
        if self.sub_domain_level is not None:
            result['SubDomainLevel'] = self.sub_domain_level
        if self.ttlmin_value is not None:
            result['TTLMinValue'] = self.ttlmin_value
        if self.urlforward_count is not None:
            result['URLForwardCount'] = self.urlforward_count
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        if self.version_name is not None:
            result['VersionName'] = self.version_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindCount') is not None:
            self.bind_count = m.get('BindCount')
        if m.get('BindDomainCount') is not None:
            self.bind_domain_count = m.get('BindDomainCount')
        if m.get('BindDomainUsedCount') is not None:
            self.bind_domain_used_count = m.get('BindDomainUsedCount')
        if m.get('BindUsedCount') is not None:
            self.bind_used_count = m.get('BindUsedCount')
        if m.get('DDosDefendFlow') is not None:
            self.ddos_defend_flow = m.get('DDosDefendFlow')
        if m.get('DDosDefendQuery') is not None:
            self.ddos_defend_query = m.get('DDosDefendQuery')
        if m.get('DnsSLBCount') is not None:
            self.dns_slbcount = m.get('DnsSLBCount')
        if m.get('DnsSecurity') is not None:
            self.dns_security = m.get('DnsSecurity')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('EndTimestamp') is not None:
            self.end_timestamp = m.get('EndTimestamp')
        if m.get('Gslb') is not None:
            self.gslb = m.get('Gslb')
        if m.get('ISPLines') is not None:
            self.isplines = m.get('ISPLines')
        if m.get('ISPRegionLines') is not None:
            self.ispregion_lines = m.get('ISPRegionLines')
        if m.get('InBlackHole') is not None:
            self.in_black_hole = m.get('InBlackHole')
        if m.get('InClean') is not None:
            self.in_clean = m.get('InClean')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MonitorFrequency') is not None:
            self.monitor_frequency = m.get('MonitorFrequency')
        if m.get('MonitorNodeCount') is not None:
            self.monitor_node_count = m.get('MonitorNodeCount')
        if m.get('MonitorTaskCount') is not None:
            self.monitor_task_count = m.get('MonitorTaskCount')
        if m.get('OverseaDDosDefendFlow') is not None:
            self.oversea_ddos_defend_flow = m.get('OverseaDDosDefendFlow')
        if m.get('OverseaLine') is not None:
            self.oversea_line = m.get('OverseaLine')
        if m.get('PaymentType') is not None:
            self.payment_type = m.get('PaymentType')
        if m.get('RegionLines') is not None:
            self.region_lines = m.get('RegionLines')
        if m.get('SearchEngineLines') is not None:
            self.search_engine_lines = m.get('SearchEngineLines')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('StartTimestamp') is not None:
            self.start_timestamp = m.get('StartTimestamp')
        if m.get('SubDomainLevel') is not None:
            self.sub_domain_level = m.get('SubDomainLevel')
        if m.get('TTLMinValue') is not None:
            self.ttlmin_value = m.get('TTLMinValue')
        if m.get('URLForwardCount') is not None:
            self.urlforward_count = m.get('URLForwardCount')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        if m.get('VersionName') is not None:
            self.version_name = m.get('VersionName')
        return self


class DescribeDnsProductInstancesResponseBodyDnsProducts(TeaModel):
    def __init__(
        self,
        dns_product: List[DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct] = None,
    ):
        self.dns_product = dns_product

    def validate(self):
        if self.dns_product:
            for k in self.dns_product:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DnsProduct'] = []
        if self.dns_product is not None:
            for k in self.dns_product:
                result['DnsProduct'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dns_product = []
        if m.get('DnsProduct') is not None:
            for k in m.get('DnsProduct'):
                temp_model = DescribeDnsProductInstancesResponseBodyDnsProductsDnsProduct()
                self.dns_product.append(temp_model.from_map(k))
        return self


class DescribeDnsProductInstancesResponseBody(TeaModel):
    def __init__(
        self,
        dns_products: DescribeDnsProductInstancesResponseBodyDnsProducts = None,
        domain_type: str = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The list of Alibaba Cloud DNS instances obtained by this operation.
        self.dns_products = dns_products
        self.domain_type = domain_type
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of domain names.
        self.total_count = total_count

    def validate(self):
        if self.dns_products:
            self.dns_products.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_products is not None:
            result['DnsProducts'] = self.dns_products.to_map()
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsProducts') is not None:
            temp_model = DescribeDnsProductInstancesResponseBodyDnsProducts()
            self.dns_products = temp_model.from_map(m['DnsProducts'])
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDnsProductInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDnsProductInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDnsProductInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDohAccountStatisticsRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        lang: str = None,
        start_date: str = None,
    ):
        # The end of the time range to query. Specify the time in the YYYY-MM-DD format.
        # 
        # The default value is the day when you perform the operation.
        self.end_date = end_date
        # The language type.
        self.lang = lang
        # The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
        # 
        # You can query only the DNS records of the latest 90 days.`The value of StartDate must be greater than or equal to the difference between the current date and 90`.
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class DescribeDohAccountStatisticsResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        timestamp: int = None,
        total_count: int = None,
        v_4http_count: int = None,
        v_4https_count: int = None,
        v_6http_count: int = None,
        v_6https_count: int = None,
    ):
        # The timestamp.
        self.timestamp = timestamp
        # The total number of requests.
        self.total_count = total_count
        # The number of IPv4-based HTTP requests.
        self.v_4http_count = v_4http_count
        # The number of IPv4-based HTTPS requests.
        self.v_4https_count = v_4https_count
        # The number of IPv6-based HTTP requests.
        self.v_6http_count = v_6http_count
        # The number of IPv6-based HTTPS requests.
        self.v_6https_count = v_6https_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.v_4http_count is not None:
            result['V4HttpCount'] = self.v_4http_count
        if self.v_4https_count is not None:
            result['V4HttpsCount'] = self.v_4https_count
        if self.v_6http_count is not None:
            result['V6HttpCount'] = self.v_6http_count
        if self.v_6https_count is not None:
            result['V6HttpsCount'] = self.v_6https_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('V4HttpCount') is not None:
            self.v_4http_count = m.get('V4HttpCount')
        if m.get('V4HttpsCount') is not None:
            self.v_4https_count = m.get('V4HttpsCount')
        if m.get('V6HttpCount') is not None:
            self.v_6http_count = m.get('V6HttpCount')
        if m.get('V6HttpsCount') is not None:
            self.v_6https_count = m.get('V6HttpsCount')
        return self


class DescribeDohAccountStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        statistics: List[DescribeDohAccountStatisticsResponseBodyStatistics] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The statistics list.
        self.statistics = statistics

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeDohAccountStatisticsResponseBodyStatistics()
                self.statistics.append(temp_model.from_map(k))
        return self


class DescribeDohAccountStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDohAccountStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDohAccountStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDohDomainStatisticsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        end_date: str = None,
        lang: str = None,
        start_date: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The end of the time range to query. Specify the time in the YYYY-MM-DD format.
        # 
        # The default value is the day when you perform the operation.
        self.end_date = end_date
        # The language type.
        self.lang = lang
        # The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
        # 
        # You can query only the DNS records of the latest 90 days. `The value of StartDate must be greater than or equal to the difference between the current date and 90`.
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class DescribeDohDomainStatisticsResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        timestamp: int = None,
        total_count: int = None,
        v_4http_count: int = None,
        v_4https_count: int = None,
        v_6http_count: int = None,
        v_6https_count: int = None,
    ):
        # The timestamp.
        self.timestamp = timestamp
        # The total number of requests.
        self.total_count = total_count
        # The number of IPv4-based HTTP requests.
        self.v_4http_count = v_4http_count
        # The number of IPv4-based HTTPS requests.
        self.v_4https_count = v_4https_count
        # The number of IPv6-based HTTP requests.
        self.v_6http_count = v_6http_count
        # The number of IPv6-based HTTPS requests.
        self.v_6https_count = v_6https_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.v_4http_count is not None:
            result['V4HttpCount'] = self.v_4http_count
        if self.v_4https_count is not None:
            result['V4HttpsCount'] = self.v_4https_count
        if self.v_6http_count is not None:
            result['V6HttpCount'] = self.v_6http_count
        if self.v_6https_count is not None:
            result['V6HttpsCount'] = self.v_6https_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('V4HttpCount') is not None:
            self.v_4http_count = m.get('V4HttpCount')
        if m.get('V4HttpsCount') is not None:
            self.v_4https_count = m.get('V4HttpsCount')
        if m.get('V6HttpCount') is not None:
            self.v_6http_count = m.get('V6HttpCount')
        if m.get('V6HttpsCount') is not None:
            self.v_6https_count = m.get('V6HttpsCount')
        return self


class DescribeDohDomainStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        statistics: List[DescribeDohDomainStatisticsResponseBodyStatistics] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The statistics list.
        self.statistics = statistics

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeDohDomainStatisticsResponseBodyStatistics()
                self.statistics.append(temp_model.from_map(k))
        return self


class DescribeDohDomainStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDohDomainStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDohDomainStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDohDomainStatisticsSummaryRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        end_date: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The end of the time range to query. Specify the time in the YYYY-MM-DD format.
        # 
        # The default value is the day when you perform the operation.
        self.end_date = end_date
        # The language type.
        self.lang = lang
        # The number of the page to return. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: 100. Default value: 20.
        self.page_size = page_size
        # The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
        # 
        # You can query only the DNS records of the last 90 days. `The value of StartDate must be greater than or equal to the difference between the current date and 90`.
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class DescribeDohDomainStatisticsSummaryResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        http_count: int = None,
        https_count: int = None,
        ip_count: int = None,
        total_count: int = None,
        v_4http_count: int = None,
        v_4https_count: int = None,
        v_6http_count: int = None,
        v_6https_count: int = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The number of HTTP requests.
        self.http_count = http_count
        # The number of HTTPS requests.
        self.https_count = https_count
        # The number of IP addresses.
        self.ip_count = ip_count
        # The total number of requests.
        self.total_count = total_count
        # The number of IPv4-based HTTP requests.
        self.v_4http_count = v_4http_count
        # The number of IPv4-based HTTPS requests.
        self.v_4https_count = v_4https_count
        # The number of IPv6-based HTTP requests.
        self.v_6http_count = v_6http_count
        # The number of IPv6-based HTTPS requests.
        self.v_6https_count = v_6https_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.http_count is not None:
            result['HttpCount'] = self.http_count
        if self.https_count is not None:
            result['HttpsCount'] = self.https_count
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.v_4http_count is not None:
            result['V4HttpCount'] = self.v_4http_count
        if self.v_4https_count is not None:
            result['V4HttpsCount'] = self.v_4https_count
        if self.v_6http_count is not None:
            result['V6HttpCount'] = self.v_6http_count
        if self.v_6https_count is not None:
            result['V6HttpsCount'] = self.v_6https_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('HttpCount') is not None:
            self.http_count = m.get('HttpCount')
        if m.get('HttpsCount') is not None:
            self.https_count = m.get('HttpsCount')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('V4HttpCount') is not None:
            self.v_4http_count = m.get('V4HttpCount')
        if m.get('V4HttpsCount') is not None:
            self.v_4https_count = m.get('V4HttpsCount')
        if m.get('V6HttpCount') is not None:
            self.v_6http_count = m.get('V6HttpCount')
        if m.get('V6HttpsCount') is not None:
            self.v_6https_count = m.get('V6HttpsCount')
        return self


class DescribeDohDomainStatisticsSummaryResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        statistics: List[DescribeDohDomainStatisticsSummaryResponseBodyStatistics] = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The statistics list.
        self.statistics = statistics
        # The total number of entries returned.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeDohDomainStatisticsSummaryResponseBodyStatistics()
                self.statistics.append(temp_model.from_map(k))
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeDohDomainStatisticsSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDohDomainStatisticsSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDohDomainStatisticsSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDohSubDomainStatisticsRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        lang: str = None,
        start_date: str = None,
        sub_domain: str = None,
    ):
        # The end of the time range to query. Specify the time in the YYYY-MM-DD format.
        # 
        # The default value is the day when you perform the operation.
        self.end_date = end_date
        # The language type.
        self.lang = lang
        # The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
        # 
        # You can query only the DNS records of the latest 90 days. `The value of StartDate must be greater than or equal to the difference between the current date and 90`.
        self.start_date = start_date
        # The subdomain whose statistics you want to query.
        self.sub_domain = sub_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        return self


class DescribeDohSubDomainStatisticsResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        timestamp: int = None,
        total_count: int = None,
        v_4http_count: int = None,
        v_4https_count: int = None,
        v_6http_count: int = None,
        v_6https_count: int = None,
    ):
        # The timestamp.
        self.timestamp = timestamp
        # The total number of requests.
        self.total_count = total_count
        # The number of IPv4-based HTTP requests.
        self.v_4http_count = v_4http_count
        # The number of IPv4-based HTTPS requests.
        self.v_4https_count = v_4https_count
        # The number of IPv6-based HTTP requests.
        self.v_6http_count = v_6http_count
        # The number of IPv6-based HTTPS requests.
        self.v_6https_count = v_6https_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.v_4http_count is not None:
            result['V4HttpCount'] = self.v_4http_count
        if self.v_4https_count is not None:
            result['V4HttpsCount'] = self.v_4https_count
        if self.v_6http_count is not None:
            result['V6HttpCount'] = self.v_6http_count
        if self.v_6https_count is not None:
            result['V6HttpsCount'] = self.v_6https_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('V4HttpCount') is not None:
            self.v_4http_count = m.get('V4HttpCount')
        if m.get('V4HttpsCount') is not None:
            self.v_4https_count = m.get('V4HttpsCount')
        if m.get('V6HttpCount') is not None:
            self.v_6http_count = m.get('V6HttpCount')
        if m.get('V6HttpsCount') is not None:
            self.v_6https_count = m.get('V6HttpsCount')
        return self


class DescribeDohSubDomainStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        statistics: List[DescribeDohSubDomainStatisticsResponseBodyStatistics] = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The statistics list.
        self.statistics = statistics

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeDohSubDomainStatisticsResponseBodyStatistics()
                self.statistics.append(temp_model.from_map(k))
        return self


class DescribeDohSubDomainStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDohSubDomainStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDohSubDomainStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDohSubDomainStatisticsSummaryRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        end_date: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
        sub_domain: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The end of the time range to query. Specify the time in the YYYY-MM-DD format.
        # 
        # The default value is the day when you query the required data.
        self.end_date = end_date
        # The language type.
        self.lang = lang
        # The number of the page to return. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: 100. Default value: 20.
        self.page_size = page_size
        # The beginning of the time range to query. Specify the time in the YYYY-MM-DD format.
        # 
        # You can query only the DNS records of the last 90 days. `The value of StartDate must be greater than or equal to the difference between the current date and 90`.
        self.start_date = start_date
        # The subdomain.
        self.sub_domain = sub_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        return self


class DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        http_count: int = None,
        https_count: int = None,
        ip_count: int = None,
        sub_domain: str = None,
        total_count: int = None,
        v_4http_count: int = None,
        v_4https_count: int = None,
        v_6http_count: int = None,
        v_6https_count: int = None,
    ):
        # The number of HTTP requests.
        self.http_count = http_count
        # The number of HTTPS requests.
        self.https_count = https_count
        # The number of IP addresses.
        self.ip_count = ip_count
        # The subdomain.
        self.sub_domain = sub_domain
        # Total number of requests.
        self.total_count = total_count
        # The number of IPv4-based HTTP requests.
        self.v_4http_count = v_4http_count
        # The number of IPv4-based HTTPS requests.
        self.v_4https_count = v_4https_count
        # The number of IPv6-based HTTP requests.
        self.v_6http_count = v_6http_count
        # The number of IPv6-based HTTPS requests.
        self.v_6https_count = v_6https_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_count is not None:
            result['HttpCount'] = self.http_count
        if self.https_count is not None:
            result['HttpsCount'] = self.https_count
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.v_4http_count is not None:
            result['V4HttpCount'] = self.v_4http_count
        if self.v_4https_count is not None:
            result['V4HttpsCount'] = self.v_4https_count
        if self.v_6http_count is not None:
            result['V6HttpCount'] = self.v_6http_count
        if self.v_6https_count is not None:
            result['V6HttpsCount'] = self.v_6https_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpCount') is not None:
            self.http_count = m.get('HttpCount')
        if m.get('HttpsCount') is not None:
            self.https_count = m.get('HttpsCount')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('V4HttpCount') is not None:
            self.v_4http_count = m.get('V4HttpCount')
        if m.get('V4HttpsCount') is not None:
            self.v_4https_count = m.get('V4HttpsCount')
        if m.get('V6HttpCount') is not None:
            self.v_6http_count = m.get('V6HttpCount')
        if m.get('V6HttpsCount') is not None:
            self.v_6https_count = m.get('V6HttpsCount')
        return self


class DescribeDohSubDomainStatisticsSummaryResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        statistics: List[DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics] = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The statistics list.
        self.statistics = statistics
        # Total number of entries returned.
        self.total_items = total_items
        # Total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeDohSubDomainStatisticsSummaryResponseBodyStatistics()
                self.statistics.append(temp_model.from_map(k))
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeDohSubDomainStatisticsSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDohSubDomainStatisticsSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDohSubDomainStatisticsSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDohUserInfoRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        lang: str = None,
        start_date: str = None,
    ):
        # The end time for the query. Format: YYYY-MM-DD
        # 
        # If you do not specify this parameter, the default value is the time when you perform the query.
        self.end_date = end_date
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
        self.lang = lang
        # The start time for the query. Format: YYYY-MM-DD
        # 
        # You can query the user information of the last 90 days only. `Set the parameter to a value no earlier than 90 days from the current time`.
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class DescribeDohUserInfoResponseBody(TeaModel):
    def __init__(
        self,
        domain_count: int = None,
        pdns_id: int = None,
        request_id: str = None,
        sub_domain_count: int = None,
    ):
        # The number of accessed domains.
        self.domain_count = domain_count
        # The ID of the Alibaba Cloud public DNS user.
        self.pdns_id = pdns_id
        # The ID of the request.
        self.request_id = request_id
        # The number of accessed subdomains.
        self.sub_domain_count = sub_domain_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_count is not None:
            result['DomainCount'] = self.domain_count
        if self.pdns_id is not None:
            result['PdnsId'] = self.pdns_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sub_domain_count is not None:
            result['SubDomainCount'] = self.sub_domain_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainCount') is not None:
            self.domain_count = m.get('DomainCount')
        if m.get('PdnsId') is not None:
            self.pdns_id = m.get('PdnsId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SubDomainCount') is not None:
            self.sub_domain_count = m.get('SubDomainCount')
        return self


class DescribeDohUserInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDohUserInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDohUserInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainDnssecInfoRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
    ):
        # The domain name for which DNSSEC configurations to query.
        self.domain_name = domain_name
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages, such as the region parameter. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDomainDnssecInfoResponseBody(TeaModel):
    def __init__(
        self,
        algorithm: str = None,
        digest: str = None,
        digest_type: str = None,
        domain_name: str = None,
        ds_record: str = None,
        flags: str = None,
        key_tag: str = None,
        public_key: str = None,
        request_id: str = None,
        status: str = None,
    ):
        # The algorithm configured in a DNSSEC record. This parameter is returned if DNSSEC is enabled.
        self.algorithm = algorithm
        # The digest configured in a DNSSEC record. This parameter is returned if DNSSEC is enabled.
        self.digest = digest
        # The digest type configured in a DNSSEC record. This parameter is returned if DNSSEC is enabled.
        self.digest_type = digest_type
        # The domain name that is queried.
        self.domain_name = domain_name
        # The DS record. This parameter is returned if DNSSEC is enabled.
        self.ds_record = ds_record
        # The flag of a DNSSEC record. This parameter is returned if DNSSEC is enabled.
        self.flags = flags
        # The key tag of a DNSSEC record. This parameter is returned if DNSSEC is enabled.
        self.key_tag = key_tag
        # The public key for a DNSSEC record. This parameter is returned if DNSSEC is enabled.
        self.public_key = public_key
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether DNSSEC is enabled for the specified domain name.
        # 
        # *   ON: DNSSEC is enabled.
        # *   OFF: DNSSEC is disabled.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.algorithm is not None:
            result['Algorithm'] = self.algorithm
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.digest_type is not None:
            result['DigestType'] = self.digest_type
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.ds_record is not None:
            result['DsRecord'] = self.ds_record
        if self.flags is not None:
            result['Flags'] = self.flags
        if self.key_tag is not None:
            result['KeyTag'] = self.key_tag
        if self.public_key is not None:
            result['PublicKey'] = self.public_key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Algorithm') is not None:
            self.algorithm = m.get('Algorithm')
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('DigestType') is not None:
            self.digest_type = m.get('DigestType')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DsRecord') is not None:
            self.ds_record = m.get('DsRecord')
        if m.get('Flags') is not None:
            self.flags = m.get('Flags')
        if m.get('KeyTag') is not None:
            self.key_tag = m.get('KeyTag')
        if m.get('PublicKey') is not None:
            self.public_key = m.get('PublicKey')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeDomainDnssecInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainDnssecInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainDnssecInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainGroupsRequest(TeaModel):
    def __init__(
        self,
        key_word: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The keyword of the domain name group for searches in %KeyWord% mode. The value is not case-sensitive.
        self.key_word = key_word
        # The language type.
        self.lang = lang
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **100**. Default value: **20**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup(TeaModel):
    def __init__(
        self,
        domain_count: int = None,
        group_id: str = None,
        group_name: str = None,
    ):
        # The number of domain name groups.
        self.domain_count = domain_count
        # The ID of the domain name group.
        self.group_id = group_id
        # The name of the domain name group.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_count is not None:
            result['DomainCount'] = self.domain_count
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainCount') is not None:
            self.domain_count = m.get('DomainCount')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DescribeDomainGroupsResponseBodyDomainGroups(TeaModel):
    def __init__(
        self,
        domain_group: List[DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup] = None,
    ):
        self.domain_group = domain_group

    def validate(self):
        if self.domain_group:
            for k in self.domain_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainGroup'] = []
        if self.domain_group is not None:
            for k in self.domain_group:
                result['DomainGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_group = []
        if m.get('DomainGroup') is not None:
            for k in m.get('DomainGroup'):
                temp_model = DescribeDomainGroupsResponseBodyDomainGroupsDomainGroup()
                self.domain_group.append(temp_model.from_map(k))
        return self


class DescribeDomainGroupsResponseBody(TeaModel):
    def __init__(
        self,
        domain_groups: DescribeDomainGroupsResponseBodyDomainGroups = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The list of domain name groups.
        self.domain_groups = domain_groups
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of domain name groups.
        self.total_count = total_count

    def validate(self):
        if self.domain_groups:
            self.domain_groups.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_groups is not None:
            result['DomainGroups'] = self.domain_groups.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainGroups') is not None:
            temp_model = DescribeDomainGroupsResponseBodyDomainGroups()
            self.domain_groups = temp_model.from_map(m['DomainGroups'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDomainGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainInfoRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        need_detail_attributes: bool = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language type.
        self.lang = lang
        # Specifies whether detailed attributes are required. Default value: **false**, which indicates that detailed attributes are not required.
        # 
        # If you set this parameter to **true**, the values of the following parameters are returned: LineType, MinTtl, RecordLineTreeJson, RecordLines, LineCode, LineDisplayName, LineName, RegionLines, and SlaveDns.
        self.need_detail_attributes = need_detail_attributes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.need_detail_attributes is not None:
            result['NeedDetailAttributes'] = self.need_detail_attributes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NeedDetailAttributes') is not None:
            self.need_detail_attributes = m.get('NeedDetailAttributes')
        return self


class DescribeDomainInfoResponseBodyAvailableTtls(TeaModel):
    def __init__(
        self,
        available_ttl: List[str] = None,
    ):
        self.available_ttl = available_ttl

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_ttl is not None:
            result['AvailableTtl'] = self.available_ttl
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableTtl') is not None:
            self.available_ttl = m.get('AvailableTtl')
        return self


class DescribeDomainInfoResponseBodyDnsServers(TeaModel):
    def __init__(
        self,
        dns_server: List[str] = None,
    ):
        self.dns_server = dns_server

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_server is not None:
            result['DnsServer'] = self.dns_server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsServer') is not None:
            self.dns_server = m.get('DnsServer')
        return self


class DescribeDomainInfoResponseBodyRecordLinesRecordLine(TeaModel):
    def __init__(
        self,
        father_code: str = None,
        line_code: str = None,
        line_display_name: str = None,
        line_name: str = None,
    ):
        # The code of the parent line. This parameter is left empty if the line has no parent line.
        self.father_code = father_code
        # The code of the line.
        self.line_code = line_code
        # The name of the parent line.
        self.line_display_name = line_display_name
        # The name of the line.
        self.line_name = line_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.father_code is not None:
            result['FatherCode'] = self.father_code
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_display_name is not None:
            result['LineDisplayName'] = self.line_display_name
        if self.line_name is not None:
            result['LineName'] = self.line_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FatherCode') is not None:
            self.father_code = m.get('FatherCode')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineDisplayName') is not None:
            self.line_display_name = m.get('LineDisplayName')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        return self


class DescribeDomainInfoResponseBodyRecordLines(TeaModel):
    def __init__(
        self,
        record_line: List[DescribeDomainInfoResponseBodyRecordLinesRecordLine] = None,
    ):
        self.record_line = record_line

    def validate(self):
        if self.record_line:
            for k in self.record_line:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordLine'] = []
        if self.record_line is not None:
            for k in self.record_line:
                result['RecordLine'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_line = []
        if m.get('RecordLine') is not None:
            for k in m.get('RecordLine'):
                temp_model = DescribeDomainInfoResponseBodyRecordLinesRecordLine()
                self.record_line.append(temp_model.from_map(k))
        return self


class DescribeDomainInfoResponseBody(TeaModel):
    def __init__(
        self,
        ali_domain: bool = None,
        available_ttls: DescribeDomainInfoResponseBodyAvailableTtls = None,
        create_time: str = None,
        dns_servers: DescribeDomainInfoResponseBodyDnsServers = None,
        domain_id: str = None,
        domain_name: str = None,
        group_id: str = None,
        group_name: str = None,
        in_black_hole: bool = None,
        in_clean: bool = None,
        instance_id: str = None,
        line_type: str = None,
        min_ttl: int = None,
        puny_code: str = None,
        record_line_tree_json: str = None,
        record_lines: DescribeDomainInfoResponseBodyRecordLines = None,
        region_lines: bool = None,
        remark: str = None,
        request_id: str = None,
        resource_group_id: str = None,
        slave_dns: bool = None,
        version_code: str = None,
        version_name: str = None,
    ):
        # Indicates whether the domain name is an Alibaba Cloud HiChina domain name.
        self.ali_domain = ali_domain
        # The available time to live (TTL) values.
        self.available_ttls = available_ttls
        # The time when the domain name was added to Alibaba Cloud CDN.
        self.create_time = create_time
        # The information about DNS servers.
        self.dns_servers = dns_servers
        # The ID of the domain name.
        self.domain_id = domain_id
        # The domain name.
        self.domain_name = domain_name
        # The ID of the domain name group.
        self.group_id = group_id
        # The name of the domain name group.
        self.group_name = group_name
        # Indicates whether blackhole filtering was triggered.
        self.in_black_hole = in_black_hole
        # Indicates whether traffic scrubbing was started.
        self.in_clean = in_clean
        # The ID of the Alibaba Cloud DNS instance.
        self.instance_id = instance_id
        # The type of line.
        self.line_type = line_type
        # The minimum TTL.
        self.min_ttl = min_ttl
        # The Punycode for the domain name. This parameter is returned only for Chinese domain names.
        self.puny_code = puny_code
        # The tree-based lines.
        self.record_line_tree_json = record_line_tree_json
        # The information about lines.
        self.record_lines = record_lines
        # Indicates whether the lines are regional lines.
        self.region_lines = region_lines
        # The description of the domain name.
        self.remark = remark
        # The ID of the request.
        self.request_id = request_id
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # Indicates whether secondary DNS is allowed.
        self.slave_dns = slave_dns
        # The version of the Alibaba Cloud DNS instance.
        self.version_code = version_code
        # The edition of the Alibaba Cloud DNS instance.
        self.version_name = version_name

    def validate(self):
        if self.available_ttls:
            self.available_ttls.validate()
        if self.dns_servers:
            self.dns_servers.validate()
        if self.record_lines:
            self.record_lines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_domain is not None:
            result['AliDomain'] = self.ali_domain
        if self.available_ttls is not None:
            result['AvailableTtls'] = self.available_ttls.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dns_servers is not None:
            result['DnsServers'] = self.dns_servers.to_map()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.in_black_hole is not None:
            result['InBlackHole'] = self.in_black_hole
        if self.in_clean is not None:
            result['InClean'] = self.in_clean
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.line_type is not None:
            result['LineType'] = self.line_type
        if self.min_ttl is not None:
            result['MinTtl'] = self.min_ttl
        if self.puny_code is not None:
            result['PunyCode'] = self.puny_code
        if self.record_line_tree_json is not None:
            result['RecordLineTreeJson'] = self.record_line_tree_json
        if self.record_lines is not None:
            result['RecordLines'] = self.record_lines.to_map()
        if self.region_lines is not None:
            result['RegionLines'] = self.region_lines
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.slave_dns is not None:
            result['SlaveDns'] = self.slave_dns
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        if self.version_name is not None:
            result['VersionName'] = self.version_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliDomain') is not None:
            self.ali_domain = m.get('AliDomain')
        if m.get('AvailableTtls') is not None:
            temp_model = DescribeDomainInfoResponseBodyAvailableTtls()
            self.available_ttls = temp_model.from_map(m['AvailableTtls'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DnsServers') is not None:
            temp_model = DescribeDomainInfoResponseBodyDnsServers()
            self.dns_servers = temp_model.from_map(m['DnsServers'])
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InBlackHole') is not None:
            self.in_black_hole = m.get('InBlackHole')
        if m.get('InClean') is not None:
            self.in_clean = m.get('InClean')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('LineType') is not None:
            self.line_type = m.get('LineType')
        if m.get('MinTtl') is not None:
            self.min_ttl = m.get('MinTtl')
        if m.get('PunyCode') is not None:
            self.puny_code = m.get('PunyCode')
        if m.get('RecordLineTreeJson') is not None:
            self.record_line_tree_json = m.get('RecordLineTreeJson')
        if m.get('RecordLines') is not None:
            temp_model = DescribeDomainInfoResponseBodyRecordLines()
            self.record_lines = temp_model.from_map(m['RecordLines'])
        if m.get('RegionLines') is not None:
            self.region_lines = m.get('RegionLines')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SlaveDns') is not None:
            self.slave_dns = m.get('SlaveDns')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        if m.get('VersionName') is not None:
            self.version_name = m.get('VersionName')
        return self


class DescribeDomainInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainLogsRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        key_word: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
        type: str = None,
        end_date: str = None,
    ):
        # The ID of the domain name group.
        self.group_id = group_id
        # The keyword for the query in "%KeyWord%" mode. The keyword is not case-sensitive.
        self.key_word = key_word
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
        self.lang = lang
        # The page number to return. The page number starts from **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return per page. Maximum value: **100**. Default value: **20**.
        self.page_size = page_size
        # The start time for the query. Format: **YYYY-MM-DD**\
        self.start_date = start_date
        # The type of object of which you want to query operation logs. Valid values:
        # 
        # *   domain: domain name
        # *   slavedns: secondary Domain Name System (DNS)
        self.type = type
        # The end time for the query. Format: **YYYY-MM-DD**\
        self.end_date = end_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.type is not None:
            result['Type'] = self.type
        if self.end_date is not None:
            result['endDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        return self


class DescribeDomainLogsResponseBodyDomainLogsDomainLog(TeaModel):
    def __init__(
        self,
        action: str = None,
        action_time: str = None,
        action_timestamp: int = None,
        client_ip: str = None,
        domain_name: str = None,
        message: str = None,
        zone_id: str = None,
    ):
        # The operation performed.
        self.action = action
        # The time when the operation was performed.
        self.action_time = action_time
        # The UNIX timestamp that indicates when the operation was performed.
        self.action_timestamp = action_timestamp
        # The IP address from which the operation was performed.
        self.client_ip = client_ip
        # The domain name.
        self.domain_name = domain_name
        # The message for the operation.
        self.message = message
        # The ID of the zone.
        self.zone_id = zone_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.action_time is not None:
            result['ActionTime'] = self.action_time
        if self.action_timestamp is not None:
            result['ActionTimestamp'] = self.action_timestamp
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.message is not None:
            result['Message'] = self.message
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('ActionTime') is not None:
            self.action_time = m.get('ActionTime')
        if m.get('ActionTimestamp') is not None:
            self.action_timestamp = m.get('ActionTimestamp')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class DescribeDomainLogsResponseBodyDomainLogs(TeaModel):
    def __init__(
        self,
        domain_log: List[DescribeDomainLogsResponseBodyDomainLogsDomainLog] = None,
    ):
        self.domain_log = domain_log

    def validate(self):
        if self.domain_log:
            for k in self.domain_log:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainLog'] = []
        if self.domain_log is not None:
            for k in self.domain_log:
                result['DomainLog'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_log = []
        if m.get('DomainLog') is not None:
            for k in m.get('DomainLog'):
                temp_model = DescribeDomainLogsResponseBodyDomainLogsDomainLog()
                self.domain_log.append(temp_model.from_map(k))
        return self


class DescribeDomainLogsResponseBody(TeaModel):
    def __init__(
        self,
        domain_logs: DescribeDomainLogsResponseBodyDomainLogs = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The details about the operation logs that are queried.
        self.domain_logs = domain_logs
        # The page number of the returned page.
        self.page_number = page_number
        # The number of operation logs returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of operation logs returned.
        self.total_count = total_count

    def validate(self):
        if self.domain_logs:
            self.domain_logs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_logs is not None:
            result['DomainLogs'] = self.domain_logs.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainLogs') is not None:
            temp_model = DescribeDomainLogsResponseBodyDomainLogs()
            self.domain_logs = temp_model.from_map(m['DomainLogs'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDomainLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainLogsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainNsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language type.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeDomainNsResponseBodyDnsServers(TeaModel):
    def __init__(
        self,
        dns_server: List[str] = None,
    ):
        self.dns_server = dns_server

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_server is not None:
            result['DnsServer'] = self.dns_server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsServer') is not None:
            self.dns_server = m.get('DnsServer')
        return self


class DescribeDomainNsResponseBodyExpectDnsServers(TeaModel):
    def __init__(
        self,
        expect_dns_server: List[str] = None,
    ):
        self.expect_dns_server = expect_dns_server

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expect_dns_server is not None:
            result['ExpectDnsServer'] = self.expect_dns_server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpectDnsServer') is not None:
            self.expect_dns_server = m.get('ExpectDnsServer')
        return self


class DescribeDomainNsResponseBody(TeaModel):
    def __init__(
        self,
        all_ali_dns: bool = None,
        detect_failed_reason_code: str = None,
        dns_servers: DescribeDomainNsResponseBodyDnsServers = None,
        expect_dns_servers: DescribeDomainNsResponseBodyExpectDnsServers = None,
        include_ali_dns: bool = None,
        request_id: str = None,
    ):
        # Indicates whether all the name servers were Alibaba Cloud DNS servers.
        self.all_ali_dns = all_ali_dns
        self.detect_failed_reason_code = detect_failed_reason_code
        # The list of DNS servers for the domain name.
        self.dns_servers = dns_servers
        # The list of DNS servers assigned by Alibaba Cloud.
        self.expect_dns_servers = expect_dns_servers
        # Indicates whether the name servers included Alibaba Cloud DNS servers.
        self.include_ali_dns = include_ali_dns
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.dns_servers:
            self.dns_servers.validate()
        if self.expect_dns_servers:
            self.expect_dns_servers.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_ali_dns is not None:
            result['AllAliDns'] = self.all_ali_dns
        if self.detect_failed_reason_code is not None:
            result['DetectFailedReasonCode'] = self.detect_failed_reason_code
        if self.dns_servers is not None:
            result['DnsServers'] = self.dns_servers.to_map()
        if self.expect_dns_servers is not None:
            result['ExpectDnsServers'] = self.expect_dns_servers.to_map()
        if self.include_ali_dns is not None:
            result['IncludeAliDns'] = self.include_ali_dns
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllAliDns') is not None:
            self.all_ali_dns = m.get('AllAliDns')
        if m.get('DetectFailedReasonCode') is not None:
            self.detect_failed_reason_code = m.get('DetectFailedReasonCode')
        if m.get('DnsServers') is not None:
            temp_model = DescribeDomainNsResponseBodyDnsServers()
            self.dns_servers = temp_model.from_map(m['DnsServers'])
        if m.get('ExpectDnsServers') is not None:
            temp_model = DescribeDomainNsResponseBodyExpectDnsServers()
            self.expect_dns_servers = temp_model.from_map(m['ExpectDnsServers'])
        if m.get('IncludeAliDns') is not None:
            self.include_ali_dns = m.get('IncludeAliDns')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDomainNsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainNsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainNsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainRecordInfoRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        record_id: str = None,
        user_client_ip: str = None,
    ):
        # The language type.
        self.lang = lang
        # The ID of the DNS record.
        # 
        # This parameter is returned when you add a DNS record or when you query the list of DNS records.
        self.record_id = record_id
        # The IP address of the client.
        self.user_client_ip = user_client_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        return self


class DescribeDomainRecordInfoResponseBody(TeaModel):
    def __init__(
        self,
        domain_id: str = None,
        domain_name: str = None,
        group_id: str = None,
        group_name: str = None,
        line: str = None,
        locked: bool = None,
        priority: int = None,
        puny_code: str = None,
        rr: str = None,
        record_id: str = None,
        remark: str = None,
        request_id: str = None,
        status: str = None,
        ttl: int = None,
        type: str = None,
        value: str = None,
    ):
        # The ID of the domain name.
        self.domain_id = domain_id
        # The domain name.
        self.domain_name = domain_name
        # The ID of the domain name group.
        self.group_id = group_id
        # The name of the domain name group.
        self.group_name = group_name
        # The resolution line.
        self.line = line
        # The lock status of the DNS record. Valid values: true and false.
        self.locked = locked
        # The priority of the MX-type DNS record.
        self.priority = priority
        # The punycode is only returned for Chinese domain names.
        self.puny_code = puny_code
        # The host record.
        self.rr = rr
        # The ID of the DNS record.
        self.record_id = record_id
        self.remark = remark
        # The ID of the request.
        self.request_id = request_id
        # The status of the DNS record. Valid values: Enable and Disable.
        self.status = status
        # The TTL of the resolution.
        self.ttl = ttl
        # The type of the DNS record.
        self.type = type
        # The value of the DNS record.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.line is not None:
            result['Line'] = self.line
        if self.locked is not None:
            result['Locked'] = self.locked
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.puny_code is not None:
            result['PunyCode'] = self.puny_code
        if self.rr is not None:
            result['RR'] = self.rr
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.ttl is not None:
            result['TTL'] = self.ttl
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('Locked') is not None:
            self.locked = m.get('Locked')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('PunyCode') is not None:
            self.puny_code = m.get('PunyCode')
        if m.get('RR') is not None:
            self.rr = m.get('RR')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TTL') is not None:
            self.ttl = m.get('TTL')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDomainRecordInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainRecordInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainRecordInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainRecordsRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        domain_name: str = None,
        group_id: int = None,
        key_word: str = None,
        lang: str = None,
        line: str = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
        rrkey_word: str = None,
        search_mode: str = None,
        status: str = None,
        type: str = None,
        type_key_word: str = None,
        value_key_word: str = None,
    ):
        # The order in which the returned DNS records are sorted. Valid values: DESC and ASC. Default value: DESC.
        self.direction = direction
        # The domain name for which you want to query DNS records.
        self.domain_name = domain_name
        # The ID of the domain name group.
        self.group_id = group_id
        # The keyword based on which the system queries DNS records.
        self.key_word = key_word
        # The language of the domain name.
        self.lang = lang
        # The line based on which the system queries DNS records. Default value: **default**.
        # 
        # For more information, see the following topic:
        # 
        # [DNS lines](https://www.alibabacloud.com/help/zh/doc-detail/29807.htm)
        self.line = line
        # The method that is used to sort the returned DNS records. By default, the DNS records are sorted in reverse chronological order based on the time when they were added.
        self.order_by = order_by
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **500**. Default value: **20**.
        self.page_size = page_size
        # The resource record (RR) keyword based on which the system queries DNS records. The system queries DNS records based on the value of this parameter in fuzzy match mode. The value is not case-sensitive.
        self.rrkey_word = rrkey_word
        # The search mode. Valid values: **LIKE, EXACT, and ADVANCED**.
        # 
        # *   If you set this parameter to LIKE or EXACT, specify the KeyWord parameter.In this case, the RRKeyWord, TypeKeyWord, ValueKeyWord, Type, Line, and Status parameters are ignored.
        # 
        # *   If you set this parameter to ADVANCED, specify the RRKeyWord, TypeKeyWord, ValueKeyWord, Type, Line, and Status parameters.
        # 
        # *   If you do not specify this parameter, the system determines the search mode based on the following rules:
        # 
        #     *   If the KeyWord parameter is specified, the system uses the LIKE mode.
        #     *   If the KeyWord parameter is not specified, the system queries DNS records based on values of the RRKeyWord and ValueKeyWord parameters in fuzzy match mode, and based on the values of the TypeKeyWord, Type, Line, and Status parameters in exact match mode.
        self.search_mode = search_mode
        # The status of the DNS records to query. Valid values: **Enable and Disable**.
        self.status = status
        # The type of the DNS records to query. For more information, see the following topic:
        # 
        # [DNS record types](https://www.alibabacloud.com/help/zh/doc-detail/29805.htm)
        self.type = type
        # The type keyword based on which the system queries DNS records. The system queries DNS records based on the value of this parameter in exact match mode. The value is not case-sensitive.
        self.type_key_word = type_key_word
        # The record value keyword based on which the system queries DNS records. The system queries DNS records based on the value of this parameter in fuzzy match mode. The value is not case-sensitive.
        self.value_key_word = value_key_word

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.line is not None:
            result['Line'] = self.line
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rrkey_word is not None:
            result['RRKeyWord'] = self.rrkey_word
        if self.search_mode is not None:
            result['SearchMode'] = self.search_mode
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.type_key_word is not None:
            result['TypeKeyWord'] = self.type_key_word
        if self.value_key_word is not None:
            result['ValueKeyWord'] = self.value_key_word
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RRKeyWord') is not None:
            self.rrkey_word = m.get('RRKeyWord')
        if m.get('SearchMode') is not None:
            self.search_mode = m.get('SearchMode')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('TypeKeyWord') is not None:
            self.type_key_word = m.get('TypeKeyWord')
        if m.get('ValueKeyWord') is not None:
            self.value_key_word = m.get('ValueKeyWord')
        return self


class DescribeDomainRecordsResponseBodyDomainRecordsRecord(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        line: str = None,
        locked: bool = None,
        priority: int = None,
        rr: str = None,
        record_id: str = None,
        remark: str = None,
        status: str = None,
        ttl: int = None,
        type: str = None,
        value: str = None,
        weight: int = None,
    ):
        # The domain name to which the DNS record belongs.
        self.domain_name = domain_name
        # The line that is used by the DNS record.
        self.line = line
        # Indicates whether the DNS record is locked.
        self.locked = locked
        # The priority of the MX record.
        self.priority = priority
        # The RR value.
        self.rr = rr
        # The ID of the DNS record.
        self.record_id = record_id
        # The description of the DNS record.
        self.remark = remark
        # The status of the DNS record.
        self.status = status
        # The time-to-live (TTL) of the DNS record.
        self.ttl = ttl
        # The type of the DNS record.
        self.type = type
        # The record value.
        self.value = value
        # The weight of the DNS record.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.line is not None:
            result['Line'] = self.line
        if self.locked is not None:
            result['Locked'] = self.locked
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.rr is not None:
            result['RR'] = self.rr
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.status is not None:
            result['Status'] = self.status
        if self.ttl is not None:
            result['TTL'] = self.ttl
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('Locked') is not None:
            self.locked = m.get('Locked')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RR') is not None:
            self.rr = m.get('RR')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TTL') is not None:
            self.ttl = m.get('TTL')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeDomainRecordsResponseBodyDomainRecords(TeaModel):
    def __init__(
        self,
        record: List[DescribeDomainRecordsResponseBodyDomainRecordsRecord] = None,
    ):
        self.record = record

    def validate(self):
        if self.record:
            for k in self.record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Record'] = []
        if self.record is not None:
            for k in self.record:
                result['Record'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record = []
        if m.get('Record') is not None:
            for k in m.get('Record'):
                temp_model = DescribeDomainRecordsResponseBodyDomainRecordsRecord()
                self.record.append(temp_model.from_map(k))
        return self


class DescribeDomainRecordsResponseBody(TeaModel):
    def __init__(
        self,
        domain_records: DescribeDomainRecordsResponseBodyDomainRecords = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The DNS records returned.
        self.domain_records = domain_records
        # The number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of DNS records.
        self.total_count = total_count

    def validate(self):
        if self.domain_records:
            self.domain_records.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_records is not None:
            result['DomainRecords'] = self.domain_records.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainRecords') is not None:
            temp_model = DescribeDomainRecordsResponseBodyDomainRecords()
            self.domain_records = temp_model.from_map(m['DomainRecords'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDomainRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainResolveStatisticsSummaryRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        end_date: str = None,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        search_mode: str = None,
        start_date: str = None,
        threshold: int = None,
    ):
        self.direction = direction
        self.end_date = end_date
        self.keyword = keyword
        self.lang = lang
        self.page_number = page_number
        self.page_size = page_size
        self.search_mode = search_mode
        self.start_date = start_date
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_mode is not None:
            result['SearchMode'] = self.search_mode
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchMode') is not None:
            self.search_mode = m.get('SearchMode')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeDomainResolveStatisticsSummaryResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        count: str = None,
        domain_name: str = None,
        domain_type: str = None,
    ):
        self.count = count
        self.domain_name = domain_name
        self.domain_type = domain_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        return self


class DescribeDomainResolveStatisticsSummaryResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        statistics: List[DescribeDomainResolveStatisticsSummaryResponseBodyStatistics] = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        # RequestId
        self.request_id = request_id
        self.statistics = statistics
        self.total_items = total_items
        self.total_pages = total_pages

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeDomainResolveStatisticsSummaryResponseBodyStatistics()
                self.statistics.append(temp_model.from_map(k))
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeDomainResolveStatisticsSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainResolveStatisticsSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainResolveStatisticsSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainStatisticsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_type: str = None,
        end_date: str = None,
        lang: str = None,
        start_date: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        self.domain_type = domain_type
        # The end of the time range to query. Specify the time in the **YYYY-MM-DD** format.
        # 
        # The default value is the day when you perform the operation.
        self.end_date = end_date
        # The language type.
        self.lang = lang
        # The beginning of the time range to query. Specify the time in the **YYYY-MM-DD** format.
        # 
        # You can only query the DNS records of the last 90 days.
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class DescribeDomainStatisticsResponseBodyStatisticsStatistic(TeaModel):
    def __init__(
        self,
        count: int = None,
        timestamp: int = None,
    ):
        # The number of queries.
        self.count = count
        # The UNIX timestamp representing the collection time.
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class DescribeDomainStatisticsResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        statistic: List[DescribeDomainStatisticsResponseBodyStatisticsStatistic] = None,
    ):
        self.statistic = statistic

    def validate(self):
        if self.statistic:
            for k in self.statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Statistic'] = []
        if self.statistic is not None:
            for k in self.statistic:
                result['Statistic'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.statistic = []
        if m.get('Statistic') is not None:
            for k in m.get('Statistic'):
                temp_model = DescribeDomainStatisticsResponseBodyStatisticsStatistic()
                self.statistic.append(temp_model.from_map(k))
        return self


class DescribeDomainStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        statistics: DescribeDomainStatisticsResponseBodyStatistics = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The list of query volume records.
        self.statistics = statistics

    def validate(self):
        if self.statistics:
            self.statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.statistics is not None:
            result['Statistics'] = self.statistics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Statistics') is not None:
            temp_model = DescribeDomainStatisticsResponseBodyStatistics()
            self.statistics = temp_model.from_map(m['Statistics'])
        return self


class DescribeDomainStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainStatisticsSummaryRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        search_mode: str = None,
        start_date: str = None,
        threshold: int = None,
    ):
        # The end of the time range to query. Specify the time in the **YYYY-MM-DD** format.
        # 
        # The default value is the day when you perform the operation.
        self.end_date = end_date
        # The keyword for searches in %KeyWord% mode. The value is not case-sensitive.
        self.keyword = keyword
        # The language type.
        self.lang = lang
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **100**. Minimum value: **1**. Default value: **20**.
        self.page_size = page_size
        # The search mode of the keyword. Valid values:
        # 
        # *   **LIKE**: fuzzy match (default).
        # *   **EXACT**: exact match.
        self.search_mode = search_mode
        # The beginning of the time range to query. Specify the time in the **YYYY-MM-DD** format.
        # 
        # You can only query DNS records of the last 90 days.
        self.start_date = start_date
        # The threshold of query volume that can be obtained. You can also obtain data about a domain name with the query volume less than or equal to the threshold. For example, if you set this parameter to 100, you can query domain names with less than 100 queries.
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_mode is not None:
            result['SearchMode'] = self.search_mode
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchMode') is not None:
            self.search_mode = m.get('SearchMode')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic(TeaModel):
    def __init__(
        self,
        count: int = None,
        domain_name: str = None,
        domain_type: str = None,
    ):
        # The number of queries.
        self.count = count
        # The domain name.
        self.domain_name = domain_name
        self.domain_type = domain_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        return self


class DescribeDomainStatisticsSummaryResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        statistic: List[DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic] = None,
    ):
        self.statistic = statistic

    def validate(self):
        if self.statistic:
            for k in self.statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Statistic'] = []
        if self.statistic is not None:
            for k in self.statistic:
                result['Statistic'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.statistic = []
        if m.get('Statistic') is not None:
            for k in m.get('Statistic'):
                temp_model = DescribeDomainStatisticsSummaryResponseBodyStatisticsStatistic()
                self.statistic.append(temp_model.from_map(k))
        return self


class DescribeDomainStatisticsSummaryResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        statistics: DescribeDomainStatisticsSummaryResponseBodyStatistics = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The list of query volume records.
        self.statistics = statistics
        # The total number of data records.
        self.total_items = total_items
        # The total number of returned pages.
        self.total_pages = total_pages

    def validate(self):
        if self.statistics:
            self.statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.statistics is not None:
            result['Statistics'] = self.statistics.to_map()
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Statistics') is not None:
            temp_model = DescribeDomainStatisticsSummaryResponseBodyStatistics()
            self.statistics = temp_model.from_map(m['Statistics'])
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeDomainStatisticsSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainStatisticsSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainStatisticsSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainsRequest(TeaModel):
    def __init__(
        self,
        group_id: str = None,
        key_word: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_group_id: str = None,
        search_mode: str = None,
        starmark: bool = None,
    ):
        # The ID of the domain name group. If you do not specify this parameter, all domain names are queried by default.
        self.group_id = group_id
        # The keyword for searches in "%KeyWord%" mode. The value is not case-sensitive.
        self.key_word = key_word
        # The language type.
        self.lang = lang
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **100**. Default value: **20**.
        self.page_size = page_size
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The search mode. Valid values:
        # 
        # *   **LIKE**: fuzzy match.
        # *   **EXACT**: exact match.
        self.search_mode = search_mode
        # Specifies whether to query the starmark of the domain name.
        self.starmark = starmark

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.search_mode is not None:
            result['SearchMode'] = self.search_mode
        if self.starmark is not None:
            result['Starmark'] = self.starmark
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('SearchMode') is not None:
            self.search_mode = m.get('SearchMode')
        if m.get('Starmark') is not None:
            self.starmark = m.get('Starmark')
        return self


class DescribeDomainsResponseBodyDomainsDomainDnsServers(TeaModel):
    def __init__(
        self,
        dns_server: List[str] = None,
    ):
        self.dns_server = dns_server

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_server is not None:
            result['DnsServer'] = self.dns_server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsServer') is not None:
            self.dns_server = m.get('DnsServer')
        return self


class DescribeDomainsResponseBodyDomainsDomainTagsTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        self.key = key
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeDomainsResponseBodyDomainsDomainTags(TeaModel):
    def __init__(
        self,
        tag: List[DescribeDomainsResponseBodyDomainsDomainTagsTag] = None,
    ):
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeDomainsResponseBodyDomainsDomainTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeDomainsResponseBodyDomainsDomain(TeaModel):
    def __init__(
        self,
        ali_domain: bool = None,
        create_time: str = None,
        create_timestamp: int = None,
        dns_servers: DescribeDomainsResponseBodyDomainsDomainDnsServers = None,
        domain_id: str = None,
        domain_name: str = None,
        group_id: str = None,
        group_name: str = None,
        instance_end_time: str = None,
        instance_expired: bool = None,
        instance_id: str = None,
        puny_code: str = None,
        record_count: int = None,
        registrant_email: str = None,
        remark: str = None,
        resource_group_id: str = None,
        starmark: bool = None,
        tags: DescribeDomainsResponseBodyDomainsDomainTags = None,
        version_code: str = None,
        version_name: str = None,
    ):
        # Indicates whether the domain name is an Alibaba Cloud HiChina domain name.
        self.ali_domain = ali_domain
        self.create_time = create_time
        self.create_timestamp = create_timestamp
        # The list of DNS servers of the domain name in the DNS system.
        self.dns_servers = dns_servers
        # The ID of the domain name.
        self.domain_id = domain_id
        # The domain name.
        self.domain_name = domain_name
        # The ID of the domain name group.
        self.group_id = group_id
        # The name of the domain name group.
        self.group_name = group_name
        # The expiration time of the instance.
        self.instance_end_time = instance_end_time
        # Indicates whether the instance expired.
        self.instance_expired = instance_expired
        # The ID of the Alibaba Cloud DNS instance.
        self.instance_id = instance_id
        # The punycode is returned for Chinese domain names and is left blank for English domain names.
        self.puny_code = puny_code
        # The number of DNS records of the domain name.
        self.record_count = record_count
        # The email address of the registrant.
        self.registrant_email = registrant_email
        # The description.
        self.remark = remark
        self.resource_group_id = resource_group_id
        # Indicates whether to query the starmark of the domain name.
        self.starmark = starmark
        self.tags = tags
        # The version code of the Alibaba Cloud DNS instance.
        self.version_code = version_code
        # The version name of the Alibaba Cloud DNS instance.
        self.version_name = version_name

    def validate(self):
        if self.dns_servers:
            self.dns_servers.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_domain is not None:
            result['AliDomain'] = self.ali_domain
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.dns_servers is not None:
            result['DnsServers'] = self.dns_servers.to_map()
        if self.domain_id is not None:
            result['DomainId'] = self.domain_id
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_end_time is not None:
            result['InstanceEndTime'] = self.instance_end_time
        if self.instance_expired is not None:
            result['InstanceExpired'] = self.instance_expired
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.puny_code is not None:
            result['PunyCode'] = self.puny_code
        if self.record_count is not None:
            result['RecordCount'] = self.record_count
        if self.registrant_email is not None:
            result['RegistrantEmail'] = self.registrant_email
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.starmark is not None:
            result['Starmark'] = self.starmark
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        if self.version_name is not None:
            result['VersionName'] = self.version_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliDomain') is not None:
            self.ali_domain = m.get('AliDomain')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('DnsServers') is not None:
            temp_model = DescribeDomainsResponseBodyDomainsDomainDnsServers()
            self.dns_servers = temp_model.from_map(m['DnsServers'])
        if m.get('DomainId') is not None:
            self.domain_id = m.get('DomainId')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceEndTime') is not None:
            self.instance_end_time = m.get('InstanceEndTime')
        if m.get('InstanceExpired') is not None:
            self.instance_expired = m.get('InstanceExpired')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PunyCode') is not None:
            self.puny_code = m.get('PunyCode')
        if m.get('RecordCount') is not None:
            self.record_count = m.get('RecordCount')
        if m.get('RegistrantEmail') is not None:
            self.registrant_email = m.get('RegistrantEmail')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Starmark') is not None:
            self.starmark = m.get('Starmark')
        if m.get('Tags') is not None:
            temp_model = DescribeDomainsResponseBodyDomainsDomainTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        if m.get('VersionName') is not None:
            self.version_name = m.get('VersionName')
        return self


class DescribeDomainsResponseBodyDomains(TeaModel):
    def __init__(
        self,
        domain: List[DescribeDomainsResponseBodyDomainsDomain] = None,
    ):
        self.domain = domain

    def validate(self):
        if self.domain:
            for k in self.domain:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Domain'] = []
        if self.domain is not None:
            for k in self.domain:
                result['Domain'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain = []
        if m.get('Domain') is not None:
            for k in m.get('Domain'):
                temp_model = DescribeDomainsResponseBodyDomainsDomain()
                self.domain.append(temp_model.from_map(k))
        return self


class DescribeDomainsResponseBody(TeaModel):
    def __init__(
        self,
        domains: DescribeDomainsResponseBodyDomains = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The list of domain names queried by this operation.
        self.domains = domains
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of domain names.
        self.total_count = total_count

    def validate(self):
        if self.domains:
            self.domains.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domains is not None:
            result['Domains'] = self.domains.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domains') is not None:
            temp_model = DescribeDomainsResponseBodyDomains()
            self.domains = temp_model.from_map(m['Domains'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDomainsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmAccessStrategiesRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the GTM instance whose access policies you want to query.
        self.instance_id = instance_id
        # The language used by the user.
        self.lang = lang
        # The number of the page to return.
        self.page_number = page_number
        # The number of entries to return per page.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine(TeaModel):
    def __init__(
        self,
        group_code: str = None,
        group_name: str = None,
        line_code: str = None,
        line_name: str = None,
    ):
        # The code of the access region group.
        self.group_code = group_code
        # The name of the access region group.
        self.group_name = group_name
        # The code for the line of the access region.
        self.line_code = line_code
        # The name for the line of the access region.
        self.line_name = line_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_code is not None:
            result['GroupCode'] = self.group_code
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_name is not None:
            result['LineName'] = self.line_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupCode') is not None:
            self.group_code = m.get('GroupCode')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        return self


class DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLines(TeaModel):
    def __init__(
        self,
        line: List[DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine] = None,
    ):
        self.line = line

    def validate(self):
        if self.line:
            for k in self.line:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Line'] = []
        if self.line is not None:
            for k in self.line:
                result['Line'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.line = []
        if m.get('Line') is not None:
            for k in m.get('Line'):
                temp_model = DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLinesLine()
                self.line.append(temp_model.from_map(k))
        return self


class DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy(TeaModel):
    def __init__(
        self,
        access_mode: str = None,
        access_status: str = None,
        create_time: str = None,
        create_timestamp: int = None,
        default_addr_pool_id: str = None,
        default_addr_pool_monitor_status: str = None,
        default_addr_pool_name: str = None,
        default_addr_pool_status: str = None,
        failover_addr_pool_id: str = None,
        failover_addr_pool_monitor_status: str = None,
        failover_addr_pool_name: str = None,
        failover_addr_pool_status: str = None,
        instance_id: str = None,
        lines: DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLines = None,
        strategy_id: str = None,
        strategy_mode: str = None,
        strategy_name: str = None,
    ):
        # The access policy. Valid values:
        # 
        # *   **AUTO**: Automatic switch
        # *   **DEFAULT**: Default address pool
        # *   **FAILOVER**: Failover address pool
        self.access_mode = access_mode
        # The access status. Valid values:
        # 
        # *   **DEFAULT**: The default address pool is currently accessed.
        # *   **FAILOVER**: The failover address pool is currently accessed.
        self.access_status = access_status
        # The time when the access policy was created.
        self.create_time = create_time
        self.create_timestamp = create_timestamp
        # The ID of the default address pool.
        self.default_addr_pool_id = default_addr_pool_id
        # Indicates whether health check was enabled for the default address pool. Valid values:
        # 
        # *   **OPEN**: Enabled
        # *   **CLOSE**: Disabled
        # *   **UNCONFIGURED**: Not configured
        self.default_addr_pool_monitor_status = default_addr_pool_monitor_status
        # The name of the default address pool.
        self.default_addr_pool_name = default_addr_pool_name
        # The availability status of the default address pool. Valid values:
        # 
        # *   **AVAILABLE**: Available
        # *   **NOT_AVAILABLE**: Unavailable
        self.default_addr_pool_status = default_addr_pool_status
        # The ID of the failover address pool.
        self.failover_addr_pool_id = failover_addr_pool_id
        # Indicates whether health check was enabled for the failover address pool.
        self.failover_addr_pool_monitor_status = failover_addr_pool_monitor_status
        # The name of the failover address pool.
        self.failover_addr_pool_name = failover_addr_pool_name
        # The availability status of the failover address pool.
        self.failover_addr_pool_status = failover_addr_pool_status
        # The ID of the GTM instance whose access policies you want to query.
        self.instance_id = instance_id
        # The returned lines of access regions.
        self.lines = lines
        # The ID of the access policy.
        self.strategy_id = strategy_id
        # The mode of the access policy. **SELF_DEFINED** indicates that the access policy is user-defined.
        self.strategy_mode = strategy_mode
        # The name of the access policy.
        self.strategy_name = strategy_name

    def validate(self):
        if self.lines:
            self.lines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_mode is not None:
            result['AccessMode'] = self.access_mode
        if self.access_status is not None:
            result['AccessStatus'] = self.access_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.default_addr_pool_id is not None:
            result['DefaultAddrPoolId'] = self.default_addr_pool_id
        if self.default_addr_pool_monitor_status is not None:
            result['DefaultAddrPoolMonitorStatus'] = self.default_addr_pool_monitor_status
        if self.default_addr_pool_name is not None:
            result['DefaultAddrPoolName'] = self.default_addr_pool_name
        if self.default_addr_pool_status is not None:
            result['DefaultAddrPoolStatus'] = self.default_addr_pool_status
        if self.failover_addr_pool_id is not None:
            result['FailoverAddrPoolId'] = self.failover_addr_pool_id
        if self.failover_addr_pool_monitor_status is not None:
            result['FailoverAddrPoolMonitorStatus'] = self.failover_addr_pool_monitor_status
        if self.failover_addr_pool_name is not None:
            result['FailoverAddrPoolName'] = self.failover_addr_pool_name
        if self.failover_addr_pool_status is not None:
            result['FailoverAddrPoolStatus'] = self.failover_addr_pool_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lines is not None:
            result['Lines'] = self.lines.to_map()
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.strategy_mode is not None:
            result['StrategyMode'] = self.strategy_mode
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessMode') is not None:
            self.access_mode = m.get('AccessMode')
        if m.get('AccessStatus') is not None:
            self.access_status = m.get('AccessStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('DefaultAddrPoolId') is not None:
            self.default_addr_pool_id = m.get('DefaultAddrPoolId')
        if m.get('DefaultAddrPoolMonitorStatus') is not None:
            self.default_addr_pool_monitor_status = m.get('DefaultAddrPoolMonitorStatus')
        if m.get('DefaultAddrPoolName') is not None:
            self.default_addr_pool_name = m.get('DefaultAddrPoolName')
        if m.get('DefaultAddrPoolStatus') is not None:
            self.default_addr_pool_status = m.get('DefaultAddrPoolStatus')
        if m.get('FailoverAddrPoolId') is not None:
            self.failover_addr_pool_id = m.get('FailoverAddrPoolId')
        if m.get('FailoverAddrPoolMonitorStatus') is not None:
            self.failover_addr_pool_monitor_status = m.get('FailoverAddrPoolMonitorStatus')
        if m.get('FailoverAddrPoolName') is not None:
            self.failover_addr_pool_name = m.get('FailoverAddrPoolName')
        if m.get('FailoverAddrPoolStatus') is not None:
            self.failover_addr_pool_status = m.get('FailoverAddrPoolStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lines') is not None:
            temp_model = DescribeGtmAccessStrategiesResponseBodyStrategiesStrategyLines()
            self.lines = temp_model.from_map(m['Lines'])
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('StrategyMode') is not None:
            self.strategy_mode = m.get('StrategyMode')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        return self


class DescribeGtmAccessStrategiesResponseBodyStrategies(TeaModel):
    def __init__(
        self,
        strategy: List[DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy] = None,
    ):
        self.strategy = strategy

    def validate(self):
        if self.strategy:
            for k in self.strategy:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Strategy'] = []
        if self.strategy is not None:
            for k in self.strategy:
                result['Strategy'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.strategy = []
        if m.get('Strategy') is not None:
            for k in m.get('Strategy'):
                temp_model = DescribeGtmAccessStrategiesResponseBodyStrategiesStrategy()
                self.strategy.append(temp_model.from_map(k))
        return self


class DescribeGtmAccessStrategiesResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        strategies: DescribeGtmAccessStrategiesResponseBodyStrategies = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The number of the page returned.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The returned list of access policies of the GTM instance.
        self.strategies = strategies
        # The total number of entries returned on all pages.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.strategies:
            self.strategies.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategies is not None:
            result['Strategies'] = self.strategies.to_map()
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Strategies') is not None:
            temp_model = DescribeGtmAccessStrategiesResponseBodyStrategies()
            self.strategies = temp_model.from_map(m['Strategies'])
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeGtmAccessStrategiesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmAccessStrategiesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmAccessStrategiesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmAccessStrategyRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        strategy_id: str = None,
    ):
        # The language used by the user.
        self.lang = lang
        # The ID of the access policy that you want to query.
        self.strategy_id = strategy_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        return self


class DescribeGtmAccessStrategyResponseBodyLinesLine(TeaModel):
    def __init__(
        self,
        group_code: str = None,
        group_name: str = None,
        line_code: str = None,
        line_name: str = None,
    ):
        # The code of the access region group.
        self.group_code = group_code
        # The name of the access region group.
        self.group_name = group_name
        # The code for the line of the access region.
        self.line_code = line_code
        # The name for the line of the access region.
        self.line_name = line_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_code is not None:
            result['GroupCode'] = self.group_code
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_name is not None:
            result['LineName'] = self.line_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupCode') is not None:
            self.group_code = m.get('GroupCode')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        return self


class DescribeGtmAccessStrategyResponseBodyLines(TeaModel):
    def __init__(
        self,
        line: List[DescribeGtmAccessStrategyResponseBodyLinesLine] = None,
    ):
        self.line = line

    def validate(self):
        if self.line:
            for k in self.line:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Line'] = []
        if self.line is not None:
            for k in self.line:
                result['Line'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.line = []
        if m.get('Line') is not None:
            for k in m.get('Line'):
                temp_model = DescribeGtmAccessStrategyResponseBodyLinesLine()
                self.line.append(temp_model.from_map(k))
        return self


class DescribeGtmAccessStrategyResponseBody(TeaModel):
    def __init__(
        self,
        access_mode: str = None,
        access_status: str = None,
        default_addr_pool_monitor_status: str = None,
        default_addr_pool_name: str = None,
        default_addr_pool_status: str = None,
        defult_addr_pool_id: str = None,
        failover_addr_pool_id: str = None,
        failover_addr_pool_monitor_status: str = None,
        failover_addr_pool_name: str = None,
        failover_addr_pool_status: str = None,
        instance_id: str = None,
        lines: DescribeGtmAccessStrategyResponseBodyLines = None,
        request_id: str = None,
        strategy_id: str = None,
        strategy_mode: str = None,
        strategy_name: str = None,
    ):
        # The access policy.
        self.access_mode = access_mode
        # The access status. Valid values:
        # 
        # *   **DEFAULT**: Indicates normal when the default address pool is accessed.
        # *   **FAILOVER**: Indicates an exception when a failover address pool is accessed.
        self.access_status = access_status
        # Indicates whether health check is enabled for the default address pool.
        self.default_addr_pool_monitor_status = default_addr_pool_monitor_status
        # The name of the default address pool.
        self.default_addr_pool_name = default_addr_pool_name
        # The availability status of the default address pool.
        self.default_addr_pool_status = default_addr_pool_status
        # The ID of the default address pool.
        self.defult_addr_pool_id = defult_addr_pool_id
        # The ID of the failover address pool.
        self.failover_addr_pool_id = failover_addr_pool_id
        # Indicates whether health check is enabled for the failover address pool.
        self.failover_addr_pool_monitor_status = failover_addr_pool_monitor_status
        # The name of the failover address pool.
        self.failover_addr_pool_name = failover_addr_pool_name
        # The availability status of the failover address pool.
        self.failover_addr_pool_status = failover_addr_pool_status
        # The ID of the GTM instance whose access policy details you want to query.
        self.instance_id = instance_id
        # The returned lines of access regions.
        self.lines = lines
        # The ID of the request.
        self.request_id = request_id
        # The ID of the access policy queried.
        self.strategy_id = strategy_id
        # The mode of traffic scheduling.
        self.strategy_mode = strategy_mode
        # The name of the access policy queried.
        self.strategy_name = strategy_name

    def validate(self):
        if self.lines:
            self.lines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_mode is not None:
            result['AccessMode'] = self.access_mode
        if self.access_status is not None:
            result['AccessStatus'] = self.access_status
        if self.default_addr_pool_monitor_status is not None:
            result['DefaultAddrPoolMonitorStatus'] = self.default_addr_pool_monitor_status
        if self.default_addr_pool_name is not None:
            result['DefaultAddrPoolName'] = self.default_addr_pool_name
        if self.default_addr_pool_status is not None:
            result['DefaultAddrPoolStatus'] = self.default_addr_pool_status
        if self.defult_addr_pool_id is not None:
            result['DefultAddrPoolId'] = self.defult_addr_pool_id
        if self.failover_addr_pool_id is not None:
            result['FailoverAddrPoolId'] = self.failover_addr_pool_id
        if self.failover_addr_pool_monitor_status is not None:
            result['FailoverAddrPoolMonitorStatus'] = self.failover_addr_pool_monitor_status
        if self.failover_addr_pool_name is not None:
            result['FailoverAddrPoolName'] = self.failover_addr_pool_name
        if self.failover_addr_pool_status is not None:
            result['FailoverAddrPoolStatus'] = self.failover_addr_pool_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lines is not None:
            result['Lines'] = self.lines.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.strategy_mode is not None:
            result['StrategyMode'] = self.strategy_mode
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessMode') is not None:
            self.access_mode = m.get('AccessMode')
        if m.get('AccessStatus') is not None:
            self.access_status = m.get('AccessStatus')
        if m.get('DefaultAddrPoolMonitorStatus') is not None:
            self.default_addr_pool_monitor_status = m.get('DefaultAddrPoolMonitorStatus')
        if m.get('DefaultAddrPoolName') is not None:
            self.default_addr_pool_name = m.get('DefaultAddrPoolName')
        if m.get('DefaultAddrPoolStatus') is not None:
            self.default_addr_pool_status = m.get('DefaultAddrPoolStatus')
        if m.get('DefultAddrPoolId') is not None:
            self.defult_addr_pool_id = m.get('DefultAddrPoolId')
        if m.get('FailoverAddrPoolId') is not None:
            self.failover_addr_pool_id = m.get('FailoverAddrPoolId')
        if m.get('FailoverAddrPoolMonitorStatus') is not None:
            self.failover_addr_pool_monitor_status = m.get('FailoverAddrPoolMonitorStatus')
        if m.get('FailoverAddrPoolName') is not None:
            self.failover_addr_pool_name = m.get('FailoverAddrPoolName')
        if m.get('FailoverAddrPoolStatus') is not None:
            self.failover_addr_pool_status = m.get('FailoverAddrPoolStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lines') is not None:
            temp_model = DescribeGtmAccessStrategyResponseBodyLines()
            self.lines = temp_model.from_map(m['Lines'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('StrategyMode') is not None:
            self.strategy_mode = m.get('StrategyMode')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        return self


class DescribeGtmAccessStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmAccessStrategyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmAccessStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmAccessStrategyAvailableConfigRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
    ):
        # The ID of the GTM instance for which you want to query the available configurations of the current access policy.
        self.instance_id = instance_id
        # The language used by the user.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        addr_pool_name: str = None,
    ):
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The name of the address pool.
        self.addr_pool_name = addr_pool_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.addr_pool_name is not None:
            result['AddrPoolName'] = self.addr_pool_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('AddrPoolName') is not None:
            self.addr_pool_name = m.get('AddrPoolName')
        return self


class DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPools(TeaModel):
    def __init__(
        self,
        addr_pool: List[DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool] = None,
    ):
        self.addr_pool = addr_pool

    def validate(self):
        if self.addr_pool:
            for k in self.addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AddrPool'] = []
        if self.addr_pool is not None:
            for k in self.addr_pool:
                result['AddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.addr_pool = []
        if m.get('AddrPool') is not None:
            for k in m.get('AddrPool'):
                temp_model = DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPoolsAddrPool()
                self.addr_pool.append(temp_model.from_map(k))
        return self


class DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine(TeaModel):
    def __init__(
        self,
        father_code: str = None,
        group_code: str = None,
        group_name: str = None,
        line_code: str = None,
        line_name: str = None,
        status: str = None,
    ):
        # The code of the parent line for the access region. If no parent line exists, leave this parameter blank.
        self.father_code = father_code
        # The code of the access region group.
        self.group_code = group_code
        # The name of the access region group.
        self.group_name = group_name
        # The code for the line of the access region.
        self.line_code = line_code
        # The name for the line of the access region.
        self.line_name = line_name
        # The current status of the line. Valid values:
        # 
        # - **FORBIDDEN**: Unavailable
        # - **OPTIONAL**: Availabe
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.father_code is not None:
            result['FatherCode'] = self.father_code
        if self.group_code is not None:
            result['GroupCode'] = self.group_code
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_name is not None:
            result['LineName'] = self.line_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FatherCode') is not None:
            self.father_code = m.get('FatherCode')
        if m.get('GroupCode') is not None:
            self.group_code = m.get('GroupCode')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeGtmAccessStrategyAvailableConfigResponseBodyLines(TeaModel):
    def __init__(
        self,
        line: List[DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine] = None,
    ):
        self.line = line

    def validate(self):
        if self.line:
            for k in self.line:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Line'] = []
        if self.line is not None:
            for k in self.line:
                result['Line'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.line = []
        if m.get('Line') is not None:
            for k in m.get('Line'):
                temp_model = DescribeGtmAccessStrategyAvailableConfigResponseBodyLinesLine()
                self.line.append(temp_model.from_map(k))
        return self


class DescribeGtmAccessStrategyAvailableConfigResponseBody(TeaModel):
    def __init__(
        self,
        addr_pools: DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPools = None,
        lines: DescribeGtmAccessStrategyAvailableConfigResponseBodyLines = None,
        request_id: str = None,
        suggest_set_default_line: bool = None,
    ):
        # The returned list of address pools.
        self.addr_pools = addr_pools
        # The returned lines of access regions.
        self.lines = lines
        # The ID of the request.
        self.request_id = request_id
        self.suggest_set_default_line = suggest_set_default_line

    def validate(self):
        if self.addr_pools:
            self.addr_pools.validate()
        if self.lines:
            self.lines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pools is not None:
            result['AddrPools'] = self.addr_pools.to_map()
        if self.lines is not None:
            result['Lines'] = self.lines.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.suggest_set_default_line is not None:
            result['SuggestSetDefaultLine'] = self.suggest_set_default_line
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPools') is not None:
            temp_model = DescribeGtmAccessStrategyAvailableConfigResponseBodyAddrPools()
            self.addr_pools = temp_model.from_map(m['AddrPools'])
        if m.get('Lines') is not None:
            temp_model = DescribeGtmAccessStrategyAvailableConfigResponseBodyLines()
            self.lines = temp_model.from_map(m['Lines'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SuggestSetDefaultLine') is not None:
            self.suggest_set_default_line = m.get('SuggestSetDefaultLine')
        return self


class DescribeGtmAccessStrategyAvailableConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmAccessStrategyAvailableConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmAccessStrategyAvailableConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmAvailableAlertGroupRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language used by the user.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeGtmAvailableAlertGroupResponseBody(TeaModel):
    def __init__(
        self,
        available_alert_group: str = None,
        request_id: str = None,
    ):
        # The available alert groups of the GTM instance.
        self.available_alert_group = available_alert_group
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_alert_group is not None:
            result['AvailableAlertGroup'] = self.available_alert_group
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableAlertGroup') is not None:
            self.available_alert_group = m.get('AvailableAlertGroup')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGtmAvailableAlertGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmAvailableAlertGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmAvailableAlertGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmInstanceRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
        need_detail_attributes: bool = None,
    ):
        # The ID of the GTM instance.
        self.instance_id = instance_id
        # The language of the values of specific response parameters.
        self.lang = lang
        # Specifies whether additional information is required. Default value: **false**. If the value is **true**, the AccessStrategyNum and AddressPoolNum parameters are returned.
        self.need_detail_attributes = need_detail_attributes

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.need_detail_attributes is not None:
            result['NeedDetailAttributes'] = self.need_detail_attributes
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NeedDetailAttributes') is not None:
            self.need_detail_attributes = m.get('NeedDetailAttributes')
        return self


class DescribeGtmInstanceResponseBody(TeaModel):
    def __init__(
        self,
        access_strategy_num: int = None,
        address_pool_num: int = None,
        alert_group: str = None,
        cname: str = None,
        cname_mode: str = None,
        create_time: str = None,
        create_timestamp: int = None,
        expire_time: str = None,
        expire_timestamp: int = None,
        instance_id: str = None,
        instance_name: str = None,
        lba_strategy: str = None,
        request_id: str = None,
        resource_group_id: str = None,
        ttl: int = None,
        user_domain_name: str = None,
        version_code: str = None,
    ):
        # The number of access policies of the GTM instance.
        self.access_strategy_num = access_strategy_num
        # The number of address pools of the GTM instance.
        self.address_pool_num = address_pool_num
        # The alert group of the GTM instance.
        self.alert_group = alert_group
        # The domain name of the GTM instance to which the service domain name is mapped by using a CNAME record.
        self.cname = cname
        # Indicates whether the CNAME is a custom domain name or is assigned by the system. Valid values:
        # 
        # *   **SYSTEM_ASSIGN**\
        # *   **CUSTOM**\
        self.cname_mode = cname_mode
        # The time when the GTM instance was created.
        self.create_time = create_time
        # The timestamp that indicates the time when the GTM instance was created.
        self.create_timestamp = create_timestamp
        # The time when the GTM instance expires.
        self.expire_time = expire_time
        # The timestamp that indicates the time when the GTM instance expires.
        self.expire_timestamp = expire_timestamp
        # The ID of the GTM instance.
        self.instance_id = instance_id
        # The name of the GTM instance.
        self.instance_name = instance_name
        # The load balancing policy. Valid values:
        # 
        # *   **ALL_RR**: round robin
        # *   **RATIO**: weighted round-robin
        self.lba_strategy = lba_strategy
        # The ID of the request.
        self.request_id = request_id
        # The ID of the resource group.
        self.resource_group_id = resource_group_id
        # The global time to live (TTL).
        self.ttl = ttl
        # The domain name of the application.
        self.user_domain_name = user_domain_name
        # The version code.
        self.version_code = version_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_strategy_num is not None:
            result['AccessStrategyNum'] = self.access_strategy_num
        if self.address_pool_num is not None:
            result['AddressPoolNum'] = self.address_pool_num
        if self.alert_group is not None:
            result['AlertGroup'] = self.alert_group
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.cname_mode is not None:
            result['CnameMode'] = self.cname_mode
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.expire_timestamp is not None:
            result['ExpireTimestamp'] = self.expire_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.lba_strategy is not None:
            result['LbaStrategy'] = self.lba_strategy
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.user_domain_name is not None:
            result['UserDomainName'] = self.user_domain_name
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessStrategyNum') is not None:
            self.access_strategy_num = m.get('AccessStrategyNum')
        if m.get('AddressPoolNum') is not None:
            self.address_pool_num = m.get('AddressPoolNum')
        if m.get('AlertGroup') is not None:
            self.alert_group = m.get('AlertGroup')
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('CnameMode') is not None:
            self.cname_mode = m.get('CnameMode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('ExpireTimestamp') is not None:
            self.expire_timestamp = m.get('ExpireTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('LbaStrategy') is not None:
            self.lba_strategy = m.get('LbaStrategy')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('UserDomainName') is not None:
            self.user_domain_name = m.get('UserDomainName')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        return self


class DescribeGtmInstanceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmInstanceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmInstanceAddressPoolRequest(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        lang: str = None,
    ):
        # The ID of the address pool that you want to query.
        self.addr_pool_id = addr_pool_id
        # The language used by the user.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr(TeaModel):
    def __init__(
        self,
        addr_id: int = None,
        alert_status: str = None,
        create_time: str = None,
        create_timestamp: int = None,
        lba_weight: int = None,
        mode: str = None,
        update_time: str = None,
        update_timestamp: int = None,
        value: str = None,
    ):
        # The ID of the address.
        self.addr_id = addr_id
        # Indicates whether health check was enabled for the address. Valid values:
        # 
        # *   **OK**: Normal
        # *   **ALERT**: Alert
        self.alert_status = alert_status
        # The time when the address pool was created.
        self.create_time = create_time
        self.create_timestamp = create_timestamp
        # The weight of the address.
        self.lba_weight = lba_weight
        # The mode of the address. Valid values:
        # 
        # *   **SMART**: Intelligent return
        # *   **ONLINE**: Always online
        # *   **OFFLINE**: Always offline
        self.mode = mode
        # The last time when the address was updated.
        self.update_time = update_time
        # A timestamp that indicates the last time when the address was updated.
        self.update_timestamp = update_timestamp
        # The address.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_id is not None:
            result['AddrId'] = self.addr_id
        if self.alert_status is not None:
            result['AlertStatus'] = self.alert_status
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.lba_weight is not None:
            result['LbaWeight'] = self.lba_weight
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrId') is not None:
            self.addr_id = m.get('AddrId')
        if m.get('AlertStatus') is not None:
            self.alert_status = m.get('AlertStatus')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('LbaWeight') is not None:
            self.lba_weight = m.get('LbaWeight')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeGtmInstanceAddressPoolResponseBodyAddrs(TeaModel):
    def __init__(
        self,
        addr: List[DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr] = None,
    ):
        self.addr = addr

    def validate(self):
        if self.addr:
            for k in self.addr:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Addr'] = []
        if self.addr is not None:
            for k in self.addr:
                result['Addr'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.addr = []
        if m.get('Addr') is not None:
            for k in m.get('Addr'):
                temp_model = DescribeGtmInstanceAddressPoolResponseBodyAddrsAddr()
                self.addr.append(temp_model.from_map(k))
        return self


class DescribeGtmInstanceAddressPoolResponseBody(TeaModel):
    def __init__(
        self,
        addr_count: int = None,
        addr_pool_id: str = None,
        addrs: DescribeGtmInstanceAddressPoolResponseBodyAddrs = None,
        create_time: str = None,
        create_timestamp: int = None,
        min_available_addr_num: int = None,
        monitor_config_id: str = None,
        monitor_status: str = None,
        name: str = None,
        request_id: str = None,
        status: str = None,
        type: str = None,
        update_time: str = None,
        update_timestamp: int = None,
    ):
        # The number of addresses in the address pool queried.
        self.addr_count = addr_count
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The addresses in the address pool.
        self.addrs = addrs
        # The time when the address pool was created.
        self.create_time = create_time
        self.create_timestamp = create_timestamp
        # The minimum number of available addresses in the address pool.
        self.min_available_addr_num = min_available_addr_num
        # The health check ID of the address pool.
        self.monitor_config_id = monitor_config_id
        # Indicates whether health check was enabled for the address pool. Valid values:
        # 
        # *   **OPEN**: Enabled
        # *   **CLOSE**: Disabled
        # *   **UNCONFIGURED**: Not configured
        self.monitor_status = monitor_status
        # The name of the address pool.
        self.name = name
        # The ID of the request.
        self.request_id = request_id
        # The availability status of the address pool. Valid values:
        # 
        # *   **AVAILABLE**: Available
        # *   **NOT_AVAILABLE**: Unavailable
        self.status = status
        # The type of the address pool. Valid values:
        # 
        # *   **IP**: IP address
        # *   **DOMAIN**: Domain name
        self.type = type
        # The last time when the address pool was updated.
        self.update_time = update_time
        # A timestamp that indicates the last time the address pool was updated.
        self.update_timestamp = update_timestamp

    def validate(self):
        if self.addrs:
            self.addrs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_count is not None:
            result['AddrCount'] = self.addr_count
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.addrs is not None:
            result['Addrs'] = self.addrs.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.min_available_addr_num is not None:
            result['MinAvailableAddrNum'] = self.min_available_addr_num
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        if self.monitor_status is not None:
            result['MonitorStatus'] = self.monitor_status
        if self.name is not None:
            result['Name'] = self.name
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrCount') is not None:
            self.addr_count = m.get('AddrCount')
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('Addrs') is not None:
            temp_model = DescribeGtmInstanceAddressPoolResponseBodyAddrs()
            self.addrs = temp_model.from_map(m['Addrs'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('MinAvailableAddrNum') is not None:
            self.min_available_addr_num = m.get('MinAvailableAddrNum')
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        if m.get('MonitorStatus') is not None:
            self.monitor_status = m.get('MonitorStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        return self


class DescribeGtmInstanceAddressPoolResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmInstanceAddressPoolResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmInstanceAddressPoolResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmInstanceAddressPoolsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the GTM instance that you want to query.
        self.instance_id = instance_id
        # The language used by the user.
        self.lang = lang
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return per page. Maximum value: **100**. Default value: **20**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool(TeaModel):
    def __init__(
        self,
        addr_count: int = None,
        addr_pool_id: str = None,
        create_time: str = None,
        create_timestamp: int = None,
        min_available_addr_num: int = None,
        monitor_config_id: str = None,
        monitor_status: str = None,
        name: str = None,
        status: str = None,
        type: str = None,
        update_time: str = None,
        update_timestamp: int = None,
    ):
        # The number of addresses in the address pool.
        self.addr_count = addr_count
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The time when this address pool was created.
        self.create_time = create_time
        self.create_timestamp = create_timestamp
        # The minimum number of available addresses in the address pool.
        self.min_available_addr_num = min_available_addr_num
        # The health check ID of the address pool.
        self.monitor_config_id = monitor_config_id
        # Indicates whether health check was enabled for the address pool. Valid values:
        # 
        # *   **OPEN**: Enabled
        # *   **CLOSE**: Disabled
        # *   **UNCONFIGURED**: Not configured
        self.monitor_status = monitor_status
        # The name of the address pool.
        self.name = name
        # The availability status of the address pool. Valid values:
        # 
        # *   **AVAILABLE**: Available
        # *   **NOT_AVAILABLE**: Unavailable
        self.status = status
        # The type of the address pool. Valid values:
        # 
        # *   **IP**: IP address
        # *   **DOMAIN**: Domain name
        self.type = type
        # The last time when the address pool was updated.
        self.update_time = update_time
        # A timestamp that indicates the last time the address pool was updated.
        self.update_timestamp = update_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_count is not None:
            result['AddrCount'] = self.addr_count
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.min_available_addr_num is not None:
            result['MinAvailableAddrNum'] = self.min_available_addr_num
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        if self.monitor_status is not None:
            result['MonitorStatus'] = self.monitor_status
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrCount') is not None:
            self.addr_count = m.get('AddrCount')
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('MinAvailableAddrNum') is not None:
            self.min_available_addr_num = m.get('MinAvailableAddrNum')
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        if m.get('MonitorStatus') is not None:
            self.monitor_status = m.get('MonitorStatus')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        return self


class DescribeGtmInstanceAddressPoolsResponseBodyAddrPools(TeaModel):
    def __init__(
        self,
        addr_pool: List[DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool] = None,
    ):
        self.addr_pool = addr_pool

    def validate(self):
        if self.addr_pool:
            for k in self.addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AddrPool'] = []
        if self.addr_pool is not None:
            for k in self.addr_pool:
                result['AddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.addr_pool = []
        if m.get('AddrPool') is not None:
            for k in m.get('AddrPool'):
                temp_model = DescribeGtmInstanceAddressPoolsResponseBodyAddrPoolsAddrPool()
                self.addr_pool.append(temp_model.from_map(k))
        return self


class DescribeGtmInstanceAddressPoolsResponseBody(TeaModel):
    def __init__(
        self,
        addr_pools: DescribeGtmInstanceAddressPoolsResponseBodyAddrPools = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The returned list of address pools of the GTM instance.
        self.addr_pools = addr_pools
        # The number of the page returned.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned on all pages.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.addr_pools:
            self.addr_pools.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pools is not None:
            result['AddrPools'] = self.addr_pools.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPools') is not None:
            temp_model = DescribeGtmInstanceAddressPoolsResponseBodyAddrPools()
            self.addr_pools = temp_model.from_map(m['AddrPools'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeGtmInstanceAddressPoolsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmInstanceAddressPoolsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmInstanceAddressPoolsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmInstanceStatusRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
    ):
        # The ID of the instance to query.
        self.instance_id = instance_id
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeGtmInstanceStatusResponseBody(TeaModel):
    def __init__(
        self,
        addr_not_available_num: int = None,
        addr_pool_not_available_num: int = None,
        request_id: str = None,
        status: str = None,
        status_reason: str = None,
        strategy_not_available_num: int = None,
        switch_to_failover_strategy_num: int = None,
    ):
        # The number of unavailable addresses.
        self.addr_not_available_num = addr_not_available_num
        # The number of unavailable address pools.
        self.addr_pool_not_available_num = addr_pool_not_available_num
        # The ID of the request.
        self.request_id = request_id
        # The status of the instance. Valid values:
        # 
        # *   ALLOW: Operations on the instance are allowed.
        # *   DENY: Operations on the instance are not allowed.
        self.status = status
        # List of reasons for an instance status. Valid values:
        # 
        # *   INSTANCE_OPERATE_BLACK_LIST: The instance is in the blacklist.
        # *   BETA_INSTANCE: The instance is in public preview.
        self.status_reason = status_reason
        # The number of access policies that are unavailable in the active address pool.
        self.strategy_not_available_num = strategy_not_available_num
        # The number of access policies that fail over to the secondary address pool.
        self.switch_to_failover_strategy_num = switch_to_failover_strategy_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_not_available_num is not None:
            result['AddrNotAvailableNum'] = self.addr_not_available_num
        if self.addr_pool_not_available_num is not None:
            result['AddrPoolNotAvailableNum'] = self.addr_pool_not_available_num
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.status_reason is not None:
            result['StatusReason'] = self.status_reason
        if self.strategy_not_available_num is not None:
            result['StrategyNotAvailableNum'] = self.strategy_not_available_num
        if self.switch_to_failover_strategy_num is not None:
            result['SwitchToFailoverStrategyNum'] = self.switch_to_failover_strategy_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrNotAvailableNum') is not None:
            self.addr_not_available_num = m.get('AddrNotAvailableNum')
        if m.get('AddrPoolNotAvailableNum') is not None:
            self.addr_pool_not_available_num = m.get('AddrPoolNotAvailableNum')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusReason') is not None:
            self.status_reason = m.get('StatusReason')
        if m.get('StrategyNotAvailableNum') is not None:
            self.strategy_not_available_num = m.get('StrategyNotAvailableNum')
        if m.get('SwitchToFailoverStrategyNum') is not None:
            self.switch_to_failover_strategy_num = m.get('SwitchToFailoverStrategyNum')
        return self


class DescribeGtmInstanceStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmInstanceStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmInstanceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmInstanceSystemCnameRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
    ):
        # The ID of the Global Traffic Manager (GTM) instance.
        self.instance_id = instance_id
        # The language used by the user.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeGtmInstanceSystemCnameResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        system_cname: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The CNAME record assigned by the system.
        self.system_cname = system_cname

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.system_cname is not None:
            result['SystemCname'] = self.system_cname
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SystemCname') is not None:
            self.system_cname = m.get('SystemCname')
        return self


class DescribeGtmInstanceSystemCnameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmInstanceSystemCnameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmInstanceSystemCnameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmInstancesRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        lang: str = None,
        need_detail_attributes: bool = None,
        page_number: int = None,
        page_size: int = None,
        resource_group_id: str = None,
    ):
        # The keyword that you use for query. Exact match is supported by instance ID or instance name.
        self.keyword = keyword
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
        self.lang = lang
        # Specifies whether additional information is required. Default value: **false**.
        self.need_detail_attributes = need_detail_attributes
        # The page number to return.
        self.page_number = page_number
        # The number of entries to return per page.
        self.page_size = page_size
        # The ID of the resource group.
        self.resource_group_id = resource_group_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.need_detail_attributes is not None:
            result['NeedDetailAttributes'] = self.need_detail_attributes
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NeedDetailAttributes') is not None:
            self.need_detail_attributes = m.get('NeedDetailAttributes')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        return self


class DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance(TeaModel):
    def __init__(
        self,
        access_strategy_num: int = None,
        address_pool_num: int = None,
        alert_group: str = None,
        cname: str = None,
        cname_mode: str = None,
        create_time: str = None,
        create_timestamp: int = None,
        expire_time: str = None,
        expire_timestamp: int = None,
        instance_id: str = None,
        instance_name: str = None,
        lba_strategy: str = None,
        resource_group_id: str = None,
        ttl: int = None,
        user_domain_name: str = None,
        version_code: str = None,
    ):
        # The number of access policies.
        self.access_strategy_num = access_strategy_num
        # The number of address pools.
        self.address_pool_num = address_pool_num
        # The name of the alert group.
        self.alert_group = alert_group
        # The CNAME domain name that is used to access the instance.
        self.cname = cname
        # The CNAME domain name used to access the instance. Valid values:
        # 
        # *   **SYSTEM_ASSIGN**: A CNAME domain name assigned by the system is used.
        # *   **CUSTOM**: A custom CNAME domain name is used.
        self.cname_mode = cname_mode
        # The time when the instance was created.
        self.create_time = create_time
        # The UNIX timestamp that indicates when the instance was created.
        self.create_timestamp = create_timestamp
        # The time when the instance expires.
        self.expire_time = expire_time
        # The UNIX timestamp that indicates when the instance expires.
        self.expire_timestamp = expire_timestamp
        # The ID of the instance.
        self.instance_id = instance_id
        # The name of the instance.
        self.instance_name = instance_name
        # The load balancing policy that is used. Valid values:
        # 
        # *   **ALL_RR**: Load balancing
        # *   **RATIO**: Weighted round-robin
        self.lba_strategy = lba_strategy
        # The ID of the resource group to which the instance belongs.
        self.resource_group_id = resource_group_id
        # The global time to live (TTL).
        self.ttl = ttl
        # The domain name of the user.
        self.user_domain_name = user_domain_name
        # The version code of the instance.
        self.version_code = version_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_strategy_num is not None:
            result['AccessStrategyNum'] = self.access_strategy_num
        if self.address_pool_num is not None:
            result['AddressPoolNum'] = self.address_pool_num
        if self.alert_group is not None:
            result['AlertGroup'] = self.alert_group
        if self.cname is not None:
            result['Cname'] = self.cname
        if self.cname_mode is not None:
            result['CnameMode'] = self.cname_mode
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.expire_timestamp is not None:
            result['ExpireTimestamp'] = self.expire_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.lba_strategy is not None:
            result['LbaStrategy'] = self.lba_strategy
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.user_domain_name is not None:
            result['UserDomainName'] = self.user_domain_name
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessStrategyNum') is not None:
            self.access_strategy_num = m.get('AccessStrategyNum')
        if m.get('AddressPoolNum') is not None:
            self.address_pool_num = m.get('AddressPoolNum')
        if m.get('AlertGroup') is not None:
            self.alert_group = m.get('AlertGroup')
        if m.get('Cname') is not None:
            self.cname = m.get('Cname')
        if m.get('CnameMode') is not None:
            self.cname_mode = m.get('CnameMode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('ExpireTimestamp') is not None:
            self.expire_timestamp = m.get('ExpireTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('LbaStrategy') is not None:
            self.lba_strategy = m.get('LbaStrategy')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('UserDomainName') is not None:
            self.user_domain_name = m.get('UserDomainName')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        return self


class DescribeGtmInstancesResponseBodyGtmInstances(TeaModel):
    def __init__(
        self,
        gtm_instance: List[DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance] = None,
    ):
        self.gtm_instance = gtm_instance

    def validate(self):
        if self.gtm_instance:
            for k in self.gtm_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GtmInstance'] = []
        if self.gtm_instance is not None:
            for k in self.gtm_instance:
                result['GtmInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.gtm_instance = []
        if m.get('GtmInstance') is not None:
            for k in m.get('GtmInstance'):
                temp_model = DescribeGtmInstancesResponseBodyGtmInstancesGtmInstance()
                self.gtm_instance.append(temp_model.from_map(k))
        return self


class DescribeGtmInstancesResponseBody(TeaModel):
    def __init__(
        self,
        gtm_instances: DescribeGtmInstancesResponseBodyGtmInstances = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The list of queried instances.
        self.gtm_instances = gtm_instances
        # The returned page number.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.gtm_instances:
            self.gtm_instances.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.gtm_instances is not None:
            result['GtmInstances'] = self.gtm_instances.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GtmInstances') is not None:
            temp_model = DescribeGtmInstancesResponseBodyGtmInstances()
            self.gtm_instances = temp_model.from_map(m['GtmInstances'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeGtmInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmLogsRequest(TeaModel):
    def __init__(
        self,
        end_timestamp: int = None,
        instance_id: str = None,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        start_timestamp: int = None,
    ):
        self.end_timestamp = end_timestamp
        # The ID of the GTM instance whose logs you want to query.
        self.instance_id = instance_id
        # The keyword for searching logs, in case-insensitive "%Keyword%" format.
        self.keyword = keyword
        # The language used by the user.
        self.lang = lang
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on per page. Maximum value: **100**. Default value: **20**.
        self.page_size = page_size
        # The beginning of the time range to query.
        self.start_timestamp = start_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_timestamp is not None:
            result['EndTimestamp'] = self.end_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_timestamp is not None:
            result['StartTimestamp'] = self.start_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTimestamp') is not None:
            self.end_timestamp = m.get('EndTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTimestamp') is not None:
            self.start_timestamp = m.get('StartTimestamp')
        return self


class DescribeGtmLogsResponseBodyLogsLog(TeaModel):
    def __init__(
        self,
        content: str = None,
        entity_id: str = None,
        entity_name: str = None,
        entity_type: str = None,
        id: int = None,
        oper_action: str = None,
        oper_ip: str = None,
        oper_time: str = None,
        oper_timestamp: int = None,
    ):
        # The formatted message content.
        self.content = content
        # The ID of the object that was operated on.
        self.entity_id = entity_id
        # The name of the object that was operated on.
        self.entity_name = entity_name
        # The type of the object that was operated on.
        self.entity_type = entity_type
        # The ID of the log record.
        self.id = id
        # The operation performed.
        self.oper_action = oper_action
        # The IP address subject to the operation.
        self.oper_ip = oper_ip
        # The time when the operation was performed.
        self.oper_time = oper_time
        # A timestamp that indicates the time when the operation was performed.
        self.oper_timestamp = oper_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.entity_id is not None:
            result['EntityId'] = self.entity_id
        if self.entity_name is not None:
            result['EntityName'] = self.entity_name
        if self.entity_type is not None:
            result['EntityType'] = self.entity_type
        if self.id is not None:
            result['Id'] = self.id
        if self.oper_action is not None:
            result['OperAction'] = self.oper_action
        if self.oper_ip is not None:
            result['OperIp'] = self.oper_ip
        if self.oper_time is not None:
            result['OperTime'] = self.oper_time
        if self.oper_timestamp is not None:
            result['OperTimestamp'] = self.oper_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('EntityId') is not None:
            self.entity_id = m.get('EntityId')
        if m.get('EntityName') is not None:
            self.entity_name = m.get('EntityName')
        if m.get('EntityType') is not None:
            self.entity_type = m.get('EntityType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('OperAction') is not None:
            self.oper_action = m.get('OperAction')
        if m.get('OperIp') is not None:
            self.oper_ip = m.get('OperIp')
        if m.get('OperTime') is not None:
            self.oper_time = m.get('OperTime')
        if m.get('OperTimestamp') is not None:
            self.oper_timestamp = m.get('OperTimestamp')
        return self


class DescribeGtmLogsResponseBodyLogs(TeaModel):
    def __init__(
        self,
        log: List[DescribeGtmLogsResponseBodyLogsLog] = None,
    ):
        self.log = log

    def validate(self):
        if self.log:
            for k in self.log:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Log'] = []
        if self.log is not None:
            for k in self.log:
                result['Log'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.log = []
        if m.get('Log') is not None:
            for k in m.get('Log'):
                temp_model = DescribeGtmLogsResponseBodyLogsLog()
                self.log.append(temp_model.from_map(k))
        return self


class DescribeGtmLogsResponseBody(TeaModel):
    def __init__(
        self,
        logs: DescribeGtmLogsResponseBodyLogs = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The list of logs returned.
        self.logs = logs
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned on all pages.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.logs:
            self.logs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logs is not None:
            result['Logs'] = self.logs.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Logs') is not None:
            temp_model = DescribeGtmLogsResponseBodyLogs()
            self.logs = temp_model.from_map(m['Logs'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeGtmLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmLogsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmMonitorAvailableConfigRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language of the values of specific response parameters.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        default_selected: bool = None,
        group_name: str = None,
        group_type: str = None,
        isp_code: str = None,
        isp_name: str = None,
        mainland: bool = None,
    ):
        # The code of the city where the monitored node is deployed.
        self.city_code = city_code
        # The display name of the city where the monitored node is deployed.
        self.city_name = city_name
        # Indicates whether the monitored node is selected for the health check by default.
        self.default_selected = default_selected
        # The name of the group to which the monitored node belongs.
        # 
        # Valid values: Overseas Nodes, BGP Nodes, and ISP Nodes.
        self.group_name = group_name
        # The type of the group to which the monitored node belongs.
        # 
        # Valid values: BGP, OVERSEAS, and ISP.
        self.group_type = group_type
        # The code of the Internet service provider (ISP) to which the monitored node belongs.
        # 
        # *   If the value of the GroupType parameter is BGP or OVERSEAS, the value of IspCode is 465 by default.
        # *   If the value of the GroupType parameter is not BGP or OVERSEAS, valid values of IspCode are 232, 132, and 5. and is used together with CityCode.
        self.isp_code = isp_code
        # The display name of the ISP to which the monitored node belongs.
        self.isp_name = isp_name
        # Indicates whether the monitored node is deployed in the Chinese mainland.
        self.mainland = mainland

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.default_selected is not None:
            result['DefaultSelected'] = self.default_selected
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        if self.mainland is not None:
            result['Mainland'] = self.mainland
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('DefaultSelected') is not None:
            self.default_selected = m.get('DefaultSelected')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        if m.get('Mainland') is not None:
            self.mainland = m.get('Mainland')
        return self


class DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodes(TeaModel):
    def __init__(
        self,
        isp_city_node: List[DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode] = None,
    ):
        self.isp_city_node = isp_city_node

    def validate(self):
        if self.isp_city_node:
            for k in self.isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IspCityNode'] = []
        if self.isp_city_node is not None:
            for k in self.isp_city_node:
                result['IspCityNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.isp_city_node = []
        if m.get('IspCityNode') is not None:
            for k in m.get('IspCityNode'):
                temp_model = DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodesIspCityNode()
                self.isp_city_node.append(temp_model.from_map(k))
        return self


class DescribeGtmMonitorAvailableConfigResponseBody(TeaModel):
    def __init__(
        self,
        isp_city_nodes: DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodes = None,
        request_id: str = None,
    ):
        # The monitored nodes.
        self.isp_city_nodes = isp_city_nodes
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.isp_city_nodes:
            self.isp_city_nodes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.isp_city_nodes is not None:
            result['IspCityNodes'] = self.isp_city_nodes.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IspCityNodes') is not None:
            temp_model = DescribeGtmMonitorAvailableConfigResponseBodyIspCityNodes()
            self.isp_city_nodes = temp_model.from_map(m['IspCityNodes'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGtmMonitorAvailableConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmMonitorAvailableConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmMonitorAvailableConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmMonitorConfigRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        monitor_config_id: str = None,
    ):
        # The language of the values of specific response parameters.
        self.lang = lang
        # The ID of the health check configuration.
        self.monitor_config_id = monitor_config_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        return self


class DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode(TeaModel):
    def __init__(
        self,
        city_code: str = None,
        city_name: str = None,
        country_code: str = None,
        country_name: str = None,
        isp_code: str = None,
        isp_name: str = None,
    ):
        # The code of the city where the monitored node is deployed.
        self.city_code = city_code
        # The display name of the city where the monitored node is deployed.
        self.city_name = city_name
        # The code of the country where the monitored node is deployed.
        self.country_code = country_code
        # The display name of the country where the monitored node is deployed.
        self.country_name = country_name
        # The code of the Internet service provider (ISP) to which the monitored node belongs.
        self.isp_code = isp_code
        # The display name of the ISP to which the monitored node belongs.
        self.isp_name = isp_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.city_code is not None:
            result['CityCode'] = self.city_code
        if self.city_name is not None:
            result['CityName'] = self.city_name
        if self.country_code is not None:
            result['CountryCode'] = self.country_code
        if self.country_name is not None:
            result['CountryName'] = self.country_name
        if self.isp_code is not None:
            result['IspCode'] = self.isp_code
        if self.isp_name is not None:
            result['IspName'] = self.isp_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CityCode') is not None:
            self.city_code = m.get('CityCode')
        if m.get('CityName') is not None:
            self.city_name = m.get('CityName')
        if m.get('CountryCode') is not None:
            self.country_code = m.get('CountryCode')
        if m.get('CountryName') is not None:
            self.country_name = m.get('CountryName')
        if m.get('IspCode') is not None:
            self.isp_code = m.get('IspCode')
        if m.get('IspName') is not None:
            self.isp_name = m.get('IspName')
        return self


class DescribeGtmMonitorConfigResponseBodyIspCityNodes(TeaModel):
    def __init__(
        self,
        isp_city_node: List[DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode] = None,
    ):
        self.isp_city_node = isp_city_node

    def validate(self):
        if self.isp_city_node:
            for k in self.isp_city_node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IspCityNode'] = []
        if self.isp_city_node is not None:
            for k in self.isp_city_node:
                result['IspCityNode'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.isp_city_node = []
        if m.get('IspCityNode') is not None:
            for k in m.get('IspCityNode'):
                temp_model = DescribeGtmMonitorConfigResponseBodyIspCityNodesIspCityNode()
                self.isp_city_node.append(temp_model.from_map(k))
        return self


class DescribeGtmMonitorConfigResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_timestamp: int = None,
        evaluation_count: int = None,
        interval: int = None,
        isp_city_nodes: DescribeGtmMonitorConfigResponseBodyIspCityNodes = None,
        monitor_config_id: str = None,
        monitor_extend_info: str = None,
        protocol_type: str = None,
        request_id: str = None,
        timeout: int = None,
        update_time: str = None,
        update_timestamp: int = None,
    ):
        # The time when the health check configuration was created.
        self.create_time = create_time
        # The timestamp that indicates the time when the health check configuration was created.
        self.create_timestamp = create_timestamp
        # The maximum number of consecutive exceptions detected. If the number of consecutive exceptions detected reaches the maximum number, the application service is deemed abnormal.
        self.evaluation_count = evaluation_count
        # The health check interval. Unit: seconds. The value is 60.
        self.interval = interval
        # The monitored nodes.
        self.isp_city_nodes = isp_city_nodes
        # The ID of the health check configuration.
        self.monitor_config_id = monitor_config_id
        # The extended information, that is, the parameters required for the protocol. Different protocols require different parameters:
        # 
        # HTTP or HTTPS:
        # 
        # *   port: the port to check.
        # *   failureRate: the failure rate.
        # *   code: the status code threshold. If the returned status code is greater than the specified threshold, the application service is deemed abnormal. Valid values: 400 and 500.
        # *   host: the host configuration.
        # *   path: the health check URL.
        # 
        # PING:
        # 
        # *   packetNum: the number of ping packets.
        # *   packetLossRate: the loss rate of ping packets.
        # *   failureRate: the failure rate.
        # 
        # TCP:
        # 
        # *   port: the port to check.
        # *   failureRate: the failure rate.
        self.monitor_extend_info = monitor_extend_info
        # The protocol used for the health check.
        self.protocol_type = protocol_type
        # The ID of the request.
        self.request_id = request_id
        # The health check timeout period. Unit: milliseconds. Valid values: 2000, 3000, 5000, and 10000.
        self.timeout = timeout
        # The time when the health check configuration was last updated.
        self.update_time = update_time
        # The timestamp that indicates the time when the health check configuration was last updated.
        self.update_timestamp = update_timestamp

    def validate(self):
        if self.isp_city_nodes:
            self.isp_city_nodes.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.evaluation_count is not None:
            result['EvaluationCount'] = self.evaluation_count
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.isp_city_nodes is not None:
            result['IspCityNodes'] = self.isp_city_nodes.to_map()
        if self.monitor_config_id is not None:
            result['MonitorConfigId'] = self.monitor_config_id
        if self.monitor_extend_info is not None:
            result['MonitorExtendInfo'] = self.monitor_extend_info
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('EvaluationCount') is not None:
            self.evaluation_count = m.get('EvaluationCount')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('IspCityNodes') is not None:
            temp_model = DescribeGtmMonitorConfigResponseBodyIspCityNodes()
            self.isp_city_nodes = temp_model.from_map(m['IspCityNodes'])
        if m.get('MonitorConfigId') is not None:
            self.monitor_config_id = m.get('MonitorConfigId')
        if m.get('MonitorExtendInfo') is not None:
            self.monitor_extend_info = m.get('MonitorExtendInfo')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        return self


class DescribeGtmMonitorConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmMonitorConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmMonitorConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmRecoveryPlanRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        recovery_plan_id: int = None,
    ):
        # The language used by the user.
        self.lang = lang
        # The ID of the disaster recovery plan that you want to query.
        self.recovery_plan_id = recovery_plan_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.recovery_plan_id is not None:
            result['RecoveryPlanId'] = self.recovery_plan_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RecoveryPlanId') is not None:
            self.recovery_plan_id = m.get('RecoveryPlanId')
        return self


class DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr(TeaModel):
    def __init__(
        self,
        id: int = None,
        mode: str = None,
        value: str = None,
    ):
        # The ID of the address.
        self.id = id
        # The address work mode. It is the mode that was set for the IP address to work.
        self.mode = mode
        # The address value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.mode is not None:
            result['Mode'] = self.mode
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Mode') is not None:
            self.mode = m.get('Mode')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrs(TeaModel):
    def __init__(
        self,
        addr: List[DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr] = None,
    ):
        self.addr = addr

    def validate(self):
        if self.addr:
            for k in self.addr:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Addr'] = []
        if self.addr is not None:
            for k in self.addr:
                result['Addr'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.addr = []
        if m.get('Addr') is not None:
            for k in m.get('Addr'):
                temp_model = DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrsAddr()
                self.addr.append(temp_model.from_map(k))
        return self


class DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        addr_pool_name: str = None,
        addrs: DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrs = None,
        instance_id: str = None,
    ):
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The name of the address pool.
        self.addr_pool_name = addr_pool_name
        # The list of addresses in the address pool.
        self.addrs = addrs
        # The ID of the GTM instance.
        self.instance_id = instance_id

    def validate(self):
        if self.addrs:
            self.addrs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.addr_pool_name is not None:
            result['AddrPoolName'] = self.addr_pool_name
        if self.addrs is not None:
            result['Addrs'] = self.addrs.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('AddrPoolName') is not None:
            self.addr_pool_name = m.get('AddrPoolName')
        if m.get('Addrs') is not None:
            temp_model = DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPoolAddrs()
            self.addrs = temp_model.from_map(m['Addrs'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeGtmRecoveryPlanResponseBodyFaultAddrPools(TeaModel):
    def __init__(
        self,
        fault_addr_pool: List[DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool] = None,
    ):
        self.fault_addr_pool = fault_addr_pool

    def validate(self):
        if self.fault_addr_pool:
            for k in self.fault_addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FaultAddrPool'] = []
        if self.fault_addr_pool is not None:
            for k in self.fault_addr_pool:
                result['FaultAddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.fault_addr_pool = []
        if m.get('FaultAddrPool') is not None:
            for k in m.get('FaultAddrPool'):
                temp_model = DescribeGtmRecoveryPlanResponseBodyFaultAddrPoolsFaultAddrPool()
                self.fault_addr_pool.append(temp_model.from_map(k))
        return self


class DescribeGtmRecoveryPlanResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_timestamp: int = None,
        fault_addr_pool_num: int = None,
        fault_addr_pools: DescribeGtmRecoveryPlanResponseBodyFaultAddrPools = None,
        last_execute_time: str = None,
        last_execute_timestamp: int = None,
        last_rollback_time: str = None,
        last_rollback_timestamp: int = None,
        name: str = None,
        recovery_plan_id: int = None,
        remark: str = None,
        request_id: str = None,
        status: str = None,
        update_time: str = None,
        update_timestamp: int = None,
    ):
        # The time when the disaster recovery plan was created.
        self.create_time = create_time
        self.create_timestamp = create_timestamp
        # The number of faulty address pools.
        self.fault_addr_pool_num = fault_addr_pool_num
        # The list of faulty address pools.
        self.fault_addr_pools = fault_addr_pools
        # The last time when the recovery plan was executed.
        self.last_execute_time = last_execute_time
        # A timestamp that indicates the last time when the recovery plan was executed.
        self.last_execute_timestamp = last_execute_timestamp
        # The last time when the disaster recovery plan was rolled back.
        self.last_rollback_time = last_rollback_time
        # A timestamp that indicates the last time when the disaster recovery plan was rolled back.
        self.last_rollback_timestamp = last_rollback_timestamp
        # The name of the disaster recovery plan queried.
        self.name = name
        # The ID of the disaster recovery plan queried.
        self.recovery_plan_id = recovery_plan_id
        # The remarks on the disaster recovery plan.
        self.remark = remark
        # The ID of the request.
        self.request_id = request_id
        # The status of the disaster recovery plan queried.
        self.status = status
        # The last time when the disaster recovery plan was updated.
        self.update_time = update_time
        # A timestamp that indicates the last time when the disaster recovery plan was updated.
        self.update_timestamp = update_timestamp

    def validate(self):
        if self.fault_addr_pools:
            self.fault_addr_pools.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.fault_addr_pool_num is not None:
            result['FaultAddrPoolNum'] = self.fault_addr_pool_num
        if self.fault_addr_pools is not None:
            result['FaultAddrPools'] = self.fault_addr_pools.to_map()
        if self.last_execute_time is not None:
            result['LastExecuteTime'] = self.last_execute_time
        if self.last_execute_timestamp is not None:
            result['LastExecuteTimestamp'] = self.last_execute_timestamp
        if self.last_rollback_time is not None:
            result['LastRollbackTime'] = self.last_rollback_time
        if self.last_rollback_timestamp is not None:
            result['LastRollbackTimestamp'] = self.last_rollback_timestamp
        if self.name is not None:
            result['Name'] = self.name
        if self.recovery_plan_id is not None:
            result['RecoveryPlanId'] = self.recovery_plan_id
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('FaultAddrPoolNum') is not None:
            self.fault_addr_pool_num = m.get('FaultAddrPoolNum')
        if m.get('FaultAddrPools') is not None:
            temp_model = DescribeGtmRecoveryPlanResponseBodyFaultAddrPools()
            self.fault_addr_pools = temp_model.from_map(m['FaultAddrPools'])
        if m.get('LastExecuteTime') is not None:
            self.last_execute_time = m.get('LastExecuteTime')
        if m.get('LastExecuteTimestamp') is not None:
            self.last_execute_timestamp = m.get('LastExecuteTimestamp')
        if m.get('LastRollbackTime') is not None:
            self.last_rollback_time = m.get('LastRollbackTime')
        if m.get('LastRollbackTimestamp') is not None:
            self.last_rollback_timestamp = m.get('LastRollbackTimestamp')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RecoveryPlanId') is not None:
            self.recovery_plan_id = m.get('RecoveryPlanId')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        return self


class DescribeGtmRecoveryPlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmRecoveryPlanResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmRecoveryPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmRecoveryPlanAvailableConfigRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language used by the user.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool(TeaModel):
    def __init__(
        self,
        addr_pool_id: str = None,
        name: str = None,
    ):
        # The ID of the address pool.
        self.addr_pool_id = addr_pool_id
        # The name of the address pool.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pool_id is not None:
            result['AddrPoolId'] = self.addr_pool_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPoolId') is not None:
            self.addr_pool_id = m.get('AddrPoolId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPools(TeaModel):
    def __init__(
        self,
        addr_pool: List[DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool] = None,
    ):
        self.addr_pool = addr_pool

    def validate(self):
        if self.addr_pool:
            for k in self.addr_pool:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AddrPool'] = []
        if self.addr_pool is not None:
            for k in self.addr_pool:
                result['AddrPool'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.addr_pool = []
        if m.get('AddrPool') is not None:
            for k in m.get('AddrPool'):
                temp_model = DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPoolsAddrPool()
                self.addr_pool.append(temp_model.from_map(k))
        return self


class DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance(TeaModel):
    def __init__(
        self,
        addr_pools: DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPools = None,
        instance_id: str = None,
        instance_name: str = None,
    ):
        # The list of address pools for the GTM instance.
        self.addr_pools = addr_pools
        # The ID of the GTM instance.
        self.instance_id = instance_id
        # The name of the GTM instance.
        self.instance_name = instance_name

    def validate(self):
        if self.addr_pools:
            self.addr_pools.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.addr_pools is not None:
            result['AddrPools'] = self.addr_pools.to_map()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AddrPools') is not None:
            temp_model = DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstanceAddrPools()
            self.addr_pools = temp_model.from_map(m['AddrPools'])
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        return self


class DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstances(TeaModel):
    def __init__(
        self,
        instance: List[DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance] = None,
    ):
        self.instance = instance

    def validate(self):
        if self.instance:
            for k in self.instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instance'] = []
        if self.instance is not None:
            for k in self.instance:
                result['Instance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance = []
        if m.get('Instance') is not None:
            for k in m.get('Instance'):
                temp_model = DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstancesInstance()
                self.instance.append(temp_model.from_map(k))
        return self


class DescribeGtmRecoveryPlanAvailableConfigResponseBody(TeaModel):
    def __init__(
        self,
        instances: DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstances = None,
        request_id: str = None,
    ):
        # The list of GTM instances involved in the disaster recovery plan.
        self.instances = instances
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.instances:
            self.instances.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instances is not None:
            result['Instances'] = self.instances.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Instances') is not None:
            temp_model = DescribeGtmRecoveryPlanAvailableConfigResponseBodyInstances()
            self.instances = temp_model.from_map(m['Instances'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGtmRecoveryPlanAvailableConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmRecoveryPlanAvailableConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmRecoveryPlanAvailableConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGtmRecoveryPlansRequest(TeaModel):
    def __init__(
        self,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The keyword for the query. Fuzzy match is supported by disaster recovery plan name.
        self.keyword = keyword
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
        self.lang = lang
        # The page number to return. The page number starts from **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return per page. Maximum value: **100**. Default value: **20**.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_timestamp: int = None,
        fault_addr_pool_num: int = None,
        last_execute_time: str = None,
        last_execute_timestamp: int = None,
        last_rollback_time: str = None,
        last_rollback_timestamp: int = None,
        name: str = None,
        recovery_plan_id: int = None,
        remark: str = None,
        status: str = None,
        update_time: str = None,
        update_timestamp: int = None,
    ):
        # The time when the disaster recovery plan was created.
        self.create_time = create_time
        # The UNIX timestamp that indicates when the disaster recovery plan was created.
        self.create_timestamp = create_timestamp
        # The number of faulty address pools.
        self.fault_addr_pool_num = fault_addr_pool_num
        # The last time when the disaster recovery plan was executed.
        self.last_execute_time = last_execute_time
        # The UNIX timestamp that indicates the last time when the disaster recovery plan was executed.
        self.last_execute_timestamp = last_execute_timestamp
        # The last time when the disaster recovery plan was rolled back.
        self.last_rollback_time = last_rollback_time
        # The UNIX timestamp that indicates the last time when the disaster recovery plan was rolled back.
        self.last_rollback_timestamp = last_rollback_timestamp
        # The name of the disaster recovery plan.
        self.name = name
        # The ID of the disaster recovery plan.
        self.recovery_plan_id = recovery_plan_id
        # The remarks about the disaster recovery plan.
        self.remark = remark
        # The status of the disaster recovery plan. Valid values:
        # 
        # *   **UNEXECUTED**: The plan is not executed.
        # *   **EXECUTED**: The plan is executed.
        # *   **ROLLED_BACK**: The plan is rolled back.
        self.status = status
        # The last time when the disaster recovery plan was updated.
        self.update_time = update_time
        # The UNIX timestamp that indicates the last time when the disaster recovery plan was updated.
        self.update_timestamp = update_timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.fault_addr_pool_num is not None:
            result['FaultAddrPoolNum'] = self.fault_addr_pool_num
        if self.last_execute_time is not None:
            result['LastExecuteTime'] = self.last_execute_time
        if self.last_execute_timestamp is not None:
            result['LastExecuteTimestamp'] = self.last_execute_timestamp
        if self.last_rollback_time is not None:
            result['LastRollbackTime'] = self.last_rollback_time
        if self.last_rollback_timestamp is not None:
            result['LastRollbackTimestamp'] = self.last_rollback_timestamp
        if self.name is not None:
            result['Name'] = self.name
        if self.recovery_plan_id is not None:
            result['RecoveryPlanId'] = self.recovery_plan_id
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        if self.update_timestamp is not None:
            result['UpdateTimestamp'] = self.update_timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('FaultAddrPoolNum') is not None:
            self.fault_addr_pool_num = m.get('FaultAddrPoolNum')
        if m.get('LastExecuteTime') is not None:
            self.last_execute_time = m.get('LastExecuteTime')
        if m.get('LastExecuteTimestamp') is not None:
            self.last_execute_timestamp = m.get('LastExecuteTimestamp')
        if m.get('LastRollbackTime') is not None:
            self.last_rollback_time = m.get('LastRollbackTime')
        if m.get('LastRollbackTimestamp') is not None:
            self.last_rollback_timestamp = m.get('LastRollbackTimestamp')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RecoveryPlanId') is not None:
            self.recovery_plan_id = m.get('RecoveryPlanId')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        if m.get('UpdateTimestamp') is not None:
            self.update_timestamp = m.get('UpdateTimestamp')
        return self


class DescribeGtmRecoveryPlansResponseBodyRecoveryPlans(TeaModel):
    def __init__(
        self,
        recovery_plan: List[DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan] = None,
    ):
        self.recovery_plan = recovery_plan

    def validate(self):
        if self.recovery_plan:
            for k in self.recovery_plan:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecoveryPlan'] = []
        if self.recovery_plan is not None:
            for k in self.recovery_plan:
                result['RecoveryPlan'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.recovery_plan = []
        if m.get('RecoveryPlan') is not None:
            for k in m.get('RecoveryPlan'):
                temp_model = DescribeGtmRecoveryPlansResponseBodyRecoveryPlansRecoveryPlan()
                self.recovery_plan.append(temp_model.from_map(k))
        return self


class DescribeGtmRecoveryPlansResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        recovery_plans: DescribeGtmRecoveryPlansResponseBodyRecoveryPlans = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The details about the queried disaster recovery plans.
        self.recovery_plans = recovery_plans
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.recovery_plans:
            self.recovery_plans.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.recovery_plans is not None:
            result['RecoveryPlans'] = self.recovery_plans.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecoveryPlans') is not None:
            temp_model = DescribeGtmRecoveryPlansResponseBodyRecoveryPlans()
            self.recovery_plans = temp_model.from_map(m['RecoveryPlans'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeGtmRecoveryPlansResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGtmRecoveryPlansResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGtmRecoveryPlansResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceDomainsRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        # The ID of the instance.
        self.instance_id = instance_id
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages.
        self.lang = lang
        # The page number to return. The page number starts from 1. Default value: 1.
        self.page_number = page_number
        # The number of entries to return per page. Maximum value: 100. Default value: 20.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeInstanceDomainsResponseBodyInstanceDomains(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_timestamp: int = None,
        domain_name: str = None,
    ):
        # The time when the domain name was bound with the instance.
        self.create_time = create_time
        # The UNIX timestamp that indicates when the domain name was bound with the instance.
        self.create_timestamp = create_timestamp
        # The domain name.
        self.domain_name = domain_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        return self


class DescribeInstanceDomainsResponseBody(TeaModel):
    def __init__(
        self,
        instance_domains: List[DescribeInstanceDomainsResponseBodyInstanceDomains] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The domain names that are bound to the instance.
        self.instance_domains = instance_domains
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.instance_domains:
            for k in self.instance_domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['InstanceDomains'] = []
        if self.instance_domains is not None:
            for k in self.instance_domains:
                result['InstanceDomains'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instance_domains = []
        if m.get('InstanceDomains') is not None:
            for k in m.get('InstanceDomains'):
                temp_model = DescribeInstanceDomainsResponseBodyInstanceDomains()
                self.instance_domains.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeInstanceDomainsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceDomainsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIspFlushCacheInstancesRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        isp: str = None,
        keyword: str = None,
        lang: str = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
        type: str = None,
    ):
        self.direction = direction
        self.isp = isp
        self.keyword = keyword
        self.lang = lang
        self.order_by = order_by
        self.page_number = page_number
        self.page_size = page_size
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo(TeaModel):
    def __init__(
        self,
        instance_quota: int = None,
        instance_quota_used: int = None,
    ):
        self.instance_quota = instance_quota
        self.instance_quota_used = instance_quota_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_quota is not None:
            result['InstanceQuota'] = self.instance_quota
        if self.instance_quota_used is not None:
            result['InstanceQuotaUsed'] = self.instance_quota_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceQuota') is not None:
            self.instance_quota = m.get('InstanceQuota')
        if m.get('InstanceQuotaUsed') is not None:
            self.instance_quota_used = m.get('InstanceQuotaUsed')
        return self


class DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances(TeaModel):
    def __init__(
        self,
        expire_time: str = None,
        expire_timestamp: int = None,
        instance_id: str = None,
        instance_name: str = None,
        isp: str = None,
        quota_info: DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo = None,
        status: str = None,
        version_code: str = None,
    ):
        self.expire_time = expire_time
        self.expire_timestamp = expire_timestamp
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.isp = isp
        self.quota_info = quota_info
        self.status = status
        self.version_code = version_code

    def validate(self):
        if self.quota_info:
            self.quota_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.expire_timestamp is not None:
            result['ExpireTimestamp'] = self.expire_timestamp
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.quota_info is not None:
            result['QuotaInfo'] = self.quota_info.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.version_code is not None:
            result['VersionCode'] = self.version_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('ExpireTimestamp') is not None:
            self.expire_timestamp = m.get('ExpireTimestamp')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('QuotaInfo') is not None:
            temp_model = DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstancesQuotaInfo()
            self.quota_info = temp_model.from_map(m['QuotaInfo'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VersionCode') is not None:
            self.version_code = m.get('VersionCode')
        return self


class DescribeIspFlushCacheInstancesResponseBody(TeaModel):
    def __init__(
        self,
        isp_flush_cache_instances: List[DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        self.isp_flush_cache_instances = isp_flush_cache_instances
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_items = total_items
        self.total_pages = total_pages

    def validate(self):
        if self.isp_flush_cache_instances:
            for k in self.isp_flush_cache_instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IspFlushCacheInstances'] = []
        if self.isp_flush_cache_instances is not None:
            for k in self.isp_flush_cache_instances:
                result['IspFlushCacheInstances'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.isp_flush_cache_instances = []
        if m.get('IspFlushCacheInstances') is not None:
            for k in m.get('IspFlushCacheInstances'):
                temp_model = DescribeIspFlushCacheInstancesResponseBodyIspFlushCacheInstances()
                self.isp_flush_cache_instances.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeIspFlushCacheInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeIspFlushCacheInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeIspFlushCacheInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIspFlushCacheRemainQuotaRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeIspFlushCacheRemainQuotaResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        telecom_remain_quota: int = None,
    ):
        self.request_id = request_id
        self.telecom_remain_quota = telecom_remain_quota

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.telecom_remain_quota is not None:
            result['TelecomRemainQuota'] = self.telecom_remain_quota
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TelecomRemainQuota') is not None:
            self.telecom_remain_quota = m.get('TelecomRemainQuota')
        return self


class DescribeIspFlushCacheRemainQuotaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeIspFlushCacheRemainQuotaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeIspFlushCacheRemainQuotaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIspFlushCacheTaskRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        task_id: str = None,
    ):
        self.lang = lang
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers(TeaModel):
    def __init__(
        self,
        name: str = None,
        record: str = None,
        ttl: int = None,
        type: str = None,
    ):
        self.name = name
        self.record = record
        self.ttl = ttl
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.record is not None:
            result['Record'] = self.record
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Record') is not None:
            self.record = m.get('Record')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes(TeaModel):
    def __init__(
        self,
        answers: List[DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers] = None,
        node_ip: str = None,
        sp_name: str = None,
        status: str = None,
    ):
        self.answers = answers
        self.node_ip = node_ip
        self.sp_name = sp_name
        self.status = status

    def validate(self):
        if self.answers:
            for k in self.answers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Answers'] = []
        if self.answers is not None:
            for k in self.answers:
                result['Answers'].append(k.to_map() if k else None)
        if self.node_ip is not None:
            result['NodeIp'] = self.node_ip
        if self.sp_name is not None:
            result['SpName'] = self.sp_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.answers = []
        if m.get('Answers') is not None:
            for k in m.get('Answers'):
                temp_model = DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodesAnswers()
                self.answers.append(temp_model.from_map(k))
        if m.get('NodeIp') is not None:
            self.node_ip = m.get('NodeIp')
        if m.get('SpName') is not None:
            self.sp_name = m.get('SpName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeIspFlushCacheTaskResponseBodyFlushCacheResults(TeaModel):
    def __init__(
        self,
        dns_nodes: List[DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes] = None,
        province: str = None,
    ):
        self.dns_nodes = dns_nodes
        self.province = province

    def validate(self):
        if self.dns_nodes:
            for k in self.dns_nodes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DnsNodes'] = []
        if self.dns_nodes is not None:
            for k in self.dns_nodes:
                result['DnsNodes'].append(k.to_map() if k else None)
        if self.province is not None:
            result['Province'] = self.province
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dns_nodes = []
        if m.get('DnsNodes') is not None:
            for k in m.get('DnsNodes'):
                temp_model = DescribeIspFlushCacheTaskResponseBodyFlushCacheResultsDnsNodes()
                self.dns_nodes.append(temp_model.from_map(k))
        if m.get('Province') is not None:
            self.province = m.get('Province')
        return self


class DescribeIspFlushCacheTaskResponseBody(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_timestamp: int = None,
        domain_name: str = None,
        flush_cache_results: List[DescribeIspFlushCacheTaskResponseBodyFlushCacheResults] = None,
        instance_id: str = None,
        instance_name: str = None,
        isp: str = None,
        request_id: str = None,
        task_id: str = None,
        task_status: str = None,
    ):
        self.create_time = create_time
        self.create_timestamp = create_timestamp
        self.domain_name = domain_name
        self.flush_cache_results = flush_cache_results
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.isp = isp
        self.request_id = request_id
        self.task_id = task_id
        self.task_status = task_status

    def validate(self):
        if self.flush_cache_results:
            for k in self.flush_cache_results:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        result['FlushCacheResults'] = []
        if self.flush_cache_results is not None:
            for k in self.flush_cache_results:
                result['FlushCacheResults'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        self.flush_cache_results = []
        if m.get('FlushCacheResults') is not None:
            for k in m.get('FlushCacheResults'):
                temp_model = DescribeIspFlushCacheTaskResponseBodyFlushCacheResults()
                self.flush_cache_results.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class DescribeIspFlushCacheTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeIspFlushCacheTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeIspFlushCacheTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIspFlushCacheTasksRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        domain_name: str = None,
        instance_id: str = None,
        isp: str = None,
        lang: str = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.direction = direction
        self.domain_name = domain_name
        self.instance_id = instance_id
        self.isp = isp
        self.lang = lang
        self.order_by = order_by
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_timestamp: int = None,
        domain_name: str = None,
        instance_id: str = None,
        instance_name: str = None,
        isp: str = None,
        task_id: str = None,
        task_status: str = None,
    ):
        self.create_time = create_time
        self.create_timestamp = create_timestamp
        self.domain_name = domain_name
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.isp = isp
        self.task_id = task_id
        self.task_status = task_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.isp is not None:
            result['Isp'] = self.isp
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Isp') is not None:
            self.isp = m.get('Isp')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        return self


class DescribeIspFlushCacheTasksResponseBody(TeaModel):
    def __init__(
        self,
        isp_flush_cache_tasks: List[DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        self.isp_flush_cache_tasks = isp_flush_cache_tasks
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_items = total_items
        self.total_pages = total_pages

    def validate(self):
        if self.isp_flush_cache_tasks:
            for k in self.isp_flush_cache_tasks:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IspFlushCacheTasks'] = []
        if self.isp_flush_cache_tasks is not None:
            for k in self.isp_flush_cache_tasks:
                result['IspFlushCacheTasks'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.isp_flush_cache_tasks = []
        if m.get('IspFlushCacheTasks') is not None:
            for k in m.get('IspFlushCacheTasks'):
                temp_model = DescribeIspFlushCacheTasksResponseBodyIspFlushCacheTasks()
                self.isp_flush_cache_tasks.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeIspFlushCacheTasksResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeIspFlushCacheTasksResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeIspFlushCacheTasksResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsAccountSummaryRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        lang: str = None,
        start_date: str = None,
    ):
        self.end_date = end_date
        self.lang = lang
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class DescribePdnsAccountSummaryResponseBodyData(TeaModel):
    def __init__(
        self,
        domain_count: int = None,
        http_count: int = None,
        https_count: int = None,
        sub_domain_count: int = None,
        threat_count: int = None,
        total_count: int = None,
        user_id: int = None,
    ):
        self.domain_count = domain_count
        self.http_count = http_count
        self.https_count = https_count
        self.sub_domain_count = sub_domain_count
        self.threat_count = threat_count
        self.total_count = total_count
        self.user_id = user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_count is not None:
            result['DomainCount'] = self.domain_count
        if self.http_count is not None:
            result['HttpCount'] = self.http_count
        if self.https_count is not None:
            result['HttpsCount'] = self.https_count
        if self.sub_domain_count is not None:
            result['SubDomainCount'] = self.sub_domain_count
        if self.threat_count is not None:
            result['ThreatCount'] = self.threat_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainCount') is not None:
            self.domain_count = m.get('DomainCount')
        if m.get('HttpCount') is not None:
            self.http_count = m.get('HttpCount')
        if m.get('HttpsCount') is not None:
            self.https_count = m.get('HttpsCount')
        if m.get('SubDomainCount') is not None:
            self.sub_domain_count = m.get('SubDomainCount')
        if m.get('ThreatCount') is not None:
            self.threat_count = m.get('ThreatCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class DescribePdnsAccountSummaryResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribePdnsAccountSummaryResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribePdnsAccountSummaryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePdnsAccountSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsAccountSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsAccountSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsAppKeyRequest(TeaModel):
    def __init__(
        self,
        app_key_id: str = None,
        lang: str = None,
    ):
        self.app_key_id = app_key_id
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key_id is not None:
            result['AppKeyId'] = self.app_key_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppKeyId') is not None:
            self.app_key_id = m.get('AppKeyId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribePdnsAppKeyResponseBodyAppKey(TeaModel):
    def __init__(
        self,
        app_key_id: str = None,
        app_key_secret: str = None,
        create_date: str = None,
        state: str = None,
    ):
        self.app_key_id = app_key_id
        self.app_key_secret = app_key_secret
        self.create_date = create_date
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key_id is not None:
            result['AppKeyId'] = self.app_key_id
        if self.app_key_secret is not None:
            result['AppKeySecret'] = self.app_key_secret
        if self.create_date is not None:
            result['CreateDate'] = self.create_date
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppKeyId') is not None:
            self.app_key_id = m.get('AppKeyId')
        if m.get('AppKeySecret') is not None:
            self.app_key_secret = m.get('AppKeySecret')
        if m.get('CreateDate') is not None:
            self.create_date = m.get('CreateDate')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribePdnsAppKeyResponseBody(TeaModel):
    def __init__(
        self,
        app_key: DescribePdnsAppKeyResponseBodyAppKey = None,
        request_id: str = None,
    ):
        self.app_key = app_key
        self.request_id = request_id

    def validate(self):
        if self.app_key:
            self.app_key.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key is not None:
            result['AppKey'] = self.app_key.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppKey') is not None:
            temp_model = DescribePdnsAppKeyResponseBodyAppKey()
            self.app_key = temp_model.from_map(m['AppKey'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePdnsAppKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsAppKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsAppKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsAppKeysRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribePdnsAppKeysResponseBodyAppKeys(TeaModel):
    def __init__(
        self,
        app_key_id: str = None,
        create_date: str = None,
        state: str = None,
    ):
        self.app_key_id = app_key_id
        self.create_date = create_date
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key_id is not None:
            result['AppKeyId'] = self.app_key_id
        if self.create_date is not None:
            result['CreateDate'] = self.create_date
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppKeyId') is not None:
            self.app_key_id = m.get('AppKeyId')
        if m.get('CreateDate') is not None:
            self.create_date = m.get('CreateDate')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribePdnsAppKeysResponseBody(TeaModel):
    def __init__(
        self,
        app_keys: List[DescribePdnsAppKeysResponseBodyAppKeys] = None,
        request_id: str = None,
    ):
        self.app_keys = app_keys
        self.request_id = request_id

    def validate(self):
        if self.app_keys:
            for k in self.app_keys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AppKeys'] = []
        if self.app_keys is not None:
            for k in self.app_keys:
                result['AppKeys'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.app_keys = []
        if m.get('AppKeys') is not None:
            for k in m.get('AppKeys'):
                temp_model = DescribePdnsAppKeysResponseBodyAppKeys()
                self.app_keys.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePdnsAppKeysResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsAppKeysResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsAppKeysResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsOperateLogsRequest(TeaModel):
    def __init__(
        self,
        action_type: str = None,
        end_date: str = None,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
    ):
        self.action_type = action_type
        self.end_date = end_date
        self.keyword = keyword
        self.lang = lang
        self.page_number = page_number
        self.page_size = page_size
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_type is not None:
            result['ActionType'] = self.action_type
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionType') is not None:
            self.action_type = m.get('ActionType')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class DescribePdnsOperateLogsResponseBodyLogs(TeaModel):
    def __init__(
        self,
        action: str = None,
        operate_time: str = None,
        type: str = None,
        content: str = None,
    ):
        self.action = action
        self.operate_time = operate_time
        self.type = type
        self.content = content

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.operate_time is not None:
            result['OperateTime'] = self.operate_time
        if self.type is not None:
            result['Type'] = self.type
        if self.content is not None:
            result['content'] = self.content
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('OperateTime') is not None:
            self.operate_time = m.get('OperateTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('content') is not None:
            self.content = m.get('content')
        return self


class DescribePdnsOperateLogsResponseBody(TeaModel):
    def __init__(
        self,
        logs: List[DescribePdnsOperateLogsResponseBodyLogs] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.logs = logs
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.logs:
            for k in self.logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Logs'] = []
        if self.logs is not None:
            for k in self.logs:
                result['Logs'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.logs = []
        if m.get('Logs') is not None:
            for k in m.get('Logs'):
                temp_model = DescribePdnsOperateLogsResponseBodyLogs()
                self.logs.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePdnsOperateLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsOperateLogsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsOperateLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsRequestStatisticRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        end_date: str = None,
        lang: str = None,
        start_date: str = None,
        sub_domain: str = None,
    ):
        self.domain_name = domain_name
        self.end_date = end_date
        self.lang = lang
        self.start_date = start_date
        self.sub_domain = sub_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        return self


class DescribePdnsRequestStatisticResponseBodyData(TeaModel):
    def __init__(
        self,
        doh_total_count: int = None,
        http_count: int = None,
        https_count: int = None,
        ip_count: int = None,
        timestamp: int = None,
        total_count: int = None,
        udp_total_count: int = None,
        v_4count: int = None,
        v_4http_count: int = None,
        v_4https_count: int = None,
        v_6count: int = None,
        v_6http_count: int = None,
        v_6https_count: int = None,
    ):
        self.doh_total_count = doh_total_count
        self.http_count = http_count
        self.https_count = https_count
        self.ip_count = ip_count
        self.timestamp = timestamp
        self.total_count = total_count
        self.udp_total_count = udp_total_count
        self.v_4count = v_4count
        self.v_4http_count = v_4http_count
        self.v_4https_count = v_4https_count
        self.v_6count = v_6count
        self.v_6http_count = v_6http_count
        self.v_6https_count = v_6https_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doh_total_count is not None:
            result['DohTotalCount'] = self.doh_total_count
        if self.http_count is not None:
            result['HttpCount'] = self.http_count
        if self.https_count is not None:
            result['HttpsCount'] = self.https_count
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.udp_total_count is not None:
            result['UdpTotalCount'] = self.udp_total_count
        if self.v_4count is not None:
            result['V4Count'] = self.v_4count
        if self.v_4http_count is not None:
            result['V4HttpCount'] = self.v_4http_count
        if self.v_4https_count is not None:
            result['V4HttpsCount'] = self.v_4https_count
        if self.v_6count is not None:
            result['V6Count'] = self.v_6count
        if self.v_6http_count is not None:
            result['V6HttpCount'] = self.v_6http_count
        if self.v_6https_count is not None:
            result['V6HttpsCount'] = self.v_6https_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DohTotalCount') is not None:
            self.doh_total_count = m.get('DohTotalCount')
        if m.get('HttpCount') is not None:
            self.http_count = m.get('HttpCount')
        if m.get('HttpsCount') is not None:
            self.https_count = m.get('HttpsCount')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UdpTotalCount') is not None:
            self.udp_total_count = m.get('UdpTotalCount')
        if m.get('V4Count') is not None:
            self.v_4count = m.get('V4Count')
        if m.get('V4HttpCount') is not None:
            self.v_4http_count = m.get('V4HttpCount')
        if m.get('V4HttpsCount') is not None:
            self.v_4https_count = m.get('V4HttpsCount')
        if m.get('V6Count') is not None:
            self.v_6count = m.get('V6Count')
        if m.get('V6HttpCount') is not None:
            self.v_6http_count = m.get('V6HttpCount')
        if m.get('V6HttpsCount') is not None:
            self.v_6https_count = m.get('V6HttpsCount')
        return self


class DescribePdnsRequestStatisticResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribePdnsRequestStatisticResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribePdnsRequestStatisticResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePdnsRequestStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsRequestStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsRequestStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsRequestStatisticsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        end_date: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
        sub_domain: str = None,
        type: str = None,
    ):
        self.domain_name = domain_name
        self.end_date = end_date
        self.lang = lang
        self.page_number = page_number
        self.page_size = page_size
        self.start_date = start_date
        self.sub_domain = sub_domain
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePdnsRequestStatisticsResponseBodyDataThreatInfo(TeaModel):
    def __init__(
        self,
        threat_level: str = None,
        threat_type: str = None,
    ):
        self.threat_level = threat_level
        self.threat_type = threat_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.threat_level is not None:
            result['ThreatLevel'] = self.threat_level
        if self.threat_type is not None:
            result['ThreatType'] = self.threat_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ThreatLevel') is not None:
            self.threat_level = m.get('ThreatLevel')
        if m.get('ThreatType') is not None:
            self.threat_type = m.get('ThreatType')
        return self


class DescribePdnsRequestStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        doh_total_count: int = None,
        domain_name: str = None,
        http_count: int = None,
        https_count: int = None,
        ip_count: int = None,
        max_threat_level: str = None,
        sub_domain: str = None,
        threat_count: int = None,
        threat_info: List[DescribePdnsRequestStatisticsResponseBodyDataThreatInfo] = None,
        total_count: int = None,
        udp_total_count: int = None,
        v_4count: int = None,
        v_4http_count: int = None,
        v_4https_count: int = None,
        v_6count: int = None,
        v_6http_count: int = None,
        v_6https_count: int = None,
    ):
        self.doh_total_count = doh_total_count
        self.domain_name = domain_name
        self.http_count = http_count
        self.https_count = https_count
        self.ip_count = ip_count
        self.max_threat_level = max_threat_level
        self.sub_domain = sub_domain
        self.threat_count = threat_count
        self.threat_info = threat_info
        self.total_count = total_count
        self.udp_total_count = udp_total_count
        self.v_4count = v_4count
        self.v_4http_count = v_4http_count
        self.v_4https_count = v_4https_count
        self.v_6count = v_6count
        self.v_6http_count = v_6http_count
        self.v_6https_count = v_6https_count

    def validate(self):
        if self.threat_info:
            for k in self.threat_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doh_total_count is not None:
            result['DohTotalCount'] = self.doh_total_count
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.http_count is not None:
            result['HttpCount'] = self.http_count
        if self.https_count is not None:
            result['HttpsCount'] = self.https_count
        if self.ip_count is not None:
            result['IpCount'] = self.ip_count
        if self.max_threat_level is not None:
            result['MaxThreatLevel'] = self.max_threat_level
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        if self.threat_count is not None:
            result['ThreatCount'] = self.threat_count
        result['ThreatInfo'] = []
        if self.threat_info is not None:
            for k in self.threat_info:
                result['ThreatInfo'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.udp_total_count is not None:
            result['UdpTotalCount'] = self.udp_total_count
        if self.v_4count is not None:
            result['V4Count'] = self.v_4count
        if self.v_4http_count is not None:
            result['V4HttpCount'] = self.v_4http_count
        if self.v_4https_count is not None:
            result['V4HttpsCount'] = self.v_4https_count
        if self.v_6count is not None:
            result['V6Count'] = self.v_6count
        if self.v_6http_count is not None:
            result['V6HttpCount'] = self.v_6http_count
        if self.v_6https_count is not None:
            result['V6HttpsCount'] = self.v_6https_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DohTotalCount') is not None:
            self.doh_total_count = m.get('DohTotalCount')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('HttpCount') is not None:
            self.http_count = m.get('HttpCount')
        if m.get('HttpsCount') is not None:
            self.https_count = m.get('HttpsCount')
        if m.get('IpCount') is not None:
            self.ip_count = m.get('IpCount')
        if m.get('MaxThreatLevel') is not None:
            self.max_threat_level = m.get('MaxThreatLevel')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        if m.get('ThreatCount') is not None:
            self.threat_count = m.get('ThreatCount')
        self.threat_info = []
        if m.get('ThreatInfo') is not None:
            for k in m.get('ThreatInfo'):
                temp_model = DescribePdnsRequestStatisticsResponseBodyDataThreatInfo()
                self.threat_info.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UdpTotalCount') is not None:
            self.udp_total_count = m.get('UdpTotalCount')
        if m.get('V4Count') is not None:
            self.v_4count = m.get('V4Count')
        if m.get('V4HttpCount') is not None:
            self.v_4http_count = m.get('V4HttpCount')
        if m.get('V4HttpsCount') is not None:
            self.v_4https_count = m.get('V4HttpsCount')
        if m.get('V6Count') is not None:
            self.v_6count = m.get('V6Count')
        if m.get('V6HttpCount') is not None:
            self.v_6http_count = m.get('V6HttpCount')
        if m.get('V6HttpsCount') is not None:
            self.v_6https_count = m.get('V6HttpsCount')
        return self


class DescribePdnsRequestStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribePdnsRequestStatisticsResponseBodyData] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.data = data
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribePdnsRequestStatisticsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePdnsRequestStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsRequestStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsRequestStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsThreatLogsRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
        threat_level: str = None,
        threat_source_ip: str = None,
        threat_type: str = None,
    ):
        self.end_date = end_date
        self.keyword = keyword
        self.lang = lang
        self.page_number = page_number
        self.page_size = page_size
        self.start_date = start_date
        self.threat_level = threat_level
        self.threat_source_ip = threat_source_ip
        self.threat_type = threat_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.threat_level is not None:
            result['ThreatLevel'] = self.threat_level
        if self.threat_source_ip is not None:
            result['ThreatSourceIp'] = self.threat_source_ip
        if self.threat_type is not None:
            result['ThreatType'] = self.threat_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('ThreatLevel') is not None:
            self.threat_level = m.get('ThreatLevel')
        if m.get('ThreatSourceIp') is not None:
            self.threat_source_ip = m.get('ThreatSourceIp')
        if m.get('ThreatType') is not None:
            self.threat_type = m.get('ThreatType')
        return self


class DescribePdnsThreatLogsResponseBodyLogs(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        sub_domain: str = None,
        threat_level: str = None,
        threat_time: str = None,
        threat_type: str = None,
    ):
        self.source_ip = source_ip
        self.sub_domain = sub_domain
        self.threat_level = threat_level
        self.threat_time = threat_time
        self.threat_type = threat_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        if self.threat_level is not None:
            result['ThreatLevel'] = self.threat_level
        if self.threat_time is not None:
            result['ThreatTime'] = self.threat_time
        if self.threat_type is not None:
            result['ThreatType'] = self.threat_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        if m.get('ThreatLevel') is not None:
            self.threat_level = m.get('ThreatLevel')
        if m.get('ThreatTime') is not None:
            self.threat_time = m.get('ThreatTime')
        if m.get('ThreatType') is not None:
            self.threat_type = m.get('ThreatType')
        return self


class DescribePdnsThreatLogsResponseBody(TeaModel):
    def __init__(
        self,
        logs: List[DescribePdnsThreatLogsResponseBodyLogs] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.logs = logs
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.logs:
            for k in self.logs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Logs'] = []
        if self.logs is not None:
            for k in self.logs:
                result['Logs'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.logs = []
        if m.get('Logs') is not None:
            for k in m.get('Logs'):
                temp_model = DescribePdnsThreatLogsResponseBodyLogs()
                self.logs.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePdnsThreatLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsThreatLogsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsThreatLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsThreatStatisticRequest(TeaModel):
    def __init__(
        self,
        end_date: str = None,
        lang: str = None,
        start_date: str = None,
        threat_source_ip: str = None,
    ):
        self.end_date = end_date
        self.lang = lang
        self.start_date = start_date
        self.threat_source_ip = threat_source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.threat_source_ip is not None:
            result['ThreatSourceIp'] = self.threat_source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('ThreatSourceIp') is not None:
            self.threat_source_ip = m.get('ThreatSourceIp')
        return self


class DescribePdnsThreatStatisticResponseBodyData(TeaModel):
    def __init__(
        self,
        doh_total_count: int = None,
        threat_level: str = None,
        threat_type: str = None,
        timestamp: int = None,
        total_count: int = None,
        udp_total_count: int = None,
    ):
        self.doh_total_count = doh_total_count
        self.threat_level = threat_level
        self.threat_type = threat_type
        self.timestamp = timestamp
        self.total_count = total_count
        self.udp_total_count = udp_total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doh_total_count is not None:
            result['DohTotalCount'] = self.doh_total_count
        if self.threat_level is not None:
            result['ThreatLevel'] = self.threat_level
        if self.threat_type is not None:
            result['ThreatType'] = self.threat_type
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.udp_total_count is not None:
            result['UdpTotalCount'] = self.udp_total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DohTotalCount') is not None:
            self.doh_total_count = m.get('DohTotalCount')
        if m.get('ThreatLevel') is not None:
            self.threat_level = m.get('ThreatLevel')
        if m.get('ThreatType') is not None:
            self.threat_type = m.get('ThreatType')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UdpTotalCount') is not None:
            self.udp_total_count = m.get('UdpTotalCount')
        return self


class DescribePdnsThreatStatisticResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribePdnsThreatStatisticResponseBodyData] = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribePdnsThreatStatisticResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribePdnsThreatStatisticResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsThreatStatisticResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsThreatStatisticResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsThreatStatisticsRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        domain_name: str = None,
        end_date: str = None,
        lang: str = None,
        order_by: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
        sub_domain: str = None,
        threat_level: str = None,
        threat_source_ip: str = None,
        threat_type: str = None,
        type: str = None,
    ):
        self.direction = direction
        self.domain_name = domain_name
        self.end_date = end_date
        self.lang = lang
        self.order_by = order_by
        self.page_number = page_number
        self.page_size = page_size
        self.start_date = start_date
        self.sub_domain = sub_domain
        self.threat_level = threat_level
        self.threat_source_ip = threat_source_ip
        self.threat_type = threat_type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.order_by is not None:
            result['OrderBy'] = self.order_by
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        if self.threat_level is not None:
            result['ThreatLevel'] = self.threat_level
        if self.threat_source_ip is not None:
            result['ThreatSourceIp'] = self.threat_source_ip
        if self.threat_type is not None:
            result['ThreatType'] = self.threat_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('OrderBy') is not None:
            self.order_by = m.get('OrderBy')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        if m.get('ThreatLevel') is not None:
            self.threat_level = m.get('ThreatLevel')
        if m.get('ThreatSourceIp') is not None:
            self.threat_source_ip = m.get('ThreatSourceIp')
        if m.get('ThreatType') is not None:
            self.threat_type = m.get('ThreatType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribePdnsThreatStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        doh_total_count: int = None,
        domain_count: int = None,
        domain_name: str = None,
        latest_threat_time: int = None,
        max_threat_level: str = None,
        source_ip: str = None,
        sub_domain: str = None,
        threat_level: str = None,
        threat_type: str = None,
        total_count: int = None,
        udp_total_count: int = None,
    ):
        self.doh_total_count = doh_total_count
        self.domain_count = domain_count
        self.domain_name = domain_name
        self.latest_threat_time = latest_threat_time
        self.max_threat_level = max_threat_level
        self.source_ip = source_ip
        self.sub_domain = sub_domain
        self.threat_level = threat_level
        self.threat_type = threat_type
        self.total_count = total_count
        self.udp_total_count = udp_total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.doh_total_count is not None:
            result['DohTotalCount'] = self.doh_total_count
        if self.domain_count is not None:
            result['DomainCount'] = self.domain_count
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.latest_threat_time is not None:
            result['LatestThreatTime'] = self.latest_threat_time
        if self.max_threat_level is not None:
            result['MaxThreatLevel'] = self.max_threat_level
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        if self.threat_level is not None:
            result['ThreatLevel'] = self.threat_level
        if self.threat_type is not None:
            result['ThreatType'] = self.threat_type
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.udp_total_count is not None:
            result['UdpTotalCount'] = self.udp_total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DohTotalCount') is not None:
            self.doh_total_count = m.get('DohTotalCount')
        if m.get('DomainCount') is not None:
            self.domain_count = m.get('DomainCount')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LatestThreatTime') is not None:
            self.latest_threat_time = m.get('LatestThreatTime')
        if m.get('MaxThreatLevel') is not None:
            self.max_threat_level = m.get('MaxThreatLevel')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        if m.get('ThreatLevel') is not None:
            self.threat_level = m.get('ThreatLevel')
        if m.get('ThreatType') is not None:
            self.threat_type = m.get('ThreatType')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UdpTotalCount') is not None:
            self.udp_total_count = m.get('UdpTotalCount')
        return self


class DescribePdnsThreatStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribePdnsThreatStatisticsResponseBodyData] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.data = data
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribePdnsThreatStatisticsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePdnsThreatStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsThreatStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsThreatStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsUdpIpSegmentsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
    ):
        self.lang = lang
        self.page_number = page_number
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribePdnsUdpIpSegmentsResponseBodyIpSegments(TeaModel):
    def __init__(
        self,
        create_date: str = None,
        ip: str = None,
        mask: int = None,
        name: str = None,
        state: str = None,
        update_date: str = None,
    ):
        self.create_date = create_date
        self.ip = ip
        self.mask = mask
        self.name = name
        self.state = state
        self.update_date = update_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_date is not None:
            result['CreateDate'] = self.create_date
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.mask is not None:
            result['Mask'] = self.mask
        if self.name is not None:
            result['Name'] = self.name
        if self.state is not None:
            result['State'] = self.state
        if self.update_date is not None:
            result['UpdateDate'] = self.update_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateDate') is not None:
            self.create_date = m.get('CreateDate')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Mask') is not None:
            self.mask = m.get('Mask')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('UpdateDate') is not None:
            self.update_date = m.get('UpdateDate')
        return self


class DescribePdnsUdpIpSegmentsResponseBody(TeaModel):
    def __init__(
        self,
        ip_segments: List[DescribePdnsUdpIpSegmentsResponseBodyIpSegments] = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        self.ip_segments = ip_segments
        self.page_number = page_number
        self.page_size = page_size
        self.request_id = request_id
        self.total_count = total_count

    def validate(self):
        if self.ip_segments:
            for k in self.ip_segments:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['IpSegments'] = []
        if self.ip_segments is not None:
            for k in self.ip_segments:
                result['IpSegments'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.ip_segments = []
        if m.get('IpSegments') is not None:
            for k in m.get('IpSegments'):
                temp_model = DescribePdnsUdpIpSegmentsResponseBodyIpSegments()
                self.ip_segments.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePdnsUdpIpSegmentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsUdpIpSegmentsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsUdpIpSegmentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePdnsUserInfoRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribePdnsUserInfoResponseBodyUserInfo(TeaModel):
    def __init__(
        self,
        available_service: str = None,
        pdns_id: int = None,
        service_type: str = None,
        state: str = None,
        stopped_service: str = None,
    ):
        self.available_service = available_service
        self.pdns_id = pdns_id
        self.service_type = service_type
        self.state = state
        self.stopped_service = stopped_service

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_service is not None:
            result['AvailableService'] = self.available_service
        if self.pdns_id is not None:
            result['PdnsId'] = self.pdns_id
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        if self.state is not None:
            result['State'] = self.state
        if self.stopped_service is not None:
            result['StoppedService'] = self.stopped_service
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvailableService') is not None:
            self.available_service = m.get('AvailableService')
        if m.get('PdnsId') is not None:
            self.pdns_id = m.get('PdnsId')
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('StoppedService') is not None:
            self.stopped_service = m.get('StoppedService')
        return self


class DescribePdnsUserInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_info: DescribePdnsUserInfoResponseBodyUserInfo = None,
    ):
        self.request_id = request_id
        self.user_info = user_info

    def validate(self):
        if self.user_info:
            self.user_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_info is not None:
            result['UserInfo'] = self.user_info.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserInfo') is not None:
            temp_model = DescribePdnsUserInfoResponseBodyUserInfo()
            self.user_info = temp_model.from_map(m['UserInfo'])
        return self


class DescribePdnsUserInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribePdnsUserInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePdnsUserInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecordLogsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        key_word: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        start_date: str = None,
        user_client_ip: str = None,
        end_date: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The keyword for searches in %KeyWord% mode. The value is not case-sensitive.
        self.key_word = key_word
        # The language type.
        self.lang = lang
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **100**. Default value: **20**.
        self.page_size = page_size
        # The beginning of the time range to query. Specify the time in the ISO 8601 standard in the **yyyy-MM-ddTHH:mm:ssZ** format.
        self.start_date = start_date
        # The IP address of the client.
        self.user_client_ip = user_client_ip
        # The end of the time range to query. Specify the time in the ISO 8601 standard in the **yyyy-MM-ddTHH:mm:ssZ** format.
        self.end_date = end_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.key_word is not None:
            result['KeyWord'] = self.key_word
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        if self.end_date is not None:
            result['endDate'] = self.end_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('KeyWord') is not None:
            self.key_word = m.get('KeyWord')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        return self


class DescribeRecordLogsResponseBodyRecordLogsRecordLog(TeaModel):
    def __init__(
        self,
        action: str = None,
        action_time: str = None,
        action_timestamp: int = None,
        client_ip: str = None,
        message: str = None,
    ):
        # The operation that you performed.
        self.action = action
        # The time when the operation was performed.
        self.action_time = action_time
        # The UNIX timestamp representing the time of the operation.
        self.action_timestamp = action_timestamp
        # The IP address of the operator.
        self.client_ip = client_ip
        # The returned operation message.
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action is not None:
            result['Action'] = self.action
        if self.action_time is not None:
            result['ActionTime'] = self.action_time
        if self.action_timestamp is not None:
            result['ActionTimestamp'] = self.action_timestamp
        if self.client_ip is not None:
            result['ClientIp'] = self.client_ip
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Action') is not None:
            self.action = m.get('Action')
        if m.get('ActionTime') is not None:
            self.action_time = m.get('ActionTime')
        if m.get('ActionTimestamp') is not None:
            self.action_timestamp = m.get('ActionTimestamp')
        if m.get('ClientIp') is not None:
            self.client_ip = m.get('ClientIp')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DescribeRecordLogsResponseBodyRecordLogs(TeaModel):
    def __init__(
        self,
        record_log: List[DescribeRecordLogsResponseBodyRecordLogsRecordLog] = None,
    ):
        self.record_log = record_log

    def validate(self):
        if self.record_log:
            for k in self.record_log:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordLog'] = []
        if self.record_log is not None:
            for k in self.record_log:
                result['RecordLog'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_log = []
        if m.get('RecordLog') is not None:
            for k in m.get('RecordLog'):
                temp_model = DescribeRecordLogsResponseBodyRecordLogsRecordLog()
                self.record_log.append(temp_model.from_map(k))
        return self


class DescribeRecordLogsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        record_logs: DescribeRecordLogsResponseBodyRecordLogs = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The list of the operation logs of the domain name.
        self.record_logs = record_logs
        # The ID of the request.
        self.request_id = request_id
        # The total number of operation logs.
        self.total_count = total_count

    def validate(self):
        if self.record_logs:
            self.record_logs.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.record_logs is not None:
            result['RecordLogs'] = self.record_logs.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecordLogs') is not None:
            temp_model = DescribeRecordLogsResponseBodyRecordLogs()
            self.record_logs = temp_model.from_map(m['RecordLogs'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRecordLogsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRecordLogsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRecordLogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecordResolveStatisticsSummaryRequest(TeaModel):
    def __init__(
        self,
        direction: str = None,
        domain_name: str = None,
        domain_type: str = None,
        end_date: str = None,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        search_mode: str = None,
        start_date: str = None,
        threshold: int = None,
    ):
        self.direction = direction
        self.domain_name = domain_name
        self.domain_type = domain_type
        self.end_date = end_date
        self.keyword = keyword
        self.lang = lang
        self.page_number = page_number
        self.page_size = page_size
        self.search_mode = search_mode
        self.start_date = start_date
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_mode is not None:
            result['SearchMode'] = self.search_mode
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchMode') is not None:
            self.search_mode = m.get('SearchMode')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeRecordResolveStatisticsSummaryResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        count: str = None,
        domain_name: str = None,
        domain_type: str = None,
        sub_domain: str = None,
    ):
        self.count = count
        self.domain_name = domain_name
        self.domain_type = domain_type
        self.sub_domain = sub_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        return self


class DescribeRecordResolveStatisticsSummaryResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        statistics: List[DescribeRecordResolveStatisticsSummaryResponseBodyStatistics] = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        self.page_number = page_number
        self.page_size = page_size
        # RequestId
        self.request_id = request_id
        self.statistics = statistics
        self.total_items = total_items
        self.total_pages = total_pages

    def validate(self):
        if self.statistics:
            for k in self.statistics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Statistics'] = []
        if self.statistics is not None:
            for k in self.statistics:
                result['Statistics'].append(k.to_map() if k else None)
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics = []
        if m.get('Statistics') is not None:
            for k in m.get('Statistics'):
                temp_model = DescribeRecordResolveStatisticsSummaryResponseBodyStatistics()
                self.statistics.append(temp_model.from_map(k))
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeRecordResolveStatisticsSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRecordResolveStatisticsSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRecordResolveStatisticsSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecordStatisticsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_type: str = None,
        end_date: str = None,
        lang: str = None,
        rr: str = None,
        start_date: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        self.domain_type = domain_type
        # The end of the time range to query. Specify the time in the **YYYY-MM-DD** format.
        # 
        # The default value is the day when you perform the operation.
        self.end_date = end_date
        # The language type.
        self.lang = lang
        # The DNS record.
        # 
        # The host record. For example, to resolve `www.dns-exmaple.com`, you must set Rr to www.
        self.rr = rr
        # The beginning of the time range to query. Specify the time in the **YYYY-MM-DD** format.
        # 
        # You can only query DNS records of the last 90 days.
        self.start_date = start_date

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.rr is not None:
            result['Rr'] = self.rr
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Rr') is not None:
            self.rr = m.get('Rr')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class DescribeRecordStatisticsResponseBodyStatisticsStatistic(TeaModel):
    def __init__(
        self,
        count: int = None,
        timestamp: int = None,
    ):
        # The number of queries.
        self.count = count
        # The UNIX timestamp representing the collection time.
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.timestamp is not None:
            result['Timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Timestamp') is not None:
            self.timestamp = m.get('Timestamp')
        return self


class DescribeRecordStatisticsResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        statistic: List[DescribeRecordStatisticsResponseBodyStatisticsStatistic] = None,
    ):
        self.statistic = statistic

    def validate(self):
        if self.statistic:
            for k in self.statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Statistic'] = []
        if self.statistic is not None:
            for k in self.statistic:
                result['Statistic'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.statistic = []
        if m.get('Statistic') is not None:
            for k in m.get('Statistic'):
                temp_model = DescribeRecordStatisticsResponseBodyStatisticsStatistic()
                self.statistic.append(temp_model.from_map(k))
        return self


class DescribeRecordStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        statistics: DescribeRecordStatisticsResponseBodyStatistics = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The list of query volume records.
        self.statistics = statistics

    def validate(self):
        if self.statistics:
            self.statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.statistics is not None:
            result['Statistics'] = self.statistics.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Statistics') is not None:
            temp_model = DescribeRecordStatisticsResponseBodyStatistics()
            self.statistics = temp_model.from_map(m['Statistics'])
        return self


class DescribeRecordStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRecordStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRecordStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecordStatisticsSummaryRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        domain_type: str = None,
        end_date: str = None,
        keyword: str = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        search_mode: str = None,
        start_date: str = None,
        threshold: int = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        self.domain_type = domain_type
        # The end of the time range to query. Specify the time in the **YYYY-MM-DD** format.
        # 
        # The default value is the day when you perform the operation.
        self.end_date = end_date
        # The keyword for searches in %KeyWord% mode. The value is not case-sensitive.
        self.keyword = keyword
        # The language type.
        self.lang = lang
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **100**. Minimum value: **1**. Default value: **20**.
        self.page_size = page_size
        # The search mode of the keyword. Valid values:
        # 
        # *   **LIKE**: fuzzy match (default).
        # *   **EXACT**: exact match.
        self.search_mode = search_mode
        # The beginning of the time range to query. Specify the time in the **YYYY-MM-DD** format.
        # 
        # You can only query DNS records of the last 90 days.
        self.start_date = start_date
        # The threshold of query volume that can be obtained. You can also obtain data about a domain name with the query volume less than or equal to the threshold. For example, if you set this parameter to 100, you can query domain names with less than 100 queries.
        self.threshold = threshold

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.keyword is not None:
            result['Keyword'] = self.keyword
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_mode is not None:
            result['SearchMode'] = self.search_mode
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.threshold is not None:
            result['Threshold'] = self.threshold
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Keyword') is not None:
            self.keyword = m.get('Keyword')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchMode') is not None:
            self.search_mode = m.get('SearchMode')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('Threshold') is not None:
            self.threshold = m.get('Threshold')
        return self


class DescribeRecordStatisticsSummaryResponseBodyStatisticsStatistic(TeaModel):
    def __init__(
        self,
        count: int = None,
        sub_domain: str = None,
    ):
        # The number of queries.
        self.count = count
        # The subdomain name.
        self.sub_domain = sub_domain

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        return self


class DescribeRecordStatisticsSummaryResponseBodyStatistics(TeaModel):
    def __init__(
        self,
        statistic: List[DescribeRecordStatisticsSummaryResponseBodyStatisticsStatistic] = None,
    ):
        self.statistic = statistic

    def validate(self):
        if self.statistic:
            for k in self.statistic:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Statistic'] = []
        if self.statistic is not None:
            for k in self.statistic:
                result['Statistic'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.statistic = []
        if m.get('Statistic') is not None:
            for k in m.get('Statistic'):
                temp_model = DescribeRecordStatisticsSummaryResponseBodyStatisticsStatistic()
                self.statistic.append(temp_model.from_map(k))
        return self


class DescribeRecordStatisticsSummaryResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        statistics: DescribeRecordStatisticsSummaryResponseBodyStatistics = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The list of query volume records.
        self.statistics = statistics
        # The total number of data records.The total number of data records.
        self.total_items = total_items
        # The total number of returned pages.
        self.total_pages = total_pages

    def validate(self):
        if self.statistics:
            self.statistics.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.statistics is not None:
            result['Statistics'] = self.statistics.to_map()
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Statistics') is not None:
            temp_model = DescribeRecordStatisticsSummaryResponseBodyStatistics()
            self.statistics = temp_model.from_map(m['Statistics'])
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class DescribeRecordStatisticsSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeRecordStatisticsSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRecordStatisticsSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSubDomainRecordsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        line: str = None,
        page_number: int = None,
        page_size: int = None,
        sub_domain: str = None,
        type: str = None,
        user_client_ip: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language.
        self.lang = lang
        # The resolution line.
        self.line = line
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: **500**. Default value: **20**.
        self.page_size = page_size
        # The subdomain. For example, assume that the SubDomain parameter is set to a.www.example.com.
        # 
        # If the DomainName parameter is empty, the DNS records of the subdomain whose domain name is example.com and hostname is "a.www" are queried.
        # 
        # If the DomainName parameter is set to www.example.com, the DNS records of the subdomain whose domain name is www.example.com and hostname is "a" are queried.
        # 
        # If the DomainName parameter is set to a.www.example.com, the DNS records of the subdomain whose domain name is a.www.example.com and hostname is "@" are queried.
        self.sub_domain = sub_domain
        # The type of DNS records to query. If you do not specify this parameter, all types of DNS records corresponding to the subdomain are returned.
        # 
        # DNS record types include **A, MX, CNAME, TXT, REDIRECT_URL, FORWORD_URL, NS, AAAA, and SRV**. The value is not case-sensitive.
        self.type = type
        # The IP address of the client.
        self.user_client_ip = user_client_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.line is not None:
            result['Line'] = self.line
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        if self.type is not None:
            result['Type'] = self.type
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        return self


class DescribeSubDomainRecordsResponseBodyDomainRecordsRecord(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        line: str = None,
        locked: bool = None,
        priority: int = None,
        rr: str = None,
        record_id: str = None,
        remark: str = None,
        status: str = None,
        ttl: int = None,
        type: str = None,
        value: str = None,
        weight: int = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The resolution line.
        self.line = line
        # Indicates whether the DNS record is locked.
        self.locked = locked
        # The priority of the MX record.
        self.priority = priority
        # The hostname.
        self.rr = rr
        # The ID of the DNS record.
        self.record_id = record_id
        # The description of the DNS record.
        self.remark = remark
        # The status of the DNS record.
        self.status = status
        # The Time-to-Live (TTL) of the DNS record.
        self.ttl = ttl
        # The type of the DNS record.
        self.type = type
        # The record value.
        self.value = value
        # The weight of the DNS record.
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.line is not None:
            result['Line'] = self.line
        if self.locked is not None:
            result['Locked'] = self.locked
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.rr is not None:
            result['RR'] = self.rr
        if self.record_id is not None:
            result['RecordId'] = self.record_id
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.status is not None:
            result['Status'] = self.status
        if self.ttl is not None:
            result['TTL'] = self.ttl
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('Locked') is not None:
            self.locked = m.get('Locked')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RR') is not None:
            self.rr = m.get('RR')
        if m.get('RecordId') is not None:
            self.record_id = m.get('RecordId')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TTL') is not None:
            self.ttl = m.get('TTL')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class DescribeSubDomainRecordsResponseBodyDomainRecords(TeaModel):
    def __init__(
        self,
        record: List[DescribeSubDomainRecordsResponseBodyDomainRecordsRecord] = None,
    ):
        self.record = record

    def validate(self):
        if self.record:
            for k in self.record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Record'] = []
        if self.record is not None:
            for k in self.record:
                result['Record'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record = []
        if m.get('Record') is not None:
            for k in m.get('Record'):
                temp_model = DescribeSubDomainRecordsResponseBodyDomainRecordsRecord()
                self.record.append(temp_model.from_map(k))
        return self


class DescribeSubDomainRecordsResponseBody(TeaModel):
    def __init__(
        self,
        domain_records: DescribeSubDomainRecordsResponseBodyDomainRecords = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The list of DNS records returned.
        self.domain_records = domain_records
        # The number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of DNS records returned.
        self.total_count = total_count

    def validate(self):
        if self.domain_records:
            self.domain_records.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_records is not None:
            result['DomainRecords'] = self.domain_records.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainRecords') is not None:
            temp_model = DescribeSubDomainRecordsResponseBodyDomainRecords()
            self.domain_records = temp_model.from_map(m['DomainRecords'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeSubDomainRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSubDomainRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSubDomainRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeSupportLinesRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        user_client_ip: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language type.
        self.lang = lang
        # The IP address of the client.
        self.user_client_ip = user_client_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        return self


class DescribeSupportLinesResponseBodyRecordLinesRecordLine(TeaModel):
    def __init__(
        self,
        father_code: str = None,
        line_code: str = None,
        line_display_name: str = None,
        line_name: str = None,
    ):
        # The code of the parent line. Leave it blank if there is no parent line.
        self.father_code = father_code
        # The code of the child line.
        self.line_code = line_code
        # The name of the parent line.
        self.line_display_name = line_display_name
        # The name of the child line.
        self.line_name = line_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.father_code is not None:
            result['FatherCode'] = self.father_code
        if self.line_code is not None:
            result['LineCode'] = self.line_code
        if self.line_display_name is not None:
            result['LineDisplayName'] = self.line_display_name
        if self.line_name is not None:
            result['LineName'] = self.line_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FatherCode') is not None:
            self.father_code = m.get('FatherCode')
        if m.get('LineCode') is not None:
            self.line_code = m.get('LineCode')
        if m.get('LineDisplayName') is not None:
            self.line_display_name = m.get('LineDisplayName')
        if m.get('LineName') is not None:
            self.line_name = m.get('LineName')
        return self


class DescribeSupportLinesResponseBodyRecordLines(TeaModel):
    def __init__(
        self,
        record_line: List[DescribeSupportLinesResponseBodyRecordLinesRecordLine] = None,
    ):
        self.record_line = record_line

    def validate(self):
        if self.record_line:
            for k in self.record_line:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RecordLine'] = []
        if self.record_line is not None:
            for k in self.record_line:
                result['RecordLine'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.record_line = []
        if m.get('RecordLine') is not None:
            for k in m.get('RecordLine'):
                temp_model = DescribeSupportLinesResponseBodyRecordLinesRecordLine()
                self.record_line.append(temp_model.from_map(k))
        return self


class DescribeSupportLinesResponseBody(TeaModel):
    def __init__(
        self,
        record_lines: DescribeSupportLinesResponseBodyRecordLines = None,
        request_id: str = None,
    ):
        # The list of Alibaba Cloud DNS lines.
        self.record_lines = record_lines
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.record_lines:
            self.record_lines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.record_lines is not None:
            result['RecordLines'] = self.record_lines.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RecordLines') is not None:
            temp_model = DescribeSupportLinesResponseBodyRecordLines()
            self.record_lines = temp_model.from_map(m['RecordLines'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeSupportLinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeSupportLinesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeSupportLinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTagsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        resource_type: str = None,
    ):
        # The language in which you want the values of some response parameters to be returned. These response parameters support multiple languages. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The page number to return. Default value: 1.
        self.page_number = page_number
        # The number of entries to return per page. Default value: 200.
        self.page_size = page_size
        # The type of the resources from which you want to query tags. Set the value to DOMAIN.
        self.resource_type = resource_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        return self


class DescribeTagsResponseBodyTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        values: List[str] = None,
    ):
        # The key of the tag.
        self.key = key
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeTagsResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        tags: List[DescribeTagsResponseBodyTags] = None,
        total_count: int = None,
    ):
        # The returned page number. Default value: 1.
        self.page_number = page_number
        # The number of entries returned per page. Default value: 200.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The list of tags.
        self.tags = tags
        # The total number of tags returned.
        self.total_count = total_count

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeTagsResponseBodyTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeTagsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTransferDomainsRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        from_user_id: int = None,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        target_user_id: int = None,
        transfer_type: str = None,
    ):
        self.domain_name = domain_name
        self.from_user_id = from_user_id
        # The language type.
        self.lang = lang
        # The number of the page to return. Pages start from page 1. Default value: 1.
        self.page_number = page_number
        # The number of entries to return on each page. Maximum value: 100. Default value: 20.
        self.page_size = page_size
        self.target_user_id = target_user_id
        # The transfer type. Valid values:
        # 
        # *   IN: transferred to this account.
        # *   OUT: transferred from this account.
        self.transfer_type = transfer_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.from_user_id is not None:
            result['FromUserId'] = self.from_user_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        if self.transfer_type is not None:
            result['TransferType'] = self.transfer_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FromUserId') is not None:
            self.from_user_id = m.get('FromUserId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        if m.get('TransferType') is not None:
            self.transfer_type = m.get('TransferType')
        return self


class DescribeTransferDomainsResponseBodyDomainTransfersDomainTransfer(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        create_timestamp: int = None,
        domain_name: str = None,
        from_user_id: int = None,
        id: int = None,
        target_user_id: int = None,
    ):
        # The time when the task for transferring domain names was created.
        self.create_time = create_time
        # The UNIX timestamp representing when the task for transferring domain names was created.
        self.create_timestamp = create_timestamp
        # The domain name.
        self.domain_name = domain_name
        # The ID of the user from which the domain name was transferred.
        self.from_user_id = from_user_id
        # The ID of the domain name that was transferred.
        self.id = id
        # The ID of the user to which the domain name was transferred.
        self.target_user_id = target_user_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.from_user_id is not None:
            result['FromUserId'] = self.from_user_id
        if self.id is not None:
            result['Id'] = self.id
        if self.target_user_id is not None:
            result['TargetUserId'] = self.target_user_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('FromUserId') is not None:
            self.from_user_id = m.get('FromUserId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('TargetUserId') is not None:
            self.target_user_id = m.get('TargetUserId')
        return self


class DescribeTransferDomainsResponseBodyDomainTransfers(TeaModel):
    def __init__(
        self,
        domain_transfer: List[DescribeTransferDomainsResponseBodyDomainTransfersDomainTransfer] = None,
    ):
        self.domain_transfer = domain_transfer

    def validate(self):
        if self.domain_transfer:
            for k in self.domain_transfer:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainTransfer'] = []
        if self.domain_transfer is not None:
            for k in self.domain_transfer:
                result['DomainTransfer'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_transfer = []
        if m.get('DomainTransfer') is not None:
            for k in m.get('DomainTransfer'):
                temp_model = DescribeTransferDomainsResponseBodyDomainTransfersDomainTransfer()
                self.domain_transfer.append(temp_model.from_map(k))
        return self


class DescribeTransferDomainsResponseBody(TeaModel):
    def __init__(
        self,
        domain_transfers: DescribeTransferDomainsResponseBodyDomainTransfers = None,
        page_number: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The list of domain names that were transferred between accounts.
        self.domain_transfers = domain_transfers
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of domain names.
        self.total_count = total_count

    def validate(self):
        if self.domain_transfers:
            self.domain_transfers.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_transfers is not None:
            result['DomainTransfers'] = self.domain_transfers.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainTransfers') is not None:
            temp_model = DescribeTransferDomainsResponseBodyDomainTransfers()
            self.domain_transfers = temp_model.from_map(m['DomainTransfers'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeTransferDomainsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeTransferDomainsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTransferDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ExecuteGtmRecoveryPlanRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        recovery_plan_id: int = None,
    ):
        # The language used by the user.
        self.lang = lang
        # The ID of the disaster recovery plan that you want to executed.
        self.recovery_plan_id = recovery_plan_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.recovery_plan_id is not None:
            result['RecoveryPlanId'] = self.recovery_plan_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RecoveryPlanId') is not None:
            self.recovery_plan_id = m.get('RecoveryPlanId')
        return self


class ExecuteGtmRecoveryPlanResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ExecuteGtmRecoveryPlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ExecuteGtmRecoveryPlanResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ExecuteGtmRecoveryPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMainDomainNameRequest(TeaModel):
    def __init__(
        self,
        input_string: str = None,
        lang: str = None,
    ):
        # The input string. The string can be up to 128 characters in length.
        self.input_string = input_string
        # The language type.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.input_string is not None:
            result['InputString'] = self.input_string
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InputString') is not None:
            self.input_string = m.get('InputString')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class GetMainDomainNameResponseBody(TeaModel):
    def __init__(
        self,
        domain_level: int = None,
        domain_name: str = None,
        rr: str = None,
        request_id: str = None,
    ):
        # The level of the entered domain name.
        self.domain_level = domain_level
        # The domain name.
        self.domain_name = domain_name
        # The host record.
        self.rr = rr
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_level is not None:
            result['DomainLevel'] = self.domain_level
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.rr is not None:
            result['RR'] = self.rr
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainLevel') is not None:
            self.domain_level = m.get('DomainLevel')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RR') is not None:
            self.rr = m.get('RR')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GetMainDomainNameResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetMainDomainNameResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMainDomainNameResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetTxtRecordForVerifyRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        type: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language type.
        self.lang = lang
        # The function verified by using the TXT record. Valid values:
        # 
        # *   ADD_SUBDOMAIN
        # *   RETRIEVAL
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetTxtRecordForVerifyResponseBody(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        rr: str = None,
        request_id: str = None,
        value: str = None,
    ):
        # The domain name.
        # 
        # >  If you do not specify this parameter, it is not returned.
        self.domain_name = domain_name
        # The host record.
        self.rr = rr
        # The ID of the request.
        self.request_id = request_id
        # The value of the DNS record.
        # 
        # >  The validity period is three days.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.rr is not None:
            result['RR'] = self.rr
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('RR') is not None:
            self.rr = m.get('RR')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetTxtRecordForVerifyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: GetTxtRecordForVerifyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetTxtRecordForVerifyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagResourcesRequestTag(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key.
        self.key = key
        # The tag value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListTagResourcesRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        next_token: str = None,
        resource_id: List[str] = None,
        resource_type: str = None,
        tag: List[ListTagResourcesRequestTag] = None,
    ):
        # The language.
        self.lang = lang
        # The pagination token that is used in the next request to retrieve a new page of results.
        self.next_token = next_token
        # The ID of the resource.
        self.resource_id = resource_id
        # The type of the resource.
        self.resource_type = resource_type
        # The key-value pairs of tags.
        self.tag = tag

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListTagResourcesRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ListTagResourcesResponseBodyTagResources(TeaModel):
    def __init__(
        self,
        resource_id: str = None,
        resource_type: str = None,
        tag_key: str = None,
        tag_value: str = None,
    ):
        # The ID of the resource.
        self.resource_id = resource_id
        # The type of the resource. The returned parameter value is fixed to DOMAIN.
        self.resource_type = resource_type
        # The key of the tag.
        self.tag_key = tag_key
        # The tag value.
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListTagResourcesResponseBody(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        request_id: str = None,
        tag_resources: List[ListTagResourcesResponseBodyTagResources] = None,
    ):
        # The returned value of NextToken is a pagination token, which can be used in the next request to retrieve a new page of results. If the NextToken parameter is empty, no next page exists.
        self.next_token = next_token
        # The unique ID of the request.
        self.request_id = request_id
        # Details of the resource and tags, such as the resource ID, the resource type, tag keys, and tag values.
        self.tag_resources = tag_resources

    def validate(self):
        if self.tag_resources:
            for k in self.tag_resources:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TagResources'] = []
        if self.tag_resources is not None:
            for k in self.tag_resources:
                result['TagResources'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.tag_resources = []
        if m.get('TagResources') is not None:
            for k in m.get('TagResources'):
                temp_model = ListTagResourcesResponseBodyTagResources()
                self.tag_resources.append(temp_model.from_map(k))
        return self


class ListTagResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ListTagResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ModifyHichinaDomainDNSRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        user_client_ip: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language type.
        self.lang = lang
        # The IP address of the client.
        self.user_client_ip = user_client_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        return self


class ModifyHichinaDomainDNSResponseBodyNewDnsServers(TeaModel):
    def __init__(
        self,
        dns_server: List[str] = None,
    ):
        self.dns_server = dns_server

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_server is not None:
            result['DnsServer'] = self.dns_server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsServer') is not None:
            self.dns_server = m.get('DnsServer')
        return self


class ModifyHichinaDomainDNSResponseBodyOriginalDnsServers(TeaModel):
    def __init__(
        self,
        dns_server: List[str] = None,
    ):
        self.dns_server = dns_server

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dns_server is not None:
            result['DnsServer'] = self.dns_server
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DnsServer') is not None:
            self.dns_server = m.get('DnsServer')
        return self


class ModifyHichinaDomainDNSResponseBody(TeaModel):
    def __init__(
        self,
        new_dns_servers: ModifyHichinaDomainDNSResponseBodyNewDnsServers = None,
        original_dns_servers: ModifyHichinaDomainDNSResponseBodyOriginalDnsServers = None,
        request_id: str = None,
    ):
        # The list of DNS servers after the domain name is changed.
        self.new_dns_servers = new_dns_servers
        # The list of DNS servers before the domain name is changed.
        self.original_dns_servers = original_dns_servers
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.new_dns_servers:
            self.new_dns_servers.validate()
        if self.original_dns_servers:
            self.original_dns_servers.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.new_dns_servers is not None:
            result['NewDnsServers'] = self.new_dns_servers.to_map()
        if self.original_dns_servers is not None:
            result['OriginalDnsServers'] = self.original_dns_servers.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NewDnsServers') is not None:
            temp_model = ModifyHichinaDomainDNSResponseBodyNewDnsServers()
            self.new_dns_servers = temp_model.from_map(m['NewDnsServers'])
        if m.get('OriginalDnsServers') is not None:
            temp_model = ModifyHichinaDomainDNSResponseBodyOriginalDnsServers()
            self.original_dns_servers = temp_model.from_map(m['OriginalDnsServers'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ModifyHichinaDomainDNSResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ModifyHichinaDomainDNSResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ModifyHichinaDomainDNSResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MoveDomainResourceGroupRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        new_resource_group_id: str = None,
        resource_id: str = None,
    ):
        # The language of some returned parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The ID of the resource group.
        self.new_resource_group_id = new_resource_group_id
        # The domain name.
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.new_resource_group_id is not None:
            result['NewResourceGroupId'] = self.new_resource_group_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NewResourceGroupId') is not None:
            self.new_resource_group_id = m.get('NewResourceGroupId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class MoveDomainResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class MoveDomainResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: MoveDomainResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = MoveDomainResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MoveGtmResourceGroupRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        new_resource_group_id: str = None,
        resource_id: str = None,
    ):
        self.lang = lang
        self.new_resource_group_id = new_resource_group_id
        self.resource_id = resource_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.new_resource_group_id is not None:
            result['NewResourceGroupId'] = self.new_resource_group_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('NewResourceGroupId') is not None:
            self.new_resource_group_id = m.get('NewResourceGroupId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        return self


class MoveGtmResourceGroupResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class MoveGtmResourceGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: MoveGtmResourceGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = MoveGtmResourceGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class OperateBatchDomainRequestDomainRecordInfo(TeaModel):
    def __init__(
        self,
        domain: str = None,
        line: str = None,
        new_rr: str = None,
        new_type: str = None,
        new_value: str = None,
        priority: int = None,
        rr: str = None,
        ttl: int = None,
        type: str = None,
        value: str = None,
    ):
        # The domain name corresponding to DNS record N.
        # 
        # >  N is specified by users. **N** starts from **1**. The maximum value of N is **1000**. Extra data entries are ignored.
        self.domain = domain
        # The resolution line of DNS record N. Default value: default.
        # 
        # For more information, see [Resolution line enumeration](https://www.alibabacloud.com/help/zh/doc-detail/29807.htm).
        self.line = line
        self.new_rr = new_rr
        self.new_type = new_type
        self.new_value = new_value
        # The priority of MX-type DNS record N.
        # 
        # This parameter must be specified if the type of the DNS record is MX. Default value: 10.
        self.priority = priority
        # The host record corresponding to DNS record N.
        # 
        # >  If you set the Type parameter to **RR_ADD**, you must also specify this parameter.
        self.rr = rr
        # The TTL of DNS record N. Unit: seconds. Default value: **600**.
        self.ttl = ttl
        # The type of DNS record N. For the DNS record types supported by Alibaba Cloud DNS, see [Resolution record type formats](https://www.alibabacloud.com/help/zh/doc-detail/29805.htm).
        # 
        # >  If you set the Type parameter to **RR_ADD**, you must also specify this parameter.
        self.type = type
        # The value of DNS record N.
        # 
        # >  If you set the Type parameter to **RR_ADD**, you must also specify this parameter.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.line is not None:
            result['Line'] = self.line
        if self.new_rr is not None:
            result['NewRr'] = self.new_rr
        if self.new_type is not None:
            result['NewType'] = self.new_type
        if self.new_value is not None:
            result['NewValue'] = self.new_value
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.rr is not None:
            result['Rr'] = self.rr
        if self.ttl is not None:
            result['Ttl'] = self.ttl
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('NewRr') is not None:
            self.new_rr = m.get('NewRr')
        if m.get('NewType') is not None:
            self.new_type = m.get('NewType')
        if m.get('NewValue') is not None:
            self.new_value = m.get('NewValue')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('Rr') is not None:
            self.rr = m.get('Rr')
        if m.get('Ttl') is not None:
            self.ttl = m.get('Ttl')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class OperateBatchDomainRequest(TeaModel):
    def __init__(
        self,
        domain_record_info: List[OperateBatchDomainRequestDomainRecordInfo] = None,
        lang: str = None,
        type: str = None,
    ):
        self.domain_record_info = domain_record_info
        # The language type.
        self.lang = lang
        # The type of the batch operation. Valid values:
        # 
        # *   **DOMAIN_ADD**: adds domain names in batches.
        # *   **DOMAIN_DEL**: deletes domain names in batches.
        # *   **RR_ADD**: adds DNS records in batches.
        # *   **RR_DEL**: deletes DNS records in batches. (If RR or VALUE exists, DNS records corresponding to the specified RR or VALUE are deleted. If both of them exist, DNS records corresponding to the specified RR and VALUE are deleted. If no RR or VALUE is specified, the DNS records corresponding to the DomainName parameter are deleted.)
        self.type = type

    def validate(self):
        if self.domain_record_info:
            for k in self.domain_record_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainRecordInfo'] = []
        if self.domain_record_info is not None:
            for k in self.domain_record_info:
                result['DomainRecordInfo'].append(k.to_map() if k else None)
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_record_info = []
        if m.get('DomainRecordInfo') is not None:
            for k in m.get('DomainRecordInfo'):
                temp_model = OperateBatchDomainRequestDomainRecordInfo()
                self.domain_record_info.append(temp_model.from_map(k))
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class OperateBatchDomainResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        task_id: int = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The ID of the task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class OperateBatchDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: OperateBatchDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = OperateBatchDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PausePdnsServiceRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        service_type: str = None,
    ):
        self.lang = lang
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        return self


class PausePdnsServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class PausePdnsServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: PausePdnsServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = PausePdnsServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class PreviewGtmRecoveryPlanRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        page_number: int = None,
        page_size: int = None,
        recovery_plan_id: int = None,
    ):
        # The language used by the user.
        self.lang = lang
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.page_number = page_number
        # The number of entries to return on per page. Maximum value: **20**. Default value: **5**.
        self.page_size = page_size
        # The ID of the disaster recovery plan that you want to preview.
        self.recovery_plan_id = recovery_plan_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.recovery_plan_id is not None:
            result['RecoveryPlanId'] = self.recovery_plan_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RecoveryPlanId') is not None:
            self.recovery_plan_id = m.get('RecoveryPlanId')
        return self


class PreviewGtmRecoveryPlanResponseBodyPreviewsPreviewSwitchInfosSwitchInfo(TeaModel):
    def __init__(
        self,
        content: str = None,
        strategy_name: str = None,
    ):
        # The formatted message content.
        self.content = content
        # The name of the switching policy for address pools.
        self.strategy_name = strategy_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.strategy_name is not None:
            result['StrategyName'] = self.strategy_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('StrategyName') is not None:
            self.strategy_name = m.get('StrategyName')
        return self


class PreviewGtmRecoveryPlanResponseBodyPreviewsPreviewSwitchInfos(TeaModel):
    def __init__(
        self,
        switch_info: List[PreviewGtmRecoveryPlanResponseBodyPreviewsPreviewSwitchInfosSwitchInfo] = None,
    ):
        self.switch_info = switch_info

    def validate(self):
        if self.switch_info:
            for k in self.switch_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['SwitchInfo'] = []
        if self.switch_info is not None:
            for k in self.switch_info:
                result['SwitchInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.switch_info = []
        if m.get('SwitchInfo') is not None:
            for k in m.get('SwitchInfo'):
                temp_model = PreviewGtmRecoveryPlanResponseBodyPreviewsPreviewSwitchInfosSwitchInfo()
                self.switch_info.append(temp_model.from_map(k))
        return self


class PreviewGtmRecoveryPlanResponseBodyPreviewsPreview(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        name: str = None,
        switch_infos: PreviewGtmRecoveryPlanResponseBodyPreviewsPreviewSwitchInfos = None,
        user_domain_name: str = None,
    ):
        # The ID of the GTM instance to which the previewed disaster recovery plan belongs.
        self.instance_id = instance_id
        # The name of the GTM instance to which the previewed disaster recovery plan belongs.
        self.name = name
        # The returned information of the switching policies for address pools.
        self.switch_infos = switch_infos
        # The user\"s domain name or domain name list.
        self.user_domain_name = user_domain_name

    def validate(self):
        if self.switch_infos:
            self.switch_infos.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.switch_infos is not None:
            result['SwitchInfos'] = self.switch_infos.to_map()
        if self.user_domain_name is not None:
            result['UserDomainName'] = self.user_domain_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SwitchInfos') is not None:
            temp_model = PreviewGtmRecoveryPlanResponseBodyPreviewsPreviewSwitchInfos()
            self.switch_infos = temp_model.from_map(m['SwitchInfos'])
        if m.get('UserDomainName') is not None:
            self.user_domain_name = m.get('UserDomainName')
        return self


class PreviewGtmRecoveryPlanResponseBodyPreviews(TeaModel):
    def __init__(
        self,
        preview: List[PreviewGtmRecoveryPlanResponseBodyPreviewsPreview] = None,
    ):
        self.preview = preview

    def validate(self):
        if self.preview:
            for k in self.preview:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Preview'] = []
        if self.preview is not None:
            for k in self.preview:
                result['Preview'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.preview = []
        if m.get('Preview') is not None:
            for k in m.get('Preview'):
                temp_model = PreviewGtmRecoveryPlanResponseBodyPreviewsPreview()
                self.preview.append(temp_model.from_map(k))
        return self


class PreviewGtmRecoveryPlanResponseBody(TeaModel):
    def __init__(
        self,
        page_number: int = None,
        page_size: int = None,
        previews: PreviewGtmRecoveryPlanResponseBodyPreviews = None,
        request_id: str = None,
        total_items: int = None,
        total_pages: int = None,
    ):
        # The page number of the returned page.
        self.page_number = page_number
        # The number of entries returned per page.
        self.page_size = page_size
        # The returned preview information of the disaster recovery plan.
        self.previews = previews
        # The ID of the request.
        self.request_id = request_id
        # The total number of entries returned on all pages.
        self.total_items = total_items
        # The total number of pages returned.
        self.total_pages = total_pages

    def validate(self):
        if self.previews:
            self.previews.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.previews is not None:
            result['Previews'] = self.previews.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_items is not None:
            result['TotalItems'] = self.total_items
        if self.total_pages is not None:
            result['TotalPages'] = self.total_pages
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Previews') is not None:
            temp_model = PreviewGtmRecoveryPlanResponseBodyPreviews()
            self.previews = temp_model.from_map(m['Previews'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalItems') is not None:
            self.total_items = m.get('TotalItems')
        if m.get('TotalPages') is not None:
            self.total_pages = m.get('TotalPages')
        return self


class PreviewGtmRecoveryPlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: PreviewGtmRecoveryPlanResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = PreviewGtmRecoveryPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemovePdnsAppKeyRequest(TeaModel):
    def __init__(
        self,
        app_key_id: str = None,
        lang: str = None,
    ):
        self.app_key_id = app_key_id
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_key_id is not None:
            result['AppKeyId'] = self.app_key_id
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppKeyId') is not None:
            self.app_key_id = m.get('AppKeyId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class RemovePdnsAppKeyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemovePdnsAppKeyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RemovePdnsAppKeyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RemovePdnsAppKeyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemovePdnsUdpIpSegmentRequest(TeaModel):
    def __init__(
        self,
        ip: str = None,
        lang: str = None,
    ):
        self.ip = ip
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class RemovePdnsUdpIpSegmentResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RemovePdnsUdpIpSegmentResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RemovePdnsUdpIpSegmentResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RemovePdnsUdpIpSegmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResumePdnsServiceRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        service_type: str = None,
    ):
        self.lang = lang
        self.service_type = service_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        return self


class ResumePdnsServiceResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ResumePdnsServiceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ResumePdnsServiceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ResumePdnsServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RetrieveDomainRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language type.
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class RetrieveDomainResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RetrieveDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RetrieveDomainResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RetrieveDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RollbackGtmRecoveryPlanRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        recovery_plan_id: int = None,
    ):
        # The language used by the user.
        self.lang = lang
        # The ID of the disaster recovery plan that you want to roll back.
        self.recovery_plan_id = recovery_plan_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.recovery_plan_id is not None:
            result['RecoveryPlanId'] = self.recovery_plan_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RecoveryPlanId') is not None:
            self.recovery_plan_id = m.get('RecoveryPlanId')
        return self


class RollbackGtmRecoveryPlanResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RollbackGtmRecoveryPlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: RollbackGtmRecoveryPlanResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RollbackGtmRecoveryPlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetDNSSLBStatusRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        lang: str = None,
        line: str = None,
        open: bool = None,
        sub_domain: str = None,
        type: str = None,
        user_client_ip: str = None,
    ):
        # The domain name.
        self.domain_name = domain_name
        # The language of the subdomain.
        self.lang = lang
        self.line = line
        # Specifies whether to enable or disable weighted round-robin. Valid values:
        # 
        # *   **true**: enables weighted round-robin. This is the default value.
        # *   **false**: disables weighted round-robin.
        self.open = open
        # The subdomain for which you want to configure weighted round-robin. Do not set the value to a string such as aliyun.com. Instead, set the value to @.aliyun.com.
        self.sub_domain = sub_domain
        # The type of the DNS record. Valid values: A and AAAA. Default value: A.
        self.type = type
        # The IP address of the client that you use to configure weighted round-robin.
        self.user_client_ip = user_client_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.line is not None:
            result['Line'] = self.line
        if self.open is not None:
            result['Open'] = self.open
        if self.sub_domain is not None:
            result['SubDomain'] = self.sub_domain
        if self.type is not None:
            result['Type'] = self.type
        if self.user_client_ip is not None:
            result['UserClientIp'] = self.user_client_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Line') is not None:
            self.line = m.get('Line')
        if m.get('Open') is not None:
            self.open = m.get('Open')
        if m.get('SubDomain') is not None:
            self.sub_domain = m.get('SubDomain')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('UserClientIp') is not None:
            self.user_client_ip = m.get('UserClientIp')
        return self


class SetDNSSLBStatusResponseBody(TeaModel):
    def __init__(
        self,
        open: bool = None,
        record_count: int = None,
        request_id: str = None,
    ):
        # Indicates whether weighted round-robin is enabled for the subdomain.
        self.open = open
        # The number of A records that are matched.
        self.record_count = record_count
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.open is not None:
            result['Open'] = self.open
        if self.record_count is not None:
            result['RecordCount'] = self.record_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Open') is not None:
            self.open = m.get('Open')
        if m.get('RecordCount') is not None:
            self.record_count = m.get('RecordCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SetDNSSLBStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: SetDNSSLBStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SetDNSSLBStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SetDnsGtmAccessModeRequest(TeaModel):
    def __init__(
        self,
        access_mode: str = None,
        lang: str = None,
        strategy_id: str = None,
    ):
        # The primary/secondary switchover policy for address pool groups. Valid values:
        # 
        # *   AUTO: performs automatic switchover between the primary and secondary address pool groups upon failures.
        # *   DEFAULT: uses the primary address pool group.
        # *   FAILOVER: uses the secondary address pool group.
        self.access_mode = access_mode
        # The language to return some response parameters. Default value: en. Valid values: en, zh, and ja.
        self.lang = lang
        # The ID of the policy.
       