"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafwebaclToApiGateway = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
// Imports
const constructs_1 = require("constructs");
const waf = require("aws-cdk-lib/aws-wafv2");
const defaults = require("@aws-solutions-constructs/core");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * @summary The WafwebaclToApiGateway class.
 */
class WafwebaclToApiGateway extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the WafwebaclToApiGateway class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {WafwebaclToApiGatewayProps} props - user provided props for the construct.
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        // Build the Web ACL
        this.webacl = defaults.buildWebacl(this, 'REGIONAL', {
            existingWebaclObj: props.existingWebaclObj,
            webaclProps: props.webaclProps,
        });
        const resourceArn = `arn:${aws_cdk_lib_1.Aws.PARTITION}:apigateway:${aws_cdk_lib_1.Aws.REGION}::/restapis/${props.existingApiGatewayInterface.restApiId}/stages/${props.existingApiGatewayInterface.deploymentStage.stageName}`;
        // Setup the Web ACL Association
        new waf.CfnWebACLAssociation(scope, `${id}-WebACLAssociation`, {
            webAclArn: this.webacl.attrArn,
            resourceArn
        });
        this.apiGateway = props.existingApiGatewayInterface;
    }
}
exports.WafwebaclToApiGateway = WafwebaclToApiGateway;
_a = JSII_RTTI_SYMBOL_1;
WafwebaclToApiGateway[_a] = { fqn: "@aws-solutions-constructs/aws-wafwebacl-apigateway.WafwebaclToApiGateway", version: "2.35.0" };
//# sourceMappingURL=data:application/json;base64,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