"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const nodeunit_shim_1 = require("nodeunit-shim");
// tslint:disable-next-line:max-line-length
const lib_1 = require("../lib");
/**
 * A load balancer that can host a VPC Endpoint Service
 */
class DummyEndpointLoadBalacer {
    constructor(arn) {
        this.loadBalancerArn = arn;
    }
}
nodeunit_shim_1.nodeunitShim({
    'test vpc endpoint service': {
        'create endpoint service with no principals'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            new lib_1.Vpc(stack, 'MyVPC');
            // WHEN
            const lb = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
            new lib_1.VpcEndpointService(stack, 'EndpointService', {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: false,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root')],
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ['arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a'],
                AcceptanceRequired: false,
            }));
            assert_1.expect(stack).notTo(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: 'EndpointServiceED36BE1F',
                },
                AllowedPrincipals: [],
            }));
            test.done();
        },
        'create endpoint service with a principal'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            // WHEN
            const lb = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
            new lib_1.VpcEndpointService(stack, 'EndpointService', {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: false,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root')],
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ['arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a'],
                AcceptanceRequired: false,
            }));
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: 'EndpointServiceED36BE1F',
                },
                AllowedPrincipals: ['arn:aws:iam::123456789012:root'],
            }));
            test.done();
        },
        'with acceptance requried'(test) {
            // GIVEN
            const stack = new core_1.Stack();
            // WHEN
            const lb = new DummyEndpointLoadBalacer('arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a');
            new lib_1.VpcEndpointService(stack, 'EndpointService', {
                vpcEndpointServiceLoadBalancers: [lb],
                acceptanceRequired: true,
                whitelistedPrincipals: [new aws_iam_1.ArnPrincipal('arn:aws:iam::123456789012:root')],
            });
            // THEN
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointService', {
                NetworkLoadBalancerArns: ['arn:aws:elasticloadbalancing:us-east-1:123456789012:loadbalancer/net/Test/9bn6qkf4e9jrw77a'],
                AcceptanceRequired: true,
            }));
            assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::VPCEndpointServicePermissions', {
                ServiceId: {
                    Ref: 'EndpointServiceED36BE1F',
                },
                AllowedPrincipals: ['arn:aws:iam::123456789012:root'],
            }));
            test.done();
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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