# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['fastapi_admin', 'fastapi_admin.routes']

package_data = \
{'': ['*']}

install_requires = \
['aiomysql',
 'aiosqlite',
 'bcrypt',
 'colorama',
 'fastapi[all]',
 'passlib',
 'prompt_toolkit',
 'pyjwt',
 'python-dotenv',
 'python-rapidjson',
 'tortoise-orm',
 'uvloop',
 'xlsxwriter']

entry_points = \
{'console_scripts': ['fastapi-admin = fastapi_admin.cli:main']}

setup_kwargs = {
    'name': 'fastapi-admin',
    'version': '0.2.7',
    'description': 'Fast Admin Dashboard based on fastapi and tortoise-orm and rest-admin.',
    'long_description': '=============\nFastAPI Admin\n=============\n\n.. image:: https://img.shields.io/pypi/v/fastapi-admin.svg?style=flat\n   :target: https://pypi.python.org/pypi/fastapi-admin\n.. image:: https://img.shields.io/github/license/long2ice/fastapi-admin\n   :target: https://github.com/long2ice/fastapi-admin\n.. image:: https://github.com/long2ice/fastapi-admin/workflows/gh-pages/badge.svg\n   :target: https://github.com/long2ice/fastapi-admin/actions?query=workflow:gh-pages\n.. image:: https://github.com/long2ice/fastapi-admin/workflows/pypi/badge.svg\n   :target: https://github.com/long2ice/fastapi-admin/actions?query=workflow:pypi\n\n`中文文档 <https://blog.long2ice.cn/2020/05/fastapi-admin%E5%BF%AB%E9%80%9F%E6%90%AD%E5%BB%BA%E5%9F%BA%E4%BA%8Efastapi%E4%B8%8Etortoise-orm%E7%9A%84%E7%AE%A1%E7%90%86%E5%90%8E%E5%8F%B0/>`_\n\n\nIntroduction\n============\n\nFastAPI-Admin is a admin dashboard based on `fastapi <https://github.com/tiangolo/fastapi>`_ and `tortoise-orm <https://github.com/tortoise/tortoise-orm>`_.\n\nFastAPI-Admin provide crud feature out-of-the-box with just a few config.\n\nLive Demo\n=========\nCheck a live Demo here `https://fastapi-admin.long2ice.cn <https://fastapi-admin.long2ice.cn/>`_.\n\n* username: ``admin``\n* password: ``123456``\n\nData in database will restore every day.\n\nScreenshots\n===========\n\n.. image:: https://github.com/long2ice/fastapi-admin/raw/master/images/login.png\n.. image:: https://github.com/long2ice/fastapi-admin/raw/master/images/list.png\n.. image:: https://github.com/long2ice/fastapi-admin/raw/master/images/view.png\n.. image:: https://github.com/long2ice/fastapi-admin/raw/master/images/create.png\n\nRequirements\n============\n\n* `FastAPI <https://github.com/tiangolo/fastapi>`_ framework as your backend framework.\n* `Tortoise-ORM <https://github.com/tortoise/tortoise-orm>`_ as your orm framework, by the way, which is best asyncio orm so far and I\'m one of the contributors😋.\n\nQuick Start\n===========\n\nRun Example Local\n~~~~~~~~~~~~~~~~~\nLook at `examples <https://github.com/long2ice/fastapi-admin/tree/master/examples>`_.\n\n1. ``git clone https://github.com/long2ice/fastapi-admin.git``.\n2. create database ``fastapi-admin`` and import from ``examples/example.sql``.\n3. ``python setup.py install``.\n4. ``env DATABASE_URL=mysql://root:123456@127.0.0.1:3306/fastapi-admin PYTHONPATH=./ python3 examples/main.py``,then you can see:\n\n.. code-block:: python\n\n    INFO:     Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)\n    INFO:     Started reloader process [89005]\n    INFO:     Started server process [89009]\n    INFO:     Waiting for application startup.\n    INFO:     Tortoise-ORM startup\n        connections: {\'default\': \'mysql://root:123456@127.0.0.1:3306/fastapi-admin\'}\n        apps: {\'models\': {\'models\': [\'examples.models\'], \'default_connection\': \'default\'}}\n    INFO:     Tortoise-ORM started, {\'default\': <tortoise.backends.mysql.client.MySQLClient object at 0x110ed6760>}, {\'models\': {\'Category\': <class \'examples.models.Category\'>, \'Product\': <class \'examples.models.Product\'>, \'User\': <class \'examples.models.User\'>}}\n    INFO:     Tortoise-ORM generating schema\n    INFO:     Application startup complete.\n\nBackend Integration\n~~~~~~~~~~~~~~~~~~~\n\n.. code-block:: shell\n\n    $ pip3 install fastapi-admin\n\n.. code-block:: python\n\n    from fastapi_admin.factory import app as admin_app\n\n    fast_app = FastAPI()\n\n    register_tortoise(fast_app, config=TORTOISE_ORM, generate_schemas=True)\n\n    fast_app.mount(\'/admin\', admin_app)\n\n    @fast_app.on_event(\'startup\')\n    async def startup():\n        admin_app.init(\n            user_model=\'User\',\n            tortoise_app=\'models\',\n            admin_secret=\'test\',\n            permission=True,\n            site=Site(...)\n        )\n\nFront\n~~~~~\nSee `fastapi-admin-front <https://github.com/long2ice/fastapi-admin-front>`_ for reference.\n\nFeatures\n========\n\nBuiltin Auth And Permissions Control\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\nInherit ``fastapi_admin.models.User`` and add you own fields,must contains ``is_active`` and ``is_superuser``.\n\n.. code-block:: python\n\n    from fastapi_admin.models import User as AdminUser\n\n    class AdminUser(AdminUser,Model):\n        is_active = fields.BooleanField(default=False, description=\'Is Active\')\n        is_superuser = fields.BooleanField(default=False, description=\'Is Superuser\')\n        status = fields.IntEnumField(Status, description=\'User Status\')\n        created_at = fields.DatetimeField(auto_now_add=True)\n        updated_at = fields.DatetimeField(auto_now=True)\n\nThen add ``fastapi_admin.models`` to ``Tortoise-ORM`` config, example:\n\n.. code-block:: python\n\n    TORTOISE_ORM = {\n        \'connections\': {\n            \'default\': os.getenv(\'DATABASE_URL\')\n        },\n        \'apps\': {\n            \'models\': {\n                \'models\': [\'examples.models\', \'fastapi_admin.models\'],\n                \'default_connection\': \'default\',\n            }\n        }\n    }\n\nAnd set ``permission=True`` to active it:\n\n.. code-block:: python\n\n        admin_app.init(\n            user_model=\'AdminUser\',\n            admin_secret=\'123456\',\n            models=\'examples.models\',\n            permission=True,\n            site=Site(\n                ...\n            )\n        )\n\nAnd register permissions and createsuperuser:\n\n.. code-block:: shell\n\n    $ fastapi-admin -h\n    usage: fastapi-admin [-h] -c CONFIG {register_permissions,createsuperuser} ...\n\n    optional arguments:\n      -h, --help            show this help message and exit\n      -c CONFIG, --config CONFIG\n                            Tortoise-orm config dict import path,like settings.TORTOISE_ORM.\n\n    subcommands:\n      {register_permissions,createsuperuser}\n\nCustom Login\n~~~~~~~~~~~~\nYou can write your own login view logic:\n\n.. code-block:: python\n\n    admin_app.init(\n        ...\n        login_view="examples.routes.login"\n    )\n\nAnd must return json like:\n\n.. code-block:: json\n\n    {\n        "user": {\n            "username": "admin",\n            "is_superuser": False,\n            "avatar": "https://avatars2.githubusercontent.com/u/13377178?s=460&u=d150d522579f41a52a0b3dd8ea997e0161313b6e&v=4",\n        },\n        "token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJ1c2VyX2lkIjoyfQ.HSlcYkOEQewxyPuaqcVwCcw_wkbLB50Ws1-ZxfPoLAQ",\n    }\n\nEnum Support\n~~~~~~~~~~~~\nWhen you define a enum field of tortoise-orm,like ``IntEnumField``,you can inherit ``fastapi_admin.enums.EnumMixin`` and impl ``choices()`` method,\nFastAPI-Admin will auto read and display and render a ``select`` widget in front.\n\n.. code-block:: python\n\n    class Status(EnumMixin, IntEnum):\n        on = 1\n        off = 2\n\n        @classmethod\n        def choices(cls):\n            return {\n                cls.on: \'ON\',\n                cls.off: \'OFF\'\n            }\n\nVerbose Name\n~~~~~~~~~~~~\nFastAPI-Admin will auto read ``description`` defined in tortoise-orm model ``Field`` and display in front.\n\nForeignKeyField Support\n~~~~~~~~~~~~~~~~~~~~~~~\nIf ``ForeignKeyField`` not passed in ``menu.raw_id_fields``,FastAPI-Admin will get all related objects and display ``select`` in front with ``Model.__str__``.\n\nManyToManyField Support\n~~~~~~~~~~~~~~~~~~~~~~~\nFastAPI-Admin will render ``ManyToManyField`` with multiple ``select`` in ``form`` edit with ``Model.__str__``.\n\nJSONField Render\n~~~~~~~~~~~~~~~~\nFastAPI-Admin will render ``JSONField`` with ``jsoneditor`` as beauty interface.\n\nSearch Fields\n~~~~~~~~~~~~~\nDefined ``menu.search_fields`` in ``menu`` will render a search form by fields.\n\nXlsx Export\n~~~~~~~~~~~\nFastAPI-Admin can export searched data to excel file when define ``export=True`` in ``menu``.\n\nBulk Actions\n~~~~~~~~~~~~\nCurrent FastAPI-Admin support builtin bulk action ``delete_all``,if you want write your own bulk actions:\n\n1. pass ``bulk_actions`` in ``Menu``,example:\n\n.. code-block:: python\n\n    Menu(\n        ...\n        bulk_actions=[{\n            \'value\': \'delete\', # this is fastapi router path param.\n            \'text\': \'delete_all\', # this will show in front.\n        }]\n    )\n\n2. write fastapi route,example:\n\n.. code-block:: python\n\n    from fastapi_admin.schemas import BulkIn\n    from fastapi_admin.factory import app as admin_app\n\n    @admin_app.post(\n        \'/rest/{resource}/bulk/delete\' # `delete` is defined in Menu before.\n    )\n    async def bulk_delete(\n            bulk_in: BulkIn,\n            model=Depends(get_model)\n    ):\n        await model.filter(pk__in=bulk_in.pk_list).delete()\n        return {\'success\': True}\n\nDefault Menus\n~~~~~~~~~~~~~\nDefault, FastAPI-Admin provide default menus by your models, without doing tedious works.\n\nDeployment\n==========\nDeploy fastapi app by gunicorn+uvicorn or reference https://fastapi.tiangolo.com/deployment/.\n\nRestful API Docs\n================\nSee `restful api <https://api-fastapi-admin.long2ice.cn:8443/admin/docs>`_ docs.\n\nDocuments\n=========\nSee `documents <https://fastapi-admin-docs.long2ice.cn>`_ for reference.\n\nThanksTo\n========\n\n* `fastapi <https://github.com/tiangolo/fastapi>`_ ,high performance async api framework.\n* `tortoise-orm <https://github.com/tortoise/tortoise-orm>`_ ,familiar asyncio ORM for python.\n\nLicense\n=======\n\nThis project is licensed under the `MIT <https://github.com/long2ice/fastapi-admin/blob/master/LICENSE>`_ License.\n',
    'author': 'long2ice',
    'author_email': 'long2ice@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/long2ice/fastapi-admin',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
