# lightSpider
lightsmile个人的用于爬取网络公开语料数据的mini通用爬虫框架。

## 声明

1. 本项目仅是本人简单尝试，系统功能并不完善。
2. 已有的特性：
   - 启用代理池，降低ip被封带来的损失风险
   - 启用多进程，加快进程爬取速度
   - 实现断点重爬，即使程序因内外在原因挂掉了，可以继续执行任务脚本继续爬取
   - 启用进度条，可实时显示当前爬取总进度与爬取速度，用户体验较好
   - 提供了爬取百度百科的实现，提供批量爬取和单项查询两种模式，简单易用
   - 邮件提醒功能，程序可以在任务执行完成后发送邮件到指定邮箱
3. 本项目并没有：
   - 验证码登录功能
   - 其他复杂功能
   - 等等。

## 安装

```bash
pip install lightSpider
```
建议使用国内源来安装，如使用以下命令：

```bash
pip install -i https://pypi.douban.com/simple/ lightSpider
```

## 使用

### step1: 引入必要依赖库

```python
from lightspider import Spider, light, DEFAULT_PROXY
```
### step2：编写页面解析函数

如：
```python
# 编写页面解析函数
@light
def parser(response):
    """
    必要的页面解析函数
    :param response: 执行Request请求后得到的Response对象，可以自由选择xpath或BeautifulSoup等方式解析处理
    :return: type：tuple:(解析得到的数据对象, 解析页面得到的新的tasks（要么为List，要么为None)
    """
    html = etree.HTML(response.text)
    info = html.xpath('//div[@class="col-md-8"]')[0]
    words = [re.sub(r'\(\d+\)', '', item.xpath('string(.)')) for item in info.xpath('./b')[:-1]]
    mean = info.xpath('./a/text()')[0]
    return {
        'mean': mean,
        'words': words
    }, None
```

### step3：编写得到tasks脚本

如：
```python
tasks = []
for i in range(1, 30):
    tasks.append(i)
```

### step4: 创建`Spider`对象

如：
```python
base_url = 'https://www.cilin.org/jyc/b_{}.html'
save_format = 'json'

spider = Spider(base_url=base_url, save_format=save_format, save_path=r'D:\Data\NLP\corpus\baike_search')
```

### step5: 执行`Spider`对象的`run`方法

如：
```python
if __name__ == '__main__':
    spider.run(tasks, parser)
```
**注意**：`if-main`句式不能省略！

## [完整示例](https://github.com/smilelight/lightSpider/blob/master/examples/jyc.py)

```python
from lightspider import Spider, light, DEFAULT_PROXY

from lxml import etree
import re


# 编写页面解析函数
@light
def parser(response):
    """
    必要的页面解析函数
    :param response: 执行Request请求后得到的Response对象，可以自由选择xpath或BeautifulSoup等方式解析处理
    :return: type：tuple:(解析得到的数据对象, 解析页面得到的新的tasks（要么为List，要么为None)
    """
    html = etree.HTML(response.text)
    info = html.xpath('//div[@class="col-md-8"]')[0]
    words = [re.sub(r'\(\d+\)', '', item.xpath('string(.)')) for item in info.xpath('./b')[:-1]]
    mean = info.xpath('./a/text()')[0]
    return {
        'mean': mean,
        'words': words
    }, None

tasks = []
for i in range(1, 30):
    tasks.append(i)

base_url = 'https://www.cilin.org/jyc/b_{}.html'
save_format = 'json'

spider = Spider(base_url=base_url, save_format=save_format, save_path=r'D:\Data\NLP\corpus\baike_search')


if __name__ == '__main__':
    spider.run(tasks, parser)

```

### 执行结果

**说明**：批量爬取模式中，会在指定存储目录生成3个文件：`handled.txt`,`result.xxx`,`task.txt`。
其中`handled.txt`代表已处理的task，`task.txt`表示初始总的task，`result.xxx`表示爬取结果数据文件，格式可以选择`csv`和`json`，需要自行配合自己写的parser函数使用。

如图：
![Demo](res/lightSpider-demo.jpg)

断点重爬效果如图：
![断点重爬1](res/lightSpider-recrawl-1.jpg)
![断点重爬2](res/lightSpider-recrawl-2.jpg)

## 高级功能

### 1.使用代理及启用代理池服务（可选）

设置`Spider`的`proxy`参数为自己传入的代理（如`{
                    'http': '127.0.0.1:1080'
                }`，默认为`None`），即代码修改为：
```python
proxy = {'http': '127.0.0.1:1080'}
spider = Spider(base_url=base_url, format=save_format, save_path=r'D:\Data\NLP\corpus\test', proxy=proxy)
```
即可启用代理

若想启用代理池服务，则需要参见[Python3WebSpider/ProxyPool: Proxy Pool](https://github.com/Python3WebSpider/ProxyPool)以进行环境配置并启动服务，代码则修改为：

```python
spider = Spider(base_url=base_url, save_format=save_format, save_path=r'D:\Data\NLP\corpus\test', proxy=DEFAULT_PROXY)
```

### 2.百度百科

#### 批量爬取百科条目基本信息

使用示例：

```python
from lightspider.baike import info
from lightspider import Spider


tasks = ['曹操', '曹操字孟德', '司马懿',
         '自然语言处理', '知识图谱', '人工智能', '深度学习', '爬虫']

spider = Spider(base_url=info.base_url, save_format=info.save_format, save_path=r'D:\Data\NLP\corpus\baike_info')

if __name__ == '__main__':
    spider.run(tasks, info.parser)
```

执行结果：

```bash
[2020-01-11 20:29:32] [WARNING] [MainThread] [spider.py:22] 指定目录不存在！将创建存储目录D:\Data\NLP\corpus\baike_info
[2020-01-11 20:29:32] [INFO] [MainThread] [spider.py:42] 已处理0条数据，还需处理8条数据
[2020-01-11 20:29:33] [INFO] [MainThread] [spider.py:55] 开始爬取，当前时间为：2020-01-11 20:29:33
[2020-01-11 20:29:34] [INFO] [MainThread] [writer.py:10] 写入地址为：D:\Data\NLP\corpus\baike_info/result.json， 临时文件地址为：D:\Data\NLP\corpus\baike_info/handled.txt
100%|██████████| 8/8 [00:01<00:00,  5.69it/s]
[2020-01-11 20:29:35] [INFO] [MainThread] [spider.py:72] 执行结束, 当前时间为：2020-01-11 20:29:35
[2020-01-11 20:29:35] [INFO] [MainThread] [spider.py:75] 本次共计耗时2.57s，共爬取数据条数为8，平均速度为：3.11(task/s)
```

爬取内容示例：

```bash
{"info": {"word": "自然语言处理", "basic": {"title": "自然语言处理", "description": "自然语言处理是计算机科学领域与人工智能领域中的一个重要方向。它研究能实现人与计算机之间用自然语言进行有效通信的各种理论和方法。自然语言处理是一门融语言学、计算机科学、数学于一体的科学。因此，这一领域的研究将涉及自然语言，即人们日常使用的语言，所以它与语言学的研究有着密切的联系，但又有重要的区别。自然语言处理并不是一般地研究自然语言，而在于研制能有效地实现自然语言通信的计算机系统，特别是其中的软件系统。因而它是计算机科学的一部分。自然语言处理（NLP）是计算机科学，人工智能，语言学关注计算机和人类（自然）语言之间的相互作用的领域。"}, "attrs": {"中文名": "自然语言处理", "外文名": "naturallanguageprocessing", "适用领域": "计算机、人工智能", "缩写": "NLP"}, "tags": ["科学百科信息科学分类", "中国电子学会", "科学", "学科"]}, "type": "signal"}
{"info": {"word": "司马懿", "means": [["司马懿：三国时期曹魏权臣", "司马懿/9367"], ["司马懿：手游《我有上将》人物角色", "司马懿/21579401"], ["司马懿：手游《少年三国志》中人物", "司马懿/16819541"], ["司马懿：司马懿《唱吧三国》中武将形象", "司马懿/17186885"], ["司马懿：手游《百将行》游戏角色", "司马懿/20178043"], ["司马懿：南门太守所著书籍", "司马懿/22163927"], ["司马懿：日本游戏《真·三国无双》系列中人物", "司马懿/4021665"], ["司马懿：游戏《英雄三国》角色", "司马懿/16184657"], ["司马懿：桌游《三国杀》中的武将", "司马懿/4021684"], ["司马懿：游戏《赛尔号》中的精灵", "司马懿/16962770"], ["司马懿：方北辰所著书籍", "司马懿/13873914"], ["司马懿：《阵面对决》中的卡牌", "司马懿/19923464"], ["司马懿：MOBA手游《英魂之刃口袋版》里的法师类英雄", "司马懿/19877986"], ["司马懿：TCG桌游《乱战》卡片名", "司马懿/16307467"], ["司马懿：《梦三国》游戏人物角色", "司马懿/13875221"], ["司马懿：《虽远必诛》手游武将", "司马懿/19519097"], ["司马懿：《大皇帝》中人物角色", "司马懿/15963229"], ["司马懿：小说及漫画《哑舍》角色", "司马懿/22664368"], ["司马懿：手游《王者荣耀》中的英雄角色", "司马懿/22762691"], ["司马懿：《Fate/Grand Order》中登场的Rider之一", "司马懿/23448742"], ["司马懿：漫画《火凤燎原》角色", "司马懿/24118117"], ["司马懿：MOBA端游《英魂之刃》里的一名法师类的英雄", "司马懿/24143256"]]}, "type": "ambiguous"}
{"info": {"word": "深度学习", "basic": {"title": "深度学习", "sub_title": "（人工神经网络的研究的概念）", "description": "深度学习(DL, Deep Learning)是机器学习(ML, Machine Learning)领域中一个新的研究方向，它被引入机器学习使其更接近于最初的目标——人工智能(AI, Artificial Intelligence)。深度学习是学习样本数据的内在规律和表示层次，这些学习过程中获得的信息对诸如文字，图像和声音等数据的解释有很大的帮助。它的最终目标是让机器能够像人一样具有分析学习能力，能够识别文字、图像和声音等数据。 深度学习是一个复杂的机器学习算法，在语音和图像识别方面取得的效果，远远超过先前相关技术。深度学习在搜索技术，数据挖掘，机器学习，机器翻译，自然语言处理，多媒体学习，语音，推荐和个性化技术，以及其他相关领域都取得了很多成果。深度学习使机器模仿视听和思考等人类的活动，解决了很多复杂的模式识别难题，使得人工智能相关技术取得了很大进步。"}, "means": [["人工神经网络的研究的概念", "深度学习/3729729"], ["Ian Goodfellow 等所著书籍", "深度学习/22059753"], ["Monica R.Martinez等所著书籍", "深度学习/23731499"], ["科学出版社2019年出版书籍", "深度学习/24204682"]], "attrs": {"中文名": "深度学习", "外文名": "DeepLearning", "提出者": "GeoffreyHinton，YoshuaBengio，YannLeCun等", "提出时间": "2006年", "学科": "人工智能", "应用": "计算机视觉，自然语言处理，生物信息学等"}, "tags": ["科学百科信息科学分类", "科技术语", "科学"]}, "type": "multiple"}
{"info": {"word": "知识图谱", "basic": {"title": "知识图谱", "description": "知识图谱（Knowledge Graph），在图书情报界称为知识域可视化或知识领域映射地图，是显示知识发展进程与结构关系的一系列各种不同的图形，用可视化技术描述知识资源及其载体，挖掘、分析、构建、绘制和显示知识及它们之间的相互联系。知识图谱是通过将应用数学、图形学、信息可视化技术、信息科学等学科的理论与方法与计量学引文分析、共现分析等方法结合，并利用可视化的图谱形象地展示学科的核心结构、发展历史、前沿领域以及整体知识架构达到多学科融合目的的现代理论。它能为学科研究提供切实的、有价值的参考。"}, "attrs": {"中文名": "知识图谱", "外文名": "KnowledgeGraph/Vault", "也称": "科学知识图谱", "应用": "理论与方法与计量学引文分析"}, "tags": ["书籍"]}, "type": "signal"}
{"type": "none"}
{"info": {"word": "网络爬虫", "basic": {"title": "网络爬虫", "sub_title": "", "description": "网络爬虫（又称为网页蜘蛛，网络机器人，在FOAF社区中间，更经常的称为网页追逐者），是一种按照一定的规则，自动地抓取万维网信息的程序或者脚本。另外一些不常使用的名字还有蚂蚁、自动索引、模拟程序或者蠕虫。"}, "means": [["自动获取网页内容的程序", "网络爬虫/5162711?fromtitle=爬虫&fromid=22046949"], ["汉语词语", "爬虫/5021046"]], "attrs": {"中文名": "网络爬虫", "外文名": "webcrawler", "别称": "网络蜘蛛", "目的": "按要求获取万维网信息"}, "tags": ["科学百科信息科学分类", "软件", "科技产品", "科学"]}, "type": "multiple"}
{"info": {"word": "人工智能", "basic": {"title": "人工智能", "sub_title": "（计算机科学的一个分支）", "description": "人工智能（Artificial Intelligence），英文缩写为AI。它是研究、开发用于模拟、延伸和扩展人的智能的理论、方法、技术及应用系统的一门新的技术科学。人工智能是计算机科学的一个分支，它企图了解智能的实质，并生产出一种新的能以人类智能相似的方式做出反应的智能机器，该领域的研究包括机器人、语言识别、图像识别、自然语言处理和专家系统等。人工智能从诞生以来，理论和技术日益成熟，应用领域也不断扩大，可以设想，未来人工智能带来的科技产品，将会是人类智慧的“容器”。人工智能可以对人的意识、思维的信息过程的模拟。人工智能不是人的智能，但能像人那样思考、也可能超过人的智能。人工智能是一门极富挑战性的科学，从事这项工作的人必须懂得计算机知识，心理学和哲学。人工智能是包括十分广泛的科学，它由不同的领域组成，如机器学习，计算机视觉等等，总的说来，人工智能研究的一个主要目标是使机器能够胜任一些通常需要人类智能才能完成的复杂工作。但不同的时代、不同的人对这种“复杂工作”的理解是不同的。2017年12月，人工智能入选“2017年度中国媒体十大流行语”。"}, "means": [["计算机科学的一个分支", "人工智能/9180"], ["2003年武汉理工大学版社出版图书", "人工智能/20487382"], ["美国2001年史蒂文·斯皮尔伯格执导电影", "人工智能/3751704"], ["（美）卢格尔所著书籍", "人工智能/20411662"], ["李开复和王咏刚写作书籍", "人工智能/20780710"], ["2007年耐格纳威斯基编写图书", "人工智能/20415442"], ["2003年尼尔森所著书籍", "人工智能/20413756"], ["2016年电视剧", "人工智能/19650695"], ["2016年郑小岳执导电影", "人工智能/19849982"], ["刘雪婧演唱的歌曲", "人工智能/22144453"], ["陈奕迅演唱歌曲", "人工智能/5754279"], ["2008年哈里·亨德森所著书籍", "人工智能/20417773"], ["韦康博所著书籍", "人工智能/20784731"], ["中国人民大学出版社出版书籍", "人工智能/22303816"], ["尚文倩编著书籍", "人工智能/22350315"], ["2018年央视春晚小品", "人工智能/22389498"], ["周晓垣所著书籍", "人工智能/22600836"], ["2018年学生用书", "人工智能/23266808"], ["人民邮电出版社2018年10月出版图书（第2版）", "人工智能/23289389"]], "attrs": {"中文名": "人工智能", "外文名": "ARTIFICIALINTELLIGENCE", "简称": "AI", "提出时间": "1956年", "提出地点": "DARTMOUTH学会", "名称来源": "雨果·德·加里斯的著作"}, "tags": ["中国通信学会", "学科"]}, "type": "multiple"}
{"info": {"word": "曹操", "basic": {"title": "曹操", "sub_title": "（东汉末年历史人物）", "description": "曹操（155年－220年3月15日），本名吉利，字孟德，小名阿瞒，谥号武皇帝（魏武帝），沛国谯县（今安徽亳州）人。东汉末年杰出的政治家、军事家、文学家、书法家，曹魏政权的奠基人。东汉末年，天下大乱，曹操以汉朝天子刘协的名义征讨四方，对内消灭二袁、吕布、刘表、马超、韩遂等割据势力，对外降服南匈奴、乌桓、鲜卑等，统一了中国北方，并实行一系列政策恢复经济生产和社会秩序，扩大屯田、兴修水利、奖励农桑、重视手工业、安置流亡人口、实行“租调制”，从而使中原社会渐趋稳定、经济出现转机。建安十八年（213年），曹操获封魏公，建立魏公国，定都河北邺城，而后进爵魏王。去世后，其子曹丕称帝，追尊曹操为武皇帝，庙号太祖。曹操喜欢用诗歌、散文来抒发自己政治抱负，反映民生疾苦，是魏晋文学的代表人物，鲁迅赞之为“改造文章的祖师”。同时曹操擅长书法，唐朝张怀瓘《书断》将曹操的章草评为“妙品”。"}, "means": [["东汉末年历史人物", "曹操/6772"], ["[日] 堀敏一所著历史书籍", "《曹操》/23245607"], ["林俊杰音乐专辑", "曹操/10749527"], ["手游《百将行》游戏角色", "曹操/20178005"], ["手机游戏《Q卡三国》中的人物", "曹操/15917009"], ["1999年电视剧", "曹操/1117711"], ["2018年张黎执导电视剧", "曹操/20481440"], ["《梦三国》游戏人物角色", "曹操/13868137"], ["陈舜臣所著的历史小说", "曹操/18785489"], ["美国演员", "曹操/1205242"], ["游戏《炎黄战纪》卡牌", "曹操/20459910"], ["2013年胡玫指导历史剧", "曹操/13832016"], ["伊沙所著的历史小说", "曹操/19409096"], ["桌游《英雄杀》角色", "曹操/2364108"], ["林俊杰演唱歌曲", "曹操/10748725"], ["《阵面对决》中的卡牌", "曹操/20121613"], ["TCG桌游《乱战》卡片名", "曹操/16326570"], ["《虽远必诛》手游武将", "曹操/19527092"], ["桌游《三国杀》武将牌", "曹操/10748739"], ["《真三国无双》人物", "曹操/16522702"], ["明末义军首领罗汝才的绰号", "曹操/18762008"], ["漫画《苍天航路》角色", "曹操/15279108"], ["手游《王者荣耀》中的英雄角色", "曹操/19479693"], ["MOBA手游《英魂之刃口袋版》的一名法师英雄", "曹操/20451845"], ["我的美女老师中人物", "曹操/18803583"], ["动漫《恶魔高校D×D》角色", "曹操/15928756"], ["游戏《英雄三国》角色", "曹操/16191846"], ["手游《率土之滨》角色", "曹操/22312067"], ["腾讯代理网游《英魂之刃》远程智力型英雄", "曹操/24131566"], ["漫画《火凤燎原》及其衍生作品角色", "曹操/24177677"], ["《小米超神》的法师类英雄", "曹操/24186154"]], "attrs": {"本名": "曹操", "别称": "一名吉利", "字号": "字孟德小字阿瞒", "所处时代": "东汉末年", "民族族群": "汉族", "出生地": "沛国谯县（今安徽亳州）", "出生时间": "155年", "去世时间": "220年3月15日", "主要作品": "《观沧海》《龟虽寿》《让县自明本志令》《蒿里行》《孟德新书》", "主要成就": "开创建安文学，提倡薄葬", "官职": "丞相", "爵位": "魏王（去世前）", "谥号": "武皇帝", "庙号": "太祖", "陵墓": "高陵"}, "tags": ["诗人"]}, "type": "multiple"}
```

其中`type`表示页面情况，有`none`,`signal`,`ambiguous`,`multiple`四种情况，分别表示无此条目，为单义条目，歧义条目，多义条目，具体信息可自行试验查看。

#### 批量爬取百科条目站内链接

使用示例：

```python
from lightspider.baike import href
from lightspider import Spider


tasks = ['曹操', '曹操字孟德']

spider = Spider(base_url=href.base_url, save_format=href.save_format, save_path=r'D:\Data\NLP\corpus\baike_href')

if __name__ == '__main__':
    spider.run(tasks, href.parser)
```

执行结果：

```bash
[2020-01-10 16:36:56] [WARNING] [MainThread] [spider.py:22] 指定目录不存在！将创建存储目录D:\Data\NLP\corpus\baike_href
[2020-01-10 16:36:56] [INFO] [MainThread] [spider.py:42] 已处理0条数据，还需处理2条数据
[2020-01-10 16:36:56] [INFO] [MainThread] [spider.py:55] 开始爬取，当前时间为：2020-01-10 16:36:56
[2020-01-10 16:36:57] [INFO] [MainThread] [writer.py:10] 写入地址为：D:\Data\NLP\corpus\baike_href/result.json， 临时文件地址为：D:\Data\NLP\corpus\baike_href/handled.txt
100%|██████████| 2/2 [00:01<00:00,  1.25it/s]
[2020-01-10 16:36:59] [INFO] [MainThread] [spider.py:72] 执行结束, 当前时间为：2020-01-10 16:36:59
[2020-01-10 16:36:59] [INFO] [MainThread] [spider.py:75] 本次共计耗时2.69s，共爬取数据条数为2，平均速度为：0.74(task/s)
```

爬取内容示例：

```bash
{"title": null, "links": []}
{"title": "曹操/6772", "links": ["《曹操》/23245607", "曹操/10749527", "曹操/20178005", "曹操/15917009", "曹操/1117711", "曹操/20481440", "曹操/13868137", "曹操/18785489", "曹操/1205242", "曹操/20459910", "曹操/13832016", "曹操/19409096", "曹操/2364108", "曹操/10748725", "曹操/20121613", "曹操/16326570", "曹操/19527092", "曹操/10748739", "曹操/16522702", "曹操/18762008", "曹操/15279108", "曹操/19479693", "曹操/20451845", "曹操/18803583", "曹操/15928756", "曹操/16191846", "曹操/22312067", "曹操/24131566", "曹操/24177677", "曹操/24186154", "沛国/15817292", "谯县/1767866", "安徽/37014", "亳州/146796", "东汉", "政治家/1209571", "军事家/824850", "文学家/1211248", "书法家/1242244", "曹魏/4475", "东汉末年", "刘协/18268", "二袁", "吕布/9592", "刘表/35154", "马超/1201", "韩遂/1176067", "南匈奴", "乌桓", "鲜卑", "租调制/4164328", "曹丕/5980", "鲁迅/36231", "张怀瓘/6184559", "书断/6740024", "观沧海/1907220", "龟虽寿/2356846", "让县自明本志令/890268", "蒿里行/2356432", "孟德新书/1056935", "屯田制", "建安", "薄葬", "高陵/11042894", "三国志/1057", "曹参", "曹嵩/879853", "曹腾", "养子", "汉桓帝", "汉灵帝/627355", "放荡不羁/2719992", "梁国", "何颙", "许劭", "博览群书/1190", "兵法/1025158", "韬略/7389819", "孙子兵法", "孝廉", "洛阳/125712", "衙门/844061", "蹇硕", "蹇图", "蹇图/2058145", "五色棒", "权贵/1615284", "曹嵩/879853", "明升暗降/6855153", "宋奇", "谯县", "议郎", "窦武", "太傅", "陈蕃", "汉灵帝", "腐败/8783703", "黄巾起义", "骑都尉", "皇甫嵩", "颍川", "济南/135066", "济南/18596216", "议郎", "冀州", "王芬", "许攸", "周旌", "合肥侯", "金城郡", "兰州/170826", "边章", "韩遂", "刘辩", "何进", "董卓", "弘农王", "汉献帝", "太师", "董卓/17359", "陈留", "袁术/16976", "袁绍", "凉州/2793283", "酸枣", "延津", "荥阳", "曹洪/19052", "武关", "陕西/193811", "东郡", "袁绍", "黄巾军", "兖州", "昌邑/5717700", "巨野", "刘岱", "鲍信", "兖州牧", "青州兵", "袁术/16976", "陶谦", "曹嵩/879853", "郯县", "陈宫/17375", "张邈", "张超/4769801", "许汜", "吕布", "王允", "鄄城", "东郡", "范县", "东阿", "阳谷", "荀彧", "程昱", "夏侯惇", "徐州", "濮阳", "袁绍/16975", "邺县/6653194", "程昱/64979", "兴平", "吕布/9592", "定陶", "廪丘", "郓城", "刘备", "李傕/24491", "郭汜", "汉献帝/17140", "建安/8722", "汉献帝/17140", "司隶校尉", "录尚书事", "迁都", "司空", "车骑将军", "张绣", "曹昂", "曹安民", "典韦/6606", "袁术", "裴茂", "段煨", "夷三族", "曹军", "魏续", "宋宪", "陈宫/17375", "高顺", "张辽", "臧霸", "孙观", "徐州/6250", "黄河/5394", "袁绍/16975", "青州", "臧霸", "临淄", "北海", "寿光", "于禁", "袁军", "贾诩", "扬武将军", "官渡", "中牟", "刘备/30564", "陶谦", "徐州牧/11030922", "吕布", "刘备/30564", "豫州牧", "左将军", "董承", "车胄", "袁绍", "袁安", "袁谭", "袁熙", "高干", "颜良", "滑县/1206114", "黎阳", "浚县", "地盘", "四战之地", "裴松之", "白马之围", "荀攸", "延津", "关羽/17338", "文丑/5432", "骑兵", "官渡/81736", "土山", "淳于琼", "乌巢", "许攸", "官渡之战", "袁谭", "袁尚", "邺城", "邯郸/334665", "临漳", "滏阳河", "定县", "许县", "幽州", "乌桓", "蹋顿", "无终", "蓟县", "田畴", "徐无山", "玉田", "卢龙塞", "喜峰口", "柳城", "张辽/6764", "张辽/6764", "白狼山之战/3643544", "平州", "公孙康", "易水", "普富卢", "郭嘉", "玄武池", "三公", "刘表", "刘琮", "新野", "官渡之战", "刘备", "樊城", "襄樊", "江陵", "当阳", "鲁肃/9396", "诸葛亮/21048", "周瑜", "赤壁", "武昌县", "乌林", "洪湖县", "黄盖", "华容道", "监利", "求贤令", "钟繇", "夏侯渊", "南郑", "马超", "韩遂", "杨秋", "贾诩/8870", "萧何", "濡须口", "巢县", "公孙阳", "禹贡", "魏公", "邺城/2934914", "魏王/80436", "曹丕/5980", "益州", "阳平关", "勉县", "巴中", "张鲁", "夏侯渊/17354", "曹彰/54249", "鲜卑", "汉水", "定军山", "黄忠", "坚壁", "扬州/8475769", "关羽", "于禁/17366", "庞德", "徐晃", "樊城", "孙权", "吕蒙", "江陵/4726", "摩陂", "郏县", "骠骑将军", "邺城", "高陵/11042894", "曹丕", "太祖", "法治", "王修", "司马芝", "杨沛", "吕虔", "贾逵", "仁义", "道德品质", "高贵", "崔琰", "毛玠", "唯才是举", "黄巾起义", "东汉", "李傕", "曹魏/4475", "孙子略解/9685133", "李靖", "通典", "屯田", "屯田", "自耕农经济", "户调制", "北宋仁宗", "白狼山之战/3643544", "薄葬/3680109", "陈寿/5816", "三国志/1057", "运筹演谋/1464761", "王沈/8040", "魏书/8433", "李瓒/6132703", "鲍信", "张辽/6764", "威信/79719", "凉茂", "孙权/17337", "骨肉", "孙楚/23893", "陆机", "潘安/2695", "刘渊/9234", "王导", "裴松之", "垣荣祖", "钟嵘", "李世民/44058", "王勃/248912", "魏元忠", "朱敬则", "赵蕤", "张说/66379", "张鼎/84103", "穆修", "司马光/220370", "何去非/62368", "苏洵", "王安石/127359", "洪皓", "钟惺", "张溥/33423", "三国志通俗演义", "陈祚明", "黄摩西", "鲁迅/36231", "毛泽东/113835", "范文澜", "谭其骧/3560009", "钱穆/119716", "黄仁宇/865271", "孙子略解", "孟德新书", "乐府诗", "薤露行", "蒿里行", "苦寒行", "步出夏门行", "何进", "诗史", "苦寒行", "步出夏门行", "观沧海/1907220", "冬十月", "龟虽寿", "度关山", "对酒", "短歌行", "短歌行/5570", "山不厌高", "周公吐哺", "建安文学/815180", "挽歌", "建安七子", "刘勰", "蔡琰", "邺下文人集团", "姚振宗", "三国艺文志", "魏武帝集", "兵书", "张溥", "汉魏六朝百三家集", "丁福保", "中华书局", "曹操集", "短歌行", "观沧海", "龟虽寿", "度关山", "对酒/27457", "董逃歌词", "蒿里行", "苦寒行", "气出唱", "谣俗词", "精列", "塘上行", "却东西门行", "秋胡行/8979", "述志令", "陌上桑", "薤露行", "善哉行/3888134", "善哉行/3888134", "沧海赋", "求贤令", "终令", "博物志/84837", "庾肩吾/2266079", "书品/1842330", "书断/6740024", "梁鹄/6354285", "邯郸淳/1315480", "韦诞/4184655", "孙子荆/3868902", "大飨碑/9987583", "叶奕苞/3815522", "金石录/9683122", "曹操地下运兵道/9042284", "隶书/835864", "曹腾/7397930", "对食", "曹嵩", "丁夫人/6776", "卞夫人", "武宣卞皇后", "刘夫人/9659436", "环夫人/10836452", "杜夫人/6439780", "秦夫人/5225147", "尹夫人/15411062", "王昭仪/78480", "陈姬/19925729", "周姬/18692574", "宋姬/225840", "赵姬/2864459", "张济/22316", "邹夫人/18168", "曹丕/5980", "曹彰/54249", "曹植/17364", "曹熊/1175957", "曹昂/714793", "曹铄/4100571", "曹冲/629", "曹据/7297146", "曹宇/9384", "曹林/19168", "曹衮/1561264", "曹玹/4100676", "曹峻/52058", "曹矩/4100768", "曹干/7108675", "曹上/3998341", "曹彪/4303929", "曹勤/37473", "曹乘/3998408", "曹整/4304082", "曹京/4304067", "曹均/4304050", "曹棘/4304002", "曹徽/4303985", "曹茂/4303954", "清河长公主/6845285", "夏侯楙/4295670", "曹宪/32991", "曹节/10748882", "曹华/4128515", "安阳公主/29249", "荀恽/4798307", "金乡公主/29099", "何晏/943680", "何晏/943680", "何进/4593", "秦朗/6296", "曹真/715510", "夏侯氏", "宗亲", "曹仁", "曹褒/3969955", "曹炽/9050663", "曹洪", "曹纯/1980343", "曹休/833559", "族子", "夏侯惇", "夏侯渊", "妙才", "从弟", "夏侯尚", "曹霸", "杜甫", "高向玄理", "曹操墓", "袁绍/16975", "青庐/9816943", "秦宜禄/1325150", "杜夫人/6439780", "秦朗/6296", "关羽/17338", "杜夫人/6439780", "关羽/17338", "杜夫人/6439780", "秦朗/6296", "张让/66433", "文昭甄皇后", "袁熙/16995", "蔡邕", "蔡文姬/6785", "董祀", "饮马长江", "苏东坡", "前赤壁赋", "酾酒", "临江", "曹娥/4231775", "杨修/8088", "黄绢", "五辛", "这说", "杖责", "神通术与小霸王", "白彪/3179", "华佗与曹操/65607", "王洪生/20805409", "诸葛亮/4201194", "关公/16176656", "胡庆士", "三国演义/7088688", "鲍国安", "东方小故事", "望梅止渴/1448", "三国英雄传之关公", "龙隆", "诸葛亮/4290772", "柯俊雄", "一代枭雄曹操", "柯俊雄", "医神华佗", "黄日华", "曹操/1117711", "姚橹", "吕布与貂蝉", "聂远", "邵峰", "洛神", "刘丹/6326308", "曹操与蔡文姬", "濮存昕", "武圣关公/9699", "张永刚/17227", "三国之见龙卸甲", "刘松仁", "赤壁", "张丰毅", "赤壁下", "张丰毅", "三国", "陈建斌", "关云长", "姜文", "越光宝盒", "郭德纲", "钟繇/2946888", "吴广林", "回到三国/5423390", "罗乐林", "铜雀台", "周润发", "曹操/13832016", "赵立新", "新洛神", "李进荣", "半为苍生半美人/14083329", "王建新/3043537", "大军师司马懿之军师联盟/20818349", "于和伟", "三国机密/20224332", "谢君豪", "三国之战神无双/22595695", "连奕名/571280", "真三国无双/19455923"]}
```

**注意**：上述结果未去重，可以作为PageRank算法的数据源；为了压缩文件大小，这里的每一个链接都没有保留，默认前缀都是`https://baike.baidu.com/item/`。


#### 批量爬取百科搜索结果

使用示例：

```python
from lightspider.baike import search
from lightspider import Spider


tasks = ['曹操', '曹操字孟德']

spider = Spider(base_url=search.base_url, save_format=search.save_format, save_path=r'D:\Data\NLP\corpus\baike_search')

if __name__ == '__main__':
    spider.run(tasks, search.parser)
```

执行结果：

```bash
[2020-01-10 16:42:09] [WARNING] [MainThread] [spider.py:22] 指定目录不存在！将创建存储目录D:\Data\NLP\corpus\baike_search
[2020-01-10 16:42:09] [INFO] [MainThread] [spider.py:42] 已处理0条数据，还需处理2条数据
[2020-01-10 16:42:09] [INFO] [MainThread] [spider.py:55] 开始爬取，当前时间为：2020-01-10 16:42:09
[2020-01-10 16:42:10] [INFO] [MainThread] [writer.py:10] 写入地址为：D:\Data\NLP\corpus\baike_search/result.json， 临时文件地址为：D:\Data\NLP\corpus\baike_search/handled.txt
100%|██████████| 2/2 [00:01<00:00,  1.14it/s]
[2020-01-10 16:42:12] [INFO] [MainThread] [spider.py:72] 执行结束, 当前时间为：2020-01-10 16:42:12
[2020-01-10 16:42:12] [INFO] [MainThread] [spider.py:75] 本次共计耗时2.74s，共爬取数据条数为2，平均速度为：0.73(task/s)
```

爬取内容示例：

```bash
{"search_word": "曹操字孟德", "result": [{"title": "字孟德_百度百科", "url": "字孟德/6942839", "description": "曹操,字孟德,小字阿瞒,一名吉利,汉族,沛国谯(今安徽亳州)人。中国东汉末年著名的军事家、政治家和诗人,三国时代魏国的奠基人和主要缔造者,后为魏王。...", "result_date": "2019-11-29"}, {"title": "曹操:一世之雄_百度百科", "url": "曹操：一世之雄/2642729", "description": "《曹操:一世之雄》是中州古籍出版社出版的图书,作者是张亚新。 本书从客观的...曹操:一世之雄内容简介 编辑 曹操,字孟德,小字阿瞒,汉族,沛国谯(今安徽亳州)...", "result_date": "2019-12-1"}, {"title": "曹操贡酒_百度百科", "url": "曹操贡酒/12724993", "description": "曹操贡酒之所以被人们誉为“中华白酒第一贡品”,最主要的原因是三国英雄曹操创造了中华白酒第一贡品--曹操贡酒。曹操,字孟德,是我国杰出的军事家、政治家、文学家...", "result_date": "2019-11-30"}, {"title": "曹操全传_百度百科", "url": "曹操全传/1390582", "description": "曹操,字孟德,公元155年生,沛国谯县(安徽亳县)人。父亲曹嵩本姓夏侯,因为成为曹腾养子而改姓并继承侯爵。曹操一生从陈留起兵到洛阳逝世,奋战30余年,参加大小战役...", "result_date": "2019-11-26"}, {"title": "千古枭雄之曹操_百度百科", "url": "千古枭雄之曹操", "description": "曹操,字孟德,是东汉末年著名的政治家、军事家、诗人。他本为东汉丞相,后为魏王,其子曹丕称帝后,追尊他为魏武帝。曹操一生以汉朝丞相的名义征讨四方,为统一中原...", "result_date": "2019-11-27"}, {"title": "曹操吧_百度百科", "url": "曹操吧/3331071", "description": "曹操吧是百度曹操迷的大本营,这里曹操迷可以讨论关于曹操的文学,历史等等知识,并...第十一任吧主: 征东大将军张辽(马甲:曹操字孟德)(丙戌年 庚寅月上任)...", "result_date": "2019-12-3"}, {"title": "曹询_百度百科", "url": "曹询/10644813", "description": "曹嵩·字巨高⊕ 曹操·字孟德 曹昂·字子脩 无子  曹琬  曹丕·字子桓 曹叡·字元仲 曹冏 曹穆 曹殷 曹芳曹询曹奂 [1]  曹霖 曹髦·字彦士 曹植字子建...", "result_date": "2019-11-24"}, {"title": "曹氏三祖_百度百科", "url": "曹氏三祖/7403605", "description": "曹操像 曹操,字孟德,小字阿瞒,汉族,沛国谯县(今安徽亳州)人。中国东汉末年著名的军事家、政治家和诗人,三国时代魏国的奠基人和主要缔造者,后为魏王。其子曹丕...", "result_date": "2019-12-26"}]}
{"search_word": "曹操", "result": [{"title": "曹操(东汉末年历史人物)_百度百科", "url": "曹操/6772", "description": "曹操(155年-220年3月15日),本名吉利,字孟德,小名阿瞒,谥号武皇帝(魏武帝),沛国谯县(今安徽亳州)人。东汉末年杰出的政治家、军事家、文学家、书法家,曹魏...", "result_date": "2020-1-3"}, {"title": "曹操(林俊杰音乐专辑)_百度百科", "url": "曹操/10749527", "description": "《曹操》是林俊杰2006年发行的专辑。作词者包括林秋离、林俊杰等人,作曲由林俊杰一人完成,全专辑共11首歌曲(内地版为10首歌曲,马来西亚版为12首歌曲)。2006年凭借该...", "result_date": "2019-11-25"}, {"title": "曹操(美国演员)_百度百科", "url": "曹操/1205242", "description": "曹操,出生于美国,毕业于纽约大学电影学院,演员。代表作品有《爱的保镖》、《跨国阴谋》等。...", "result_date": "2019-12-14"}, {"title": "曹操(1999年电视剧)_百度百科", "url": "曹操/1117711", "description": "东汉末年,腐朽没落的东汉王朝分崩离折,外戚宦官当道,军阀混乱,天下大乱,人民流离失所。社会生产力遭到极大破坏,作为非常之人,超世之杰的曹操,怀抱救国之志,除...", "result_date": "2019-11-25"}, {"title": "曹操(手游《王者荣耀》中的英雄角色)_百度百科", "url": "曹操/19479693", "description": "曹操是手游《王者荣耀》中的一位无蓝战士型英雄角色。曹操是手游中操作难度极高的英雄。团战中可以前排抗伤、保护射手或切敌方输出,是游戏中强大的英雄。曹操是一...", "result_date": "2019-12-14"}, {"title": "曹操(2013年胡玫指导历史剧)_百度百科", "url": "曹操/13832016", "description": "《曹操》是由电广传媒文化发展有限公司出品,胡玫执导的历史古装正剧,由赵立新、孙洪涛、龚洁、张玉洁、韩雪、古巨基等主演。该剧主要讲述了东汉末年曹操一统北方、创建...", "result_date": "2019-12-6"}, {"title": "曹操(《真三国无双》人物)_百度百科", "url": "曹操/16522702", "description": "曹操,日本光荣出品游戏《真三国无双》系列曹魏势力重要角色。苍紫的霸道。之后的魏王,人称“乱世的奸雄”。长于判断与决断,参加黄巾讨伐军后展现头角。在陷入战乱的...", "result_date": "2019-11-29"}, {"title": "《曹操》([日] 堀敏一所著历史书籍)_百度百科", "url": "《曹操》/23245607", "description": "《曹操》 是一部由 [日] 堀敏一所著历史书籍,北京联合出版公司出版发行。...... 《曹操》 是一部由 [日] 堀敏一所著历史书籍,北京联合出版公司出版发行。...", "result_date": "2019-12-7"}, {"title": "曹操墓_百度百科", "url": "曹操墓/3652496", "description": "曹操墓即安阳高陵,位于河南省安阳市安丰乡西高穴村,在曹操王都邺北城西12公里处。据《三国志》等史料记载,220年曹操卒于洛阳,灵柩葬在邺城的西门豹祠以西丘陵...", "result_date": "2019-12-27"}, {"title": "曹操(2018年张黎执导电视剧)_百度百科", "url": "曹操/20481440", "description": "《曹操》是由张黎执导,姜文领衔主演古装历史剧。该剧以曹操的一生为主线,讲述了曹操戎马倥偬,功过是非的传奇故事。暂定在2018年9月开机。...", "result_date": "2019-12-26"}]}
```

#### 单项查询条目基本信息、链接信息、搜索结果

使用示例：

```python
from lightspider.baike import href
from lightspider.baike import info
from lightspider.baike import search

if __name__ == '__main__':
    word = '曹操'
    href_result = href.query(word)
    info_result = info.query(word)
    search_result = search.query(word)
    print(href_result)
    print(info_result)
    print(search_result)
```

执行结果：

```bash
{'title': '曹操/6772', 'links': ['《曹操》/23245607', '曹操/10749527', '曹操/20178005', '曹操/15917009', '曹操/1117711', '曹操/20481440', '曹操/13868137', '曹操/18785489', '曹操/1205242', '曹操/20459910', '曹操/13832016', '曹操/19409096', '曹操/2364108', '曹操/10748725', '曹操/20121613', '曹操/16326570', '曹操/19527092', '曹操/10748739', '曹操/16522702', '曹操/18762008', '曹操/15279108', '曹操/19479693', '曹操/20451845', '曹操/18803583', '曹操/15928756', '曹操/16191846', '曹操/22312067', '曹操/24131566', '曹操/24177677', '曹操/24186154', '沛国/15817292', '谯县/1767866', '安徽/37014', '亳州/146796', '东汉', '政治家/1209571', '军事家/824850', '文学家/1211248', '书法家/1242244', '曹魏/4475', '东汉末年', '刘协/18268', '二袁', '吕布/9592', '刘表/35154', '马超/1201', '韩遂/1176067', '南匈奴', '乌桓', '鲜卑', '租调制/4164328', '曹丕/5980', '鲁迅/36231', '张怀瓘/6184559', '书断/6740024', '观沧海/1907220', '龟虽寿/2356846', '让县自明本志令/890268', '蒿里行/2356432', '孟德新书/1056935', '屯田制', '建安', '薄葬', '高陵/11042894', '三国志/1057', '曹参', '曹嵩/879853', '曹腾', '养子', '汉桓帝', '汉灵帝/627355', '放荡不羁/2719992', '梁国', '何颙', '许劭', '博览群书/1190', '兵法/1025158', '韬略/7389819', '孙子兵法', '孝廉', '洛阳/125712', '衙门/844061', '蹇硕', '蹇图', '蹇图/2058145', '五色棒', '权贵/1615284', '曹嵩/879853', '明升暗降/6855153', '宋奇', '谯县', '议郎', '窦武', '太傅', '陈蕃', '汉灵帝', '腐败/8783703', '黄巾起义', '骑都尉', '皇甫嵩', '颍川', '济南/135066', '济南/18596216', '议郎', '冀州', '王芬', '许攸', '周旌', '合肥侯', '金城郡', '兰州/170826', '边章', '韩遂', '刘辩', '何进', '董卓', '弘农王', '汉献帝', '太师', '董卓/17359', '陈留', '袁术/16976', '袁绍', '凉州/2793283', '酸枣', '延津', '荥阳', '曹洪/19052', '武关', '陕西/193811', '东郡', '袁绍', '黄巾军', '兖州', '昌邑/5717700', '巨野', '刘岱', '鲍信', '兖州牧', '青州兵', '袁术/16976', '陶谦', '曹嵩/879853', '郯县', '陈宫/17375', '张邈', '张超/4769801', '许汜', '吕布', '王允', '鄄城', '东郡', '范县', '东阿', '阳谷', '荀彧', '程昱', '夏侯惇', '徐州', '濮阳', '袁绍/16975', '邺县/6653194', '程昱/64979', '兴平', '吕布/9592', '定陶', '廪丘', '郓城', '刘备', '李傕/24491', '郭汜', '汉献帝/17140', '建安/8722', '汉献帝/17140', '司隶校尉', '录尚书事', '迁都', '司空', '车骑将军', '张绣', '曹昂', '曹安民', '典韦/6606', '袁术', '裴茂', '段煨', '夷三族', '曹军', '魏续', '宋宪', '陈宫/17375', '高顺', '张辽', '臧霸', '孙观', '徐州/6250', '黄河/5394', '袁绍/16975', '青州', '臧霸', '临淄', '北海', '寿光', '于禁', '袁军', '贾诩', '扬武将军', '官渡', '中牟', '刘备/30564', '陶谦', '徐州牧/11030922', '吕布', '刘备/30564', '豫州牧', '左将军', '董承', '车胄', '袁绍', '袁安', '袁谭', '袁熙', '高干', '颜良', '滑县/1206114', '黎阳', '浚县', '地盘', '四战之地', '裴松之', '白马之围', '荀攸', '延津', '关羽/17338', '文丑/5432', '骑兵', '官渡/81736', '土山', '淳于琼', '乌巢', '许攸', '官渡之战', '袁谭', '袁尚', '邺城', '邯郸/334665', '临漳', '滏阳河', '定县', '许县', '幽州', '乌桓', '蹋顿', '无终', '蓟县', '田畴', '徐无山', '玉田', '卢龙塞', '喜峰口', '柳城', '张辽/6764', '张辽/6764', '白狼山之战/3643544', '平州', '公孙康', '易水', '普富卢', '郭嘉', '玄武池', '三公', '刘表', '刘琮', '新野', '官渡之战', '刘备', '樊城', '襄樊', '江陵', '当阳', '鲁肃/9396', '诸葛亮/21048', '周瑜', '赤壁', '武昌县', '乌林', '洪湖县', '黄盖', '华容道', '监利', '求贤令', '钟繇', '夏侯渊', '南郑', '马超', '韩遂', '杨秋', '贾诩/8870', '萧何', '濡须口', '巢县', '公孙阳', '禹贡', '魏公', '邺城/2934914', '魏王/80436', '曹丕/5980', '益州', '阳平关', '勉县', '巴中', '张鲁', '夏侯渊/17354', '曹彰/54249', '鲜卑', '汉水', '定军山', '黄忠', '坚壁', '扬州/8475769', '关羽', '于禁/17366', '庞德', '徐晃', '樊城', '孙权', '吕蒙', '江陵/4726', '摩陂', '郏县', '骠骑将军', '邺城', '高陵/11042894', '曹丕', '太祖', '法治', '王修', '司马芝', '杨沛', '吕虔', '贾逵', '仁义', '道德品质', '高贵', '崔琰', '毛玠', '唯才是举', '黄巾起义', '东汉', '李傕', '曹魏/4475', '孙子略解/9685133', '李靖', '通典', '屯田', '屯田', '自耕农经济', '户调制', '北宋仁宗', '白狼山之战/3643544', '薄葬/3680109', '陈寿/5816', '三国志/1057', '运筹演谋/1464761', '王沈/8040', '魏书/8433', '李瓒/6132703', '鲍信', '张辽/6764', '威信/79719', '凉茂', '孙权/17337', '骨肉', '孙楚/23893', '陆机', '潘安/2695', '刘渊/9234', '王导', '裴松之', '垣荣祖', '钟嵘', '李世民/44058', '王勃/248912', '魏元忠', '朱敬则', '赵蕤', '张说/66379', '张鼎/84103', '穆修', '司马光/220370', '何去非/62368', '苏洵', '王安石/127359', '洪皓', '钟惺', '张溥/33423', '三国志通俗演义', '陈祚明', '黄摩西', '鲁迅/36231', '毛泽东/113835', '范文澜', '谭其骧/3560009', '钱穆/119716', '黄仁宇/865271', '孙子略解', '孟德新书', '乐府诗', '薤露行', '蒿里行', '苦寒行', '步出夏门行', '何进', '诗史', '苦寒行', '步出夏门行', '观沧海/1907220', '冬十月', '龟虽寿', '度关山', '对酒', '短歌行', '短歌行/5570', '山不厌高', '周公吐哺', '建安文学/815180', '挽歌', '建安七子', '刘勰', '蔡琰', '邺下文人集团', '姚振宗', '三国艺文志', '魏武帝集', '兵书', '张溥', '汉魏六朝百三家集', '丁福保', '中华书局', '曹操集', '短歌行', '观沧海', '龟虽寿', '度关山', '对酒/27457', '董逃歌词', '蒿里行', '苦寒行', '气出唱', '谣俗词', '精列', '塘上行', '却东西门行', '秋胡行/8979', '述志令', '陌上桑', '薤露行', '善哉行/3888134', '善哉行/3888134', '沧海赋', '求贤令', '终令', '博物志/84837', '庾肩吾/2266079', '书品/1842330', '书断/6740024', '梁鹄/6354285', '邯郸淳/1315480', '韦诞/4184655', '孙子荆/3868902', '大飨碑/9987583', '叶奕苞/3815522', '金石录/9683122', '曹操地下运兵道/9042284', '隶书/835864', '曹腾/7397930', '对食', '曹嵩', '丁夫人/6776', '卞夫人', '武宣卞皇后', '刘夫人/9659436', '环夫人/10836452', '杜夫人/6439780', '秦夫人/5225147', '尹夫人/15411062', '王昭仪/78480', '陈姬/19925729', '周姬/18692574', '宋姬/225840', '赵姬/2864459', '张济/22316', '邹夫人/18168', '曹丕/5980', '曹彰/54249', '曹植/17364', '曹熊/1175957', '曹昂/714793', '曹铄/4100571', '曹冲/629', '曹据/7297146', '曹宇/9384', '曹林/19168', '曹衮/1561264', '曹玹/4100676', '曹峻/52058', '曹矩/4100768', '曹干/7108675', '曹上/3998341', '曹彪/4303929', '曹勤/37473', '曹乘/3998408', '曹整/4304082', '曹京/4304067', '曹均/4304050', '曹棘/4304002', '曹徽/4303985', '曹茂/4303954', '清河长公主/6845285', '夏侯楙/4295670', '曹宪/32991', '曹节/10748882', '曹华/4128515', '安阳公主/29249', '荀恽/4798307', '金乡公主/29099', '何晏/943680', '何晏/943680', '何进/4593', '秦朗/6296', '曹真/715510', '夏侯氏', '宗亲', '曹仁', '曹褒/3969955', '曹炽/9050663', '曹洪', '曹纯/1980343', '曹休/833559', '族子', '夏侯惇', '夏侯渊', '妙才', '从弟', '夏侯尚', '曹霸', '杜甫', '高向玄理', '曹操墓', '袁绍/16975', '青庐/9816943', '秦宜禄/1325150', '杜夫人/6439780', '秦朗/6296', '关羽/17338', '杜夫人/6439780', '关羽/17338', '杜夫人/6439780', '秦朗/6296', '张让/66433', '文昭甄皇后', '袁熙/16995', '蔡邕', '蔡文姬/6785', '董祀', '饮马长江', '苏东坡', '前赤壁赋', '酾酒', '临江', '曹娥/4231775', '杨修/8088', '黄绢', '五辛', '这说', '杖责', '神通术与小霸王', '白彪/3179', '华佗与曹操/65607', '王洪生/20805409', '诸葛亮/4201194', '关公/16176656', '胡庆士', '三国演义/7088688', '鲍国安', '东方小故事', '望梅止渴/1448', '三国英雄传之关公', '龙隆', '诸葛亮/4290772', '柯俊雄', '一代枭雄曹操', '柯俊雄', '医神华佗', '黄日华', '曹操/1117711', '姚橹', '吕布与貂蝉', '聂远', '邵峰', '洛神', '刘丹/6326308', '曹操与蔡文姬', '濮存昕', '武圣关公/9699', '张永刚/17227', '三国之见龙卸甲', '刘松仁', '赤壁', '张丰毅', '赤壁下', '张丰毅', '三国', '陈建斌', '关云长', '姜文', '越光宝盒', '郭德纲', '钟繇/2946888', '吴广林', '回到三国/5423390', '罗乐林', '铜雀台', '周润发', '曹操/13832016', '赵立新', '新洛神', '李进荣', '半为苍生半美人/14083329', '王建新/3043537', '大军师司马懿之军师联盟/20818349', '于和伟', '三国机密/20224332', '谢君豪', '三国之战神无双/22595695', '连奕名/571280', '真三国无双/19455923']}
{'info': {'word': '曹操', 'basic': {'title': '曹操', 'sub_title': '（东汉末年历史人物）', 'description': '曹操（155年－220年3月15日），本名吉利，字孟德，小名阿瞒，谥号武皇帝（魏武帝），沛国谯县（今安徽亳州）人。东汉末年杰出的政治家、军事家、文学家、书法家，曹魏政权的奠基人。东汉末年，天下大乱，曹操以汉朝天子刘协的名义征讨四方，对内消灭二袁、吕布、刘表、马超、韩遂等割据势力，对外降服南匈奴、乌桓、鲜卑等，统一了中国北方，并实行一系列政策恢复经济生产和社会秩序，扩大屯田、兴修水利、奖励农桑、重视手工业、安置流亡人口、实行“租调制”，从而使中原社会渐趋稳定、经济出现转机。建安十八年（213年），曹操获封魏公，建立魏公国，定都河北邺城，而后进爵魏王。去世后，其子曹丕称帝，追尊曹操为武皇帝，庙号太祖。曹操喜欢用诗歌、散文来抒发自己政治抱负，反映民生疾苦，是魏晋文学的代表人物，鲁迅赞之为“改造文章的祖师”。同时曹操擅长书法，唐朝张怀瓘《书断》将曹操的章草评为“妙品”。'}, 'means': [('东汉末年历史人物', '曹操/6772'), ('[日] 堀敏一所著历史书籍', '《曹操》/23245607'), ('林俊杰音乐专辑', '曹操/10749527'), ('手游《百将行》游戏角色', '曹操/20178005'), ('手机游戏《Q卡三国》中的人物', '曹操/15917009'), ('1999年电视剧', '曹操/1117711'), ('2018年张黎执导电视剧', '曹操/20481440'), ('《梦三国》游戏人物角色', '曹操/13868137'), ('陈舜臣所著的历史小说', '曹操/18785489'), ('美国演员', '曹操/1205242'), ('游戏《炎黄战纪》卡牌', '曹操/20459910'), ('2013年胡玫指导历史剧', '曹操/13832016'), ('伊沙所著的历史小说', '曹操/19409096'), ('桌游《英雄杀》角色', '曹操/2364108'), ('林俊杰演唱歌曲', '曹操/10748725'), ('《阵面对决》中的卡牌', '曹操/20121613'), ('TCG桌游《乱战》卡片名', '曹操/16326570'), ('《虽远必诛》手游武将', '曹操/19527092'), ('桌游《三国杀》武将牌', '曹操/10748739'), ('《真三国无双》人物', '曹操/16522702'), ('明末义军首领罗汝才的绰号', '曹操/18762008'), ('漫画《苍天航路》角色', '曹操/15279108'), ('手游《王者荣耀》中的英雄角色', '曹操/19479693'), ('MOBA手游《英魂之刃口袋版》的一名法师英雄', '曹操/20451845'), ('我的美女老师中人物', '曹操/18803583'), ('动漫《恶魔高校D×D》角色', '曹操/15928756'), ('游戏《英雄三国》角色', '曹操/16191846'), ('手游《率土之滨》角色', '曹操/22312067'), ('腾讯代理网游《英魂之刃》远程智力型英雄', '曹操/24131566'), ('漫画《火凤燎原》及其衍生作品角色', '曹操/24177677'), ('《小米超神》的法师类英雄', '曹操/24186154')], 'attrs': {'本名': '曹操', '别称': '一名吉利', '字号': '字孟德小字阿瞒', '所处时代': '东汉末年', '民族族群': '汉族', '出生地': '沛国谯县（今安徽亳州）', '出生时间': '155年', '去世时间': '220年3月15日', '主要作品': '《观沧海》《龟虽寿》《让县自明本志令》《蒿里行》《孟德新书》', '主要成就': '开创建安文学，提倡薄葬', '官职': '丞相', '爵位': '魏王（去世前）', '谥号': '武皇帝', '庙号': '太祖', '陵墓': '高陵'}, 'tags': ['诗人']}, 'type': 'multiple'}
{'search_word': '曹操', 'result': [{'title': '曹操(东汉末年历史人物)_百度百科', 'url': '曹操/6772', 'description': '曹操(155年-220年3月15日),本名吉利,字孟德,小名阿瞒,谥号武皇帝(魏武帝),沛国谯县(今安徽亳州)人。东汉末年杰出的政治家、军事家、文学家、书法家,曹魏...', 'result_date': '2020-1-3'}, {'title': '曹操(林俊杰音乐专辑)_百度百科', 'url': '曹操/10749527', 'description': '《曹操》是林俊杰2006年发行的专辑。作词者包括林秋离、林俊杰等人,作曲由林俊杰一人完成,全专辑共11首歌曲(内地版为10首歌曲,马来西亚版为12首歌曲)。2006年凭借该...', 'result_date': '2019-11-25'}, {'title': '曹操(美国演员)_百度百科', 'url': '曹操/1205242', 'description': '曹操,出生于美国,毕业于纽约大学电影学院,演员。代表作品有《爱的保镖》、《跨国阴谋》等。...', 'result_date': '2019-12-14'}, {'title': '曹操(1999年电视剧)_百度百科', 'url': '曹操/1117711', 'description': '东汉末年,腐朽没落的东汉王朝分崩离折,外戚宦官当道,军阀混乱,天下大乱,人民流离失所。社会生产力遭到极大破坏,作为非常之人,超世之杰的曹操,怀抱救国之志,除...', 'result_date': '2019-11-25'}, {'title': '曹操(手游《王者荣耀》中的英雄角色)_百度百科', 'url': '曹操/19479693', 'description': '曹操是手游《王者荣耀》中的一位无蓝战士型英雄角色。曹操是手游中操作难度极高的英雄。团战中可以前排抗伤、保护射手或切敌方输出,是游戏中强大的英雄。曹操是一...', 'result_date': '2019-12-14'}, {'title': '曹操(2013年胡玫指导历史剧)_百度百科', 'url': '曹操/13832016', 'description': '《曹操》是由电广传媒文化发展有限公司出品,胡玫执导的历史古装正剧,由赵立新、孙洪涛、龚洁、张玉洁、韩雪、古巨基等主演。该剧主要讲述了东汉末年曹操一统北方、创建...', 'result_date': '2019-12-6'}, {'title': '曹操(《真三国无双》人物)_百度百科', 'url': '曹操/16522702', 'description': '曹操,日本光荣出品游戏《真三国无双》系列曹魏势力重要角色。苍紫的霸道。之后的魏王,人称“乱世的奸雄”。长于判断与决断,参加黄巾讨伐军后展现头角。在陷入战乱的...', 'result_date': '2019-11-29'}, {'title': '《曹操》([日] 堀敏一所著历史书籍)_百度百科', 'url': '《曹操》/23245607', 'description': '《曹操》 是一部由 [日] 堀敏一所著历史书籍,北京联合出版公司出版发行。...... 《曹操》 是一部由 [日] 堀敏一所著历史书籍,北京联合出版公司出版发行。...', 'result_date': '2019-12-7'}, {'title': '曹操墓_百度百科', 'url': '曹操墓/3652496', 'description': '曹操墓即安阳高陵,位于河南省安阳市安丰乡西高穴村,在曹操王都邺北城西12公里处。据《三国志》等史料记载,220年曹操卒于洛阳,灵柩葬在邺城的西门豹祠以西丘陵...', 'result_date': '2019-12-27'}, {'title': '曹操(2018年张黎执导电视剧)_百度百科', 'url': '曹操/20481440', 'description': '《曹操》是由张黎执导,姜文领衔主演古装历史剧。该剧以曹操的一生为主线,讲述了曹操戎马倥偬,功过是非的传奇故事。暂定在2018年9月开机。...', 'result_date': '2019-12-26'}]}
```

#### 获取词条页面表格内容

代码示例：

```python
from lightspider.baike import table

if __name__ == '__main__':
    word = "曹操"
    print(table.query(word))
    for item in table.query(word):
        print(table.get_table(item[1]))
```

执行结果：

```shell script
[('三曹七子', 4028), ('《三国志》人物', 4282), ('魏国历代皇帝', 4417)]
{'title': '三曹七子', 'items': [('孔融', 'view/27805.htm'), ('陈琳', 'view/26492.htm'), ('王粲', 'view/38236.htm'), ('徐干', 'view/56263.htm'), ('阮瑀', 'view/56207.htm'), ('应玚', 'view/56224.htm'), ('刘桢', 'view/34649.htm')]}
{'title': '《三国志》人物', 'items': [('曹操', 'subview/1719/5594282.htm'), ('曹丕', 'subview/5199/5369025.htm'), ('曹睿', 'subview/42568/42568.htm'), ('曹芳', 'subview/100735/6279502.htm'), ('曹髦', 'subview/100740/100740.htm'), ('曹奂', 'subview/41563/41563.htm'), ('武宣卞皇后', 'subview/277556/277556.htm'), ('文昭甄皇后', 'subview/967166/967166.htm'), ('文德郭皇后', 'subview/4211902/4211902.htm'), ('明悼毛皇后', 'subview/2125638/2125638.htm'), ('明元郭皇后', 'view/6973626.htm'), ('董卓', 'subview/2664/6380283.htm'), ('李儒', 'subview/47340/47340.htm'), ('李傕', 'subview/115750/115750.htm'), ('郭汜', 'subview/117668/117668.htm'), ('袁绍', 'subview/15761/6346582.htm'), ('麴义', 'subview/198606/198606.htm'), ('田丰', 'subview/62019/5263868.htm'), ('沮授', 'subview/82365/82365.htm'), ('颜良', 'subview/26647/5235941.htm'), ('文丑', 'subview/26543/5235950.htm'), ('淳于琼', 'subview/131773/131773.htm'), ('审配', 'subview/62001/62001.htm'), ('袁谭', 'subview/157252/157252.htm'), ('袁熙', 'subview/115774/6347788.htm'), ('袁尚', 'subview/157237/157237.htm'), ('高干', 'subview/62010/5494749.htm'), ('袁术', 'subview/15719/6346593.htm'), ('刘表', 'subview/6640/6640.htm'), ('吕布', 'subview/3973/5850475.htm'), ('陈宫', 'subview/9918/6381188.htm'), ('高顺', 'subview/9895/5873983.htm'), ('臧洪', 'subview/120985/120985.htm'), ('公孙瓒', 'subview/41595/6455418.htm'), ('陶谦', 'subview/115766/5786369.htm'), ('张杨', 'subview/17526/5819078.htm'), ('公孙度', 'subview/131692/131692.htm'), ('公孙渊', 'subview/288383/288383.htm'), ('张燕', 'subview/32681/5413302.htm'), ('张绣', 'subview/41590/6455441.htm'), ('张鲁', 'subview/54996/5136668.htm'), ('夏侯惇', 'subview/18287/5594022.htm'), ('韩浩', 'subview/109738/6835770.htm'), ('史涣', 'subview/131912/131912.htm'), ('夏侯渊', 'subview/38721/6380200.htm'), ('曹仁', 'subview/16837/5594235.htm'), ('曹纯', 'subview/109751/109751.htm'), ('曹洪', 'subview/45503/6518082.htm'), ('曹休', 'subview/45590/45590.htm'), ('曹真', 'subview/38796/38796.htm'), ('曹爽', 'subview/123332/5118059.htm'), ('夏侯尚', 'subview/134695/134695.htm'), ('夏侯玄', 'subview/34760/34760.htm'), ('荀彧', 'subview/2618/6380210.htm'), ('荀攸', 'subview/2703/6445420.htm'), ('贾诩', 'subview/2491/5795292.htm'), ('袁涣', 'subview/109710/109710.htm'), ('张范', 'subview/120990/120990.htm'), ('凉茂', 'subview/109707/109707.htm'), ('国渊', 'subview/109706/109706.htm'), ('田畴', 'subview/109713/5456254.htm'), ('王修', 'subview/109704/109704.htm'), ('邴原', 'subview/109702/109702.htm'), ('管宁', 'subview/34593/34593.htm'), ('崔琰', 'subview/56249/56249.htm'), ('毛玠', 'subview/52133/52133.htm'), ('徐奕', 'subview/109763/109763.htm'), ('何夔', 'subview/120994/120994.htm'), ('邢颙', 'subview/109764/109764.htm'), ('鲍勋', 'subview/120995/120995.htm'), ('司马芝', 'subview/986940/986940.htm'), ('钟繇', 'subview/38702/5356077.htm'), ('华歆', 'subview/56268/56268.htm'), ('王朗', 'subview/109690/5566018.htm'), ('王肃', 'subview/56252/5893971.htm'), ('程昱', 'subview/2643/2643.htm'), ('郭嘉', 'subview/2669/5787364.htm'), ('董昭', 'subview/62025/62025.htm'), ('刘晔', 'subview/20755/5236468.htm'), ('蒋济', 'subview/38746/38746.htm'), ('刘放', 'subview/48283/48283.htm'), ('刘馥', 'subview/109600/109600.htm'), ('司马朗', 'subview/329756/329756.htm'), ('梁习', 'subview/120996/120996.htm'), ('张既', 'subview/120997/120997.htm'), ('温恢', 'subview/120999/120999.htm'), ('贾逵', 'subview/34556/5664903.htm'), ('任峻', 'subview/56250/5914756.htm'), ('苏则', 'subview/790369/790369.htm'), ('杜畿', 'subview/232982/232982.htm'), ('杜恕', 'subview/215999/215999.htm'), ('郑浑', 'subview/56255/56255.htm'), ('仓慈', 'subview/752832/752832.htm'), ('张辽', 'subview/2844/5594000.htm'), ('乐进', 'subview/38691/6415175.htm'), ('于禁', 'subview/52089/6380369.htm'), ('张郃', 'subview/18325/5594249.htm'), ('徐晃', 'subview/18346/6380235.htm'), ('朱灵', 'subview/790385/5753644.htm'), ('李典', 'subview/33362/33362.htm'), ('李通', 'subview/217012/5614276.htm'), ('臧霸', 'subview/41613/41613.htm'), ('文聘', 'subview/38733/38733.htm'), ('吕虔', 'subview/131716/131716.htm'), ('许褚', 'subview/20492/5594242.htm'), ('典韦', 'subview/16815/5533215.htm'), ('庞德', 'subview/3869/5064758.htm'), ('庞淯', 'subview/238878/238878.htm'), ('阎温', 'subview/1071838/1071838.htm'), ('曹彰', 'subview/26716/26716.htm'), ('曹植', 'subview/6255/6380335.htm'), ('曹熊', 'subview/64887/64887.htm'), ('曹昂', 'subview/38757/38757.htm'), ('曹铄', 'subview/943171/943171.htm'), ('曹冲', 'subview/59871/5037304.htm'), ('曹宇', 'subview/401316/5833679.htm'), ('曹林', 'subview/943175/6521529.htm'), ('曹峻', 'subview/943182/943182.htm'), ('曹彪', 'subview/955516/955516.htm'), ('曹协', 'subview/4619605/4619605.htm'), ('曹蕤', 'subview/759277/759277.htm'), ('曹霖', 'subview/401321/401321.htm'), ('曹礼', 'subview/4548759/4548759.htm'), ('曹邕', 'subview/4548766/4548766.htm'), ('曹贡', 'subview/4619759/4619759.htm'), ('曹俨', 'subview/1522265/1522265.htm'), ('王粲', 'subview/38236/38236.htm'), ('徐干', 'subview/56263/56263.htm'), ('陈琳', 'subview/26492/5419431.htm'), ('阮瑀', 'subview/56207/56207.htm'), ('应玚', 'subview/56224/56224.htm'), ('刘桢', 'subview/34649/6929748.htm'), ('卫觊', 'subview/675303/675303.htm'), ('刘廙', 'subview/211494/211494.htm'), ('刘劭', 'subview/159177/159177.htm'), ('傅嘏', 'subview/51750/51750.htm'), ('桓阶', 'subview/84644/84644.htm'), ('陈群', 'subview/56242/5121581.htm'), ('陈矫', 'subview/183026/183026.htm'), ('徐宣', 'subview/401338/5861282.htm'), ('卫臻', 'subview/199243/199243.htm'), ('卢毓', 'subview/1362154/1362154.htm'), ('和洽', 'subview/723433/723433.htm'), ('常林', 'subview/349665/349665.htm'), ('杨俊', 'subview/526323/5771545.htm'), ('杜袭', 'subview/351713/351713.htm'), ('赵俨', 'subview/225801/225801.htm'), ('裴潜', 'subview/384713/384713.htm'), ('韩暨', 'subview/857384/857384.htm'), ('崔林', 'subview/5892/5892.htm'), ('高柔', 'subview/287981/287981.htm'), ('孙礼', 'subview/131926/131926.htm'), ('王观', 'subview/7464/6783817.htm'), ('辛毗', 'subview/56218/56218.htm'), ('杨阜', 'subview/315150/315150.htm'), ('高堂隆', 'subview/236683/236683.htm'), ('满宠', 'subview/47390/47390.htm'), ('田豫', 'subview/350370/350370.htm'), ('牵招', 'subview/793509/793509.htm'), ('郭淮', 'subview/52183/52183.htm'), ('徐邈', 'subview/227570/227570.htm'), ('胡质', 'subview/608103/608103.htm'), ('王昶', 'subview/208302/5686122.htm'), ('王基', 'subview/5585/5585.htm'), ('王凌', 'subview/313501/313501.htm'), ('毌丘俭', 'subview/53804/53804.htm'), ('文钦', 'subview/378150/6015772.htm'), ('诸葛诞', 'subview/165309/165309.htm'), ('邓艾', 'subview/18267/5594253.htm'), ('钟会', 'subview/52206/6440109.htm'), ('华佗', 'subview/3240/5834000.htm'), ('杜夔', 'subview/56236/56236.htm'), ('朱建平', 'subview/1163296/1163296.htm'), ('周宣', 'subview/224007/224007.htm'), ('管辂', 'subview/564893/564893.htm'), ('刘焉', 'subview/410043/5364798.htm'), ('刘璋', 'subview/47389/5134331.htm'), ('刘备', 'subview/6213/6213.htm'), ('刘禅', 'subview/16830/6380316.htm'), ('甘皇后', 'subview/588268/588268.htm'), ('穆皇后吴氏', 'view/6973355.htm'), ('刘永', 'subview/157877/157877.htm'), ('刘理', 'subview/212163/6445303.htm'), ('敬哀皇后', 'subview/1013713/6433039.htm'), ('张皇后', 'subview/45013/6428150.htm'), ('刘璇', 'subview/9093/5381270.htm'), ('诸葛亮', 'subview/2347/6593662.htm'), ('关羽', 'subview/2275/6379942.htm'), ('张飞', 'subview/1679/5115439.htm'), ('马超', 'subview/4700/5063484.htm'), ('黄忠', 'subview/26688/5045229.htm'), ('赵云', 'subview/2319/5380476.htm'), ('庞统', 'subview/16700/5765864.htm'), ('法正', 'subview/16407/6380402.htm'), ('许靖', 'subview/99127/6457322.htm'), ('麋竺', 'subview/99128/99128.htm'), ('糜芳', 'subview/80864/80864.htm'), ('孙乾', 'subview/99130/5866766.htm'), ('简雍', 'subview/99134/5224502.htm'), ('伊籍', 'subview/99138/6459015.htm'), ('秦宓', 'subview/99141/99141.htm'), ('董和', 'subview/99164/99164.htm'), ('董允', 'subview/99122/99122.htm'), ('董厥', 'subview/793182/793182.htm'), ('刘巴', 'subview/99158/99158.htm'), ('马良', 'subview/6962/5063828.htm'), ('马谡', 'subview/22550/6380396.htm'), ('陈震', 'subview/79138/6707950.htm'), ('蒋琬', 'subview/84410/84410.htm'), ('费袆', 'subview/656772/656772.htm'), ('陈祗', 'subview/932955/5636422.htm'), ('吕乂', 'subview/99165/99165.htm'), ('吕凯', 'subview/269756/269756.htm'), ('刘封', 'subview/63414/63414.htm'), ('张松', 'subview/95482/5615012.htm'), ('彭羕', 'subview/971819/971819.htm'), ('廖立', 'subview/685497/685497.htm'), ('李严', 'subview/41552/41552.htm'), ('刘琰', 'subview/72871/72871.htm'), ('魏延', 'subview/5638/5779719.htm'), ('杨仪', 'subview/42481/42481.htm'), ('霍峻', 'subview/117613/117613.htm'), ('霍弋', 'subview/913713/913713.htm'), ('王连', 'subview/269779/269779.htm'), ('向朗', 'subview/401347/401347.htm'), ('向宠', 'subview/90940/90940.htm'), ('张裔', 'subview/914888/914888.htm'), ('杨洪', 'subview/401349/401349.htm'), ('费诗', 'subview/401351/401351.htm'), ('王冲', 'subview/598899/598899.htm'), ('杜微', 'subview/117722/6563161.htm'), ('周群', 'subview/50220/50220.htm'), ('杜琼', 'subview/215977/6464786.htm'), ('许慈', 'subview/706249/706249.htm'), ('孟光', 'subview/117747/117747.htm'), ('来敏', 'subview/110221/110221.htm'), ('尹默', 'subview/819358/819358.htm'), ('李撰', 'subview/217372/217372.htm'), ('谯周', 'subview/54440/54440.htm'), ('郤正', 'subview/916103/916103.htm'), ('黄权', 'subview/59893/6217196.htm'), ('邓方', 'subview/199606/199606.htm'), ('李恢', 'subview/117765/117765.htm'), ('马忠', 'subview/110250/5143613.htm'), ('王平', 'subview/26604/26604.htm'), ('张嶷', 'subview/117770/117770.htm'), ('姜维', 'subview/5658/5798356.htm'), ('邓芝', 'subview/42474/42474.htm'), ('张翼', 'subview/117757/5592833.htm'), ('宗预', 'subview/687166/687166.htm'), ('廖化', 'subview/5594/5594.htm'), ('杨戏', 'subview/841412/841412.htm'), ('吴懿', 'subview/117736/6458987.htm'), ('陈到', 'subview/99146/99146.htm'), ('徐庶', 'subview/18335/6380387.htm'), ('夏侯霸', 'subview/38774/38774.htm'), ('孙坚', 'subview/22281/5071674.htm'), ('孙策', 'subview/2589/6380296.htm'), ('孙权', 'subview/2288/6379897.htm'), ('孙亮', 'subview/97994/5758532.htm'), ('孙休', 'subview/97998/97998.htm'), ('孙皓', 'subview/28471/5118291.htm'), ('刘繇', 'subview/165253/165253.htm'), ('太史慈', 'subview/2528/5765799.htm'), ('士燮', 'subview/99093/5259031.htm'), ('吴夫人', 'subview/1820524/6448735.htm'), ('吴景', 'subview/231445/231445.htm'), ('徐琨', 'subview/1102041/1102041.htm'), ('谢夫人', 'view/6874448.htm'), ('徐夫人', 'subview/797617/5593677.htm'), ('步练师', 'subview/3912001/3912001.htm'), ('大懿皇后', 'subview/3365905/3365905.htm'), ('潘皇后', 'subview/1213241/1213241.htm'), ('敬怀皇后', 'subview/3365953/3365953.htm'), ('全惠解', 'subview/1859005/1859005.htm'), ('朱皇后', 'subview/214710/214710.htm'), ('滕皇后', 'subview/1234254/1234254.htm'), ('孙静', 'subview/99027/5817886.htm'), ('孙皎', 'subview/99032/5938672.htm'), ('孙奂', 'subview/99073/99073.htm'), ('孙贲', 'subview/99078/99078.htm'), ('孙辅', 'subview/99081/99081.htm'), ('孙翊', 'subview/99084/99084.htm'), ('孙匡', 'subview/202114/202114.htm'), ('孙韶', 'subview/99090/99090.htm'), ('孙桓', 'subview/99085/6294629.htm'), ('张昭', 'subview/16727/5128697.htm'), ('顾雍', 'subview/82699/82699.htm'), ('诸葛瑾', 'subview/231833/6444316.htm'), ('步骘', 'subview/98010/98010.htm'), ('张纮', 'subview/98011/6380301.htm'), ('严畯', 'subview/98014/98014.htm'), ('程秉', 'subview/98021/98021.htm'), ('阚泽', 'subview/98022/6445469.htm'), ('薛综', 'subview/98950/98950.htm'), ('周瑜', 'subview/2409/6380012.htm'), ('鲁肃', 'subview/24297/5834702.htm'), ('吕蒙', 'subview/5607/5459702.htm'), ('程普', 'subview/51588/51588.htm'), ('黄盖', 'subview/2849/6379999.htm'), ('韩当', 'subview/108946/5665593.htm'), ('吕岱', 'subview/50963/50963.htm'), ('蒋钦', 'subview/98956/6444353.htm'), ('周泰', 'subview/26568/5062127.htm'), ('陈武', 'subview/98961/5380454.htm'), ('陈脩', 'subview/1483657/1483657.htm'), ('陈表', 'subview/814329/814329.htm'), ('董袭', 'subview/98962/98962.htm'), ('甘宁', 'subview/2727/5628001.htm'), ('凌统', 'subview/98964/5786375.htm'), ('徐盛', 'subview/38673/6381213.htm'), ('潘璋', 'subview/71685/71685.htm'), ('丁奉', 'subview/98980/5594476.htm'), ('朱治', 'subview/98987/6444409.htm'), ('朱然', 'subview/98989/98989.htm'), ('朱绩', 'subview/98991/98991.htm'), ('吕范', 'subview/98984/98984.htm'), ('吕据', 'subview/555518/555518.htm'), ('朱桓', 'subview/98994/6444434.htm'), ('朱异', 'subview/180192/180192.htm'), ('虞翻', 'subview/99016/6445475.htm'), ('陆绩', 'subview/99008/99008.htm'), ('张温', 'subview/99024/5758901.htm'), ('骆统', 'subview/99029/99029.htm'), ('陆瑁', 'subview/99019/99019.htm'), ('吾粲', 'subview/99012/99012.htm'), ('朱据', 'subview/99013/99013.htm'), ('陆逊', 'subview/5622/6380039.htm'), ('孙登', 'subview/100636/6476013.htm'), ('孙虑', 'subview/100637/5733416.htm'), ('孙和', 'subview/100639/100639.htm'), ('孙霸', 'subview/100642/100642.htm'), ('孙奋', 'subview/100645/100645.htm'), ('贺齐', 'subview/100648/100648.htm'), ('全琮', 'subview/44991/44991.htm'), ('周鲂', 'subview/100658/6397007.htm'), ('锺离牧', 'view/6813157.htm'), ('潘濬', 'subview/99094/99094.htm'), ('陆凯', 'subview/100670/5593935.htm'), ('是仪', 'subview/100672/100672.htm'), ('胡综', 'subview/100677/100677.htm'), ('吴范', 'subview/100706/100706.htm'), ('刘惇', 'subview/100700/100700.htm'), ('赵达', 'subview/351690/351690.htm'), ('诸葛恪', 'subview/100682/100682.htm'), ('滕胤', 'subview/100684/100684.htm'), ('孙峻', 'subview/100695/5595271.htm'), ('孙綝', 'subview/100697/100697.htm'), ('濮阳兴', 'subview/100688/100688.htm'), ('王蕃', 'subview/100707/100707.htm'), ('楼玄', 'subview/100711/100711.htm'), ('贺邵', 'subview/100712/100712.htm'), ('韦曜', 'subview/100720/100720.htm'), ('华核', 'subview/875681/875681.htm')]}
{'title': '魏国历代皇帝', 'items': [('魏高帝(曹腾)', 'searchword/?word=%E9%AD%8F%E9%AB%98%E5%B8%9D&pic=1&sug=1&enc=utf8'), ('魏太帝(曹嵩)', 'searchword/?word=%E9%AD%8F%E5%A4%AA%E5%B8%9D&pic=1&sug=1&enc=utf8'), ('魏武帝(曹操)', 'view/757996.htm'), ('魏文帝(曹丕220—226年)', 'view/329746.htm'), ('魏明帝(曹叡226—239年)', 'view/277339.htm'), ('魏少帝(曹芳239—254年)', 'searchword/?word=%E9%AD%8F%E5%B0%91%E5%B8%9D&pic=1&sug=1&enc=utf8'), ('高贵乡公(曹髦255—260年)', 'view/148451.htm'), ('魏元帝(曹奂260—265年)', 'view/277343.htm')]}
```

### 3.邮件提醒

若欲启用邮件提醒功能，可在`spider.run`方法中传入`notification`参数，其格式为字典`dict`，需要有`to`和`task_name`参数，分别指定发送的邮箱和任务名称，其中`to`可以指定为字符串列表从而将邮件发送到多个邮箱。

代码示例：

```python
from lightspider.baike import info
from lightspider import Spider


tasks = ['曹操', '曹操字孟德', '司马懿',
         '自然语言处理', '知识图谱', '人工智能', '深度学习', '爬虫']

notification = {
    "to": "iamlightsmile@qq.com",
    "task_name": "baike_info"
}

spider = Spider(base_url=info.base_url, save_format=info.save_format, save_path=r'D:\Data\NLP\corpus\baike_info')

if __name__ == '__main__':
    spider.run(tasks, info.parser, notification=notification)
```

执行结果如下：

```text
[2020-02-05 09:45:58] [INFO] [MainThread] [spider.py:43] 已处理0条数据，还需处理8条数据
[2020-02-05 09:45:59] [INFO] [MainThread] [spider.py:57] 开始爬取，当前时间为：2020-02-05 09:45:59
[2020-02-05 09:46:00] [INFO] [MainThread] [writer.py:12] 写入地址为：D:\Data\NLP\corpus\baike_info\result.json， 临时文件地址为：D:\Data\NLP\corpus\baike_info\handled.txt
100%|██████████| 8/8 [00:00<00:00, 17.78it/s]
[2020-02-05 09:46:00] [INFO] [MainThread] [spider.py:76] 执行结束, 当前时间为：2020-02-05 09:46:00
[2020-02-05 09:46:00] [INFO] [MainThread] [spider.py:80] 本次共计耗时1.42秒，共爬取8条数据，平均速度为：5.62(task/s)
[2020-02-05 09:46:03] [INFO] [MainThread] [spider.py:96] 邮件发送成功！
```

同时邮件内容如下：

![UTOOLS1580867183436.png](https://lightsmile-img.oss-cn-beijing.aliyuncs.com/UTOOLS1580867183436.png)


## 参考
1. [Python3WebSpider/ProxyPool: Proxy Pool](https://github.com/Python3WebSpider/ProxyPool)
2. [如何在python中通过多进程使用tqdm？ - VoidCC](http://cn.voidcc.com/question/p-dtnumnri-bhw.html)
3. [编写多进程爬虫 - 知乎](https://zhuanlan.zhihu.com/p/76866650)
4. [Python中保留两位小数的几种方法_杰瑞的专栏-CSDN博客](https://blog.csdn.net/Jerry_1126/article/details/85009810)
5. [[快学Python3]日期和时间处理 - 简书](https://www.jianshu.com/p/eb5c416673bd)
6. [multiprocessing --- 基于进程的并行 — Python 3.8.1 文档](https://docs.python.org/zh-cn/3/library/multiprocessing.html)
7. [python去掉字符串中的空白字符_drbing的博客-CSDN博客](https://blog.csdn.net/drbing/article/details/50891172)
8. [git - ssh: connect to host github.com port 22: Connection timed out - Stack Overflow](https://stackoverflow.com/questions/15589682/ssh-connect-to-host-github-com-port-22-connection-timed-out)
9. [mongodb 导入json文件遇到的坑 - xibuhaohao - 博客园](https://www.cnblogs.com/xibuhaohao/p/11251306.html)

## 打赏

如果该项目对您有所帮助，欢迎打赏~

![UTOOLS1578660899400.jpg](https://lightsmile-img.oss-cn-beijing.aliyuncs.com/UTOOLS1578660899400.jpg)