# -*- coding: utf-8 -*-
#
# This file is part of the enjoy project
#
# Copyright (c) 2021 Tiago Coutinho
# Distributed under the GPLv3 license. See LICENSE for more info.

# This file has been generated by enjoy.gencodes
# Date: 2018-11-15 16:12:59.308313
# Version: Linux 4.15.0-20-generic #21-Ubuntu SMP Tue Apr 24 06:16:15 UTC 2018 x86_64

import enum
import ctypes
import collections


def struct_repr(self):
    name = type(self).__name__
    fields = ', '.join(('{}={}'.format(field[0], getattr(self, field[0]))
                        for field in self._fields_))
    return '{}({})'.format(name, fields)


def struct_asdict(self):
    r = collections.OrderedDict()
    for field_name, _ in self._fields_:
        r[field_name] = getattr(self, field_name)
    return r


def struct_iter(self):
    for fname, _ in self._fields_:
        yield getattr(self, fname)


class Id(enum.IntEnum):
    ID_BUS = 0x0
    ID_VENDOR = 0x1
    ID_PRODUCT = 0x2
    ID_VERSION = 0x3


class Bus(enum.IntEnum):
    BUS_PCI = 0x1
    BUS_ISAPNP = 0x2
    BUS_USB = 0x3
    BUS_HIL = 0x4
    BUS_BLUETOOTH = 0x5
    BUS_VIRTUAL = 0x6
    BUS_ISA = 0x10
    BUS_I8042 = 0x11
    BUS_XTKBD = 0x12
    BUS_RS232 = 0x13
    BUS_GAMEPORT = 0x14
    BUS_PARPORT = 0x15
    BUS_AMIGA = 0x16
    BUS_ADB = 0x17
    BUS_I2C = 0x18
    BUS_HOST = 0x19
    BUS_GSC = 0x1A
    BUS_ATARI = 0x1B
    BUS_SPI = 0x1C
    BUS_RMI = 0x1D
    BUS_CEC = 0x1E
    BUS_INTEL_ISHTP = 0x1F


class MultiTouch(enum.IntEnum):
    MT_TOOL_FINGER = 0x0
    MT_TOOL_PEN = 0x1
    MT_TOOL_PALM = 0x2
    MT_TOOL_MAX = 0x2


class ForceFeedback(enum.IntEnum):
    FF_STATUS_STOPPED = 0x0
    FF_STATUS_PLAYING = 0x1
    FF_STATUS_MAX = 0x1
    FF_RUMBLE = 0x50
    FF_PERIODIC = 0x51
    FF_CONSTANT = 0x52
    FF_SPRING = 0x53
    FF_FRICTION = 0x54
    FF_DAMPER = 0x55
    FF_INERTIA = 0x56
    FF_RAMP = 0x57
    FF_EFFECT_MIN = 0x50
    FF_EFFECT_MAX = 0x57
    FF_SQUARE = 0x58
    FF_TRIANGLE = 0x59
    FF_SINE = 0x5A
    FF_SAW_UP = 0x5B
    FF_SAW_DOWN = 0x5C
    FF_CUSTOM = 0x5D
    FF_WAVEFORM_MIN = 0x58
    FF_WAVEFORM_MAX = 0x5D
    FF_GAIN = 0x60
    FF_AUTOCENTER = 0x61
    FF_MAX_EFFECTS = 0x60
    FF_MAX = 0x7F


class EventType(enum.IntEnum):
    EV_SYN = 0x0
    EV_KEY = 0x1
    EV_REL = 0x2
    EV_ABS = 0x3
    EV_MSC = 0x4
    EV_SW = 0x5
    EV_LED = 0x11
    EV_SND = 0x12
    EV_REP = 0x14
    EV_FF = 0x15
    EV_PWR = 0x16
    EV_FF_STATUS = 0x17
    EV_MAX = 0x1F


class Synchronization(enum.IntEnum):
    SYN_REPORT = 0x0
    SYN_CONFIG = 0x1
    SYN_MT_REPORT = 0x2
    SYN_DROPPED = 0x3
    SYN_MAX = 0xF


class Key(enum.IntEnum):
    KEY_RESERVED = 0x0
    KEY_ESC = 0x1
    KEY_1 = 0x2
    KEY_2 = 0x3
    KEY_3 = 0x4
    KEY_4 = 0x5
    KEY_5 = 0x6
    KEY_6 = 0x7
    KEY_7 = 0x8
    KEY_8 = 0x9
    KEY_9 = 0xA
    KEY_0 = 0xB
    KEY_MINUS = 0xC
    KEY_EQUAL = 0xD
    KEY_BACKSPACE = 0xE
    KEY_TAB = 0xF
    KEY_Q = 0x10
    KEY_W = 0x11
    KEY_E = 0x12
    KEY_R = 0x13
    KEY_T = 0x14
    KEY_Y = 0x15
    KEY_U = 0x16
    KEY_I = 0x17
    KEY_O = 0x18
    KEY_P = 0x19
    KEY_LEFTBRACE = 0x1A
    KEY_RIGHTBRACE = 0x1B
    KEY_ENTER = 0x1C
    KEY_LEFTCTRL = 0x1D
    KEY_A = 0x1E
    KEY_S = 0x1F
    KEY_D = 0x20
    KEY_F = 0x21
    KEY_G = 0x22
    KEY_H = 0x23
    KEY_J = 0x24
    KEY_K = 0x25
    KEY_L = 0x26
    KEY_SEMICOLON = 0x27
    KEY_APOSTROPHE = 0x28
    KEY_GRAVE = 0x29
    KEY_LEFTSHIFT = 0x2A
    KEY_BACKSLASH = 0x2B
    KEY_Z = 0x2C
    KEY_X = 0x2D
    KEY_C = 0x2E
    KEY_V = 0x2F
    KEY_B = 0x30
    KEY_N = 0x31
    KEY_M = 0x32
    KEY_COMMA = 0x33
    KEY_DOT = 0x34
    KEY_SLASH = 0x35
    KEY_RIGHTSHIFT = 0x36
    KEY_KPASTERISK = 0x37
    KEY_LEFTALT = 0x38
    KEY_SPACE = 0x39
    KEY_CAPSLOCK = 0x3A
    KEY_F1 = 0x3B
    KEY_F2 = 0x3C
    KEY_F3 = 0x3D
    KEY_F4 = 0x3E
    KEY_F5 = 0x3F
    KEY_F6 = 0x40
    KEY_F7 = 0x41
    KEY_F8 = 0x42
    KEY_F9 = 0x43
    KEY_F10 = 0x44
    KEY_NUMLOCK = 0x45
    KEY_SCROLLLOCK = 0x46
    KEY_KP7 = 0x47
    KEY_KP8 = 0x48
    KEY_KP9 = 0x49
    KEY_KPMINUS = 0x4A
    KEY_KP4 = 0x4B
    KEY_KP5 = 0x4C
    KEY_KP6 = 0x4D
    KEY_KPPLUS = 0x4E
    KEY_KP1 = 0x4F
    KEY_KP2 = 0x50
    KEY_KP3 = 0x51
    KEY_KP0 = 0x52
    KEY_KPDOT = 0x53
    KEY_ZENKAKUHANKAKU = 0x55
    KEY_102ND = 0x56
    KEY_F11 = 0x57
    KEY_F12 = 0x58
    KEY_RO = 0x59
    KEY_KATAKANA = 0x5A
    KEY_HIRAGANA = 0x5B
    KEY_HENKAN = 0x5C
    KEY_KATAKANAHIRAGANA = 0x5D
    KEY_MUHENKAN = 0x5E
    KEY_KPJPCOMMA = 0x5F
    KEY_KPENTER = 0x60
    KEY_RIGHTCTRL = 0x61
    KEY_KPSLASH = 0x62
    KEY_SYSRQ = 0x63
    KEY_RIGHTALT = 0x64
    KEY_LINEFEED = 0x65
    KEY_HOME = 0x66
    KEY_UP = 0x67
    KEY_PAGEUP = 0x68
    KEY_LEFT = 0x69
    KEY_RIGHT = 0x6A
    KEY_END = 0x6B
    KEY_DOWN = 0x6C
    KEY_PAGEDOWN = 0x6D
    KEY_INSERT = 0x6E
    KEY_DELETE = 0x6F
    KEY_MACRO = 0x70
    KEY_MUTE = 0x71
    KEY_VOLUMEDOWN = 0x72
    KEY_VOLUMEUP = 0x73
    KEY_POWER = 0x74
    KEY_KPEQUAL = 0x75
    KEY_KPPLUSMINUS = 0x76
    KEY_PAUSE = 0x77
    KEY_SCALE = 0x78
    KEY_KPCOMMA = 0x79
    KEY_HANGEUL = 0x7A
    KEY_HANGUEL = 0x7A
    KEY_HANJA = 0x7B
    KEY_YEN = 0x7C
    KEY_LEFTMETA = 0x7D
    KEY_RIGHTMETA = 0x7E
    KEY_COMPOSE = 0x7F
    KEY_STOP = 0x80
    KEY_AGAIN = 0x81
    KEY_PROPS = 0x82
    KEY_UNDO = 0x83
    KEY_FRONT = 0x84
    KEY_COPY = 0x85
    KEY_OPEN = 0x86
    KEY_PASTE = 0x87
    KEY_FIND = 0x88
    KEY_CUT = 0x89
    KEY_HELP = 0x8A
    KEY_MENU = 0x8B
    KEY_CALC = 0x8C
    KEY_SETUP = 0x8D
    KEY_SLEEP = 0x8E
    KEY_WAKEUP = 0x8F
    KEY_FILE = 0x90
    KEY_SENDFILE = 0x91
    KEY_DELETEFILE = 0x92
    KEY_XFER = 0x93
    KEY_PROG1 = 0x94
    KEY_PROG2 = 0x95
    KEY_WWW = 0x96
    KEY_MSDOS = 0x97
    KEY_COFFEE = 0x98
    KEY_SCREENLOCK = 0x98
    KEY_ROTATE_DISPLAY = 0x99
    KEY_DIRECTION = 0x99
    KEY_CYCLEWINDOWS = 0x9A
    KEY_MAIL = 0x9B
    KEY_BOOKMARKS = 0x9C
    KEY_COMPUTER = 0x9D
    KEY_BACK = 0x9E
    KEY_FORWARD = 0x9F
    KEY_CLOSECD = 0xA0
    KEY_EJECTCD = 0xA1
    KEY_EJECTCLOSECD = 0xA2
    KEY_NEXTSONG = 0xA3
    KEY_PLAYPAUSE = 0xA4
    KEY_PREVIOUSSONG = 0xA5
    KEY_STOPCD = 0xA6
    KEY_RECORD = 0xA7
    KEY_REWIND = 0xA8
    KEY_PHONE = 0xA9
    KEY_ISO = 0xAA
    KEY_CONFIG = 0xAB
    KEY_HOMEPAGE = 0xAC
    KEY_REFRESH = 0xAD
    KEY_EXIT = 0xAE
    KEY_MOVE = 0xAF
    KEY_EDIT = 0xB0
    KEY_SCROLLUP = 0xB1
    KEY_SCROLLDOWN = 0xB2
    KEY_KPLEFTPAREN = 0xB3
    KEY_KPRIGHTPAREN = 0xB4
    KEY_NEW = 0xB5
    KEY_REDO = 0xB6
    KEY_F13 = 0xB7
    KEY_F14 = 0xB8
    KEY_F15 = 0xB9
    KEY_F16 = 0xBA
    KEY_F17 = 0xBB
    KEY_F18 = 0xBC
    KEY_F19 = 0xBD
    KEY_F20 = 0xBE
    KEY_F21 = 0xBF
    KEY_F22 = 0xC0
    KEY_F23 = 0xC1
    KEY_F24 = 0xC2
    KEY_PLAYCD = 0xC8
    KEY_PAUSECD = 0xC9
    KEY_PROG3 = 0xCA
    KEY_PROG4 = 0xCB
    KEY_DASHBOARD = 0xCC
    KEY_SUSPEND = 0xCD
    KEY_CLOSE = 0xCE
    KEY_PLAY = 0xCF
    KEY_FASTFORWARD = 0xD0
    KEY_BASSBOOST = 0xD1
    KEY_PRINT = 0xD2
    KEY_HP = 0xD3
    KEY_CAMERA = 0xD4
    KEY_SOUND = 0xD5
    KEY_QUESTION = 0xD6
    KEY_EMAIL = 0xD7
    KEY_CHAT = 0xD8
    KEY_SEARCH = 0xD9
    KEY_CONNECT = 0xDA
    KEY_FINANCE = 0xDB
    KEY_SPORT = 0xDC
    KEY_SHOP = 0xDD
    KEY_ALTERASE = 0xDE
    KEY_CANCEL = 0xDF
    KEY_BRIGHTNESSDOWN = 0xE0
    KEY_BRIGHTNESSUP = 0xE1
    KEY_MEDIA = 0xE2
    KEY_SWITCHVIDEOMODE = 0xE3
    KEY_KBDILLUMTOGGLE = 0xE4
    KEY_KBDILLUMDOWN = 0xE5
    KEY_KBDILLUMUP = 0xE6
    KEY_SEND = 0xE7
    KEY_REPLY = 0xE8
    KEY_FORWARDMAIL = 0xE9
    KEY_SAVE = 0xEA
    KEY_DOCUMENTS = 0xEB
    KEY_BATTERY = 0xEC
    KEY_BLUETOOTH = 0xED
    KEY_WLAN = 0xEE
    KEY_UWB = 0xEF
    KEY_UNKNOWN = 0xF0
    KEY_VIDEO_NEXT = 0xF1
    KEY_VIDEO_PREV = 0xF2
    KEY_BRIGHTNESS_CYCLE = 0xF3
    KEY_BRIGHTNESS_AUTO = 0xF4
    KEY_BRIGHTNESS_ZERO = 0xF4
    KEY_DISPLAY_OFF = 0xF5
    KEY_WWAN = 0xF6
    KEY_WIMAX = 0xF6
    KEY_RFKILL = 0xF7
    KEY_MICMUTE = 0xF8
    BTN_MISC = 0x100
    BTN_0 = 0x100
    BTN_1 = 0x101
    BTN_2 = 0x102
    BTN_3 = 0x103
    BTN_4 = 0x104
    BTN_5 = 0x105
    BTN_6 = 0x106
    BTN_7 = 0x107
    BTN_8 = 0x108
    BTN_9 = 0x109
    BTN_MOUSE = 0x110
    BTN_LEFT = 0x110
    BTN_RIGHT = 0x111
    BTN_MIDDLE = 0x112
    BTN_SIDE = 0x113
    BTN_EXTRA = 0x114
    BTN_FORWARD = 0x115
    BTN_BACK = 0x116
    BTN_TASK = 0x117
    BTN_JOYSTICK = 0x120
    BTN_TRIGGER = 0x120
    BTN_THUMB = 0x121
    BTN_THUMB2 = 0x122
    BTN_TOP = 0x123
    BTN_TOP2 = 0x124
    BTN_PINKIE = 0x125
    BTN_BASE = 0x126
    BTN_BASE2 = 0x127
    BTN_BASE3 = 0x128
    BTN_BASE4 = 0x129
    BTN_BASE5 = 0x12A
    BTN_BASE6 = 0x12B
    BTN_DEAD = 0x12F
    BTN_GAMEPAD = 0x130
    BTN_SOUTH = 0x130
    BTN_A = 0x130
    BTN_EAST = 0x131
    BTN_B = 0x131
    BTN_C = 0x132
    BTN_NORTH = 0x133
    BTN_X = 0x133
    BTN_WEST = 0x134
    BTN_Y = 0x134
    BTN_Z = 0x135
    BTN_TL = 0x136
    BTN_TR = 0x137
    BTN_TL2 = 0x138
    BTN_TR2 = 0x139
    BTN_SELECT = 0x13A
    BTN_START = 0x13B
    BTN_MODE = 0x13C
    BTN_THUMBL = 0x13D
    BTN_THUMBR = 0x13E
    BTN_DIGI = 0x140
    BTN_TOOL_PEN = 0x140
    BTN_TOOL_RUBBER = 0x141
    BTN_TOOL_BRUSH = 0x142
    BTN_TOOL_PENCIL = 0x143
    BTN_TOOL_AIRBRUSH = 0x144
    BTN_TOOL_FINGER = 0x145
    BTN_TOOL_MOUSE = 0x146
    BTN_TOOL_LENS = 0x147
    BTN_TOOL_QUINTTAP = 0x148
    BTN_STYLUS3 = 0x149
    BTN_TOUCH = 0x14A
    BTN_STYLUS = 0x14B
    BTN_STYLUS2 = 0x14C
    BTN_TOOL_DOUBLETAP = 0x14D
    BTN_TOOL_TRIPLETAP = 0x14E
    BTN_TOOL_QUADTAP = 0x14F
    BTN_WHEEL = 0x150
    BTN_GEAR_DOWN = 0x150
    BTN_GEAR_UP = 0x151
    KEY_OK = 0x160
    KEY_SELECT = 0x161
    KEY_GOTO = 0x162
    KEY_CLEAR = 0x163
    KEY_POWER2 = 0x164
    KEY_OPTION = 0x165
    KEY_INFO = 0x166
    KEY_TIME = 0x167
    KEY_VENDOR = 0x168
    KEY_ARCHIVE = 0x169
    KEY_PROGRAM = 0x16A
    KEY_CHANNEL = 0x16B
    KEY_FAVORITES = 0x16C
    KEY_EPG = 0x16D
    KEY_PVR = 0x16E
    KEY_MHP = 0x16F
    KEY_LANGUAGE = 0x170
    KEY_TITLE = 0x171
    KEY_SUBTITLE = 0x172
    KEY_ANGLE = 0x173
    KEY_ZOOM = 0x174
    KEY_MODE = 0x175
    KEY_KEYBOARD = 0x176
    KEY_SCREEN = 0x177
    KEY_PC = 0x178
    KEY_TV = 0x179
    KEY_TV2 = 0x17A
    KEY_VCR = 0x17B
    KEY_VCR2 = 0x17C
    KEY_SAT = 0x17D
    KEY_SAT2 = 0x17E
    KEY_CD = 0x17F
    KEY_TAPE = 0x180
    KEY_RADIO = 0x181
    KEY_TUNER = 0x182
    KEY_PLAYER = 0x183
    KEY_TEXT = 0x184
    KEY_DVD = 0x185
    KEY_AUX = 0x186
    KEY_MP3 = 0x187
    KEY_AUDIO = 0x188
    KEY_VIDEO = 0x189
    KEY_DIRECTORY = 0x18A
    KEY_LIST = 0x18B
    KEY_MEMO = 0x18C
    KEY_CALENDAR = 0x18D
    KEY_RED = 0x18E
    KEY_GREEN = 0x18F
    KEY_YELLOW = 0x190
    KEY_BLUE = 0x191
    KEY_CHANNELUP = 0x192
    KEY_CHANNELDOWN = 0x193
    KEY_FIRST = 0x194
    KEY_LAST = 0x195
    KEY_AB = 0x196
    KEY_NEXT = 0x197
    KEY_RESTART = 0x198
    KEY_SLOW = 0x199
    KEY_SHUFFLE = 0x19A
    KEY_BREAK = 0x19B
    KEY_PREVIOUS = 0x19C
    KEY_DIGITS = 0x19D
    KEY_TEEN = 0x19E
    KEY_TWEN = 0x19F
    KEY_VIDEOPHONE = 0x1A0
    KEY_GAMES = 0x1A1
    KEY_ZOOMIN = 0x1A2
    KEY_ZOOMOUT = 0x1A3
    KEY_ZOOMRESET = 0x1A4
    KEY_WORDPROCESSOR = 0x1A5
    KEY_EDITOR = 0x1A6
    KEY_SPREADSHEET = 0x1A7
    KEY_GRAPHICSEDITOR = 0x1A8
    KEY_PRESENTATION = 0x1A9
    KEY_DATABASE = 0x1AA
    KEY_NEWS = 0x1AB
    KEY_VOICEMAIL = 0x1AC
    KEY_ADDRESSBOOK = 0x1AD
    KEY_MESSENGER = 0x1AE
    KEY_DISPLAYTOGGLE = 0x1AF
    KEY_BRIGHTNESS_TOGGLE = 0x1AF
    KEY_SPELLCHECK = 0x1B0
    KEY_LOGOFF = 0x1B1
    KEY_DOLLAR = 0x1B2
    KEY_EURO = 0x1B3
    KEY_FRAMEBACK = 0x1B4
    KEY_FRAMEFORWARD = 0x1B5
    KEY_CONTEXT_MENU = 0x1B6
    KEY_MEDIA_REPEAT = 0x1B7
    KEY_10CHANNELSUP = 0x1B8
    KEY_10CHANNELSDOWN = 0x1B9
    KEY_IMAGES = 0x1BA
    KEY_DEL_EOL = 0x1C0
    KEY_DEL_EOS = 0x1C1
    KEY_INS_LINE = 0x1C2
    KEY_DEL_LINE = 0x1C3
    KEY_FN = 0x1D0
    KEY_FN_ESC = 0x1D1
    KEY_FN_F1 = 0x1D2
    KEY_FN_F2 = 0x1D3
    KEY_FN_F3 = 0x1D4
    KEY_FN_F4 = 0x1D5
    KEY_FN_F5 = 0x1D6
    KEY_FN_F6 = 0x1D7
    KEY_FN_F7 = 0x1D8
    KEY_FN_F8 = 0x1D9
    KEY_FN_F9 = 0x1DA
    KEY_FN_F10 = 0x1DB
    KEY_FN_F11 = 0x1DC
    KEY_FN_F12 = 0x1DD
    KEY_FN_1 = 0x1DE
    KEY_FN_2 = 0x1DF
    KEY_FN_D = 0x1E0
    KEY_FN_E = 0x1E1
    KEY_FN_F = 0x1E2
    KEY_FN_S = 0x1E3
    KEY_FN_B = 0x1E4
    KEY_BRL_DOT1 = 0x1F1
    KEY_BRL_DOT2 = 0x1F2
    KEY_BRL_DOT3 = 0x1F3
    KEY_BRL_DOT4 = 0x1F4
    KEY_BRL_DOT5 = 0x1F5
    KEY_BRL_DOT6 = 0x1F6
    KEY_BRL_DOT7 = 0x1F7
    KEY_BRL_DOT8 = 0x1F8
    KEY_BRL_DOT9 = 0x1F9
    KEY_BRL_DOT10 = 0x1FA
    KEY_NUMERIC_0 = 0x200
    KEY_NUMERIC_1 = 0x201
    KEY_NUMERIC_2 = 0x202
    KEY_NUMERIC_3 = 0x203
    KEY_NUMERIC_4 = 0x204
    KEY_NUMERIC_5 = 0x205
    KEY_NUMERIC_6 = 0x206
    KEY_NUMERIC_7 = 0x207
    KEY_NUMERIC_8 = 0x208
    KEY_NUMERIC_9 = 0x209
    KEY_NUMERIC_STAR = 0x20A
    KEY_NUMERIC_POUND = 0x20B
    KEY_NUMERIC_A = 0x20C
    KEY_NUMERIC_B = 0x20D
    KEY_NUMERIC_C = 0x20E
    KEY_NUMERIC_D = 0x20F
    KEY_CAMERA_FOCUS = 0x210
    KEY_WPS_BUTTON = 0x211
    KEY_TOUCHPAD_TOGGLE = 0x212
    KEY_TOUCHPAD_ON = 0x213
    KEY_TOUCHPAD_OFF = 0x214
    KEY_CAMERA_ZOOMIN = 0x215
    KEY_CAMERA_ZOOMOUT = 0x216
    KEY_CAMERA_UP = 0x217
    KEY_CAMERA_DOWN = 0x218
    KEY_CAMERA_LEFT = 0x219
    KEY_CAMERA_RIGHT = 0x21A
    KEY_ATTENDANT_ON = 0x21B
    KEY_ATTENDANT_OFF = 0x21C
    KEY_ATTENDANT_TOGGLE = 0x21D
    KEY_LIGHTS_TOGGLE = 0x21E
    BTN_DPAD_UP = 0x220
    BTN_DPAD_DOWN = 0x221
    BTN_DPAD_LEFT = 0x222
    BTN_DPAD_RIGHT = 0x223
    KEY_ALS_TOGGLE = 0x230
    KEY_BUTTONCONFIG = 0x240
    KEY_TASKMANAGER = 0x241
    KEY_JOURNAL = 0x242
    KEY_CONTROLPANEL = 0x243
    KEY_APPSELECT = 0x244
    KEY_SCREENSAVER = 0x245
    KEY_VOICECOMMAND = 0x246
    KEY_ASSISTANT = 0x247
    KEY_BRIGHTNESS_MIN = 0x250
    KEY_BRIGHTNESS_MAX = 0x251
    KEY_KBDINPUTASSIST_PREV = 0x260
    KEY_KBDINPUTASSIST_NEXT = 0x261
    KEY_KBDINPUTASSIST_PREVGROUP = 0x262
    KEY_KBDINPUTASSIST_NEXTGROUP = 0x263
    KEY_KBDINPUTASSIST_ACCEPT = 0x264
    KEY_KBDINPUTASSIST_CANCEL = 0x265
    KEY_RIGHT_UP = 0x266
    KEY_RIGHT_DOWN = 0x267
    KEY_LEFT_UP = 0x268
    KEY_LEFT_DOWN = 0x269
    KEY_ROOT_MENU = 0x26A
    KEY_MEDIA_TOP_MENU = 0x26B
    KEY_NUMERIC_11 = 0x26C
    KEY_NUMERIC_12 = 0x26D
    KEY_AUDIO_DESC = 0x26E
    KEY_3D_MODE = 0x26F
    KEY_NEXT_FAVORITE = 0x270
    KEY_STOP_RECORD = 0x271
    KEY_PAUSE_RECORD = 0x272
    KEY_VOD = 0x273
    KEY_UNMUTE = 0x274
    KEY_FASTREVERSE = 0x275
    KEY_SLOWREVERSE = 0x276
    KEY_DATA = 0x277
    KEY_ONSCREEN_KEYBOARD = 0x278
    BTN_TRIGGER_HAPPY = 0x2C0
    BTN_TRIGGER_HAPPY1 = 0x2C0
    BTN_TRIGGER_HAPPY2 = 0x2C1
    BTN_TRIGGER_HAPPY3 = 0x2C2
    BTN_TRIGGER_HAPPY4 = 0x2C3
    BTN_TRIGGER_HAPPY5 = 0x2C4
    BTN_TRIGGER_HAPPY6 = 0x2C5
    BTN_TRIGGER_HAPPY7 = 0x2C6
    BTN_TRIGGER_HAPPY8 = 0x2C7
    BTN_TRIGGER_HAPPY9 = 0x2C8
    BTN_TRIGGER_HAPPY10 = 0x2C9
    BTN_TRIGGER_HAPPY11 = 0x2CA
    BTN_TRIGGER_HAPPY12 = 0x2CB
    BTN_TRIGGER_HAPPY13 = 0x2CC
    BTN_TRIGGER_HAPPY14 = 0x2CD
    BTN_TRIGGER_HAPPY15 = 0x2CE
    BTN_TRIGGER_HAPPY16 = 0x2CF
    BTN_TRIGGER_HAPPY17 = 0x2D0
    BTN_TRIGGER_HAPPY18 = 0x2D1
    BTN_TRIGGER_HAPPY19 = 0x2D2
    BTN_TRIGGER_HAPPY20 = 0x2D3
    BTN_TRIGGER_HAPPY21 = 0x2D4
    BTN_TRIGGER_HAPPY22 = 0x2D5
    BTN_TRIGGER_HAPPY23 = 0x2D6
    BTN_TRIGGER_HAPPY24 = 0x2D7
    BTN_TRIGGER_HAPPY25 = 0x2D8
    BTN_TRIGGER_HAPPY26 = 0x2D9
    BTN_TRIGGER_HAPPY27 = 0x2DA
    BTN_TRIGGER_HAPPY28 = 0x2DB
    BTN_TRIGGER_HAPPY29 = 0x2DC
    BTN_TRIGGER_HAPPY30 = 0x2DD
    BTN_TRIGGER_HAPPY31 = 0x2DE
    BTN_TRIGGER_HAPPY32 = 0x2DF
    BTN_TRIGGER_HAPPY33 = 0x2E0
    BTN_TRIGGER_HAPPY34 = 0x2E1
    BTN_TRIGGER_HAPPY35 = 0x2E2
    BTN_TRIGGER_HAPPY36 = 0x2E3
    BTN_TRIGGER_HAPPY37 = 0x2E4
    BTN_TRIGGER_HAPPY38 = 0x2E5
    BTN_TRIGGER_HAPPY39 = 0x2E6
    BTN_TRIGGER_HAPPY40 = 0x2E7
    KEY_MIN_INTERESTING = 0x71
    KEY_MAX = 0x2FF


class Relative(enum.IntEnum):
    REL_X = 0x0
    REL_Y = 0x1
    REL_Z = 0x2
    REL_RX = 0x3
    REL_RY = 0x4
    REL_RZ = 0x5
    REL_HWHEEL = 0x6
    REL_DIAL = 0x7
    REL_WHEEL = 0x8
    REL_MISC = 0x9
    REL_MAX = 0xF


class Absolute(enum.IntEnum):
    ABS_X = 0x0
    ABS_Y = 0x1
    ABS_Z = 0x2
    ABS_RX = 0x3
    ABS_RY = 0x4
    ABS_RZ = 0x5
    ABS_THROTTLE = 0x6
    ABS_RUDDER = 0x7
    ABS_WHEEL = 0x8
    ABS_GAS = 0x9
    ABS_BRAKE = 0xA
    ABS_HAT0X = 0x10
    ABS_HAT0Y = 0x11
    ABS_HAT1X = 0x12
    ABS_HAT1Y = 0x13
    ABS_HAT2X = 0x14
    ABS_HAT2Y = 0x15
    ABS_HAT3X = 0x16
    ABS_HAT3Y = 0x17
    ABS_PRESSURE = 0x18
    ABS_DISTANCE = 0x19
    ABS_TILT_X = 0x1A
    ABS_TILT_Y = 0x1B
    ABS_TOOL_WIDTH = 0x1C
    ABS_VOLUME = 0x20
    ABS_MISC = 0x28
    ABS_MT_SLOT = 0x2F
    ABS_MT_TOUCH_MAJOR = 0x30
    ABS_MT_TOUCH_MINOR = 0x31
    ABS_MT_WIDTH_MAJOR = 0x32
    ABS_MT_WIDTH_MINOR = 0x33
    ABS_MT_ORIENTATION = 0x34
    ABS_MT_POSITION_X = 0x35
    ABS_MT_POSITION_Y = 0x36
    ABS_MT_TOOL_TYPE = 0x37
    ABS_MT_BLOB_ID = 0x38
    ABS_MT_TRACKING_ID = 0x39
    ABS_MT_PRESSURE = 0x3A
    ABS_MT_DISTANCE = 0x3B
    ABS_MT_TOOL_X = 0x3C
    ABS_MT_TOOL_Y = 0x3D
    ABS_MAX = 0x3F


class Switch(enum.IntEnum):
    SW_LID = 0x0
    SW_TABLET_MODE = 0x1
    SW_HEADPHONE_INSERT = 0x2
    SW_RFKILL_ALL = 0x3
    SW_RADIO = 0x3
    SW_MICROPHONE_INSERT = 0x4
    SW_DOCK = 0x5
    SW_LINEOUT_INSERT = 0x6
    SW_JACK_PHYSICAL_INSERT = 0x7
    SW_VIDEOOUT_INSERT = 0x8
    SW_CAMERA_LENS_COVER = 0x9
    SW_KEYPAD_SLIDE = 0xA
    SW_FRONT_PROXIMITY = 0xB
    SW_ROTATE_LOCK = 0xC
    SW_LINEIN_INSERT = 0xD
    SW_MUTE_DEVICE = 0xE
    SW_PEN_INSERTED = 0xF
    SW_MAX = 0xF


class Miscelaneous(enum.IntEnum):
    MSC_SERIAL = 0x0
    MSC_PULSELED = 0x1
    MSC_GESTURE = 0x2
    MSC_RAW = 0x3
    MSC_SCAN = 0x4
    MSC_TIMESTAMP = 0x5
    MSC_MAX = 0x7


class Led(enum.IntEnum):
    LED_NUML = 0x0
    LED_CAPSL = 0x1
    LED_SCROLLL = 0x2
    LED_COMPOSE = 0x3
    LED_KANA = 0x4
    LED_SLEEP = 0x5
    LED_SUSPEND = 0x6
    LED_MUTE = 0x7
    LED_MISC = 0x8
    LED_MAIL = 0x9
    LED_CHARGING = 0xA
    LED_MAX = 0xF


class AutoRepeat(enum.IntEnum):
    REP_DELAY = 0x0
    REP_PERIOD = 0x1
    REP_MAX = 0x1


class Sound(enum.IntEnum):
    SND_CLICK = 0x0
    SND_BELL = 0x1
    SND_TONE = 0x2
    SND_MAX = 0x7


EVENT_TYPE_MAP = {
    EventType.EV_SYN: Synchronization,
    EventType.EV_KEY: Key,
    EventType.EV_REL: Relative,
    EventType.EV_ABS: Absolute,
    EventType.EV_MSC: Miscelaneous,
    EventType.EV_SW: Switch,
    EventType.EV_LED: Led,
    EventType.EV_SND: Sound,
    EventType.EV_REP: AutoRepeat,
    EventType.EV_FF: ForceFeedback
}


class timeval(ctypes.Structure):
    _fields_ = [
        ('tv_sec', ctypes.c_int64),
        ('tv_usec', ctypes.c_int64)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class input_event(ctypes.Structure):
    _fields_ = [
        ('time', timeval),
        ('type', ctypes.c_uint16),
        ('code', ctypes.c_uint16),
        ('value', ctypes.c_int)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class input_id(ctypes.Structure):
    _fields_ = [
        ('bustype', ctypes.c_uint16),
        ('vendor', ctypes.c_uint16),
        ('product', ctypes.c_uint16),
        ('version', ctypes.c_uint16)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class input_absinfo(ctypes.Structure):
    _fields_ = [
        ('value', ctypes.c_int),
        ('minimum', ctypes.c_int),
        ('maximum', ctypes.c_int),
        ('fuzz', ctypes.c_int),
        ('flat', ctypes.c_int),
        ('resolution', ctypes.c_int)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class input_keymap_entry(ctypes.Structure):
    _fields_ = [
        ('flags', ctypes.c_uint8),
        ('len', ctypes.c_uint8),
        ('index', ctypes.c_uint16),
        ('keycode', ctypes.c_uint),
        ('scancode', ctypes.c_uint8)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class input_mask(ctypes.Structure):
    _fields_ = [
        ('type', ctypes.c_uint),
        ('codes_size', ctypes.c_uint),
        ('codes_ptr', ctypes.c_void_p)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class ff_replay(ctypes.Structure):
    _fields_ = [
        ('length', ctypes.c_uint16),
        ('delay', ctypes.c_uint16)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class ff_trigger(ctypes.Structure):
    _fields_ = [
        ('button', ctypes.c_uint16),
        ('interval', ctypes.c_uint16)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class ff_envelope(ctypes.Structure):
    _fields_ = [
        ('attack_length', ctypes.c_uint16),
        ('attack_level', ctypes.c_uint16),
        ('fade_length', ctypes.c_uint16),
        ('fade_level', ctypes.c_uint16)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class ff_constant_effect(ctypes.Structure):
    _fields_ = [
        ('level', ctypes.c_int16),
        ('envelope', ff_envelope)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class ff_ramp_effect(ctypes.Structure):
    _fields_ = [
        ('start_level', ctypes.c_int16),
        ('end_level', ctypes.c_int16),
        ('envelope', ff_envelope)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class ff_condition_effect(ctypes.Structure):
    _fields_ = [
        ('right_saturation', ctypes.c_uint16),
        ('left_saturation', ctypes.c_uint16),
        ('right_coeff', ctypes.c_int16),
        ('left_coeff', ctypes.c_int16),
        ('deadband', ctypes.c_uint16),
        ('center', ctypes.c_int16)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class ff_periodic_effect(ctypes.Structure):
    _fields_ = [
        ('waveform', ctypes.c_uint16),
        ('period', ctypes.c_uint16),
        ('magnitude', ctypes.c_int16),
        ('offset', ctypes.c_int16),
        ('phase', ctypes.c_uint16),
        ('envelope', ff_envelope),
        ('custom_len', ctypes.c_uint),
        ('custom_data', ctypes.POINTER(ctypes.c_int16))
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class ff_rumble_effect(ctypes.Structure):
    _fields_ = [
        ('strong_magnitude', ctypes.c_uint16),
        ('weak_magnitude', ctypes.c_uint16)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict


class ff_effect(ctypes.Structure):
    class U(ctypes.Union):
        _fields_ = [
            ('constant', ff_constant_effect),
            ('ramp', ff_ramp_effect),
            ('periodic', ff_periodic_effect),
            ('condition', ff_condition_effect),
            ('rumble', ff_rumble_effect)
        ]
        __iter__ = struct_iter
        __repr__ = struct_repr
        asdict = struct_asdict
    _fields_ = [
        ('type', ctypes.c_uint16),
        ('id', ctypes.c_int16),
        ('direction', ctypes.c_uint16),
        ('trigger', ff_trigger),
        ('replay', ff_replay),
        ('u', U)
    ]
    __iter__ = struct_iter
    __repr__ = struct_repr
    asdict = struct_asdict
