"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sameEnvDimension = sameEnvDimension;
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * Whether two string probably contain the same environment dimension (region or account)
 *
 * Used to compare either accounts or regions, and also returns true if both
 * are unresolved (in which case both are expted to be "current region" or "current account").
 */
function sameEnvDimension(dim1, dim2) {
    return [aws_cdk_lib_1.TokenComparison.SAME, aws_cdk_lib_1.TokenComparison.BOTH_UNRESOLVED].includes(aws_cdk_lib_1.Token.compareStrings(dim1, dim2));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFRQSw0Q0FFQztBQVZELDZDQUFxRDtBQUVyRDs7Ozs7R0FLRztBQUNILFNBQWdCLGdCQUFnQixDQUFDLElBQVksRUFBRSxJQUFZO0lBQ3pELE9BQU8sQ0FBQyw2QkFBZSxDQUFDLElBQUksRUFBRSw2QkFBZSxDQUFDLGVBQWUsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxtQkFBSyxDQUFDLGNBQWMsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQztBQUM1RyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVG9rZW4sIFRva2VuQ29tcGFyaXNvbiB9IGZyb20gJ2F3cy1jZGstbGliJztcblxuLyoqXG4gKiBXaGV0aGVyIHR3byBzdHJpbmcgcHJvYmFibHkgY29udGFpbiB0aGUgc2FtZSBlbnZpcm9ubWVudCBkaW1lbnNpb24gKHJlZ2lvbiBvciBhY2NvdW50KVxuICpcbiAqIFVzZWQgdG8gY29tcGFyZSBlaXRoZXIgYWNjb3VudHMgb3IgcmVnaW9ucywgYW5kIGFsc28gcmV0dXJucyB0cnVlIGlmIGJvdGhcbiAqIGFyZSB1bnJlc29sdmVkIChpbiB3aGljaCBjYXNlIGJvdGggYXJlIGV4cHRlZCB0byBiZSBcImN1cnJlbnQgcmVnaW9uXCIgb3IgXCJjdXJyZW50IGFjY291bnRcIikuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBzYW1lRW52RGltZW5zaW9uKGRpbTE6IHN0cmluZywgZGltMjogc3RyaW5nKSB7XG4gIHJldHVybiBbVG9rZW5Db21wYXJpc29uLlNBTUUsIFRva2VuQ29tcGFyaXNvbi5CT1RIX1VOUkVTT0xWRURdLmluY2x1ZGVzKFRva2VuLmNvbXBhcmVTdHJpbmdzKGRpbTEsIGRpbTIpKTtcbn1cbiJdfQ==