"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionsStartExecution = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const target_1 = require("./target");
/**
 * Use an AWS Step function as a target for AWS EventBridge Scheduler.
 */
class StepFunctionsStartExecution extends target_1.ScheduleTargetBase {
    constructor(stateMachine, props) {
        super(props, stateMachine.stateMachineArn);
        this.stateMachine = stateMachine;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StepFunctionsStartExecution);
            }
            throw error;
        }
    }
    addTargetActionToRole(role) {
        this.stateMachine.grantStartExecution(role);
    }
}
exports.StepFunctionsStartExecution = StepFunctionsStartExecution;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionsStartExecution[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.StepFunctionsStartExecution", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RlcGZ1bmN0aW9ucy1zdGFydC1leGVjdXRpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzdGVwZnVuY3Rpb25zLXN0YXJ0LWV4ZWN1dGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFHQSxxQ0FBdUU7QUFFdkU7O0dBRUc7QUFDSCxNQUFhLDJCQUE0QixTQUFRLDJCQUFrQjtJQUNqRSxZQUNtQixZQUEyQixFQUM1QyxLQUE4QjtRQUU5QixLQUFLLENBQUMsS0FBSyxFQUFFLFlBQVksQ0FBQyxlQUFlLENBQUMsQ0FBQztRQUgxQixpQkFBWSxHQUFaLFlBQVksQ0FBZTs7Ozs7OytDQUZuQywyQkFBMkI7Ozs7S0FNckM7SUFFUyxxQkFBcUIsQ0FBQyxJQUFXO1FBQ3pDLElBQUksQ0FBQyxZQUFZLENBQUMsbUJBQW1CLENBQUMsSUFBSSxDQUFDLENBQUM7S0FDN0M7O0FBVkgsa0VBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJU2NoZWR1bGVUYXJnZXQgfSBmcm9tICdAYXdzLWNkay9hd3Mtc2NoZWR1bGVyLWFscGhhJztcbmltcG9ydCB7IElSb2xlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgeyBJU3RhdGVNYWNoaW5lIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLXN0ZXBmdW5jdGlvbnMnO1xuaW1wb3J0IHsgU2NoZWR1bGVUYXJnZXRCYXNlLCBTY2hlZHVsZVRhcmdldEJhc2VQcm9wcyB9IGZyb20gJy4vdGFyZ2V0JztcblxuLyoqXG4gKiBVc2UgYW4gQVdTIFN0ZXAgZnVuY3Rpb24gYXMgYSB0YXJnZXQgZm9yIEFXUyBFdmVudEJyaWRnZSBTY2hlZHVsZXIuXG4gKi9cbmV4cG9ydCBjbGFzcyBTdGVwRnVuY3Rpb25zU3RhcnRFeGVjdXRpb24gZXh0ZW5kcyBTY2hlZHVsZVRhcmdldEJhc2UgaW1wbGVtZW50cyBJU2NoZWR1bGVUYXJnZXQge1xuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIHJlYWRvbmx5IHN0YXRlTWFjaGluZTogSVN0YXRlTWFjaGluZSxcbiAgICBwcm9wczogU2NoZWR1bGVUYXJnZXRCYXNlUHJvcHMsXG4gICkge1xuICAgIHN1cGVyKHByb3BzLCBzdGF0ZU1hY2hpbmUuc3RhdGVNYWNoaW5lQXJuKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBhZGRUYXJnZXRBY3Rpb25Ub1JvbGUocm9sZTogSVJvbGUpOiB2b2lkIHtcbiAgICB0aGlzLnN0YXRlTWFjaGluZS5ncmFudFN0YXJ0RXhlY3V0aW9uKHJvbGUpO1xuICB9XG59XG4iXX0=