"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsSendMessage = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const target_1 = require("./target");
/**
 * Use an Amazon SQS Queue as a target for AWS EventBridge Scheduler.
 */
class SqsSendMessage extends target_1.ScheduleTargetBase {
    constructor(queue, props = {}) {
        super(props, queue.queueArn);
        this.queue = queue;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_SqsSendMessageProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SqsSendMessage);
            }
            throw error;
        }
        if (props.messageGroupId !== undefined) {
            if (!aws_cdk_lib_1.Token.isUnresolved(props.messageGroupId) && (props.messageGroupId.length < 1 || props.messageGroupId.length > 128)) {
                throw new Error(`messageGroupId length must be between 1 and 128, got ${props.messageGroupId.length}`);
            }
            if (!queue.fifo) {
                throw new Error('target must be a FIFO queue if messageGroupId is specified');
            }
            if (!queue.node.defaultChild.contentBasedDeduplication) {
                throw new Error('contentBasedDeduplication must be true if the target is a FIFO queue');
            }
        }
        else if (queue.fifo) {
            throw new Error('messageGroupId must be specified if the target is a FIFO queue');
        }
    }
    addTargetActionToRole(role) {
        this.queue.grant(role, 'sqs:SendMessage');
        this.queue.encryptionMasterKey?.grant(role, 'kms:Decrypt', 'kms:GenerateDataKey*');
    }
    bindBaseTargetConfig(_schedule) {
        return {
            ...super.bindBaseTargetConfig(_schedule),
            sqsParameters: {
                messageGroupId: this.props.messageGroupId,
            },
        };
    }
}
exports.SqsSendMessage = SqsSendMessage;
_a = JSII_RTTI_SYMBOL_1;
SqsSendMessage[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.SqsSendMessage", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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