"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsPublish = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const target_1 = require("./target");
/**
 * Use an Amazon SNS topic as a target for AWS EventBridge Scheduler.
 */
class SnsPublish extends target_1.ScheduleTargetBase {
    constructor(topic, props = {}) {
        super(props, topic.topicArn);
        this.topic = topic;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SnsPublish);
            }
            throw error;
        }
    }
    addTargetActionToRole(role) {
        this.topic.grantPublish(role);
    }
}
exports.SnsPublish = SnsPublish;
_a = JSII_RTTI_SYMBOL_1;
SnsPublish[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.SnsPublish", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic25zLXB1Ymxpc2guanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzbnMtcHVibGlzaC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFHQSxxQ0FBdUU7QUFFdkU7O0dBRUc7QUFDSCxNQUFhLFVBQVcsU0FBUSwyQkFBa0I7SUFDaEQsWUFDbUIsS0FBaUIsRUFDbEMsUUFBaUMsRUFBRTtRQUVuQyxLQUFLLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUhaLFVBQUssR0FBTCxLQUFLLENBQVk7Ozs7OzsrQ0FGekIsVUFBVTs7OztLQU1wQjtJQUVTLHFCQUFxQixDQUFDLElBQVc7UUFDekMsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUM7S0FDL0I7O0FBVkgsZ0NBV0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJU2NoZWR1bGVUYXJnZXQgfSBmcm9tICdAYXdzLWNkay9hd3Mtc2NoZWR1bGVyLWFscGhhJztcbmltcG9ydCB7IElSb2xlIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBzbnMgZnJvbSAnYXdzLWNkay1saWIvYXdzLXNucyc7XG5pbXBvcnQgeyBTY2hlZHVsZVRhcmdldEJhc2UsIFNjaGVkdWxlVGFyZ2V0QmFzZVByb3BzIH0gZnJvbSAnLi90YXJnZXQnO1xuXG4vKipcbiAqIFVzZSBhbiBBbWF6b24gU05TIHRvcGljIGFzIGEgdGFyZ2V0IGZvciBBV1MgRXZlbnRCcmlkZ2UgU2NoZWR1bGVyLlxuICovXG5leHBvcnQgY2xhc3MgU25zUHVibGlzaCBleHRlbmRzIFNjaGVkdWxlVGFyZ2V0QmFzZSBpbXBsZW1lbnRzIElTY2hlZHVsZVRhcmdldCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHByaXZhdGUgcmVhZG9ubHkgdG9waWM6IHNucy5JVG9waWMsXG4gICAgcHJvcHM6IFNjaGVkdWxlVGFyZ2V0QmFzZVByb3BzID0ge30sXG4gICkge1xuICAgIHN1cGVyKHByb3BzLCB0b3BpYy50b3BpY0Fybik7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWRkVGFyZ2V0QWN0aW9uVG9Sb2xlKHJvbGU6IElSb2xlKTogdm9pZCB7XG4gICAgdGhpcy50b3BpYy5ncmFudFB1Ymxpc2gocm9sZSk7XG4gIH1cbn1cbiJdfQ==