"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SageMakerStartPipelineExecution = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const target_1 = require("./target");
/**
 * Use a SageMaker pipeline as a target for AWS EventBridge Scheduler.
 */
class SageMakerStartPipelineExecution extends target_1.ScheduleTargetBase {
    constructor(pipeline, props = {}) {
        super(props, pipeline.pipelineArn);
        this.pipeline = pipeline;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_SageMakerStartPipelineExecutionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SageMakerStartPipelineExecution);
            }
            throw error;
        }
        if (props.pipelineParameterList !== undefined && props.pipelineParameterList.length > 200) {
            throw new Error(`pipelineParameterList length must be between 0 and 200, got ${props.pipelineParameterList.length}`);
        }
    }
    addTargetActionToRole(role) {
        this.pipeline.grantStartPipelineExecution(role);
    }
    bindBaseTargetConfig(schedule) {
        const sageMakerPipelineParameters = this.props.pipelineParameterList ? {
            pipelineParameterList: this.props.pipelineParameterList.map(param => {
                return {
                    name: param.name,
                    value: param.value,
                };
            }),
        } : undefined;
        return {
            ...super.bindBaseTargetConfig(schedule),
            sageMakerPipelineParameters,
        };
    }
}
exports.SageMakerStartPipelineExecution = SageMakerStartPipelineExecution;
_a = JSII_RTTI_SYMBOL_1;
SageMakerStartPipelineExecution[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.SageMakerStartPipelineExecution", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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