import { ISchedule, IScheduleTarget, ScheduleTargetConfig } from '@aws-cdk/aws-scheduler-alpha';
import { IRole } from 'aws-cdk-lib/aws-iam';
import { IPipeline } from 'aws-cdk-lib/aws-sagemaker';
import { ScheduleTargetBase, ScheduleTargetBaseProps } from './target';
/**
 * Properties for a pipeline parameter
 */
export interface SageMakerPipelineParameter {
    /**
     * Name of parameter to start execution of a SageMaker Model Building Pipeline.
     */
    readonly name: string;
    /**
     * Value of parameter to start execution of a SageMaker Model Building Pipeline.
     */
    readonly value: string;
}
/**
 * Properties for a SageMaker Target
 */
export interface SageMakerStartPipelineExecutionProps extends ScheduleTargetBaseProps {
    /**
     * List of parameter names and values to use when executing the SageMaker Model Building Pipeline.
     *
     * The length must be between 0 and 200.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-scheduler-schedule-sagemakerpipelineparameters.html#cfn-scheduler-schedule-sagemakerpipelineparameters-pipelineparameterlist
     *
     * @default - no pipeline parameter list
     */
    readonly pipelineParameterList?: SageMakerPipelineParameter[];
}
/**
 * Use a SageMaker pipeline as a target for AWS EventBridge Scheduler.
 */
export declare class SageMakerStartPipelineExecution extends ScheduleTargetBase implements IScheduleTarget {
    private readonly pipeline;
    private readonly props;
    constructor(pipeline: IPipeline, props?: SageMakerStartPipelineExecutionProps);
    protected addTargetActionToRole(role: IRole): void;
    protected bindBaseTargetConfig(schedule: ISchedule): ScheduleTargetConfig;
}
