"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInvoke = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const target_1 = require("./target");
/**
 * Use an AWS Lambda function as a target for AWS EventBridge Scheduler.
 */
class LambdaInvoke extends target_1.ScheduleTargetBase {
    constructor(func, props = {}) {
        super(props, func.functionArn);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_scheduler_targets_alpha_ScheduleTargetBaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaInvoke);
            }
            throw error;
        }
        this.func = func;
    }
    addTargetActionToRole(role) {
        this.func.grantInvoke(role);
    }
}
exports.LambdaInvoke = LambdaInvoke;
_a = JSII_RTTI_SYMBOL_1;
LambdaInvoke[_a] = { fqn: "@aws-cdk/aws-scheduler-targets-alpha.LambdaInvoke", version: "2.173.4-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWludm9rZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImxhbWJkYS1pbnZva2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBR0EscUNBQXVFO0FBRXZFOztHQUVHO0FBQ0gsTUFBYSxZQUFhLFNBQVEsMkJBQWtCO0lBR2xELFlBQ0UsSUFBc0IsRUFDdEIsUUFBaUMsRUFBRTtRQUVuQyxLQUFLLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQzs7Ozs7OytDQVB0QixZQUFZOzs7O1FBUXJCLElBQUksQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO0tBQ2xCO0lBRVMscUJBQXFCLENBQUMsSUFBVztRQUN6QyxJQUFJLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztLQUM3Qjs7QUFiSCxvQ0FjQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElTY2hlZHVsZVRhcmdldCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1zY2hlZHVsZXItYWxwaGEnO1xuaW1wb3J0IHsgSVJvbGUgfSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtaWFtJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdhd3MtY2RrLWxpYi9hd3MtbGFtYmRhJztcbmltcG9ydCB7IFNjaGVkdWxlVGFyZ2V0QmFzZSwgU2NoZWR1bGVUYXJnZXRCYXNlUHJvcHMgfSBmcm9tICcuL3RhcmdldCc7XG5cbi8qKlxuICogVXNlIGFuIEFXUyBMYW1iZGEgZnVuY3Rpb24gYXMgYSB0YXJnZXQgZm9yIEFXUyBFdmVudEJyaWRnZSBTY2hlZHVsZXIuXG4gKi9cbmV4cG9ydCBjbGFzcyBMYW1iZGFJbnZva2UgZXh0ZW5kcyBTY2hlZHVsZVRhcmdldEJhc2UgaW1wbGVtZW50cyBJU2NoZWR1bGVUYXJnZXQge1xuICBwcml2YXRlIHJlYWRvbmx5IGZ1bmM6IGxhbWJkYS5JRnVuY3Rpb247XG5cbiAgY29uc3RydWN0b3IoXG4gICAgZnVuYzogbGFtYmRhLklGdW5jdGlvbixcbiAgICBwcm9wczogU2NoZWR1bGVUYXJnZXRCYXNlUHJvcHMgPSB7fSxcbiAgKSB7XG4gICAgc3VwZXIocHJvcHMsIGZ1bmMuZnVuY3Rpb25Bcm4pO1xuICAgIHRoaXMuZnVuYyA9IGZ1bmM7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWRkVGFyZ2V0QWN0aW9uVG9Sb2xlKHJvbGU6IElSb2xlKTogdm9pZCB7XG4gICAgdGhpcy5mdW5jLmdyYW50SW52b2tlKHJvbGUpO1xuICB9XG59XG4iXX0=